/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.ui.tool;

import io.keikai.doc.api.editor.Commands;
import io.keikai.doc.api.editor.Editor;
import io.keikai.doc.api.editor.SelectionView;
import io.keikai.doc.api.impl.node.style.Color;
import io.keikai.doc.api.impl.node.style.TextStyle;
import io.keikai.doc.ui.Docpad;
import io.keikai.doc.ui.tool.ToolInserter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zkex.zul.Colorbox;
import org.zkoss.zul.Toolbar;

public class FontBackgroundColorInserter
implements ToolInserter {
    @Override
    public void insertTool(Docpad docpad, Toolbar toolbar) {
        Editor editor = Editor.getInstance(docpad);
        Colorbox colorbox = new Colorbox();
        colorbox.setTooltiptext("Font Background Color");
        colorbox.addEventListener("onChange", e -> {
            Color color = Color.decode(colorbox.getColor());
            editor.execute(Commands.findSelection().textStyle(style -> style.withBackgroundColor(color)));
        });
        docpad.addEventListener("onDocpadChange", e -> {
            if (!toolbar.getParent().isVisible()) {
                return;
            }
            SelectionView sv = editor.getSelection();
            if (sv == null) {
                return;
            }
            boolean allMatched = sv.allTextStylesMatched(TextStyle::getBackgroundColor);
            Color color = sv.getStartTextNodeStyle(TextStyle::getBackgroundColor);
            String c = allMatched && color != null ? Color.toHexString(color) : "#FFFFFF";
            colorbox.setColor(c);
        });
        toolbar.appendChild((Component)colorbox);
    }
}

