/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.ui.tool;

import io.keikai.doc.ui.tool.AlignInserter;
import io.keikai.doc.ui.tool.ExporterInserter;
import io.keikai.doc.ui.tool.FontBackgroundColorInserter;
import io.keikai.doc.ui.tool.FontBoldInserter;
import io.keikai.doc.ui.tool.FontColorInserter;
import io.keikai.doc.ui.tool.FontFamilyInserter;
import io.keikai.doc.ui.tool.FontItalicInserter;
import io.keikai.doc.ui.tool.FontSizeInserter;
import io.keikai.doc.ui.tool.FontStrikethroughInserter;
import io.keikai.doc.ui.tool.FontSubscriptInserter;
import io.keikai.doc.ui.tool.FontSuperscriptInserter;
import io.keikai.doc.ui.tool.FontUnderlineInserter;
import io.keikai.doc.ui.tool.ImporterInserter;
import io.keikai.doc.ui.tool.ParagraphDecreaseIndentInserter;
import io.keikai.doc.ui.tool.ParagraphIncreaseIndentInserter;
import io.keikai.doc.ui.tool.ParagraphSpacingInserter;
import io.keikai.doc.ui.tool.ParagraphTypeInserter;
import io.keikai.doc.ui.tool.RedoInserter;
import io.keikai.doc.ui.tool.SeparatorInserter;
import io.keikai.doc.ui.tool.Tool;
import io.keikai.doc.ui.tool.ToolInserter;
import io.keikai.doc.ui.tool.ToolManager;
import io.keikai.doc.ui.tool.UndoInserter;
import java.util.HashMap;
import java.util.Map;

public class DefaultToolManager
implements ToolManager {
    protected final Map<String, ToolInserter> _adderMap = new HashMap<String, ToolInserter>();

    public DefaultToolManager() {
        this.initDefaultAdders();
    }

    protected void initDefaultAdders() {
        this.registerInserter(Tool.SEPARATOR, (ToolInserter)new SeparatorInserter());
        this.registerInserter(Tool.UNDO, (ToolInserter)new UndoInserter());
        this.registerInserter(Tool.REDO, (ToolInserter)new RedoInserter());
        this.registerInserter(Tool.PARAGRAPH_TYPE, (ToolInserter)new ParagraphTypeInserter());
        this.registerInserter(Tool.FONT_FAMILY, (ToolInserter)new FontFamilyInserter());
        this.registerInserter(Tool.FONT_SIZE, (ToolInserter)new FontSizeInserter());
        this.registerInserter(Tool.FONT_BOLD, (ToolInserter)new FontBoldInserter());
        this.registerInserter(Tool.FONT_ITALIC, (ToolInserter)new FontItalicInserter());
        this.registerInserter(Tool.FONT_UNDERLINE, (ToolInserter)new FontUnderlineInserter());
        this.registerInserter(Tool.FONT_STRIKETHROUGH, (ToolInserter)new FontStrikethroughInserter());
        this.registerInserter(Tool.FONT_SUPERSCRIPT, (ToolInserter)new FontSuperscriptInserter());
        this.registerInserter(Tool.FONT_SUBSCRIPT, (ToolInserter)new FontSubscriptInserter());
        this.registerInserter(Tool.FONT_COLOR, (ToolInserter)new FontColorInserter());
        this.registerInserter(Tool.FONT_BACKGROUND_COLOR, (ToolInserter)new FontBackgroundColorInserter());
        this.registerInserter(Tool.ALIGN, (ToolInserter)new AlignInserter());
        this.registerInserter(Tool.PARAGRAPH_SPACING, (ToolInserter)new ParagraphSpacingInserter());
        this.registerInserter(Tool.PARAGRAPH_DECREASE_INDENT, (ToolInserter)new ParagraphDecreaseIndentInserter());
        this.registerInserter(Tool.PARAGRAPH_INCREASE_INDENT, (ToolInserter)new ParagraphIncreaseIndentInserter());
        this.registerInserter(Tool.IMPORTER, (ToolInserter)new ImporterInserter());
        this.registerInserter(Tool.EXPORTER, (ToolInserter)new ExporterInserter());
    }

    @Override
    public void registerInserter(String tool, ToolInserter toolInserter) {
        this._adderMap.put(tool, toolInserter);
    }

    @Override
    public void registerInserter(Tool tool, ToolInserter toolInserter) {
        this.registerInserter(tool.toString(), toolInserter);
    }

    @Override
    public ToolInserter getInserter(String tool) {
        return this._adderMap.get(tool);
    }
}

