/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.ui;

import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.DocumentModelListener;
import io.keikai.doc.api.DocumentOperation;
import io.keikai.doc.api.DocumentOperationBatch;
import io.keikai.doc.api.editor.Editor;
import io.keikai.doc.api.editor.SelectionView;
import io.keikai.doc.api.impl.model.DefaultDocumentModel;
import io.keikai.doc.api.impl.node.ComponentNode;
import io.keikai.doc.api.impl.node.DocumentNodeLazyIterator;
import io.keikai.doc.api.impl.operation.AbstractDocumentOperation;
import io.keikai.doc.api.impl.operation.AddChildOperation;
import io.keikai.doc.api.impl.operation.DefaultDocumentOperationFactory;
import io.keikai.doc.api.impl.operation.RemoveChildOperation;
import io.keikai.doc.api.impl.util.ObjectMapperUtil;
import io.keikai.doc.ui.Ghost;
import io.keikai.doc.ui.event.DocpadChangeEvent;
import io.keikai.doc.ui.tool.DefaultToolManager;
import io.keikai.doc.ui.tool.Tool;
import io.keikai.doc.ui.tool.ToolInserter;
import io.keikai.doc.ui.tool.ToolManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Div;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.impl.XulElement;

public class Docpad
extends XulElement {
    private static final Logger log = LoggerFactory.getLogger(Docpad.class);
    public static final List<String> DEFAULT_TOOLS = Stream.of(Tool.UNDO, Tool.REDO, Tool.SEPARATOR, Tool.PARAGRAPH_TYPE, Tool.SEPARATOR, Tool.FONT_FAMILY, Tool.SEPARATOR, Tool.FONT_SIZE, Tool.SEPARATOR, Tool.FONT_BOLD, Tool.FONT_ITALIC, Tool.FONT_UNDERLINE, Tool.FONT_STRIKETHROUGH, Tool.FONT_SUPERSCRIPT, Tool.FONT_SUBSCRIPT, Tool.FONT_COLOR, Tool.FONT_BACKGROUND_COLOR, Tool.SEPARATOR, Tool.ALIGN, Tool.PARAGRAPH_SPACING, Tool.PARAGRAPH_DECREASE_INDENT, Tool.PARAGRAPH_INCREASE_INDENT, Tool.SEPARATOR, Tool.IMPORTER, Tool.EXPORTER).map(Tool::toString).collect(Collectors.toUnmodifiableList());
    public static final List<String> DEFAULT_POPUP_TOOLS = Stream.of(Tool.FONT_FAMILY, Tool.FONT_SIZE, Tool.FONT_BOLD, Tool.FONT_ITALIC, Tool.FONT_UNDERLINE, Tool.FONT_STRIKETHROUGH, Tool.FONT_COLOR, Tool.FONT_BACKGROUND_COLOR).map(Tool::toString).collect(Collectors.toUnmodifiableList());
    private transient DocumentModel _model;
    private transient DocumentModelListener _listener;
    private final Ghost _ghost = new Ghost();
    private ToolManager _toolManager;
    private final MainToolbarContainer _mainToolbarContainer = new MainToolbarContainer();
    private final EditorContainer _editorContainer = new EditorContainer();
    private final PopupToolbarContainer _popupToolbarContainer = new PopupToolbarContainer();
    private boolean _showPopupToolbar;
    private final EventListener<Event> _popupToolbarListener = e -> {
        SelectionView sv = Editor.getInstance(this).getSelection();
        if (sv != null && sv.isRange() && !this._popupToolbarContainer.isVisible()) {
            this._popupToolbarContainer.open((Component)this, "at_pointer");
        }
    };

    public Docpad() {
        this._toolManager = this.getToolManager();
        this.appendChild((Component)this._mainToolbarContainer);
        this._mainToolbarContainer.appendChild((Component)this.createToolbar(DEFAULT_TOOLS));
        this._mainToolbarContainer.setVisible(false);
        this.appendChild((Component)this._editorContainer);
        this.appendChild((Component)this._popupToolbarContainer);
        this._popupToolbarContainer.appendChild((Component)this.createToolbar(DEFAULT_POPUP_TOOLS));
        this.appendChild((Component)this._ghost);
        this.setModel(new DefaultDocumentModel());
    }

    public String getZclass() {
        return this._zclass == null ? "z-docpad" : this._zclass;
    }

    public DocumentModel getModel() {
        return this._model;
    }

    public void setModel(DocumentModel model) {
        if (model == null) {
            throw new UiException("Cannot set the document model to null.");
        }
        if (this._model != model) {
            if (this._model != null) {
                this._model.removeListener(this._listener);
            }
            this._model = model;
            new DocumentNodeLazyIterator(this._model.getRoot()).stream().filter(ComponentNode.class::isInstance).map(ComponentNode.class::cast).map(ComponentNode::getContainer).forEach(arg_0 -> ((Ghost)this._ghost).appendChild(arg_0));
            this._listener = new DocumentModelListener(){
                private List<JSONObject> _jsonObjects = new ArrayList<JSONObject>();

                @Override
                public void onBatchChange(DocumentOperationBatch batch) {
                    if (!batch.isFromClient()) {
                        Docpad.this.smartUpdate("apply", new ArrayList<JSONObject>(this._jsonObjects), true);
                    }
                    Events.postEvent((Event)new DocpadChangeEvent("onDocpadChange", Docpad.this, batch));
                    this._jsonObjects.clear();
                }

                @Override
                public void onOperationChange(DocumentOperation operation) {
                    if (operation instanceof AddChildOperation) {
                        new DocumentNodeLazyIterator(((AddChildOperation)operation).getNode()).stream().filter(ComponentNode.class::isInstance).map(ComponentNode.class::cast).map(ComponentNode::getContainer).forEach(arg_0 -> ((Ghost)Docpad.this._ghost).appendChild(arg_0));
                    } else if (operation instanceof RemoveChildOperation) {
                        new DocumentNodeLazyIterator(((RemoveChildOperation)operation).getNode()).stream().filter(ComponentNode.class::isInstance).map(ComponentNode.class::cast).map(ComponentNode::getContainer).forEach(arg_0 -> ((Ghost)Docpad.this._ghost).removeChild(arg_0));
                    }
                    this._jsonObjects.add(ObjectMapperUtil.toJSON(operation));
                }
            };
            this._model.addListener(this._listener);
            this.smartUpdate("value", this.getValue());
        }
    }

    public ToolManager getToolManager() {
        if (this._toolManager == null) {
            String clznm = Library.getProperty((String)"io.keikai.document.toolbar.ToolManager.class");
            if (clznm != null) {
                try {
                    Class clz = Classes.forNameByThread((String)clznm);
                    this._toolManager = (ToolManager)clz.newInstance();
                }
                catch (Exception e) {
                    throw UiException.Aide.wrap((Throwable)e, (String)"Can't initialize ToolManager");
                }
            } else {
                this._toolManager = new DefaultToolManager();
            }
        }
        return this._toolManager;
    }

    private Toolbar createToolbar(List<String> tools) {
        Toolbar toolbar = new Toolbar();
        for (String tool : tools) {
            ToolInserter inserter = this._toolManager.getInserter(tool);
            if (inserter == null) {
                log.warn("No ToolInserter found for {}, please register it in ToolManager first.", (Object)tool);
                continue;
            }
            inserter.insertTool(this, toolbar);
        }
        return toolbar;
    }

    public Div getMainToolbarContainer() {
        return this._mainToolbarContainer;
    }

    public void setShowMainToolbar(boolean showMainToolbar) {
        this._mainToolbarContainer.setVisible(showMainToolbar);
        this.smartUpdate("showMainToolbar", showMainToolbar);
    }

    public boolean isShowMainToolbar() {
        return this._mainToolbarContainer.isVisible();
    }

    public Popup getPopupToolbarContainer() {
        return this._popupToolbarContainer;
    }

    public void setShowPopupToolbar(boolean showPopupToolbar) {
        if (this._showPopupToolbar != showPopupToolbar) {
            this._showPopupToolbar = showPopupToolbar;
            if (showPopupToolbar) {
                this.addEventListener("onEditorMouseUp", this._popupToolbarListener);
            } else {
                this.removeEventListener("onEditorMouseUp", this._popupToolbarListener);
            }
        }
    }

    public boolean isShowPopupToolbar() {
        return this._showPopupToolbar;
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (newChild instanceof MainToolbarContainer) {
            if (this._mainToolbarContainer != newChild) {
                throw new UiException("Only one main toolbar container is allowed: " + this);
            }
        } else if (newChild instanceof EditorContainer) {
            if (this._editorContainer != newChild) {
                throw new UiException("Only one editor container is allowed: " + this);
            }
        } else if (newChild instanceof PopupToolbarContainer) {
            if (this._popupToolbarContainer != newChild) {
                throw new UiException("Only one popup toolbar container is allowed: " + this);
            }
        } else if (newChild instanceof Ghost) {
            if (this._ghost != newChild) {
                throw new UiException("Only one ghost is allowed: " + this);
            }
        } else {
            throw new UiException("Unsupported child for Docpad: " + newChild);
        }
        super.beforeChildAdded(newChild, refChild);
    }

    public boolean removeChild(Component child) {
        throw new UiException("Children of Docpad cannot be removed since the child's configuration is preset and cannot be changed.");
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "value", this.getValue());
        this.render(renderer, "showMainToolbar", this.isShowMainToolbar());
    }

    private JSONObject getValue() {
        return ObjectMapperUtil.toJSON(this._model.getRoot());
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        Map data = request.getData();
        if ("onChanging".equals(cmd)) {
            this._model.runBatch(true, () -> {
                for (Object o : (JSONArray)data.get("operations")) {
                    JSONObject jsonObject = (JSONObject)o;
                    AbstractDocumentOperation operation = DefaultDocumentOperationFactory.create(jsonObject);
                    if (operation instanceof RemoveChildOperation) {
                        operation = new RemoveChildOperation(operation.getPath(), this._model.getNode(operation.getPath()));
                    }
                    if (operation == null) continue;
                    operation.apply(this._model);
                }
            });
        } else {
            super.service(request, everError);
        }
    }

    static {
        Docpad.addClientEvent(Docpad.class, (String)"onChanging", (int)3);
        Docpad.addClientEvent(Docpad.class, (String)"onEditorMouseUp", (int)3);
    }

    private static class PopupToolbarContainer
    extends Popup {
        private PopupToolbarContainer() {
        }
    }

    private static class EditorContainer
    extends Div {
        public EditorContainer() {
            this.setSclass("z-docpad-cave");
        }
    }

    private static class MainToolbarContainer
    extends Div {
        private MainToolbarContainer() {
        }
    }
}

