/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.zkoss.json.JSONObject;

public class ObjectMapperUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().findAndRegisterModules();

    protected ObjectMapperUtil() {
    }

    public static JSONObject toJSON(Object object) {
        return (JSONObject)OBJECT_MAPPER.convertValue(object, JSONObject.class);
    }

    public static <T> T fromJSON(Map<?, ?> json, Class<T> clazz) {
        return (T)OBJECT_MAPPER.convertValue(json, clazz);
    }

    public static JSONObject readJSON(String json) {
        try {
            return (JSONObject)OBJECT_MAPPER.readValue(json, JSONObject.class);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static JSONObject readJSON(InputStream is) {
        try {
            return (JSONObject)OBJECT_MAPPER.readValue(is, JSONObject.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static JSONObject readJSON(File file) {
        try {
            return (JSONObject)OBJECT_MAPPER.readValue(file, JSONObject.class);
        }
        catch (IOException e) {
            return null;
        }
    }
}

