/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.operation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.DocumentNode;
import io.keikai.doc.api.DocumentSelectableModel;
import io.keikai.doc.api.Path;
import io.keikai.doc.api.Point;
import io.keikai.doc.api.impl.node.DefaultDocumentRange;
import io.keikai.doc.api.impl.node.TextNode;
import io.keikai.doc.api.impl.operation.AbstractDocumentOperation;
import java.util.Map;

public class SetSelectionOperation
extends AbstractDocumentOperation {
    static final String TYPE = "SET_SELECTION";
    private final Point _anchor;
    private final Point _focus;

    public SetSelectionOperation() {
        super(TYPE, null);
        this._anchor = null;
        this._focus = null;
    }

    public SetSelectionOperation(Path anchorPath, int anchorOffset, Path focusPath, int focusOffset) {
        super(TYPE, null);
        this._anchor = Point.of(anchorPath, anchorOffset);
        this._focus = Point.of(focusPath, focusOffset);
    }

    @JsonCreator
    private SetSelectionOperation(@JsonProperty(value="anchor") Point anchor, @JsonProperty(value="focus") Point focus) {
        super(TYPE, null);
        this._anchor = anchor;
        this._focus = focus;
    }

    @JsonIgnore
    public Point getAnchor() {
        return this._anchor;
    }

    @JsonIgnore
    public Point getFocus() {
        return this._focus;
    }

    @JsonProperty(value="properties")
    private Map<Object, Object> getProperties() {
        return null;
    }

    @JsonProperty(value="newProperties")
    private Map<Object, Object> getNewProperties() {
        return this._anchor == null || this._focus == null ? null : Map.of("anchor", this._anchor, "focus", this._focus);
    }

    @Override
    public void apply(DocumentModel model) {
        if (model instanceof DocumentSelectableModel) {
            DocumentSelectableModel selectableModel = (DocumentSelectableModel)((Object)model);
            if (this._anchor == null || this._focus == null) {
                selectableModel.setSelection(null);
                return;
            }
            DocumentNode<?, ?, ?> startNode = model.getNode(this._anchor.getPath());
            DocumentNode<?, ?, ?> endNode = model.getNode(this._focus.getPath());
            if (startNode instanceof TextNode && endNode instanceof TextNode) {
                selectableModel.setSelection(new DefaultDocumentRange((TextNode)startNode, this._anchor.getOffset(), (TextNode)endNode, this._focus.getOffset()));
            }
        }
    }

    @Override
    public AbstractDocumentOperation reverse() {
        return null;
    }
}

