/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.operation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.DocumentNode;
import io.keikai.doc.api.Path;
import io.keikai.doc.api.impl.node.AbstractDocumentNode;
import io.keikai.doc.api.impl.node.style.AbstractDocumentNodeStyle;
import io.keikai.doc.api.impl.node.style.DefaultDocumentNodeStyleFactory;
import io.keikai.doc.api.impl.operation.AbstractDocumentOperation;
import io.keikai.doc.api.impl.util.ObjectMapperUtil;
import java.util.Map;
import org.zkoss.json.JSONObject;

public class SetNodeOperation
extends AbstractDocumentOperation {
    static final String TYPE = "SET_NODE";
    private final DocumentNode<?, ?, ?> _node;
    private final Map<Object, Object> _properties;
    private final Map<Object, Object> _newProperties;

    @JsonCreator
    private SetNodeOperation(@JsonProperty(value="path") Path path, @JsonProperty(value="properties") Map<Object, Object> properties, @JsonProperty(value="newProperties") Map<Object, Object> newProperties) {
        this(path, null, properties, newProperties);
    }

    public SetNodeOperation(Path path, DocumentNode<?, ?, ?> node, Map<Object, Object> properties, Map<Object, Object> newProperties) {
        super(TYPE, path);
        this._node = node;
        this._properties = properties;
        this._newProperties = newProperties;
    }

    public DocumentNode<?, ?, ?> getNode() {
        return this._node;
    }

    public Map<Object, Object> getProperties() {
        return this._properties;
    }

    public Map<Object, Object> getNewProperties() {
        return this._newProperties;
    }

    @Override
    public void apply(DocumentModel model) {
        Object attributes;
        DocumentNode<?, ?, ?> node = model.getNode(this.getPath());
        JSONObject allProperties = ObjectMapperUtil.toJSON(node.getStyle());
        allProperties.keySet().removeAll(this._properties.keySet());
        allProperties.putAll(this._newProperties);
        AbstractDocumentNodeStyle newStyle = DefaultDocumentNodeStyleFactory.create(allProperties, node.getClass());
        if (newStyle != null) {
            node.setStyle(newStyle);
        }
        if ((attributes = this._newProperties.get("attributes")) instanceof Map && node instanceof AbstractDocumentNode) {
            ((AbstractDocumentNode)node).setAttributes((Map)attributes);
        }
    }

    @Override
    public AbstractDocumentOperation reverse() {
        return new SetNodeOperation(this.getPath(), this._newProperties, this._properties);
    }
}

