/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.operation;

import io.keikai.doc.api.impl.operation.AbstractDocumentOperation;
import io.keikai.doc.api.impl.operation.AddChildOperation;
import io.keikai.doc.api.impl.operation.AddTextOperation;
import io.keikai.doc.api.impl.operation.MergeChildOperation;
import io.keikai.doc.api.impl.operation.MoveNodeOperation;
import io.keikai.doc.api.impl.operation.RemoveChildOperation;
import io.keikai.doc.api.impl.operation.RemoveTextOperation;
import io.keikai.doc.api.impl.operation.SetNodeOperation;
import io.keikai.doc.api.impl.operation.SetSelectionOperation;
import io.keikai.doc.api.impl.operation.SplitChildOperation;
import io.keikai.doc.api.impl.util.ObjectMapperUtil;
import java.util.Map;

public class DefaultDocumentOperationFactory {
    private static final Map<String, Class<? extends AbstractDocumentOperation>> TYPE_TO_OPERATION_MAP = Map.of("SET_SELECTION", SetSelectionOperation.class, "INSERT_NODE", AddChildOperation.class, "REMOVE_NODE", RemoveChildOperation.class, "MOVE_NODE", MoveNodeOperation.class, "SPLIT_NODE", SplitChildOperation.class, "MERGE_NODE", MergeChildOperation.class, "SET_NODE", SetNodeOperation.class, "INSERT_TEXT", AddTextOperation.class, "REMOVE_TEXT", RemoveTextOperation.class);

    private DefaultDocumentOperationFactory() {
    }

    public static AbstractDocumentOperation create(Map<?, ?> map) {
        String type = ((String)map.get("type")).toUpperCase();
        if ("SET_SELECTION".equals(type)) {
            Map newProperties = (Map)map.get("newProperties");
            if (newProperties.get("anchor") == null || newProperties.get("focus") == null) {
                return null;
            }
            return ObjectMapperUtil.fromJSON(newProperties, SetSelectionOperation.class);
        }
        return ObjectMapperUtil.fromJSON(map, TYPE_TO_OPERATION_MAP.get(type));
    }
}

