/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.operation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.DocumentNode;
import io.keikai.doc.api.Path;
import io.keikai.doc.api.impl.node.DefaultDocumentNodeFactory;
import io.keikai.doc.api.impl.operation.AbstractDocumentOperation;
import io.keikai.doc.api.impl.operation.RemoveChildOperation;
import java.util.Map;

public class AddChildOperation
extends AbstractDocumentOperation {
    static final String TYPE = "INSERT_NODE";
    private final DocumentNode<?, ?, ?> _node;

    public AddChildOperation(Path path, DocumentNode<?, ?, ?> node) {
        super(TYPE, path);
        this._node = node;
    }

    @JsonCreator
    private AddChildOperation(@JsonProperty(value="path") Path path, @JsonProperty(value="node") Map<?, ?> node) {
        this(path, DefaultDocumentNodeFactory.create(node));
    }

    public DocumentNode<?, ?, ?> getNode() {
        return this._node;
    }

    @Override
    public void apply(DocumentModel model) {
        if (Path.of().equals(this.getPath())) {
            model.setRoot(this.getNode());
            return;
        }
        DocumentNode<?, ?, ?> parent = model.getNode(this.getPath().getParent());
        parent.addChild(this.getPath().getLastIndex(), this.getNode());
    }

    @Override
    public AbstractDocumentOperation reverse() {
        return new RemoveChildOperation(this.getPath(), this._node);
    }
}

