/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.keikai.doc.api.impl.node.style.AbstractDocumentNodeStyle;
import io.keikai.doc.api.impl.node.style.Color;
import io.keikai.doc.api.impl.node.style.ParagraphStyle;

public class TextStyle
extends AbstractDocumentNodeStyle {
    public static final TextStyle DEFAULT = new Builder().build();
    public static final String DEFAULT_FONT_FAMILY = "Arial";
    public static final int FONT_WEIGHT_NORMAL = 400;
    public static final int FONT_WEIGHT_BOLD = 700;
    private final Color _backgroundColor;
    private final Color _color;
    private final String _fontFamily;
    private final double _fontSize;
    private final int _fontWeight;
    private final boolean _italic;
    private final boolean _strikethrough;
    private final boolean _subscript;
    private final boolean _superscript;
    private final boolean _underline;

    @JsonCreator
    private TextStyle(@JsonProperty(value="backgroundColor") Color backgroundColor, @JsonProperty(value="color") Color color, @JsonProperty(value="fontFamily") String fontFamily, @JsonProperty(value="fontSize") double fontSize, @JsonProperty(value="fontWeight") int fontWeight, @JsonProperty(value="italic") boolean italic, @JsonProperty(value="strikethrough") boolean strikethrough, @JsonProperty(value="subscript") boolean subscript, @JsonProperty(value="superscript") boolean superscript, @JsonProperty(value="underline") boolean underline) {
        this._backgroundColor = backgroundColor;
        this._color = color;
        this._fontFamily = fontFamily;
        this._fontSize = fontSize;
        this._fontWeight = fontWeight;
        this._italic = italic;
        this._strikethrough = strikethrough;
        this._subscript = subscript;
        this._superscript = superscript;
        this._underline = underline;
    }

    @JsonIgnore
    public boolean isBold() {
        return this._fontWeight >= 700;
    }

    public TextStyle withBold(boolean bold) {
        return new Builder(this).setBold(bold).build();
    }

    public Color getBackgroundColor() {
        return this._backgroundColor;
    }

    public TextStyle withBackgroundColor(Color backgroundColor) {
        return new Builder(this).setBackgroundColor(backgroundColor).build();
    }

    public Color getColor() {
        return this._color;
    }

    public TextStyle withColor(Color color) {
        return new Builder(this).setColor(color).build();
    }

    public String getFontFamily() {
        return this._fontFamily;
    }

    public TextStyle withFontFamily(String fontFamily) {
        return new Builder(this).setFontFamily(fontFamily).build();
    }

    public double getFontSize() {
        return this._fontSize;
    }

    public TextStyle withFontSize(double fontSize) {
        return new Builder(this).setFontSize(fontSize).build();
    }

    public int getFontWeight() {
        return this._fontWeight;
    }

    public TextStyle withFontWeight(int fontWeight) {
        return new Builder(this).setFontWeight(fontWeight).build();
    }

    public boolean isItalic() {
        return this._italic;
    }

    public TextStyle withItalic(boolean italic) {
        return new Builder(this).setItalic(italic).build();
    }

    public boolean isStrikethrough() {
        return this._strikethrough;
    }

    public TextStyle withStrikethrough(boolean strikethrough) {
        return new Builder(this).setStrikethrough(strikethrough).build();
    }

    public boolean isSubscript() {
        return this._subscript;
    }

    public TextStyle withSubscript(boolean subscript) {
        return new Builder(this).setSubscript(subscript).build();
    }

    public boolean isSuperscript() {
        return this._superscript;
    }

    public TextStyle withSuperscript(boolean superscript) {
        return new Builder(this).setSuperscript(superscript).build();
    }

    public boolean isUnderline() {
        return this._underline;
    }

    public TextStyle withUnderline(boolean underline) {
        return new Builder(this).setUnderline(underline).build();
    }

    public static class Builder {
        private Color _backgroundColor = null;
        private Color _color = Color.BLACK;
        private String _fontFamily = "Arial";
        private double _fontSize = ParagraphStyle.Type.P.getFontSize();
        private int _fontWeight = 400;
        private boolean _italic;
        private boolean _strikethrough;
        private boolean _subscript;
        private boolean _superscript;
        private boolean _underline;

        public Builder() {
        }

        Builder(TextStyle style) {
            this._backgroundColor = style._backgroundColor;
            this._color = style._color;
            this._fontFamily = style._fontFamily;
            this._fontSize = style._fontSize;
            this._fontWeight = style._fontWeight;
            this._italic = style._italic;
            this._strikethrough = style._strikethrough;
            this._subscript = style._subscript;
            this._superscript = style._superscript;
            this._underline = style._underline;
        }

        public Builder setBold(boolean bold) {
            this._fontWeight = bold ? 700 : 400;
            return this;
        }

        public Builder setBackgroundColor(Color backgroundColor) {
            this._backgroundColor = backgroundColor;
            return this;
        }

        public Builder setColor(Color color) {
            this._color = color;
            return this;
        }

        public Builder setFontFamily(String fontFamily) {
            this._fontFamily = fontFamily;
            return this;
        }

        public Builder setFontSize(double fontSize) {
            this._fontSize = fontSize;
            return this;
        }

        public Builder setFontWeight(int fontWeight) {
            this._fontWeight = fontWeight;
            return this;
        }

        public Builder setItalic(boolean italic) {
            this._italic = italic;
            return this;
        }

        public Builder setStrikethrough(boolean strikethrough) {
            this._strikethrough = strikethrough;
            return this;
        }

        public Builder setSubscript(boolean subscript) {
            this._subscript = subscript;
            return this;
        }

        public Builder setSuperscript(boolean superscript) {
            this._superscript = superscript;
            return this;
        }

        public Builder setUnderline(boolean underline) {
            this._underline = underline;
            return this;
        }

        public TextStyle build() {
            return new TextStyle(this._backgroundColor, this._color, this._fontFamily, this._fontSize, this._fontWeight, this._italic, this._strikethrough, this._subscript, this._superscript, this._underline);
        }
    }
}

