/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.keikai.doc.api.impl.node.style.AbstractDocumentNodeStyle;

public class TableStyle
extends AbstractDocumentNodeStyle {
    public static final TableStyle DEFAULT = new Builder().build();
    private final double _marginLeft;
    private final double[] _colSizes;

    @JsonCreator
    private TableStyle(@JsonProperty(value="marginLeft") double marginLeft, @JsonProperty(value="colSizes") double[] colSizes) {
        this._marginLeft = marginLeft;
        this._colSizes = colSizes;
    }

    public double getMarginLeft() {
        return this._marginLeft;
    }

    public TableStyle withMarginLeft(double marginLeft) {
        return new Builder(this).setMarginLeft(marginLeft).build();
    }

    public double[] getColSizes() {
        return this._colSizes;
    }

    public TableStyle withColSizes(double[] colSizes) {
        return new Builder(this).setColSizes(colSizes).build();
    }

    public static class Builder {
        private double _marginLeft = 0.0;
        private double[] _colSizes = null;

        public Builder() {
        }

        Builder(TableStyle style) {
            this._marginLeft = style._marginLeft;
            this._colSizes = style._colSizes;
        }

        public Builder setMarginLeft(double marginLeft) {
            this._marginLeft = marginLeft;
            return this;
        }

        public Builder setColSizes(double[] colSizes) {
            this._colSizes = colSizes;
            return this;
        }

        public TableStyle build() {
            return new TableStyle(this._marginLeft, this._colSizes);
        }
    }
}

