/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.keikai.doc.api.impl.node.style.AbstractDocumentNodeStyle;
import io.keikai.doc.api.impl.node.style.Color;

public class TableCellStyle
extends AbstractDocumentNodeStyle {
    public static final TableCellStyle DEFAULT = new Builder().build();
    public static final Color DEFAULT_BACKGROUND = null;
    public static final double DEFAULT_BORDER_SIZE = 1.0;
    public static final Border.Style DEFAULT_BORDER_STYLE = Border.Style.SOLID;
    public static final Color DEFAULT_BORDER_COLOR = Color.BLACK;
    private final Color _background;
    private final Borders _borders;
    private final int _colSpan;
    private final int _rowSpan;

    @JsonCreator
    private TableCellStyle(@JsonProperty(value="background") Color background, @JsonProperty(value="borders") Borders borders, @JsonProperty(value="colSpan") int colSpan, @JsonProperty(value="rowSpan") int rowSpan) {
        this._background = background;
        this._borders = borders;
        this._colSpan = colSpan;
        this._rowSpan = rowSpan;
    }

    public Color getBackground() {
        return this._background;
    }

    public TableCellStyle withBackground(Color background) {
        return new Builder(this).setBackground(background).build();
    }

    public Borders getBorders() {
        return this._borders;
    }

    public TableCellStyle withBorders(Borders borders) {
        return new Builder(this).setBorders(borders).build();
    }

    public TableCellStyle withTopBorder(Border border) {
        return new Builder(this).setTopBorder(border).build();
    }

    public TableCellStyle withRightBorder(Border border) {
        return new Builder(this).setRightBorder(border).build();
    }

    public TableCellStyle withBottomBorder(Border border) {
        return new Builder(this).setBottomBorder(border).build();
    }

    public TableCellStyle withLeftBorder(Border border) {
        return new Builder(this).setLeftBorder(border).build();
    }

    public TableCellStyle withTopBorderSize(double topBorderSize) {
        return new Builder(this).setTopBorderSize(topBorderSize).build();
    }

    public TableCellStyle withTopBorderStyle(Border.Style topBorderStyle) {
        return new Builder(this).setTopBorderStyle(topBorderStyle).build();
    }

    public TableCellStyle withTopBorderColor(Color topBorderColor) {
        return new Builder(this).setTopBorderColor(topBorderColor).build();
    }

    public TableCellStyle withRightBorderSize(double rightBorderSize) {
        return new Builder(this).setRightBorderSize(rightBorderSize).build();
    }

    public TableCellStyle withRightBorderStyle(Border.Style rightBorderStyle) {
        return new Builder(this).setRightBorderStyle(rightBorderStyle).build();
    }

    public TableCellStyle withRightBorderColor(Color rightBorderColor) {
        return new Builder(this).setRightBorderColor(rightBorderColor).build();
    }

    public TableCellStyle withBottomBorderSize(double bottomBorderSize) {
        return new Builder(this).setBottomBorderSize(bottomBorderSize).build();
    }

    public TableCellStyle withBottomBorderStyle(Border.Style bottomBorderStyle) {
        return new Builder(this).setBottomBorderStyle(bottomBorderStyle).build();
    }

    public TableCellStyle withBottomBorderColor(Color bottomBorderColor) {
        return new Builder(this).setBottomBorderColor(bottomBorderColor).build();
    }

    public TableCellStyle withLeftBorderSize(double leftBorderSize) {
        return new Builder(this).setLeftBorderSize(leftBorderSize).build();
    }

    public TableCellStyle withLeftBorderStyle(Border.Style leftBorderStyle) {
        return new Builder(this).setLeftBorderStyle(leftBorderStyle).build();
    }

    public TableCellStyle withLeftBorderColor(Color leftBorderColor) {
        return new Builder(this).setLeftBorderColor(leftBorderColor).build();
    }

    public int getColSpan() {
        return this._colSpan;
    }

    public TableCellStyle withColSpan(int colSpan) {
        return new Builder(this).setColSpan(colSpan).build();
    }

    public int getRowSpan() {
        return this._rowSpan;
    }

    public TableCellStyle withRowSpan(int rowSpan) {
        return new Builder(this).setRowSpan(rowSpan).build();
    }

    public static class Builder {
        private Color _background = DEFAULT_BACKGROUND;
        private double _topBorderSize = 1.0;
        private Border.Style _topBorderStyle = DEFAULT_BORDER_STYLE;
        private Color _topBorderColor = DEFAULT_BORDER_COLOR;
        private double _rightBorderSize = 1.0;
        private Border.Style _rightBorderStyle = DEFAULT_BORDER_STYLE;
        private Color _rightBorderColor = DEFAULT_BORDER_COLOR;
        private double _bottomBorderSize = 1.0;
        private Border.Style _bottomBorderStyle = DEFAULT_BORDER_STYLE;
        private Color _bottomBorderColor = DEFAULT_BORDER_COLOR;
        private double _leftBorderSize = 1.0;
        private Border.Style _leftBorderStyle = DEFAULT_BORDER_STYLE;
        private Color _leftBorderColor = DEFAULT_BORDER_COLOR;
        private int _colSpan = 1;
        private int _rowSpan = 1;

        public Builder() {
        }

        Builder(TableCellStyle style) {
            this._background = style._background;
            this._topBorderSize = style._borders.getTop().getSize();
            this._topBorderStyle = style._borders.getTop().getStyle();
            this._topBorderColor = style._borders.getTop().getColor();
            this._rightBorderSize = style._borders.getRight().getSize();
            this._rightBorderStyle = style._borders.getRight().getStyle();
            this._rightBorderColor = style._borders.getRight().getColor();
            this._bottomBorderSize = style._borders.getBottom().getSize();
            this._bottomBorderStyle = style._borders.getBottom().getStyle();
            this._bottomBorderColor = style._borders.getBottom().getColor();
            this._leftBorderSize = style._borders.getLeft().getSize();
            this._leftBorderStyle = style._borders.getLeft().getStyle();
            this._leftBorderColor = style._borders.getLeft().getColor();
            this._colSpan = style._colSpan;
            this._rowSpan = style._rowSpan;
        }

        public Builder setBackground(Color background) {
            this._background = background;
            return this;
        }

        public Builder setBorders(Borders borders) {
            this._topBorderSize = borders.getTop().getSize();
            this._topBorderStyle = borders.getTop().getStyle();
            this._topBorderColor = borders.getTop().getColor();
            this._rightBorderSize = borders.getRight().getSize();
            this._rightBorderStyle = borders.getRight().getStyle();
            this._rightBorderColor = borders.getRight().getColor();
            this._bottomBorderSize = borders.getBottom().getSize();
            this._bottomBorderStyle = borders.getBottom().getStyle();
            this._bottomBorderColor = borders.getBottom().getColor();
            this._leftBorderSize = borders.getLeft().getSize();
            this._leftBorderStyle = borders.getLeft().getStyle();
            this._leftBorderColor = borders.getLeft().getColor();
            return this;
        }

        public Builder setTopBorder(Border border) {
            this._topBorderSize = border.getSize();
            this._topBorderStyle = border.getStyle();
            this._topBorderColor = border.getColor();
            return this;
        }

        public Builder setRightBorder(Border border) {
            this._rightBorderSize = border.getSize();
            this._rightBorderStyle = border.getStyle();
            this._rightBorderColor = border.getColor();
            return this;
        }

        public Builder setBottomBorder(Border border) {
            this._bottomBorderSize = border.getSize();
            this._bottomBorderStyle = border.getStyle();
            this._bottomBorderColor = border.getColor();
            return this;
        }

        public Builder setLeftBorder(Border border) {
            this._leftBorderSize = border.getSize();
            this._leftBorderStyle = border.getStyle();
            this._leftBorderColor = border.getColor();
            return this;
        }

        public Builder setTopBorderSize(double topBorderSize) {
            this._topBorderSize = topBorderSize;
            return this;
        }

        public Builder setTopBorderStyle(Border.Style topBorderStyle) {
            this._topBorderStyle = topBorderStyle;
            return this;
        }

        public Builder setTopBorderColor(Color topBorderColor) {
            this._topBorderColor = topBorderColor;
            return this;
        }

        public Builder setRightBorderSize(double rightBorderSize) {
            this._rightBorderSize = rightBorderSize;
            return this;
        }

        public Builder setRightBorderStyle(Border.Style rightBorderStyle) {
            this._rightBorderStyle = rightBorderStyle;
            return this;
        }

        public Builder setRightBorderColor(Color rightBorderColor) {
            this._rightBorderColor = rightBorderColor;
            return this;
        }

        public Builder setBottomBorderSize(double bottomBorderSize) {
            this._bottomBorderSize = bottomBorderSize;
            return this;
        }

        public Builder setBottomBorderStyle(Border.Style bottomBorderStyle) {
            this._bottomBorderStyle = bottomBorderStyle;
            return this;
        }

        public Builder setBottomBorderColor(Color bottomBorderColor) {
            this._bottomBorderColor = bottomBorderColor;
            return this;
        }

        public Builder setLeftBorderSize(double leftBorderSize) {
            this._leftBorderSize = leftBorderSize;
            return this;
        }

        public Builder setLeftBorderStyle(Border.Style leftBorderStyle) {
            this._leftBorderStyle = leftBorderStyle;
            return this;
        }

        public Builder setLeftBorderColor(Color leftBorderColor) {
            this._leftBorderColor = leftBorderColor;
            return this;
        }

        public Builder setColSpan(int colSpan) {
            this._colSpan = colSpan;
            return this;
        }

        public Builder setRowSpan(int rowSpan) {
            this._rowSpan = rowSpan;
            return this;
        }

        public TableCellStyle build() {
            return new TableCellStyle(this._background, new Borders(new Border(this._topBorderSize, this._topBorderStyle, this._topBorderColor), new Border(this._rightBorderSize, this._rightBorderStyle, this._rightBorderColor), new Border(this._bottomBorderSize, this._bottomBorderStyle, this._bottomBorderColor), new Border(this._leftBorderSize, this._leftBorderStyle, this._leftBorderColor)), this._colSpan, this._rowSpan);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public static class Border {
        private final double _size;
        private final Style _style;
        private final Color _color;

        @JsonCreator
        public Border(@JsonProperty(value="size") double size, @JsonProperty(value="style") Style style, @JsonProperty(value="color") Color color) {
            this._size = size;
            this._style = style;
            this._color = color;
        }

        public double getSize() {
            return this._size;
        }

        public Style getStyle() {
            return this._style;
        }

        public Color getColor() {
            return this._color;
        }

        public static enum Style {
            NONE,
            DOTTED,
            DASHED,
            SOLID,
            DOUBLE;


            @JsonValue
            public String toString() {
                return super.toString().toLowerCase();
            }

            @JsonCreator
            private static Style fromString(String value) {
                return value == null ? null : Style.valueOf(value.toUpperCase());
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public static class Borders {
        private final Border _top;
        private final Border _right;
        private final Border _bottom;
        private final Border _left;

        @JsonCreator
        public Borders(@JsonProperty(value="top") Border top, @JsonProperty(value="right") Border right, @JsonProperty(value="bottom") Border bottom, @JsonProperty(value="left") Border left) {
            this._top = top;
            this._right = right;
            this._bottom = bottom;
            this._left = left;
        }

        public Border getTop() {
            return this._top;
        }

        public Border getRight() {
            return this._right;
        }

        public Border getBottom() {
            return this._bottom;
        }

        public Border getLeft() {
            return this._left;
        }
    }
}

