/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.regex.Pattern;
import org.zkoss.zk.ui.UiException;

public class Color {
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("^#([A-Fa-f0-9]{6})([A-Fa-f0-9]{2})?$");
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color WHITE = new Color(255, 255, 255);
    private int _red;
    private int _green;
    private int _blue;
    private int _alpha;

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(int r, int g, int b, int a) {
        this.checkColorRange(r, g, b, a);
        this._red = r;
        this._green = g;
        this._blue = b;
        this._alpha = a;
    }

    private void checkColorRange(int r, int g, int b, int a) {
        Object wrongColors = "";
        boolean gotError = false;
        if (r < 0 || r > 255) {
            gotError = true;
            wrongColors = (String)wrongColors + "\"red\"";
        }
        if (g < 0 || g > 255) {
            gotError = true;
            wrongColors = (String)wrongColors + " \"green\"";
        }
        if (b < 0 || b > 255) {
            gotError = true;
            wrongColors = (String)wrongColors + " \"blue\"";
        }
        if (a < 0 || a > 255) {
            gotError = true;
            wrongColors = (String)wrongColors + " \"alpha\"";
        }
        if (gotError) {
            throw new IllegalArgumentException((String)wrongColors + " color value outside of expected range 0-255");
        }
    }

    public int getRed() {
        return this._red;
    }

    public int getGreen() {
        return this._green;
    }

    public int getBlue() {
        return this._blue;
    }

    public int getAlpha() {
        return this._alpha;
    }

    public int getRGB() {
        return (this._alpha << 24) + (this._red << 16) + (this._green << 8) + this._blue;
    }

    @JsonValue
    public String toString() {
        return String.format("rgba(%d, %d, %d, %d)", this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    @JsonCreator
    private static Color fromString(String s) {
        String[] rgba = s.replaceAll("[rgba() ]", "").split(",");
        if (rgba.length == 3 || rgba.length == 4) {
            return new Color(Integer.parseInt(rgba[0]), Integer.parseInt(rgba[1]), Integer.parseInt(rgba[2]), rgba.length == 3 ? 255 : Integer.parseInt(rgba[3]));
        }
        throw new UiException("Invalid color format: " + s);
    }

    public static String toHexString(byte[] color) throws IllegalArgumentException {
        if (color == null || color.length < 3 || color.length > 4) {
            throw new IllegalArgumentException("Color bytes must be exactly 3 or 4 bytes.");
        }
        StringBuilder hexColor = new StringBuilder("#");
        for (byte b : color) {
            hexColor.append(String.format("%02X", b & 0xFF));
        }
        return hexColor.toString();
    }

    public static String toHexString(Color color) {
        String hex = String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
        return color.getAlpha() == 255 ? hex : hex + String.format("%02X", color.getAlpha());
    }

    public static byte[] toBytes(String color) throws IllegalArgumentException {
        if (!HEX_COLOR_PATTERN.matcher(color).matches()) {
            throw new IllegalArgumentException("Invalid color format, color string format must be #RRGGBB or #RRGGBBAA.");
        }
        color = color.substring(1, 7);
        byte[] colorBytes = new byte[3];
        for (int i = 0; i < 3; ++i) {
            colorBytes[i] = (byte)Integer.parseInt(color.substring(i * 2, i * 2 + 2), 16);
        }
        return colorBytes;
    }

    public static byte[] toBytes(Color color) {
        return new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()};
    }

    public static Color decode(String color) throws IllegalArgumentException {
        if (!HEX_COLOR_PATTERN.matcher(color).matches()) {
            throw new IllegalArgumentException("Invalid color format, color string format must be #RRGGBB or #RRGGBBAA.");
        }
        color = color.substring(0, 7);
        int x = Integer.decode(color);
        return new Color(x >> 16 & 0xFF, x >> 8 & 0xFF, x & 0xFF);
    }

    public static Color decode(byte[] color) throws IllegalArgumentException {
        if (color == null || color.length < 3 || color.length > 4) {
            throw new IllegalArgumentException("Color bytes must be exactly 3 or 4 bytes.");
        }
        return new Color(color[0] & 0xFF, color[1] & 0xFF, color[2] & 0xFF);
    }

    public static java.awt.Color toAwtColor(Color color) {
        if (color == null) {
            return null;
        }
        return new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }
}

