/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.keikai.doc.api.impl.model.DefaultDocumentModel;
import io.keikai.doc.api.impl.node.AbstractDocumentNode;
import io.keikai.doc.api.impl.node.DocumentNodeVisitor;
import io.keikai.doc.api.impl.node.InlineNode;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.style.DefaultDocumentNodeStyleFactory;
import io.keikai.doc.api.impl.node.style.TextStyle;
import io.keikai.doc.api.impl.operation.AddTextOperation;
import io.keikai.doc.api.impl.operation.RemoveTextOperation;
import io.keikai.doc.api.impl.util.ObjectMapperUtil;
import java.util.List;
import org.zkoss.zk.ui.UiException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TextNode
extends InlineNode<TextStyle> {
    private String _text;

    public TextNode(String text) {
        this(new TextStyle.Builder().build(), text);
    }

    @JsonCreator
    public TextNode(@JsonProperty(value="style") TextStyle style, @JsonProperty(value="text") String text) {
        super(style);
        this._text = text;
    }

    @Override
    String getType() {
        return null;
    }

    public String getText() {
        return this._text;
    }

    public void addText(int offset, String text) {
        this._text = this._text.substring(0, offset) + text + this._text.substring(offset);
        DefaultDocumentModel model = this.getModel();
        if (model != null) {
            model.fireOperation(new AddTextOperation(model.getPath(this), offset, text));
        }
    }

    public void removeText(int startOffset, int endOffset) {
        String removed = this._text.substring(startOffset, endOffset);
        this._text = this._text.substring(0, startOffset) + this._text.substring(endOffset);
        DefaultDocumentModel model = this.getModel();
        if (model != null) {
            model.fireOperation(new RemoveTextOperation(model.getPath(this), startOffset, removed));
        }
    }

    public void setStyle(int startOffset, int endOffset, TextStyle style) {
        if (this.getStyle() != null && ((TextStyle)this.getStyle()).equals(style)) {
            return;
        }
        DefaultDocumentModel model = this.getModel();
        Runnable action = () -> {
            ParagraphNode parent = (ParagraphNode)this.getParent();
            TextNode node = this;
            int oriLength = this._text.length();
            if (startOffset > 0) {
                parent.splitChildToPreviousChild(parent.getChildIndex(this), startOffset);
            }
            if (endOffset > 0 && endOffset < oriLength) {
                parent.splitChildToPreviousChild(parent.getChildIndex(this), startOffset == 0 ? endOffset : endOffset - startOffset);
                node = (TextNode)parent.getChild(parent.getChildIndex(this) - 1);
            }
            node.setStyle(style);
        };
        if (model == null) {
            action.run();
        } else {
            model.runBatch(action);
        }
    }

    @Override
    @JsonIgnore
    public List<TextNode> getChildren() {
        return List.of();
    }

    @Override
    public void addChild(int index, TextNode child) {
        throw new UiException("TextNode cannot have children");
    }

    @Override
    public void removeChild(TextNode child) {
        throw new UiException("TextNode cannot have children");
    }

    TextNode split(int position) {
        TextStyle style = this.getStyle() == null ? null : (TextStyle)DefaultDocumentNodeStyleFactory.create(ObjectMapperUtil.toJSON(this.getStyle()), this.getClass());
        TextNode prev = new TextNode(style, this._text.substring(0, position));
        this._text = this._text.substring(position);
        return prev;
    }

    @Override
    int merge(AbstractDocumentNode<?, ?, ?> node) {
        int position = this._text.length();
        this._text = this._text + ((TextNode)node)._text;
        return position;
    }

    @Override
    public <R> R accept(DocumentNodeVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

