/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import io.keikai.doc.api.impl.model.DefaultDocumentModel;
import io.keikai.doc.api.impl.node.BlockNode;
import io.keikai.doc.api.impl.node.ContainerNode;
import io.keikai.doc.api.impl.node.DocumentNodeVisitor;
import io.keikai.doc.api.impl.node.FooterNode;
import io.keikai.doc.api.impl.node.HeaderNode;
import io.keikai.doc.api.impl.node.PageType;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.RootNode;
import io.keikai.doc.api.impl.node.style.SectionStyle;
import io.keikai.doc.api.impl.operation.SetNodeOperation;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SectionNode
extends ContainerNode<RootNode, SectionStyle> {
    static final String TYPE = "section";
    private final EnumMap<PageType, HeaderNode> _headers = new EnumMap(PageType.class);
    private final EnumMap<PageType, FooterNode> _footers = new EnumMap(PageType.class);

    public SectionNode() {
        this(SectionStyle.DEFAULT);
    }

    public SectionNode(SectionStyle style) {
        this(style, (Collection<BlockNode<?, ?>>)List.of());
    }

    public SectionNode(Collection<BlockNode<?, ?>> children) {
        this(SectionStyle.DEFAULT, children);
    }

    public SectionNode(SectionStyle style, Collection<BlockNode<?, ?>> children) {
        super(style, children);
        this.setHeader(PageType.DEFAULT, new HeaderNode((Collection<BlockNode<?, ?>>)List.of(new ParagraphNode(""))));
        this.setFooter(PageType.DEFAULT, new FooterNode((Collection<BlockNode<?, ?>>)List.of(new ParagraphNode(""))));
    }

    @Override
    String getType() {
        return TYPE;
    }

    @JsonAnyGetter
    private Map<String, Object> getHeadersAndFooters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this._headers.forEach((k, v) -> map.put(k.name().toLowerCase() + "Header", v));
        this._footers.forEach((k, v) -> map.put(k.name().toLowerCase() + "Footer", v));
        return map;
    }

    public HeaderNode getHeader(PageType pageType) {
        return this._headers.get((Object)pageType);
    }

    public void setHeader(PageType type, HeaderNode node) {
        HeaderNode oriNode = this._headers.get((Object)type);
        if (oriNode != null) {
            oriNode.setParent(null);
        }
        if (node != null) {
            node.setParent(this);
        }
        this._headers.put(type, node);
        DefaultDocumentModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.runBatch(() -> {
            String key = type.name().toLowerCase() + "Header";
            HashMap<Object, Object> oriMap = new HashMap<Object, Object>();
            oriMap.put(key, oriNode);
            HashMap<Object, Object> newMap = new HashMap<Object, Object>();
            newMap.put(key, node);
            model.fireOperation(new SetNodeOperation(model.getPath(this), this, oriMap, newMap));
        });
    }

    public FooterNode getFooter(PageType type) {
        return this._footers.get((Object)type);
    }

    public void setFooter(PageType type, FooterNode node) {
        FooterNode oriNode = this._footers.get((Object)type);
        if (oriNode != null) {
            oriNode.setParent(null);
        }
        if (node != null) {
            node.setParent(this);
        }
        this._footers.put(type, node);
        DefaultDocumentModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.runBatch(() -> {
            String key = type.name().toLowerCase() + "Footer";
            HashMap<Object, Object> oriMap = new HashMap<Object, Object>();
            oriMap.put(key, oriNode);
            HashMap<Object, Object> newMap = new HashMap<Object, Object>();
            newMap.put(key, node);
            model.fireOperation(new SetNodeOperation(model.getPath(this), this, oriMap, newMap));
        });
    }

    public PageType getPageType(HeaderNode node) {
        return this._headers.entrySet().stream().filter(e -> e.getValue() == node).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public PageType getPageType(FooterNode node) {
        return this._footers.entrySet().stream().filter(e -> e.getValue() == node).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    @Override
    public <R> R accept(DocumentNodeVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

