/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node;

import io.keikai.doc.api.DocumentNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DocumentNodeLazyIterator
implements Iterator<DocumentNode<?, ?, ?>> {
    private final Deque<DocumentNode<?, ?, ?>> _stack = new ArrayDeque(2);

    public DocumentNodeLazyIterator(DocumentNode<?, ?, ?> root) {
        this._stack.push(root);
    }

    @Override
    public boolean hasNext() {
        return !this._stack.isEmpty();
    }

    @Override
    public DocumentNode<?, ?, ?> next() {
        if (this.hasNext()) {
            DocumentNode<?, ?, ?> node = this._stack.pop();
            for (int r = node.getChildCount() - 1; r >= 0; --r) {
                this._stack.push((DocumentNode<?, ?, ?>)node.getChild(r));
            }
            return node;
        }
        throw new NoSuchElementException();
    }

    public Stream<DocumentNode<?, ?, ?>> stream() {
        Iterable iterable = () -> this;
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

