/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node;

import io.keikai.doc.api.DocumentRange;
import io.keikai.doc.api.Path;
import io.keikai.doc.api.impl.model.DefaultDocumentModel;
import io.keikai.doc.api.impl.node.AbstractDocumentNode;
import io.keikai.doc.api.impl.node.ContainerNode;
import io.keikai.doc.api.impl.node.DocumentNodeVisitor;
import io.keikai.doc.api.impl.node.SectionNode;
import io.keikai.doc.api.impl.node.TextNode;
import java.util.ArrayList;
import java.util.List;

public class DefaultDocumentRange
implements DocumentRange {
    private TextNode _startNode;
    private int _startOffset;
    private TextNode _endNode;
    private int _endOffset;

    public DefaultDocumentRange(TextNode startNode, int startOffset, TextNode endNode, int endOffset) {
        this._startNode = startNode;
        this._startOffset = startOffset;
        this._endNode = endNode;
        this._endOffset = endOffset;
    }

    public TextNode getStartNode() {
        return this._startNode;
    }

    @Override
    public int getStartOffset() {
        return this._startOffset;
    }

    public TextNode getEndNode() {
        return this._endNode;
    }

    @Override
    public int getEndOffset() {
        return this._endOffset;
    }

    void setStart(TextNode startNode, int startOffset) {
        this._startNode = startNode;
        this._startOffset = startOffset;
    }

    void setEnd(TextNode endNode, int endOffset) {
        this._endNode = endNode;
        this._endOffset = endOffset;
    }

    public <T extends AbstractDocumentNode<?, ?, ?>> List<T> getNodes(final Class<T> clazz) {
        SectionNode sectionNode;
        final DefaultDocumentModel model = this._startNode.getModel();
        final Path startNodePath = model.getPath(this._startNode);
        final Path endNodePath = model.getPath(this._endNode);
        ContainerNode root = sectionNode = (SectionNode)model.getRoot().getChild(startNodePath.getSectionIndex());
        if (startNodePath.isInHeader()) {
            root = sectionNode.getHeader(startNodePath.getPageType());
        } else if (startNodePath.isInFooter()) {
            root = sectionNode.getFooter(startNodePath.getPageType());
        }
        return (List)root.accept(new DocumentNodeVisitor<List<T>>(){

            @Override
            public List<T> defaultVisit(AbstractDocumentNode<?, ?, ?> node) {
                ArrayList<AbstractDocumentNode> nodes = new ArrayList<AbstractDocumentNode>();
                Path path = model.getPath(node);
                if (this.beforeOrEqual(startNodePath, path) && this.beforeOrEqual(path, endNodePath)) {
                    if (clazz.isInstance(node)) {
                        nodes.add((AbstractDocumentNode)clazz.cast(node));
                    }
                    node.visitChildren(this).forEach(nodes::addAll);
                }
                return nodes;
            }

            private boolean beforeOrEqual(Path path0, Path path1) {
                int[] relPath0 = path0.getRelativePath();
                int[] relPath1 = path1.getRelativePath();
                for (int i = 0; i < Math.min(relPath0.length, relPath1.length); ++i) {
                    if (relPath0[i] < relPath1[i]) {
                        return true;
                    }
                    if (relPath0[i] <= relPath1[i]) continue;
                    return false;
                }
                return true;
            }
        });
    }
}

