/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.DocumentModelListener;
import io.keikai.doc.api.DocumentNode;
import io.keikai.doc.api.DocumentOperation;
import io.keikai.doc.api.DocumentOperationBatch;
import io.keikai.doc.api.DocumentRange;
import io.keikai.doc.api.DocumentSelectableModel;
import io.keikai.doc.api.DocumentUndoableModel;
import io.keikai.doc.api.Path;
import io.keikai.doc.api.impl.node.AbstractDocumentNode;
import io.keikai.doc.api.impl.node.BlockNode;
import io.keikai.doc.api.impl.node.DefaultDocumentNodeFactory;
import io.keikai.doc.api.impl.node.DefaultDocumentRange;
import io.keikai.doc.api.impl.node.FooterNode;
import io.keikai.doc.api.impl.node.HeaderNode;
import io.keikai.doc.api.impl.node.InlineNode;
import io.keikai.doc.api.impl.node.PageType;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.RootNode;
import io.keikai.doc.api.impl.node.SectionNode;
import io.keikai.doc.api.impl.node.TextNode;
import io.keikai.doc.api.impl.node.style.SectionStyle;
import io.keikai.doc.api.impl.node.style.TextStyle;
import io.keikai.doc.api.impl.operation.AbstractDocumentOperation;
import io.keikai.doc.api.impl.operation.AddChildOperation;
import io.keikai.doc.api.impl.operation.AddTextOperation;
import io.keikai.doc.api.impl.operation.DefaultDocumentOperationBatch;
import io.keikai.doc.api.impl.operation.RemoveChildOperation;
import io.keikai.doc.api.impl.operation.RemoveTextOperation;
import io.keikai.doc.api.impl.operation.SetNodeOperation;
import io.keikai.doc.api.impl.operation.SetSelectionOperation;
import io.keikai.doc.api.impl.util.ObjectMapperUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.zkoss.json.JSONObject;

public class DefaultDocumentModel
implements DocumentModel,
DocumentSelectableModel,
DocumentUndoableModel {
    private RootNode _root;
    private final List<DocumentModelListener> _listeners = new ArrayList<DocumentModelListener>();
    private final ThreadLocal<Boolean> _shouldNotify = ThreadLocal.withInitial(() -> true);
    private final ReadWriteLock _lock = new ReentrantReadWriteLock();
    private final ThreadLocal<DocumentOperationBatch> _batch = ThreadLocal.withInitial(() -> null);
    private DefaultDocumentRange _selection;
    private int _maxRevisionSize = 100;
    private int _currentRevisionIndex = -1;
    private LinkedList<DocumentOperationBatch> _revisionHistory = new LinkedList();
    private final ThreadLocal<Boolean> _shouldAddToHistory = ThreadLocal.withInitial(() -> true);

    public DefaultDocumentModel() {
        this(new RootNode((Collection<SectionNode>)List.of(new SectionNode((Collection<BlockNode<?, ?>>)List.of(new ParagraphNode(""))))));
    }

    public DefaultDocumentModel(RootNode root) {
        this._root = root;
        this._root.setModel(this);
    }

    @JsonCreator
    private DefaultDocumentModel(@JsonProperty(value="root") Map<Object, Object> root, @JsonProperty(value="maxRevisionSize") int maxRevisionSize, @JsonProperty(value="currentRevisionIndex") int currentRevisionIndex, @JsonProperty(value="revisionHistory") List<DefaultDocumentOperationBatch> revisionHistory) {
        this((RootNode)DefaultDocumentNodeFactory.create(root));
        this._maxRevisionSize = maxRevisionSize;
        this._currentRevisionIndex = currentRevisionIndex;
        this._revisionHistory.addAll(revisionHistory);
    }

    @Override
    public JSONObject toJSON() {
        return ObjectMapperUtil.toJSON(this);
    }

    @Override
    public void loadJSON(JSONObject json) {
        DefaultDocumentModel model = (DefaultDocumentModel)ObjectMapperUtil.fromJSON(json, this.getClass());
        this.setRoot(model._root);
        this._maxRevisionSize = model._maxRevisionSize;
        this._currentRevisionIndex = model._currentRevisionIndex;
        this._revisionHistory = model._revisionHistory;
    }

    public RootNode getRoot() {
        return this._root;
    }

    @Override
    public void setRoot(DocumentNode<?, ?, ?> root) {
        if (!(root instanceof RootNode)) {
            throw new IllegalArgumentException("Can only set root to a RootNode.");
        }
        this.runBatch(() -> {
            RootNode originalRoot = this._root;
            this._root = (RootNode)root;
            this._root.setModel(this);
            this.fireOperation(new RemoveChildOperation(Path.of(), originalRoot));
            this.fireOperation(new AddChildOperation(Path.of(), this._root));
        });
    }

    public AbstractDocumentNode<?, ?, ?> getNode(Path path) {
        if (Path.of().equals(path)) {
            return this._root;
        }
        SectionNode section = (SectionNode)this._root.getChild(path.getSectionIndex());
        if (section == null) {
            return null;
        }
        DocumentNode<RootNode, BlockNode<?, ?>, SectionStyle> node = section;
        if (path.isInHeader()) {
            node = section.getHeader(path.getPageType());
        } else if (path.isInFooter()) {
            node = section.getFooter(path.getPageType());
        }
        for (int i : path.getRelativePath()) {
            if (node == null) {
                return null;
            }
            node = node.getChild(i);
        }
        return node;
    }

    @Override
    public Path getPath(DocumentNode<?, ?, ?> node) {
        if (node == this._root) {
            return Path.of();
        }
        if (node instanceof AbstractDocumentNode) {
            DocumentNode parent;
            int sectionIndex = -1;
            boolean inHeader = false;
            boolean inFooter = false;
            PageType pageType = null;
            ArrayList<Integer> reversedPath = new ArrayList<Integer>();
            DocumentNode current = (AbstractDocumentNode)node;
            while ((parent = current.getParent()) != null) {
                SectionNode section;
                int index = ((AbstractDocumentNode)parent).getChildren().indexOf(current);
                if (index >= 0) {
                    if (current instanceof SectionNode) {
                        sectionIndex = index;
                    } else {
                        reversedPath.add(index);
                    }
                } else if (current instanceof HeaderNode) {
                    inHeader = true;
                    HeaderNode header = (HeaderNode)current;
                    section = (SectionNode)header.getParent();
                    pageType = section.getPageType(header);
                } else if (current instanceof FooterNode) {
                    inFooter = true;
                    FooterNode footer = (FooterNode)current;
                    section = (SectionNode)footer.getParent();
                    pageType = section.getPageType(footer);
                } else {
                    return null;
                }
                current = parent;
            }
            if (current == this._root) {
                Collections.reverse(reversedPath);
                int[] path = reversedPath.stream().mapToInt(i -> i).toArray();
                if (inHeader) {
                    return Path.ofHeader(sectionIndex, pageType, path);
                }
                if (inFooter) {
                    return Path.ofFooter(sectionIndex, pageType, path);
                }
                return Path.of(sectionIndex, path);
            }
        }
        return null;
    }

    @Override
    public void addListener(DocumentModelListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeListener(DocumentModelListener listener) {
        this._listeners.remove(listener);
    }

    @Override
    @JsonIgnore
    public List<DocumentModelListener> getListeners() {
        return Collections.unmodifiableList(this._listeners);
    }

    @Override
    public void runBatch(boolean fromClient, Runnable r) {
        if (this._batch.get() == null) {
            try {
                this._batch.set(new DefaultDocumentOperationBatch(fromClient));
                r.run();
                this.fireBatch(this._batch.get());
            }
            finally {
                this._batch.remove();
            }
        } else {
            r.run();
        }
    }

    @Override
    public void fireOperation(DocumentOperation operation) {
        this._listeners.forEach(listener -> listener.onOperationChange(operation));
        if (this._batch.get() == null) {
            DefaultDocumentOperationBatch batch = new DefaultDocumentOperationBatch();
            batch.addOperation(operation);
            this.fireBatch(batch);
        } else {
            this._batch.get().addOperation(operation);
        }
    }

    private void fireBatch(DocumentOperationBatch batch) {
        if (Boolean.TRUE.equals(this._shouldNotify.get())) {
            if (Boolean.TRUE.equals(this._shouldAddToHistory.get())) {
                if (!batch.isFromClient()) {
                    this.normalize(batch);
                }
                this.addBatchToHistory(batch);
            }
            this._listeners.forEach(listener -> listener.onBatchChange(batch));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void normalize(DocumentOperationBatch batch) {
        try {
            this._shouldNotify.set(false);
            List<DocumentOperation> operations = batch.getOperations();
            for (int i = 0; i < operations.size(); ++i) {
                InlineNode prev;
                int index;
                SetNodeOperation setNodeOperation;
                DocumentNode<?, ?, ?> node;
                if (!(operations.get(i) instanceof SetNodeOperation) || !((node = (setNodeOperation = (SetNodeOperation)operations.get(i)).getNode()) instanceof TextNode)) continue;
                TextNode curr = (TextNode)node;
                ParagraphNode paragraph = (ParagraphNode)curr.getParent();
                InlineNode next = (InlineNode)paragraph.getChild((index = paragraph.getChildIndex(curr)) + 1);
                if (next instanceof TextNode && ((TextStyle)curr.getStyle()).equals(next.getStyle())) {
                    paragraph.mergeChildToPreviousChild(index + 1);
                }
                if (!((prev = (InlineNode)paragraph.getChild(index - 1)) instanceof TextNode) || !((TextStyle)curr.getStyle()).equals(prev.getStyle())) continue;
                paragraph.mergeChildToPreviousChild(index);
            }
        }
        finally {
            this._shouldNotify.remove();
        }
    }

    @Override
    @JsonIgnore
    public ReadWriteLock getLock() {
        return this._lock;
    }

    @Override
    @JsonIgnore
    public DefaultDocumentRange getSelection() {
        return this._selection;
    }

    @Override
    public void setSelection(DocumentRange selection) {
        this._selection = (DefaultDocumentRange)selection;
        this.fireOperation(selection == null ? new SetSelectionOperation() : new SetSelectionOperation(this.getPath(selection.getStartNode()), selection.getStartOffset(), this.getPath(selection.getEndNode()), selection.getEndOffset()));
    }

    @Override
    public List<DocumentOperationBatch> getRevisionHistory() {
        return this._revisionHistory;
    }

    @Override
    public int getCurrentRevisionIndex() {
        return this._currentRevisionIndex;
    }

    @Override
    public int getMaxRevisionSize() {
        return this._maxRevisionSize;
    }

    @Override
    public void setMaxRevisionSize(int size) {
        this._maxRevisionSize = size;
    }

    private void addBatchToHistory(DocumentOperationBatch batch) {
        while (this._revisionHistory.size() > this._currentRevisionIndex + 1) {
            this._revisionHistory.removeLast();
        }
        while (this._revisionHistory.size() >= this._maxRevisionSize) {
            this._revisionHistory.removeFirst();
        }
        DefaultDocumentOperationBatch currBatch = new DefaultDocumentOperationBatch(batch.isFromClient());
        for (DocumentOperation operation : batch.getOperations()) {
            if (operation instanceof SetSelectionOperation) continue;
            if (batch.isFromClient() && operation instanceof SetNodeOperation) {
                SetNodeOperation setNodeOp = (SetNodeOperation)operation;
                Map<Object, Object> properties = setNodeOp.getProperties();
                Map<Object, Object> newProperties = setNodeOp.getNewProperties();
                List.of("width", "height").forEach(key -> {
                    Object value = properties.get(key);
                    Object newValue = newProperties.get(key);
                    if (value instanceof Double && (Double)value < 0.0 && newValue instanceof Double && (Double)newValue >= 0.0) {
                        properties.remove(key);
                        newProperties.remove(key);
                    }
                });
                if (properties.isEmpty() && newProperties.isEmpty()) continue;
            }
            currBatch.addOperation(operation);
        }
        if (currBatch.getOperations().isEmpty()) {
            return;
        }
        if (this._revisionHistory.isEmpty() || !this.shouldMerge(this._revisionHistory.getLast(), currBatch)) {
            this._revisionHistory.add(currBatch);
        } else {
            this._revisionHistory.getLast().addAllOperations(currBatch);
        }
        this._currentRevisionIndex = this._revisionHistory.size() - 1;
    }

    private boolean shouldMerge(DocumentOperationBatch prevBatch, DocumentOperationBatch currBatch) {
        if (!prevBatch.isFromClient() || !currBatch.isFromClient()) {
            return false;
        }
        if (currBatch.getOperations().size() != 1) {
            return false;
        }
        DocumentOperation lastOp = prevBatch.getOperations().get(prevBatch.getOperations().size() - 1);
        DocumentOperation currOp = currBatch.getOperations().get(0);
        if (lastOp instanceof AddTextOperation && currOp instanceof AddTextOperation) {
            AddTextOperation lastTextOperation = (AddTextOperation)lastOp;
            AddTextOperation currTextOperation = (AddTextOperation)currOp;
            if (lastTextOperation.getPath().equals(currTextOperation.getPath())) {
                return lastTextOperation.getOffset() + lastTextOperation.getText().length() == currTextOperation.getOffset();
            }
        } else if (lastOp instanceof RemoveTextOperation && currOp instanceof RemoveTextOperation) {
            RemoveTextOperation lastTextOperation = (RemoveTextOperation)lastOp;
            RemoveTextOperation currTextOperation = (RemoveTextOperation)currOp;
            if (lastTextOperation.getPath().equals(currTextOperation.getPath())) {
                return lastTextOperation.getOffset() - lastTextOperation.getText().length() == currTextOperation.getOffset();
            }
        }
        return false;
    }

    @Override
    public boolean canUndo() {
        return this.getCurrentBatch() != null;
    }

    @Override
    public void undo() {
        try {
            this._shouldAddToHistory.set(false);
            DocumentOperationBatch batch = this.getCurrentBatch();
            if (batch != null) {
                this.runBatch(() -> {
                    for (int i = batch.getOperations().size() - 1; i >= 0; --i) {
                        AbstractDocumentOperation operation = (AbstractDocumentOperation)batch.getOperations().get(i);
                        AbstractDocumentOperation reversed = operation.reverse();
                        if (reversed == null) continue;
                        reversed.apply(this);
                    }
                });
                --this._currentRevisionIndex;
            }
        }
        finally {
            this._shouldAddToHistory.remove();
        }
    }

    @Override
    public boolean canRedo() {
        return this.getNextBatch() != null;
    }

    @Override
    public void redo() {
        try {
            this._shouldAddToHistory.set(false);
            DocumentOperationBatch batch = this.getNextBatch();
            if (batch != null) {
                this.runBatch(() -> {
                    for (DocumentOperation operation : batch.getOperations()) {
                        if (!(operation instanceof AbstractDocumentOperation)) continue;
                        AbstractDocumentOperation abstractOperation = (AbstractDocumentOperation)operation;
                        abstractOperation.apply(this);
                    }
                });
                ++this._currentRevisionIndex;
            }
        }
        finally {
            this._shouldAddToHistory.remove();
        }
    }

    @Override
    public void clearRevisionHistory() {
        this._currentRevisionIndex = -1;
        this._revisionHistory.clear();
    }

    private DocumentOperationBatch getCurrentBatch() {
        return this.getBatch(this._currentRevisionIndex);
    }

    private DocumentOperationBatch getNextBatch() {
        return this.getBatch(this._currentRevisionIndex + 1);
    }

    private DocumentOperationBatch getBatch(int index) {
        return index < 0 || index >= this._revisionHistory.size() ? null : this._revisionHistory.get(index);
    }
}

