/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.editor;

import io.keikai.doc.api.DocumentNode;
import io.keikai.doc.api.editor.View;
import io.keikai.doc.api.impl.node.AbstractDocumentNode;
import io.keikai.doc.api.impl.node.DefaultDocumentRange;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.TextNode;
import io.keikai.doc.api.impl.node.style.ParagraphStyle;
import io.keikai.doc.api.impl.node.style.TextStyle;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class SelectionView
extends View<AbstractDocumentNode<?, ?, ?>> {
    private final DefaultDocumentRange _range;

    protected SelectionView(DefaultDocumentRange range) {
        super(null);
        this._range = range;
    }

    public boolean allTextStylesMatched(Predicate<TextStyle> predicate) {
        return this._range.getNodes(TextNode.class).stream().allMatch(node -> predicate.test((TextStyle)node.getStyle()));
    }

    public <T> boolean allTextStylesMatched(Function<TextStyle, T> function) {
        return this._range.getNodes(TextNode.class).stream().map(node -> function.apply((TextStyle)node.getStyle())).distinct().count() == 1L;
    }

    public <T> T getStartTextNodeStyle(Function<TextStyle, T> function) {
        return Optional.ofNullable((TextStyle)this._range.getStartNode().getStyle()).map(function).orElse(null);
    }

    public <T> boolean allParagraphStyleMatched(Function<ParagraphStyle, T> function) {
        return this._range.getNodes(ParagraphNode.class).stream().map(node -> function.apply((ParagraphStyle)node.getStyle())).distinct().count() == 1L;
    }

    public <T> T getStartParagraphStyle(Function<ParagraphStyle, T> function) {
        DocumentNode<ParagraphNode, TextNode, TextStyle> parent = this._range.getStartNode();
        while (!(parent instanceof ParagraphNode)) {
            parent = parent.getParent();
        }
        return Optional.ofNullable((ParagraphStyle)((ParagraphNode)parent).getStyle()).map(function).orElse(null);
    }

    public boolean isRange() {
        return this._range.getStartNode() != this._range.getEndNode() || this._range.getStartOffset() != this._range.getEndOffset();
    }
}

