/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.editor;

import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.Point;
import io.keikai.doc.api.editor.BlockCommand;
import io.keikai.doc.api.editor.Command;
import io.keikai.doc.api.impl.model.DefaultDocumentModel;
import io.keikai.doc.api.impl.node.FooterNode;
import io.keikai.doc.api.impl.node.HeaderNode;
import io.keikai.doc.api.impl.node.PageType;
import io.keikai.doc.api.impl.node.SectionNode;
import io.keikai.doc.api.impl.node.style.SectionStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public class SectionCommand
extends Command<SectionNode> {
    protected SectionCommand(BiFunction<DocumentModel, Point, List<SectionNode>> finder) {
        super(finder);
    }

    protected SectionCommand(boolean atSelection, BiFunction<DocumentModel, Point, List<SectionNode>> finder) {
        super(atSelection, finder);
    }

    protected SectionCommand(Command<SectionNode> command) {
        super(command);
    }

    private SectionCommand withAction(Consumer<SectionNode> consumer) {
        SectionCommand command = new SectionCommand(this);
        command.addAction(consumer);
        return command;
    }

    public SectionCommand header(PageType type, BlockCommand<?> ... commands) {
        return this.withAction(section -> {
            DefaultDocumentModel model = section.getModel();
            ArrayList blocks = new ArrayList();
            for (BlockCommand command : commands) {
                blocks.addAll(command.execute(model, null));
            }
            section.setHeader(type, new HeaderNode(blocks));
        });
    }

    public SectionCommand removeHeader(PageType type) {
        return this.withAction(section -> section.setHeader(type, null));
    }

    public SectionCommand footer(PageType type, BlockCommand<?> ... commands) {
        return this.withAction(section -> {
            DefaultDocumentModel model = section.getModel();
            ArrayList blocks = new ArrayList();
            for (BlockCommand command : commands) {
                blocks.addAll(command.execute(model, null));
            }
            section.setFooter(type, new FooterNode(blocks));
        });
    }

    public SectionCommand removeFooter(PageType type) {
        return this.withAction(section -> section.setFooter(type, null));
    }

    public SectionCommand style(UnaryOperator<SectionStyle> mapper) {
        return this.withAction(section -> section.setStyle((SectionStyle)mapper.apply((SectionStyle)section.getStyle())));
    }
}

