/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.editor;

import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.DocumentNode;
import io.keikai.doc.api.Point;
import io.keikai.doc.api.editor.BlockCommand;
import io.keikai.doc.api.editor.Command;
import io.keikai.doc.api.editor.ParagraphView;
import io.keikai.doc.api.impl.node.ComponentNode;
import io.keikai.doc.api.impl.node.DocumentNodeLazyIterator;
import io.keikai.doc.api.impl.node.DocumentNodeVisitor;
import io.keikai.doc.api.impl.node.PageNumberNode;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.TextNode;
import io.keikai.doc.api.impl.node.style.ComponentStyle;
import io.keikai.doc.api.impl.node.style.ParagraphStyle;
import io.keikai.doc.api.impl.node.style.TextStyle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.Component;

public class ParagraphCommand
extends BlockCommand<ParagraphNode> {
    protected ParagraphCommand(BiFunction<DocumentModel, Point, List<ParagraphNode>> finder) {
        super(finder);
    }

    protected ParagraphCommand(boolean atSelection, BiFunction<DocumentModel, Point, List<ParagraphNode>> finder) {
        super(atSelection, finder);
    }

    protected ParagraphCommand(Command<ParagraphNode> command) {
        super(command);
    }

    private ParagraphCommand withAction(Consumer<ParagraphNode> consumer) {
        ParagraphCommand command = new ParagraphCommand(this);
        command.addAction(consumer);
        return command;
    }

    public ParagraphCommand text(String text) {
        return this.withAction(paragraph -> {
            final TextNode[] last = new TextNode[1];
            paragraph.accept(new DocumentNodeVisitor<Void>(){

                @Override
                public Void visit(TextNode node) {
                    last[0] = node;
                    return (Void)DocumentNodeVisitor.super.visit(node);
                }
            });
            last[0].addText(last[0].getText().length(), text);
        });
    }

    public ParagraphCommand text(ToIntFunction<String> offset, String text) {
        return this.withAction(paragraph -> {
            StringBuilder builder = new StringBuilder();
            int startOffset = offset.applyAsInt(new ParagraphView((ParagraphNode)paragraph).getText());
            Iterator iterator = new DocumentNodeLazyIterator((DocumentNode<?, ?, ?>)paragraph).stream().filter(TextNode.class::isInstance).map(TextNode.class::cast).iterator();
            while (iterator.hasNext()) {
                TextNode node = (TextNode)iterator.next();
                int nodeStart = builder.length();
                int nodeEnd = builder.append(node.getText()).length();
                if (nodeStart > startOffset || startOffset > nodeEnd) continue;
                node.addText(startOffset - nodeStart, text);
                break;
            }
        });
    }

    public ParagraphCommand removeText(Function<String, Pair<Integer, Integer>> offsets) {
        return this.withAction(paragraph -> {
            StringBuilder builder = new StringBuilder();
            Pair pair = (Pair)offsets.apply(new ParagraphView((ParagraphNode)paragraph).getText());
            Iterator iterator = new DocumentNodeLazyIterator((DocumentNode<?, ?, ?>)paragraph).stream().filter(TextNode.class::isInstance).map(TextNode.class::cast).iterator();
            while (iterator.hasNext()) {
                TextNode node = (TextNode)iterator.next();
                int nodeStart = builder.length();
                int nodeEnd = builder.append(node.getText()).length();
                if ((Integer)pair.x <= nodeStart && nodeEnd <= (Integer)pair.y) {
                    ((ParagraphNode)node.getParent()).removeChild(node);
                    continue;
                }
                if ((Integer)pair.x <= nodeStart && nodeStart < (Integer)pair.y) {
                    node.removeText(0, (Integer)pair.y - nodeStart);
                    continue;
                }
                if ((Integer)pair.x < nodeEnd && nodeEnd <= (Integer)pair.y) {
                    node.removeText((Integer)pair.x - nodeStart, nodeEnd - nodeStart);
                    continue;
                }
                if ((Integer)pair.y > nodeStart) continue;
                break;
            }
            if (paragraph.getChildCount() == 0) {
                paragraph.addChild(new TextNode(""));
            }
        });
    }

    public ParagraphCommand component(Component component) {
        return this.component(component, UnaryOperator.identity());
    }

    public ParagraphCommand component(Component component, UnaryOperator<ComponentStyle> mapper) {
        return this.withAction(paragraph -> {
            ComponentStyle style = (ComponentStyle)mapper.apply(ComponentStyle.DEFAULT);
            ComponentStyle.TextWrap wrap = style.getTextWrap();
            ComponentNode componentNode = new ComponentNode(component, style);
            if (ComponentStyle.TextWrap.INLINE.equals((Object)wrap) || ComponentStyle.TextWrap.BREAK_TEXT.equals((Object)wrap)) {
                paragraph.addChild(componentNode);
                paragraph.addChild(new TextNode(""));
            } else {
                paragraph.addChild(0, componentNode);
            }
        });
    }

    public ParagraphCommand component(ToIntFunction<String> offset, Component component) {
        return this.component(offset, component, UnaryOperator.identity());
    }

    public ParagraphCommand component(ToIntFunction<String> offset, Component component, UnaryOperator<ComponentStyle> mapper) {
        ComponentStyle style = (ComponentStyle)mapper.apply(ComponentStyle.DEFAULT);
        ComponentStyle.TextWrap wrap = style.getTextWrap();
        if (ComponentStyle.TextWrap.INLINE.equals((Object)wrap) || ComponentStyle.TextWrap.BREAK_TEXT.equals((Object)wrap)) {
            return this.withAction(paragraph -> {
                StringBuilder builder = new StringBuilder();
                int startOffset = offset.applyAsInt(new ParagraphView((ParagraphNode)paragraph).getText());
                Iterator iterator = new DocumentNodeLazyIterator((DocumentNode<?, ?, ?>)paragraph).stream().filter(TextNode.class::isInstance).map(TextNode.class::cast).iterator();
                while (iterator.hasNext()) {
                    TextNode node = (TextNode)iterator.next();
                    int nodeStart = builder.length();
                    int nodeEnd = builder.append(node.getText()).length();
                    if (nodeStart > startOffset || startOffset > nodeEnd) continue;
                    int index = paragraph.getChildIndex(node);
                    paragraph.splitChildToPreviousChild(index, startOffset - nodeStart);
                    paragraph.addChild(index + 1, new ComponentNode(component, style));
                    break;
                }
            });
        }
        return this.component(component, mapper);
    }

    public ParagraphCommand pageNumber() {
        return this.withAction(paragraph -> {
            paragraph.addChild(new PageNumberNode());
            paragraph.addChild(new TextNode(""));
        });
    }

    public ParagraphCommand pageNumber(final int startOffset) {
        return this.withAction(paragraph -> paragraph.accept(new DocumentNodeVisitor<Void>(){
            private boolean _inserted;
            private final StringBuilder _builder = new StringBuilder();

            @Override
            public Void visit(TextNode node) {
                if (this._inserted) {
                    return null;
                }
                int nodeStart = this._builder.length();
                int nodeEnd = this._builder.append(node.getText()).length();
                if (nodeStart <= startOffset && startOffset <= nodeEnd) {
                    int index = paragraph.getChildIndex(node);
                    paragraph.splitChildToPreviousChild(index, startOffset - nodeStart);
                    paragraph.addChild(index + 1, new PageNumberNode());
                    this._inserted = true;
                }
                return (Void)DocumentNodeVisitor.super.visit(node);
            }
        }));
    }

    public ParagraphCommand style(UnaryOperator<ParagraphStyle> mapper) {
        return this.withAction(paragraph -> paragraph.setStyle((ParagraphStyle)mapper.apply((ParagraphStyle)paragraph.getStyle())));
    }

    public ParagraphCommand style(final int startOffset, final int endOffset, UnaryOperator<TextStyle> mapper) {
        return this.withAction(paragraph -> {
            final ArrayList texts = new ArrayList();
            final ArrayList runnables = new ArrayList();
            paragraph.accept(new DocumentNodeVisitor<Void>(){
                private final StringBuilder _builder = new StringBuilder();

                @Override
                public Void visit(TextNode node) {
                    int nodeStart = this._builder.length();
                    int nodeEnd = this._builder.append(node.getText()).length();
                    if (nodeStart <= startOffset && endOffset <= nodeEnd || startOffset <= nodeStart && nodeStart < endOffset || startOffset < nodeEnd && nodeEnd <= endOffset) {
                        int index;
                        ParagraphNode parent;
                        int runnableCount = runnables.size();
                        if (endOffset < nodeEnd) {
                            parent = (ParagraphNode)node.getParent();
                            index = parent.getChildIndex(node);
                            runnables.add(() -> {
                                parent.splitChildToPreviousChild(index, endOffset - nodeStart);
                                texts.add((TextNode)parent.getChild(index));
                            });
                        }
                        if (nodeStart < startOffset) {
                            parent = (ParagraphNode)node.getParent();
                            index = parent.getChildIndex(node);
                            runnables.add(() -> {
                                parent.splitChildToPreviousChild(index, startOffset - nodeStart);
                                texts.add((TextNode)parent.getChild(index + 1));
                            });
                        }
                        if (runnables.size() == runnableCount) {
                            texts.add(node);
                        }
                    }
                    return (Void)DocumentNodeVisitor.super.visit(node);
                }
            });
            runnables.forEach(Runnable::run);
            texts.forEach(text -> text.setStyle((TextStyle)mapper.apply((TextStyle)text.getStyle())));
        });
    }

    public ParagraphCommand attr(Object key, Object value) {
        return this.withAction(paragraph -> paragraph.addAttribute(key, value));
    }

    public ParagraphCommand removeAttr(Object key) {
        return this.withAction(paragraph -> paragraph.removeAttribute(key));
    }
}

