/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.editor;

import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.DocumentNode;
import io.keikai.doc.api.DocumentOperationBatch;
import io.keikai.doc.api.DocumentRange;
import io.keikai.doc.api.DocumentSelectableModel;
import io.keikai.doc.api.DocumentUndoableModel;
import io.keikai.doc.api.Path;
import io.keikai.doc.api.Point;
import io.keikai.doc.api.editor.Command;
import io.keikai.doc.api.editor.ComponentView;
import io.keikai.doc.api.editor.ParagraphView;
import io.keikai.doc.api.editor.SectionView;
import io.keikai.doc.api.editor.SelectionView;
import io.keikai.doc.api.editor.TableView;
import io.keikai.doc.api.editor.View;
import io.keikai.doc.api.impl.node.ComponentNode;
import io.keikai.doc.api.impl.node.ContainerNode;
import io.keikai.doc.api.impl.node.DefaultDocumentRange;
import io.keikai.doc.api.impl.node.DocumentNodeLazyIterator;
import io.keikai.doc.api.impl.node.PageBreakNode;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.RootNode;
import io.keikai.doc.api.impl.node.SectionNode;
import io.keikai.doc.api.impl.node.TableNode;
import io.keikai.doc.api.impl.node.TextNode;
import io.keikai.doc.api.impl.util.ObjectMapperUtil;
import io.keikai.doc.ui.Docpad;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.zkoss.json.JSONObject;
import org.zkoss.zk.ui.UiException;

public class Editor {
    private final Docpad _docpad;
    private final DocumentModel _model;

    private Editor(Docpad docpad) {
        this._docpad = docpad;
        this._model = null;
    }

    private Editor(DocumentModel model) {
        this._docpad = null;
        this._model = model;
    }

    public static Editor getInstance(Docpad docpad) {
        return new Editor(docpad);
    }

    public static Editor getInstance(DocumentModel model) {
        return new Editor(model);
    }

    private DocumentModel getModel() {
        return this._docpad == null ? this._model : this._docpad.getModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R getInReadLock(Supplier<R> supplier) {
        ReadWriteLock lock = this.getModel().getLock();
        lock.readLock().lock();
        try {
            R r = supplier.get();
            return r;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R runInWriteLock(Supplier<R> supplier) {
        ReadWriteLock lock = this.getModel().getLock();
        lock.writeLock().lock();
        try {
            R r = supplier.get();
            return r;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private void runInWriteLock(Runnable runnable) {
        this.runInWriteLock(() -> {
            runnable.run();
            return null;
        });
    }

    public JSONObject toJSON() {
        return this.getInReadLock(() -> this.getModel().toJSON());
    }

    public void loadJSON(JSONObject json) {
        this.runInWriteLock(() -> this.getModel().loadJSON(json));
    }

    public void loadJSON(String json) {
        this.loadJSON(ObjectMapperUtil.readJSON(json));
    }

    public void loadJSON(InputStream is) {
        this.loadJSON(ObjectMapperUtil.readJSON(is));
    }

    public void loadJSON(File file) {
        this.loadJSON(ObjectMapperUtil.readJSON(file));
    }

    public void execute(Command<?> ... commands) {
        JSONObject json = this.toJSON();
        this.runInWriteLock(() -> {
            AtomicInteger commandIdx = new AtomicInteger();
            try {
                DocumentModel model = this.getModel();
                model.runBatch(() -> {
                    Point point = null;
                    boolean hasSelection = false;
                    DocumentNode lastInsertion = null;
                    commandIdx.set(0);
                    while (commandIdx.get() < commands.length) {
                        DocumentNode node2;
                        Path path;
                        Command command = commands[commandIdx.get()];
                        if (command.isAtSelection() && point == null) {
                            DocumentRange selection;
                            RootNode root = (RootNode)model.getRoot();
                            SectionNode section = (SectionNode)root.getChild(root.getChildCount() - 1);
                            point = Point.of(model.getPath(section).getChild(section.getChildCount()), -1);
                            if (model instanceof DocumentSelectableModel && (selection = ((DocumentSelectableModel)((Object)model)).getSelection()) instanceof DefaultDocumentRange) {
                                hasSelection = true;
                                int startOffset = selection.getStartOffset();
                                int endOffset = selection.getEndOffset();
                                point = Point.of(model.getPath(selection.getStartNode()), startOffset);
                                if (selection.getStartNode() != selection.getEndNode() || startOffset != endOffset) {
                                    List<TextNode> nodes = ((DefaultDocumentRange)selection).getNodes(TextNode.class);
                                    nodes.forEach(node -> {
                                        node.removeText(node == selection.getStartNode() ? startOffset : 0, node == selection.getEndNode() ? endOffset : node.getText().length());
                                        ParagraphNode parent = (ParagraphNode)node.getParent();
                                        if (new ParagraphView((ParagraphNode)node.getParent()).getText().isEmpty()) {
                                            ((ContainerNode)parent.getParent()).removeChild(parent);
                                        }
                                    });
                                }
                            }
                        }
                        List nodes = command.execute(model, point);
                        if (command.isAtSelection() && (path = model.getPath(node2 = (DocumentNode)nodes.get(0))) != null) {
                            lastInsertion = node2;
                            point = Point.of(path.getNextSibling(), -1);
                        }
                        commandIdx.getAndIncrement();
                    }
                    if (model instanceof DocumentSelectableModel && hasSelection && lastInsertion != null) {
                        if (lastInsertion instanceof PageBreakNode) {
                            PageBreakNode pageBreak = (PageBreakNode)lastInsertion;
                            ContainerNode parent = (ContainerNode)pageBreak.getParent();
                            lastInsertion = parent.getChild(parent.getChildIndex(pageBreak) + 1);
                        }
                        new DocumentNodeLazyIterator(lastInsertion).stream().filter(TextNode.class::isInstance).map(TextNode.class::cast).findFirst().ifPresent(textNode -> ((DocumentSelectableModel)((Object)model)).setSelection(new DefaultDocumentRange((TextNode)textNode, 0, (TextNode)textNode, 0)));
                    }
                });
            }
            catch (Exception e) {
                this.loadJSON(json);
                throw new UiException("Failed to execute commands[" + commandIdx + "].", (Throwable)e);
            }
        });
    }

    public void undo() {
        DocumentUndoableModel undoableModel;
        DocumentModel model = this.getModel();
        if (model instanceof DocumentUndoableModel && (undoableModel = (DocumentUndoableModel)((Object)model)).canUndo()) {
            this.runInWriteLock(undoableModel::undo);
        }
    }

    public void redo() {
        DocumentUndoableModel undoableModel;
        DocumentModel model = this.getModel();
        if (model instanceof DocumentUndoableModel && (undoableModel = (DocumentUndoableModel)((Object)model)).canRedo()) {
            this.runInWriteLock(undoableModel::redo);
        }
    }

    public List<DocumentOperationBatch> getRevisionHistory() {
        DocumentModel model = this.getModel();
        if (model instanceof DocumentUndoableModel) {
            DocumentUndoableModel undoableModel = (DocumentUndoableModel)((Object)model);
            return this.getInReadLock(undoableModel::getRevisionHistory);
        }
        return List.of();
    }

    public int getCurrentRevisionIndex() {
        DocumentModel model = this.getModel();
        if (model instanceof DocumentUndoableModel) {
            DocumentUndoableModel undoableModel = (DocumentUndoableModel)((Object)model);
            return this.getInReadLock(undoableModel::getCurrentRevisionIndex);
        }
        return -1;
    }

    public void clearRevisionHistory() {
        DocumentModel model = this.getModel();
        if (model instanceof DocumentUndoableModel) {
            DocumentUndoableModel undoableModel = (DocumentUndoableModel)((Object)model);
            this.runInWriteLock(undoableModel::clearRevisionHistory);
        }
    }

    public void loadRevision(int revisionIndex) {
        DocumentModel model = this.getModel();
        if (model instanceof DocumentUndoableModel) {
            DocumentUndoableModel undoableModel = (DocumentUndoableModel)((Object)model);
            this.runInWriteLock(() -> {
                if (revisionIndex == undoableModel.getCurrentRevisionIndex()) {
                    return;
                }
                if (revisionIndex < 0 || revisionIndex >= undoableModel.getRevisionHistory().size()) {
                    throw new IndexOutOfBoundsException("Revision index out of bounds: " + revisionIndex);
                }
                while (revisionIndex < undoableModel.getCurrentRevisionIndex()) {
                    undoableModel.undo();
                }
                while (revisionIndex > undoableModel.getCurrentRevisionIndex()) {
                    undoableModel.redo();
                }
            });
        }
    }

    private Stream<SectionView> getSectionsWithoutLock() {
        return this.getModel().getRoot().getChildren().stream().map(SectionNode.class::cast).map(SectionView::new);
    }

    public Stream<SectionView> getSections() {
        return this.getInReadLock(this::getSectionsWithoutLock);
    }

    public Stream<ParagraphView> getDirectParagraphs() {
        return this.getInReadLock(() -> this.getSectionsWithoutLock().flatMap(View::getDirectParagraphs));
    }

    public Stream<ParagraphView> getParagraphs() {
        return this.getInReadLock(() -> this.getSectionsWithoutLock().flatMap(View::getParagraphs));
    }

    public Stream<ParagraphView> getParagraphsByAttr(Object key) {
        return this.getInReadLock(() -> this.getSectionsWithoutLock().flatMap(View::getParagraphs).filter(view -> ((ParagraphNode)view.getNode()).getAttributes().containsKey(key)));
    }

    public Stream<ComponentView> getDirectComponents() {
        return this.getInReadLock(() -> this.getSectionsWithoutLock().flatMap(View::getDirectComponents));
    }

    public Stream<ComponentView> getComponents() {
        return this.getInReadLock(() -> this.getSectionsWithoutLock().flatMap(View::getComponents));
    }

    public Stream<ComponentView> getComponentsByAttr(Object key) {
        return this.getInReadLock(() -> this.getSectionsWithoutLock().flatMap(View::getComponents).filter(view -> ((ComponentNode)view.getNode()).getAttributes().containsKey(key)));
    }

    public Stream<TableView> getDirectTables() {
        return this.getInReadLock(() -> this.getSectionsWithoutLock().flatMap(View::getDirectTables));
    }

    public Stream<TableView> getTables() {
        return this.getInReadLock(() -> this.getSectionsWithoutLock().flatMap(View::getTables));
    }

    public Stream<TableView> getTablesByAttr(String key) {
        return this.getInReadLock(() -> this.getSectionsWithoutLock().flatMap(View::getTables).filter(view -> ((TableNode)view.getNode()).getAttributes().containsKey(key)));
    }

    public SelectionView getSelection() {
        DocumentModel model = this.getModel();
        if (model instanceof DocumentSelectableModel) {
            DocumentSelectableModel selectableModel = (DocumentSelectableModel)((Object)model);
            return this.getInReadLock(() -> {
                DocumentRange selection = selectableModel.getSelection();
                return selection instanceof DefaultDocumentRange ? new SelectionView((DefaultDocumentRange)selection) : null;
            });
        }
        return null;
    }
}

