/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.editor;

import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.DocumentNode;
import io.keikai.doc.api.DocumentSelectableModel;
import io.keikai.doc.api.Path;
import io.keikai.doc.api.Point;
import io.keikai.doc.api.editor.BlockCommand;
import io.keikai.doc.api.editor.BlockView;
import io.keikai.doc.api.editor.Command;
import io.keikai.doc.api.editor.ComponentCommand;
import io.keikai.doc.api.editor.ComponentView;
import io.keikai.doc.api.editor.ContainerView;
import io.keikai.doc.api.editor.ParagraphCommand;
import io.keikai.doc.api.editor.ParagraphView;
import io.keikai.doc.api.editor.SectionCommand;
import io.keikai.doc.api.editor.SectionView;
import io.keikai.doc.api.editor.SelectionCommand;
import io.keikai.doc.api.editor.TableCommand;
import io.keikai.doc.api.editor.TableView;
import io.keikai.doc.api.editor.View;
import io.keikai.doc.api.impl.node.BlockNode;
import io.keikai.doc.api.impl.node.ComponentNode;
import io.keikai.doc.api.impl.node.ContainerNode;
import io.keikai.doc.api.impl.node.DefaultDocumentNodeFactory;
import io.keikai.doc.api.impl.node.DefaultDocumentRange;
import io.keikai.doc.api.impl.node.DocumentNodeLazyIterator;
import io.keikai.doc.api.impl.node.PageBreakNode;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.RootNode;
import io.keikai.doc.api.impl.node.SectionNode;
import io.keikai.doc.api.impl.node.TableNode;
import io.keikai.doc.api.impl.node.TextNode;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.zkoss.zk.ui.UiException;

public class Commands {
    private Commands() {
    }

    private static <T extends BlockNode<?, ?>> List<T> insertBlock(T block, DocumentModel model, Point point) {
        if (point == null) {
            return List.of(block);
        }
        if (point.getOffset() < 0) {
            Path path = point.getPath();
            DocumentNode<?, ?, ?> parent = model.getNode(path.getParent());
            if (parent instanceof ContainerNode) {
                ((ContainerNode)parent).addChild(path.getLastIndex(), block);
                return List.of(block);
            }
            throw new UiException("The parent at " + path.getParent() + " is not a container");
        }
        TextNode text = (TextNode)model.getNode(point.getPath());
        ParagraphNode paragraph = (ParagraphNode)text.getParent();
        int textIdx = paragraph.getChildIndex(text);
        ContainerNode container = (ContainerNode)paragraph.getParent();
        int paragraphIdx = container.getChildIndex(paragraph);
        if (point.getOffset() > 0 && point.getOffset() < text.getText().length()) {
            paragraph.splitChildToPreviousChild(textIdx, point.getOffset());
            container.splitChildToPreviousChild(paragraphIdx, textIdx + 1);
        }
        container.addChild(point.getOffset() == 0 ? paragraphIdx : paragraphIdx + 1, block);
        return List.of(block);
    }

    private static <T extends BlockNode<?, ?>> List<T> insertSiblingBlock(T block, Supplier<BlockView<?>> supplier, boolean beforeBegin) {
        BlockNode sibling = (BlockNode)supplier.get().getNode();
        ContainerNode container = (ContainerNode)sibling.getParent();
        int index = container.getChildIndex(sibling);
        container.addChild(beforeBegin ? index : index + 1, block);
        return List.of(block);
    }

    private static <T extends BlockNode<?, ?>> List<T> insertChildBlock(T block, Supplier<ContainerView<?>> supplier, boolean afterBegin) {
        ContainerNode container = (ContainerNode)supplier.get().getNode();
        container.addChild(afterBegin ? 0 : container.getChildCount(), block);
        return List.of(block);
    }

    public static ParagraphCommand findParagraph(Supplier<ParagraphView> supplier) {
        return new ParagraphCommand((model, unused) -> List.of((ParagraphNode)((ParagraphView)supplier.get()).getNode()));
    }

    public static ParagraphCommand findParagraphs(Supplier<Stream<ParagraphView>> supplier) {
        return new ParagraphCommand((model, unused) -> ((Stream)supplier.get()).map(View::getNode).collect(Collectors.toList()));
    }

    public static ParagraphCommand paragraph(String text) {
        return new ParagraphCommand(true, (model, point) -> Commands.insertBlock(new ParagraphNode(text), model, point));
    }

    public static ParagraphCommand paragraphBeforeBegin(Supplier<BlockView<?>> supplier, String text) {
        return new ParagraphCommand((model, unused) -> Commands.insertSiblingBlock(new ParagraphNode(text), supplier, true));
    }

    public static ParagraphCommand paragraphAfterBegin(Supplier<ContainerView<?>> supplier, String text) {
        return new ParagraphCommand((model, unused) -> Commands.insertChildBlock(new ParagraphNode(text), supplier, true));
    }

    public static ParagraphCommand paragraphBeforeEnd(Supplier<ContainerView<?>> supplier, String text) {
        return new ParagraphCommand((model, unused) -> Commands.insertChildBlock(new ParagraphNode(text), supplier, false));
    }

    public static ParagraphCommand paragraphAfterEnd(Supplier<BlockView<?>> supplier, String text) {
        return new ParagraphCommand((model, unused) -> Commands.insertSiblingBlock(new ParagraphNode(text), supplier, false));
    }

    public static ComponentCommand findComponent(Supplier<ComponentView> supplier) {
        return new ComponentCommand((model, unused) -> List.of((ComponentNode)((ComponentView)supplier.get()).getNode()));
    }

    public static ComponentCommand findComponents(Supplier<Stream<ComponentView>> supplier) {
        return new ComponentCommand((model, unused) -> ((Stream)supplier.get()).map(View::getNode).collect(Collectors.toList()));
    }

    public static TableCommand findTable(Supplier<TableView> supplier) {
        return new TableCommand((model, unused) -> List.of((TableNode)((TableView)supplier.get()).getNode()));
    }

    public static TableCommand findTables(Supplier<Stream<TableView>> supplier) {
        return new TableCommand((model, unused) -> ((Stream)supplier.get()).map(View::getNode).collect(Collectors.toList()));
    }

    private static String[][] newStringArr(int numRows, int numCols) {
        String[][] arr;
        for (Object[] objectArray : arr = new String[numRows][numCols]) {
            Arrays.fill(objectArray, "");
        }
        return arr;
    }

    public static TableCommand table(int numRows, int numCols) {
        return Commands.table(Commands.newStringArr(numRows, numCols));
    }

    public static TableCommand table(String[][] data) {
        return new TableCommand(true, (model, point) -> Commands.insertBlock(new TableNode(data), model, point));
    }

    public static TableCommand tableBeforeBegin(Supplier<BlockView<?>> supplier, int numRows, int numCols) {
        return Commands.tableBeforeBegin(supplier, Commands.newStringArr(numRows, numCols));
    }

    public static TableCommand tableBeforeBegin(Supplier<BlockView<?>> supplier, String[][] data) {
        return new TableCommand((model, unused) -> Commands.insertSiblingBlock(new TableNode(data), supplier, true));
    }

    public static TableCommand tableAfterBegin(Supplier<ContainerView<?>> supplier, int numRows, int numCols) {
        return Commands.tableAfterBegin(supplier, Commands.newStringArr(numRows, numCols));
    }

    public static TableCommand tableAfterBegin(Supplier<ContainerView<?>> supplier, String[][] data) {
        return new TableCommand((model, unused) -> Commands.insertChildBlock(new TableNode(data), supplier, true));
    }

    public static TableCommand tableBeforeEnd(Supplier<ContainerView<?>> target, int numRows, int numCols) {
        return Commands.tableBeforeEnd(target, Commands.newStringArr(numRows, numCols));
    }

    public static TableCommand tableBeforeEnd(Supplier<ContainerView<?>> target, String[][] data) {
        return new TableCommand((model, unused) -> Commands.insertChildBlock(new TableNode(data), target, false));
    }

    public static TableCommand tableAfterEnd(Supplier<BlockView<?>> target, int numRows, int numCols) {
        return Commands.tableAfterEnd(target, Commands.newStringArr(numRows, numCols));
    }

    public static TableCommand tableAfterEnd(Supplier<BlockView<?>> target, String[][] data) {
        return new TableCommand((model, unused) -> Commands.insertSiblingBlock(new TableNode(data), target, false));
    }

    private static List<PageBreakNode> insertPageBreakWithinTable(DocumentModel model, Path path) {
        PageBreakNode node = new PageBreakNode();
        int[] relativePath = path.getRelativePath();
        if (relativePath.length < 2) {
            return null;
        }
        Path blockPath = Path.of(path.getSectionIndex(), relativePath[0]);
        BlockNode block = (BlockNode)model.getNode(blockPath);
        if (block instanceof TableNode) {
            TableNode table = (TableNode)block;
            ContainerNode section = (ContainerNode)table.getParent();
            int tableIdx = section.getChildIndex(table);
            TableView tableView = new TableView(table);
            int rowIdx = relativePath[1];
            int lastColIdx = tableView.getColCount() - 1;
            int splitRowIdx = tableView.getZFlattenedCells(rowIdx, 0, rowIdx, lastColIdx).stream().mapToInt(c -> c.getMerger() == null ? c.getRow() : c.getMerger().getRow()).min().orElse(rowIdx);
            if (splitRowIdx == 0) {
                section.addChild(tableIdx, node);
                return List.of(node);
            }
            section.splitChildToPreviousChild(tableIdx, splitRowIdx);
            section.addChild(tableIdx + 1, node);
            return List.of(node);
        }
        return null;
    }

    public static Command<PageBreakNode> pageBreak() {
        return new Command<PageBreakNode>(true, (model, point) -> Optional.ofNullable(Commands.insertPageBreakWithinTable(model, point.getPath())).orElseGet(() -> Commands.insertBlock(new PageBreakNode(), model, point)));
    }

    public static Command<PageBreakNode> pageBreakBeforeBegin(Supplier<BlockView<?>> supplier) {
        return new Command<PageBreakNode>((model, unused) -> {
            Path path = model.getPath((DocumentNode<?, ?, ?>)((BlockView)supplier.get()).getNode());
            return Optional.ofNullable(Commands.insertPageBreakWithinTable(model, path)).orElseGet(() -> Commands.lambda$pageBreakBeforeBegin$19((Supplier)supplier));
        });
    }

    public static Command<PageBreakNode> pageBreakAfterBegin(Supplier<ContainerView<?>> supplier) {
        return new Command<PageBreakNode>((model, unused) -> {
            Path path = model.getPath((DocumentNode<?, ?, ?>)((ContainerView)supplier.get()).getNode()).getChild(0);
            return Optional.ofNullable(Commands.insertPageBreakWithinTable(model, path)).orElseGet(() -> Commands.lambda$pageBreakAfterBegin$21((Supplier)supplier));
        });
    }

    public static Command<PageBreakNode> pageBreakBeforeEnd(Supplier<ContainerView<?>> supplier) {
        return new Command<PageBreakNode>((model, unused) -> {
            ContainerNode container = (ContainerNode)((ContainerView)supplier.get()).getNode();
            Path path = model.getPath(container).getChild(container.getChildCount());
            return Optional.ofNullable(Commands.insertPageBreakWithinTable(model, path)).orElseGet(() -> Commands.lambda$pageBreakBeforeEnd$23((Supplier)supplier));
        });
    }

    public static Command<PageBreakNode> pageBreakAfterEnd(Supplier<BlockView<?>> supplier) {
        return new Command<PageBreakNode>((model, unused) -> {
            Path path = model.getPath((DocumentNode<?, ?, ?>)((BlockView)supplier.get()).getNode()).getNextSibling();
            return Optional.ofNullable(Commands.insertPageBreakWithinTable(model, path)).orElseGet(() -> Commands.lambda$pageBreakAfterEnd$25((Supplier)supplier));
        });
    }

    public static SectionCommand findSection(Supplier<SectionView> supplier) {
        return new SectionCommand((model, unused) -> List.of((SectionNode)((SectionView)supplier.get()).getNode()));
    }

    public static SectionCommand findSections(Supplier<Stream<SectionView>> supplier) {
        return new SectionCommand((model, unused) -> ((Stream)supplier.get()).map(View::getNode).collect(Collectors.toList()));
    }

    private static List<SectionNode> insertSectionBreak(DocumentModel model, Point point) {
        TextNode text = (TextNode)model.getNode(point.getPath());
        ParagraphNode paragraph = (ParagraphNode)text.getParent();
        int textIdx = paragraph.getChildIndex(text);
        SectionNode section = (SectionNode)paragraph.getParent();
        int paragraphIdx = ((ContainerNode)paragraph.getParent()).getChildIndex(paragraph);
        if (point.getOffset() > 0 && point.getOffset() < text.getText().length()) {
            paragraph.splitChildToPreviousChild(textIdx, point.getOffset());
            section.splitChildToPreviousChild(paragraphIdx, textIdx + 1);
        }
        RootNode root = (RootNode)section.getParent();
        root.splitChildToPreviousChild(root.getChildIndex(section), point.getOffset() == 0 ? paragraphIdx : paragraphIdx + 1);
        return List.of(section);
    }

    private static List<SectionNode> insertSectionBreak(DocumentModel model, Path path) {
        DocumentNode<?, ?, ?> parent = model.getNode(path.getParent());
        if (parent instanceof SectionNode) {
            SectionNode section = (SectionNode)parent;
            RootNode root = (RootNode)section.getParent();
            int sectionIdx = root.getChildIndex(section);
            root.splitChildToPreviousChild(sectionIdx, path.getLastIndex());
            return List.of(section);
        }
        throw new UiException("The parent at " + path.getParent() + " is not a section");
    }

    private static List<SectionNode> insertSectionBreakWithinTable(DocumentModel model, Path path) {
        int[] relativePath = path.getRelativePath();
        if (relativePath.length < 2) {
            return null;
        }
        Path blockPath = Path.of(path.getSectionIndex(), relativePath[0]);
        BlockNode block = (BlockNode)model.getNode(blockPath);
        if (block instanceof TableNode) {
            TableNode table = (TableNode)block;
            TableView tableView = new TableView(table);
            int rowIdx = relativePath[1];
            int lastColIdx = tableView.getColCount() - 1;
            int splitRowIdx = tableView.getZFlattenedCells(rowIdx, 0, rowIdx, lastColIdx).stream().mapToInt(c -> c.getMerger() == null ? c.getRow() : c.getMerger().getRow()).min().orElse(rowIdx);
            SectionNode section = (SectionNode)table.getParent();
            RootNode root = (RootNode)section.getParent();
            int sectionIdx = root.getChildIndex(section);
            int tableIdx = section.getChildIndex(table);
            if (splitRowIdx > 0) {
                section.splitChildToPreviousChild(tableIdx++, splitRowIdx);
            }
            root.splitChildToPreviousChild(sectionIdx, tableIdx);
            return List.of(section);
        }
        return null;
    }

    public static SectionCommand sectionBreak() {
        return new SectionCommand(true, (model, point) -> Optional.ofNullable(Commands.insertSectionBreakWithinTable(model, point.getPath())).orElseGet(() -> Commands.insertSectionBreak(model, point)));
    }

    public static SectionCommand sectionBreakBeforeBegin(Supplier<BlockView<?>> supplier) {
        return new SectionCommand((model, unused) -> {
            Path path = model.getPath((DocumentNode<?, ?, ?>)((BlockView)supplier.get()).getNode());
            return Optional.ofNullable(Commands.insertSectionBreakWithinTable(model, path)).orElseGet(() -> Commands.insertSectionBreak(model, path));
        });
    }

    public static SectionCommand sectionBreakAfterBegin(Supplier<ContainerView<?>> supplier) {
        return new SectionCommand((model, unused) -> {
            Path path = model.getPath((DocumentNode<?, ?, ?>)((ContainerView)supplier.get()).getNode()).getChild(0);
            return Optional.ofNullable(Commands.insertSectionBreakWithinTable(model, path)).orElseGet(() -> Commands.insertSectionBreak(model, path));
        });
    }

    public static SectionCommand sectionBreakBeforeEnd(Supplier<ContainerView<?>> supplier) {
        return new SectionCommand((model, unused) -> {
            ContainerNode container = (ContainerNode)((ContainerView)supplier.get()).getNode();
            Path path = model.getPath(container).getChild(container.getChildCount());
            return Optional.ofNullable(Commands.insertSectionBreakWithinTable(model, path)).orElseGet(() -> Commands.insertSectionBreak(model, path));
        });
    }

    public static SectionCommand sectionBreakAfterEnd(Supplier<BlockView<?>> supplier) {
        return new SectionCommand((model, unused) -> {
            Path path = model.getPath((DocumentNode<?, ?, ?>)((BlockView)supplier.get()).getNode()).getNextSibling();
            return Optional.ofNullable(Commands.insertSectionBreakWithinTable(model, path)).orElseGet(() -> Commands.insertSectionBreak(model, path));
        });
    }

    public static BlockCommand<?> remove(Supplier<BlockView<?>> supplier) {
        return new BlockCommand((model, unused) -> {
            BlockNode block = (BlockNode)((BlockView)supplier.get()).getNode();
            ((ContainerNode)block.getParent()).removeChild(block);
            return List.of(block);
        });
    }

    public static BlockCommand<?> removeAll(Supplier<Stream<? extends BlockView<?>>> supplier) {
        return new BlockCommand((model, unused) -> {
            List<BlockNode> blocks = ((Stream)supplier.get()).map(View::getNode).collect(Collectors.toList());
            blocks.forEach(block -> ((ContainerNode)block.getParent()).removeChild(block));
            return blocks;
        });
    }

    public static BlockCommand<?> moveBeforeBegin(Supplier<BlockView<?>> srcSupplier, Supplier<BlockView<?>> desSupplier) {
        return new BlockCommand((model, unused) -> {
            BlockNode block = (BlockNode)((BlockView)srcSupplier.get()).getNode();
            return Commands.insertSiblingBlock(block, desSupplier, true);
        });
    }

    public static BlockCommand<?> moveAfterBegin(Supplier<BlockView<?>> srcSupplier, Supplier<ContainerView<?>> desSupplier) {
        return new BlockCommand((model, unused) -> {
            BlockNode block = (BlockNode)((BlockView)srcSupplier.get()).getNode();
            return Commands.insertChildBlock(block, desSupplier, true);
        });
    }

    public static BlockCommand<?> moveBeforeEnd(Supplier<BlockView<?>> srcSupplier, Supplier<ContainerView<?>> desSupplier) {
        return new BlockCommand((model, unused) -> {
            BlockNode block = (BlockNode)((BlockView)srcSupplier.get()).getNode();
            return Commands.insertChildBlock(block, desSupplier, false);
        });
    }

    public static BlockCommand<?> moveAfterEnd(Supplier<BlockView<?>> srcSupplier, Supplier<BlockView<?>> desSupplier) {
        return new BlockCommand((model, unused) -> {
            BlockNode block = (BlockNode)((BlockView)srcSupplier.get()).getNode();
            return Commands.insertSiblingBlock(block, desSupplier, false);
        });
    }

    public static BlockCommand<?> copyBeforeBegin(Supplier<BlockView<?>> srcSupplier, Supplier<BlockView<?>> desSupplier) {
        return new BlockCommand((model, unused) -> {
            BlockNode block = (BlockNode)((BlockView)srcSupplier.get()).getNode();
            return Commands.insertSiblingBlock(DefaultDocumentNodeFactory.clone(block), desSupplier, true);
        });
    }

    public static BlockCommand<?> copyAfterBegin(Supplier<BlockView<?>> srcSupplier, Supplier<ContainerView<?>> desSupplier) {
        return new BlockCommand((model, unused) -> {
            BlockNode block = (BlockNode)((BlockView)srcSupplier.get()).getNode();
            return Commands.insertChildBlock(DefaultDocumentNodeFactory.clone(block), desSupplier, true);
        });
    }

    public static BlockCommand<?> copyBeforeEnd(Supplier<BlockView<?>> srcSupplier, Supplier<ContainerView<?>> desSupplier) {
        return new BlockCommand((model, unused) -> {
            BlockNode block = (BlockNode)((BlockView)srcSupplier.get()).getNode();
            return Commands.insertChildBlock(DefaultDocumentNodeFactory.clone(block), desSupplier, false);
        });
    }

    public static BlockCommand<?> copyAfterEnd(Supplier<BlockView<?>> srcSupplier, Supplier<BlockView<?>> desSupplier) {
        return new BlockCommand((model, unused) -> {
            BlockNode block = (BlockNode)((BlockView)srcSupplier.get()).getNode();
            return Commands.insertSiblingBlock(DefaultDocumentNodeFactory.clone(block), desSupplier, false);
        });
    }

    public static SelectionCommand findSelection() {
        return new SelectionCommand();
    }

    public static BlockCommand<?> select(Supplier<BlockView<?>> supplier) {
        return new BlockCommand((model, unused) -> {
            if (model instanceof DocumentSelectableModel) {
                BlockNode block = (BlockNode)((BlockView)supplier.get()).getNode();
                List textNodes = new DocumentNodeLazyIterator(block).stream().filter(TextNode.class::isInstance).map(TextNode.class::cast).collect(Collectors.toList());
                TextNode startNode = (TextNode)textNodes.get(0);
                TextNode endNode = (TextNode)textNodes.get(textNodes.size() - 1);
                ((DocumentSelectableModel)((Object)model)).setSelection(new DefaultDocumentRange(startNode, 0, endNode, endNode.getText().length()));
                return List.of(block);
            }
            throw new UiException("The model must implement DocumentSelectableModel");
        });
    }

    private static /* synthetic */ List lambda$pageBreakAfterEnd$25(Supplier supplier) {
        return Commands.insertSiblingBlock(new PageBreakNode(), supplier, false);
    }

    private static /* synthetic */ List lambda$pageBreakBeforeEnd$23(Supplier supplier) {
        return Commands.insertChildBlock(new PageBreakNode(), supplier, false);
    }

    private static /* synthetic */ List lambda$pageBreakAfterBegin$21(Supplier supplier) {
        return Commands.insertChildBlock(new PageBreakNode(), supplier, true);
    }

    private static /* synthetic */ List lambda$pageBreakBeforeBegin$19(Supplier supplier) {
        return Commands.insertSiblingBlock(new PageBreakNode(), supplier, true);
    }
}

