/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/aria-hidden/dist/es2015/index.js":
/*!*******************************************************!*\
  !*** ./node_modules/aria-hidden/dist/es2015/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hideOthers: () => (/* binding */ hideOthers),
/* harmony export */   inertOthers: () => (/* binding */ inertOthers),
/* harmony export */   supportsInert: () => (/* binding */ supportsInert),
/* harmony export */   suppressOthers: () => (/* binding */ suppressOthers)
/* harmony export */ });
var getDefaultParent = function (originalTarget) {
    if (typeof document === 'undefined') {
        return null;
    }
    var sampleTarget = Array.isArray(originalTarget) ? originalTarget[0] : originalTarget;
    return sampleTarget.ownerDocument.body;
};
var counterMap = new WeakMap();
var uncontrolledNodes = new WeakMap();
var markerMap = {};
var lockCount = 0;
var unwrapHost = function (node) {
    return node && (node.host || unwrapHost(node.parentNode));
};
var correctTargets = function (parent, targets) {
    return targets
        .map(function (target) {
        if (parent.contains(target)) {
            return target;
        }
        var correctedTarget = unwrapHost(target);
        if (correctedTarget && parent.contains(correctedTarget)) {
            return correctedTarget;
        }
        console.error('aria-hidden', target, 'in not contained inside', parent, '. Doing nothing');
        return null;
    })
        .filter(function (x) { return Boolean(x); });
};
/**
 * Marks everything except given node(or nodes) as aria-hidden
 * @param {Element | Element[]} originalTarget - elements to keep on the page
 * @param [parentNode] - top element, defaults to document.body
 * @param {String} [markerName] - a special attribute to mark every node
 * @param {String} [controlAttribute] - html Attribute to control
 * @return {Undo} undo command
 */
var applyAttributeToOthers = function (originalTarget, parentNode, markerName, controlAttribute) {
    var targets = correctTargets(parentNode, Array.isArray(originalTarget) ? originalTarget : [originalTarget]);
    if (!markerMap[markerName]) {
        markerMap[markerName] = new WeakMap();
    }
    var markerCounter = markerMap[markerName];
    var hiddenNodes = [];
    var elementsToKeep = new Set();
    var elementsToStop = new Set(targets);
    var keep = function (el) {
        if (!el || elementsToKeep.has(el)) {
            return;
        }
        elementsToKeep.add(el);
        keep(el.parentNode);
    };
    targets.forEach(keep);
    var deep = function (parent) {
        if (!parent || elementsToStop.has(parent)) {
            return;
        }
        Array.prototype.forEach.call(parent.children, function (node) {
            if (elementsToKeep.has(node)) {
                deep(node);
            }
            else {
                try {
                    var attr = node.getAttribute(controlAttribute);
                    var alreadyHidden = attr !== null && attr !== 'false';
                    var counterValue = (counterMap.get(node) || 0) + 1;
                    var markerValue = (markerCounter.get(node) || 0) + 1;
                    counterMap.set(node, counterValue);
                    markerCounter.set(node, markerValue);
                    hiddenNodes.push(node);
                    if (counterValue === 1 && alreadyHidden) {
                        uncontrolledNodes.set(node, true);
                    }
                    if (markerValue === 1) {
                        node.setAttribute(markerName, 'true');
                    }
                    if (!alreadyHidden) {
                        node.setAttribute(controlAttribute, 'true');
                    }
                }
                catch (e) {
                    console.error('aria-hidden: cannot operate on ', node, e);
                }
            }
        });
    };
    deep(parentNode);
    elementsToKeep.clear();
    lockCount++;
    return function () {
        hiddenNodes.forEach(function (node) {
            var counterValue = counterMap.get(node) - 1;
            var markerValue = markerCounter.get(node) - 1;
            counterMap.set(node, counterValue);
            markerCounter.set(node, markerValue);
            if (!counterValue) {
                if (!uncontrolledNodes.has(node)) {
                    node.removeAttribute(controlAttribute);
                }
                uncontrolledNodes.delete(node);
            }
            if (!markerValue) {
                node.removeAttribute(markerName);
            }
        });
        lockCount--;
        if (!lockCount) {
            // clear
            counterMap = new WeakMap();
            counterMap = new WeakMap();
            uncontrolledNodes = new WeakMap();
            markerMap = {};
        }
    };
};
/**
 * Marks everything except given node(or nodes) as aria-hidden
 * @param {Element | Element[]} originalTarget - elements to keep on the page
 * @param [parentNode] - top element, defaults to document.body
 * @param {String} [markerName] - a special attribute to mark every node
 * @return {Undo} undo command
 */
var hideOthers = function (originalTarget, parentNode, markerName) {
    if (markerName === void 0) { markerName = 'data-aria-hidden'; }
    var targets = Array.from(Array.isArray(originalTarget) ? originalTarget : [originalTarget]);
    var activeParentNode = parentNode || getDefaultParent(originalTarget);
    if (!activeParentNode) {
        return function () { return null; };
    }
    // we should not hide ariaLive elements - https://github.com/theKashey/aria-hidden/issues/10
    targets.push.apply(targets, Array.from(activeParentNode.querySelectorAll('[aria-live]')));
    return applyAttributeToOthers(targets, activeParentNode, markerName, 'aria-hidden');
};
/**
 * Marks everything except given node(or nodes) as inert
 * @param {Element | Element[]} originalTarget - elements to keep on the page
 * @param [parentNode] - top element, defaults to document.body
 * @param {String} [markerName] - a special attribute to mark every node
 * @return {Undo} undo command
 */
var inertOthers = function (originalTarget, parentNode, markerName) {
    if (markerName === void 0) { markerName = 'data-inert-ed'; }
    var activeParentNode = parentNode || getDefaultParent(originalTarget);
    if (!activeParentNode) {
        return function () { return null; };
    }
    return applyAttributeToOthers(originalTarget, activeParentNode, markerName, 'inert');
};
/**
 * @returns if current browser supports inert
 */
var supportsInert = function () {
    return typeof HTMLElement !== 'undefined' && HTMLElement.prototype.hasOwnProperty('inert');
};
/**
 * Automatic function to "suppress" DOM elements - _hide_ or _inert_ in the best possible way
 * @param {Element | Element[]} originalTarget - elements to keep on the page
 * @param [parentNode] - top element, defaults to document.body
 * @param {String} [markerName] - a special attribute to mark every node
 * @return {Undo} undo command
 */
var suppressOthers = function (originalTarget, parentNode, markerName) {
    if (markerName === void 0) { markerName = 'data-suppressed'; }
    return (supportsInert() ? inertOthers : hideOthers)(originalTarget, parentNode, markerName);
};


/***/ }),

/***/ "./extends.js":
/*!********************!*\
  !*** ./extends.js ***!
  \********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// Adapted from zk (https://github.com/zkoss/zk)
var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return extendStatics(d, b);
};
// refer tslib#__extends
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(d, b) {
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  d.prototype._$super = d.name == '$subclass$' && b.prototype._$super ? b.prototype._$super : b.prototype; // Potix: Jumper Chen adds to support `$supers(foo.Bar, 'bind_')`
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/Document.ts":
/*!****************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/Document.ts ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Document: () => (/* binding */ Document)
/* harmony export */ });
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! dompurify */ "./node_modules/dompurify/dist/purify.es.mjs");
/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];

var Document = /** @class */function (_super) {
  __extends(Document, _super);
  function Document() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  Document.prototype.getValue = function () {
    return this._value;
  };
  Document.prototype.setHeight = function (height) {
    _super.prototype.setHeight.call(this, height);
    if (this.desktop && !height) this.$n_('editor').style.removeProperty('height');
    return this;
  };
  Document.prototype.setValue = function (value, opts) {
    var _a;
    var o = this._value;
    this._value = value = dompurify__WEBPACK_IMPORTED_MODULE_0__["default"].sanitize(value);
    if (this.desktop && (o !== value || (opts === null || opts === void 0 ? void 0 : opts.force))) {
      (_a = this._plate) === null || _a === void 0 ? void 0 : _a.setValue(value);
    }
    return this;
  };
  Document.prototype.isReadonly = function () {
    return !!this._readonly;
  };
  Document.prototype.setReadonly = function (readonly) {
    var _a;
    if (this._readonly !== readonly) {
      this._readonly = readonly;
      if (this.desktop) {
        (_a = this._plate) === null || _a === void 0 ? void 0 : _a.setReadonly(readonly);
      }
    }
    return this;
  };
  Document.prototype.getCustomConfigurationsPath = function () {
    return this._customConfigurationsPath;
  };
  Document.prototype.setCustomConfigurationsPath = function (customConfigurationsPath) {
    var _this = this;
    if (this._customConfigurationsPath !== customConfigurationsPath) {
      this._customConfigurationsPath = customConfigurationsPath;
      if (this._customConfigurationsPath != null) {
        void jq.getJSON(this._customConfigurationsPath, function (data) {
          _this.setDocumentConfig(data, {
            force: true
          });
        });
      } else {
        this.setDocumentConfig(this._customConfigurationsPath, {
          force: true
        });
      }
    }
    return this;
  };
  Document.prototype.getDocumentConfig = function () {
    return this._documentConfig;
  };
  Document.prototype.setDocumentConfig = function (documentConfig, opts) {
    var _a;
    var o = this._documentConfig;
    this._documentConfig = documentConfig;
    if (this.desktop && (o !== documentConfig || (opts === null || opts === void 0 ? void 0 : opts.force))) {
      (_a = this._plate) === null || _a === void 0 ? void 0 : _a.setDocumentConfig(documentConfig);
    }
    return this;
  };
  Document.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    this._plate = new kkdoc.PlateObject(this.uuid, /*safe*/this.getZclass(), this.isReadonly(), this._value, this._documentConfig, this._onChange.bind(this), this._onChanging.bind(this));
  };
  Document.prototype.unbind_ = function (skipper, after, keepRod) {
    var _a;
    (_a = this._plate) === null || _a === void 0 ? void 0 : _a.destroy();
    this._plate = undefined;
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  Document.prototype.beforeSendAU_ = function (wgt, evt) {
    var _this = this;
    _super.prototype.beforeSendAU_.call(this, wgt, evt);
    if ((evt.name === 'onChange' || evt.name === 'onChanging') && this._plate) {
      evt.opts['waiting'] = true;
      this._plate.getValue(function (value) {
        _this._value = value;
        evt.data['value'] = value;
        delete evt.opts['waiting'];
        if (_this.desktop) zAu.sendNow(_this.desktop);
      });
    }
  };
  /** @internal */
  Document.prototype._onChange = function () {
    this.fire('onChange', {});
  };
  /** @internal */
  Document.prototype._onChanging = function () {
    this.fire('onChanging', {});
  };
  Document = __decorate([zk.WrapClass('kkdoc.Document')], Document);
  return Document;
}(zul.Widget);


/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/au.ts":
/*!**********************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/au.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* au.ts

        Purpose:
                
        Description:
                
        History:
                Wed Mar 26 09:55:15 CST 2025, Created by rebeccalai

Copyright (C) 2025 Potix Corporation. All Rights Reserved.
*/
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({});
var getAuRequests = zk.augment(zAu, {
  getAuRequests: function (dt) {
    var aureqs = getAuRequests(dt),
      waitingIdx = aureqs.findIndex(function (aureq) {
        return aureq.opts['waiting'];
      });
    return waitingIdx < 0 ? aureqs : aureqs.slice(0, waitingIdx);
  }
}).getAuRequests;

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/Plate.tsx":
/*!******************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/Plate.tsx ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PlateObject: () => (/* binding */ PlateObject)
/* harmony export */ });
/* harmony import */ var _plate_components_editor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @plate/components/editor */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/editor.tsx");
/* harmony import */ var _plate_components_PlateStatic__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @plate/components/PlateStatic */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/PlateStatic.tsx");
/* harmony import */ var _plate_create_plate_plugins__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @plate/create-plate-plugins */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/create-plate-plugins.ts");
/* harmony import */ var _plate_create_plate_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @plate/create-plate-ui */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/create-plate-ui.ts");
/* harmony import */ var _plate_create_static_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @plate/create-static-components */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/create-static-components.ts");
/* harmony import */ var _plate_toolbar_KKDocToolbar__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @plate/toolbar/KKDocToolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/KKDocToolbar.tsx");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _udecode_plate_diff__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @udecode/plate-diff */ "./node_modules/@udecode/plate-diff/dist/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_dnd__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react-dnd */ "./node_modules/react-dnd/dist/core/DndProvider.js");
/* harmony import */ var react_dnd_html5_backend__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react-dnd-html5-backend */ "./node_modules/react-dnd-html5-backend/dist/index.js");
/* harmony import */ var react_dom_client__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-dom/client */ "./node_modules/react-dom/client.js");
/* harmony import */ var tiny_typed_emitter__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! tiny-typed-emitter */ "tiny-typed-emitter");
/* harmony import */ var tiny_typed_emitter__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(tiny_typed_emitter__WEBPACK_IMPORTED_MODULE_10__);
/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];














/**
 * Normalizes the value without triggering Plate's onChange.
 * @param value - the value to normalize
 */
var normalize = function (value) {
  return (0,_udecode_plate__WEBPACK_IMPORTED_MODULE_6__.createSlateEditor)({
    plugins: (0,_plate_create_plate_plugins__WEBPACK_IMPORTED_MODULE_2__.createPlatePlugins)(),
    value: value,
    shouldNormalizeEditor: true
  }).children;
};
function EditorDefault(_a) {
  var uuid = _a.uuid,
    zclass = _a.zclass,
    emitter = _a.emitter,
    getInitialValue = _a.getInitialValue,
    onRender = _a.onRender;
  var _b = react__WEBPACK_IMPORTED_MODULE_8__.useState(getInitialValue('documentConfig')),
    documentConfig = _b[0],
    setDocumentConfig = _b[1],
    _c = react__WEBPACK_IMPORTED_MODULE_8__.useState(getInitialValue('readonly')),
    readonly = _c[0],
    setReadonly = _c[1],
    editor = react__WEBPACK_IMPORTED_MODULE_8__.useMemo(function () {
      var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_7__.createPlateEditor)({
        override: {
          components: (0,_plate_create_plate_ui__WEBPACK_IMPORTED_MODULE_3__.createPlateUI)(zclass, new tiny_typed_emitter__WEBPACK_IMPORTED_MODULE_10__.TypedEmitter())
        },
        plugins: (0,_plate_create_plate_plugins__WEBPACK_IMPORTED_MODULE_2__.createPlatePlugins)(),
        value: normalize(getInitialValue('value'))
      });
      editor.id = uuid;
      editor.zclass = zclass;
      var staticComponents = (0,_plate_create_static_components__WEBPACK_IMPORTED_MODULE_4__.createStaticComponents)(zclass);
      emitter.on('getValue', function (cb) {
        (0,_udecode_plate__WEBPACK_IMPORTED_MODULE_6__.serializeHtml)(editor, {
          components: staticComponents,
          editorComponent: _plate_components_PlateStatic__WEBPACK_IMPORTED_MODULE_1__.PlateStatic,
          preserveClassNames: [],
          stripClassNames: true,
          stripDataAttributes: true
        }).then(cb).catch(function (error) {
          throw error;
        });
      });
      emitter.on('setValue', function (value) {
        // editor.tf.setValue(value) without firing back to the server
        editor.tf.withoutNormalizing(function () {
          var children = normalize(value);
          for (var _i = 0, _a = Array.from(_udecode_plate__WEBPACK_IMPORTED_MODULE_6__.NodeApi.children(editor, [], {
              reverse: true
            })); _i < _a.length; _i++) {
            var _b = _a[_i],
              node = _b[0],
              path_1 = _b[1];
            editor.tf.apply({
              fromServer: true,
              type: 'remove_node',
              path: path_1,
              node: node
            });
          }
          var path = [0];
          for (var _c = 0, children_1 = children; _c < children_1.length; _c++) {
            var node = children_1[_c];
            editor.tf.apply({
              fromServer: true,
              type: 'insert_node',
              path: path,
              node: node
            });
            path = _udecode_plate__WEBPACK_IMPORTED_MODULE_6__.PathApi.next(path);
          }
        });
        setOnChangeValue(editor.children);
      });
      emitter.on('setDocumentConfig', function (documentConfig) {
        setDocumentConfig(documentConfig);
      });
      emitter.on('setReadonly', function (readonly) {
        setReadonly(readonly);
      });
      // call onRender after the editor is created
      onRender();
      return editor;
    }, []),
    _d = react__WEBPACK_IMPORTED_MODULE_8__.useState(editor.children),
    onChangeValue = _d[0],
    setOnChangeValue = _d[1];
  react__WEBPACK_IMPORTED_MODULE_8__.useEffect(function () {
    var document = zk.$('#' + uuid),
      $document = document.$n_(),
      $toolbar = document.$n_('toolbar'),
      $editor = document.$n_('editor'),
      resizeObserver = new ResizeObserver(function () {
        if (document.getHeight() || document.getVflex()) {
          // update $editor's height
          $editor.style.height = $document.clientHeight - $toolbar.clientHeight + 'px';
        } else {
          // otherwise, remove height-related styles
          $editor.style.removeProperty('height');
        }
      });
    resizeObserver.observe($document);
    resizeObserver.observe($toolbar);
    return function () {
      resizeObserver.disconnect();
    };
  }, []);
  // eslint-disable-next-line zk/noMixedHtml
  return react__WEBPACK_IMPORTED_MODULE_8__.createElement(react_dnd__WEBPACK_IMPORTED_MODULE_11__.DndProvider, {
    backend: react_dnd_html5_backend__WEBPACK_IMPORTED_MODULE_12__.HTML5Backend
  }, react__WEBPACK_IMPORTED_MODULE_8__.createElement(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_7__.Plate, {
    editor: editor,
    onChange: function () {
      var operations = editor.operations;
      if (operations.every(function (op) {
        return op.type === 'set_selection' || op.fromServer;
      })) return;
      emitter.emit('onChanging');
    }
  }, react__WEBPACK_IMPORTED_MODULE_8__.createElement(_plate_toolbar_KKDocToolbar__WEBPACK_IMPORTED_MODULE_5__.KKDocToolbar, {
    id: uuid + '-toolbar',
    documentConfig: documentConfig
  }), react__WEBPACK_IMPORTED_MODULE_8__.createElement(_plate_components_editor__WEBPACK_IMPORTED_MODULE_0__.EditorContainer, {
    id: uuid + '-editor',
    onBlur: function (event) {
      var _a;
      if (((_a = event.relatedTarget) === null || _a === void 0 ? void 0 : _a.getAttribute('data-plate-focus-id')) === uuid) return;
      var changed = false;
      var setChanged = function (_) {
        return changed = true;
      };
      (0,_udecode_plate_diff__WEBPACK_IMPORTED_MODULE_13__.computeDiff)(onChangeValue, editor.children, {
        getDeleteProps: setChanged,
        getInsertProps: setChanged,
        getUpdateProps: setChanged
      });
      if (changed) {
        setOnChangeValue(editor.children);
        emitter.emit('onChange');
      }
    }
  }, react__WEBPACK_IMPORTED_MODULE_8__.createElement(_plate_components_editor__WEBPACK_IMPORTED_MODULE_0__.Editor, {
    variant: 'demo',
    readOnly: readonly
  }))));
}
var PlateObject = /** @class */function (_super) {
  __extends(PlateObject, _super);
  function PlateObject(uuid, zclass, initialReadonly, initialValue, initialDocumentConfig, onChange, onChanging) {
    var _this = _super.call(this) || this;
    _this._initialValue = initialValue;
    _this._initialDocumentConfig = initialDocumentConfig;
    _this._initialReadonly = initialReadonly;
    var getInitialValue = function (type) {
      switch (type) {
        case 'value':
          return _this._initialValue;
        case 'readonly':
          return _this._initialReadonly;
        case 'documentConfig':
          return _this._initialDocumentConfig;
      }
    };
    _this._emitter = new tiny_typed_emitter__WEBPACK_IMPORTED_MODULE_10__.TypedEmitter();
    _this._emitter.on('onChange', onChange);
    _this._emitter.on('onChanging', onChanging);
    _this._root = (0,react_dom_client__WEBPACK_IMPORTED_MODULE_9__.createRoot)(document.getElementById(uuid));
    _this._root.render(react__WEBPACK_IMPORTED_MODULE_8__.createElement(EditorDefault, {
      uuid: uuid,
      zclass: zclass,
      emitter: _this._emitter,
      getInitialValue: getInitialValue,
      onRender: function () {
        return _this._isRendered = true;
      }
    }));
    return _this;
  }
  PlateObject.prototype.destroy = function () {
    this._emitter.removeAllListeners();
    this._root.unmount();
  };
  PlateObject.prototype.getValue = function (cb) {
    if (this._isRendered) {
      this._emitter.emit('getValue', cb);
    }
  };
  PlateObject.prototype.setValue = function (value) {
    this._initialValue = value;
    if (this._isRendered) {
      this._emitter.emit('setValue', value);
    }
    return this;
  };
  PlateObject.prototype.setReadonly = function (readonly) {
    this._initialReadonly = readonly;
    if (this._isRendered) {
      this._emitter.emit('setReadonly', readonly);
    }
    return this;
  };
  PlateObject.prototype.setDocumentConfig = function (documentConfig) {
    this._initialDocumentConfig = documentConfig;
    if (this._isRendered) {
      this._emitter.emit('setDocumentConfig', documentConfig);
    }
    return this;
  };
  PlateObject = __decorate([zk.WrapClass('kkdoc.PlateObject')], PlateObject);
  return PlateObject;
}(zk.Object);


/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/PlateStatic.tsx":
/*!*****************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/PlateStatic.tsx ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PlateStatic: () => (/* binding */ PlateStatic)
/* harmony export */ });
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_slate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/slate */ "./node_modules/@udecode/slate/dist/index.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);



var defaultDecorate = function () {
  return [];
};
function Children(_a) {
  var _b = _a.children,
    children = _b === void 0 ? [] : _b,
    components = _a.components,
    _c = _a.decorate,
    decorate = _c === void 0 ? defaultDecorate : _c,
    _d = _a.decorations,
    decorations = _d === void 0 ? [] : _d,
    editor = _a.editor;
  return react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, children.map(function (child, i) {
    var p = editor.api.findPath(child);
    var ds = [];
    if (p) {
      var range = editor.api.range(p);
      ds = decorate([child, p]);
      for (var _i = 0, decorations_1 = decorations; _i < decorations_1.length; _i++) {
        var dec = decorations_1[_i];
        var d = _udecode_slate__WEBPACK_IMPORTED_MODULE_2__.RangeApi.intersection(dec, range);
        if (d) {
          ds.push(d);
        }
      }
    }
    return _udecode_slate__WEBPACK_IMPORTED_MODULE_2__.ElementApi.isElement(child) ? react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_udecode_plate__WEBPACK_IMPORTED_MODULE_0__.ElementStatic, {
      key: i,
      components: components,
      decorate: decorate,
      decorations: ds,
      editor: editor,
      element: child
    }) : react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_udecode_plate__WEBPACK_IMPORTED_MODULE_0__.LeafStatic, {
      key: i,
      components: components,
      decorations: ds,
      editor: editor,
      leaf: child
    });
  }));
}
function PlateStatic(props) {
  var components = props.components,
    editor = props.editor,
    value = props.value;
  if (value) {
    editor.children = value;
  }
  var decorate = (0,_udecode_plate__WEBPACK_IMPORTED_MODULE_0__.pipeDecorate)(editor);
  var afterEditable = undefined,
    beforeEditable = undefined;
  editor.pluginList.forEach(function (plugin) {
    var _a = plugin.render,
      AfterEditable = _a.afterEditable,
      BeforeEditable = _a.beforeEditable;
    if (AfterEditable) {
      afterEditable = react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, afterEditable, react__WEBPACK_IMPORTED_MODULE_1___default().createElement(AfterEditable, null));
    }
    if (BeforeEditable) {
      beforeEditable = react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, beforeEditable, react__WEBPACK_IMPORTED_MODULE_1___default().createElement(BeforeEditable, null));
    }
  });
  var content = /* Potix: remove the slate-editor div */
  // <div
  //     className={clsx('slate-editor', className)}
  //     data-slate-editor
  //     data-slate-node="value"
  //     {...rest}
  // >
  react__WEBPACK_IMPORTED_MODULE_1___default().createElement(Children, {
    components: components,
    decorate: decorate,
    decorations: [],
    editor: editor
  }, editor.children)
  // </div>
  ;
  var aboveEditable = react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, beforeEditable, content, afterEditable);
  editor.pluginList.forEach(function (plugin) {
    var AboveEditable = plugin.render.aboveEditable;
    if (AboveEditable) {
      aboveEditable = react__WEBPACK_IMPORTED_MODULE_1___default().createElement(AboveEditable, null, aboveEditable);
    }
  });
  return aboveEditable;
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/block-selection.tsx":
/*!*********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/block-selection.tsx ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BlockSelection: () => (/* binding */ BlockSelection),
/* harmony export */   blockSelectionVariants: () => (/* binding */ blockSelectionVariants)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_dnd__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @udecode/plate-dnd */ "./node_modules/@udecode/plate-dnd/dist/index.mjs");
/* harmony import */ var _udecode_plate_selection_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-selection/react */ "@udecode/plate-selection/react");
/* harmony import */ var _udecode_plate_selection_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_selection_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! class-variance-authority */ "class-variance-authority");
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(class_variance_authority__WEBPACK_IMPORTED_MODULE_4__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';







var blockSelectionVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_4__.cva)('pointer-events-none absolute inset-0 z-1 bg-brand/[.13] transition-opacity', {
  defaultVariants: {
    active: true
  },
  variants: {
    active: {
      false: 'opacity-0',
      true: 'opacity-100'
    }
  }
});
function BlockSelection(_a) {
  var className = _a.className,
    props = __rest(_a, ["className"]);
  var isBlockSelected = (0,_udecode_plate_selection_react__WEBPACK_IMPORTED_MODULE_2__.useBlockSelected)(),
    isDragging = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.usePluginOption)(_udecode_plate_dnd__WEBPACK_IMPORTED_MODULE_5__.DndPlugin, 'isDragging');
  if (!isBlockSelected) return undefined;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", __assign({
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(blockSelectionVariants({
      active: isBlockSelected && !isDragging
    }), className),
    "data-slot": "block-selection"
  }, props));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/blockquote-element-static.tsx":
/*!*******************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/blockquote-element-static.tsx ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BlockquoteElementStatic: () => (/* binding */ BlockquoteElementStatic)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];



var BlockquoteElementStatic = function (_a) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate__WEBPACK_IMPORTED_MODULE_2__.SlateElement, __assign({
    as: "blockquote",
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(className, 'my-1 border-l-2 pl-6 italic')
  }, props), children);
};

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/blockquote-element.tsx":
/*!************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/blockquote-element.tsx ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BlockquoteElement: () => (/* binding */ BlockquoteElement)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';




var BlockquoteElement = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.PlateElement, __assign({
    ref: ref,
    as: "blockquote",
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(className, 'my-1 border-l-2 pl-6 italic')
  }, props), children);
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/code-leaf-static.tsx":
/*!**********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/code-leaf-static.tsx ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeLeafStatic: () => (/* binding */ CodeLeafStatic)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];



var CodeLeafStatic = function (_a) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate__WEBPACK_IMPORTED_MODULE_2__.SlateLeaf, __assign({
    as: "code",
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(className, 'rounded-md bg-muted px-[0.3em] py-[0.2em] font-mono text-sm whitespace-pre-wrap')
  }, props), children);
};

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/code-leaf.tsx":
/*!***************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/code-leaf.tsx ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeLeaf: () => (/* binding */ CodeLeaf)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';




var CodeLeaf = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.PlateLeaf, __assign({
    ref: ref,
    as: "code",
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(className, 'rounded-md bg-muted px-[0.3em] py-[0.2em] font-mono text-sm whitespace-pre-wrap')
  }, props), children);
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/draggable.tsx":
/*!***************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/draggable.tsx ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Draggable: () => (/* binding */ Draggable),
/* harmony export */   DraggableAboveNodes: () => (/* binding */ DraggableAboveNodes),
/* harmony export */   UNDRAGGABLE_KEYS: () => (/* binding */ UNDRAGGABLE_KEYS)
/* harmony export */ });
/* harmony import */ var _plate_toolbar_tooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @plate/toolbar/tooltip */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/tooltip.tsx");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _udecode_plate_block_quote_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @udecode/plate-block-quote/react */ "./node_modules/@udecode/plate-block-quote/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_dnd__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @udecode/plate-dnd */ "./node_modules/@udecode/plate-dnd/dist/index.mjs");
/* harmony import */ var _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate-heading */ "@udecode/plate-heading");
/* harmony import */ var _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @udecode/plate-media/react */ "./node_modules/@udecode/plate-media/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @udecode/plate-table/react */ "./node_modules/@udecode/plate-table/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/grip-vertical.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];











var STRUCTURAL_TYPES = [
// ColumnPlugin.key,
// ColumnItemPlugin.key,
_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__.TablePlugin.key, _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__.TableRowPlugin.key, _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__.TableCellPlugin.key];
var UNDRAGGABLE_KEYS = [
// ColumnItemPlugin.key,
_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__.TableRowPlugin.key, _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__.TableCellPlugin.key];
var DraggableAboveNodes = function (props) {
  var editor = props.editor,
    element = props.element,
    path = props.path,
    readOnly = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_4__.useReadOnly)(),
    enabled = (0,react__WEBPACK_IMPORTED_MODULE_5__.useMemo)(function () {
      if (!path || readOnly) return false;
      if (path.length === 1 && !(0,_udecode_plate__WEBPACK_IMPORTED_MODULE_2__.isType)(editor, element, UNDRAGGABLE_KEYS)) {
        return true;
      }
      // if (path.length === 3 && !isType(editor, element, UNDRAGGABLE_KEYS)) {
      //     const block = editor.api.some({
      //         at: path,
      //         match: {
      //             type: editor.getType(ColumnPlugin),
      //         },
      //     });
      //
      //     if (block) {
      //         return true;
      //     }
      // }
      if (path.length === 4 && !(0,_udecode_plate__WEBPACK_IMPORTED_MODULE_2__.isType)(editor, element, UNDRAGGABLE_KEYS)) {
        var block = editor.api.some({
          at: path,
          match: {
            type: editor.getType(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__.TablePlugin)
          }
        });
        if (block) {
          return true;
        }
      }
      return false;
    }, [editor, element, path, readOnly]);
  if (!enabled) return;
  return function (props) {
    return react__WEBPACK_IMPORTED_MODULE_5___default().createElement(Draggable, __assign({}, props));
  };
};
var Draggable = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var className = _a.className,
    children = _a.children,
    props = __rest(_a, ["className", "children"]);
  var editor = props.editor,
    element = props.element,
    path = props.path,
    // blockSelectionApi =
    //     editor.getApi(BlockSelectionPlugin).blockSelection,
    _b = (0,_udecode_plate_dnd__WEBPACK_IMPORTED_MODULE_7__.useDraggable)({
      element: element
      // onDropHandler: (_, {dragItem}) => {
      //     const id = dragItem['id'] as string;
      //     if (blockSelectionApi && id) {
      //         blockSelectionApi.set(id);
      //     }
      // },
    }),
    isDragging = _b.isDragging,
    previewRef = _b.previewRef,
    handleRef = _b.handleRef,
    isInColumn = path.length === 3,
    isInTable = path.length === 4;
  return react__WEBPACK_IMPORTED_MODULE_5___default().createElement("div", {
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('relative', isDragging && 'opacity-50', STRUCTURAL_TYPES.includes(element.type) ? 'group/structural' : 'group')
  }, !isInTable && react__WEBPACK_IMPORTED_MODULE_5___default().createElement(Gutter, null, react__WEBPACK_IMPORTED_MODULE_5___default().createElement("div", {
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('slate-blockToolbarWrapper', 'flex h-[1.5em]', (0,_udecode_plate__WEBPACK_IMPORTED_MODULE_2__.isType)(editor, element, [_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__.HEADING_KEYS.h1, _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__.HEADING_KEYS.h2, _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__.HEADING_KEYS.h3, _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__.HEADING_KEYS.h4, _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__.HEADING_KEYS.h5]) && 'h-[1.3em]', isInColumn && 'h-4')
  }, react__WEBPACK_IMPORTED_MODULE_5___default().createElement("div", {
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('slate-blockToolbar', 'pointer-events-auto mr-1 flex items-center', isInColumn && 'mr-1.5')
  }, react__WEBPACK_IMPORTED_MODULE_5___default().createElement("div", {
    ref: handleRef,
    className: "size-4"
  }, react__WEBPACK_IMPORTED_MODULE_5___default().createElement(DragHandle, null))))), react__WEBPACK_IMPORTED_MODULE_5___default().createElement("div", {
    ref: previewRef,
    className: "slate-blockWrapper"
  }, react__WEBPACK_IMPORTED_MODULE_5___default().createElement(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.MemoizedChildren, null, children), react__WEBPACK_IMPORTED_MODULE_5___default().createElement(DropLine, null)));
});
var Gutter = react__WEBPACK_IMPORTED_MODULE_5___default().forwardRef(function (_a, ref) {
    var children = _a.children,
      className = _a.className,
      props = __rest(_a, ["children", "className"]);
    var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_4__.useEditorRef)(),
      element = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_4__.useElement)(),
      path = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_4__.usePath)(),
      // isSelectionAreaVisible = usePluginOption(
      //     BlockSelectionPlugin,
      //     'isSelectionAreaVisible'
      // ),
      selected = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_4__.useSelected)(),
      isNodeType = function (keys) {
        return (0,_udecode_plate__WEBPACK_IMPORTED_MODULE_2__.isType)(editor, element, keys);
      },
      isInColumn = path.length === 3;
    return react__WEBPACK_IMPORTED_MODULE_5___default().createElement("div", __assign({
      ref: ref,
      className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('slate-gutterLeft', 'absolute -top-px z-50 flex h-full -translate-x-full cursor-text hover:opacity-100 sm:opacity-0', STRUCTURAL_TYPES.includes(element.type) ? 'group-hover/structural:opacity-100' : 'group-hover:opacity-100',
      // isSelectionAreaVisible && 'hidden',
      !selected && 'opacity-0', isNodeType(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__.HEADING_KEYS.h1) && 'pb-1 text-[1.875em]', isNodeType(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__.HEADING_KEYS.h2) && 'pb-1 text-[1.5em]', isNodeType(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__.HEADING_KEYS.h3) && 'pt-[2px] pb-1 text-[1.25em]', isNodeType([_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__.HEADING_KEYS.h4, _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__.HEADING_KEYS.h5]) && 'pt-[3px] pb-0 text-[1.1em]', isNodeType(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__.HEADING_KEYS.h6) && 'pb-0', isNodeType(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_4__.ParagraphPlugin.key) && 'pt-[3px] pb-0', isNodeType(['ul', 'ol']) && 'pb-0', isNodeType(_udecode_plate_block_quote_react__WEBPACK_IMPORTED_MODULE_8__.BlockquotePlugin.key) && 'pb-0',
      // isNodeType(CodeBlockPlugin.key) && 'pt-6 pb-0',
      isNodeType([_udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_9__.ImagePlugin.key, _udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_9__.MediaEmbedPlugin.key
      //     ExcalidrawPlugin.key,
      //     TogglePlugin.key,
      //     ColumnPlugin.key,
      ]) && 'py-0', isNodeType([/* PlaceholderPlugin.key, */_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__.TablePlugin.key]) && 'pt-3 pb-0', isInColumn && 'mt-2 h-4 pt-0', className),
      contentEditable: false
    }, props), children);
  }),
  DragHandle = react__WEBPACK_IMPORTED_MODULE_5___default().memo(function () {
    // const editor = useEditorRef(),
    //     element = useElement();
    return react__WEBPACK_IMPORTED_MODULE_5___default().createElement(_plate_toolbar_tooltip__WEBPACK_IMPORTED_MODULE_0__.TooltipButton, {
      variant: "ghost",
      className: "h-6 w-4.5 p-0",
      "data-plate-focus-id": (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_4__.useEditorRef)().id,
      "data-plate-prevent-deselect": true,
      tooltip: "Drag to move"
    }, react__WEBPACK_IMPORTED_MODULE_5___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_10__["default"], {
      className: "text-muted-foreground"
    }));
  }),
  DropLine = react__WEBPACK_IMPORTED_MODULE_5___default().memo(react__WEBPACK_IMPORTED_MODULE_5___default().forwardRef(function (_a, ref) {
    var className = _a.className,
      props = __rest(_a, ["className"]);
    var dropLine = (0,_udecode_plate_dnd__WEBPACK_IMPORTED_MODULE_7__.useDropLine)().dropLine,
      zclass = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_4__.useEditorRef)().zclass;
    if (!dropLine) return undefined;
    return react__WEBPACK_IMPORTED_MODULE_5___default().createElement("div", __assign({
      ref: ref
    }, props, {
      className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)("slate-dropLine ".concat(zclass, "-dropLine"), 'absolute inset-x-0 h-0.5 opacity-100 transition-opacity', 'bg-brand/50', dropLine === 'top' && '-top-px', dropLine === 'bottom' && '-bottom-px', className)
    }));
  }));

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/editor.tsx":
/*!************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/editor.tsx ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Editor: () => (/* binding */ Editor),
/* harmony export */   EditorContainer: () => (/* binding */ EditorContainer)
/* harmony export */ });
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! class-variance-authority */ "class-variance-authority");
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(class_variance_authority__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];




var editorContainerVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_2__.cva)('relative w-full cursor-text overflow-y-auto caret-primary select-text selection:bg-brand/25 focus-visible:outline-none [&_.slate-selection-area]:z-50 [&_.slate-selection-area]:border [&_.slate-selection-area]:border-brand/25 [&_.slate-selection-area]:bg-brand/15', {
  defaultVariants: {
    variant: 'default'
  },
  variants: {
    variant: {
      comment: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)('flex flex-wrap justify-between gap-1 px-1 py-0.5 text-sm', 'rounded-md border-[1.5px] border-transparent bg-transparent', 'has-[[data-slate-editor]:focus]:border-brand/50 has-[[data-slate-editor]:focus]:ring-2 has-[[data-slate-editor]:focus]:ring-brand/30', 'has-aria-disabled:border-input has-aria-disabled:bg-muted'),
      default: 'h-full',
      demo: 'h-[650px]',
      select: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)('group rounded-md border border-input ring-offset-background focus-within:ring-2 focus-within:ring-ring focus-within:ring-offset-2', 'has-data-readonly:w-fit has-data-readonly:cursor-default has-data-readonly:border-transparent has-data-readonly:focus-within:[box-shadow:none]')
    }
  }
});
var EditorContainer = function (_a) {
  var className = _a.className,
    variant = _a.variant,
    props = __rest(_a, ["className", "variant"]);
  var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__.useEditorRef)(),
    containerRef = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__.useEditorContainerRef)();
  return react__WEBPACK_IMPORTED_MODULE_3__.createElement("div", __assign({
    id: editor.uid,
    ref: containerRef,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)('ignore-click-outside/toolbar', editorContainerVariants({
      variant: variant
    }), className)
  }, props));
};
EditorContainer.displayName = 'EditorContainer';
var editorVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_2__.cva)((0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)('group/editor', 'relative w-full cursor-text overflow-x-hidden break-words whitespace-pre-wrap select-text', 'rounded-md ring-offset-background focus-visible:outline-none', 'placeholder:text-muted-foreground/80 **:data-slate-placeholder:top-[auto_!important] **:data-slate-placeholder:text-muted-foreground/80 **:data-slate-placeholder:opacity-100!', '[&_strong]:font-bold'), {
  defaultVariants: {
    variant: 'default'
  },
  variants: {
    disabled: {
      true: 'cursor-not-allowed opacity-50'
    },
    focused: {
      true: 'ring-2 ring-ring ring-offset-2'
    },
    variant: {
      ai: 'w-full px-0 text-base md:text-sm',
      aiChat: 'max-h-[min(70vh,320px)] w-full max-w-[700px] overflow-y-auto px-3 py-2 text-base md:text-sm',
      comment: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)('rounded-none border-none bg-transparent text-sm'),
      default:
      // disable: pt-4 for EventTest.java
      //          sm:px-[max(64px,calc(50%-350px))]
      'px-16 text-base h-full',
      // disable: pt-4 for EventTest.java
      //          sm:px-[max(64px,calc(50%-350px))]
      demo: 'px-16 text-base h-full',
      // disable: pt-4 for EventTest.java
      fullWidth: 'px-16 text-base sm:px-24 h-full',
      none: '',
      select: 'px-3 py-2 text-base data-readonly:w-fit'
    }
  }
});
var Editor = react__WEBPACK_IMPORTED_MODULE_3__.forwardRef(function (_a, ref) {
  var className = _a.className,
    disabled = _a.disabled,
    focused = _a.focused,
    readOnly = _a.readOnly,
    variant = _a.variant,
    props = __rest(_a, ["className", "disabled", "focused", "readOnly", "variant"]);
  return react__WEBPACK_IMPORTED_MODULE_3__.createElement(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__.PlateContent, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)(editorVariants({
      disabled: disabled,
      focused: focused,
      variant: variant
    }), className),
    "data-plate-focus-id": (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__.useEditorRef)().id,
    disabled: disabled,
    readOnly: readOnly,
    disableDefaultStyles: true
  }, props));
});
Editor.displayName = 'Editor';


/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/heading-element-static.tsx":
/*!****************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/heading-element-static.tsx ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HeadingElementStatic: () => (/* binding */ HeadingElementStatic)
/* harmony export */ });
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! class-variance-authority */ "class-variance-authority");
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(class_variance_authority__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];




var headingVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_2__.cva)('relative mb-1', {
  variants: {
    variant: {
      h1: 'mt-[1.6em] pb-1 font-heading text-4xl font-bold',
      h2: 'mt-[1.4em] pb-px font-heading text-2xl font-semibold tracking-tight',
      h3: 'mt-[1em] pb-px font-heading text-xl font-semibold tracking-tight',
      h4: 'mt-[0.75em] font-heading text-lg font-semibold tracking-tight',
      h5: 'mt-[0.75em] text-lg font-semibold tracking-tight',
      h6: 'mt-[0.75em] text-base font-semibold tracking-tight'
    }
  }
});
var HeadingElementStatic = function (_a) {
  var children = _a.children,
    className = _a.className,
    _b = _a.variant,
    variant = _b === void 0 ? 'h1' : _b,
    props = __rest(_a, ["children", "className", "variant"]);
  return react__WEBPACK_IMPORTED_MODULE_3__.createElement(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.SlateElement, __assign({
    as: variant,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)(className, headingVariants({
      variant: variant
    }))
  }, props), children);
};

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/heading-element.tsx":
/*!*********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/heading-element.tsx ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HeadingElement: () => (/* binding */ HeadingElement)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! class-variance-authority */ "class-variance-authority");
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(class_variance_authority__WEBPACK_IMPORTED_MODULE_3__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];




var headingVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_3__.cva)('relative mb-1', {
    variants: {
      variant: {
        h1: 'mt-[1.6em] pb-1 font-heading text-4xl font-bold',
        h2: 'mt-[1.4em] pb-px font-heading text-2xl font-semibold tracking-tight',
        h3: 'mt-[1em] pb-px font-heading text-xl font-semibold tracking-tight',
        h4: 'mt-[0.75em] font-heading text-lg font-semibold tracking-tight',
        h5: 'mt-[0.75em] text-lg font-semibold tracking-tight',
        h6: 'mt-[0.75em] text-base font-semibold tracking-tight'
      }
    }
  }),
  HeadingElementVariants = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withVariants)(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.PlateElement, headingVariants, ['variant']);
var HeadingElement = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var children = _a.children,
    _b = _a.variant,
    variant = _b === void 0 ? 'h1' : _b,
    props = __rest(_a, ["children", "variant"]);
  var ghost = react__WEBPACK_IMPORTED_MODULE_0___default().useMemo(function () {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
      className: 'ghost',
      contentEditable: false
    });
  }, []);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(HeadingElementVariants, __assign({
    ref: ref,
    as: variant,
    variant: variant
  }, props), ghost, children);
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/highlight-leaf-static.tsx":
/*!***************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/highlight-leaf-static.tsx ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HighlightLeafStatic: () => (/* binding */ HighlightLeafStatic)
/* harmony export */ });
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];



function HighlightLeafStatic(_a) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  return react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.SlateLeaf, __assign({
    as: "mark",
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)(className, 'bg-highlight/30 text-inherit')
  }, props), children);
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/highlight-leaf.tsx":
/*!********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/highlight-leaf.tsx ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HighlightLeaf: () => (/* binding */ HighlightLeaf)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];



var HighlightLeaf = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.PlateLeaf, __assign({
    ref: ref,
    as: "mark",
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(className, 'bg-highlight/30 text-inherit')
  }, props), children);
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/image-element-static.tsx":
/*!**************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/image-element-static.tsx ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ImageElementStatic: () => (/* binding */ ImageElementStatic)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];



function ImageElementStatic(_a) {
  var children = _a.children,
    className = _a.className,
    nodeProps = _a.nodeProps,
    props = __rest(_a, ["children", "className", "nodeProps"]);
  var _b = props.element,
    // align = 'center',
    caption = _b.caption,
    url = _b.url,
    width = _b.width;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate__WEBPACK_IMPORTED_MODULE_2__.SlateElement, __assign({
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(className, 'py-2.5')
  }, props, {
    nodeProps: nodeProps
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("figure", {
    className: "group relative m-0 inline-block",
    style: {
      width: width
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "relative max-w-full min-w-[92px]"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("img", __assign({
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('cursor-default object-cover px-0', 'rounded-sm'),
    alt: "",
    src: url
  }, nodeProps)), caption && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("figcaption", {
    className: "mx-auto mt-2 h-[24px] max-w-full"
  }, _udecode_plate__WEBPACK_IMPORTED_MODULE_2__.NodeApi.string(caption[0])))), children);
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/image-element.tsx":
/*!*******************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/image-element.tsx ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ImageElement: () => (/* binding */ ImageElement)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_dnd__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @udecode/plate-dnd */ "./node_modules/@udecode/plate-dnd/dist/index.mjs");
/* harmony import */ var _udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @udecode/plate-media/react */ "./node_modules/@udecode/plate-media/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_resizable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-resizable */ "@udecode/plate-resizable");
/* harmony import */ var _udecode_plate_resizable__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_resizable__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';







// import {mediaResizeHandleVariants, Resizable, ResizeHandle,} from './resizable';
var ImageElement = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.withHOC)(_udecode_plate_resizable__WEBPACK_IMPORTED_MODULE_2__.ResizableProvider, (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    nodeProps = _a.nodeProps,
    props = __rest(_a, ["children", "className", "nodeProps"]);
  var _b = (0,_udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_4__.useMediaState)(),
    // align = 'center',
    focused = _b.focused,
    // readOnly,
    selected = _b.selected,
    // const width = useResizableValue('width');
    _c = (0,_udecode_plate_dnd__WEBPACK_IMPORTED_MODULE_5__.useDraggable)({
      element: props.element
    }),
    isDragging = _c.isDragging,
    handleRef = _c.handleRef;
  return (
    // <MediaPopover plugin={ImagePlugin}>
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.PlateElement, __assign({
      ref: ref,
      className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(className, 'py-2.5')
    }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("figure", {
      className: "group relative m-0",
      contentEditable: false
    }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_4__.Image, __assign({
      ref: handleRef,
      className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('block cursor-pointer object-cover px-0', 'rounded-sm', focused && selected && 'ring-2 ring-ring ring-offset-2', isDragging && 'opacity-50'),
      alt: ""
    }, nodeProps))), children)
    // </MediaPopover>
  );
}));

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/link-element-static.tsx":
/*!*************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/link-element-static.tsx ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LinkElementStatic: () => (/* binding */ LinkElementStatic)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];



var LinkElementStatic = function (_a) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate__WEBPACK_IMPORTED_MODULE_2__.SlateElement, __assign({
    as: "a",
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(className, 'font-medium text-primary underline decoration-primary underline-offset-4')
  }, props), children);
};

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/link-element.tsx":
/*!******************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/link-element.tsx ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LinkElement: () => (/* binding */ LinkElement)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate-link/react */ "./node_modules/@udecode/plate-link/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';





var LinkElement = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  var element = props.element;
  var linkProps = (0,_udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_3__.useLink)({
    element: element
  }).props;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.PlateElement, __assign({
    ref: ref,
    as: "a",
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(className, 'font-medium text-primary underline decoration-primary underline-offset-4')
  }, linkProps, props), children);
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/list-element.tsx":
/*!******************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/list-element.tsx ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ListElement: () => (/* binding */ ListElement)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! class-variance-authority */ "class-variance-authority");
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(class_variance_authority__WEBPACK_IMPORTED_MODULE_3__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';





var listVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_3__.cva)('m-0 ps-6', {
  variants: {
    variant: {
      ol: 'list-decimal',
      ul: 'list-disc [&_ul]:list-[circle] [&_ul_ul]:list-[square]'
    }
  }
});
var ListElementVariants = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withVariants)(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.PlateElement, listVariants, ['variant']);
var ListElement = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var children = _a.children,
    _b = _a.variant,
    variant = _b === void 0 ? 'ul' : _b,
    props = __rest(_a, ["children", "variant"]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ListElementVariants, __assign({
    ref: ref,
    as: variant,
    variant: variant
  }, props), children);
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/paragraph-element-static.tsx":
/*!******************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/paragraph-element-static.tsx ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ParagraphElementStatic: () => (/* binding */ ParagraphElementStatic)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];



var ParagraphElementStatic = function (_a) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate__WEBPACK_IMPORTED_MODULE_2__.SlateElement, __assign({
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(className, 'm-0 px-0 py-1')
  }, props), children);
};

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/paragraph-element.tsx":
/*!***********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/paragraph-element.tsx ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ParagraphElement: () => (/* binding */ ParagraphElement)
/* harmony export */ });
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];



var ParagraphElement = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_0__.withRef)(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  var ghost = react__WEBPACK_IMPORTED_MODULE_2__.useMemo(function () {
    return react__WEBPACK_IMPORTED_MODULE_2__.createElement("span", {
      className: 'ghost',
      contentEditable: false
    });
  }, []);
  return react__WEBPACK_IMPORTED_MODULE_2__.createElement(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_0__.PlateElement, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(className, 'm-0 px-0 py-1')
  }, props), ghost, children);
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/resizable.tsx":
/*!***************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/resizable.tsx ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Resizable: () => (/* binding */ Resizable),
/* harmony export */   ResizeHandle: () => (/* binding */ ResizeHandle),
/* harmony export */   mediaResizeHandleVariants: () => (/* binding */ mediaResizeHandleVariants)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_resizable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-resizable */ "@udecode/plate-resizable");
/* harmony import */ var _udecode_plate_resizable__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_resizable__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! class-variance-authority */ "class-variance-authority");
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(class_variance_authority__WEBPACK_IMPORTED_MODULE_3__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];




var mediaResizeHandleVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_3__.cva)((0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('top-0 flex w-6 flex-col justify-center select-none', "after:flex after:h-16 after:w-[3px] after:rounded-[6px] after:bg-ring after:opacity-0 after:content-['_'] group-hover:after:opacity-100"), {
  variants: {
    direction: {
      left: '-left-3 -ml-3 pl-3',
      right: '-right-3 -mr-3 items-end pr-3'
    }
  }
});
var resizeHandleVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_3__.cva)((0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('absolute z-40'), {
    variants: {
      direction: {
        bottom: 'w-full cursor-row-resize',
        left: 'h-full cursor-col-resize',
        right: 'h-full cursor-col-resize',
        top: 'w-full cursor-row-resize'
      }
    }
  }),
  ResizeHandleVariants = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withVariants)((0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.createPrimitiveElement)('div'), resizeHandleVariants, ['direction']);
var ResizeHandle = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var options = _a.options,
    props = __rest(_a, ["options"]);
  var state = (0,_udecode_plate_resizable__WEBPACK_IMPORTED_MODULE_2__.useResizeHandleState)(options !== null && options !== void 0 ? options : {}),
    resizeHandle = (0,_udecode_plate_resizable__WEBPACK_IMPORTED_MODULE_2__.useResizeHandle)(state);
  if (state.readOnly) return undefined;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ResizeHandleVariants, __assign({
    ref: ref,
    "data-resizing": state.isResizing,
    direction: options === null || options === void 0 ? void 0 : options.direction
  }, resizeHandle.props, props));
});
var resizableVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_3__.cva)('', {
  variants: {
    align: {
      center: 'mx-auto',
      left: 'mr-auto',
      right: 'ml-auto'
    }
  }
});
var Resizable = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withVariants)(_udecode_plate_resizable__WEBPACK_IMPORTED_MODULE_2__.Resizable, resizableVariants, ['align']);

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-cell-element-static.tsx":
/*!*******************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-cell-element-static.tsx ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableCellElementStatic: () => (/* binding */ TableCellElementStatic),
/* harmony export */   TableCellHeaderStaticElement: () => (/* binding */ TableCellHeaderStaticElement)
/* harmony export */ });
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_table__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-table */ "@udecode/plate-table");
/* harmony import */ var _udecode_plate_table__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_table__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];




function TableCellElementStatic(_a) {
  var _b, _c, _d, _e;
  var children = _a.children,
    className = _a.className,
    isHeader = _a.isHeader,
    style = _a.style,
    props = __rest(_a, ["children", "className", "isHeader", "style"]);
  var editor = props.editor,
    element = props.element;
  var api = editor.getPlugin(_udecode_plate_table__WEBPACK_IMPORTED_MODULE_2__.BaseTablePlugin).api;
  var _f = api.table.getCellSize({
      element: element
    }),
    minHeight = _f.minHeight,
    width = _f.width;
  var borders = api.table.getCellBorders({
    element: element
  });
  return react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.SlateElement, __assign({
    as: isHeader ? 'th' : 'td',
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)(className, 'h-full overflow-visible border-none bg-background p-0', element.background ? 'bg-(--cellBackground)' : 'bg-background', (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)(isHeader && 'text-left font-normal *:m-0', 'before:size-full', "before:absolute before:box-border before:content-[''] before:select-none", borders && (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)(((_b = borders.bottom) === null || _b === void 0 ? void 0 : _b.size) && "before:border-b before:border-b-border", ((_c = borders.right) === null || _c === void 0 ? void 0 : _c.size) && "before:border-r before:border-r-border", ((_d = borders.left) === null || _d === void 0 ? void 0 : _d.size) && "before:border-l before:border-l-border", ((_e = borders.top) === null || _e === void 0 ? void 0 : _e.size) && "before:border-t before:border-t-border"))),
    style: __assign({
      '--cellBackground': element.background,
      maxWidth: width || 240,
      minWidth: width || 120
    }, style),
    colSpan: api.table.getColSpan(element),
    rowSpan: api.table.getRowSpan(element)
  }, props), react__WEBPACK_IMPORTED_MODULE_3___default().createElement("div", {
    className: "relative z-20 box-border h-full px-4 py-2",
    style: {
      minHeight: minHeight
    }
  }, children));
}
function TableCellHeaderStaticElement(props) {
  return react__WEBPACK_IMPORTED_MODULE_3___default().createElement(TableCellElementStatic, __assign({}, props, {
    isHeader: true
  }));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-cell-element.tsx":
/*!************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-cell-element.tsx ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableCellElement: () => (/* binding */ TableCellElement),
/* harmony export */   TableCellHeaderElement: () => (/* binding */ TableCellHeaderElement)
/* harmony export */ });
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate_selection_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate-selection/react */ "@udecode/plate-selection/react");
/* harmony import */ var _udecode_plate_selection_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_selection_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @udecode/plate-table/react */ "./node_modules/@udecode/plate-table/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _block_selection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./block-selection */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/block-selection.tsx");
/* harmony import */ var _resizable__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./resizable */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/resizable.tsx");
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];







var TableCellElement = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withRef)(function (_a, ref) {
  var _b, _c, _d, _e;
  var children = _a.children,
    className = _a.className,
    isHeader = _a.isHeader,
    style = _a.style,
    props = __rest(_a, ["children", "className", "isHeader", "style"]);
  var api = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useEditorPlugin)(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__.TablePlugin).api,
    readOnly = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useReadOnly)(),
    element = props.element,
    rowId = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useElementSelector)(function (_a) {
      var node = _a[0];
      return node.id;
    }, [], {
      key: _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__.TableRowPlugin.key
    }),
    isSelectingRow = (0,_udecode_plate_selection_react__WEBPACK_IMPORTED_MODULE_1__.useBlockSelected)(rowId),
    // isSelectionAreaVisible = usePluginOption(
    //     BlockSelectionPlugin,
    //     'isSelectionAreaVisible'
    // ),
    _f = (0,_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__.useTableCellElement)(),
    borders = _f.borders,
    colIndex = _f.colIndex,
    colSpan = _f.colSpan,
    minHeight = _f.minHeight,
    rowIndex = _f.rowIndex,
    selected = _f.selected,
    width = _f.width,
    _g = (0,_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__.useTableCellElementResizable)({
      colIndex: colIndex,
      colSpan: colSpan,
      rowIndex: rowIndex
    }),
    bottomProps = _g.bottomProps,
    hiddenLeft = _g.hiddenLeft,
    leftProps = _g.leftProps,
    rightProps = _g.rightProps,
    ghost = react__WEBPACK_IMPORTED_MODULE_3__.useMemo(function () {
      return react__WEBPACK_IMPORTED_MODULE_3__.createElement("span", {
        className: 'ghost',
        contentEditable: false
      });
    }, []);
  return react__WEBPACK_IMPORTED_MODULE_3__.createElement(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.PlateElement, __assign({
    ref: ref,
    as: isHeader ? 'th' : 'td',
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)(className, 'h-full overflow-visible border-none bg-background p-0', element.background ? 'bg-(--cellBackground)' : 'bg-background', isHeader && 'text-left *:m-0', 'before:size-full', selected && 'before:z-10 before:bg-brand/5', "before:absolute before:box-border before:content-[''] before:select-none", ((_b = borders.bottom) === null || _b === void 0 ? void 0 : _b.size) && 'before:border-b before:border-b-border', ((_c = borders.right) === null || _c === void 0 ? void 0 : _c.size) && 'before:border-r before:border-r-border', ((_d = borders.left) === null || _d === void 0 ? void 0 : _d.size) && 'before:border-l before:border-l-border', ((_e = borders.top) === null || _e === void 0 ? void 0 : _e.size) && 'before:border-t before:border-t-border'),
    style: __assign(__assign({}, style), {
      '--cellBackground': element.background,
      maxWidth: width || 240,
      minWidth: width || 120
    }),
    colSpan: api.table.getColSpan(element),
    rowSpan: api.table.getRowSpan(element)
  }, props), react__WEBPACK_IMPORTED_MODULE_3__.createElement("div", {
    className: "relative z-20 box-border h-full px-3 py-2",
    style: {
      minHeight: minHeight
    }
  }, ghost, children), react__WEBPACK_IMPORTED_MODULE_3__.createElement("div", {
    className: "group absolute top-0 size-full select-none",
    contentEditable: false,
    suppressContentEditableWarning: true
  }, !readOnly && react__WEBPACK_IMPORTED_MODULE_3__.createElement(react__WEBPACK_IMPORTED_MODULE_3__.Fragment, null, react__WEBPACK_IMPORTED_MODULE_3__.createElement(_resizable__WEBPACK_IMPORTED_MODULE_5__.ResizeHandle, __assign({}, rightProps, {
    className: "-top-2 -right-1 h-[calc(100%_+_8px)] w-2",
    "data-col": colIndex
  })), react__WEBPACK_IMPORTED_MODULE_3__.createElement(_resizable__WEBPACK_IMPORTED_MODULE_5__.ResizeHandle, __assign({}, bottomProps, {
    className: "-bottom-1 h-2"
  })), !hiddenLeft && react__WEBPACK_IMPORTED_MODULE_3__.createElement(_resizable__WEBPACK_IMPORTED_MODULE_5__.ResizeHandle, __assign({}, leftProps, {
    className: "top-0 -left-1 w-2",
    "data-resizer-left": colIndex === 0 ? 'true' : undefined
  })), react__WEBPACK_IMPORTED_MODULE_3__.createElement("div", {
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)('absolute top-0 z-30 hidden h-full w-1 bg-ring', 'right-[-1.5px]')
  }))), isSelectingRow && react__WEBPACK_IMPORTED_MODULE_3__.createElement("div", {
    className: (0,_block_selection__WEBPACK_IMPORTED_MODULE_4__.blockSelectionVariants)(),
    contentEditable: false
  }));
});
var TableCellHeaderElement = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(TableCellElement, {
  isHeader: true
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-element-static.tsx":
/*!**************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-element-static.tsx ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableElementStatic: () => (/* binding */ TableElementStatic)
/* harmony export */ });
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_table__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-table */ "@udecode/plate-table");
/* harmony import */ var _udecode_plate_table__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_table__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];




var TableElementStatic = function (_a) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  var disableMarginLeft = props.editor.getOptions(_udecode_plate_table__WEBPACK_IMPORTED_MODULE_2__.BaseTablePlugin).disableMarginLeft;
  var marginLeft = disableMarginLeft ? 0 : props.element.marginLeft;
  return react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.SlateElement, __assign({
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)(className, 'overflow-x-auto py-5'),
    style: {
      paddingLeft: marginLeft
    }
  }, props), react__WEBPACK_IMPORTED_MODULE_3___default().createElement("div", {
    className: "group/table relative w-fit"
  }, react__WEBPACK_IMPORTED_MODULE_3___default().createElement("table", {
    className: "mr-0 ml-px table h-px table-fixed border-collapse"
  }, react__WEBPACK_IMPORTED_MODULE_3___default().createElement("tbody", {
    className: "min-w-full"
  }, children))));
};

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-element.tsx":
/*!*******************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-element.tsx ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableBordersDropdownMenuContent: () => (/* binding */ TableBordersDropdownMenuContent),
/* harmony export */   TableElement: () => (/* binding */ TableElement),
/* harmony export */   TableFloatingToolbar: () => (/* binding */ TableFloatingToolbar)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _radix_ui_react_popover__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @radix-ui/react-popover */ "./node_modules/@radix-ui/react-popover/dist/index.mjs");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_table__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-table */ "@udecode/plate-table");
/* harmony import */ var _udecode_plate_table__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_table__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @udecode/plate-table/react */ "./node_modules/@udecode/plate-table/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/paint-bucket.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/combine.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/square-split-horizontal.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/grid-2x2.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/trash-2.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/arrow-up.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/arrow-down.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/x.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/arrow-left.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/arrow-right.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/eraser.js");
/* harmony import */ var _toolbar_color_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../toolbar/color-constants */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-constants.ts");
/* harmony import */ var _toolbar_color_dropdown_menu_items__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../toolbar/color-dropdown-menu-items */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-dropdown-menu-items.tsx");
/* harmony import */ var _toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../toolbar/dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/dropdown-menu.tsx");
/* harmony import */ var _toolbar_popover__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../toolbar/popover */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/popover.tsx");
/* harmony import */ var _toolbar_table_icons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../toolbar/table-icons */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/table-icons.tsx");
/* harmony import */ var _toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../toolbar/toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';














var TableElement = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.withHOC)(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_10__.TableProvider, (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  var readOnly = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useReadOnly)();
  // const isSelectionAreaVisible = usePluginOption(
  //     BlockSelectionPlugin,
  //     'isSelectionAreaVisible'
  // );
  // const hasControls = !readOnly && !isSelectionAreaVisible;
  var selected = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useSelected)();
  var _b = (0,_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_10__.useTableElement)(),
    isSelectingCell = _b.isSelectingCell,
    marginLeft = _b.marginLeft,
    tableProps = _b.props;
  var ghost = react__WEBPACK_IMPORTED_MODULE_0___default().useMemo(function () {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("thead", {
      className: 'ghost',
      contentEditable: false
    });
  }, []);
  var content = react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.PlateElement, __assign({
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(className, 'overflow-x-auto py-5'),
    style: {
      paddingLeft: marginLeft
    }
  }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "group/table relative w-fit"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("table", __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('mr-0 ml-px table h-px table-fixed border-collapse', isSelectingCell && 'selection:bg-transparent')
  }, tableProps), ghost, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("tbody", {
    className: "min-w-full"
  }, children))));
  if (readOnly || !selected) {
    return content;
  }
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(TableFloatingToolbar, null, content);
}));
var TableFloatingToolbar = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var children = _a.children,
    props = __rest(_a, ["children"]);
  var tf = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorPlugin)(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_10__.TablePlugin).tf;
  var element = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useElement)();
  var buttonProps = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useRemoveNodeButton)({
    element: element
  }).props;
  var collapsed = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorSelector)(function (editor) {
    return !editor.api.isExpanded();
  }, []);
  var _b = (0,_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_10__.useTableMergeState)(),
    canMerge = _b.canMerge,
    canSplit = _b.canSplit;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_popover__WEBPACK_IMPORTED_MODULE_7__.Popover, {
    open: canMerge || canSplit || collapsed,
    modal: false
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_radix_ui_react_popover__WEBPACK_IMPORTED_MODULE_11__.PopoverAnchor, {
    asChild: true
  }, children), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_popover__WEBPACK_IMPORTED_MODULE_7__.PopoverContent, __assign({
    ref: ref,
    asChild: true,
    onOpenAutoFocus: function (e) {
      return e.preventDefault();
    },
    contentEditable: false
  }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.Toolbar, {
    className: "flex scrollbar-hide w-auto max-w-[80vw] flex-row overflow-x-auto rounded-md border bg-popover p-1 shadow-md print:hidden",
    contentEditable: false
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarGroup, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ColorDropdownMenu, {
    tooltip: "Background color"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_12__["default"], null)), canMerge && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarButton, {
    onClick: function () {
      return tf.table.merge();
    },
    onMouseDown: function (e) {
      return e.preventDefault();
    },
    tooltip: "Merge cells"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_13__["default"], null)), canSplit && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarButton, {
    onClick: function () {
      return tf.table.split();
    },
    onMouseDown: function (e) {
      return e.preventDefault();
    },
    tooltip: "Split cell"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_14__["default"], null)), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenu, {
    modal: false
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuTrigger, {
    asChild: true
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarButton, {
    tooltip: "Cell borders"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_15__["default"], null))), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuPortal, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(TableBordersDropdownMenuContent, null))), collapsed && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarGroup, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarButton, __assign({
    tooltip: "Delete table"
  }, buttonProps), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_16__["default"], null)))), collapsed && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarGroup, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarButton, {
    onClick: function () {
      tf.insert.tableRow({
        before: true
      });
    },
    onMouseDown: function (e) {
      return e.preventDefault();
    },
    tooltip: "Insert row before"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_17__["default"], null)), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarButton, {
    onClick: function () {
      tf.insert.tableRow();
    },
    onMouseDown: function (e) {
      return e.preventDefault();
    },
    tooltip: "Insert row after"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_18__["default"], null)), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarButton, {
    onClick: function () {
      tf.remove.tableRow();
    },
    onMouseDown: function (e) {
      return e.preventDefault();
    },
    tooltip: "Delete row"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_19__["default"], null))), collapsed && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarGroup, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarButton, {
    onClick: function () {
      tf.insert.tableColumn({
        before: true
      });
    },
    onMouseDown: function (e) {
      return e.preventDefault();
    },
    tooltip: "Insert column before"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_20__["default"], null)), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarButton, {
    onClick: function () {
      tf.insert.tableColumn();
    },
    onMouseDown: function (e) {
      return e.preventDefault();
    },
    tooltip: "Insert column after"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_21__["default"], null)), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarButton, {
    onClick: function () {
      tf.remove.tableColumn();
    },
    onMouseDown: function (e) {
      return e.preventDefault();
    },
    tooltip: "Delete column"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_19__["default"], null))))));
});
var TableBordersDropdownMenuContent = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (props, ref) {
  var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorRef)();
  var _a = (0,_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_10__.useTableBordersDropdownMenuContentState)(),
    getOnSelectTableBorder = _a.getOnSelectTableBorder,
    hasBottomBorder = _a.hasBottomBorder,
    hasLeftBorder = _a.hasLeftBorder,
    hasNoBorders = _a.hasNoBorders,
    hasOuterBorders = _a.hasOuterBorders,
    hasRightBorder = _a.hasRightBorder,
    hasTopBorder = _a.hasTopBorder;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuContent, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('min-w-[220px]'),
    onCloseAutoFocus: function (e) {
      e.preventDefault();
      editor.tf.focus();
    },
    align: "start",
    side: "right",
    sideOffset: 0
  }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuGroup, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuCheckboxItem, {
    checked: hasTopBorder,
    onCheckedChange: getOnSelectTableBorder('top')
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_table_icons__WEBPACK_IMPORTED_MODULE_8__.BorderTop, null), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "Top Border")), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuCheckboxItem, {
    checked: hasRightBorder,
    onCheckedChange: getOnSelectTableBorder('right')
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_table_icons__WEBPACK_IMPORTED_MODULE_8__.BorderRight, null), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "Right Border")), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuCheckboxItem, {
    checked: hasBottomBorder,
    onCheckedChange: getOnSelectTableBorder('bottom')
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_table_icons__WEBPACK_IMPORTED_MODULE_8__.BorderBottom, null), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "Bottom Border")), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuCheckboxItem, {
    checked: hasLeftBorder,
    onCheckedChange: getOnSelectTableBorder('left')
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_table_icons__WEBPACK_IMPORTED_MODULE_8__.BorderLeft, null), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "Left Border"))), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuGroup, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuCheckboxItem, {
    checked: hasNoBorders,
    onCheckedChange: getOnSelectTableBorder('none')
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_table_icons__WEBPACK_IMPORTED_MODULE_8__.BorderNone, null), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "No Border")), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuCheckboxItem, {
    checked: hasOuterBorders,
    onCheckedChange: getOnSelectTableBorder('outer')
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_table_icons__WEBPACK_IMPORTED_MODULE_8__.BorderAll, null), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "Outside Borders"))));
});
function ColorDropdownMenu(_a) {
  var children = _a.children,
    tooltip = _a.tooltip;
  var _b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    open = _b[0],
    setOpen = _b[1];
  var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorRef)();
  var selectedCells = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.usePluginOption)(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_10__.TablePlugin, 'selectedCells');
  var onUpdateColor = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (color) {
    setOpen(false);
    (0,_udecode_plate_table__WEBPACK_IMPORTED_MODULE_2__.setCellBackground)(editor, {
      color: color,
      selectedCells: selectedCells !== null && selectedCells !== void 0 ? selectedCells : []
    });
  }, [selectedCells, editor]);
  var onClearColor = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    setOpen(false);
    (0,_udecode_plate_table__WEBPACK_IMPORTED_MODULE_2__.setCellBackground)(editor, {
      color: null,
      selectedCells: selectedCells !== null && selectedCells !== void 0 ? selectedCells : []
    });
  }, [selectedCells, editor]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenu, {
    open: open,
    onOpenChange: setOpen,
    modal: false
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuTrigger, {
    asChild: true
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_toolbar__WEBPACK_IMPORTED_MODULE_9__.ToolbarButton, {
    tooltip: tooltip
  }, children)), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuContent, {
    align: "start"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuGroup, {
    label: "Colors"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_color_dropdown_menu_items__WEBPACK_IMPORTED_MODULE_5__.ColorDropdownMenuItems, {
    className: "px-2",
    colors: _toolbar_color_constants__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_COLORS,
    updateColor: onUpdateColor
  })), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuGroup, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.DropdownMenuItem, {
    className: "p-2",
    onClick: onClearColor
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_22__["default"], null), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Clear")))));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-row-element-static.tsx":
/*!******************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-row-element-static.tsx ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableRowElementStatic: () => (/* binding */ TableRowElementStatic)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];



function TableRowElementStatic(_a) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate__WEBPACK_IMPORTED_MODULE_2__.SlateElement, __assign({
    as: "tr",
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(className, 'h-full')
  }, props), children);
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-row-element.tsx":
/*!***********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-row-element.tsx ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableRowElement: () => (/* binding */ TableRowElement)
/* harmony export */ });
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_dnd__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @udecode/plate-dnd */ "./node_modules/@udecode/plate-dnd/dist/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];





var TableRowElement = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withRef)(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  // usePluginOption(
  //     BlockSelectionPlugin,
  //     'isSelectionAreaVisible'
  // );
  var element = props.element,
    selected = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useSelected)(),
    editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useEditorRef)(),
    previewRef = (0,_udecode_plate_dnd__WEBPACK_IMPORTED_MODULE_4__.useDraggable)({
      element: element,
      type: element.type,
      canDropNode: function (_a) {
        var dragEntry = _a.dragEntry,
          dropEntry = _a.dropEntry;
        return _udecode_plate__WEBPACK_IMPORTED_MODULE_1__.PathApi.equals(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.PathApi.parent(dragEntry[1]), _udecode_plate__WEBPACK_IMPORTED_MODULE_1__.PathApi.parent(dropEntry[1]));
      },
      onDropHandler: function (_, _a) {
        var dragItem = _a.dragItem;
        var dragElement = dragItem['element'];
        if (dragElement) {
          editor.tf.select(dragElement);
        }
      }
    }).previewRef,
    ghost = react__WEBPACK_IMPORTED_MODULE_3__.useMemo(function () {
      return react__WEBPACK_IMPORTED_MODULE_3__.createElement("th", {
        className: 'ghost',
        contentEditable: false
      });
    }, []);
  return react__WEBPACK_IMPORTED_MODULE_3__.createElement(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.PlateElement, __assign({
    ref: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.useComposedRef)(ref, previewRef),
    as: "tr",
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.cn)(className, 'group/row'),
    "data-selected": selected ? 'true' : undefined
  }, props), ghost, children);
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/create-plate-plugins.ts":
/*!**************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/create-plate-plugins.ts ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PARAGRAPH_KEYS: () => (/* binding */ PARAGRAPH_KEYS),
/* harmony export */   createPlatePlugins: () => (/* binding */ createPlatePlugins)
/* harmony export */ });
/* harmony import */ var _plate_components_draggable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @plate/components/draggable */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/draggable.tsx");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_alignment_react__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @udecode/plate-alignment/react */ "./node_modules/@udecode/plate-alignment/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @udecode/plate-basic-marks/react */ "./node_modules/@udecode/plate-basic-marks/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_break_react__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @udecode/plate-break/react */ "./node_modules/@udecode/plate-break/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_csv__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-csv */ "@udecode/plate-csv");
/* harmony import */ var _udecode_plate_csv__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_csv__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _udecode_plate_dnd__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @udecode/plate-dnd */ "./node_modules/@udecode/plate-dnd/dist/index.mjs");
/* harmony import */ var _udecode_plate_docx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate-docx */ "@udecode/plate-docx");
/* harmony import */ var _udecode_plate_docx__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_docx__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @udecode/plate-font/react */ "./node_modules/@udecode/plate-font/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @udecode/plate-heading */ "@udecode/plate-heading");
/* harmony import */ var _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _udecode_plate_heading_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @udecode/plate-heading/react */ "./node_modules/@udecode/plate-heading/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_highlight_react__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @udecode/plate-highlight/react */ "./node_modules/@udecode/plate-highlight/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_indent_react__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @udecode/plate-indent/react */ "./node_modules/@udecode/plate-indent/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_line_height_react__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @udecode/plate-line-height/react */ "./node_modules/@udecode/plate-line-height/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_list__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @udecode/plate-list */ "./node_modules/@udecode/plate-list/dist/index.mjs");
/* harmony import */ var _udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @udecode/plate-list/react */ "./node_modules/@udecode/plate-list/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @udecode/plate-media/react */ "./node_modules/@udecode/plate-media/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_select__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @udecode/plate-select */ "@udecode/plate-select");
/* harmony import */ var _udecode_plate_select__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_select__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @udecode/plate-table/react */ "./node_modules/@udecode/plate-table/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _plate_plugins_link_plugin__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @plate/plugins/link-plugin */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/plugins/link-plugin.tsx");
/* harmony import */ var _udecode_plate_emoji_react__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @udecode/plate-emoji/react */ "./node_modules/@udecode/plate-emoji/dist/react/index.mjs");
/* harmony import */ var _emoji_mart_data__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @emoji-mart/data */ "./node_modules/@emoji-mart/data/sets/15/native.json");
/* harmony import */ var _udecode_plate_block_quote_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @udecode/plate-block-quote/react */ "./node_modules/@udecode/plate-block-quote/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_node_id__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @udecode/plate-node-id */ "./node_modules/@udecode/plate-node-id/dist/index.mjs");

























var PARAGRAPH_KEYS = [_udecode_plate_react__WEBPACK_IMPORTED_MODULE_6__.ParagraphPlugin.key, _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_4__.HEADING_KEYS.h1, _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_4__.HEADING_KEYS.h2, _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_4__.HEADING_KEYS.h3, _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_4__.HEADING_KEYS.h4, _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_4__.HEADING_KEYS.h5, _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_4__.HEADING_KEYS.h6];
var createPlatePlugins = function (emitter) {
  return [
  // Node Id
  _udecode_plate_node_id__WEBPACK_IMPORTED_MODULE_8__.NodeIdPlugin.configure({
    options: {
      normalizeInitialValue: true
    }
  }),
  // Nodes
  _udecode_plate_react__WEBPACK_IMPORTED_MODULE_6__.ParagraphPlugin.overrideEditor(function (_a) {
    var editor = _a.editor,
      normalizeNode = _a.tf.normalizeNode;
    return {
      transforms: {
        // wrap consecutive text nodes in paragraph
        normalizeNode: function (_a) {
          var node = _a[0],
            path = _a[1];
          if (_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.NodeApi.isEditor(node)) {
            var wasNextText = false;
            for (var _i = 0, _b = Array.from(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.NodeApi.children(node, path, {
                reverse: true
              })); _i < _b.length; _i++) {
              var _c = _b[_i],
                child = _c[0],
                childPath = _c[1];
              if (_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.TextApi.isText(child)) {
                if (wasNextText) {
                  editor.tf.moveNodes({
                    at: childPath,
                    to: _udecode_plate__WEBPACK_IMPORTED_MODULE_1__.PathApi.firstChild(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.PathApi.next(childPath))
                  });
                } else {
                  editor.tf.wrapNodes({
                    type: _udecode_plate_react__WEBPACK_IMPORTED_MODULE_6__.ParagraphPlugin.key,
                    children: [child]
                  }, {
                    at: childPath
                  });
                }
                wasNextText = true;
              } else wasNextText = false;
            }
            // ensure editor remains non-empty
            if (node.children.length === 0) {
              editor.tf.insertNode({
                type: _udecode_plate_react__WEBPACK_IMPORTED_MODULE_6__.ParagraphPlugin.key,
                children: [{
                  text: ''
                }]
              });
            }
          }
          normalizeNode([node, path]);
        }
      }
    };
  }), _udecode_plate_heading_react__WEBPACK_IMPORTED_MODULE_9__.HeadingPlugin, _udecode_plate_block_quote_react__WEBPACK_IMPORTED_MODULE_10__.BlockquotePlugin, _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_11__.TablePlugin,
  // Paragraph Style
  _udecode_plate_alignment_react__WEBPACK_IMPORTED_MODULE_12__.AlignPlugin.configure({
    inject: {
      targetPlugins: PARAGRAPH_KEYS
    }
  }),
  // ListPlugin must be before IndentPlugin for tab and shift+tab to work
  _udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_13__.ListPlugin.configure({
    options: {
      enableResetOnShiftTab: true,
      validLiChildrenTypes: Object.values(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_4__.HEADING_KEYS)
    }
  }).extendEditorTransforms(function (_a) {
    var editor = _a.editor;
    return {
      toggle: {
        list: function (_a) {
          var type = _a.type;
          return editor.tf.withoutNormalizing(function () {
            /* Potix: Fix toolbar action after grid cell selection */
            var selectedCells = editor.getOptions(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_11__.TablePlugin).selectedCells;
            if (selectedCells && selectedCells.length > 0) {
              var shouldUnwrapList = selectedCells.every(function (cell) {
                return cell.children.length === 1 && cell.children[0].type === type;
              });
              if (shouldUnwrapList) {
                selectedCells.forEach(function (cell) {
                  var cellPath = editor.api.findPath(cell);
                  if (cellPath) (0,_udecode_plate_list__WEBPACK_IMPORTED_MODULE_14__.unwrapList)(editor, {
                    at: cellPath
                  });
                });
                return;
              }
              var validLiChildrenTypes_1 = editor.getOptions(_udecode_plate_list__WEBPACK_IMPORTED_MODULE_14__.BaseListPlugin).validLiChildrenTypes;
              selectedCells.forEach(function (cell) {
                var cellPath = editor.api.findPath(cell);
                if (cellPath) {
                  var commonEntry = [cell, cellPath];
                  var rootPathLength_1 = commonEntry[1].length;
                  var _nodes = editor.api.nodes({
                    at: commonEntry[1],
                    mode: 'all'
                  });
                  var nodes = Array.from(_nodes).filter(function (_a) {
                    var path = _a[1];
                    return path.length === rootPathLength_1 + 1;
                  });
                  nodes.forEach(function (n) {
                    if ((0,_udecode_plate_list__WEBPACK_IMPORTED_MODULE_14__.getListTypes)(editor).includes(n[0].type)) {
                      editor.tf.setNodes({
                        type: type
                      }, {
                        at: n[1],
                        mode: 'all',
                        match: function (_n) {
                          return _udecode_plate__WEBPACK_IMPORTED_MODULE_1__.ElementApi.isElement(_n) && (0,_udecode_plate_list__WEBPACK_IMPORTED_MODULE_14__.getListTypes)(editor).includes(_n.type);
                        }
                      });
                    } else {
                      if (!(validLiChildrenTypes_1 === null || validLiChildrenTypes_1 === void 0 ? void 0 : validLiChildrenTypes_1.includes(n[0].type))) {
                        editor.tf.setNodes({
                          type: editor.getType(_udecode_plate_list__WEBPACK_IMPORTED_MODULE_14__.BaseListItemContentPlugin)
                        }, {
                          at: n[1]
                        });
                      }
                      var listItem = {
                        children: [],
                        type: editor.getType(_udecode_plate_list__WEBPACK_IMPORTED_MODULE_14__.BaseListItemPlugin)
                      };
                      editor.tf.wrapNodes(listItem, {
                        at: n[1]
                      });
                      var list = {
                        children: [],
                        type: type
                      };
                      editor.tf.wrapNodes(list, {
                        at: n[1]
                      });
                    }
                  });
                }
              });
            } else (0,_udecode_plate_list__WEBPACK_IMPORTED_MODULE_14__.toggleList)(editor, {
              type: type
            });
          });
        }
      }
    };
  }), _udecode_plate_indent_react__WEBPACK_IMPORTED_MODULE_15__.IndentPlugin.configure({
    inject: {
      targetPlugins: PARAGRAPH_KEYS
    }
  }), _udecode_plate_line_height_react__WEBPACK_IMPORTED_MODULE_16__.LineHeightPlugin.configure({
    inject: {
      nodeProps: {
        defaultNodeValue: 1.5,
        validNodeValues: [1, 1.15, 1.5, 2, 2.5, 3]
      },
      targetPlugins: PARAGRAPH_KEYS,
      targetPluginToInject: function (_a) {
        var editor = _a.editor,
          plugin = _a.plugin;
        return {
          parsers: {
            html: {
              deserializer: {
                parse: function (_a) {
                  var _b;
                  var element = _a.element;
                  if (element.style.lineHeight) {
                    var lineHeight = Number(element.style.lineHeight);
                    if (!isNaN(lineHeight)) return _b = {}, _b[editor.getType(plugin)] = lineHeight, _b;
                  }
                }
              }
            }
          }
        };
      }
    }
  }),
  // Marks
  _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.BoldPlugin, _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.ItalicPlugin, _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.StrikethroughPlugin, _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.SubscriptPlugin, _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.SuperscriptPlugin, _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.UnderlinePlugin, _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.CodePlugin, _udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_18__.FontBackgroundColorPlugin, _udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_18__.FontColorPlugin, _udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_18__.FontFamilyPlugin, _udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_18__.FontSizePlugin, _udecode_plate_highlight_react__WEBPACK_IMPORTED_MODULE_19__.HighlightPlugin, _udecode_plate_break_react__WEBPACK_IMPORTED_MODULE_20__.SoftBreakPlugin, _plate_plugins_link_plugin__WEBPACK_IMPORTED_MODULE_7__.linkPlugin, _udecode_plate_emoji_react__WEBPACK_IMPORTED_MODULE_21__.EmojiPlugin.configure({
    options: {
      data: _emoji_mart_data__WEBPACK_IMPORTED_MODULE_22__
    }
  }),
  // Deserialization
  _udecode_plate_csv__WEBPACK_IMPORTED_MODULE_2__.CsvPlugin, _udecode_plate_docx__WEBPACK_IMPORTED_MODULE_3__.DocxPlugin,
  // Media
  _udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_23__.ImagePlugin, _udecode_plate_select__WEBPACK_IMPORTED_MODULE_5__.SelectOnBackspacePlugin.configure({
    options: {
      query: {
        allow: [_udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_23__.ImagePlugin.key]
      }
    }
  }),
  // Drag and Drop
  _udecode_plate_dnd__WEBPACK_IMPORTED_MODULE_24__.DndPlugin.configure({
    options: {
      enableScroller: true
    },
    render: {
      aboveNodes: _plate_components_draggable__WEBPACK_IMPORTED_MODULE_0__.DraggableAboveNodes
    }
  }), _udecode_plate_break_react__WEBPACK_IMPORTED_MODULE_20__.ExitBreakPlugin.configure({
    options: {
      rules: [{
        hotkey: 'mod+enter'
      }, {
        before: true,
        hotkey: 'mod+shift+enter'
      }]
    }
  })];
};

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/create-plate-ui.ts":
/*!*********************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/create-plate-ui.ts ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPlateUI: () => (/* binding */ createPlateUI)
/* harmony export */ });
/* harmony import */ var _plate_components_heading_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @plate/components/heading-element */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/heading-element.tsx");
/* harmony import */ var _plate_components_highlight_leaf__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @plate/components/highlight-leaf */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/highlight-leaf.tsx");
/* harmony import */ var _plate_components_paragraph_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @plate/components/paragraph-element */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/paragraph-element.tsx");
/* harmony import */ var _plate_components_table_cell_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @plate/components/table-cell-element */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-cell-element.tsx");
/* harmony import */ var _plate_components_table_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @plate/components/table-element */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-element.tsx");
/* harmony import */ var _plate_components_table_row_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @plate/components/table-row-element */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-row-element.tsx");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @udecode/plate-basic-marks/react */ "./node_modules/@udecode/plate-basic-marks/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @udecode/plate-heading */ "@udecode/plate-heading");
/* harmony import */ var _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _udecode_plate_highlight_react__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @udecode/plate-highlight/react */ "./node_modules/@udecode/plate-highlight/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @udecode/plate-table/react */ "./node_modules/@udecode/plate-table/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @udecode/plate-media/react */ "./node_modules/@udecode/plate-media/dist/react/index.mjs");
/* harmony import */ var _plate_components_image_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @plate/components/image-element */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/image-element.tsx");
/* harmony import */ var _udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @udecode/plate-list/react */ "./node_modules/@udecode/plate-list/dist/react/index.mjs");
/* harmony import */ var _plate_components_code_leaf__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @plate/components/code-leaf */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/code-leaf.tsx");
/* harmony import */ var _plate_components_list_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @plate/components/list-element */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/list-element.tsx");
/* harmony import */ var _udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @udecode/plate-link/react */ "./node_modules/@udecode/plate-link/dist/react/index.mjs");
/* harmony import */ var _plate_components_link_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @plate/components/link-element */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/link-element.tsx");
/* harmony import */ var _udecode_plate_block_quote_react__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @udecode/plate-block-quote/react */ "./node_modules/@udecode/plate-block-quote/dist/react/index.mjs");
/* harmony import */ var _plate_components_blockquote_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @plate/components/blockquote-element */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/blockquote-element.tsx");





















var createPlateUI = function (zclass, emitter) {
  var _a;
  return _a = {}, _a[_udecode_plate_react__WEBPACK_IMPORTED_MODULE_8__.ParagraphPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_paragraph_element__WEBPACK_IMPORTED_MODULE_2__.ParagraphElement, {
    className: "".concat(zclass, "-").concat(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_8__.ParagraphPlugin.key)
  }), _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7__.HEADING_KEYS.h1] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_heading_element__WEBPACK_IMPORTED_MODULE_0__.HeadingElement, {
    variant: 'h1',
    className: "".concat(zclass, "-").concat(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7__.HEADING_KEYS.h1)
  }), _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7__.HEADING_KEYS.h2] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_heading_element__WEBPACK_IMPORTED_MODULE_0__.HeadingElement, {
    variant: 'h2',
    className: "".concat(zclass, "-").concat(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7__.HEADING_KEYS.h2)
  }), _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7__.HEADING_KEYS.h3] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_heading_element__WEBPACK_IMPORTED_MODULE_0__.HeadingElement, {
    variant: 'h3',
    className: "".concat(zclass, "-").concat(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7__.HEADING_KEYS.h3)
  }), _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7__.HEADING_KEYS.h4] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_heading_element__WEBPACK_IMPORTED_MODULE_0__.HeadingElement, {
    variant: 'h4',
    className: "".concat(zclass, "-").concat(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7__.HEADING_KEYS.h4)
  }), _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7__.HEADING_KEYS.h5] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_heading_element__WEBPACK_IMPORTED_MODULE_0__.HeadingElement, {
    variant: 'h5',
    className: "".concat(zclass, "-").concat(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7__.HEADING_KEYS.h5)
  }), _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7__.HEADING_KEYS.h6] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_heading_element__WEBPACK_IMPORTED_MODULE_0__.HeadingElement, {
    variant: 'h6',
    className: "".concat(zclass, "-").concat(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_7__.HEADING_KEYS.h6)
  }), _a[_udecode_plate_block_quote_react__WEBPACK_IMPORTED_MODULE_14__.BlockquotePlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_blockquote_element__WEBPACK_IMPORTED_MODULE_13__.BlockquoteElement, {
    className: "".concat(zclass, "-").concat(_udecode_plate_block_quote_react__WEBPACK_IMPORTED_MODULE_14__.BlockquotePlugin.key)
  }), _a[_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_15__.TablePlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_table_element__WEBPACK_IMPORTED_MODULE_4__.TableElement, {
    className: "".concat(zclass, "-").concat(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_15__.TablePlugin.key)
  }), _a[_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_15__.TableRowPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_table_row_element__WEBPACK_IMPORTED_MODULE_5__.TableRowElement, {
    className: "".concat(zclass, "-").concat(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_15__.TableRowPlugin.key)
  }), _a[_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_15__.TableCellHeaderPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_table_cell_element__WEBPACK_IMPORTED_MODULE_3__.TableCellHeaderElement, {
    className: "".concat(zclass, "-").concat(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_15__.TableCellHeaderPlugin.key)
  }), _a[_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_15__.TableCellPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_table_cell_element__WEBPACK_IMPORTED_MODULE_3__.TableCellElement, {
    className: "".concat(zclass, "-").concat(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_15__.TableCellPlugin.key)
  }), _a[_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__.BoldPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_8__.PlateLeaf, {
    as: 'strong',
    className: "".concat(zclass, "-").concat(_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__.BoldPlugin.key)
  }), _a[_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__.ItalicPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_8__.PlateLeaf, {
    as: 'em',
    className: "".concat(zclass, "-").concat(_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__.ItalicPlugin.key)
  }), _a[_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__.StrikethroughPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_8__.PlateLeaf, {
    as: 's',
    className: "".concat(zclass, "-").concat(_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__.StrikethroughPlugin.key)
  }), _a[_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__.SubscriptPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_8__.PlateLeaf, {
    as: 'sub',
    className: "".concat(zclass, "-").concat(_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__.SubscriptPlugin.key)
  }), _a[_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__.SuperscriptPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_8__.PlateLeaf, {
    as: 'sup',
    className: "".concat(zclass, "-").concat(_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__.SuperscriptPlugin.key)
  }), _a[_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__.UnderlinePlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_8__.PlateLeaf, {
    as: 'u',
    className: "".concat(zclass, "-").concat(_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__.UnderlinePlugin.key)
  }), _a[_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__.CodePlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_code_leaf__WEBPACK_IMPORTED_MODULE_10__.CodeLeaf, {
    className: "".concat(zclass, "-").concat(_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_16__.CodePlugin.key)
  }), _a[_udecode_plate_highlight_react__WEBPACK_IMPORTED_MODULE_17__.HighlightPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_highlight_leaf__WEBPACK_IMPORTED_MODULE_1__.HighlightLeaf, {
    className: "".concat(zclass, "-").concat(_udecode_plate_highlight_react__WEBPACK_IMPORTED_MODULE_17__.HighlightPlugin.key)
  }),
  // media
  _a[_udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_18__.ImagePlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_image_element__WEBPACK_IMPORTED_MODULE_9__.ImageElement, {
    className: "".concat(zclass, "-").concat(_udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_18__.ImagePlugin.key)
  }),
  // list
  _a[_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_19__.BulletedListPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_list_element__WEBPACK_IMPORTED_MODULE_11__.ListElement, {
    variant: 'ul',
    className: "".concat(zclass, "-").concat(_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_19__.BulletedListPlugin.key)
  }), _a[_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_19__.NumberedListPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_list_element__WEBPACK_IMPORTED_MODULE_11__.ListElement, {
    variant: 'ol',
    className: "".concat(zclass, "-").concat(_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_19__.NumberedListPlugin.key)
  }), _a[_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_19__.ListItemPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_8__.PlateElement, {
    as: 'li',
    className: "".concat(zclass, "-").concat(_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_19__.ListItemPlugin.key)
  }),
  // link
  _a[_udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_20__.LinkPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_6__.withProps)(_plate_components_link_element__WEBPACK_IMPORTED_MODULE_12__.LinkElement, {
    className: "".concat(zclass, "-").concat(_udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_20__.LinkPlugin.key)
  }), _a;
};

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/create-static-components.ts":
/*!******************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/create-static-components.ts ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createStaticComponents: () => (/* binding */ createStaticComponents)
/* harmony export */ });
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @udecode/plate-basic-marks/react */ "./node_modules/@udecode/plate-basic-marks/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-heading */ "@udecode/plate-heading");
/* harmony import */ var _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _udecode_plate_highlight_react__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @udecode/plate-highlight/react */ "./node_modules/@udecode/plate-highlight/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @udecode/plate-table/react */ "./node_modules/@udecode/plate-table/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_heading_element_static__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./components/heading-element-static */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/heading-element-static.tsx");
/* harmony import */ var _components_highlight_leaf_static__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./components/highlight-leaf-static */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/highlight-leaf-static.tsx");
/* harmony import */ var _components_paragraph_element_static__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./components/paragraph-element-static */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/paragraph-element-static.tsx");
/* harmony import */ var _components_table_cell_element_static__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./components/table-cell-element-static */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-cell-element-static.tsx");
/* harmony import */ var _components_table_element_static__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./components/table-element-static */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-element-static.tsx");
/* harmony import */ var _components_table_row_element_static__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./components/table-row-element-static */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/table-row-element-static.tsx");
/* harmony import */ var _udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @udecode/plate-media/react */ "./node_modules/@udecode/plate-media/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @udecode/plate-list/react */ "./node_modules/@udecode/plate-list/dist/react/index.mjs");
/* harmony import */ var _components_list_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./components/list-element */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/list-element.tsx");
/* harmony import */ var _udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @udecode/plate-link/react */ "./node_modules/@udecode/plate-link/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_block_quote_react__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @udecode/plate-block-quote/react */ "./node_modules/@udecode/plate-block-quote/dist/react/index.mjs");
/* harmony import */ var _components_image_element_static__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./components/image-element-static */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/image-element-static.tsx");
/* harmony import */ var _components_code_leaf_static__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./components/code-leaf-static */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/code-leaf-static.tsx");
/* harmony import */ var _components_link_element_static__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./components/link-element-static */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/link-element-static.tsx");
/* harmony import */ var _components_blockquote_element_static__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./components/blockquote-element-static */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/components/blockquote-element-static.tsx");






















var createStaticComponents = function (zclass) {
  var _a;
  return _a = {}, /* Potix: Add {as: 'p'} to preserve paragraph styles in Document#setValue(getValue()) */
  _a[_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.ParagraphPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_paragraph_element_static__WEBPACK_IMPORTED_MODULE_6__.ParagraphElementStatic, {
    as: 'p',
    className: "".concat(zclass, "-").concat(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.ParagraphPlugin.key)
  }), _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2__.HEADING_KEYS.h1] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_heading_element_static__WEBPACK_IMPORTED_MODULE_4__.HeadingElementStatic, {
    variant: 'h1',
    className: "".concat(zclass, "-").concat(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2__.HEADING_KEYS.h1)
  }), _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2__.HEADING_KEYS.h2] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_heading_element_static__WEBPACK_IMPORTED_MODULE_4__.HeadingElementStatic, {
    variant: 'h2',
    className: "".concat(zclass, "-").concat(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2__.HEADING_KEYS.h2)
  }), _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2__.HEADING_KEYS.h3] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_heading_element_static__WEBPACK_IMPORTED_MODULE_4__.HeadingElementStatic, {
    variant: 'h3',
    className: "".concat(zclass, "-").concat(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2__.HEADING_KEYS.h3)
  }), _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2__.HEADING_KEYS.h4] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_heading_element_static__WEBPACK_IMPORTED_MODULE_4__.HeadingElementStatic, {
    variant: 'h4',
    className: "".concat(zclass, "-").concat(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2__.HEADING_KEYS.h4)
  }), _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2__.HEADING_KEYS.h5] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_heading_element_static__WEBPACK_IMPORTED_MODULE_4__.HeadingElementStatic, {
    variant: 'h5',
    className: "".concat(zclass, "-").concat(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2__.HEADING_KEYS.h5)
  }), _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2__.HEADING_KEYS.h6] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_heading_element_static__WEBPACK_IMPORTED_MODULE_4__.HeadingElementStatic, {
    variant: 'h6',
    className: "".concat(zclass, "-").concat(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_2__.HEADING_KEYS.h6)
  }), _a[_udecode_plate_block_quote_react__WEBPACK_IMPORTED_MODULE_15__.BlockquotePlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_blockquote_element_static__WEBPACK_IMPORTED_MODULE_14__.BlockquoteElementStatic, {
    className: "".concat(zclass, "-").concat(_udecode_plate_block_quote_react__WEBPACK_IMPORTED_MODULE_15__.BlockquotePlugin.key)
  }), _a[_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_16__.TablePlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_table_element_static__WEBPACK_IMPORTED_MODULE_8__.TableElementStatic, {
    className: "".concat(zclass, "-").concat(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_16__.TablePlugin.key)
  }), _a[_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_16__.TableRowPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_table_row_element_static__WEBPACK_IMPORTED_MODULE_9__.TableRowElementStatic, {
    className: "".concat(zclass, "-").concat(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_16__.TableRowPlugin.key)
  }), _a[_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_16__.TableCellHeaderPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_table_cell_element_static__WEBPACK_IMPORTED_MODULE_7__.TableCellHeaderStaticElement, {
    className: "".concat(zclass, "-").concat(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_16__.TableCellHeaderPlugin.key)
  }), _a[_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_16__.TableCellPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_table_cell_element_static__WEBPACK_IMPORTED_MODULE_7__.TableCellElementStatic, {
    className: "".concat(zclass, "-").concat(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_16__.TableCellPlugin.key)
  }), _a[_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.BoldPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.SlateLeaf, {
    as: 'strong',
    className: "".concat(zclass, "-").concat(_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.BoldPlugin.key)
  }), _a[_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.ItalicPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.SlateLeaf, {
    as: 'em',
    className: "".concat(zclass, "-").concat(_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.ItalicPlugin.key)
  }), _a[_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.StrikethroughPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.SlateLeaf, {
    as: 's',
    className: "".concat(zclass, "-").concat(_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.StrikethroughPlugin.key)
  }), _a[_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.SubscriptPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.SlateLeaf, {
    as: 'sub',
    className: "".concat(zclass, "-").concat(_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.SubscriptPlugin.key)
  }), _a[_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.SuperscriptPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.SlateLeaf, {
    as: 'sup',
    className: "".concat(zclass, "-").concat(_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.SuperscriptPlugin.key)
  }), _a[_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.UnderlinePlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.SlateLeaf, {
    as: 'u',
    className: "".concat(zclass, "-").concat(_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.UnderlinePlugin.key)
  }), _a[_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.CodePlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_code_leaf_static__WEBPACK_IMPORTED_MODULE_12__.CodeLeafStatic, {
    className: "".concat(zclass, "-").concat(_udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_17__.CodePlugin.key)
  }), _a[_udecode_plate_highlight_react__WEBPACK_IMPORTED_MODULE_18__.HighlightPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_highlight_leaf_static__WEBPACK_IMPORTED_MODULE_5__.HighlightLeafStatic, {
    className: "".concat(zclass, "-").concat(_udecode_plate_highlight_react__WEBPACK_IMPORTED_MODULE_18__.HighlightPlugin.key)
  }),
  // media
  _a[_udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_19__.ImagePlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_image_element_static__WEBPACK_IMPORTED_MODULE_11__.ImageElementStatic, {
    className: "".concat(zclass, "-").concat(_udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_19__.ImagePlugin.key)
  }),
  // list
  _a[_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_20__.BulletedListPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_list_element__WEBPACK_IMPORTED_MODULE_10__.ListElement, {
    variant: 'ul',
    className: "".concat(zclass, "-").concat(_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_20__.BulletedListPlugin.key)
  }), _a[_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_20__.NumberedListPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_list_element__WEBPACK_IMPORTED_MODULE_10__.ListElement, {
    variant: 'ol',
    className: "".concat(zclass, "-").concat(_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_20__.NumberedListPlugin.key)
  }), _a[_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_20__.ListItemPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.SlateElement, {
    as: 'li',
    className: "".concat(zclass, "-").concat(_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_20__.ListItemPlugin.key)
  }),
  // link
  _a[_udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_21__.LinkPlugin.key] = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_components_link_element_static__WEBPACK_IMPORTED_MODULE_13__.LinkElementStatic, {
    className: "".concat(zclass, "-").concat(_udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_21__.LinkPlugin.key)
  }), _a;
};

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/plugins/link-plugin.tsx":
/*!**************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/plugins/link-plugin.tsx ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   linkPlugin: () => (/* binding */ linkPlugin)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-link/react */ "./node_modules/@udecode/plate-link/dist/react/index.mjs");
/* harmony import */ var _plate_toolbar_link_floating_toolbar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @plate/toolbar/link-floating-toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/link-floating-toolbar.tsx");
'use client';




var linkPlugin = _udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_2__.LinkPlugin.extend({
  render: {
    afterEditable: function () {
      return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_plate_toolbar_link_floating_toolbar__WEBPACK_IMPORTED_MODULE_1__.LinkFloatingToolbar, null);
    }
  }
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/KKDocToolbar.tsx":
/*!***************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/KKDocToolbar.tsx ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   KKDocToolbar: () => (/* binding */ KKDocToolbar)
/* harmony export */ });
/* harmony import */ var _plate_toolbar_list_toolbar_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @plate/toolbar/list-toolbar-button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/list-toolbar-button.tsx");
/* harmony import */ var _udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @udecode/plate-list/react */ "./node_modules/@udecode/plate-list/dist/react/index.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _plate_toolbar_history_toolbar_button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @plate/toolbar/history-toolbar-button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/history-toolbar-button.tsx");
/* harmony import */ var _plate_toolbar_turn_into_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @plate/toolbar/turn-into-dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/turn-into-dropdown-menu.tsx");
/* harmony import */ var _plate_toolbar_mark_toolbar_button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @plate/toolbar/mark-toolbar-button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/mark-toolbar-button.tsx");
/* harmony import */ var _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @udecode/plate-basic-marks/react */ "./node_modules/@udecode/plate-basic-marks/dist/react/index.mjs");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/bold.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/italic.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/underline.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/strikethrough.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/superscript.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/subscript.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/code-xml.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/baseline.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/paint-bucket.js");
/* harmony import */ var _plate_toolbar_font_size_toolbar_button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @plate/toolbar/font-size-toolbar-button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/font-size-toolbar-button.tsx");
/* harmony import */ var _plate_toolbar_color_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @plate/toolbar/color-dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-dropdown-menu.tsx");
/* harmony import */ var _udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @udecode/plate-font/react */ "./node_modules/@udecode/plate-font/dist/react/index.mjs");
/* harmony import */ var _plate_toolbar_align_dropdown_menu__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @plate/toolbar/align-dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/align-dropdown-menu.tsx");
/* harmony import */ var _plate_toolbar_line_height_dropdown_menu__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @plate/toolbar/line-height-dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/line-height-dropdown-menu.tsx");
/* harmony import */ var _plate_toolbar_outdent_toolbar_button__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @plate/toolbar/outdent-toolbar-button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/outdent-toolbar-button.tsx");
/* harmony import */ var _plate_toolbar_indent_toolbar_button__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @plate/toolbar/indent-toolbar-button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/indent-toolbar-button.tsx");
/* harmony import */ var _plate_toolbar_link_toolbar_button__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @plate/toolbar/link-toolbar-button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/link-toolbar-button.tsx");
/* harmony import */ var _plate_toolbar_emoji_dropdown_menu__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @plate/toolbar/emoji-dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-dropdown-menu.tsx");
/* harmony import */ var _plate_toolbar_table_dropdown_menu__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @plate/toolbar/table-dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/table-dropdown-menu.tsx");
/* harmony import */ var _plate_toolbar_media_toolbar_button__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @plate/toolbar/media-toolbar-button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/media-toolbar-button.tsx");
/* harmony import */ var _udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! @udecode/plate-media/react */ "./node_modules/@udecode/plate-media/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _plate_toolbar_fixed_toolbar__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @plate/toolbar/fixed-toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/fixed-toolbar.tsx");
/* harmony import */ var _plate_toolbar_separator__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @plate/toolbar/separator */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/separator.tsx");























var toolsMap = {
    '-': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
        className: "mx-1.5 py-0.5 group-last/toolbar-group:hidden!",
        key: key
      }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_separator__WEBPACK_IMPORTED_MODULE_17__.Separator, {
        orientation: "vertical"
      }));
    },
    'Undo': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_history_toolbar_button__WEBPACK_IMPORTED_MODULE_2__.UndoToolbarButton, {
        key: key
      });
    },
    'Redo': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_history_toolbar_button__WEBPACK_IMPORTED_MODULE_2__.RedoToolbarButton, {
        key: key
      });
    },
    'TurnInto': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_turn_into_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.TurnIntoDropdownMenu, {
        key: key
      });
    },
    'Bold': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_mark_toolbar_button__WEBPACK_IMPORTED_MODULE_4__.MarkToolbarButton, {
        nodeType: _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_18__.BoldPlugin.key,
        tooltip: "Bold (\u2318+B)",
        key: key
      }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_19__["default"], null));
    },
    'Italic': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_mark_toolbar_button__WEBPACK_IMPORTED_MODULE_4__.MarkToolbarButton, {
        nodeType: _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_18__.ItalicPlugin.key,
        tooltip: "Italic (\u2318+I)",
        key: key
      }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_20__["default"], null));
    },
    'Underline': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_mark_toolbar_button__WEBPACK_IMPORTED_MODULE_4__.MarkToolbarButton, {
        nodeType: _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_18__.UnderlinePlugin.key,
        tooltip: "Underline (\u2318+U)",
        key: key
      }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_21__["default"], null));
    },
    'Strike': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_mark_toolbar_button__WEBPACK_IMPORTED_MODULE_4__.MarkToolbarButton, {
        nodeType: _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_18__.StrikethroughPlugin.key,
        tooltip: "Strikethrough (\u2318+\u21E7+M)",
        key: key
      }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_22__["default"], null));
    },
    'Superscript': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_mark_toolbar_button__WEBPACK_IMPORTED_MODULE_4__.MarkToolbarButton, {
        nodeType: _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_18__.SuperscriptPlugin.key,
        tooltip: "Superscript",
        key: key
      }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_23__["default"], null));
    },
    'Subscript': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_mark_toolbar_button__WEBPACK_IMPORTED_MODULE_4__.MarkToolbarButton, {
        nodeType: _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_18__.SubscriptPlugin.key,
        tooltip: "Subscript",
        key: key
      }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_24__["default"], null));
    },
    'Code': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_mark_toolbar_button__WEBPACK_IMPORTED_MODULE_4__.MarkToolbarButton, {
        nodeType: _udecode_plate_basic_marks_react__WEBPACK_IMPORTED_MODULE_18__.CodePlugin.key,
        tooltip: "Code (\u2318+E)",
        key: key
      }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_25__["default"], null));
    },
    'FontSize': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_font_size_toolbar_button__WEBPACK_IMPORTED_MODULE_5__.FontSizeToolbarButton, {
        key: key
      });
    },
    'FontColor': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_color_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.ColorDropdownMenu, {
        nodeType: _udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_26__.FontColorPlugin.key,
        tooltip: "Text color",
        key: key
      }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_27__["default"], null));
    },
    'FontBackgroundColor': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_color_dropdown_menu__WEBPACK_IMPORTED_MODULE_6__.ColorDropdownMenu, {
        nodeType: _udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_26__.FontBackgroundColorPlugin.key,
        tooltip: "Background color",
        key: key
      }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_28__["default"], null));
    },
    'NumberedList': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_list_toolbar_button__WEBPACK_IMPORTED_MODULE_0__.ListToolbarButton, {
        nodeType: _udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_29__.NumberedListPlugin.key,
        key: key
      });
    },
    'BulletedList': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_list_toolbar_button__WEBPACK_IMPORTED_MODULE_0__.ListToolbarButton, {
        nodeType: _udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_29__.BulletedListPlugin.key,
        key: key
      });
    },
    'HorizontalRule': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_align_dropdown_menu__WEBPACK_IMPORTED_MODULE_7__.AlignDropdownMenu, {
        key: key
      });
    },
    'LineHeight': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_line_height_dropdown_menu__WEBPACK_IMPORTED_MODULE_8__.LineHeightDropdownMenu, {
        key: key
      });
    },
    'Outdent': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_outdent_toolbar_button__WEBPACK_IMPORTED_MODULE_9__.OutdentToolbarButton, {
        key: key
      });
    },
    'Indent': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_indent_toolbar_button__WEBPACK_IMPORTED_MODULE_10__.IndentToolbarButton, {
        key: key
      });
    },
    'Link': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_link_toolbar_button__WEBPACK_IMPORTED_MODULE_11__.LinkToolbarButton, {
        key: key
      });
    },
    'Emoji': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_emoji_dropdown_menu__WEBPACK_IMPORTED_MODULE_12__.EmojiDropdownMenu, {
        key: key
      });
    },
    'Table': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_table_dropdown_menu__WEBPACK_IMPORTED_MODULE_13__.TableDropdownMenu, {
        key: key
      });
    },
    'Image': function (key) {
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_media_toolbar_button__WEBPACK_IMPORTED_MODULE_14__.MediaToolbarButton, {
        nodeType: _udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_30__.ImagePlugin.key,
        key: key
      });
    }
  },
  defaultToolbar = [['Undo', 'Redo', '-', 'TurnInto', 'FontSize', '-', 'Bold', 'Italic', 'Underline', 'Strike', 'Superscript', 'Subscript', 'Code', 'FontColor', 'FontBackgroundColor', '-', 'HorizontalRule', 'NumberedList', 'BulletedList', '-', 'Link', 'Table', 'Emoji', 'Image', '-', 'LineHeight', 'Outdent', 'Indent']];
function KKDocToolbar(_a) {
  var _b;
  var id = _a.id,
    documentConfig = _a.documentConfig;
  var readOnly = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_15__.useEditorReadOnly)(),
    toolbarConfig = (_b = documentConfig === null || documentConfig === void 0 ? void 0 : documentConfig.toolbar) !== null && _b !== void 0 ? _b : defaultToolbar;
  return react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    id: id
  }, !readOnly && toolbarConfig.map(function (row, rowIndex) {
    return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_plate_toolbar_fixed_toolbar__WEBPACK_IMPORTED_MODULE_16__.FixedToolbar, {
      key: rowIndex,
      onMouseDown: function (e) {
        if (e.target === e.currentTarget) e.preventDefault();
      }
    }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "flex w-full flex-wrap",
      onMouseDown: function (e) {
        if (e.target === e.currentTarget) e.preventDefault();
      }
    }, row.map(function (toolName, toolIndex) {
      var toolCallback = toolsMap[toolName];
      if (toolCallback) {
        return toolCallback(toolIndex.toString());
      } else {
        zk.error("Unknown tool name: ".concat(toolName));
      }
    })));
  }));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/alert-dialog.tsx":
/*!***************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/alert-dialog.tsx ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AlertDialog: () => (/* binding */ AlertDialog),
/* harmony export */   AlertDialogAction: () => (/* binding */ AlertDialogAction),
/* harmony export */   AlertDialogCancel: () => (/* binding */ AlertDialogCancel),
/* harmony export */   AlertDialogContent: () => (/* binding */ AlertDialogContent),
/* harmony export */   AlertDialogDescription: () => (/* binding */ AlertDialogDescription),
/* harmony export */   AlertDialogFooter: () => (/* binding */ AlertDialogFooter),
/* harmony export */   AlertDialogHeader: () => (/* binding */ AlertDialogHeader),
/* harmony export */   AlertDialogOverlay: () => (/* binding */ AlertDialogOverlay),
/* harmony export */   AlertDialogPortal: () => (/* binding */ AlertDialogPortal),
/* harmony export */   AlertDialogTitle: () => (/* binding */ AlertDialogTitle),
/* harmony export */   AlertDialogTrigger: () => (/* binding */ AlertDialogTrigger)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @radix-ui/react-alert-dialog */ "./node_modules/@radix-ui/react-alert-dialog/dist/index.mjs");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/button.tsx");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';






var AlertDialog = _radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Root;
var AlertDialogTrigger = _radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Trigger;
var AlertDialogPortal = _radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Portal;
var AlertDialogOverlay = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (_a, ref) {
  var className = _a.className,
    props = __rest(_a, ["className"]);
  var zclass = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorRef)().zclass;
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Overlay, __assign({
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)("fixed inset-0 ".concat(zclass, "-toolbar-pp bg-black/80 data-[state=closed]:animate-out data-[state=closed]:fade-out-0 data-[state=open]:animate-in data-[state=open]:fade-in-0"), className)
  }, props, {
    ref: ref
  }));
});
AlertDialogOverlay.displayName = _radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Overlay.displayName;
var AlertDialogContent = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (_a, ref) {
  var className = _a.className,
    props = __rest(_a, ["className"]);
  var zclass = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorRef)().zclass;
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(AlertDialogPortal, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    "data-radix-popper-content-wrapper": ''
  }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(AlertDialogOverlay, null), react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Content, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)("data-[state=closed]:slide-out-to-left-1/2 data-[state=open]:slide-in-from-left-1/2 fixed top-1/2 left-1/2 ".concat(zclass, "-toolbar-pp grid w-full max-w-lg -translate-x-1/2 -translate-y-1/2 gap-4 border bg-background p-6 shadow-lg duration-200 data-[state=closed]:animate-out data-[state=closed]:fade-out-0 data-[state=closed]:slide-out-to-top-[48%] data-[state=closed]:zoom-out-95 data-[state=open]:animate-in data-[state=open]:fade-in-0 data-[state=open]:slide-in-from-top-[48%] data-[state=open]:zoom-in-95 sm:rounded-lg"), className)
  }, props))));
});
AlertDialogContent.displayName = _radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Content.displayName;
var AlertDialogHeader = function (_a) {
  var className = _a.className,
    props = __rest(_a, ["className"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", __assign({
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('flex flex-col space-y-2 text-center sm:text-left', className)
  }, props));
};
AlertDialogHeader.displayName = 'AlertDialogHeader';
var AlertDialogFooter = function (_a) {
  var className = _a.className,
    props = __rest(_a, ["className"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", __assign({
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('flex flex-col-reverse sm:flex-row sm:justify-end sm:space-x-2', className)
  }, props));
};
AlertDialogFooter.displayName = 'AlertDialogFooter';
var AlertDialogTitle = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (_a, ref) {
  var className = _a.className,
    props = __rest(_a, ["className"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Title, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('text-lg font-semibold', className)
  }, props));
});
AlertDialogTitle.displayName = _radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Title.displayName;
var AlertDialogDescription = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (_a, ref) {
  var className = _a.className,
    props = __rest(_a, ["className"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Description, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('text-sm text-muted-foreground', className)
  }, props));
});
AlertDialogDescription.displayName = _radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Description.displayName;
var AlertDialogAction = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (_a, ref) {
  var className = _a.className,
    props = __rest(_a, ["className"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Action, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)((0,_button__WEBPACK_IMPORTED_MODULE_2__.buttonVariants)({
      size: 'md'
    }), className)
  }, props));
});
AlertDialogAction.displayName = _radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Action.displayName;
var AlertDialogCancel = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (_a, ref) {
  var className = _a.className,
    props = __rest(_a, ["className"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Cancel, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)((0,_button__WEBPACK_IMPORTED_MODULE_2__.buttonVariants)({
      size: 'md',
      variant: 'outline'
    }), 'mt-2 sm:mt-0', className)
  }, props));
});
AlertDialogCancel.displayName = _radix_ui_react_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.Cancel.displayName;


/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/align-dropdown-menu.tsx":
/*!**********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/align-dropdown-menu.tsx ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AlignDropdownMenu: () => (/* binding */ AlignDropdownMenu)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate_alignment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate-alignment */ "@udecode/plate-alignment");
/* harmony import */ var _udecode_plate_alignment__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_alignment__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @udecode/plate-table/react */ "./node_modules/@udecode/plate-table/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/align-left.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/align-center.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/align-right.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/align-justify.js");
/* harmony import */ var _transforms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./transforms */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/transforms.ts");
/* harmony import */ var _dropdown_menu__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/dropdown-menu.tsx");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';









var items = [{
  icon: lucide_react__WEBPACK_IMPORTED_MODULE_6__["default"],
  value: 'left'
}, {
  icon: lucide_react__WEBPACK_IMPORTED_MODULE_7__["default"],
  value: 'center'
}, {
  icon: lucide_react__WEBPACK_IMPORTED_MODULE_8__["default"],
  value: 'right'
}, {
  icon: lucide_react__WEBPACK_IMPORTED_MODULE_9__["default"],
  value: 'justify'
}];
function AlignDropdownMenu(_a) {
  var _b, _c;
  var children = _a.children,
    props = __rest(_a, ["children"]);
  var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useEditorRef)();
  /* Potix: Fix toolbar value after grid cell selection */
  var selectedCells = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.usePluginOption)(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_10__.TablePlugin, 'selectedCells');
  var value = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useEditorSelector)(function (editor) {
    var fragment = selectedCells && selectedCells.length > 0 ? selectedCells.flatMap(function (cell) {
      return editor.api.fragment(cell, {
        structuralTypes: _transforms__WEBPACK_IMPORTED_MODULE_3__.STRUCTURAL_TYPES
      });
    }) : editor.api.fragment(editor.selection, {
      structuralTypes: _transforms__WEBPACK_IMPORTED_MODULE_3__.STRUCTURAL_TYPES
    });
    return editor.api.prop({
      defaultValue: 'start',
      getProp: function (node) {
        return node.align;
      },
      nodes: fragment
    });
  }, [selectedCells]);
  var openState = (0,_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.useOpenState)();
  var IconValue = (_c = (_b = items.find(function (item) {
    return item.value === value;
  })) === null || _b === void 0 ? void 0 : _b.icon) !== null && _c !== void 0 ? _c : lucide_react__WEBPACK_IMPORTED_MODULE_6__["default"];
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.DropdownMenu, __assign({
    modal: false
  }, openState, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.DropdownMenuTrigger, {
    asChild: true
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_5__.ToolbarButton, {
    pressed: openState.open,
    tooltip: "Align",
    isDropdown: true
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(IconValue, null))), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.DropdownMenuContent, {
    className: "min-w-0",
    align: "start"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.DropdownMenuRadioGroup, {
    value: value,
    onValueChange: function (value) {
      /* Potix: Fix toolbar action after grid cell selection */
      if (selectedCells && selectedCells.length > 0) {
        selectedCells.forEach(function (cell) {
          var cellPath = editor.api.findPath(cell);
          if (cellPath) (0,_udecode_plate_alignment__WEBPACK_IMPORTED_MODULE_1__.setAlign)(editor, {
            setNodesOptions: {
              at: cellPath
            },
            value: value
          });
        });
      } else (0,_udecode_plate_alignment__WEBPACK_IMPORTED_MODULE_1__.setAlign)(editor, {
        value: value
      });
      editor.tf.focus();
    }
  }, items.map(function (_a) {
    var Icon = _a.icon,
      itemValue = _a.value;
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.DropdownMenuRadioItem, {
      key: itemValue,
      value: itemValue,
      hideIcon: true
    }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Icon, null));
  }))));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/button.tsx":
/*!*********************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/button.tsx ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Button: () => (/* binding */ Button),
/* harmony export */   buttonVariants: () => (/* binding */ buttonVariants)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _radix_ui_react_slot__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @radix-ui/react-slot */ "./node_modules/@radix-ui/react-slot/dist/index.mjs");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! class-variance-authority */ "class-variance-authority");
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(class_variance_authority__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];




var buttonVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_2__.cva)('inline-flex cursor-pointer items-center justify-center gap-2 rounded-md text-sm font-medium whitespace-nowrap ring-offset-background transition-colors focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 focus-visible:outline-none disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg]:size-4 [&_svg]:shrink-0', {
  defaultVariants: {
    size: 'sm',
    variant: 'default'
  },
  variants: {
    isMenu: {
      true: 'w-full cursor-pointer justify-start'
    },
    size: {
      icon: 'size-[28px] rounded-md px-1.5',
      lg: 'h-9 rounded-md px-4',
      md: 'h-8 px-3 text-sm',
      none: '',
      sm: 'h-[28px] rounded-md px-2.5',
      xs: 'h-8 rounded-md px-3 text-xs'
    },
    variant: {
      default: 'bg-primary text-primary-foreground hover:bg-primary/90',
      destructive: 'bg-destructive text-destructive-foreground hover:bg-destructive/90',
      ghost: 'hover:bg-accent hover:text-accent-foreground',
      inlineLink: 'text-base text-primary underline underline-offset-4',
      link: 'text-primary underline-offset-4 hover:underline',
      outline: 'border border-input bg-background hover:bg-accent hover:text-accent-foreground',
      secondary: 'bg-secondary text-secondary-foreground hover:bg-secondary/80'
    }
  }
});
var Button = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var _b = _a.asChild,
    asChild = _b === void 0 ? false : _b,
    className = _a.className,
    isMenu = _a.isMenu,
    size = _a.size,
    variant = _a.variant,
    props = __rest(_a, ["asChild", "className", "isMenu", "size", "variant"]);
  var Comp = asChild ? _radix_ui_react_slot__WEBPACK_IMPORTED_MODULE_3__.Slot : 'button';
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(Comp, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(buttonVariants({
      className: className,
      isMenu: isMenu,
      size: size,
      variant: variant
    }))
  }, props));
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-constants.ts":
/*!*****************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-constants.ts ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DEFAULT_COLORS: () => (/* binding */ DEFAULT_COLORS),
/* harmony export */   DEFAULT_CUSTOM_COLORS: () => (/* binding */ DEFAULT_CUSTOM_COLORS)
/* harmony export */ });
var DEFAULT_COLORS = [{
  isBrightColor: false,
  name: 'black',
  value: '#000000'
}, {
  isBrightColor: false,
  name: 'dark grey 4',
  value: '#434343'
}, {
  isBrightColor: false,
  name: 'dark grey 3',
  value: '#666666'
}, {
  isBrightColor: false,
  name: 'dark grey 2',
  value: '#999999'
}, {
  isBrightColor: false,
  name: 'dark grey 1',
  value: '#B7B7B7'
}, {
  isBrightColor: false,
  name: 'grey',
  value: '#CCCCCC'
}, {
  isBrightColor: false,
  name: 'light grey 1',
  value: '#D9D9D9'
}, {
  isBrightColor: true,
  name: 'light grey 2',
  value: '#EFEFEF'
}, {
  isBrightColor: true,
  name: 'light grey 3',
  value: '#F3F3F3'
}, {
  isBrightColor: true,
  name: 'white',
  value: '#FFFFFF'
}, {
  isBrightColor: false,
  name: 'red berry',
  value: '#980100'
}, {
  isBrightColor: false,
  name: 'red',
  value: '#FE0000'
}, {
  isBrightColor: false,
  name: 'orange',
  value: '#FE9900'
}, {
  isBrightColor: true,
  name: 'yellow',
  value: '#FEFF00'
}, {
  isBrightColor: false,
  name: 'green',
  value: '#00FF00'
}, {
  isBrightColor: false,
  name: 'cyan',
  value: '#00FFFF'
}, {
  isBrightColor: false,
  name: 'cornflower blue',
  value: '#4B85E8'
}, {
  isBrightColor: false,
  name: 'blue',
  value: '#1300FF'
}, {
  isBrightColor: false,
  name: 'purple',
  value: '#9900FF'
}, {
  isBrightColor: false,
  name: 'magenta',
  value: '#FF00FF'
}, {
  isBrightColor: false,
  name: 'light red berry 3',
  value: '#E6B8AF'
}, {
  isBrightColor: false,
  name: 'light red 3',
  value: '#F4CCCC'
}, {
  isBrightColor: true,
  name: 'light orange 3',
  value: '#FCE4CD'
}, {
  isBrightColor: true,
  name: 'light yellow 3',
  value: '#FFF2CC'
}, {
  isBrightColor: true,
  name: 'light green 3',
  value: '#D9EAD3'
}, {
  isBrightColor: false,
  name: 'light cyan 3',
  value: '#D0DFE3'
}, {
  isBrightColor: false,
  name: 'light cornflower blue 3',
  value: '#C9DAF8'
}, {
  isBrightColor: true,
  name: 'light blue 3',
  value: '#CFE1F3'
}, {
  isBrightColor: true,
  name: 'light purple 3',
  value: '#D9D2E9'
}, {
  isBrightColor: true,
  name: 'light magenta 3',
  value: '#EAD1DB'
}, {
  isBrightColor: false,
  name: 'light red berry 2',
  value: '#DC7E6B'
}, {
  isBrightColor: false,
  name: 'light red 2',
  value: '#EA9999'
}, {
  isBrightColor: false,
  name: 'light orange 2',
  value: '#F9CB9C'
}, {
  isBrightColor: true,
  name: 'light yellow 2',
  value: '#FFE598'
}, {
  isBrightColor: false,
  name: 'light green 2',
  value: '#B7D6A8'
}, {
  isBrightColor: false,
  name: 'light cyan 2',
  value: '#A1C4C9'
}, {
  isBrightColor: false,
  name: 'light cornflower blue 2',
  value: '#A4C2F4'
}, {
  isBrightColor: false,
  name: 'light blue 2',
  value: '#9FC5E8'
}, {
  isBrightColor: false,
  name: 'light purple 2',
  value: '#B5A7D5'
}, {
  isBrightColor: false,
  name: 'light magenta 2',
  value: '#D5A6BD'
}, {
  isBrightColor: false,
  name: 'light red berry 1',
  value: '#CC4125'
}, {
  isBrightColor: false,
  name: 'light red 1',
  value: '#E06666'
}, {
  isBrightColor: false,
  name: 'light orange 1',
  value: '#F6B26B'
}, {
  isBrightColor: false,
  name: 'light yellow 1',
  value: '#FFD966'
}, {
  isBrightColor: false,
  name: 'light green 1',
  value: '#93C47D'
}, {
  isBrightColor: false,
  name: 'light cyan 1',
  value: '#76A5AE'
}, {
  isBrightColor: false,
  name: 'light cornflower blue 1',
  value: '#6C9EEB'
}, {
  isBrightColor: false,
  name: 'light blue 1',
  value: '#6FA8DC'
}, {
  isBrightColor: false,
  name: 'light purple 1',
  value: '#8D7CC3'
}, {
  isBrightColor: false,
  name: 'light magenta 1',
  value: '#C27BA0'
}, {
  isBrightColor: false,
  name: 'dark red berry 1',
  value: '#A61B00'
}, {
  isBrightColor: false,
  name: 'dark red 1',
  value: '#CC0000'
}, {
  isBrightColor: false,
  name: 'dark orange 1',
  value: '#E59138'
}, {
  isBrightColor: false,
  name: 'dark yellow 1',
  value: '#F1C231'
}, {
  isBrightColor: false,
  name: 'dark green 1',
  value: '#6AA74F'
}, {
  isBrightColor: false,
  name: 'dark cyan 1',
  value: '#45818E'
}, {
  isBrightColor: false,
  name: 'dark cornflower blue 1',
  value: '#3B78D8'
}, {
  isBrightColor: false,
  name: 'dark blue 1',
  value: '#3E84C6'
}, {
  isBrightColor: false,
  name: 'dark purple 1',
  value: '#664EA6'
}, {
  isBrightColor: false,
  name: 'dark magenta 1',
  value: '#A64D78'
}, {
  isBrightColor: false,
  name: 'dark red berry 2',
  value: '#84200D'
}, {
  isBrightColor: false,
  name: 'dark red 2',
  value: '#990001'
}, {
  isBrightColor: false,
  name: 'dark orange 2',
  value: '#B45F05'
}, {
  isBrightColor: false,
  name: 'dark yellow 2',
  value: '#BF9002'
}, {
  isBrightColor: false,
  name: 'dark green 2',
  value: '#38761D'
}, {
  isBrightColor: false,
  name: 'dark cyan 2',
  value: '#124F5C'
}, {
  isBrightColor: false,
  name: 'dark cornflower blue 2',
  value: '#1155CB'
}, {
  isBrightColor: false,
  name: 'dark blue 2',
  value: '#0C5394'
}, {
  isBrightColor: false,
  name: 'dark purple 2',
  value: '#351C75'
}, {
  isBrightColor: false,
  name: 'dark magenta 2',
  value: '#741B47'
}, {
  isBrightColor: false,
  name: 'dark red berry 3',
  value: '#5B0F00'
}, {
  isBrightColor: false,
  name: 'dark red 3',
  value: '#660000'
}, {
  isBrightColor: false,
  name: 'dark orange 3',
  value: '#783F04'
}, {
  isBrightColor: false,
  name: 'dark yellow 3',
  value: '#7E6000'
}, {
  isBrightColor: false,
  name: 'dark green 3',
  value: '#274E12'
}, {
  isBrightColor: false,
  name: 'dark cyan 3',
  value: '#0D343D'
}, {
  isBrightColor: false,
  name: 'dark cornflower blue 3',
  value: '#1B4487'
}, {
  isBrightColor: false,
  name: 'dark blue 3',
  value: '#083763'
}, {
  isBrightColor: false,
  name: 'dark purple 3',
  value: '#1F124D'
}, {
  isBrightColor: false,
  name: 'dark magenta 3',
  value: '#4C1130'
}];
var DEFAULT_CUSTOM_COLORS = [{
  isBrightColor: false,
  name: 'dark orange 3',
  value: '#783F04'
}, {
  isBrightColor: false,
  name: 'dark grey 3',
  value: '#666666'
}, {
  isBrightColor: false,
  name: 'dark grey 2',
  value: '#999999'
}, {
  isBrightColor: false,
  name: 'light cornflower blue 1',
  value: '#6C9EEB'
}, {
  isBrightColor: false,
  name: 'dark magenta 3',
  value: '#4C1130'
}];

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-dropdown-menu-items.tsx":
/*!****************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-dropdown-menu-items.tsx ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ColorDropdownMenuItem: () => (/* binding */ ColorDropdownMenuItem),
/* harmony export */   ColorDropdownMenuItems: () => (/* binding */ ColorDropdownMenuItems)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/check.js");
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/button.tsx");
/* harmony import */ var _dropdown_menu__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/dropdown-menu.tsx");
/* harmony import */ var _tooltip__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./tooltip */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/tooltip.tsx");
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';







function ColorDropdownMenuItem(_a) {
  var className = _a.className,
    isBrightColor = _a.isBrightColor,
    isSelected = _a.isSelected,
    name = _a.name,
    updateColor = _a.updateColor,
    value = _a.value,
    props = __rest(_a, ["className", "isBrightColor", "isSelected", "name", "updateColor", "value"]);
  var content = react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuItem, __assign({
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)((0,_button__WEBPACK_IMPORTED_MODULE_2__.buttonVariants)({
      isMenu: true,
      size: 'icon',
      variant: 'outline'
    }), 'my-1 flex size-6 items-center justify-center rounded-full border border-solid border-muted p-0 transition-all hover:scale-125', !isBrightColor && 'border-transparent text-white hover:text-white!', className),
    style: {
      backgroundColor: value
    },
    onSelect: function (e) {
      e.preventDefault();
      updateColor(value);
    }
  }, props), isSelected ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_5__["default"], {
    className: "size-3!"
  }) : null);
  return name ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_tooltip__WEBPACK_IMPORTED_MODULE_4__.Tooltip, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_tooltip__WEBPACK_IMPORTED_MODULE_4__.TooltipTrigger, null, content), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_tooltip__WEBPACK_IMPORTED_MODULE_4__.TooltipContent, {
    className: "mb-1 capitalize"
  }, name)) : content;
}
function ColorDropdownMenuItems(_a) {
  var className = _a.className,
    color = _a.color,
    colors = _a.colors,
    updateColor = _a.updateColor,
    props = __rest(_a, ["className", "color", "colors", "updateColor"]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", __assign({
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('grid grid-cols-[repeat(10,1fr)] place-items-center', className)
  }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_tooltip__WEBPACK_IMPORTED_MODULE_4__.TooltipProvider, null, colors.map(function (_a) {
    var isBrightColor = _a.isBrightColor,
      name = _a.name,
      value = _a.value;
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ColorDropdownMenuItem, {
      name: name,
      key: name !== null && name !== void 0 ? name : value,
      value: value,
      isBrightColor: isBrightColor,
      isSelected: color === value,
      updateColor: updateColor
    });
  }), props.children));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-dropdown-menu.tsx":
/*!**********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-dropdown-menu.tsx ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ColorDropdownMenu: () => (/* binding */ ColorDropdownMenu)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @udecode/plate-font/react */ "./node_modules/@udecode/plate-font/dist/react/index.mjs");
/* harmony import */ var _color_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./color-constants */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-constants.ts");
/* harmony import */ var _color_picker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./color-picker */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-picker.tsx");
/* harmony import */ var _dropdown_menu__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/dropdown-menu.tsx");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';







function ColorDropdownMenu(_a) {
  var children = _a.children,
    nodeType = _a.nodeType,
    tooltip = _a.tooltip;
  var state = (0,_udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_5__.useColorDropdownMenuState)({
      closeOnSelect: true,
      colors: _color_constants__WEBPACK_IMPORTED_MODULE_1__.DEFAULT_COLORS,
      customColors: _color_constants__WEBPACK_IMPORTED_MODULE_1__.DEFAULT_CUSTOM_COLORS,
      nodeType: nodeType
    }),
    _b = (0,_udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_5__.useColorDropdownMenu)(state),
    buttonProps = _b.buttonProps,
    menuProps = _b.menuProps;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenu, __assign({
    modal: false
  }, menuProps), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuTrigger, {
    asChild: true
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_4__.ToolbarButton, __assign({
    tooltip: tooltip
  }, buttonProps), children)), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuContent, {
    align: "start"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_color_picker__WEBPACK_IMPORTED_MODULE_2__.ColorPicker, {
    color: state.selectedColor || state.color,
    clearColor: state.clearColor,
    colors: state.colors,
    customColors: state.customColors,
    updateColor: state.updateColorAndClose,
    updateCustomColor: state.updateColor
  })));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-input.tsx":
/*!**************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-input.tsx ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ColorInput: () => (/* binding */ ColorInput)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate-font/react */ "./node_modules/@udecode/plate-font/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';





var ColorInput = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    _b = _a.value,
    value = _b === void 0 ? '#000000' : _b,
    props = __rest(_a, ["children", "className", "value"]);
  var _c = (0,_udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_3__.useColorInput)(),
    childProps = _c.childProps,
    inputRef = _c.inputRef;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "flex flex-col items-center"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().Children.map(children, function (child) {
    if (!child) return child;
    return react__WEBPACK_IMPORTED_MODULE_0___default().cloneElement(child, childProps);
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", __assign({
    ref: (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useComposedRef)(ref, inputRef),
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('size-0 overflow-hidden border-0 p-0', className),
    value: value,
    type: "color"
  }, props)));
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-picker.tsx":
/*!***************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-picker.tsx ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ColorPicker: () => (/* binding */ ColorPicker),
/* harmony export */   ColorPickerContent: () => (/* binding */ ColorPickerContent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/eraser.js");
/* harmony import */ var _color_dropdown_menu_items__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./color-dropdown-menu-items */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-dropdown-menu-items.tsx");
/* harmony import */ var _colors_custom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./colors-custom */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/colors-custom.tsx");
/* harmony import */ var _dropdown_menu__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/dropdown-menu.tsx");
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';







var ColorPickerContent = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var className = _a.className,
    clearColor = _a.clearColor,
    color = _a.color,
    colors = _a.colors,
    customColors = _a.customColors,
    updateColor = _a.updateColor,
    updateCustomColor = _a.updateCustomColor,
    props = __rest(_a, ["className", "clearColor", "color", "colors", "customColors", "updateColor", "updateCustomColor"]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('flex flex-col', className)
  }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.DropdownMenuGroup, {
    label: "Custom Colors"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_colors_custom__WEBPACK_IMPORTED_MODULE_3__.ColorCustom, {
    color: color,
    className: "px-2",
    colors: colors,
    customColors: customColors,
    updateColor: updateColor,
    updateCustomColor: updateCustomColor
  })), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.DropdownMenuGroup, {
    label: "Default Colors"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_color_dropdown_menu_items__WEBPACK_IMPORTED_MODULE_2__.ColorDropdownMenuItems, {
    color: color,
    className: "px-2",
    colors: colors,
    updateColor: updateColor
  })), color && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.DropdownMenuGroup, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.DropdownMenuItem, {
    className: "p-2",
    onClick: clearColor
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_5__["default"], null), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Clear"))));
});
var ColorPicker = react__WEBPACK_IMPORTED_MODULE_0___default().memo(ColorPickerContent, function (prev, next) {
  return prev.color === next.color && prev.colors === next.colors && prev.customColors === next.customColors;
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/colors-custom.tsx":
/*!****************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/colors-custom.tsx ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ColorCustom: () => (/* binding */ ColorCustom)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @udecode/plate-font/react */ "./node_modules/@udecode/plate-font/dist/react/index.mjs");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/plus.js");
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/button.tsx");
/* harmony import */ var _color_dropdown_menu_items__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./color-dropdown-menu-items */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-dropdown-menu-items.tsx");
/* harmony import */ var _color_input__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./color-input */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/color-input.tsx");
/* harmony import */ var _dropdown_menu__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/dropdown-menu.tsx");
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';








// import { ColorInput } from './color-input';

function ColorCustom(_a) {
  var className = _a.className,
    color = _a.color,
    colors = _a.colors,
    customColors = _a.customColors,
    updateColor = _a.updateColor,
    updateCustomColor = _a.updateCustomColor,
    props = __rest(_a, ["className", "color", "colors", "customColors", "updateColor", "updateCustomColor"]);
  var state = (0,_udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_6__.useColorsCustomState)({
    color: color,
    colors: colors,
    customColors: customColors,
    updateCustomColor: updateCustomColor
  });
  var _b = (0,_udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_6__.useColorsCustom)(state),
    inputProps = _b.inputProps,
    menuItemProps = _b.menuItemProps;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", __assign({
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('relative flex flex-col gap-4', className)
  }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_color_dropdown_menu_items__WEBPACK_IMPORTED_MODULE_3__.ColorDropdownMenuItems, {
    color: color,
    colors: state.computedColors,
    updateColor: updateColor
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_color_input__WEBPACK_IMPORTED_MODULE_4__.ColorInput, __assign({}, inputProps), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_5__.DropdownMenuItem, __assign({
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)((0,_button__WEBPACK_IMPORTED_MODULE_2__.buttonVariants)({
      isMenu: true,
      size: 'icon',
      variant: 'outline'
    }), 'absolute top-1.5 right-2 bottom-2 flex size-7 items-center justify-center rounded-full')
  }, menuItemProps), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "sr-only"
  }, "Custom"), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_7__["default"], null)))));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/dropdown-menu.tsx":
/*!****************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/dropdown-menu.tsx ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DropdownMenu: () => (/* binding */ DropdownMenu),
/* harmony export */   DropdownMenuCheckboxItem: () => (/* binding */ DropdownMenuCheckboxItem),
/* harmony export */   DropdownMenuContent: () => (/* binding */ DropdownMenuContent),
/* harmony export */   DropdownMenuGroup: () => (/* binding */ DropdownMenuGroup),
/* harmony export */   DropdownMenuItem: () => (/* binding */ DropdownMenuItem),
/* harmony export */   DropdownMenuLabel: () => (/* binding */ DropdownMenuLabel),
/* harmony export */   DropdownMenuPortal: () => (/* binding */ DropdownMenuPortal),
/* harmony export */   DropdownMenuRadioGroup: () => (/* binding */ DropdownMenuRadioGroup),
/* harmony export */   DropdownMenuRadioItem: () => (/* binding */ DropdownMenuRadioItem),
/* harmony export */   DropdownMenuSeparator: () => (/* binding */ DropdownMenuSeparator),
/* harmony export */   DropdownMenuShortcut: () => (/* binding */ DropdownMenuShortcut),
/* harmony export */   DropdownMenuSub: () => (/* binding */ DropdownMenuSub),
/* harmony export */   DropdownMenuSubContent: () => (/* binding */ DropdownMenuSubContent),
/* harmony export */   DropdownMenuSubTrigger: () => (/* binding */ DropdownMenuSubTrigger),
/* harmony export */   DropdownMenuTrigger: () => (/* binding */ DropdownMenuTrigger),
/* harmony export */   useOpenState: () => (/* binding */ useOpenState)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @radix-ui/react-dropdown-menu */ "./node_modules/@radix-ui/react-dropdown-menu/dist/index.mjs");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! class-variance-authority */ "class-variance-authority");
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(class_variance_authority__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/chevron-right.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/check.js");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';








var DropdownMenu = _radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.Root;
var DropdownMenuTrigger = _radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.Trigger;
var DropdownMenuGroup = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (_a, ref) {
  var label = _a.label,
    props = __rest(_a, ["label"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(DropdownMenuSeparator, {
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('hidden', 'mb-0 shrink-0 peer-has-[[role=menuitem]]/menu-group:block peer-has-[[role=menuitemcheckbox]]/menu-group:block peer-has-[[role=option]]/menu-group:block')
  }), react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.Group, __assign({
    ref: ref
  }, props, {
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('hidden', 'peer/menu-group group/menu-group my-1.5 has-[[role=menuitem]]:block has-[[role=menuitemcheckbox]]:block has-[[role=option]]:block', props.className)
  }), label && react__WEBPACK_IMPORTED_MODULE_0__.createElement(DropdownMenuLabel, null, label), props.children));
});
var DropdownMenuPortal = _radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.Portal;
var DropdownMenuSub = _radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.Sub;
var DropdownMenuRadioGroup = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (_a, ref) {
  var label = _a.label,
    props = __rest(_a, ["label"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(DropdownMenuSeparator, {
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('hidden', 'mb-0 shrink-0 peer-has-[[role=menuitemradio]]/menu-group:block peer-has-[[role=option]]/menu-group:block')
  }), react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.RadioGroup, __assign({
    ref: ref
  }, props, {
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('hidden', 'peer/menu-group group/menu-group my-1.5 has-[[role=menuitemradio]]:block has-[[role=option]]:block', props.className)
  }), label && react__WEBPACK_IMPORTED_MODULE_0__.createElement(DropdownMenuLabel, null, label), props.children));
});
var DropdownMenuSubTrigger = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    inset = _a.inset,
    props = __rest(_a, ["children", "className", "inset"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.SubTrigger, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('mx-1 flex cursor-default items-center gap-2 rounded-sm px-2 py-1 text-sm outline-none select-none focus:bg-accent data-disabled:pointer-events-none data-disabled:opacity-50 data-[state=open]:bg-accent [&_svg]:pointer-events-none [&_svg]:size-4 [&_svg]:shrink-0', inset && 'pl-8', className)
  }, props), children, react__WEBPACK_IMPORTED_MODULE_0__.createElement(lucide_react__WEBPACK_IMPORTED_MODULE_5__["default"], {
    className: "ml-auto"
  }));
});
var DropdownMenuSubContent = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (_a, ref) {
  var className = _a.className,
    props = __rest(_a, ["className"]);
  var zclass = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorRef)().zclass;
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.SubContent, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)("data-[side=bottom]:slide-in-from-top-2 data-[side=left]:slide-in-from-right-2 data-[side=right]:slide-in-from-left-2 data-[side=top]:slide-in-from-bottom-2 ".concat(zclass, "-toolbar-pp min-w-32 overflow-hidden rounded-md border bg-popover py-1 text-popover-foreground shadow-lg data-[state=closed]:animate-out data-[state=closed]:fade-out-0 data-[state=closed]:zoom-out-95 data-[state=open]:animate-in data-[state=open]:fade-in-0 data-[state=open]:zoom-in-95"), className)
  }, props));
});
var DropdownMenuContent = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (_a, ref) {
  var className = _a.className,
    props = __rest(_a, ["className"]);
  var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorRef)(),
    zclass = editor.zclass;
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.Portal, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.Content, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)("data-[side=bottom]:slide-in-from-top-2 data-[side=left]:slide-in-from-right-2 data-[side=right]:slide-in-from-left-2 data-[side=top]:slide-in-from-bottom-2 ".concat(zclass, "-toolbar-pp min-w-32 overflow-hidden rounded-md border bg-popover text-popover-foreground shadow-md data-[state=closed]:animate-out data-[state=closed]:fade-out-0 data-[state=closed]:zoom-out-95 data-[state=open]:animate-in data-[state=open]:fade-in-0 data-[state=open]:zoom-in-95"), className),
    sideOffset: 4,
    "data-plate-focus-id": editor.id,
    onCloseAutoFocus: function (e) {
      e.preventDefault();
      editor.tf.focus();
    }
  }, props)));
});
var menuItemVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_2__.cva)('relative mx-1 flex cursor-pointer items-center gap-2 rounded-sm px-2 py-1 text-sm transition-colors outline-none select-none focus:bg-accent focus:text-accent-foreground data-disabled:pointer-events-none data-disabled:opacity-50 [&_svg]:pointer-events-none [&_svg]:size-4 [&_svg]:shrink-0', {
  variants: {
    inset: {
      true: 'pl-8'
    }
  }
});
var DropdownMenuItem = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var className = _a.className,
    props = __rest(_a, ["className"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.Item, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(menuItemVariants({
      inset: props.inset
    }), className),
    "data-plate-focus-id": (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorRef)().id
  }, props));
});
var DropdownMenuCheckboxItem = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.CheckboxItem, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('relative mx-1 flex items-center gap-2 rounded-sm py-1 pr-2 pl-8 text-sm transition-colors outline-none select-none focus:bg-accent focus:text-accent-foreground data-disabled:pointer-events-none data-disabled:opacity-50 [&_svg]:size-4 [&_svg]:shrink-0', 'cursor-pointer', className),
    "data-plate-focus-id": (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorRef)().id
  }, props), react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", {
    className: "absolute left-2 flex size-3.5 items-center justify-center"
  }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.ItemIndicator, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(lucide_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
    className: "size-4"
  }))), children);
});
var DropdownMenuRadioItem = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    hideIcon = _a.hideIcon,
    props = __rest(_a, ["children", "className", "hideIcon"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.RadioItem, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('relative mx-1 flex cursor-pointer items-center gap-2 rounded-sm px-2 py-1 text-sm transition-colors outline-none select-none focus:bg-accent focus:text-accent-foreground data-disabled:pointer-events-none data-disabled:opacity-50 data-[state=checked]:text-accent-foreground [&_svg]:size-4', className),
    "data-plate-focus-id": (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorRef)().id
  }, props), !hideIcon && react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", {
    className: "absolute right-2 flex size-3.5 items-center justify-center"
  }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.ItemIndicator, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(lucide_react__WEBPACK_IMPORTED_MODULE_6__["default"], null))), children);
});
var dropdownMenuLabelVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_2__.cva)((0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('mx-1 px-2 pt-1.5 pb-2 text-xs font-semibold text-muted-foreground select-none'), {
  variants: {
    inset: {
      true: 'pl-8'
    }
  }
});
var DropdownMenuLabel = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withVariants)(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.Label, dropdownMenuLabelVariants, ['inset']);
var DropdownMenuSeparator = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withCn)(_radix_ui_react_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.Separator, '-mx-1 my-1 h-px bg-muted');
var DropdownMenuShortcut = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withCn)((0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.createPrimitiveElement)('span'), 'ml-auto text-xs tracking-widest opacity-60');
var useOpenState = function () {
  var _a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    open = _a[0],
    setOpen = _a[1];
  var onOpenChange = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (_value) {
    if (_value === void 0) {
      _value = !open;
    }
    setOpen(_value);
  }, [open]);
  return {
    open: open,
    onOpenChange: onOpenChange
  };
};

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-dropdown-menu.tsx":
/*!**********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-dropdown-menu.tsx ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmojiDropdownMenu: () => (/* binding */ EmojiDropdownMenu)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate_emoji_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @udecode/plate-emoji/react */ "./node_modules/@udecode/plate-emoji/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/smile.js");
/* harmony import */ var _emoji_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./emoji-icons */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-icons.tsx");
/* harmony import */ var _emoji_picker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./emoji-picker */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker.tsx");
/* harmony import */ var _emoji_toolbar_dropdown__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./emoji-toolbar-dropdown */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-toolbar-dropdown.tsx");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';









function EmojiDropdownMenu(_a) {
  var options = _a.options,
    props = __rest(_a, ["options"]);
  var _b = (0,_udecode_plate_emoji_react__WEBPACK_IMPORTED_MODULE_6__.useEmojiDropdownMenuState)(options),
    emojiPickerState = _b.emojiPickerState,
    isOpen = _b.isOpen,
    setIsOpen = _b.setIsOpen;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_emoji_toolbar_dropdown__WEBPACK_IMPORTED_MODULE_4__.EmojiToolbarDropdown, {
    control: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_5__.ToolbarButton, __assign({
      "data-plate-focus-id": (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__.useEditorRef)().id,
      pressed: isOpen,
      tooltip: "Emoji",
      isDropdown: true
    }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_7__["default"], null)),
    isOpen: isOpen,
    setIsOpen: setIsOpen
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_emoji_picker__WEBPACK_IMPORTED_MODULE_3__.EmojiPicker, __assign({}, emojiPickerState, {
    icons: {
      categories: _emoji_icons__WEBPACK_IMPORTED_MODULE_2__.emojiCategoryIcons,
      search: _emoji_icons__WEBPACK_IMPORTED_MODULE_2__.emojiSearchIcons
    },
    isOpen: isOpen,
    setIsOpen: setIsOpen,
    settings: options === null || options === void 0 ? void 0 : options.settings
  })));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-icons.tsx":
/*!**************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-icons.tsx ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   emojiCategoryIcons: () => (/* binding */ emojiCategoryIcons),
/* harmony export */   emojiSearchIcons: () => (/* binding */ emojiSearchIcons)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/star.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/flag.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/apple.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/clock.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/leaf.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/lightbulb.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/smile.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/compass.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/music.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/x.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/search.js");


var emojiCategoryIcons = {
  activity: {
    outline: react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", {
      className: "size-full",
      fill: "none",
      stroke: "currentColor",
      strokeLinecap: "round",
      strokeLinejoin: "round",
      strokeWidth: "2",
      viewBox: "0 0 24 24",
      xmlns: "http://www.w3.org/2000/svg"
    }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", {
      cx: "12",
      cy: "12",
      r: "10"
    }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
      d: "M2.1 13.4A10.1 10.1 0 0 0 13.4 2.1"
    }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
      d: "m5 4.9 14 14.2"
    }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
      d: "M21.9 10.6a10.1 10.1 0 0 0-11.3 11.3"
    })),
    solid: react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", {
      className: "size-full",
      fill: "none",
      stroke: "currentColor",
      strokeLinecap: "round",
      strokeLinejoin: "round",
      strokeWidth: "2",
      viewBox: "0 0 24 24",
      xmlns: "http://www.w3.org/2000/svg"
    }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", {
      cx: "12",
      cy: "12",
      r: "10"
    }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
      d: "M2.1 13.4A10.1 10.1 0 0 0 13.4 2.1"
    }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
      d: "m5 4.9 14 14.2"
    }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
      d: "M21.9 10.6a10.1 10.1 0 0 0-11.3 11.3"
    }))
  },
  custom: {
    outline: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_1__["default"], {
      className: "size-full"
    }),
    solid: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_1__["default"], {
      className: "size-full"
    })
  },
  flags: {
    outline: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_2__["default"], {
      className: "size-full"
    }),
    solid: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_2__["default"], {
      className: "size-full"
    })
  },
  foods: {
    outline: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_3__["default"], {
      className: "size-full"
    }),
    solid: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_3__["default"], {
      className: "size-full"
    })
  },
  frequent: {
    outline: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_4__["default"], {
      className: "size-full"
    }),
    solid: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_4__["default"], {
      className: "size-full"
    })
  },
  nature: {
    outline: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_5__["default"], {
      className: "size-full"
    }),
    solid: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_5__["default"], {
      className: "size-full"
    })
  },
  objects: {
    outline: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
      className: "size-full"
    }),
    solid: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
      className: "size-full"
    })
  },
  people: {
    outline: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_7__["default"], {
      className: "size-full"
    }),
    solid: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_7__["default"], {
      className: "size-full"
    })
  },
  places: {
    outline: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_8__["default"], {
      className: "size-full"
    }),
    solid: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_8__["default"], {
      className: "size-full"
    })
  },
  symbols: {
    outline: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_9__["default"], {
      className: "size-full"
    }),
    solid: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_9__["default"], {
      className: "size-full"
    })
  }
};
var emojiSearchIcons = {
  delete: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_10__["default"], {
    className: "size-4 text-current"
  }),
  loupe: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_11__["default"], {
    className: "size-4 text-current"
  })
};

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-content.tsx":
/*!***********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-content.tsx ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmojiPickerContent: () => (/* binding */ EmojiPickerContent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_emoji__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-emoji */ "@udecode/plate-emoji");
/* harmony import */ var _udecode_plate_emoji__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_emoji__WEBPACK_IMPORTED_MODULE_2__);
'use client';





var Button = (0,react__WEBPACK_IMPORTED_MODULE_0__.memo)(function (_a) {
  var emoji = _a.emoji,
    index = _a.index,
    onMouseOver = _a.onMouseOver,
    onSelect = _a.onSelect;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
    className: "group relative flex size-9 cursor-pointer items-center justify-center border-none bg-transparent text-2xl leading-none",
    onClick: function () {
      return onSelect(emoji);
    },
    onMouseEnter: function () {
      return onMouseOver(emoji);
    },
    onMouseLeave: function () {
      return onMouseOver();
    },
    "aria-label": emoji.skins[0].native,
    "data-index": index,
    tabIndex: -1,
    type: "button"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "absolute inset-0 rounded-full opacity-0 group-hover:opacity-100",
    "aria-hidden": "true"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "relative",
    style: {
      fontFamily: '"Apple Color Emoji", "Segoe UI Emoji", NotoColorEmoji, "Noto Color Emoji", "Segoe UI Symbol", "Android Emoji", EmojiSymbols'
    },
    "data-emoji-set": "native"
  }, emoji.skins[0].native));
});
Button.displayName = 'Button';
var RowOfButtons = (0,react__WEBPACK_IMPORTED_MODULE_0__.memo)(function (_a) {
  var emojiLibrary = _a.emojiLibrary,
    row = _a.row,
    onMouseOver = _a.onMouseOver,
    onSelectEmoji = _a.onSelectEmoji;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    key: row.id,
    className: "flex",
    "data-index": row.id
  }, row.elements.map(function (emojiId, index) {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Button, {
      key: emojiId,
      onMouseOver: onMouseOver,
      onSelect: onSelectEmoji,
      emoji: emojiLibrary.getEmoji(emojiId),
      index: index
    });
  }));
});
RowOfButtons.displayName = 'RowOfButtons';
function EmojiPickerContent(_a) {
  var emojiLibrary = _a.emojiLibrary,
    i18n = _a.i18n,
    _b = _a.isSearching,
    isSearching = _b === void 0 ? false : _b,
    refs = _a.refs,
    searchResult = _a.searchResult,
    _c = _a.settings,
    settings = _c === void 0 ? _udecode_plate_emoji__WEBPACK_IMPORTED_MODULE_2__.EmojiSettings : _c,
    visibleCategories = _a.visibleCategories,
    onMouseOver = _a.onMouseOver,
    onSelectEmoji = _a.onSelectEmoji;
  var getRowWidth = settings.perLine.value * settings.buttonSize.value;
  var isCategoryVisible = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (categoryId) {
    return visibleCategories.has(categoryId) ? visibleCategories.get(categoryId) : false;
  }, [visibleCategories]);
  var EmojiList = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    return emojiLibrary.getGrid().sections().map(function (_a) {
      var categoryId = _a.id;
      var section = emojiLibrary.getGrid().section(categoryId);
      var buttonSize = settings.buttonSize;
      return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        key: categoryId,
        ref: section.root,
        style: {
          width: getRowWidth
        },
        "data-id": categoryId
      }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "sticky -top-px z-1 bg-popover/90 p-1 py-2 text-sm font-semibold backdrop-blur-xs"
      }, i18n.categories[categoryId]), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "relative flex flex-wrap",
        style: {
          height: section.getRows().length * buttonSize.value
        }
      }, isCategoryVisible(categoryId) && section.getRows().map(function (row) {
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(RowOfButtons, {
          key: row.id,
          onMouseOver: onMouseOver,
          onSelectEmoji: onSelectEmoji,
          emojiLibrary: emojiLibrary,
          row: row
        });
      })));
    });
  }, [emojiLibrary, getRowWidth, i18n.categories, isCategoryVisible, onSelectEmoji, onMouseOver, settings]);
  var SearchList = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      style: {
        width: getRowWidth
      },
      "data-id": "search"
    }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "sticky -top-px z-1 bg-popover/90 p-1 py-2 text-sm font-semibold text-card-foreground backdrop-blur-xs"
    }, i18n.searchResult), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "relative flex flex-wrap"
    }, searchResult.map(function (emoji, index) {
      return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Button, {
        key: emoji.id,
        onMouseOver: onMouseOver,
        onSelect: onSelectEmoji,
        emoji: emojiLibrary.getEmoji(emoji.id),
        index: index
      });
    })));
  }, [emojiLibrary, getRowWidth, i18n.searchResult, searchResult, onSelectEmoji, onMouseOver]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    ref: refs.current.contentRoot,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('h-full min-h-[50%] overflow-x-hidden overflow-y-auto px-2', '[&::-webkit-scrollbar]:w-4', '[&::-webkit-scrollbar-button]:hidden [&::-webkit-scrollbar-button]:size-0', '[&::-webkit-scrollbar-thumb]:min-h-11 [&::-webkit-scrollbar-thumb]:rounded-full [&::-webkit-scrollbar-thumb]:bg-muted [&::-webkit-scrollbar-thumb]:hover:bg-muted-foreground/25', '[&::-webkit-scrollbar-thumb]:border-4 [&::-webkit-scrollbar-thumb]:border-solid [&::-webkit-scrollbar-thumb]:border-popover [&::-webkit-scrollbar-thumb]:bg-clip-padding'),
    "data-id": "scroll"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    ref: refs.current.content,
    className: "h-full"
  }, isSearching ? SearchList() : EmojiList()));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-navigation.tsx":
/*!**************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-navigation.tsx ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmojiPickerNavigation: () => (/* binding */ EmojiPickerNavigation)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/button.tsx");
/* harmony import */ var _tooltip__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./tooltip */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/tooltip.tsx");




// KEEP: This is for the animated idicator bar under the icon - Opt in if needed
// const getBarProperty = (
//   emojiLibrary: IEmojiFloatingLibrary,
//   focusedCategory?: EmojiCategoryList
// ) => {
//   let width = 0;
//   let position = 0;
//   if (focusedCategory) {
//     width = 100 / emojiLibrary.getGrid().size;
//     position = focusedCategory
//       ? emojiLibrary.indexOf(focusedCategory) * 100
//       : 0;
//   }
//   return { position, width };
// };
function EmojiPickerNavigation(_a) {
  // KEEP: This is for the animated idicator bar under the icon - Opt in if needed
  // const { position, width } = useMemo(
  //   () => getBarProperty(emojiLibrary, focusedCategory),
  //   [emojiLibrary, focusedCategory]
  // );
  var emojiLibrary = _a.emojiLibrary,
    focusedCategory = _a.focusedCategory,
    i18n = _a.i18n,
    icons = _a.icons,
    onClick = _a.onClick;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_tooltip__WEBPACK_IMPORTED_MODULE_3__.TooltipProvider, {
    delayDuration: 500
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("nav", {
    id: "emoji-nav",
    className: "mb-2.5 border-0 border-b border-solid border-b-border p-1.5"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "relative flex items-center justify-evenly"
  }, emojiLibrary.getGrid().sections().map(function (_a) {
    var id = _a.id;
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_tooltip__WEBPACK_IMPORTED_MODULE_3__.Tooltip, {
      key: id
    }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_tooltip__WEBPACK_IMPORTED_MODULE_3__.TooltipTrigger, {
      asChild: true
    }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_button__WEBPACK_IMPORTED_MODULE_2__.Button, {
      size: "sm",
      variant: "ghost",
      className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('h-fit rounded-full fill-current p-1.5 text-muted-foreground hover:bg-muted hover:text-muted-foreground', id === focusedCategory && 'pointer-events-none bg-accent fill-current text-accent-foreground'),
      onClick: function () {
        onClick(id);
      },
      "aria-label": i18n.categories[id],
      type: "button"
    }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
      className: "inline-flex size-5 items-center justify-center"
    }, icons.categories[id].outline))), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_tooltip__WEBPACK_IMPORTED_MODULE_3__.TooltipContent, {
      side: "bottom"
    }, i18n.categories[id]));
  }))));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-preview.tsx":
/*!***********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-preview.tsx ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmojiPickerPreview: () => (/* binding */ EmojiPickerPreview)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';


function EmojiPreview(_a) {
  var emoji = _a.emoji;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "flex h-14 max-h-14 min-h-14 items-center border-t border-muted p-2"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "flex items-center justify-center text-2xl"
  }, emoji === null || emoji === void 0 ? void 0 : emoji.skins[0].native), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "overflow-hidden pl-2"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "truncate text-sm font-semibold"
  }, emoji === null || emoji === void 0 ? void 0 : emoji.name), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "truncate text-sm"
  }, ":".concat(emoji === null || emoji === void 0 ? void 0 : emoji.id, ":"))));
}
function NoEmoji(_a) {
  var i18n = _a.i18n;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "flex h-14 max-h-14 min-h-14 items-center border-t border-muted p-2"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "flex items-center justify-center text-2xl"
  }, "\uD83D\uDE22"), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "overflow-hidden pl-2"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "truncate text-sm font-bold"
  }, i18n.searchNoResultsTitle), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "truncate text-sm"
  }, i18n.searchNoResultsSubtitle)));
}
function PickAnEmoji(_a) {
  var i18n = _a.i18n;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "flex h-14 max-h-14 min-h-14 items-center border-t border-muted p-2"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "flex items-center justify-center text-2xl"
  }, "\u261D\uFE0F"), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "overflow-hidden pl-2"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "truncate text-sm font-semibold"
  }, i18n.pick)));
}
function EmojiPickerPreview(_a) {
  var emoji = _a.emoji,
    _b = _a.hasFound,
    hasFound = _b === void 0 ? true : _b,
    i18n = _a.i18n,
    _c = _a.isSearching,
    isSearching = _c === void 0 ? false : _c,
    props = __rest(_a, ["emoji", "hasFound", "i18n", "isSearching"]);
  var showPickEmoji = !emoji && (!isSearching || hasFound);
  var showNoEmoji = isSearching && !hasFound;
  var showPreview = emoji && !showNoEmoji && !showNoEmoji;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, showPreview && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(EmojiPreview, __assign({
    emoji: emoji
  }, props)), showPickEmoji && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PickAnEmoji, __assign({
    i18n: i18n
  }, props)), showNoEmoji && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(NoEmoji, __assign({
    i18n: i18n
  }, props)));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-search-and-clear.tsx":
/*!********************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-search-and-clear.tsx ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmojiPickerSearchAndClear: () => (/* binding */ EmojiPickerSearchAndClear)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/button.tsx");
/* harmony import */ var _emoji_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./emoji-icons */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-icons.tsx");
'use client';





function EmojiPickerSearchAndClear(_a) {
  var clearSearch = _a.clearSearch,
    i18n = _a.i18n,
    searchValue = _a.searchValue;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "flex items-center text-foreground"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('absolute top-1/2 left-2.5 z-10 flex size-5 -translate-y-1/2 items-center justify-center text-foreground')
  }, _emoji_icons__WEBPACK_IMPORTED_MODULE_3__.emojiSearchIcons.loupe), searchValue && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_button__WEBPACK_IMPORTED_MODULE_2__.Button, {
    size: "icon",
    variant: "ghost",
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('absolute top-1/2 right-0.5 flex size-8 -translate-y-1/2 cursor-pointer items-center justify-center rounded-full border-none bg-transparent text-popover-foreground hover:bg-transparent'),
    onClick: clearSearch,
    title: i18n.clear,
    "aria-label": "Clear",
    type: "button"
  }, _emoji_icons__WEBPACK_IMPORTED_MODULE_3__.emojiSearchIcons.delete));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-search-bar.tsx":
/*!**************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-search-bar.tsx ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmojiPickerSearchBar: () => (/* binding */ EmojiPickerSearchBar)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__);
'use client';



function EmojiPickerSearchBar(_a) {
  var children = _a.children,
    i18n = _a.i18n,
    searchValue = _a.searchValue,
    setSearch = _a.setSearch;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "flex items-center px-2"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "relative flex grow items-center"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
    className: "block w-full appearance-none rounded-full border-0 bg-muted px-10 py-2 text-sm outline-none placeholder:text-muted-foreground focus-visible:outline-none",
    value: searchValue,
    onChange: function (event) {
      return setSearch(event.target.value);
    },
    placeholder: i18n.search,
    "aria-label": "Search",
    autoComplete: "off",
    type: "text",
    autoFocus: true,
    "data-plate-focus-id": (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__.useEditorRef)().id
  }), children));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker.tsx":
/*!***************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker.tsx ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmojiPicker: () => (/* binding */ EmojiPicker)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_emoji__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-emoji */ "@udecode/plate-emoji");
/* harmony import */ var _udecode_plate_emoji__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_emoji__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _emoji_picker_content__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./emoji-picker-content */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-content.tsx");
/* harmony import */ var _emoji_picker_navigation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./emoji-picker-navigation */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-navigation.tsx");
/* harmony import */ var _emoji_picker_preview__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./emoji-picker-preview */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-preview.tsx");
/* harmony import */ var _emoji_picker_search_and_clear__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./emoji-picker-search-and-clear */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-search-and-clear.tsx");
/* harmony import */ var _emoji_picker_search_bar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./emoji-picker-search-bar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-picker-search-bar.tsx");
'use client';









function EmojiPicker(_a) {
  var clearSearch = _a.clearSearch,
    emoji = _a.emoji,
    emojiLibrary = _a.emojiLibrary,
    focusedCategory = _a.focusedCategory,
    hasFound = _a.hasFound,
    i18n = _a.i18n,
    icons = _a.icons,
    isSearching = _a.isSearching,
    refs = _a.refs,
    searchResult = _a.searchResult,
    searchValue = _a.searchValue,
    setSearch = _a.setSearch,
    _b = _a.settings,
    settings = _b === void 0 ? _udecode_plate_emoji__WEBPACK_IMPORTED_MODULE_2__.EmojiSettings : _b,
    visibleCategories = _a.visibleCategories,
    handleCategoryClick = _a.handleCategoryClick,
    onMouseOver = _a.onMouseOver,
    onSelectEmoji = _a.onSelectEmoji;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('flex flex-col rounded-xl bg-popover text-popover-foreground', 'h-[23rem] w-80 border shadow-md')
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_emoji_picker_navigation__WEBPACK_IMPORTED_MODULE_4__.EmojiPickerNavigation, {
    onClick: handleCategoryClick,
    emojiLibrary: emojiLibrary,
    focusedCategory: focusedCategory,
    i18n: i18n,
    icons: icons
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_emoji_picker_search_bar__WEBPACK_IMPORTED_MODULE_7__.EmojiPickerSearchBar, {
    i18n: i18n,
    searchValue: searchValue,
    setSearch: setSearch
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_emoji_picker_search_and_clear__WEBPACK_IMPORTED_MODULE_6__.EmojiPickerSearchAndClear, {
    clearSearch: clearSearch,
    i18n: i18n,
    searchValue: searchValue
  })), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_emoji_picker_content__WEBPACK_IMPORTED_MODULE_3__.EmojiPickerContent, {
    onMouseOver: onMouseOver,
    onSelectEmoji: onSelectEmoji,
    emojiLibrary: emojiLibrary,
    i18n: i18n,
    isSearching: isSearching,
    refs: refs,
    searchResult: searchResult,
    settings: settings,
    visibleCategories: visibleCategories
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_emoji_picker_preview__WEBPACK_IMPORTED_MODULE_5__.EmojiPickerPreview, {
    emoji: emoji,
    hasFound: hasFound,
    i18n: i18n,
    isSearching: isSearching
  }));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-toolbar-dropdown.tsx":
/*!*************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/emoji-toolbar-dropdown.tsx ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmojiToolbarDropdown: () => (/* binding */ EmojiToolbarDropdown)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _radix_ui_react_popover__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @radix-ui/react-popover */ "./node_modules/@radix-ui/react-popover/dist/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__);
'use client';




function EmojiToolbarDropdown(_a) {
  var children = _a.children,
    control = _a.control,
    isOpen = _a.isOpen,
    setIsOpen = _a.setIsOpen;
  var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__.useEditorRef)(),
    zclass = editor.zclass;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_radix_ui_react_popover__WEBPACK_IMPORTED_MODULE_2__.Root, {
    open: isOpen,
    onOpenChange: setIsOpen
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_radix_ui_react_popover__WEBPACK_IMPORTED_MODULE_2__.Trigger, {
    asChild: true
  }, control), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_radix_ui_react_popover__WEBPACK_IMPORTED_MODULE_2__.Portal, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_radix_ui_react_popover__WEBPACK_IMPORTED_MODULE_2__.Content, {
    className: "".concat(zclass, "-toolbar-pp"),
    onCloseAutoFocus: function (e) {
      e.preventDefault();
      editor.tf.focus();
    }
  }, children)));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/fixed-toolbar.tsx":
/*!****************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/fixed-toolbar.tsx ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FixedToolbar: () => (/* binding */ FixedToolbar)
/* harmony export */ });
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
'use client';



var FixedToolbar = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withCn)(_toolbar__WEBPACK_IMPORTED_MODULE_1__.Toolbar, 'sticky top-0 left-0 z-50 scrollbar-hide w-full justify-between overflow-x-auto rounded-t-lg border-b border-b-border bg-background/95 p-1 backdrop-blur-sm supports-backdrop-blur:bg-background/60');

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/font-size-toolbar-button.tsx":
/*!***************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/font-size-toolbar-button.tsx ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FontSizeToolbarButton: () => (/* binding */ FontSizeToolbarButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_font__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-font */ "@udecode/plate-font");
/* harmony import */ var _udecode_plate_font__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_font__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @udecode/plate-font/react */ "./node_modules/@udecode/plate-font/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate-heading */ "@udecode/plate-heading");
/* harmony import */ var _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/minus.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/plus.js");
/* harmony import */ var _popover__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./popover */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/popover.tsx");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
'use client';

var _a;









var DEFAULT_FONT_SIZE = '16';
var FONT_SIZE_MAP = (_a = {}, _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__.HEADING_KEYS.h1] = '36', _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__.HEADING_KEYS.h2] = '24', _a[_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_3__.HEADING_KEYS.h3] = '20', _a);
var FONT_SIZES = ['8', '9', '10', '12', '14', '16', '18', '24', '30', '36', '48', '60', '72', '96'];
function FontSizeToolbarButton() {
  var _a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(DEFAULT_FONT_SIZE),
    inputValue = _a[0],
    setInputValue = _a[1];
  var _b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    isFocused = _b[0],
    setIsFocused = _b[1];
  var _c = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_4__.useEditorPlugin)(_udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_7__.FontSizePlugin),
    api = _c.api,
    editor = _c.editor;
  var cursorFontSize = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_4__.useEditorSelector)(function (editor) {
    var _a;
    var fontSize = (_a = editor.api.marks()) === null || _a === void 0 ? void 0 : _a[_udecode_plate_font_react__WEBPACK_IMPORTED_MODULE_7__.FontSizePlugin.key];
    if (fontSize) {
      return (0,_udecode_plate_font__WEBPACK_IMPORTED_MODULE_2__.toUnitLess)(fontSize);
    }
    var block = (editor.api.block() || [])[0];
    if (!(block === null || block === void 0 ? void 0 : block.type)) return DEFAULT_FONT_SIZE;
    return block.type in FONT_SIZE_MAP ? FONT_SIZE_MAP[block.type] : DEFAULT_FONT_SIZE;
  }, []);
  var handleInputChange = function () {
    var newSize = (0,_udecode_plate_font__WEBPACK_IMPORTED_MODULE_2__.toUnitLess)(inputValue);
    if (Number.parseInt(newSize) < 1 || Number.parseInt(newSize) > 100) {
      editor.tf.focus();
      return;
    }
    if (newSize !== (0,_udecode_plate_font__WEBPACK_IMPORTED_MODULE_2__.toUnitLess)(cursorFontSize)) {
      api.fontSize.setMark("".concat(newSize, "px"));
    }
    editor.tf.focus();
  };
  var handleFontSizeChange = function (delta) {
    var newSize = Number(displayValue) + delta;
    api.fontSize.setMark("".concat(newSize, "px"));
    editor.tf.focus();
  };
  var displayValue = isFocused ? inputValue : cursorFontSize;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "flex h-7 items-center gap-1 rounded-md bg-muted/60 p-0"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_6__.ToolbarButton, {
    onClick: function () {
      return handleFontSizeChange(-1);
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_8__["default"], null)), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_popover__WEBPACK_IMPORTED_MODULE_5__.Popover, {
    open: isFocused,
    modal: false
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_popover__WEBPACK_IMPORTED_MODULE_5__.PopoverTrigger, {
    asChild: true
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('h-full w-10 shrink-0 bg-transparent px-1 text-center text-sm hover:bg-muted'),
    value: displayValue,
    onBlur: function () {
      setIsFocused(false);
      handleInputChange();
    },
    onChange: function (e) {
      return setInputValue(e.target.value);
    },
    onFocus: function () {
      setIsFocused(true);
      setInputValue((0,_udecode_plate_font__WEBPACK_IMPORTED_MODULE_2__.toUnitLess)(cursorFontSize));
    },
    onKeyDown: function (e) {
      if (e.key === 'Enter') {
        e.preventDefault();
        handleInputChange();
      }
    },
    "data-plate-focus": "true",
    "data-plate-focus-id": editor.id,
    type: "text"
  })), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_popover__WEBPACK_IMPORTED_MODULE_5__.PopoverContent, {
    className: "w-10 px-px py-1",
    onOpenAutoFocus: function (e) {
      return e.preventDefault();
    }
  }, FONT_SIZES.map(function (size) {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
      key: size,
      className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('flex h-8 w-full items-center justify-center text-sm hover:bg-accent data-[highlighted=true]:bg-accent'),
      onClick: function () {
        api.fontSize.setMark("".concat(size, "px"));
        setIsFocused(false);
      },
      "data-highlighted": size === displayValue,
      type: "button"
    }, size);
  }))), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_6__.ToolbarButton, {
    onClick: function () {
      return handleFontSizeChange(1);
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_9__["default"], null)));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/history-toolbar-button.tsx":
/*!*************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/history-toolbar-button.tsx ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RedoToolbarButton: () => (/* binding */ RedoToolbarButton),
/* harmony export */   UndoToolbarButton: () => (/* binding */ UndoToolbarButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/redo-2.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/undo-2.js");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';





var RedoToolbarButton = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (props, ref) {
  var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__.useEditorRef)();
  var disabled = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__.useEditorSelector)(function (editor) {
    return editor.history.redos.length === 0;
  }, []);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_2__.ToolbarButton, __assign({
    ref: ref,
    disabled: disabled,
    onClick: function () {
      return editor.redo();
    },
    onMouseDown: function (e) {
      return e.preventDefault();
    },
    tooltip: "Redo"
  }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_3__["default"], null));
});
var UndoToolbarButton = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (props, ref) {
  var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__.useEditorRef)();
  var disabled = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_1__.useEditorSelector)(function (editor) {
    return editor.history.undos.length === 0;
  }, []);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_2__.ToolbarButton, __assign({
    ref: ref,
    disabled: disabled,
    onClick: function () {
      return editor.undo();
    },
    onMouseDown: function (e) {
      return e.preventDefault();
    },
    tooltip: "Undo"
  }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_4__["default"], null));
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/indent-toolbar-button.tsx":
/*!************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/indent-toolbar-button.tsx ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IndentToolbarButton: () => (/* binding */ IndentToolbarButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_indent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-indent */ "@udecode/plate-indent");
/* harmony import */ var _udecode_plate_indent__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_indent__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _udecode_plate_indent_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @udecode/plate-indent/react */ "./node_modules/@udecode/plate-indent/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_list__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @udecode/plate-list */ "./node_modules/@udecode/plate-list/dist/index.mjs");
/* harmony import */ var _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @udecode/plate-table/react */ "./node_modules/@udecode/plate-table/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/indent-increase.js");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';










var IndentToolbarButton = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (rest, ref) {
  var props = (0,_udecode_plate_indent_react__WEBPACK_IMPORTED_MODULE_5__.useIndentButton)().props,
    editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorRef)(),
    selectedCells = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.usePluginOption)(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__.TablePlugin, 'selectedCells');
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_4__.ToolbarButton, __assign({
    ref: ref,
    tooltip: "Indent"
  }, props, rest, {
    /* Potix: add list-indent-toolbar-button functionality */
    onClick: function () {
      /* Potix: Fix toolbar action after grid cell selection */
      if (selectedCells && selectedCells.length > 0) {
        selectedCells.forEach(function (cell) {
          var cellPath = editor.api.findPath(cell);
          if (cellPath) {
            // equivalent to indentListItems(editor) with return value
            (0,_udecode_plate_list__WEBPACK_IMPORTED_MODULE_7__.moveListItems)(editor, {
              at: cellPath,
              increase: true
            }) || (0,_udecode_plate_indent__WEBPACK_IMPORTED_MODULE_2__.indent)(editor, {
              getNodesOptions: {
                at: cellPath
              }
            });
          }
        });
      } else (0,_udecode_plate_list__WEBPACK_IMPORTED_MODULE_7__.moveListItems)(editor, {
        increase: true
      }) || (0,_udecode_plate_indent__WEBPACK_IMPORTED_MODULE_2__.indent)(editor);
    }
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_8__["default"], null));
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/input.tsx":
/*!********************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/input.tsx ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FloatingInput: () => (/* binding */ FloatingInput),
/* harmony export */   Input: () => (/* binding */ Input),
/* harmony export */   inputVariants: () => (/* binding */ inputVariants)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! class-variance-authority */ "class-variance-authority");
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(class_variance_authority__WEBPACK_IMPORTED_MODULE_2__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];



var inputVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_2__.cva)('flex w-full rounded-md bg-transparent text-base file:border-0 file:bg-background file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm', {
  defaultVariants: {
    h: 'md',
    variant: 'default'
  },
  variants: {
    h: {
      md: 'h-10 px-3 py-2',
      sm: 'h-[28px] px-1.5 py-1'
    },
    variant: {
      default: 'border border-input ring-offset-background focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2',
      ghost: 'border-none focus-visible:ring-transparent'
    }
  }
});
var Input = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withVariants)('input', inputVariants, ['variant', 'h']);
function FloatingInput(_a) {
  var id = _a.id,
    className = _a.className,
    label = _a.label,
    props = __rest(_a, ["id", "className", "label"]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", {
    className: "absolute top-1/2 block -translate-y-1/2 cursor-text px-1 text-sm text-muted-foreground/70 transition-all group-focus-within:pointer-events-none group-focus-within:top-0 group-focus-within:cursor-default group-focus-within:text-xs group-focus-within:font-medium group-focus-within:text-foreground has-[+input:not(:placeholder-shown)]:pointer-events-none has-[+input:not(:placeholder-shown)]:top-0 has-[+input:not(:placeholder-shown)]:cursor-default has-[+input:not(:placeholder-shown)]:text-xs has-[+input:not(:placeholder-shown)]:font-medium has-[+input:not(:placeholder-shown)]:text-foreground",
    htmlFor: id
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "inline-flex bg-background px-2"
  }, label)), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Input, __assign({
    id: id,
    className: className,
    placeholder: ""
  }, props)));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/line-height-dropdown-menu.tsx":
/*!****************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/line-height-dropdown-menu.tsx ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LineHeightDropdownMenu: () => (/* binding */ LineHeightDropdownMenu)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate_line_height__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate-line-height */ "@udecode/plate-line-height");
/* harmony import */ var _udecode_plate_line_height__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_line_height__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_line_height_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @udecode/plate-line-height/react */ "./node_modules/@udecode/plate-line-height/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @udecode/plate-table/react */ "./node_modules/@udecode/plate-table/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/wrap-text.js");
/* harmony import */ var _dropdown_menu__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/dropdown-menu.tsx");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';









function LineHeightDropdownMenu(_a) {
  var props = __rest(_a, []);
  var openState = (0,_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.useOpenState)();
  var state = (0,_udecode_plate_line_height_react__WEBPACK_IMPORTED_MODULE_5__.useLineHeightDropdownMenuState)();
  var radioGroupProps = (0,_udecode_plate_line_height_react__WEBPACK_IMPORTED_MODULE_5__.useLineHeightDropdownMenu)(state).radioGroupProps;
  var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useEditorRef)();
  var selectedCells = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.usePluginOption)(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__.TablePlugin, 'selectedCells');
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenu, __assign({
    modal: false
  }, openState, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuTrigger, {
    asChild: true
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_4__.ToolbarButton, {
    pressed: openState.open,
    tooltip: "Line height",
    isDropdown: true
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_7__["default"], null))), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuContent, {
    className: "min-w-0",
    align: "start"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuRadioGroup, __assign({}, radioGroupProps, {
    onValueChange: function (value) {
      /* Potix: Fix toolbar action after grid cell selection */
      if (selectedCells && selectedCells.length > 0) {
        selectedCells.forEach(function (cell) {
          var cellPath = editor.api.findPath(cell);
          if (cellPath) (0,_udecode_plate_line_height__WEBPACK_IMPORTED_MODULE_1__.setLineHeight)(editor, {
            setNodesOptions: {
              at: cellPath
            },
            value: Number(value)
          });
        });
      } else (0,_udecode_plate_line_height__WEBPACK_IMPORTED_MODULE_1__.setLineHeight)(editor, {
        value: Number(value)
      });
      editor.tf.focus();
    }
  }), state.values.map(function (_value) {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuRadioItem, {
      key: _value,
      className: "min-w-[180px]",
      value: _value
    }, _value);
  }))));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/link-floating-toolbar.tsx":
/*!************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/link-floating-toolbar.tsx ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LinkFloatingToolbar: () => (/* binding */ LinkFloatingToolbar)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_floating__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @udecode/plate-floating */ "./node_modules/@floating-ui/react-dom/dist/floating-ui.react-dom.mjs");
/* harmony import */ var _udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @udecode/plate-link/react */ "./node_modules/@udecode/plate-link/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/link.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/text.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/external-link.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/unlink.js");
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/button.tsx");
/* harmony import */ var _input__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./input */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/input.tsx");
/* harmony import */ var _popover__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./popover */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/popover.tsx");
/* harmony import */ var _separator__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./separator */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/separator.tsx");
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';











var floatingOptions = {
  middleware: [(0,_udecode_plate_floating__WEBPACK_IMPORTED_MODULE_7__.offset)(12), (0,_udecode_plate_floating__WEBPACK_IMPORTED_MODULE_7__.flip)({
    fallbackPlacements: ['bottom-end', 'top-start', 'top-end'],
    padding: 12
  })],
  placement: 'bottom-start'
};
function LinkFloatingToolbar(_a) {
  var state = _a.state;
  var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useEditorRef)(),
    zclass = editor.zclass;
  var insertState = (0,_udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_8__.useFloatingLinkInsertState)(__assign(__assign({}, state), {
    floatingOptions: __assign(__assign({}, floatingOptions), state === null || state === void 0 ? void 0 : state.floatingOptions)
  }));
  var _b = (0,_udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_8__.useFloatingLinkInsert)(insertState),
    hidden = _b.hidden,
    insertProps = _b.props,
    insertRef = _b.ref,
    textInputProps = _b.textInputProps;
  insertProps.style.zIndex = 1800;
  insertProps.style.position = 'fixed';
  var editState = (0,_udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_8__.useFloatingLinkEditState)(__assign(__assign({}, state), {
    floatingOptions: __assign(__assign({}, floatingOptions), state === null || state === void 0 ? void 0 : state.floatingOptions)
  }));
  var _c = (0,_udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_8__.useFloatingLinkEdit)(editState),
    editButtonProps = _c.editButtonProps,
    editProps = _c.props,
    editRef = _c.ref,
    unlinkButtonProps = _c.unlinkButtonProps;
  editProps.style.zIndex = 1800;
  editProps.style.position = 'fixed';
  var inputProps = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useFormInputProps)({
    preventDefaultOnEnterKeydown: true
  });
  if (hidden) return null;
  var input = react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", __assign({
    className: "flex w-[330px] flex-col"
  }, inputProps), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "flex items-center"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "flex items-center pr-1 pl-2 text-muted-foreground"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_9__["default"], {
    className: "size-4"
  })), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_8__.FloatingLinkUrlInput, {
    className: (0,_input__WEBPACK_IMPORTED_MODULE_4__.inputVariants)({
      h: 'sm',
      variant: 'ghost'
    }),
    placeholder: "Paste link",
    "data-plate-focus": "true",
    "data-plate-focus-id": editor.id
  })), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_separator__WEBPACK_IMPORTED_MODULE_6__.Separator, {
    className: "my-1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "flex items-center"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "flex items-center pr-1 pl-2 text-muted-foreground"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_10__["default"], {
    className: "size-4"
  })), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", __assign({
    className: (0,_input__WEBPACK_IMPORTED_MODULE_4__.inputVariants)({
      h: 'sm',
      variant: 'ghost'
    }),
    placeholder: "Text to display",
    "data-plate-focus": "true",
    "data-plate-focus-id": editor.id
  }, textInputProps))));
  var editContent = editState.isEditing ? input : react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "box-content flex items-center"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", __assign({
    className: (0,_button__WEBPACK_IMPORTED_MODULE_3__.buttonVariants)({
      size: 'sm',
      variant: 'ghost'
    }),
    "data-plate-focus-id": editor.id,
    type: "button"
  }, editButtonProps), "Edit link"), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_separator__WEBPACK_IMPORTED_MODULE_6__.Separator, {
    orientation: "vertical"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_8__.LinkOpenButton, {
    className: (0,_button__WEBPACK_IMPORTED_MODULE_3__.buttonVariants)({
      size: 'icon',
      variant: 'ghost'
    }),
    "data-plate-focus-id": editor.id
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_11__["default"], {
    width: 18
  })), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_separator__WEBPACK_IMPORTED_MODULE_6__.Separator, {
    orientation: "vertical"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", __assign({
    className: (0,_button__WEBPACK_IMPORTED_MODULE_3__.buttonVariants)({
      size: 'icon',
      variant: 'ghost'
    }),
    "data-plate-focus-id": editor.id,
    type: "button"
  }, unlinkButtonProps), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_12__["default"], {
    width: 18
  })));
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", __assign({
    ref: insertRef,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)((0,_popover__WEBPACK_IMPORTED_MODULE_5__.popoverVariants)(zclass)(), 'w-auto p-1')
  }, insertProps), input), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", __assign({
    ref: editRef,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)((0,_popover__WEBPACK_IMPORTED_MODULE_5__.popoverVariants)(zclass)(), 'w-auto p-1')
  }, editProps), editContent));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/link-toolbar-button.tsx":
/*!**********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/link-toolbar-button.tsx ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LinkToolbarButton: () => (/* binding */ LinkToolbarButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate-link/react */ "./node_modules/@udecode/plate-link/dist/react/index.mjs");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/link.js");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';






var LinkToolbarButton = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (rest, ref) {
  var state = (0,_udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_3__.useLinkToolbarButtonState)();
  var props = (0,_udecode_plate_link_react__WEBPACK_IMPORTED_MODULE_3__.useLinkToolbarButton)(state).props;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_2__.ToolbarButton, __assign({
    ref: ref,
    "data-plate-focus": true,
    tooltip: "Link"
  }, props, rest), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_4__["default"], null));
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/list-toolbar-button.tsx":
/*!**********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/list-toolbar-button.tsx ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ListToolbarButton: () => (/* binding */ ListToolbarButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate-list/react */ "./node_modules/@udecode/plate-list/dist/react/index.mjs");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/list.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/list-ordered.js");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';






var ListToolbarButton = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var _b = _a.nodeType,
    nodeType = _b === void 0 ? _udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_3__.BulletedListPlugin.key : _b,
    rest = __rest(_a, ["nodeType"]);
  var state = (0,_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_3__.useListToolbarButtonState)({
    nodeType: nodeType
  });
  var props = (0,_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_3__.useListToolbarButton)(state).props;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_2__.ToolbarButton, __assign({
    ref: ref,
    tooltip: nodeType === _udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_3__.BulletedListPlugin.key ? 'Bulleted List' : 'Numbered List'
  }, props, rest), nodeType === _udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_3__.BulletedListPlugin.key ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_4__["default"], null) : react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_5__["default"], null));
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/mark-toolbar-button.tsx":
/*!**********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/mark-toolbar-button.tsx ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MarkToolbarButton: () => (/* binding */ MarkToolbarButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';





var MarkToolbarButton = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var clear = _a.clear,
    nodeType = _a.nodeType,
    rest = __rest(_a, ["clear", "nodeType"]);
  var state = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useMarkToolbarButtonState)({
    clear: clear,
    nodeType: nodeType
  });
  var props = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useMarkToolbarButton)(state).props;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_3__.ToolbarButton, __assign({
    ref: ref
  }, props, rest));
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/media-toolbar-button.tsx":
/*!***********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/media-toolbar-button.tsx ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MediaToolbarButton: () => (/* binding */ MediaToolbarButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate */ "@udecode/plate");
/* harmony import */ var _udecode_plate__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @udecode/plate-media/react */ "./node_modules/@udecode/plate-media/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/audio-lines.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/file-up.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/image.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/film.js");
/* harmony import */ var sonner__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! sonner */ "./node_modules/sonner/dist/index.mjs");
/* harmony import */ var _alert_dialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./alert-dialog */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/alert-dialog.tsx");
/* harmony import */ var _dropdown_menu__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/dropdown-menu.tsx");
/* harmony import */ var _input__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./input */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/input.tsx");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
'use client';

var _a;






// import { useFilePicker } from 'use-file-picker';




var MEDIA_CONFIG = (_a = {}, _a[_udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_8__.AudioPlugin.key] = {
  accept: ['audio/*'],
  icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_9__["default"], {
    className: "size-4"
  }),
  title: 'Insert Audio',
  tooltip: 'Audio'
}, _a[_udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_8__.FilePlugin.key] = {
  accept: ['*'],
  icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_10__["default"], {
    className: "size-4"
  }),
  title: 'Insert File',
  tooltip: 'File'
}, _a[_udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_8__.ImagePlugin.key] = {
  accept: ['image/*'],
  icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_11__["default"], {
    className: "size-4"
  }),
  title: 'Insert Image',
  tooltip: 'Image'
}, _a[_udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_8__.VideoPlugin.key] = {
  accept: ['video/*'],
  icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_12__["default"], {
    className: "size-4"
  }),
  title: 'Insert Video',
  tooltip: 'Video'
}, _a);
function MediaToolbarButton(_a) {
  var children = _a.children,
    nodeType = _a.nodeType,
    props = __rest(_a, ["children", "nodeType"]);
  var currentConfig = MEDIA_CONFIG[nodeType];
  var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useEditorRef)();
  var openState = (0,_dropdown_menu__WEBPACK_IMPORTED_MODULE_5__.useOpenState)();
  var _b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
    dialogOpen = _b[0],
    setDialogOpen = _b[1];
  // const { openFilePicker } = useFilePicker({
  //     accept: currentConfig.accept,
  //     multiple: true,
  //     onFilesSelected: ({ plainFiles: updatedFiles }) => {
  //         (editor as any).tf.insert.media(updatedFiles);
  //     },
  // });
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_7__.ToolbarSplitButton, {
    "data-plate-focus-id": editor.id,
    onClick: function () {
      // openFilePicker();
      setDialogOpen(true);
    },
    onKeyDown: function (e) {
      if (e.key === 'ArrowDown') {
        e.preventDefault();
        openState.onOpenChange(true);
      }
    },
    pressed: openState.open
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_7__.ToolbarSplitButtonPrimary, {
    tooltip: currentConfig.tooltip
  }, currentConfig.icon)), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.AlertDialog, {
    open: dialogOpen,
    onOpenChange: function (value) {
      setDialogOpen(value);
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.AlertDialogContent, {
    className: "gap-6",
    onCloseAutoFocus: function (e) {
      e.preventDefault();
      editor.tf.focus();
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(MediaUrlDialogContent, {
    currentConfig: currentConfig,
    nodeType: nodeType,
    setOpen: setDialogOpen
  }))));
}
function MediaUrlDialogContent(_a) {
  var currentConfig = _a.currentConfig,
    nodeType = _a.nodeType,
    setOpen = _a.setOpen;
  var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useEditorRef)();
  var _b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(''),
    url = _b[0],
    setUrl = _b[1];
  var embedMedia = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    if (!(0,_udecode_plate__WEBPACK_IMPORTED_MODULE_1__.isUrl)(url)) return sonner__WEBPACK_IMPORTED_MODULE_3__.toast.error('Invalid URL');
    setOpen(false);
    editor.tf.insertNodes({
      children: [{
        text: ''
      }],
      name: nodeType === _udecode_plate_media_react__WEBPACK_IMPORTED_MODULE_8__.FilePlugin.key ? url.split('/').pop() : undefined,
      type: nodeType,
      url: url
    });
  }, [url, editor, nodeType, setOpen]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.AlertDialogHeader, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.AlertDialogTitle, null, currentConfig.title)), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.AlertDialogDescription, {
    className: "group relative w-full"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_input__WEBPACK_IMPORTED_MODULE_6__.FloatingInput, {
    id: "url",
    className: "w-full",
    value: url,
    onChange: function (e) {
      return setUrl(e.target.value);
    },
    onKeyDown: function (e) {
      if (e.key === 'Enter') embedMedia();
    },
    label: "URL",
    placeholder: "",
    type: "url",
    autoFocus: true,
    "data-plate-focus-id": editor.id
  })), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.AlertDialogFooter, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.AlertDialogCancel, null, "Cancel"), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_alert_dialog__WEBPACK_IMPORTED_MODULE_4__.AlertDialogAction, {
    onClick: function (e) {
      e.preventDefault();
      embedMedia();
    }
  }, "Accept")));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/outdent-toolbar-button.tsx":
/*!*************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/outdent-toolbar-button.tsx ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OutdentToolbarButton: () => (/* binding */ OutdentToolbarButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_indent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-indent */ "@udecode/plate-indent");
/* harmony import */ var _udecode_plate_indent__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_indent__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _udecode_plate_indent_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @udecode/plate-indent/react */ "./node_modules/@udecode/plate-indent/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_list__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @udecode/plate-list */ "./node_modules/@udecode/plate-list/dist/index.mjs");
/* harmony import */ var _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @udecode/plate-table/react */ "./node_modules/@udecode/plate-table/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/indent-decrease.js");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';










var OutdentToolbarButton = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (rest, ref) {
  var props = (0,_udecode_plate_indent_react__WEBPACK_IMPORTED_MODULE_5__.useOutdentButton)().props,
    editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorRef)(),
    selectedCells = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.usePluginOption)(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_6__.TablePlugin, 'selectedCells');
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_4__.ToolbarButton, __assign({
    ref: ref,
    tooltip: "Outdent"
  }, props, rest, {
    /* Potix: add list-indent-toolbar-button functionality */
    onClick: function () {
      /* Potix: Fix toolbar action after grid cell selection */
      if (selectedCells && selectedCells.length > 0) {
        selectedCells.forEach(function (cell) {
          var cellPath = editor.api.findPath(cell);
          if (cellPath) {
            (0,_udecode_plate_list__WEBPACK_IMPORTED_MODULE_7__.unindentListItems)(editor, {
              at: cellPath
            }) || (0,_udecode_plate_indent__WEBPACK_IMPORTED_MODULE_2__.outdent)(editor, {
              getNodesOptions: {
                at: cellPath
              }
            });
          }
        });
      } else (0,_udecode_plate_list__WEBPACK_IMPORTED_MODULE_7__.unindentListItems)(editor) || (0,_udecode_plate_indent__WEBPACK_IMPORTED_MODULE_2__.outdent)(editor);
    }
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_8__["default"], null));
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/popover.tsx":
/*!**********************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/popover.tsx ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Popover: () => (/* binding */ Popover),
/* harmony export */   PopoverAnchor: () => (/* binding */ PopoverAnchor),
/* harmony export */   PopoverContent: () => (/* binding */ PopoverContent),
/* harmony export */   PopoverTrigger: () => (/* binding */ PopoverTrigger),
/* harmony export */   popoverVariants: () => (/* binding */ popoverVariants)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _radix_ui_react_popover__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @radix-ui/react-popover */ "./node_modules/@radix-ui/react-popover/dist/index.mjs");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! class-variance-authority */ "class-variance-authority");
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(class_variance_authority__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';






var Popover = _radix_ui_react_popover__WEBPACK_IMPORTED_MODULE_4__.Root;
var PopoverTrigger = _radix_ui_react_popover__WEBPACK_IMPORTED_MODULE_4__.Trigger;
var PopoverAnchor = _radix_ui_react_popover__WEBPACK_IMPORTED_MODULE_4__.Anchor;
var createPopoverVariants = function (zclass) {
  return (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_2__.cva)("".concat(zclass, "-toolbar-pp w-72 rounded-md border bg-popover p-4 text-popover-foreground shadow-md outline-hidden print:hidden"), {
    defaultVariants: {
      animate: true
    },
    variants: {
      animate: {
        true: 'data-[side=bottom]:slide-in-from-top-2 data-[side=left]:slide-in-from-right-2 data-[side=right]:slide-in-from-left-2 data-[side=top]:slide-in-from-bottom-2 data-[state=closed]:animate-out data-[state=closed]:fade-out-0 data-[state=closed]:zoom-out-95 data-[state=open]:animate-in data-[state=open]:fade-in-0 data-[state=open]:zoom-in-95'
      }
    }
  });
};
var popoverVariants = function (zclass) {
  return createPopoverVariants(zclass);
};
var PopoverContent = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var _b = _a.align,
    align = _b === void 0 ? 'center' : _b,
    animate = _a.animate,
    className = _a.className,
    _c = _a.sideOffset,
    sideOffset = _c === void 0 ? 4 : _c,
    props = __rest(_a, ["align", "animate", "className", "sideOffset"]);
  var zclass = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorRef)().zclass,
    popoverVariants = createPopoverVariants(zclass);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_popover__WEBPACK_IMPORTED_MODULE_4__.Portal, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_popover__WEBPACK_IMPORTED_MODULE_4__.Content, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(popoverVariants({
      animate: animate
    }), className),
    align: align,
    sideOffset: sideOffset
  }, props)));
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/separator.tsx":
/*!************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/separator.tsx ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Separator: () => (/* binding */ Separator)
/* harmony export */ });
/* harmony import */ var _radix_ui_react_separator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @radix-ui/react-separator */ "./node_modules/@radix-ui/react-separator/dist/index.mjs");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! class-variance-authority */ "class-variance-authority");
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(class_variance_authority__WEBPACK_IMPORTED_MODULE_1__);
'use client';




var separatorVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_1__.cva)('shrink-0 bg-border', {
  defaultVariants: {
    orientation: 'horizontal'
  },
  variants: {
    orientation: {
      horizontal: 'h-px w-full',
      vertical: 'h-full w-px'
    }
  }
});
var Separator = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withVariants)((0,_udecode_cn__WEBPACK_IMPORTED_MODULE_0__.withProps)(_radix_ui_react_separator__WEBPACK_IMPORTED_MODULE_2__.Root, {
  decorative: true,
  orientation: 'horizontal'
}), separatorVariants);

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/table-dropdown-menu.tsx":
/*!**********************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/table-dropdown-menu.tsx ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableDropdownMenu: () => (/* binding */ TableDropdownMenu),
/* harmony export */   TablePicker: () => (/* binding */ TablePicker)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @udecode/plate-table/react */ "./node_modules/@udecode/plate-table/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/table.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/grid-3x3.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/combine.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/ungroup.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/arrow-up.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/arrow-down.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/x.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/arrow-left.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/arrow-right.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/trash-2.js");
/* harmony import */ var _dropdown_menu__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/dropdown-menu.tsx");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
/* provided dependency */ var __spreadArray = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__spreadArray"];
'use client';








function TableDropdownMenu(props) {
  var tableSelected = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useEditorSelector)(function (editor) {
    return editor.api.some({
      match: {
        type: _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_5__.TablePlugin.key
      }
    });
  }, []);
  var _a = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useEditorPlugin)(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_5__.TablePlugin),
    editor = _a.editor,
    tf = _a.tf;
  var openState = (0,_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.useOpenState)();
  var mergeState = (0,_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_5__.useTableMergeState)();
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenu, __assign({
    modal: false
  }, openState, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuTrigger, {
    asChild: true
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_4__.ToolbarButton, {
    pressed: openState.open,
    tooltip: "Table",
    isDropdown: true
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_6__["default"], null))), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuContent, {
    className: "flex w-[180px] min-w-0 flex-col",
    align: "start"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuGroup, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuSub, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuSubTrigger, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_7__["default"], null), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Table")), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuSubContent, {
    className: "m-0 p-0"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(TablePicker, null))), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuSub, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuSubTrigger, {
    disabled: !tableSelected
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "size-4"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Cell")), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuSubContent, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuItem, {
    className: "min-w-[180px]",
    disabled: !mergeState.canMerge,
    onSelect: function () {
      tf.table.merge();
      editor.tf.focus();
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_8__["default"], null), "Merge cells"), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuItem, {
    className: "min-w-[180px]",
    disabled: !mergeState.canSplit,
    onSelect: function () {
      tf.table.split();
      editor.tf.focus();
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_9__["default"], null), "Split cell"))), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuSub, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuSubTrigger, {
    disabled: !tableSelected
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "size-4"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Row")), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuSubContent, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuItem, {
    className: "min-w-[180px]",
    disabled: !tableSelected,
    onSelect: function () {
      tf.insert.tableRow({
        before: true
      });
      editor.tf.focus();
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_10__["default"], null), "Insert row before"), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuItem, {
    className: "min-w-[180px]",
    disabled: !tableSelected,
    onSelect: function () {
      tf.insert.tableRow();
      editor.tf.focus();
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_11__["default"], null), "Insert row after"), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuItem, {
    className: "min-w-[180px]",
    disabled: !tableSelected,
    onSelect: function () {
      tf.remove.tableRow();
      editor.tf.focus();
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_12__["default"], null), "Delete row"))), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuSub, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuSubTrigger, {
    disabled: !tableSelected
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "size-4"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Column")), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuSubContent, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuItem, {
    className: "min-w-[180px]",
    disabled: !tableSelected,
    onSelect: function () {
      tf.insert.tableColumn({
        before: true
      });
      editor.tf.focus();
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_13__["default"], null), "Insert column before"), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuItem, {
    className: "min-w-[180px]",
    disabled: !tableSelected,
    onSelect: function () {
      tf.insert.tableColumn();
      editor.tf.focus();
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_14__["default"], null), "Insert column after"), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuItem, {
    className: "min-w-[180px]",
    disabled: !tableSelected,
    onSelect: function () {
      tf.remove.tableColumn();
      editor.tf.focus();
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_12__["default"], null), "Delete column"))), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenuItem, {
    className: "min-w-[180px]",
    disabled: !tableSelected,
    onSelect: function () {
      tf.remove.table();
      editor.tf.focus();
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_15__["default"], null), "Delete table"))));
}
function TablePicker() {
  var _a = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useEditorPlugin)(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_5__.TablePlugin),
    editor = _a.editor,
    tf = _a.tf;
  var _b = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({
      grid: Array.from({
        length: 8
      }, function () {
        return Array.from({
          length: 8
        }).fill(0);
      }),
      size: {
        colCount: 0,
        rowCount: 0
      }
    }),
    tablePicker = _b[0],
    setTablePicker = _b[1];
  var onCellMove = function (rowIndex, colIndex) {
    var newGrid = __spreadArray([], tablePicker.grid, true);
    for (var i = 0; i < newGrid.length; i++) {
      for (var j = 0; j < newGrid[i].length; j++) {
        newGrid[i][j] = i >= 0 && i <= rowIndex && j >= 0 && j <= colIndex ? 1 : 0;
      }
    }
    setTablePicker({
      grid: newGrid,
      size: {
        colCount: colIndex + 1,
        rowCount: rowIndex + 1
      }
    });
  };
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "m-0 flex! flex-col p-0",
    onClick: function () {
      tf.insert.table(tablePicker.size, {
        select: true
      });
      editor.tf.focus();
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "grid size-[130px] grid-cols-8 gap-0.5 p-1"
  }, tablePicker.grid.map(function (rows, rowIndex) {
    return rows.map(function (value, columIndex) {
      return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        key: "(".concat(rowIndex, ",").concat(columIndex, ")"),
        className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('col-span-1 size-3 border border-solid bg-secondary', !!value && 'border-current'),
        onMouseMove: function () {
          onCellMove(rowIndex, columIndex);
        }
      });
    });
  })), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "text-center text-xs text-current"
  }, tablePicker.size.rowCount, " x ", tablePicker.size.colCount));
}

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/table-icons.tsx":
/*!**************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/table-icons.tsx ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BorderAll: () => (/* binding */ BorderAll),
/* harmony export */   BorderBottom: () => (/* binding */ BorderBottom),
/* harmony export */   BorderLeft: () => (/* binding */ BorderLeft),
/* harmony export */   BorderNone: () => (/* binding */ BorderNone),
/* harmony export */   BorderRight: () => (/* binding */ BorderRight),
/* harmony export */   BorderTop: () => (/* binding */ BorderTop)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';


var BorderAll = function (props) {
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __assign({
    fill: "none",
    height: "15",
    viewBox: "0 0 15 15",
    width: "15",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    clipRule: "evenodd",
    d: "M0.25 1C0.25 0.585786 0.585786 0.25 1 0.25H14C14.4142 0.25 14.75 0.585786 14.75 1V14C14.75 14.4142 14.4142 14.75 14 14.75H1C0.585786 14.75 0.25 14.4142 0.25 14V1ZM1.75 1.75V13.25H13.25V1.75H1.75Z",
    fill: "currentColor",
    fillRule: "evenodd"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "5"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "3"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "5",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "3",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "9",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "11",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "9"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "11"
  }));
};
var BorderBottom = function (props) {
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __assign({
    fill: "none",
    height: "15",
    viewBox: "0 0 15 15",
    width: "15",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    clipRule: "evenodd",
    d: "M1 13.25L14 13.25V14.75L1 14.75V13.25Z",
    fill: "currentColor",
    fillRule: "evenodd"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "5"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "13",
    y: "5"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "3"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "13",
    y: "3"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "13",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "13",
    y: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "5",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "5",
    y: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "3",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "3",
    y: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "9",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "9",
    y: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "11",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "11",
    y: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "9"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "13",
    y: "9"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "11"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "13",
    y: "11"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "1",
    y: "5"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "1",
    y: "3"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "1",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "1",
    y: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "1",
    y: "9"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "1",
    y: "11"
  }));
};
var BorderLeft = function (props) {
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __assign({
    fill: "none",
    height: "15",
    viewBox: "0 0 15 15",
    width: "15",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    clipRule: "evenodd",
    d: "M1.75 1L1.75 14L0.249999 14L0.25 1L1.75 1Z",
    fill: "currentColor",
    fillRule: "evenodd"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 10 7)",
    width: "1",
    x: "10",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 10 13)",
    width: "1",
    x: "10",
    y: "13"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 12 7)",
    width: "1",
    x: "12",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 12 13)",
    width: "1",
    x: "12",
    y: "13"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 8 7)",
    width: "1",
    x: "8",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 14 7)",
    width: "1",
    x: "14",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 8 13)",
    width: "1",
    x: "8",
    y: "13"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 14 13)",
    width: "1",
    x: "14",
    y: "13"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 8 5)",
    width: "1",
    x: "8",
    y: "5"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 14 5)",
    width: "1",
    x: "14",
    y: "5"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 8 3)",
    width: "1",
    x: "8",
    y: "3"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 14 3)",
    width: "1",
    x: "14",
    y: "3"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 8 9)",
    width: "1",
    x: "8",
    y: "9"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 14 9)",
    width: "1",
    x: "14",
    y: "9"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 8 11)",
    width: "1",
    x: "8",
    y: "11"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 14 11)",
    width: "1",
    x: "14",
    y: "11"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 6 7)",
    width: "1",
    x: "6",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 6 13)",
    width: "1",
    x: "6",
    y: "13"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 4 7)",
    width: "1",
    x: "4",
    y: "7"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 4 13)",
    width: "1",
    x: "4",
    y: "13"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 10 1)",
    width: "1",
    x: "10",
    y: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 12 1)",
    width: "1",
    x: "12",
    y: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 8 1)",
    width: "1",
    x: "8",
    y: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 14 1)",
    width: "1",
    x: "14",
    y: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 6 1)",
    width: "1",
    x: "6",
    y: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(90 4 1)",
    width: "1",
    x: "4",
    y: "1"
  }));
};
var BorderNone = function (props) {
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __assign({
    fill: "none",
    height: "15",
    viewBox: "0 0 15 15",
    width: "15",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "5.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "13",
    y: "5.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "3.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "13",
    y: "3.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "7.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "13.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "1.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "13",
    y: "7.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "13",
    y: "13.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "13",
    y: "1.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "5",
    y: "7.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "5",
    y: "13.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "5",
    y: "1.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "3",
    y: "7.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "3",
    y: "13.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "3",
    y: "1.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "9",
    y: "7.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "9",
    y: "13.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "9",
    y: "1.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "11",
    y: "7.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "11",
    y: "13.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "11",
    y: "1.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "9.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "13",
    y: "9.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "7",
    y: "11.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "13",
    y: "11.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "1",
    y: "5.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "1",
    y: "3.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "1",
    y: "7.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "1",
    y: "13.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "1",
    y: "1.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "1",
    y: "9.025"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    width: "1",
    x: "1",
    y: "11.025"
  }));
};
var BorderRight = function (props) {
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __assign({
    fill: "none",
    height: "15",
    viewBox: "0 0 15 15",
    width: "15",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    clipRule: "evenodd",
    d: "M13.25 1L13.25 14L14.75 14L14.75 1L13.25 1Z",
    fill: "currentColor",
    fillRule: "evenodd"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 5 7)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 5 13)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 3 7)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 3 13)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 7 7)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 1 7)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 7 13)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 1 13)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 7 5)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 1 5)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 7 3)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 1 3)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 7 9)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 1 9)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 7 11)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 1 11)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 9 7)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 9 13)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 11 7)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 11 13)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 5 1)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 3 1)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 7 1)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 1 1)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 9 1)",
    width: "1"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "matrix(0 1 1 0 11 1)",
    width: "1"
  }));
};
var BorderTop = function (props) {
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __assign({
    fill: "none",
    height: "15",
    viewBox: "0 0 15 15",
    width: "15",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    clipRule: "evenodd",
    d: "M14 1.75L1 1.75L1 0.249999L14 0.25L14 1.75Z",
    fill: "currentColor",
    fillRule: "evenodd"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 8 10)",
    width: "1",
    x: "8",
    y: "10"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 2 10)",
    width: "1",
    x: "2",
    y: "10"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 8 12)",
    width: "1",
    x: "8",
    y: "12"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 2 12)",
    width: "1",
    x: "2",
    y: "12"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 8 8)",
    width: "1",
    x: "8",
    y: "8"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 8 14)",
    width: "1",
    x: "8",
    y: "14"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 2 8)",
    width: "1",
    x: "2",
    y: "8"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 2 14)",
    width: "1",
    x: "2",
    y: "14"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 10 8)",
    width: "1",
    x: "10",
    y: "8"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 10 14)",
    width: "1",
    x: "10",
    y: "14"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 12 8)",
    width: "1",
    x: "12",
    y: "8"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 12 14)",
    width: "1",
    x: "12",
    y: "14"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 6 8)",
    width: "1",
    x: "6",
    y: "8"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 6 14)",
    width: "1",
    x: "6",
    y: "14"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 4 8)",
    width: "1",
    x: "4",
    y: "8"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 4 14)",
    width: "1",
    x: "4",
    y: "14"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 8 6)",
    width: "1",
    x: "8",
    y: "6"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 2 6)",
    width: "1",
    x: "2",
    y: "6"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 8 4)",
    width: "1",
    x: "8",
    y: "4"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 2 4)",
    width: "1",
    x: "2",
    y: "4"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 14 10)",
    width: "1",
    x: "14",
    y: "10"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 14 12)",
    width: "1",
    x: "14",
    y: "12"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 14 8)",
    width: "1",
    x: "14",
    y: "8"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 14 14)",
    width: "1",
    x: "14",
    y: "14"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 14 6)",
    width: "1",
    x: "14",
    y: "6"
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    fill: "currentColor",
    height: "1",
    rx: ".5",
    transform: "rotate(-180 14 4)",
    width: "1",
    x: "14",
    y: "4"
  }));
};

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx":
/*!**********************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Toolbar: () => (/* binding */ Toolbar),
/* harmony export */   ToolbarButton: () => (/* binding */ ToolbarButton),
/* harmony export */   ToolbarGroup: () => (/* binding */ ToolbarGroup),
/* harmony export */   ToolbarLink: () => (/* binding */ ToolbarLink),
/* harmony export */   ToolbarSeparator: () => (/* binding */ ToolbarSeparator),
/* harmony export */   ToolbarSplitButton: () => (/* binding */ ToolbarSplitButton),
/* harmony export */   ToolbarSplitButtonPrimary: () => (/* binding */ ToolbarSplitButtonPrimary),
/* harmony export */   ToolbarSplitButtonSecondary: () => (/* binding */ ToolbarSplitButtonSecondary),
/* harmony export */   ToolbarToggleGroup: () => (/* binding */ ToolbarToggleGroup),
/* harmony export */   ToolbarToggleItem: () => (/* binding */ ToolbarToggleItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _radix_ui_react_toolbar__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @radix-ui/react-toolbar */ "./node_modules/@radix-ui/react-toolbar/dist/index.mjs");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! class-variance-authority */ "class-variance-authority");
/* harmony import */ var class_variance_authority__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(class_variance_authority__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/chevron-down.js");
/* harmony import */ var _separator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./separator */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/separator.tsx");
/* harmony import */ var _tooltip__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./tooltip */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/tooltip.tsx");
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';









var Toolbar = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withCn)(_radix_ui_react_toolbar__WEBPACK_IMPORTED_MODULE_6__.Root, 'relative flex items-center select-none');
// const a = cn('flex items-center');
var ToolbarToggleGroup = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withCn)(_radix_ui_react_toolbar__WEBPACK_IMPORTED_MODULE_6__.ToolbarToggleGroup, 'flex items-center');
var ToolbarLink = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withCn)(_radix_ui_react_toolbar__WEBPACK_IMPORTED_MODULE_6__.Link, 'font-medium underline underline-offset-4');
var ToolbarSeparator = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withCn)(_radix_ui_react_toolbar__WEBPACK_IMPORTED_MODULE_6__.Separator, 'mx-2 my-1 w-px shrink-0 bg-border');
var toolbarButtonVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_3__.cva)((0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('inline-flex cursor-pointer items-center justify-center gap-2 rounded-md text-sm font-medium whitespace-nowrap text-foreground transition-colors disabled:pointer-events-none disabled:opacity-50 [&_svg:not([data-icon])]:size-4'), {
  defaultVariants: {
    size: 'sm',
    variant: 'default'
  },
  variants: {
    size: {
      default: 'h-10 px-3',
      lg: 'h-11 px-5',
      sm: 'h-7 px-2'
    },
    variant: {
      default: 'bg-transparent hover:bg-muted hover:text-muted-foreground aria-checked:bg-accent aria-checked:text-accent-foreground',
      outline: 'border border-input bg-transparent hover:bg-accent hover:text-accent-foreground'
    }
  }
});
var dropdownArrowVariants = (0,class_variance_authority__WEBPACK_IMPORTED_MODULE_3__.cva)((0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('inline-flex items-center justify-center rounded-r-md text-sm font-medium text-foreground transition-colors disabled:pointer-events-none disabled:opacity-50'), {
  defaultVariants: {
    size: 'sm',
    variant: 'default'
  },
  variants: {
    size: {
      default: 'h-10 w-6',
      lg: 'h-11 w-8',
      sm: 'h-7 w-4'
    },
    variant: {
      default: 'bg-transparent hover:bg-muted hover:text-muted-foreground aria-checked:bg-accent aria-checked:text-accent-foreground',
      outline: 'border border-l-0 border-input bg-transparent hover:bg-accent hover:text-accent-foreground'
    }
  }
});
var ToolbarButton = (0,_tooltip__WEBPACK_IMPORTED_MODULE_5__.withTooltip)(react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    isDropdown = _a.isDropdown,
    pressed = _a.pressed,
    size = _a.size,
    variant = _a.variant,
    props = __rest(_a, ["children", "className", "isDropdown", "pressed", "size", "variant"]);
  var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useEditorRef)();
  return typeof pressed === 'boolean' ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(ToolbarToggleGroup, {
    "data-plate-focus-id": editor.id,
    disabled: props.disabled,
    value: "single",
    type: "single"
  }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(ToolbarToggleItem, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(toolbarButtonVariants({
      size: size,
      variant: variant
    }), isDropdown && 'justify-between gap-1 pr-1', className),
    value: pressed ? 'single' : ''
  }, props), isDropdown ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "flex flex-1 items-center gap-2 whitespace-nowrap"
  }, children), react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, react__WEBPACK_IMPORTED_MODULE_0__.createElement(lucide_react__WEBPACK_IMPORTED_MODULE_7__["default"], {
    className: "size-3.5 text-muted-foreground",
    "data-icon": true
  }))) : children)) : react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_toolbar__WEBPACK_IMPORTED_MODULE_6__.Button, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(toolbarButtonVariants({
      size: size,
      variant: variant
    }), isDropdown && 'pr-1', className),
    "data-plate-focus-id": editor.id
  }, props), children);
}));

var ToolbarSplitButton = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    props = __rest(_a, ["children", "className"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(ToolbarButton, __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('group flex gap-0 px-0 hover:bg-transparent', className)
  }, props), children);
});
var ToolbarSplitButtonPrimary = (0,_tooltip__WEBPACK_IMPORTED_MODULE_5__.withTooltip)(react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (_a, ref) {
  var children = _a.children,
    className = _a.className,
    size = _a.size,
    variant = _a.variant,
    props = __rest(_a, ["children", "className", "size", "variant"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(toolbarButtonVariants({
      size: size,
      variant: variant
    }), 'rounded-r-none', 'group-data-[pressed=true]:bg-accent group-data-[pressed=true]:text-accent-foreground', className)
  }, props), children);
}));
var ToolbarSplitButtonSecondary = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (_a, ref) {
  var className = _a.className,
    size = _a.size,
    variant = _a.variant,
    props = __rest(_a, ["className", "size", "variant"]);
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", __assign({
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)(dropdownArrowVariants({
      size: size,
      variant: variant
    }), 'group-data-[pressed=true]:bg-accent group-data-[pressed=true]:text-accent-foreground', className),
    onClick: function (e) {
      return e.stopPropagation();
    },
    role: "button"
  }, props), react__WEBPACK_IMPORTED_MODULE_0__.createElement(lucide_react__WEBPACK_IMPORTED_MODULE_7__["default"], {
    className: "size-3.5 text-muted-foreground",
    "data-icon": true
  }));
});
ToolbarSplitButton.displayName = 'ToolbarButton';
var ToolbarToggleItem = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withVariants)(_radix_ui_react_toolbar__WEBPACK_IMPORTED_MODULE_6__.ToggleItem, toolbarButtonVariants, ['variant', 'size']);
var ToolbarGroup = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withRef)(function (_a, ref) {
  var children = _a.children,
    className = _a.className;
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    ref: ref,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)('group/toolbar-group', 'relative hidden has-[button]:flex', className)
  }, react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "flex items-center"
  }, children), react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "mx-1.5 py-0.5 group-last/toolbar-group:hidden!"
  }, react__WEBPACK_IMPORTED_MODULE_0__.createElement(_separator__WEBPACK_IMPORTED_MODULE_4__.Separator, {
    orientation: "vertical"
  })));
});

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/tooltip.tsx":
/*!**********************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/tooltip.tsx ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Tooltip: () => (/* binding */ Tooltip),
/* harmony export */   TooltipButton: () => (/* binding */ TooltipButton),
/* harmony export */   TooltipContent: () => (/* binding */ TooltipContent),
/* harmony export */   TooltipPortal: () => (/* binding */ TooltipPortal),
/* harmony export */   TooltipProvider: () => (/* binding */ TooltipProvider),
/* harmony export */   TooltipTrigger: () => (/* binding */ TooltipTrigger),
/* harmony export */   withTooltip: () => (/* binding */ withTooltip)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _radix_ui_react_tooltip__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @radix-ui/react-tooltip */ "./node_modules/@radix-ui/react-tooltip/dist/index.mjs");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/cn */ "@udecode/cn");
/* harmony import */ var _udecode_cn__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_cn__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./button */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/button.tsx");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__);
/* provided dependency */ var __rest = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__rest"];
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';






var TooltipProvider = (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.withProps)(_radix_ui_react_tooltip__WEBPACK_IMPORTED_MODULE_4__.Provider, {
  delayDuration: 0,
  disableHoverableContent: true,
  skipDelayDuration: 0
});
var Tooltip = _radix_ui_react_tooltip__WEBPACK_IMPORTED_MODULE_4__.Root;
var TooltipTrigger = _radix_ui_react_tooltip__WEBPACK_IMPORTED_MODULE_4__.Trigger;
var TooltipPortal = _radix_ui_react_tooltip__WEBPACK_IMPORTED_MODULE_4__.Portal;
var TooltipContent = react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef(function (_a, ref) {
  var className = _a.className,
    _b = _a.sideOffset,
    sideOffset = _b === void 0 ? 4 : _b,
    props = __rest(_a, ["className", "sideOffset"]);
  var zclass = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_3__.useEditorRef)().zclass;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_radix_ui_react_tooltip__WEBPACK_IMPORTED_MODULE_4__.Content, __assign({
    ref: ref,
    sideOffset: sideOffset,
    className: (0,_udecode_cn__WEBPACK_IMPORTED_MODULE_1__.cn)("".concat(zclass, "-toolbar-pp overflow-hidden rounded-md bg-black px-3 py-1.5 text-sm font-semibold text-white shadow-md"), className)
  }, props));
});
function withTooltip(Component) {
  return function ExtendComponent(_a) {
    var _b = _a.delayDuration,
      delayDuration = _b === void 0 ? 0 : _b,
      _c = _a.disableHoverableContent,
      disableHoverableContent = _c === void 0 ? true : _c,
      _d = _a.skipDelayDuration,
      skipDelayDuration = _d === void 0 ? 0 : _d,
      tooltip = _a.tooltip,
      tooltipContentProps = _a.tooltipContentProps,
      tooltipProps = _a.tooltipProps,
      tooltipTriggerProps = _a.tooltipTriggerProps,
      props = __rest(_a, ["delayDuration", "disableHoverableContent", "skipDelayDuration", "tooltip", "tooltipContentProps", "tooltipProps", "tooltipTriggerProps"]);
    var _e = react__WEBPACK_IMPORTED_MODULE_0___default().useState(false),
      mounted = _e[0],
      setMounted = _e[1];
    react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(function () {
      setMounted(true);
    }, []);
    var component = react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Component, __assign({}, props));
    if (tooltip && mounted) {
      return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(TooltipProvider, {
        delayDuration: delayDuration,
        disableHoverableContent: disableHoverableContent,
        skipDelayDuration: skipDelayDuration
      }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Tooltip, __assign({}, tooltipProps), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(TooltipTrigger, __assign({
        asChild: true
      }, tooltipTriggerProps), component), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(TooltipPortal, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(TooltipContent, __assign({}, tooltipContentProps), tooltip))));
    }
    return component;
  };
}
var TooltipButton = withTooltip(_button__WEBPACK_IMPORTED_MODULE_2__.Button);

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/transforms.ts":
/*!************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/transforms.ts ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STRUCTURAL_TYPES: () => (/* binding */ STRUCTURAL_TYPES),
/* harmony export */   getBlockType: () => (/* binding */ getBlockType),
/* harmony export */   setBlockType: () => (/* binding */ setBlockType)
/* harmony export */ });
/* harmony import */ var _udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @udecode/plate-list/react */ "./node_modules/@udecode/plate-list/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_indent_list__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @udecode/plate-indent-list */ "@udecode/plate-indent-list");
/* harmony import */ var _udecode_plate_indent_list__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_indent_list__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate_indent_list_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @udecode/plate-indent-list/react */ "./node_modules/@udecode/plate-indent-list/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_layout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate-layout */ "@udecode/plate-layout");
/* harmony import */ var _udecode_plate_layout__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_layout__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_layout_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate-layout/react */ "./node_modules/@udecode/plate-layout/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @udecode/plate-table/react */ "./node_modules/@udecode/plate-table/dist/react/index.mjs");
'use client';

var _a;

// import { insertCallout } from '@udecode/plate-callout';
// import { CalloutPlugin } from '@udecode/plate-callout/react';
// import { insertCodeBlock } from '@udecode/plate-code-block';
// import { CodeBlockPlugin } from '@udecode/plate-code-block/react';
// import { insertDate } from '@udecode/plate-date';
// import { DatePlugin } from '@udecode/plate-date/react';
// import { insertToc } from '@udecode/plate-heading';
// import { TocPlugin } from '@udecode/plate-heading/react';




// import { LinkPlugin, triggerFloatingLink } from '@udecode/plate-link/react';
// import { insertEquation, insertInlineEquation } from '@udecode/plate-math';
// import {
//   EquationPlugin,
//   InlineEquationPlugin,
// } from '@udecode/plate-math/react';
// import {
//   insertAudioPlaceholder,
//   insertFilePlaceholder,
//   insertMedia,
//   insertVideoPlaceholder,
// } from '@udecode/plate-media';
// import {
//   AudioPlugin,
//   FilePlugin,
//   ImagePlugin,
//   MediaEmbedPlugin,
//   VideoPlugin,
// } from '@udecode/plate-media/react';

var STRUCTURAL_TYPES = [_udecode_plate_layout_react__WEBPACK_IMPORTED_MODULE_2__.ColumnPlugin.key, _udecode_plate_layout_react__WEBPACK_IMPORTED_MODULE_2__.ColumnItemPlugin.key, /* Potix: ListPlugin for PE */
_udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_3__.BulletedListPlugin.key, _udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_3__.NumberedListPlugin.key, _udecode_plate_list_react__WEBPACK_IMPORTED_MODULE_3__.ListItemPlugin.key, _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_4__.TablePlugin.key, _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_4__.TableRowPlugin.key, _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_4__.TableCellHeaderPlugin.key, _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_4__.TableCellPlugin.key];
var ACTION_THREE_COLUMNS = 'action_three_columns';
// const insertList = (editor: PlateEditor, type: string) => {
//   editor.tf.insertNodes(
//     editor.api.create.block({
//       indent: 1,
//       listStyleType: type,
//     }),
//     { select: true }
//   );
// };
// const insertBlockMap: Record<
//   string,
//   (editor: PlateEditor, type: string) => void
// > = {
//   [INDENT_LIST_KEYS.todo]: insertList,
//   [ListStyleType.Decimal]: insertList,
//   [ListStyleType.Disc]: insertList,
//   [ACTION_THREE_COLUMNS]: (editor) =>
//     insertColumnGroup(editor, { columns: 3, select: true }),
//   [AudioPlugin.key]: (editor) =>
//     insertAudioPlaceholder(editor, { select: true }),
//   [CalloutPlugin.key]: (editor) => insertCallout(editor, { select: true }),
//   [CodeBlockPlugin.key]: (editor) => insertCodeBlock(editor, { select: true }),
//   [EquationPlugin.key]: (editor) => insertEquation(editor, { select: true }),
//   [FilePlugin.key]: (editor) => insertFilePlaceholder(editor, { select: true }),
//   [ImagePlugin.key]: (editor) =>
//     insertMedia(editor, {
//       select: true,
//       type: ImagePlugin.key,
//     }),
//   [MediaEmbedPlugin.key]: (editor) =>
//     insertMedia(editor, {
//       select: true,
//       type: MediaEmbedPlugin.key,
//     }),
//   [TablePlugin.key]: (editor) =>
//     editor.getTransforms(TablePlugin).insert.table({}, { select: true }),
//   [TocPlugin.key]: (editor) => insertToc(editor, { select: true }),
//   [VideoPlugin.key]: (editor) =>
//     insertVideoPlaceholder(editor, { select: true }),
// };
// const insertInlineMap: Record<
//   string,
//   (editor: PlateEditor, type: string) => void
// > = {
//   [DatePlugin.key]: (editor) => insertDate(editor, { select: true }),
//   [InlineEquationPlugin.key]: (editor) =>
//     insertInlineEquation(editor, '', { select: true }),
//   [LinkPlugin.key]: (editor) => triggerFloatingLink(editor, { focused: true }),
// };
// export const insertBlock = (editor: PlateEditor, type: string) => {
//   editor.tf.withoutNormalizing(() => {
//     const block = editor.api.block();
//
//     if (!block) return;
//     if (type in insertBlockMap) {
//       insertBlockMap[type](editor, type);
//     } else {
//       editor.tf.insertNodes(editor.api.create.block({ type }), {
//         at: PathApi.next(block[1]),
//         select: true,
//       });
//     }
//     if (getBlockType(block[0]) !== type) {
//       editor.tf.removeNodes({ previousEmptyBlock: true });
//     }
//   });
// };
// export const insertInlineElement = (editor: PlateEditor, type: string) => {
//   if (insertInlineMap[type]) {
//     insertInlineMap[type](editor, type);
//   }
// };
var setList = function (editor, type, entry) {
  editor.tf.setNodes(editor.api.create.block({
    indent: 1,
    listStyleType: type
  }), {
    at: entry[1]
  });
};
var setBlockMap = (_a = {}, _a[_udecode_plate_indent_list__WEBPACK_IMPORTED_MODULE_0__.INDENT_LIST_KEYS.todo] = setList, _a[_udecode_plate_indent_list__WEBPACK_IMPORTED_MODULE_0__.ListStyleType.Decimal] = setList, _a[_udecode_plate_indent_list__WEBPACK_IMPORTED_MODULE_0__.ListStyleType.Disc] = setList, _a[ACTION_THREE_COLUMNS] = function (editor) {
  return (0,_udecode_plate_layout__WEBPACK_IMPORTED_MODULE_1__.toggleColumnGroup)(editor, {
    columns: 3
  });
}, _a);
var setBlockType = function (editor, type, _a) {
  var _b = _a === void 0 ? {} : _a,
    at = _b.at;
  editor.tf.withoutNormalizing(function () {
    var setEntry = function (entry) {
      var node = entry[0],
        path = entry[1];
      if (node[_udecode_plate_indent_list_react__WEBPACK_IMPORTED_MODULE_5__.IndentListPlugin.key]) {
        editor.tf.unsetNodes([_udecode_plate_indent_list_react__WEBPACK_IMPORTED_MODULE_5__.IndentListPlugin.key, 'indent'], {
          at: path
        });
      }
      if (type in setBlockMap) {
        return setBlockMap[type](editor, type, entry);
      }
      if (node.type !== type) {
        editor.tf.setNodes({
          type: type
        }, {
          at: path
        });
      }
    };
    /* Potix: Fix toolbar action after grid cell selection */
    var entries = editor.api.blocks({
      at: at,
      mode: 'lowest'
    });
    entries.forEach(function (entry) {
      return setEntry(entry);
    });
  });
};
var getBlockType = function (block) {
  if (block[_udecode_plate_indent_list_react__WEBPACK_IMPORTED_MODULE_5__.IndentListPlugin.key]) {
    if (block[_udecode_plate_indent_list_react__WEBPACK_IMPORTED_MODULE_5__.IndentListPlugin.key] === _udecode_plate_indent_list__WEBPACK_IMPORTED_MODULE_0__.ListStyleType.Decimal) {
      return _udecode_plate_indent_list__WEBPACK_IMPORTED_MODULE_0__.ListStyleType.Decimal;
    } else if (block[_udecode_plate_indent_list_react__WEBPACK_IMPORTED_MODULE_5__.IndentListPlugin.key] === _udecode_plate_indent_list__WEBPACK_IMPORTED_MODULE_0__.INDENT_LIST_KEYS.todo) {
      return _udecode_plate_indent_list__WEBPACK_IMPORTED_MODULE_0__.INDENT_LIST_KEYS.todo;
    } else {
      return _udecode_plate_indent_list__WEBPACK_IMPORTED_MODULE_0__.ListStyleType.Disc;
    }
  }
  return block.type;
};

/***/ }),

/***/ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/turn-into-dropdown-menu.tsx":
/*!**************************************************************************************************!*\
  !*** ./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/turn-into-dropdown-menu.tsx ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TurnIntoDropdownMenu: () => (/* binding */ TurnIntoDropdownMenu)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _udecode_plate_block_quote_react__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @udecode/plate-block-quote/react */ "./node_modules/@udecode/plate-block-quote/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @udecode/plate-heading */ "@udecode/plate-heading");
/* harmony import */ var _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_heading__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @udecode/plate-table/react */ "./node_modules/@udecode/plate-table/dist/react/index.mjs");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @udecode/plate/react */ "@udecode/plate/react");
/* harmony import */ var _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/pilcrow.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/heading-1.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/heading-2.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/heading-3.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/heading-4.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/heading-5.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/heading-6.js");
/* harmony import */ var lucide_react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! lucide-react */ "./node_modules/lucide-react/dist/esm/icons/quote.js");
/* harmony import */ var _transforms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./transforms */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/transforms.ts");
/* harmony import */ var _dropdown_menu__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./dropdown-menu */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/dropdown-menu.tsx");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./toolbar */ "./keikai-doc/src/main/resources/web/js/kkdoc/ext/plate/toolbar/toolbar.tsx");
/* provided dependency */ var __assign = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__assign"];
'use client';



// import { CodeBlockPlugin } from '@udecode/plate-code-block/react';


// import {
//   // INDENT_LIST_KEYS,
//   ListStyleType
// } from '@udecode/plate-indent-list';
// import { TogglePlugin } from '@udecode/plate-toggle/react';





var turnIntoItems = [{
  icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_6__["default"], null),
  keywords: ['paragraph'],
  label: 'Text',
  value: _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.ParagraphPlugin.key
}, {
  icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_7__["default"], null),
  keywords: ['title', 'h1'],
  label: 'Heading 1',
  value: _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_1__.HEADING_KEYS.h1
}, {
  icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_8__["default"], null),
  keywords: ['subtitle', 'h2'],
  label: 'Heading 2',
  value: _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_1__.HEADING_KEYS.h2
}, {
  icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_9__["default"], null),
  keywords: ['subtitle', 'h3'],
  label: 'Heading 3',
  value: _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_1__.HEADING_KEYS.h3
}, {
  icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_10__["default"], null),
  keywords: ['subtitle', 'h4'],
  label: 'Heading 4',
  value: _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_1__.HEADING_KEYS.h4
}, {
  icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_11__["default"], null),
  keywords: ['subtitle', 'h5'],
  label: 'Heading 5',
  value: _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_1__.HEADING_KEYS.h5
}, {
  icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_12__["default"], null),
  keywords: ['subtitle', 'h6'],
  label: 'Heading 6',
  value: _udecode_plate_heading__WEBPACK_IMPORTED_MODULE_1__.HEADING_KEYS.h6
}, /* Potix: Treat list and li as structural types */
// {
//   icon: <ListIcon />,
//   keywords: ['unordered', 'ul', '-'],
//   label: 'Bulleted list',
//   value: ListStyleType.Disc,
// },
// {
//   icon: <ListOrderedIcon />,
//   keywords: ['ordered', 'ol', '1'],
//   label: 'Numbered list',
//   value: ListStyleType.Decimal,
// },
// {
//   icon: <SquareIcon />,
//   keywords: ['checklist', 'task', 'checkbox', '[]'],
//   label: 'To-do list',
//   value: INDENT_LIST_KEYS.todo,
// },
// {
//   icon: <ChevronRightIcon />,
//   keywords: ['collapsible', 'expandable'],
//   label: 'Toggle list',
//   value: TogglePlugin.key,
// },
// {
//   icon: <FileCodeIcon />,
//   keywords: ['```'],
//   label: 'Code',
//   value: CodeBlockPlugin.key,
// },
{
  icon: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(lucide_react__WEBPACK_IMPORTED_MODULE_13__["default"], null),
  keywords: ['citation', 'blockquote', '>'],
  label: 'Quote',
  value: _udecode_plate_block_quote_react__WEBPACK_IMPORTED_MODULE_14__.BlockquotePlugin.key
}
// {
//   icon: <Columns3Icon />,
//   label: '3 columns',
//   value: 'action_three_columns',
// },
];
function TurnIntoDropdownMenu(props) {
  var editor = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useEditorRef)();
  var openState = (0,_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.useOpenState)();
  /* Potix: Fix toolbar value after grid cell selection */
  var selectedCells = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.usePluginOption)(_udecode_plate_table_react__WEBPACK_IMPORTED_MODULE_15__.TablePlugin, 'selectedCells');
  var value = (0,_udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.useEditorSelector)(function (editor) {
    var fragment = selectedCells && selectedCells.length > 0 ? selectedCells.flatMap(function (cell) {
      return editor.api.fragment(cell, {
        structuralTypes: _transforms__WEBPACK_IMPORTED_MODULE_3__.STRUCTURAL_TYPES
      });
    }) : editor.api.fragment(editor.selection, {
      structuralTypes: _transforms__WEBPACK_IMPORTED_MODULE_3__.STRUCTURAL_TYPES
    });
    return editor.api.prop({
      defaultValue: _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.ParagraphPlugin.key,
      getProp: function (node) {
        return (0,_transforms__WEBPACK_IMPORTED_MODULE_3__.getBlockType)(node);
      },
      nodes: fragment
    });
  }, [selectedCells]);
  var selectedItem = react__WEBPACK_IMPORTED_MODULE_0___default().useMemo(function () {
    var _a;
    return (_a = turnIntoItems.find(function (item) {
      return item.value === (value !== null && value !== void 0 ? value : _udecode_plate_react__WEBPACK_IMPORTED_MODULE_2__.ParagraphPlugin.key);
    })) !== null && _a !== void 0 ? _a : turnIntoItems[0];
  }, [value]);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.DropdownMenu, __assign({
    modal: false
  }, openState, props), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.DropdownMenuTrigger, {
    asChild: true
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_toolbar__WEBPACK_IMPORTED_MODULE_5__.ToolbarButton, {
    className: "min-w-[125px]",
    pressed: openState.open,
    tooltip: "Turn into",
    isDropdown: true
  }, selectedItem.label)), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.DropdownMenuContent, {
    className: "ignore-click-outside/toolbar min-w-0",
    onCloseAutoFocus: function (e) {
      e.preventDefault();
      editor.tf.focus();
    },
    align: "start"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.DropdownMenuRadioGroup, {
    value: value,
    onValueChange: function (type) {
      /* Potix: Fix toolbar action after grid cell selection */
      if (selectedCells && selectedCells.length > 0) {
        selectedCells.forEach(function (cell) {
          var cellPath = editor.api.findPath(cell);
          if (cellPath) (0,_transforms__WEBPACK_IMPORTED_MODULE_3__.setBlockType)(editor, type, {
            at: cellPath
          });
        });
      } else (0,_transforms__WEBPACK_IMPORTED_MODULE_3__.setBlockType)(editor, type);
    },
    label: "Turn into"
  }, turnIntoItems.map(function (_a) {
    var icon = _a.icon,
      label = _a.label,
      itemValue = _a.value;
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_dropdown_menu__WEBPACK_IMPORTED_MODULE_4__.DropdownMenuRadioItem, {
      key: itemValue,
      className: "min-w-[180px]",
      value: itemValue
    }, icon, label);
  }))));
}

/***/ }),

/***/ "./node_modules/fast-deep-equal/index.js":
/*!***********************************************!*\
  !*** ./node_modules/fast-deep-equal/index.js ***!
  \***********************************************/
/***/ ((module) => {

"use strict";


// do not edit .js files directly - edit src/index.jst



module.exports = function equal(a, b) {
  if (a === b) return true;

  if (a && b && typeof a == 'object' && typeof b == 'object') {
    if (a.constructor !== b.constructor) return false;

    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (!equal(a[i], b[i])) return false;
      return true;
    }



    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();

    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;

    for (i = length; i-- !== 0;)
      if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;

    for (i = length; i-- !== 0;) {
      var key = keys[i];

      if (!equal(a[key], b[key])) return false;
    }

    return true;
  }

  // true if both NaN, false otherwise
  return a!==a && b!==b;
};


/***/ }),

/***/ "./node_modules/get-nonce/dist/es2015/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/get-nonce/dist/es2015/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getNonce: () => (/* binding */ getNonce),
/* harmony export */   setNonce: () => (/* binding */ setNonce)
/* harmony export */ });
var currentNonce;
var setNonce = function (nonce) {
    currentNonce = nonce;
};
var getNonce = function () {
    if (currentNonce) {
        return currentNonce;
    }
    if (true) {
        return __webpack_require__.nc;
    }
    return undefined;
};


/***/ }),

/***/ "./node_modules/is-hotkey/lib/index.js":
/*!*********************************************!*\
  !*** ./node_modules/is-hotkey/lib/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));

/**
 * Constants.
 */

var IS_MAC = typeof window != 'undefined' && /Mac|iPod|iPhone|iPad/.test(window.navigator.platform);

var MODIFIERS = {
  alt: 'altKey',
  control: 'ctrlKey',
  meta: 'metaKey',
  shift: 'shiftKey'
};

var ALIASES = {
  add: '+',
  break: 'pause',
  cmd: 'meta',
  command: 'meta',
  ctl: 'control',
  ctrl: 'control',
  del: 'delete',
  down: 'arrowdown',
  esc: 'escape',
  ins: 'insert',
  left: 'arrowleft',
  mod: IS_MAC ? 'meta' : 'control',
  opt: 'alt',
  option: 'alt',
  return: 'enter',
  right: 'arrowright',
  space: ' ',
  spacebar: ' ',
  up: 'arrowup',
  win: 'meta',
  windows: 'meta'
};

var CODES = {
  backspace: 8,
  tab: 9,
  enter: 13,
  shift: 16,
  control: 17,
  alt: 18,
  pause: 19,
  capslock: 20,
  escape: 27,
  ' ': 32,
  pageup: 33,
  pagedown: 34,
  end: 35,
  home: 36,
  arrowleft: 37,
  arrowup: 38,
  arrowright: 39,
  arrowdown: 40,
  insert: 45,
  delete: 46,
  meta: 91,
  numlock: 144,
  scrolllock: 145,
  ';': 186,
  '=': 187,
  ',': 188,
  '-': 189,
  '.': 190,
  '/': 191,
  '`': 192,
  '[': 219,
  '\\': 220,
  ']': 221,
  '\'': 222
};

for (var f = 1; f < 20; f++) {
  CODES['f' + f] = 111 + f;
}

/**
 * Is hotkey?
 */

function isHotkey(hotkey, options, event) {
  if (options && !('byKey' in options)) {
    event = options;
    options = null;
  }

  if (!Array.isArray(hotkey)) {
    hotkey = [hotkey];
  }

  var array = hotkey.map(function (string) {
    return parseHotkey(string, options);
  });
  var check = function check(e) {
    return array.some(function (object) {
      return compareHotkey(object, e);
    });
  };
  var ret = event == null ? check : check(event);
  return ret;
}

function isCodeHotkey(hotkey, event) {
  return isHotkey(hotkey, event);
}

function isKeyHotkey(hotkey, event) {
  return isHotkey(hotkey, { byKey: true }, event);
}

/**
 * Parse.
 */

function parseHotkey(hotkey, options) {
  var byKey = options && options.byKey;
  var ret = {};

  // Special case to handle the `+` key since we use it as a separator.
  hotkey = hotkey.replace('++', '+add');
  var values = hotkey.split('+');
  var length = values.length;

  // Ensure that all the modifiers are set to false unless the hotkey has them.

  for (var k in MODIFIERS) {
    ret[MODIFIERS[k]] = false;
  }

  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = values[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var value = _step.value;

      var optional = value.endsWith('?') && value.length > 1;

      if (optional) {
        value = value.slice(0, -1);
      }

      var name = toKeyName(value);
      var modifier = MODIFIERS[name];

      if (value.length > 1 && !modifier && !ALIASES[value] && !CODES[name]) {
        throw new TypeError('Unknown modifier: "' + value + '"');
      }

      if (length === 1 || !modifier) {
        if (byKey) {
          ret.key = name;
        } else {
          ret.which = toKeyCode(value);
        }
      }

      if (modifier) {
        ret[modifier] = optional ? null : true;
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return ret;
}

/**
 * Compare.
 */

function compareHotkey(object, event) {
  for (var key in object) {
    var expected = object[key];
    var actual = void 0;

    if (expected == null) {
      continue;
    }

    if (key === 'key' && event.key != null) {
      actual = event.key.toLowerCase();
    } else if (key === 'which') {
      actual = expected === 91 && event.which === 93 ? 91 : event.which;
    } else {
      actual = event[key];
    }

    if (actual == null && expected === false) {
      continue;
    }

    if (actual !== expected) {
      return false;
    }
  }

  return true;
}

/**
 * Utils.
 */

function toKeyCode(name) {
  name = toKeyName(name);
  var code = CODES[name] || name.toUpperCase().charCodeAt(0);
  return code;
}

function toKeyName(name) {
  name = name.toLowerCase();
  name = ALIASES[name] || name;
  return name;
}

/**
 * Export.
 */

exports["default"] = isHotkey;
exports.isHotkey = isHotkey;
exports.isCodeHotkey = isCodeHotkey;
exports.isKeyHotkey = isKeyHotkey;
exports.parseHotkey = parseHotkey;
exports.compareHotkey = compareHotkey;
exports.toKeyCode = toKeyCode;
exports.toKeyName = toKeyName;

/***/ }),

/***/ "./node_modules/js-video-url-parser/dist/jsVideoUrlParser.js":
/*!*******************************************************************!*\
  !*** ./node_modules/js-video-url-parser/dist/jsVideoUrlParser.js ***!
  \*******************************************************************/
/***/ (function(module) {

(function (global, factory) {
   true ? module.exports = factory() :
  0;
}(this, (function () { 'use strict';

  function _typeof(obj) {
    "@babel/helpers - typeof";

    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function (obj) {
        return typeof obj;
      };
    } else {
      _typeof = function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof(obj);
  }

  var getQueryParams = function getQueryParams(qs) {
    if (typeof qs !== 'string') {
      return {};
    }

    qs = qs.split('+').join(' ');
    var params = {};
    var match = qs.match(/(?:[?](?:[^=]+)=(?:[^&#]*)(?:[&](?:[^=]+)=(?:[^&#]*))*(?:[#].*)?)|(?:[#].*)/);
    var split;

    if (match === null) {
      return {};
    }

    split = match[0].substr(1).split(/[&#=]/);

    for (var i = 0; i < split.length; i += 2) {
      params[decodeURIComponent(split[i])] = decodeURIComponent(split[i + 1] || '');
    }

    return params;
  };

  var combineParams = function combineParams(params, hasParams) {
    if (_typeof(params) !== 'object') {
      return '';
    }

    var combined = '';
    var i = 0;
    var keys = Object.keys(params);

    if (keys.length === 0) {
      return '';
    } //always have parameters in the same order


    keys.sort();

    if (!hasParams) {
      combined += '?' + keys[0] + '=' + params[keys[0]];
      i += 1;
    }

    for (; i < keys.length; i += 1) {
      combined += '&' + keys[i] + '=' + params[keys[i]];
    }

    return combined;
  }; //parses strings like 1h30m20s to seconds


  function getLetterTime(timeString) {
    var totalSeconds = 0;
    var timeValues = {
      's': 1,
      'm': 1 * 60,
      'h': 1 * 60 * 60,
      'd': 1 * 60 * 60 * 24,
      'w': 1 * 60 * 60 * 24 * 7
    };
    var timePairs; //expand to "1 h 30 m 20 s" and split

    timeString = timeString.replace(/([smhdw])/g, ' $1 ').trim();
    timePairs = timeString.split(' ');

    for (var i = 0; i < timePairs.length; i += 2) {
      totalSeconds += parseInt(timePairs[i], 10) * timeValues[timePairs[i + 1] || 's'];
    }

    return totalSeconds;
  } //parses strings like 1:30:20 to seconds


  function getColonTime(timeString) {
    var totalSeconds = 0;
    var timeValues = [1, 1 * 60, 1 * 60 * 60, 1 * 60 * 60 * 24, 1 * 60 * 60 * 24 * 7];
    var timePairs = timeString.split(':');

    for (var i = 0; i < timePairs.length; i++) {
      totalSeconds += parseInt(timePairs[i], 10) * timeValues[timePairs.length - i - 1];
    }

    return totalSeconds;
  }

  var getTime = function getTime(timeString) {
    if (typeof timeString === 'undefined') {
      return 0;
    }

    if (timeString.match(/^(\d+[smhdw]?)+$/)) {
      return getLetterTime(timeString);
    }

    if (timeString.match(/^(\d+:?)+$/)) {
      return getColonTime(timeString);
    }

    return 0;
  };

  var util = {
    getQueryParams: getQueryParams,
    combineParams: combineParams,
    getTime: getTime
  };

  var getQueryParams$1 = util.getQueryParams;

  function UrlParser() {
    for (var _i = 0, _arr = ['parseProvider', 'parse', 'bind', 'create']; _i < _arr.length; _i++) {
      var key = _arr[_i];
      this[key] = this[key].bind(this);
    }

    this.plugins = {};
  }

  var urlParser = UrlParser;

  UrlParser.prototype.parseProvider = function (url) {
    var match = url.match(/(?:(?:https?:)?\/\/)?(?:[^.]+\.)?(\w+)\./i);
    return match ? match[1] : undefined;
  };

  UrlParser.prototype.parse = function (url) {
    if (typeof url === 'undefined') {
      return undefined;
    }

    var provider = this.parseProvider(url);
    var result;
    var plugin = this.plugins[provider];

    if (!provider || !plugin || !plugin.parse) {
      return undefined;
    }

    result = plugin.parse.call(plugin, url, getQueryParams$1(url));

    if (result) {
      result = removeEmptyParameters(result);
      result.provider = plugin.provider;
    }

    return result;
  };

  UrlParser.prototype.bind = function (plugin) {
    this.plugins[plugin.provider] = plugin;

    if (plugin.alternatives) {
      for (var i = 0; i < plugin.alternatives.length; i += 1) {
        this.plugins[plugin.alternatives[i]] = plugin;
      }
    }
  };

  UrlParser.prototype.create = function (op) {
    if (_typeof(op) !== 'object' || _typeof(op.videoInfo) !== 'object') {
      return undefined;
    }

    var vi = op.videoInfo;
    var params = op.params;
    var plugin = this.plugins[vi.provider];
    params = params === 'internal' ? vi.params : params || {};

    if (plugin) {
      op.format = op.format || plugin.defaultFormat; // eslint-disable-next-line no-prototype-builtins

      if (plugin.formats.hasOwnProperty(op.format)) {
        return plugin.formats[op.format].apply(plugin, [vi, Object.assign({}, params)]);
      }
    }

    return undefined;
  };

  function removeEmptyParameters(result) {
    if (result.params && Object.keys(result.params).length === 0) {
      delete result.params;
    }

    return result;
  }

  var parser = new urlParser();
  var base = parser;

  function Allocine() {
    this.provider = 'allocine';
    this.alternatives = [];
    this.defaultFormat = 'embed';
    this.formats = {
      embed: this.createEmbedUrl
    };
    this.mediaTypes = {
      VIDEO: 'video'
    };
  }

  Allocine.prototype.parseUrl = function (url) {
    var match = url.match(/(?:\/video\/player_gen_cmedia=)([A-Za-z0-9]+)/i);
    return match ? match[1] : undefined;
  };

  Allocine.prototype.parse = function (url) {
    var result = {
      mediaType: this.mediaTypes.VIDEO,
      id: this.parseUrl(url)
    };
    return result.id ? result : undefined;
  };

  Allocine.prototype.createEmbedUrl = function (vi) {
    if (!vi.id || vi.mediaType !== this.mediaTypes.VIDEO) {
      return undefined;
    }

    return 'https://player.allocine.fr/' + vi.id + '.html';
  };

  base.bind(new Allocine());

  var combineParams$1 = util.combineParams;

  function CanalPlus() {
    this.provider = 'canalplus';
    this.defaultFormat = 'embed';
    this.formats = {
      embed: this.createEmbedUrl
    };
    this.mediaTypes = {
      VIDEO: 'video'
    };
  }

  CanalPlus.prototype.parseParameters = function (params) {
    delete params.vid;
    return params;
  };

  CanalPlus.prototype.parse = function (url, params) {
    var _this = this;

    var result = {
      mediaType: this.mediaTypes.VIDEO,
      id: params.vid
    };
    result.params = _this.parseParameters(params);

    if (!result.id) {
      return undefined;
    }

    return result;
  };

  CanalPlus.prototype.createEmbedUrl = function (vi, params) {
    if (!vi.id || vi.mediaType !== this.mediaTypes.VIDEO) {
      return undefined;
    }

    var url = 'http://player.canalplus.fr/embed/';
    params.vid = vi.id;
    url += combineParams$1(params);
    return url;
  };

  base.bind(new CanalPlus());

  var combineParams$2 = util.combineParams;

  function Coub() {
    this.provider = 'coub';
    this.defaultFormat = 'long';
    this.formats = {
      "long": this.createLongUrl,
      embed: this.createEmbedUrl
    };
    this.mediaTypes = {
      VIDEO: 'video'
    };
  }

  Coub.prototype.parseUrl = function (url) {
    var match = url.match(/(?:embed|view)\/([a-zA-Z\d]+)/i);
    return match ? match[1] : undefined;
  };

  Coub.prototype.parse = function (url, params) {
    var result = {
      mediaType: this.mediaTypes.VIDEO,
      params: params,
      id: this.parseUrl(url)
    };

    if (!result.id) {
      return undefined;
    }

    return result;
  };

  Coub.prototype.createUrl = function (baseUrl, vi, params) {
    if (!vi.id || vi.mediaType !== this.mediaTypes.VIDEO) {
      return undefined;
    }

    var url = baseUrl + vi.id;
    url += combineParams$2(params);
    return url;
  };

  Coub.prototype.createLongUrl = function (vi, params) {
    return this.createUrl('https://coub.com/view/', vi, params);
  };

  Coub.prototype.createEmbedUrl = function (vi, params) {
    return this.createUrl('//coub.com/embed/', vi, params);
  };

  base.bind(new Coub());

  var combineParams$3 = util.combineParams,
      getTime$1 = util.getTime;

  function Dailymotion() {
    this.provider = 'dailymotion';
    this.alternatives = ['dai'];
    this.defaultFormat = 'long';
    this.formats = {
      "short": this.createShortUrl,
      "long": this.createLongUrl,
      embed: this.createEmbedUrl,
      image: this.createImageUrl
    };
    this.mediaTypes = {
      VIDEO: 'video'
    };
  }

  Dailymotion.prototype.parseParameters = function (params) {
    return this.parseTime(params);
  };

  Dailymotion.prototype.parseTime = function (params) {
    if (params.start) {
      params.start = getTime$1(params.start);
    }

    return params;
  };

  Dailymotion.prototype.parseUrl = function (url) {
    var match = url.match(/(?:\/video|ly)\/([A-Za-z0-9]+)/i);
    return match ? match[1] : undefined;
  };

  Dailymotion.prototype.parse = function (url, params) {
    var _this = this;

    var result = {
      mediaType: this.mediaTypes.VIDEO,
      params: _this.parseParameters(params),
      id: _this.parseUrl(url)
    };
    return result.id ? result : undefined;
  };

  Dailymotion.prototype.createUrl = function (base, vi, params) {
    if (!vi.id || vi.mediaType !== this.mediaTypes.VIDEO) {
      return undefined;
    }

    return base + vi.id + combineParams$3(params);
  };

  Dailymotion.prototype.createShortUrl = function (vi, params) {
    return this.createUrl('https://dai.ly/', vi, params);
  };

  Dailymotion.prototype.createLongUrl = function (vi, params) {
    return this.createUrl('https://dailymotion.com/video/', vi, params);
  };

  Dailymotion.prototype.createEmbedUrl = function (vi, params) {
    return this.createUrl('https://www.dailymotion.com/embed/video/', vi, params);
  };

  Dailymotion.prototype.createImageUrl = function (vi, params) {
    delete params.start;
    return this.createUrl('https://www.dailymotion.com/thumbnail/video/', vi, params);
  };

  base.bind(new Dailymotion());

  var combineParams$4 = util.combineParams;

  function Loom() {
    this.provider = 'loom';
    this.defaultFormat = 'long';
    this.formats = {
      "long": this.createLongUrl,
      embed: this.createEmbedUrl
    };
    this.mediaTypes = {
      VIDEO: 'video'
    };
  }

  Loom.prototype.parseUrl = function (url) {
    var match = url.match(/(?:share|embed)\/([a-zA-Z\d]+)/i);
    return match ? match[1] : undefined;
  };

  Loom.prototype.parse = function (url, params) {
    var result = {
      mediaType: this.mediaTypes.VIDEO,
      params: params,
      id: this.parseUrl(url)
    };
    return result.id ? result : undefined;
  };

  Loom.prototype.createUrl = function (baseUrl, vi, params) {
    if (!vi.id || vi.mediaType !== this.mediaTypes.VIDEO) {
      return undefined;
    }

    var url = baseUrl + vi.id;
    url += combineParams$4(params);
    return url;
  };

  Loom.prototype.createLongUrl = function (vi, params) {
    return this.createUrl('https://loom.com/share/', vi, params);
  };

  Loom.prototype.createEmbedUrl = function (vi, params) {
    return this.createUrl('//loom.com/embed/', vi, params);
  };

  base.bind(new Loom());

  var combineParams$5 = util.combineParams,
      getTime$2 = util.getTime;

  function Twitch() {
    this.provider = 'twitch';
    this.defaultFormat = 'long';
    this.formats = {
      "long": this.createLongUrl,
      embed: this.createEmbedUrl
    };
    this.mediaTypes = {
      VIDEO: 'video',
      STREAM: 'stream',
      CLIP: 'clip'
    };
  }

  Twitch.prototype.seperateId = function (id) {
    return {
      pre: id[0],
      id: id.substr(1)
    };
  };

  Twitch.prototype.parseChannel = function (result, params) {
    var channel = params.channel || params.utm_content || result.channel;
    delete params.utm_content;
    delete params.channel;
    return channel;
  };

  Twitch.prototype.parseUrl = function (url, result, params) {
    var match;
    match = url.match(/(clips\.)?twitch\.tv\/(?:(?:videos\/(\d+))|(\w+(?:-[\w\d-]+)?)(?:\/clip\/(\w+))?)/i);

    if (match && match[2]) {
      //video
      result.id = 'v' + match[2];
    } else if (params.video) {
      //video embed
      result.id = params.video;
      delete params.video;
    } else if (params.clip) {
      //clips embed
      result.id = params.clip;
      result.isClip = true;
      delete params.clip;
    } else if (match && match[1] && match[3]) {
      //clips.twitch.tv/id
      result.id = match[3];
      result.isClip = true;
    } else if (match && match[3] && match[4]) {
      //twitch.tv/channel/clip/id
      result.channel = match[3];
      result.id = match[4];
      result.isClip = true;
    } else if (match && match[3]) {
      result.channel = match[3];
    }

    return result;
  };

  Twitch.prototype.parseMediaType = function (result) {
    var mediaType;

    if (result.id) {
      if (result.isClip) {
        mediaType = this.mediaTypes.CLIP;
        delete result.isClip;
      } else {
        mediaType = this.mediaTypes.VIDEO;
      }
    } else if (result.channel) {
      mediaType = this.mediaTypes.STREAM;
    }

    return mediaType;
  };

  Twitch.prototype.parseParameters = function (params) {
    if (params.t) {
      params.start = getTime$2(params.t);
      delete params.t;
    }

    return params;
  };

  Twitch.prototype.parse = function (url, params) {
    var _this = this;

    var result = {};
    result = _this.parseUrl(url, result, params);
    result.channel = _this.parseChannel(result, params);
    result.mediaType = _this.parseMediaType(result);
    result.params = _this.parseParameters(params);
    return result.channel || result.id ? result : undefined;
  };

  Twitch.prototype.createLongUrl = function (vi, params) {
    var url = '';

    if (vi.mediaType === this.mediaTypes.STREAM && vi.channel) {
      url = 'https://twitch.tv/' + vi.channel;
    } else if (vi.mediaType === this.mediaTypes.VIDEO && vi.id) {
      var sep = this.seperateId(vi.id);
      url = 'https://twitch.tv/videos/' + sep.id;

      if (params.start) {
        params.t = params.start + 's';
        delete params.start;
      }
    } else if (vi.mediaType === this.mediaTypes.CLIP && vi.id) {
      if (vi.channel) {
        url = 'https://www.twitch.tv/' + vi.channel + '/clip/' + vi.id;
      } else {
        url = 'https://clips.twitch.tv/' + vi.id;
      }
    } else {
      return undefined;
    }

    url += combineParams$5(params);
    return url;
  };

  Twitch.prototype.createEmbedUrl = function (vi, params) {
    var url = 'https://player.twitch.tv/';

    if (vi.mediaType === this.mediaTypes.STREAM && vi.channel) {
      params.channel = vi.channel;
    } else if (vi.mediaType === this.mediaTypes.VIDEO && vi.id) {
      params.video = vi.id;

      if (params.start) {
        params.t = params.start + 's';
        delete params.start;
      }
    } else if (vi.mediaType === this.mediaTypes.CLIP && vi.id) {
      url = 'https://clips.twitch.tv/embed';
      params.clip = vi.id;
    } else {
      return undefined;
    }

    url += combineParams$5(params);
    return url;
  };

  base.bind(new Twitch());

  var combineParams$6 = util.combineParams,
      getTime$3 = util.getTime;

  function Vimeo() {
    this.provider = 'vimeo';
    this.alternatives = ['vimeopro'];
    this.defaultFormat = 'long';
    this.formats = {
      "long": this.createLongUrl,
      embed: this.createEmbedUrl
    };
    this.mediaTypes = {
      VIDEO: 'video'
    };
  }

  Vimeo.prototype.parseUrl = function (url) {
    var match = url.match(/(?:\/showcase\/\d+)?(?:\/(?:channels\/[\w]+|(?:(?:album\/\d+|groups\/[\w]+)\/)?videos?))?\/(\d+)/i);
    return match ? match[1] : undefined;
  };

  Vimeo.prototype.parseHash = function (url) {
    var match = url.match(/\/\d+\/(\w+)$/i);
    return match ? match[1] : undefined;
  };

  Vimeo.prototype.parseParameters = function (params) {
    if (params.t) {
      params.start = getTime$3(params.t);
      delete params.t;
    }

    if (params.h) {
      params.hash = params.h;
      delete params.h;
    }

    return params;
  };

  Vimeo.prototype.parse = function (url, params) {
    var result = {
      mediaType: this.mediaTypes.VIDEO,
      params: this.parseParameters(params),
      id: this.parseUrl(url)
    };
    var hash = this.parseHash(url, params);

    if (hash) {
      result.params.hash = hash;
    }

    return result.id ? result : undefined;
  };

  Vimeo.prototype.createUrl = function (baseUrl, vi, params, type) {
    if (!vi.id || vi.mediaType !== this.mediaTypes.VIDEO) {
      return undefined;
    }

    var url = baseUrl + vi.id;
    var startTime = params.start;
    delete params.start;

    if (params.hash) {
      if (type === 'embed') {
        params.h = params.hash;
      } else if (type === 'long') {
        url += '/' + params.hash;
      }

      delete params.hash;
    }

    url += combineParams$6(params);

    if (startTime) {
      url += '#t=' + startTime;
    }

    return url;
  };

  Vimeo.prototype.createLongUrl = function (vi, params) {
    return this.createUrl('https://vimeo.com/', vi, params, 'long');
  };

  Vimeo.prototype.createEmbedUrl = function (vi, params) {
    return this.createUrl('//player.vimeo.com/video/', vi, params, 'embed');
  };

  base.bind(new Vimeo());

  var combineParams$7 = util.combineParams,
      getTime$4 = util.getTime;

  function Wistia() {
    this.provider = 'wistia';
    this.alternatives = [];
    this.defaultFormat = 'long';
    this.formats = {
      "long": this.createLongUrl,
      embed: this.createEmbedUrl,
      embedjsonp: this.createEmbedJsonpUrl
    };
    this.mediaTypes = {
      VIDEO: 'video',
      EMBEDVIDEO: 'embedvideo'
    };
  }

  Wistia.prototype.parseUrl = function (url) {
    var match = url.match(/(?:(?:medias|iframe)\/|wvideo=)([\w-]+)/);
    return match ? match[1] : undefined;
  };

  Wistia.prototype.parseChannel = function (url) {
    var match = url.match(/(?:(?:https?:)?\/\/)?([^.]*)\.wistia\./);
    var channel = match ? match[1] : undefined;

    if (channel === 'fast' || channel === 'content') {
      return undefined;
    }

    return channel;
  };

  Wistia.prototype.parseParameters = function (params, result) {
    if (params.wtime) {
      params.start = getTime$4(params.wtime);
      delete params.wtime;
    }

    if (params.wvideo === result.id) {
      delete params.wvideo;
    }

    return params;
  };

  Wistia.prototype.parseMediaType = function (result) {
    if (result.id && result.channel) {
      return this.mediaTypes.VIDEO;
    } else if (result.id) {
      delete result.channel;
      return this.mediaTypes.EMBEDVIDEO;
    } else {
      return undefined;
    }
  };

  Wistia.prototype.parse = function (url, params) {
    var result = {
      id: this.parseUrl(url),
      channel: this.parseChannel(url)
    };
    result.params = this.parseParameters(params, result);
    result.mediaType = this.parseMediaType(result);

    if (!result.id) {
      return undefined;
    }

    return result;
  };

  Wistia.prototype.createUrl = function (vi, params, url) {
    if (params.start) {
      params.wtime = params.start;
      delete params.start;
    }

    url += combineParams$7(params);
    return url;
  };

  Wistia.prototype.createLongUrl = function (vi, params) {
    if (!vi.id || vi.mediaType !== this.mediaTypes.VIDEO) {
      return undefined;
    }

    var url = 'https://' + vi.channel + '.wistia.com/medias/' + vi.id;
    return this.createUrl(vi, params, url);
  };

  Wistia.prototype.createEmbedUrl = function (vi, params) {
    if (!vi.id || !(vi.mediaType === this.mediaTypes.VIDEO || vi.mediaType === this.mediaTypes.EMBEDVIDEO)) {
      return undefined;
    }

    var url = 'https://fast.wistia.com/embed/iframe/' + vi.id;
    return this.createUrl(vi, params, url);
  };

  Wistia.prototype.createEmbedJsonpUrl = function (vi) {
    if (!vi.id || !(vi.mediaType === this.mediaTypes.VIDEO || vi.mediaType === this.mediaTypes.EMBEDVIDEO)) {
      return undefined;
    }

    return 'https://fast.wistia.com/embed/medias/' + vi.id + '.jsonp';
  };

  base.bind(new Wistia());

  var combineParams$8 = util.combineParams;

  function Youku() {
    this.provider = 'youku';
    this.defaultFormat = 'long';
    this.formats = {
      embed: this.createEmbedUrl,
      "long": this.createLongUrl,
      flash: this.createFlashUrl,
      "static": this.createStaticUrl
    };
    this.mediaTypes = {
      VIDEO: 'video'
    };
  }

  Youku.prototype.parseUrl = function (url) {
    var match = url.match(/(?:(?:embed|sid)\/|v_show\/id_|VideoIDS=)([a-zA-Z0-9]+)/);
    return match ? match[1] : undefined;
  };

  Youku.prototype.parseParameters = function (params) {
    if (params.VideoIDS) {
      delete params.VideoIDS;
    }

    return params;
  };

  Youku.prototype.parse = function (url, params) {
    var _this = this;

    var result = {
      mediaType: this.mediaTypes.VIDEO,
      id: _this.parseUrl(url),
      params: _this.parseParameters(params)
    };

    if (!result.id) {
      return undefined;
    }

    return result;
  };

  Youku.prototype.createUrl = function (baseUrl, vi, params) {
    if (!vi.id || vi.mediaType !== this.mediaTypes.VIDEO) {
      return undefined;
    }

    var url = baseUrl + vi.id;
    url += combineParams$8(params);
    return url;
  };

  Youku.prototype.createEmbedUrl = function (vi, params) {
    return this.createUrl('http://player.youku.com/embed/', vi, params);
  };

  Youku.prototype.createLongUrl = function (vi, params) {
    return this.createUrl('http://v.youku.com/v_show/id_', vi, params);
  };

  Youku.prototype.createStaticUrl = function (vi, params) {
    return this.createUrl('http://static.youku.com/v1.0.0638/v/swf/loader.swf?VideoIDS=', vi, params);
  };

  Youku.prototype.createFlashUrl = function (vi, params) {
    if (!vi.id || vi.mediaType !== this.mediaTypes.VIDEO) {
      return undefined;
    }

    var url = 'http://player.youku.com/player.php/sid/' + vi.id + '/v.swf';
    url += combineParams$8(params);
    return url;
  };

  base.bind(new Youku());

  var combineParams$9 = util.combineParams,
      getTime$5 = util.getTime;

  function YouTube() {
    this.provider = 'youtube';
    this.alternatives = ['youtu', 'ytimg'];
    this.defaultFormat = 'long';
    this.formats = {
      "short": this.createShortUrl,
      "long": this.createLongUrl,
      embed: this.createEmbedUrl,
      shortImage: this.createShortImageUrl,
      longImage: this.createLongImageUrl
    };
    this.imageQualities = {
      '0': '0',
      '1': '1',
      '2': '2',
      '3': '3',
      DEFAULT: 'default',
      HQDEFAULT: 'hqdefault',
      SDDEFAULT: 'sddefault',
      MQDEFAULT: 'mqdefault',
      MAXRESDEFAULT: 'maxresdefault'
    };
    this.defaultImageQuality = this.imageQualities.HQDEFAULT;
    this.mediaTypes = {
      VIDEO: 'video',
      PLAYLIST: 'playlist',
      SHARE: 'share',
      CHANNEL: 'channel'
    };
  }

  YouTube.prototype.parseVideoUrl = function (url) {
    var match = url.match(/(?:(?:v|vi|be|videos|embed)\/(?!videoseries)|(?:v|ci)=)([\w-]{11})/i);
    return match ? match[1] : undefined;
  };

  YouTube.prototype.parseChannelUrl = function (url) {
    // Match an opaque channel ID
    var match = url.match(/\/channel\/([\w-]+)/);

    if (match) {
      return {
        id: match[1],
        mediaType: this.mediaTypes.CHANNEL
      };
    } // Match a vanity channel name or a user name. User urls are deprecated and
    // currently redirect to the channel of that same name.


    match = url.match(/\/(?:c|user)\/([\w-]+)/);

    if (match) {
      return {
        name: match[1],
        mediaType: this.mediaTypes.CHANNEL
      };
    }
  };

  YouTube.prototype.parseParameters = function (params, result) {
    if (params.start || params.t) {
      params.start = getTime$5(params.start || params.t);
      delete params.t;
    }

    if (params.v === result.id) {
      delete params.v;
    }

    if (params.list === result.id) {
      delete params.list;
    }

    return params;
  };

  YouTube.prototype.parseMediaType = function (result) {
    if (result.params.list) {
      result.list = result.params.list;
      delete result.params.list;
    }

    if (result.id && !result.params.ci) {
      result.mediaType = this.mediaTypes.VIDEO;
    } else if (result.list) {
      delete result.id;
      result.mediaType = this.mediaTypes.PLAYLIST;
    } else if (result.params.ci) {
      delete result.params.ci;
      result.mediaType = this.mediaTypes.SHARE;
    } else {
      return undefined;
    }

    return result;
  };

  YouTube.prototype.parse = function (url, params) {
    var channelResult = this.parseChannelUrl(url);

    if (channelResult) {
      return channelResult;
    } else {
      var result = {
        params: params,
        id: this.parseVideoUrl(url)
      };
      result.params = this.parseParameters(params, result);
      result = this.parseMediaType(result);
      return result;
    }
  };

  YouTube.prototype.createShortUrl = function (vi, params) {
    if (!vi.id || vi.mediaType !== this.mediaTypes.VIDEO) {
      return undefined;
    }

    var url = 'https://youtu.be/' + vi.id;

    if (params.start) {
      url += '#t=' + params.start;
    }

    return url;
  };

  YouTube.prototype.createLongUrl = function (vi, params) {
    var url = '';
    var startTime = params.start;
    delete params.start;

    if (vi.mediaType === this.mediaTypes.CHANNEL) {
      if (vi.id) {
        url += 'https://www.youtube.com/channel/' + vi.id;
      } else if (vi.name) {
        url += 'https://www.youtube.com/c/' + vi.name;
      } else {
        return undefined;
      }
    } else if (vi.mediaType === this.mediaTypes.PLAYLIST && vi.list) {
      params.feature = 'share';
      url += 'https://www.youtube.com/playlist';
    } else if (vi.mediaType === this.mediaTypes.VIDEO && vi.id) {
      params.v = vi.id;
      url += 'https://www.youtube.com/watch';
    } else if (vi.mediaType === this.mediaTypes.SHARE && vi.id) {
      params.ci = vi.id;
      url += 'https://www.youtube.com/shared';
    } else {
      return undefined;
    }

    if (vi.list) {
      params.list = vi.list;
    }

    url += combineParams$9(params);

    if (vi.mediaType !== this.mediaTypes.PLAYLIST && startTime) {
      url += '#t=' + startTime;
    }

    return url;
  };

  YouTube.prototype.createEmbedUrl = function (vi, params) {
    var url = 'https://www.youtube.com/embed';

    if (vi.mediaType === this.mediaTypes.PLAYLIST && vi.list) {
      params.listType = 'playlist';
    } else if (vi.mediaType === this.mediaTypes.VIDEO && vi.id) {
      url += '/' + vi.id; //loop hack

      if (params.loop === '1') {
        params.playlist = vi.id;
      }
    } else {
      return undefined;
    }

    if (vi.list) {
      params.list = vi.list;
    }

    url += combineParams$9(params);
    return url;
  };

  YouTube.prototype.createImageUrl = function (baseUrl, vi, params) {
    if (!vi.id || vi.mediaType !== this.mediaTypes.VIDEO) {
      return undefined;
    }

    var url = baseUrl + vi.id + '/';
    var quality = params.imageQuality || this.defaultImageQuality;
    return url + quality + '.jpg';
  };

  YouTube.prototype.createShortImageUrl = function (vi, params) {
    return this.createImageUrl('https://i.ytimg.com/vi/', vi, params);
  };

  YouTube.prototype.createLongImageUrl = function (vi, params) {
    return this.createImageUrl('https://img.youtube.com/vi/', vi, params);
  };

  base.bind(new YouTube());

  var combineParams$a = util.combineParams,
      getTime$6 = util.getTime;

  function SoundCloud() {
    this.provider = 'soundcloud';
    this.defaultFormat = 'long';
    this.formats = {
      "long": this.createLongUrl,
      embed: this.createEmbedUrl
    };
    this.mediaTypes = {
      TRACK: 'track',
      PLAYLIST: 'playlist',
      APITRACK: 'apitrack',
      APIPLAYLIST: 'apiplaylist'
    };
  }

  SoundCloud.prototype.parseUrl = function (url, result) {
    var match = url.match(/(?:m\.)?soundcloud\.com\/(?:([\w-]+)\/(sets\/)?)([\w-]+)/i);

    if (!match) {
      return result;
    }

    result.channel = match[1];

    if (match[1] === 'playlists' || match[2]) {
      //playlist
      result.list = match[3];
    } else {
      //track
      result.id = match[3];
    }

    return result;
  };

  SoundCloud.prototype.parseParameters = function (params) {
    if (params.t) {
      params.start = getTime$6(params.t);
      delete params.t;
    }

    return params;
  };

  SoundCloud.prototype.parseMediaType = function (result) {
    if (result.id) {
      if (result.channel === 'tracks') {
        delete result.channel;
        delete result.params.url;
        result.mediaType = this.mediaTypes.APITRACK;
      } else {
        result.mediaType = this.mediaTypes.TRACK;
      }
    }

    if (result.list) {
      if (result.channel === 'playlists') {
        delete result.channel;
        delete result.params.url;
        result.mediaType = this.mediaTypes.APIPLAYLIST;
      } else {
        result.mediaType = this.mediaTypes.PLAYLIST;
      }
    }

    return result;
  };

  SoundCloud.prototype.parse = function (url, params) {
    var result = {};
    result = this.parseUrl(url, result);
    result.params = this.parseParameters(params);
    result = this.parseMediaType(result);

    if (!result.id && !result.list) {
      return undefined;
    }

    return result;
  };

  SoundCloud.prototype.createLongUrl = function (vi, params) {
    var url = '';
    var startTime = params.start;
    delete params.start;

    if (vi.mediaType === this.mediaTypes.TRACK && vi.id && vi.channel) {
      url = 'https://soundcloud.com/' + vi.channel + '/' + vi.id;
    } else if (vi.mediaType === this.mediaTypes.PLAYLIST && vi.list && vi.channel) {
      url = 'https://soundcloud.com/' + vi.channel + '/sets/' + vi.list;
    } else if (vi.mediaType === this.mediaTypes.APITRACK && vi.id) {
      url = 'https://api.soundcloud.com/tracks/' + vi.id;
    } else if (vi.mediaType === this.mediaTypes.APIPLAYLIST && vi.list) {
      url = 'https://api.soundcloud.com/playlists/' + vi.list;
    } else {
      return undefined;
    }

    url += combineParams$a(params);

    if (startTime) {
      url += '#t=' + startTime;
    }

    return url;
  };

  SoundCloud.prototype.createEmbedUrl = function (vi, params) {
    var url = 'https://w.soundcloud.com/player/';
    delete params.start;

    if (vi.mediaType === this.mediaTypes.APITRACK && vi.id) {
      params.url = 'https%3A//api.soundcloud.com/tracks/' + vi.id;
    } else if (vi.mediaType === this.mediaTypes.APIPLAYLIST && vi.list) {
      params.url = 'https%3A//api.soundcloud.com/playlists/' + vi.list;
    } else {
      return undefined;
    }

    url += combineParams$a(params);
    return url;
  };

  base.bind(new SoundCloud());

  var combineParams$b = util.combineParams;

  function TeacherTube() {
    this.provider = 'teachertube';
    this.alternatives = [];
    this.defaultFormat = 'long';
    this.formats = {
      "long": this.createLongUrl,
      embed: this.createEmbedUrl
    };
    this.mediaTypes = {
      VIDEO: 'video',
      AUDIO: 'audio',
      DOCUMENT: 'document',
      CHANNEL: 'channel',
      COLLECTION: 'collection',
      GROUP: 'group'
    };
  }

  TeacherTube.prototype.parse = function (url, params) {
    var result = {};
    result.list = this.parsePlaylist(params);
    result.params = params;
    var match = url.match(/\/(audio|video|document|user\/channel|collection|group)\/(?:[\w-]+-)?(\w+)/);

    if (!match) {
      return undefined;
    }

    result.mediaType = this.parseMediaType(match[1]);
    result.id = match[2];
    return result;
  };

  TeacherTube.prototype.parsePlaylist = function (params) {
    if (params['playlist-id']) {
      var list = params['playlist-id'];
      delete params['playlist-id'];
      return list;
    }

    return undefined;
  };

  TeacherTube.prototype.parseMediaType = function (mediaTypeMatch) {
    switch (mediaTypeMatch) {
      case 'audio':
        return this.mediaTypes.AUDIO;

      case 'video':
        return this.mediaTypes.VIDEO;

      case 'document':
        return this.mediaTypes.DOCUMENT;

      case 'user/channel':
        return this.mediaTypes.CHANNEL;

      case 'collection':
        return this.mediaTypes.COLLECTION;

      case 'group':
        return this.mediaTypes.GROUP;
    }
  };

  TeacherTube.prototype.createLongUrl = function (vi, params) {
    if (!vi.id) {
      return undefined;
    }

    var url = 'https://www.teachertube.com/';

    if (vi.list) {
      params['playlist-id'] = vi.list;
    }

    if (vi.mediaType === this.mediaTypes.CHANNEL) {
      url += 'user/channel/';
    } else {
      url += vi.mediaType + '/';
    }

    url += vi.id;
    url += combineParams$b(params);
    return url;
  };

  TeacherTube.prototype.createEmbedUrl = function (vi, params) {
    if (!vi.id) {
      return undefined;
    }

    var url = 'https://www.teachertube.com/embed/';

    if (vi.mediaType === this.mediaTypes.VIDEO || vi.mediaType === this.mediaTypes.AUDIO) {
      url += vi.mediaType + '/' + vi.id;
    } else {
      return undefined;
    }

    url += combineParams$b(params);
    return url;
  };

  base.bind(new TeacherTube());

  var combineParams$c = util.combineParams;

  function TikTok() {
    this.provider = 'tiktok';
    this.defaultFormat = 'long';
    this.formats = {
      "long": this.createLongUrl
    };
    this.mediaTypes = {
      VIDEO: 'video'
    };
  }

  TikTok.prototype.parse = function (url, params) {
    var result = {
      params: params,
      mediaType: this.mediaTypes.VIDEO
    };
    var match = url.match(/@([^/]+)\/video\/(\d{19})/);

    if (!match) {
      return;
    }

    result.channel = match[1];
    result.id = match[2];
    return result;
  };

  TikTok.prototype.createLongUrl = function (vi, params) {
    var url = '';

    if (vi.mediaType === this.mediaTypes.VIDEO && vi.id && vi.channel) {
      url += "https://www.tiktok.com/@".concat(vi.channel, "/video/").concat(vi.id);
    } else {
      return undefined;
    }

    url += combineParams$c(params);
    return url;
  };

  base.bind(new TikTok());

  var combineParams$d = util.combineParams;

  function Ted() {
    this.provider = 'ted';
    this.formats = {
      "long": this.createLongUrl,
      embed: this.createEmbedUrl
    };
    this.mediaTypes = {
      VIDEO: 'video',
      PLAYLIST: 'playlist'
    };
  }

  Ted.prototype.parseUrl = function (url, result) {
    var match = url.match(/\/(talks|playlists\/(\d+))\/([\w-]+)/i);
    var channel = match ? match[1] : undefined;

    if (!channel) {
      return result;
    }

    result.channel = channel.split('/')[0];
    result.id = match[3];

    if (result.channel === 'playlists') {
      result.list = match[2];
    }

    return result;
  };

  Ted.prototype.parseMediaType = function (result) {
    if (result.id && result.channel === 'playlists') {
      delete result.channel;
      result.mediaType = this.mediaTypes.PLAYLIST;
    }

    if (result.id && result.channel === 'talks') {
      delete result.channel;
      result.mediaType = this.mediaTypes.VIDEO;
    }

    return result;
  };

  Ted.prototype.parse = function (url, params) {
    var result = {
      params: params
    };
    result = this.parseUrl(url, result);
    result = this.parseMediaType(result);

    if (!result.id) {
      return undefined;
    }

    return result;
  };

  Ted.prototype.createLongUrl = function (vi, params) {
    var url = '';

    if (vi.mediaType === this.mediaTypes.VIDEO && vi.id) {
      url += 'https://ted.com/talks/' + vi.id;
    } else if (vi.mediaType === this.mediaTypes.PLAYLIST && vi.id) {
      url += 'https://ted.com/playlists/' + vi.list + '/' + vi.id;
    } else {
      return undefined;
    }

    url += combineParams$d(params);
    return url;
  };

  Ted.prototype.createEmbedUrl = function (vi, params) {
    var url = 'https://embed.ted.com/';

    if (vi.mediaType === this.mediaTypes.PLAYLIST && vi.id) {
      url += 'playlists/' + vi.list + '/' + vi.id;
    } else if (vi.mediaType === this.mediaTypes.VIDEO && vi.id) {
      url += 'talks/' + vi.id;
    } else {
      return undefined;
    }

    url += combineParams$d(params);
    return url;
  };

  base.bind(new Ted());

  var combineParams$e = util.combineParams;

  function Facebook() {
    this.provider = 'facebook';
    this.alternatives = [];
    this.defaultFormat = 'long';
    this.formats = {
      "long": this.createLongUrl,
      watch: this.createWatchUrl
    };
    this.mediaTypes = {
      VIDEO: 'video'
    };
  }

  Facebook.prototype.parse = function (url, params) {
    var result = {
      params: params,
      mediaType: this.mediaTypes.VIDEO
    };
    var match = url.match(/(?:\/(\d+))?\/videos(?:\/.*?)?\/(\d+)/i);

    if (match) {
      if (match[1]) {
        result.pageId = match[1];
      }

      result.id = match[2];
    }

    if (params.v && !result.id) {
      result.id = params.v;
      delete params.v;
      result.params = params;
    }

    if (!result.id) {
      return undefined;
    }

    return result;
  };

  Facebook.prototype.createWatchUrl = function (vi, params) {
    var url = 'https://facebook.com/watch/';

    if (vi.mediaType !== this.mediaTypes.VIDEO || !vi.id) {
      return undefined;
    }

    params = {
      v: vi.id
    };
    url += combineParams$e(params);
    return url;
  };

  Facebook.prototype.createLongUrl = function (vi, params) {
    var url = 'https://facebook.com/';

    if (vi.pageId) {
      url += vi.pageId;
    } else {
      return undefined;
    }

    if (vi.mediaType === this.mediaTypes.VIDEO && vi.id) {
      url += '/videos/' + vi.id;
    } else {
      return undefined;
    }

    url += combineParams$e(params);
    return url;
  };

  base.bind(new Facebook());

  var lib = base;

  return lib;

})));


/***/ }),

/***/ "./node_modules/lodash/_DataView.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_DataView.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(/*! ./_getNative */ "./node_modules/lodash/_getNative.js"),
    root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/* Built-in method references that are verified to be native. */
var DataView = getNative(root, 'DataView');

module.exports = DataView;


/***/ }),

/***/ "./node_modules/lodash/_Hash.js":
/*!**************************************!*\
  !*** ./node_modules/lodash/_Hash.js ***!
  \**************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var hashClear = __webpack_require__(/*! ./_hashClear */ "./node_modules/lodash/_hashClear.js"),
    hashDelete = __webpack_require__(/*! ./_hashDelete */ "./node_modules/lodash/_hashDelete.js"),
    hashGet = __webpack_require__(/*! ./_hashGet */ "./node_modules/lodash/_hashGet.js"),
    hashHas = __webpack_require__(/*! ./_hashHas */ "./node_modules/lodash/_hashHas.js"),
    hashSet = __webpack_require__(/*! ./_hashSet */ "./node_modules/lodash/_hashSet.js");

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

module.exports = Hash;


/***/ }),

/***/ "./node_modules/lodash/_ListCache.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_ListCache.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var listCacheClear = __webpack_require__(/*! ./_listCacheClear */ "./node_modules/lodash/_listCacheClear.js"),
    listCacheDelete = __webpack_require__(/*! ./_listCacheDelete */ "./node_modules/lodash/_listCacheDelete.js"),
    listCacheGet = __webpack_require__(/*! ./_listCacheGet */ "./node_modules/lodash/_listCacheGet.js"),
    listCacheHas = __webpack_require__(/*! ./_listCacheHas */ "./node_modules/lodash/_listCacheHas.js"),
    listCacheSet = __webpack_require__(/*! ./_listCacheSet */ "./node_modules/lodash/_listCacheSet.js");

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

module.exports = ListCache;


/***/ }),

/***/ "./node_modules/lodash/_Map.js":
/*!*************************************!*\
  !*** ./node_modules/lodash/_Map.js ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(/*! ./_getNative */ "./node_modules/lodash/_getNative.js"),
    root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/* Built-in method references that are verified to be native. */
var Map = getNative(root, 'Map');

module.exports = Map;


/***/ }),

/***/ "./node_modules/lodash/_MapCache.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_MapCache.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var mapCacheClear = __webpack_require__(/*! ./_mapCacheClear */ "./node_modules/lodash/_mapCacheClear.js"),
    mapCacheDelete = __webpack_require__(/*! ./_mapCacheDelete */ "./node_modules/lodash/_mapCacheDelete.js"),
    mapCacheGet = __webpack_require__(/*! ./_mapCacheGet */ "./node_modules/lodash/_mapCacheGet.js"),
    mapCacheHas = __webpack_require__(/*! ./_mapCacheHas */ "./node_modules/lodash/_mapCacheHas.js"),
    mapCacheSet = __webpack_require__(/*! ./_mapCacheSet */ "./node_modules/lodash/_mapCacheSet.js");

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

module.exports = MapCache;


/***/ }),

/***/ "./node_modules/lodash/_Promise.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_Promise.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(/*! ./_getNative */ "./node_modules/lodash/_getNative.js"),
    root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/* Built-in method references that are verified to be native. */
var Promise = getNative(root, 'Promise');

module.exports = Promise;


/***/ }),

/***/ "./node_modules/lodash/_Set.js":
/*!*************************************!*\
  !*** ./node_modules/lodash/_Set.js ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(/*! ./_getNative */ "./node_modules/lodash/_getNative.js"),
    root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/* Built-in method references that are verified to be native. */
var Set = getNative(root, 'Set');

module.exports = Set;


/***/ }),

/***/ "./node_modules/lodash/_SetCache.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_SetCache.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var MapCache = __webpack_require__(/*! ./_MapCache */ "./node_modules/lodash/_MapCache.js"),
    setCacheAdd = __webpack_require__(/*! ./_setCacheAdd */ "./node_modules/lodash/_setCacheAdd.js"),
    setCacheHas = __webpack_require__(/*! ./_setCacheHas */ "./node_modules/lodash/_setCacheHas.js");

/**
 *
 * Creates an array cache object to store unique values.
 *
 * @private
 * @constructor
 * @param {Array} [values] The values to cache.
 */
function SetCache(values) {
  var index = -1,
      length = values == null ? 0 : values.length;

  this.__data__ = new MapCache;
  while (++index < length) {
    this.add(values[index]);
  }
}

// Add methods to `SetCache`.
SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
SetCache.prototype.has = setCacheHas;

module.exports = SetCache;


/***/ }),

/***/ "./node_modules/lodash/_Stack.js":
/*!***************************************!*\
  !*** ./node_modules/lodash/_Stack.js ***!
  \***************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var ListCache = __webpack_require__(/*! ./_ListCache */ "./node_modules/lodash/_ListCache.js"),
    stackClear = __webpack_require__(/*! ./_stackClear */ "./node_modules/lodash/_stackClear.js"),
    stackDelete = __webpack_require__(/*! ./_stackDelete */ "./node_modules/lodash/_stackDelete.js"),
    stackGet = __webpack_require__(/*! ./_stackGet */ "./node_modules/lodash/_stackGet.js"),
    stackHas = __webpack_require__(/*! ./_stackHas */ "./node_modules/lodash/_stackHas.js"),
    stackSet = __webpack_require__(/*! ./_stackSet */ "./node_modules/lodash/_stackSet.js");

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new ListCache(entries);
  this.size = data.size;
}

// Add methods to `Stack`.
Stack.prototype.clear = stackClear;
Stack.prototype['delete'] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;

module.exports = Stack;


/***/ }),

/***/ "./node_modules/lodash/_Symbol.js":
/*!****************************************!*\
  !*** ./node_modules/lodash/_Symbol.js ***!
  \****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/** Built-in value references. */
var Symbol = root.Symbol;

module.exports = Symbol;


/***/ }),

/***/ "./node_modules/lodash/_Uint8Array.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_Uint8Array.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/** Built-in value references. */
var Uint8Array = root.Uint8Array;

module.exports = Uint8Array;


/***/ }),

/***/ "./node_modules/lodash/_WeakMap.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_WeakMap.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(/*! ./_getNative */ "./node_modules/lodash/_getNative.js"),
    root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/* Built-in method references that are verified to be native. */
var WeakMap = getNative(root, 'WeakMap');

module.exports = WeakMap;


/***/ }),

/***/ "./node_modules/lodash/_arrayEach.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_arrayEach.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * A specialized version of `_.forEach` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns `array`.
 */
function arrayEach(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (iteratee(array[index], index, array) === false) {
      break;
    }
  }
  return array;
}

module.exports = arrayEach;


/***/ }),

/***/ "./node_modules/lodash/_arrayFilter.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_arrayFilter.js ***!
  \*********************************************/
/***/ ((module) => {

/**
 * A specialized version of `_.filter` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Array} Returns the new filtered array.
 */
function arrayFilter(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length,
      resIndex = 0,
      result = [];

  while (++index < length) {
    var value = array[index];
    if (predicate(value, index, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}

module.exports = arrayFilter;


/***/ }),

/***/ "./node_modules/lodash/_arrayIncludes.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash/_arrayIncludes.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIndexOf = __webpack_require__(/*! ./_baseIndexOf */ "./node_modules/lodash/_baseIndexOf.js");

/**
 * A specialized version of `_.includes` for arrays without support for
 * specifying an index to search from.
 *
 * @private
 * @param {Array} [array] The array to inspect.
 * @param {*} target The value to search for.
 * @returns {boolean} Returns `true` if `target` is found, else `false`.
 */
function arrayIncludes(array, value) {
  var length = array == null ? 0 : array.length;
  return !!length && baseIndexOf(array, value, 0) > -1;
}

module.exports = arrayIncludes;


/***/ }),

/***/ "./node_modules/lodash/_arrayIncludesWith.js":
/*!***************************************************!*\
  !*** ./node_modules/lodash/_arrayIncludesWith.js ***!
  \***************************************************/
/***/ ((module) => {

/**
 * This function is like `arrayIncludes` except that it accepts a comparator.
 *
 * @private
 * @param {Array} [array] The array to inspect.
 * @param {*} target The value to search for.
 * @param {Function} comparator The comparator invoked per element.
 * @returns {boolean} Returns `true` if `target` is found, else `false`.
 */
function arrayIncludesWith(array, value, comparator) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (comparator(value, array[index])) {
      return true;
    }
  }
  return false;
}

module.exports = arrayIncludesWith;


/***/ }),

/***/ "./node_modules/lodash/_arrayLikeKeys.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash/_arrayLikeKeys.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseTimes = __webpack_require__(/*! ./_baseTimes */ "./node_modules/lodash/_baseTimes.js"),
    isArguments = __webpack_require__(/*! ./isArguments */ "./node_modules/lodash/isArguments.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js"),
    isBuffer = __webpack_require__(/*! ./isBuffer */ "./node_modules/lodash/isBuffer.js"),
    isIndex = __webpack_require__(/*! ./_isIndex */ "./node_modules/lodash/_isIndex.js"),
    isTypedArray = __webpack_require__(/*! ./isTypedArray */ "./node_modules/lodash/isTypedArray.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray(value),
      isArg = !isArr && isArguments(value),
      isBuff = !isArr && !isArg && isBuffer(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

module.exports = arrayLikeKeys;


/***/ }),

/***/ "./node_modules/lodash/_arrayMap.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_arrayMap.js ***!
  \******************************************/
/***/ ((module) => {

/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

module.exports = arrayMap;


/***/ }),

/***/ "./node_modules/lodash/_arrayPush.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_arrayPush.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

module.exports = arrayPush;


/***/ }),

/***/ "./node_modules/lodash/_arraySome.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_arraySome.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * A specialized version of `_.some` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function arraySome(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}

module.exports = arraySome;


/***/ }),

/***/ "./node_modules/lodash/_assignValue.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_assignValue.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseAssignValue = __webpack_require__(/*! ./_baseAssignValue */ "./node_modules/lodash/_baseAssignValue.js"),
    eq = __webpack_require__(/*! ./eq */ "./node_modules/lodash/eq.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Assigns `value` to `key` of `object` if the existing value is not equivalent
 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignValue(object, key, value) {
  var objValue = object[key];
  if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

module.exports = assignValue;


/***/ }),

/***/ "./node_modules/lodash/_assocIndexOf.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_assocIndexOf.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var eq = __webpack_require__(/*! ./eq */ "./node_modules/lodash/eq.js");

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

module.exports = assocIndexOf;


/***/ }),

/***/ "./node_modules/lodash/_baseAssign.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_baseAssign.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var copyObject = __webpack_require__(/*! ./_copyObject */ "./node_modules/lodash/_copyObject.js"),
    keys = __webpack_require__(/*! ./keys */ "./node_modules/lodash/keys.js");

/**
 * The base implementation of `_.assign` without support for multiple sources
 * or `customizer` functions.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @returns {Object} Returns `object`.
 */
function baseAssign(object, source) {
  return object && copyObject(source, keys(source), object);
}

module.exports = baseAssign;


/***/ }),

/***/ "./node_modules/lodash/_baseAssignIn.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_baseAssignIn.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var copyObject = __webpack_require__(/*! ./_copyObject */ "./node_modules/lodash/_copyObject.js"),
    keysIn = __webpack_require__(/*! ./keysIn */ "./node_modules/lodash/keysIn.js");

/**
 * The base implementation of `_.assignIn` without support for multiple sources
 * or `customizer` functions.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @returns {Object} Returns `object`.
 */
function baseAssignIn(object, source) {
  return object && copyObject(source, keysIn(source), object);
}

module.exports = baseAssignIn;


/***/ }),

/***/ "./node_modules/lodash/_baseAssignValue.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash/_baseAssignValue.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var defineProperty = __webpack_require__(/*! ./_defineProperty */ "./node_modules/lodash/_defineProperty.js");

/**
 * The base implementation of `assignValue` and `assignMergeValue` without
 * value checks.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function baseAssignValue(object, key, value) {
  if (key == '__proto__' && defineProperty) {
    defineProperty(object, key, {
      'configurable': true,
      'enumerable': true,
      'value': value,
      'writable': true
    });
  } else {
    object[key] = value;
  }
}

module.exports = baseAssignValue;


/***/ }),

/***/ "./node_modules/lodash/_baseClone.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_baseClone.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Stack = __webpack_require__(/*! ./_Stack */ "./node_modules/lodash/_Stack.js"),
    arrayEach = __webpack_require__(/*! ./_arrayEach */ "./node_modules/lodash/_arrayEach.js"),
    assignValue = __webpack_require__(/*! ./_assignValue */ "./node_modules/lodash/_assignValue.js"),
    baseAssign = __webpack_require__(/*! ./_baseAssign */ "./node_modules/lodash/_baseAssign.js"),
    baseAssignIn = __webpack_require__(/*! ./_baseAssignIn */ "./node_modules/lodash/_baseAssignIn.js"),
    cloneBuffer = __webpack_require__(/*! ./_cloneBuffer */ "./node_modules/lodash/_cloneBuffer.js"),
    copyArray = __webpack_require__(/*! ./_copyArray */ "./node_modules/lodash/_copyArray.js"),
    copySymbols = __webpack_require__(/*! ./_copySymbols */ "./node_modules/lodash/_copySymbols.js"),
    copySymbolsIn = __webpack_require__(/*! ./_copySymbolsIn */ "./node_modules/lodash/_copySymbolsIn.js"),
    getAllKeys = __webpack_require__(/*! ./_getAllKeys */ "./node_modules/lodash/_getAllKeys.js"),
    getAllKeysIn = __webpack_require__(/*! ./_getAllKeysIn */ "./node_modules/lodash/_getAllKeysIn.js"),
    getTag = __webpack_require__(/*! ./_getTag */ "./node_modules/lodash/_getTag.js"),
    initCloneArray = __webpack_require__(/*! ./_initCloneArray */ "./node_modules/lodash/_initCloneArray.js"),
    initCloneByTag = __webpack_require__(/*! ./_initCloneByTag */ "./node_modules/lodash/_initCloneByTag.js"),
    initCloneObject = __webpack_require__(/*! ./_initCloneObject */ "./node_modules/lodash/_initCloneObject.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js"),
    isBuffer = __webpack_require__(/*! ./isBuffer */ "./node_modules/lodash/isBuffer.js"),
    isMap = __webpack_require__(/*! ./isMap */ "./node_modules/lodash/isMap.js"),
    isObject = __webpack_require__(/*! ./isObject */ "./node_modules/lodash/isObject.js"),
    isSet = __webpack_require__(/*! ./isSet */ "./node_modules/lodash/isSet.js"),
    keys = __webpack_require__(/*! ./keys */ "./node_modules/lodash/keys.js"),
    keysIn = __webpack_require__(/*! ./keysIn */ "./node_modules/lodash/keysIn.js");

/** Used to compose bitmasks for cloning. */
var CLONE_DEEP_FLAG = 1,
    CLONE_FLAT_FLAG = 2,
    CLONE_SYMBOLS_FLAG = 4;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values supported by `_.clone`. */
var cloneableTags = {};
cloneableTags[argsTag] = cloneableTags[arrayTag] =
cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] =
cloneableTags[boolTag] = cloneableTags[dateTag] =
cloneableTags[float32Tag] = cloneableTags[float64Tag] =
cloneableTags[int8Tag] = cloneableTags[int16Tag] =
cloneableTags[int32Tag] = cloneableTags[mapTag] =
cloneableTags[numberTag] = cloneableTags[objectTag] =
cloneableTags[regexpTag] = cloneableTags[setTag] =
cloneableTags[stringTag] = cloneableTags[symbolTag] =
cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =
cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
cloneableTags[errorTag] = cloneableTags[funcTag] =
cloneableTags[weakMapTag] = false;

/**
 * The base implementation of `_.clone` and `_.cloneDeep` which tracks
 * traversed objects.
 *
 * @private
 * @param {*} value The value to clone.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Deep clone
 *  2 - Flatten inherited properties
 *  4 - Clone symbols
 * @param {Function} [customizer] The function to customize cloning.
 * @param {string} [key] The key of `value`.
 * @param {Object} [object] The parent object of `value`.
 * @param {Object} [stack] Tracks traversed objects and their clone counterparts.
 * @returns {*} Returns the cloned value.
 */
function baseClone(value, bitmask, customizer, key, object, stack) {
  var result,
      isDeep = bitmask & CLONE_DEEP_FLAG,
      isFlat = bitmask & CLONE_FLAT_FLAG,
      isFull = bitmask & CLONE_SYMBOLS_FLAG;

  if (customizer) {
    result = object ? customizer(value, key, object, stack) : customizer(value);
  }
  if (result !== undefined) {
    return result;
  }
  if (!isObject(value)) {
    return value;
  }
  var isArr = isArray(value);
  if (isArr) {
    result = initCloneArray(value);
    if (!isDeep) {
      return copyArray(value, result);
    }
  } else {
    var tag = getTag(value),
        isFunc = tag == funcTag || tag == genTag;

    if (isBuffer(value)) {
      return cloneBuffer(value, isDeep);
    }
    if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
      result = (isFlat || isFunc) ? {} : initCloneObject(value);
      if (!isDeep) {
        return isFlat
          ? copySymbolsIn(value, baseAssignIn(result, value))
          : copySymbols(value, baseAssign(result, value));
      }
    } else {
      if (!cloneableTags[tag]) {
        return object ? value : {};
      }
      result = initCloneByTag(value, tag, isDeep);
    }
  }
  // Check for circular references and return its corresponding clone.
  stack || (stack = new Stack);
  var stacked = stack.get(value);
  if (stacked) {
    return stacked;
  }
  stack.set(value, result);

  if (isSet(value)) {
    value.forEach(function(subValue) {
      result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
    });
  } else if (isMap(value)) {
    value.forEach(function(subValue, key) {
      result.set(key, baseClone(subValue, bitmask, customizer, key, value, stack));
    });
  }

  var keysFunc = isFull
    ? (isFlat ? getAllKeysIn : getAllKeys)
    : (isFlat ? keysIn : keys);

  var props = isArr ? undefined : keysFunc(value);
  arrayEach(props || value, function(subValue, key) {
    if (props) {
      key = subValue;
      subValue = value[key];
    }
    // Recursively populate clone (susceptible to call stack limits).
    assignValue(result, key, baseClone(subValue, bitmask, customizer, key, value, stack));
  });
  return result;
}

module.exports = baseClone;


/***/ }),

/***/ "./node_modules/lodash/_baseCreate.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_baseCreate.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(/*! ./isObject */ "./node_modules/lodash/isObject.js");

/** Built-in value references. */
var objectCreate = Object.create;

/**
 * The base implementation of `_.create` without support for assigning
 * properties to the created object.
 *
 * @private
 * @param {Object} proto The object to inherit from.
 * @returns {Object} Returns the new object.
 */
var baseCreate = (function() {
  function object() {}
  return function(proto) {
    if (!isObject(proto)) {
      return {};
    }
    if (objectCreate) {
      return objectCreate(proto);
    }
    object.prototype = proto;
    var result = new object;
    object.prototype = undefined;
    return result;
  };
}());

module.exports = baseCreate;


/***/ }),

/***/ "./node_modules/lodash/_baseEach.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_baseEach.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseForOwn = __webpack_require__(/*! ./_baseForOwn */ "./node_modules/lodash/_baseForOwn.js"),
    createBaseEach = __webpack_require__(/*! ./_createBaseEach */ "./node_modules/lodash/_createBaseEach.js");

/**
 * The base implementation of `_.forEach` without support for iteratee shorthands.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array|Object} Returns `collection`.
 */
var baseEach = createBaseEach(baseForOwn);

module.exports = baseEach;


/***/ }),

/***/ "./node_modules/lodash/_baseFindIndex.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash/_baseFindIndex.js ***!
  \***********************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.findIndex` and `_.findLastIndex` without
 * support for iteratee shorthands.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Function} predicate The function invoked per iteration.
 * @param {number} fromIndex The index to search from.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseFindIndex(array, predicate, fromIndex, fromRight) {
  var length = array.length,
      index = fromIndex + (fromRight ? 1 : -1);

  while ((fromRight ? index-- : ++index < length)) {
    if (predicate(array[index], index, array)) {
      return index;
    }
  }
  return -1;
}

module.exports = baseFindIndex;


/***/ }),

/***/ "./node_modules/lodash/_baseFor.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_baseFor.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var createBaseFor = __webpack_require__(/*! ./_createBaseFor */ "./node_modules/lodash/_createBaseFor.js");

/**
 * The base implementation of `baseForOwn` which iterates over `object`
 * properties returned by `keysFunc` and invokes `iteratee` for each property.
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @returns {Object} Returns `object`.
 */
var baseFor = createBaseFor();

module.exports = baseFor;


/***/ }),

/***/ "./node_modules/lodash/_baseForOwn.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_baseForOwn.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseFor = __webpack_require__(/*! ./_baseFor */ "./node_modules/lodash/_baseFor.js"),
    keys = __webpack_require__(/*! ./keys */ "./node_modules/lodash/keys.js");

/**
 * The base implementation of `_.forOwn` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Object} Returns `object`.
 */
function baseForOwn(object, iteratee) {
  return object && baseFor(object, iteratee, keys);
}

module.exports = baseForOwn;


/***/ }),

/***/ "./node_modules/lodash/_baseGet.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_baseGet.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var castPath = __webpack_require__(/*! ./_castPath */ "./node_modules/lodash/_castPath.js"),
    toKey = __webpack_require__(/*! ./_toKey */ "./node_modules/lodash/_toKey.js");

/**
 * The base implementation of `_.get` without support for default values.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @returns {*} Returns the resolved value.
 */
function baseGet(object, path) {
  path = castPath(path, object);

  var index = 0,
      length = path.length;

  while (object != null && index < length) {
    object = object[toKey(path[index++])];
  }
  return (index && index == length) ? object : undefined;
}

module.exports = baseGet;


/***/ }),

/***/ "./node_modules/lodash/_baseGetAllKeys.js":
/*!************************************************!*\
  !*** ./node_modules/lodash/_baseGetAllKeys.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayPush = __webpack_require__(/*! ./_arrayPush */ "./node_modules/lodash/_arrayPush.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js");

/**
 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @param {Function} symbolsFunc The function to get the symbols of `object`.
 * @returns {Array} Returns the array of property names and symbols.
 */
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
}

module.exports = baseGetAllKeys;


/***/ }),

/***/ "./node_modules/lodash/_baseGetTag.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_baseGetTag.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(/*! ./_Symbol */ "./node_modules/lodash/_Symbol.js"),
    getRawTag = __webpack_require__(/*! ./_getRawTag */ "./node_modules/lodash/_getRawTag.js"),
    objectToString = __webpack_require__(/*! ./_objectToString */ "./node_modules/lodash/_objectToString.js");

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

module.exports = baseGetTag;


/***/ }),

/***/ "./node_modules/lodash/_baseHasIn.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_baseHasIn.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.hasIn` without support for deep paths.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {Array|string} key The key to check.
 * @returns {boolean} Returns `true` if `key` exists, else `false`.
 */
function baseHasIn(object, key) {
  return object != null && key in Object(object);
}

module.exports = baseHasIn;


/***/ }),

/***/ "./node_modules/lodash/_baseIndexOf.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_baseIndexOf.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseFindIndex = __webpack_require__(/*! ./_baseFindIndex */ "./node_modules/lodash/_baseFindIndex.js"),
    baseIsNaN = __webpack_require__(/*! ./_baseIsNaN */ "./node_modules/lodash/_baseIsNaN.js"),
    strictIndexOf = __webpack_require__(/*! ./_strictIndexOf */ "./node_modules/lodash/_strictIndexOf.js");

/**
 * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseIndexOf(array, value, fromIndex) {
  return value === value
    ? strictIndexOf(array, value, fromIndex)
    : baseFindIndex(array, baseIsNaN, fromIndex);
}

module.exports = baseIndexOf;


/***/ }),

/***/ "./node_modules/lodash/_baseIsArguments.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash/_baseIsArguments.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(/*! ./_baseGetTag */ "./node_modules/lodash/_baseGetTag.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "./node_modules/lodash/isObjectLike.js");

/** `Object#toString` result references. */
var argsTag = '[object Arguments]';

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag;
}

module.exports = baseIsArguments;


/***/ }),

/***/ "./node_modules/lodash/_baseIsEqual.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_baseIsEqual.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsEqualDeep = __webpack_require__(/*! ./_baseIsEqualDeep */ "./node_modules/lodash/_baseIsEqualDeep.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "./node_modules/lodash/isObjectLike.js");

/**
 * The base implementation of `_.isEqual` which supports partial comparisons
 * and tracks traversed objects.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Unordered comparison
 *  2 - Partial comparison
 * @param {Function} [customizer] The function to customize comparisons.
 * @param {Object} [stack] Tracks traversed `value` and `other` objects.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 */
function baseIsEqual(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {
    return value !== value && other !== other;
  }
  return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}

module.exports = baseIsEqual;


/***/ }),

/***/ "./node_modules/lodash/_baseIsEqualDeep.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash/_baseIsEqualDeep.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Stack = __webpack_require__(/*! ./_Stack */ "./node_modules/lodash/_Stack.js"),
    equalArrays = __webpack_require__(/*! ./_equalArrays */ "./node_modules/lodash/_equalArrays.js"),
    equalByTag = __webpack_require__(/*! ./_equalByTag */ "./node_modules/lodash/_equalByTag.js"),
    equalObjects = __webpack_require__(/*! ./_equalObjects */ "./node_modules/lodash/_equalObjects.js"),
    getTag = __webpack_require__(/*! ./_getTag */ "./node_modules/lodash/_getTag.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js"),
    isBuffer = __webpack_require__(/*! ./isBuffer */ "./node_modules/lodash/isBuffer.js"),
    isTypedArray = __webpack_require__(/*! ./isTypedArray */ "./node_modules/lodash/isTypedArray.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    objectTag = '[object Object]';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqual` for arrays and objects which performs
 * deep comparisons and tracks traversed objects enabling objects with circular
 * references to be compared.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} [stack] Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  var objIsArr = isArray(object),
      othIsArr = isArray(other),
      objTag = objIsArr ? arrayTag : getTag(object),
      othTag = othIsArr ? arrayTag : getTag(other);

  objTag = objTag == argsTag ? objectTag : objTag;
  othTag = othTag == argsTag ? objectTag : othTag;

  var objIsObj = objTag == objectTag,
      othIsObj = othTag == objectTag,
      isSameTag = objTag == othTag;

  if (isSameTag && isBuffer(object)) {
    if (!isBuffer(other)) {
      return false;
    }
    objIsArr = true;
    objIsObj = false;
  }
  if (isSameTag && !objIsObj) {
    stack || (stack = new Stack);
    return (objIsArr || isTypedArray(object))
      ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)
      : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
  }
  if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object,
          othUnwrapped = othIsWrapped ? other.value() : other;

      stack || (stack = new Stack);
      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new Stack);
  return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
}

module.exports = baseIsEqualDeep;


/***/ }),

/***/ "./node_modules/lodash/_baseIsMap.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_baseIsMap.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getTag = __webpack_require__(/*! ./_getTag */ "./node_modules/lodash/_getTag.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "./node_modules/lodash/isObjectLike.js");

/** `Object#toString` result references. */
var mapTag = '[object Map]';

/**
 * The base implementation of `_.isMap` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a map, else `false`.
 */
function baseIsMap(value) {
  return isObjectLike(value) && getTag(value) == mapTag;
}

module.exports = baseIsMap;


/***/ }),

/***/ "./node_modules/lodash/_baseIsMatch.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_baseIsMatch.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Stack = __webpack_require__(/*! ./_Stack */ "./node_modules/lodash/_Stack.js"),
    baseIsEqual = __webpack_require__(/*! ./_baseIsEqual */ "./node_modules/lodash/_baseIsEqual.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * The base implementation of `_.isMatch` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to inspect.
 * @param {Object} source The object of property values to match.
 * @param {Array} matchData The property names, values, and compare flags to match.
 * @param {Function} [customizer] The function to customize comparisons.
 * @returns {boolean} Returns `true` if `object` is a match, else `false`.
 */
function baseIsMatch(object, source, matchData, customizer) {
  var index = matchData.length,
      length = index,
      noCustomizer = !customizer;

  if (object == null) {
    return !length;
  }
  object = Object(object);
  while (index--) {
    var data = matchData[index];
    if ((noCustomizer && data[2])
          ? data[1] !== object[data[0]]
          : !(data[0] in object)
        ) {
      return false;
    }
  }
  while (++index < length) {
    data = matchData[index];
    var key = data[0],
        objValue = object[key],
        srcValue = data[1];

    if (noCustomizer && data[2]) {
      if (objValue === undefined && !(key in object)) {
        return false;
      }
    } else {
      var stack = new Stack;
      if (customizer) {
        var result = customizer(objValue, srcValue, key, object, source, stack);
      }
      if (!(result === undefined
            ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack)
            : result
          )) {
        return false;
      }
    }
  }
  return true;
}

module.exports = baseIsMatch;


/***/ }),

/***/ "./node_modules/lodash/_baseIsNaN.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_baseIsNaN.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.isNaN` without support for number objects.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
 */
function baseIsNaN(value) {
  return value !== value;
}

module.exports = baseIsNaN;


/***/ }),

/***/ "./node_modules/lodash/_baseIsNative.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_baseIsNative.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isFunction = __webpack_require__(/*! ./isFunction */ "./node_modules/lodash/isFunction.js"),
    isMasked = __webpack_require__(/*! ./_isMasked */ "./node_modules/lodash/_isMasked.js"),
    isObject = __webpack_require__(/*! ./isObject */ "./node_modules/lodash/isObject.js"),
    toSource = __webpack_require__(/*! ./_toSource */ "./node_modules/lodash/_toSource.js");

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

module.exports = baseIsNative;


/***/ }),

/***/ "./node_modules/lodash/_baseIsSet.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_baseIsSet.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getTag = __webpack_require__(/*! ./_getTag */ "./node_modules/lodash/_getTag.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "./node_modules/lodash/isObjectLike.js");

/** `Object#toString` result references. */
var setTag = '[object Set]';

/**
 * The base implementation of `_.isSet` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a set, else `false`.
 */
function baseIsSet(value) {
  return isObjectLike(value) && getTag(value) == setTag;
}

module.exports = baseIsSet;


/***/ }),

/***/ "./node_modules/lodash/_baseIsTypedArray.js":
/*!**************************************************!*\
  !*** ./node_modules/lodash/_baseIsTypedArray.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(/*! ./_baseGetTag */ "./node_modules/lodash/_baseGetTag.js"),
    isLength = __webpack_require__(/*! ./isLength */ "./node_modules/lodash/isLength.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "./node_modules/lodash/isObjectLike.js");

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[funcTag] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike(value) &&
    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}

module.exports = baseIsTypedArray;


/***/ }),

/***/ "./node_modules/lodash/_baseIteratee.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_baseIteratee.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseMatches = __webpack_require__(/*! ./_baseMatches */ "./node_modules/lodash/_baseMatches.js"),
    baseMatchesProperty = __webpack_require__(/*! ./_baseMatchesProperty */ "./node_modules/lodash/_baseMatchesProperty.js"),
    identity = __webpack_require__(/*! ./identity */ "./node_modules/lodash/identity.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js"),
    property = __webpack_require__(/*! ./property */ "./node_modules/lodash/property.js");

/**
 * The base implementation of `_.iteratee`.
 *
 * @private
 * @param {*} [value=_.identity] The value to convert to an iteratee.
 * @returns {Function} Returns the iteratee.
 */
function baseIteratee(value) {
  // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
  // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
  if (typeof value == 'function') {
    return value;
  }
  if (value == null) {
    return identity;
  }
  if (typeof value == 'object') {
    return isArray(value)
      ? baseMatchesProperty(value[0], value[1])
      : baseMatches(value);
  }
  return property(value);
}

module.exports = baseIteratee;


/***/ }),

/***/ "./node_modules/lodash/_baseKeys.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_baseKeys.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isPrototype = __webpack_require__(/*! ./_isPrototype */ "./node_modules/lodash/_isPrototype.js"),
    nativeKeys = __webpack_require__(/*! ./_nativeKeys */ "./node_modules/lodash/_nativeKeys.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!isPrototype(object)) {
    return nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}

module.exports = baseKeys;


/***/ }),

/***/ "./node_modules/lodash/_baseKeysIn.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_baseKeysIn.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(/*! ./isObject */ "./node_modules/lodash/isObject.js"),
    isPrototype = __webpack_require__(/*! ./_isPrototype */ "./node_modules/lodash/_isPrototype.js"),
    nativeKeysIn = __webpack_require__(/*! ./_nativeKeysIn */ "./node_modules/lodash/_nativeKeysIn.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeysIn(object) {
  if (!isObject(object)) {
    return nativeKeysIn(object);
  }
  var isProto = isPrototype(object),
      result = [];

  for (var key in object) {
    if (!(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
      result.push(key);
    }
  }
  return result;
}

module.exports = baseKeysIn;


/***/ }),

/***/ "./node_modules/lodash/_baseMap.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_baseMap.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseEach = __webpack_require__(/*! ./_baseEach */ "./node_modules/lodash/_baseEach.js"),
    isArrayLike = __webpack_require__(/*! ./isArrayLike */ "./node_modules/lodash/isArrayLike.js");

/**
 * The base implementation of `_.map` without support for iteratee shorthands.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function baseMap(collection, iteratee) {
  var index = -1,
      result = isArrayLike(collection) ? Array(collection.length) : [];

  baseEach(collection, function(value, key, collection) {
    result[++index] = iteratee(value, key, collection);
  });
  return result;
}

module.exports = baseMap;


/***/ }),

/***/ "./node_modules/lodash/_baseMatches.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_baseMatches.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsMatch = __webpack_require__(/*! ./_baseIsMatch */ "./node_modules/lodash/_baseIsMatch.js"),
    getMatchData = __webpack_require__(/*! ./_getMatchData */ "./node_modules/lodash/_getMatchData.js"),
    matchesStrictComparable = __webpack_require__(/*! ./_matchesStrictComparable */ "./node_modules/lodash/_matchesStrictComparable.js");

/**
 * The base implementation of `_.matches` which doesn't clone `source`.
 *
 * @private
 * @param {Object} source The object of property values to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatches(source) {
  var matchData = getMatchData(source);
  if (matchData.length == 1 && matchData[0][2]) {
    return matchesStrictComparable(matchData[0][0], matchData[0][1]);
  }
  return function(object) {
    return object === source || baseIsMatch(object, source, matchData);
  };
}

module.exports = baseMatches;


/***/ }),

/***/ "./node_modules/lodash/_baseMatchesProperty.js":
/*!*****************************************************!*\
  !*** ./node_modules/lodash/_baseMatchesProperty.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsEqual = __webpack_require__(/*! ./_baseIsEqual */ "./node_modules/lodash/_baseIsEqual.js"),
    get = __webpack_require__(/*! ./get */ "./node_modules/lodash/get.js"),
    hasIn = __webpack_require__(/*! ./hasIn */ "./node_modules/lodash/hasIn.js"),
    isKey = __webpack_require__(/*! ./_isKey */ "./node_modules/lodash/_isKey.js"),
    isStrictComparable = __webpack_require__(/*! ./_isStrictComparable */ "./node_modules/lodash/_isStrictComparable.js"),
    matchesStrictComparable = __webpack_require__(/*! ./_matchesStrictComparable */ "./node_modules/lodash/_matchesStrictComparable.js"),
    toKey = __webpack_require__(/*! ./_toKey */ "./node_modules/lodash/_toKey.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * The base implementation of `_.matchesProperty` which doesn't clone `srcValue`.
 *
 * @private
 * @param {string} path The path of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatchesProperty(path, srcValue) {
  if (isKey(path) && isStrictComparable(srcValue)) {
    return matchesStrictComparable(toKey(path), srcValue);
  }
  return function(object) {
    var objValue = get(object, path);
    return (objValue === undefined && objValue === srcValue)
      ? hasIn(object, path)
      : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
  };
}

module.exports = baseMatchesProperty;


/***/ }),

/***/ "./node_modules/lodash/_baseProperty.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_baseProperty.js ***!
  \**********************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.property` without support for deep paths.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function baseProperty(key) {
  return function(object) {
    return object == null ? undefined : object[key];
  };
}

module.exports = baseProperty;


/***/ }),

/***/ "./node_modules/lodash/_basePropertyDeep.js":
/*!**************************************************!*\
  !*** ./node_modules/lodash/_basePropertyDeep.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGet = __webpack_require__(/*! ./_baseGet */ "./node_modules/lodash/_baseGet.js");

/**
 * A specialized version of `baseProperty` which supports deep paths.
 *
 * @private
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function basePropertyDeep(path) {
  return function(object) {
    return baseGet(object, path);
  };
}

module.exports = basePropertyDeep;


/***/ }),

/***/ "./node_modules/lodash/_baseTimes.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_baseTimes.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

module.exports = baseTimes;


/***/ }),

/***/ "./node_modules/lodash/_baseToString.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_baseToString.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(/*! ./_Symbol */ "./node_modules/lodash/_Symbol.js"),
    arrayMap = __webpack_require__(/*! ./_arrayMap */ "./node_modules/lodash/_arrayMap.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js"),
    isSymbol = __webpack_require__(/*! ./isSymbol */ "./node_modules/lodash/isSymbol.js");

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (isArray(value)) {
    // Recursively convert values (susceptible to call stack limits).
    return arrayMap(value, baseToString) + '';
  }
  if (isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

module.exports = baseToString;


/***/ }),

/***/ "./node_modules/lodash/_baseTrim.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_baseTrim.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var trimmedEndIndex = __webpack_require__(/*! ./_trimmedEndIndex */ "./node_modules/lodash/_trimmedEndIndex.js");

/** Used to match leading whitespace. */
var reTrimStart = /^\s+/;

/**
 * The base implementation of `_.trim`.
 *
 * @private
 * @param {string} string The string to trim.
 * @returns {string} Returns the trimmed string.
 */
function baseTrim(string) {
  return string
    ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, '')
    : string;
}

module.exports = baseTrim;


/***/ }),

/***/ "./node_modules/lodash/_baseUnary.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_baseUnary.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

module.exports = baseUnary;


/***/ }),

/***/ "./node_modules/lodash/_baseUniq.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_baseUniq.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var SetCache = __webpack_require__(/*! ./_SetCache */ "./node_modules/lodash/_SetCache.js"),
    arrayIncludes = __webpack_require__(/*! ./_arrayIncludes */ "./node_modules/lodash/_arrayIncludes.js"),
    arrayIncludesWith = __webpack_require__(/*! ./_arrayIncludesWith */ "./node_modules/lodash/_arrayIncludesWith.js"),
    cacheHas = __webpack_require__(/*! ./_cacheHas */ "./node_modules/lodash/_cacheHas.js"),
    createSet = __webpack_require__(/*! ./_createSet */ "./node_modules/lodash/_createSet.js"),
    setToArray = __webpack_require__(/*! ./_setToArray */ "./node_modules/lodash/_setToArray.js");

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * The base implementation of `_.uniqBy` without support for iteratee shorthands.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Function} [iteratee] The iteratee invoked per element.
 * @param {Function} [comparator] The comparator invoked per element.
 * @returns {Array} Returns the new duplicate free array.
 */
function baseUniq(array, iteratee, comparator) {
  var index = -1,
      includes = arrayIncludes,
      length = array.length,
      isCommon = true,
      result = [],
      seen = result;

  if (comparator) {
    isCommon = false;
    includes = arrayIncludesWith;
  }
  else if (length >= LARGE_ARRAY_SIZE) {
    var set = iteratee ? null : createSet(array);
    if (set) {
      return setToArray(set);
    }
    isCommon = false;
    includes = cacheHas;
    seen = new SetCache;
  }
  else {
    seen = iteratee ? [] : result;
  }
  outer:
  while (++index < length) {
    var value = array[index],
        computed = iteratee ? iteratee(value) : value;

    value = (comparator || value !== 0) ? value : 0;
    if (isCommon && computed === computed) {
      var seenIndex = seen.length;
      while (seenIndex--) {
        if (seen[seenIndex] === computed) {
          continue outer;
        }
      }
      if (iteratee) {
        seen.push(computed);
      }
      result.push(value);
    }
    else if (!includes(seen, computed, comparator)) {
      if (seen !== result) {
        seen.push(computed);
      }
      result.push(value);
    }
  }
  return result;
}

module.exports = baseUniq;


/***/ }),

/***/ "./node_modules/lodash/_cacheHas.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_cacheHas.js ***!
  \******************************************/
/***/ ((module) => {

/**
 * Checks if a `cache` value for `key` exists.
 *
 * @private
 * @param {Object} cache The cache to query.
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function cacheHas(cache, key) {
  return cache.has(key);
}

module.exports = cacheHas;


/***/ }),

/***/ "./node_modules/lodash/_castPath.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_castPath.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js"),
    isKey = __webpack_require__(/*! ./_isKey */ "./node_modules/lodash/_isKey.js"),
    stringToPath = __webpack_require__(/*! ./_stringToPath */ "./node_modules/lodash/_stringToPath.js"),
    toString = __webpack_require__(/*! ./toString */ "./node_modules/lodash/toString.js");

/**
 * Casts `value` to a path array if it's not one.
 *
 * @private
 * @param {*} value The value to inspect.
 * @param {Object} [object] The object to query keys on.
 * @returns {Array} Returns the cast property path array.
 */
function castPath(value, object) {
  if (isArray(value)) {
    return value;
  }
  return isKey(value, object) ? [value] : stringToPath(toString(value));
}

module.exports = castPath;


/***/ }),

/***/ "./node_modules/lodash/_cloneArrayBuffer.js":
/*!**************************************************!*\
  !*** ./node_modules/lodash/_cloneArrayBuffer.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Uint8Array = __webpack_require__(/*! ./_Uint8Array */ "./node_modules/lodash/_Uint8Array.js");

/**
 * Creates a clone of `arrayBuffer`.
 *
 * @private
 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
 * @returns {ArrayBuffer} Returns the cloned array buffer.
 */
function cloneArrayBuffer(arrayBuffer) {
  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
  new Uint8Array(result).set(new Uint8Array(arrayBuffer));
  return result;
}

module.exports = cloneArrayBuffer;


/***/ }),

/***/ "./node_modules/lodash/_cloneBuffer.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_cloneBuffer.js ***!
  \*********************************************/
/***/ ((module, exports, __webpack_require__) => {

/* module decorator */ module = __webpack_require__.nmd(module);
var root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/** Detect free variable `exports`. */
var freeExports =  true && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && "object" == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined,
    allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined;

/**
 * Creates a clone of  `buffer`.
 *
 * @private
 * @param {Buffer} buffer The buffer to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Buffer} Returns the cloned buffer.
 */
function cloneBuffer(buffer, isDeep) {
  if (isDeep) {
    return buffer.slice();
  }
  var length = buffer.length,
      result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);

  buffer.copy(result);
  return result;
}

module.exports = cloneBuffer;


/***/ }),

/***/ "./node_modules/lodash/_cloneDataView.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash/_cloneDataView.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var cloneArrayBuffer = __webpack_require__(/*! ./_cloneArrayBuffer */ "./node_modules/lodash/_cloneArrayBuffer.js");

/**
 * Creates a clone of `dataView`.
 *
 * @private
 * @param {Object} dataView The data view to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned data view.
 */
function cloneDataView(dataView, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
  return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
}

module.exports = cloneDataView;


/***/ }),

/***/ "./node_modules/lodash/_cloneRegExp.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_cloneRegExp.js ***!
  \*********************************************/
/***/ ((module) => {

/** Used to match `RegExp` flags from their coerced string values. */
var reFlags = /\w*$/;

/**
 * Creates a clone of `regexp`.
 *
 * @private
 * @param {Object} regexp The regexp to clone.
 * @returns {Object} Returns the cloned regexp.
 */
function cloneRegExp(regexp) {
  var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
  result.lastIndex = regexp.lastIndex;
  return result;
}

module.exports = cloneRegExp;


/***/ }),

/***/ "./node_modules/lodash/_cloneSymbol.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_cloneSymbol.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(/*! ./_Symbol */ "./node_modules/lodash/_Symbol.js");

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * Creates a clone of the `symbol` object.
 *
 * @private
 * @param {Object} symbol The symbol object to clone.
 * @returns {Object} Returns the cloned symbol object.
 */
function cloneSymbol(symbol) {
  return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
}

module.exports = cloneSymbol;


/***/ }),

/***/ "./node_modules/lodash/_cloneTypedArray.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash/_cloneTypedArray.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var cloneArrayBuffer = __webpack_require__(/*! ./_cloneArrayBuffer */ "./node_modules/lodash/_cloneArrayBuffer.js");

/**
 * Creates a clone of `typedArray`.
 *
 * @private
 * @param {Object} typedArray The typed array to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned typed array.
 */
function cloneTypedArray(typedArray, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}

module.exports = cloneTypedArray;


/***/ }),

/***/ "./node_modules/lodash/_copyArray.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_copyArray.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * Copies the values of `source` to `array`.
 *
 * @private
 * @param {Array} source The array to copy values from.
 * @param {Array} [array=[]] The array to copy values to.
 * @returns {Array} Returns `array`.
 */
function copyArray(source, array) {
  var index = -1,
      length = source.length;

  array || (array = Array(length));
  while (++index < length) {
    array[index] = source[index];
  }
  return array;
}

module.exports = copyArray;


/***/ }),

/***/ "./node_modules/lodash/_copyObject.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_copyObject.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assignValue = __webpack_require__(/*! ./_assignValue */ "./node_modules/lodash/_assignValue.js"),
    baseAssignValue = __webpack_require__(/*! ./_baseAssignValue */ "./node_modules/lodash/_baseAssignValue.js");

/**
 * Copies properties of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy properties from.
 * @param {Array} props The property identifiers to copy.
 * @param {Object} [object={}] The object to copy properties to.
 * @param {Function} [customizer] The function to customize copied values.
 * @returns {Object} Returns `object`.
 */
function copyObject(source, props, object, customizer) {
  var isNew = !object;
  object || (object = {});

  var index = -1,
      length = props.length;

  while (++index < length) {
    var key = props[index];

    var newValue = customizer
      ? customizer(object[key], source[key], key, object, source)
      : undefined;

    if (newValue === undefined) {
      newValue = source[key];
    }
    if (isNew) {
      baseAssignValue(object, key, newValue);
    } else {
      assignValue(object, key, newValue);
    }
  }
  return object;
}

module.exports = copyObject;


/***/ }),

/***/ "./node_modules/lodash/_copySymbols.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_copySymbols.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var copyObject = __webpack_require__(/*! ./_copyObject */ "./node_modules/lodash/_copyObject.js"),
    getSymbols = __webpack_require__(/*! ./_getSymbols */ "./node_modules/lodash/_getSymbols.js");

/**
 * Copies own symbols of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy symbols from.
 * @param {Object} [object={}] The object to copy symbols to.
 * @returns {Object} Returns `object`.
 */
function copySymbols(source, object) {
  return copyObject(source, getSymbols(source), object);
}

module.exports = copySymbols;


/***/ }),

/***/ "./node_modules/lodash/_copySymbolsIn.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash/_copySymbolsIn.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var copyObject = __webpack_require__(/*! ./_copyObject */ "./node_modules/lodash/_copyObject.js"),
    getSymbolsIn = __webpack_require__(/*! ./_getSymbolsIn */ "./node_modules/lodash/_getSymbolsIn.js");

/**
 * Copies own and inherited symbols of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy symbols from.
 * @param {Object} [object={}] The object to copy symbols to.
 * @returns {Object} Returns `object`.
 */
function copySymbolsIn(source, object) {
  return copyObject(source, getSymbolsIn(source), object);
}

module.exports = copySymbolsIn;


/***/ }),

/***/ "./node_modules/lodash/_coreJsData.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_coreJsData.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/** Used to detect overreaching core-js shims. */
var coreJsData = root['__core-js_shared__'];

module.exports = coreJsData;


/***/ }),

/***/ "./node_modules/lodash/_createBaseEach.js":
/*!************************************************!*\
  !*** ./node_modules/lodash/_createBaseEach.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isArrayLike = __webpack_require__(/*! ./isArrayLike */ "./node_modules/lodash/isArrayLike.js");

/**
 * Creates a `baseEach` or `baseEachRight` function.
 *
 * @private
 * @param {Function} eachFunc The function to iterate over a collection.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseEach(eachFunc, fromRight) {
  return function(collection, iteratee) {
    if (collection == null) {
      return collection;
    }
    if (!isArrayLike(collection)) {
      return eachFunc(collection, iteratee);
    }
    var length = collection.length,
        index = fromRight ? length : -1,
        iterable = Object(collection);

    while ((fromRight ? index-- : ++index < length)) {
      if (iteratee(iterable[index], index, iterable) === false) {
        break;
      }
    }
    return collection;
  };
}

module.exports = createBaseEach;


/***/ }),

/***/ "./node_modules/lodash/_createBaseFor.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash/_createBaseFor.js ***!
  \***********************************************/
/***/ ((module) => {

/**
 * Creates a base function for methods like `_.forIn` and `_.forOwn`.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseFor(fromRight) {
  return function(object, iteratee, keysFunc) {
    var index = -1,
        iterable = Object(object),
        props = keysFunc(object),
        length = props.length;

    while (length--) {
      var key = props[fromRight ? length : ++index];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}

module.exports = createBaseFor;


/***/ }),

/***/ "./node_modules/lodash/_createSet.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_createSet.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Set = __webpack_require__(/*! ./_Set */ "./node_modules/lodash/_Set.js"),
    noop = __webpack_require__(/*! ./noop */ "./node_modules/lodash/noop.js"),
    setToArray = __webpack_require__(/*! ./_setToArray */ "./node_modules/lodash/_setToArray.js");

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/**
 * Creates a set object of `values`.
 *
 * @private
 * @param {Array} values The values to add to the set.
 * @returns {Object} Returns the new set.
 */
var createSet = !(Set && (1 / setToArray(new Set([,-0]))[1]) == INFINITY) ? noop : function(values) {
  return new Set(values);
};

module.exports = createSet;


/***/ }),

/***/ "./node_modules/lodash/_defineProperty.js":
/*!************************************************!*\
  !*** ./node_modules/lodash/_defineProperty.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(/*! ./_getNative */ "./node_modules/lodash/_getNative.js");

var defineProperty = (function() {
  try {
    var func = getNative(Object, 'defineProperty');
    func({}, '', {});
    return func;
  } catch (e) {}
}());

module.exports = defineProperty;


/***/ }),

/***/ "./node_modules/lodash/_equalArrays.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_equalArrays.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var SetCache = __webpack_require__(/*! ./_SetCache */ "./node_modules/lodash/_SetCache.js"),
    arraySome = __webpack_require__(/*! ./_arraySome */ "./node_modules/lodash/_arraySome.js"),
    cacheHas = __webpack_require__(/*! ./_cacheHas */ "./node_modules/lodash/_cacheHas.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `array` and `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  // Check that cyclic values are equal.
  var arrStacked = stack.get(array);
  var othStacked = stack.get(other);
  if (arrStacked && othStacked) {
    return arrStacked == other && othStacked == array;
  }
  var index = -1,
      result = true,
      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined;

  stack.set(array, other);
  stack.set(other, array);

  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, arrValue, index, other, array, stack)
        : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== undefined) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (seen) {
      if (!arraySome(other, function(othValue, othIndex) {
            if (!cacheHas(seen, othIndex) &&
                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
        result = false;
        break;
      }
    } else if (!(
          arrValue === othValue ||
            equalFunc(arrValue, othValue, bitmask, customizer, stack)
        )) {
      result = false;
      break;
    }
  }
  stack['delete'](array);
  stack['delete'](other);
  return result;
}

module.exports = equalArrays;


/***/ }),

/***/ "./node_modules/lodash/_equalByTag.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_equalByTag.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(/*! ./_Symbol */ "./node_modules/lodash/_Symbol.js"),
    Uint8Array = __webpack_require__(/*! ./_Uint8Array */ "./node_modules/lodash/_Uint8Array.js"),
    eq = __webpack_require__(/*! ./eq */ "./node_modules/lodash/eq.js"),
    equalArrays = __webpack_require__(/*! ./_equalArrays */ "./node_modules/lodash/_equalArrays.js"),
    mapToArray = __webpack_require__(/*! ./_mapToArray */ "./node_modules/lodash/_mapToArray.js"),
    setToArray = __webpack_require__(/*! ./_setToArray */ "./node_modules/lodash/_setToArray.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/** `Object#toString` result references. */
var boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]';

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * A specialized version of `baseIsEqualDeep` for comparing objects of
 * the same `toStringTag`.
 *
 * **Note:** This function only supports comparing values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {string} tag The `toStringTag` of the objects to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  switch (tag) {
    case dataViewTag:
      if ((object.byteLength != other.byteLength) ||
          (object.byteOffset != other.byteOffset)) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;

    case arrayBufferTag:
      if ((object.byteLength != other.byteLength) ||
          !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
        return false;
      }
      return true;

    case boolTag:
    case dateTag:
    case numberTag:
      // Coerce booleans to `1` or `0` and dates to milliseconds.
      // Invalid dates are coerced to `NaN`.
      return eq(+object, +other);

    case errorTag:
      return object.name == other.name && object.message == other.message;

    case regexpTag:
    case stringTag:
      // Coerce regexes to strings and treat strings, primitives and objects,
      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
      // for more details.
      return object == (other + '');

    case mapTag:
      var convert = mapToArray;

    case setTag:
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
      convert || (convert = setToArray);

      if (object.size != other.size && !isPartial) {
        return false;
      }
      // Assume cyclic values are equal.
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= COMPARE_UNORDERED_FLAG;

      // Recursively compare objects (susceptible to call stack limits).
      stack.set(object, other);
      var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
      stack['delete'](object);
      return result;

    case symbolTag:
      if (symbolValueOf) {
        return symbolValueOf.call(object) == symbolValueOf.call(other);
      }
  }
  return false;
}

module.exports = equalByTag;


/***/ }),

/***/ "./node_modules/lodash/_equalObjects.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_equalObjects.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getAllKeys = __webpack_require__(/*! ./_getAllKeys */ "./node_modules/lodash/_getAllKeys.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1;

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqualDeep` for objects with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      objProps = getAllKeys(object),
      objLength = objProps.length,
      othProps = getAllKeys(other),
      othLength = othProps.length;

  if (objLength != othLength && !isPartial) {
    return false;
  }
  var index = objLength;
  while (index--) {
    var key = objProps[index];
    if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
      return false;
    }
  }
  // Check that cyclic values are equal.
  var objStacked = stack.get(object);
  var othStacked = stack.get(other);
  if (objStacked && othStacked) {
    return objStacked == other && othStacked == object;
  }
  var result = true;
  stack.set(object, other);
  stack.set(other, object);

  var skipCtor = isPartial;
  while (++index < objLength) {
    key = objProps[index];
    var objValue = object[key],
        othValue = other[key];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, objValue, key, other, object, stack)
        : customizer(objValue, othValue, key, object, other, stack);
    }
    // Recursively compare objects (susceptible to call stack limits).
    if (!(compared === undefined
          ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
          : compared
        )) {
      result = false;
      break;
    }
    skipCtor || (skipCtor = key == 'constructor');
  }
  if (result && !skipCtor) {
    var objCtor = object.constructor,
        othCtor = other.constructor;

    // Non `Object` object instances with different constructors are not equal.
    if (objCtor != othCtor &&
        ('constructor' in object && 'constructor' in other) &&
        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
          typeof othCtor == 'function' && othCtor instanceof othCtor)) {
      result = false;
    }
  }
  stack['delete'](object);
  stack['delete'](other);
  return result;
}

module.exports = equalObjects;


/***/ }),

/***/ "./node_modules/lodash/_freeGlobal.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_freeGlobal.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof __webpack_require__.g == 'object' && __webpack_require__.g && __webpack_require__.g.Object === Object && __webpack_require__.g;

module.exports = freeGlobal;


/***/ }),

/***/ "./node_modules/lodash/_getAllKeys.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_getAllKeys.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetAllKeys = __webpack_require__(/*! ./_baseGetAllKeys */ "./node_modules/lodash/_baseGetAllKeys.js"),
    getSymbols = __webpack_require__(/*! ./_getSymbols */ "./node_modules/lodash/_getSymbols.js"),
    keys = __webpack_require__(/*! ./keys */ "./node_modules/lodash/keys.js");

/**
 * Creates an array of own enumerable property names and symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeys(object) {
  return baseGetAllKeys(object, keys, getSymbols);
}

module.exports = getAllKeys;


/***/ }),

/***/ "./node_modules/lodash/_getAllKeysIn.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_getAllKeysIn.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetAllKeys = __webpack_require__(/*! ./_baseGetAllKeys */ "./node_modules/lodash/_baseGetAllKeys.js"),
    getSymbolsIn = __webpack_require__(/*! ./_getSymbolsIn */ "./node_modules/lodash/_getSymbolsIn.js"),
    keysIn = __webpack_require__(/*! ./keysIn */ "./node_modules/lodash/keysIn.js");

/**
 * Creates an array of own and inherited enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeysIn(object) {
  return baseGetAllKeys(object, keysIn, getSymbolsIn);
}

module.exports = getAllKeysIn;


/***/ }),

/***/ "./node_modules/lodash/_getMapData.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_getMapData.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isKeyable = __webpack_require__(/*! ./_isKeyable */ "./node_modules/lodash/_isKeyable.js");

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

module.exports = getMapData;


/***/ }),

/***/ "./node_modules/lodash/_getMatchData.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_getMatchData.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isStrictComparable = __webpack_require__(/*! ./_isStrictComparable */ "./node_modules/lodash/_isStrictComparable.js"),
    keys = __webpack_require__(/*! ./keys */ "./node_modules/lodash/keys.js");

/**
 * Gets the property names, values, and compare flags of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the match data of `object`.
 */
function getMatchData(object) {
  var result = keys(object),
      length = result.length;

  while (length--) {
    var key = result[length],
        value = object[key];

    result[length] = [key, value, isStrictComparable(value)];
  }
  return result;
}

module.exports = getMatchData;


/***/ }),

/***/ "./node_modules/lodash/_getNative.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_getNative.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsNative = __webpack_require__(/*! ./_baseIsNative */ "./node_modules/lodash/_baseIsNative.js"),
    getValue = __webpack_require__(/*! ./_getValue */ "./node_modules/lodash/_getValue.js");

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

module.exports = getNative;


/***/ }),

/***/ "./node_modules/lodash/_getPrototype.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_getPrototype.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var overArg = __webpack_require__(/*! ./_overArg */ "./node_modules/lodash/_overArg.js");

/** Built-in value references. */
var getPrototype = overArg(Object.getPrototypeOf, Object);

module.exports = getPrototype;


/***/ }),

/***/ "./node_modules/lodash/_getRawTag.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_getRawTag.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(/*! ./_Symbol */ "./node_modules/lodash/_Symbol.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty.call(value, symToStringTag),
      tag = value[symToStringTag];

  try {
    value[symToStringTag] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag] = tag;
    } else {
      delete value[symToStringTag];
    }
  }
  return result;
}

module.exports = getRawTag;


/***/ }),

/***/ "./node_modules/lodash/_getSymbols.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_getSymbols.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayFilter = __webpack_require__(/*! ./_arrayFilter */ "./node_modules/lodash/_arrayFilter.js"),
    stubArray = __webpack_require__(/*! ./stubArray */ "./node_modules/lodash/stubArray.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return arrayFilter(nativeGetSymbols(object), function(symbol) {
    return propertyIsEnumerable.call(object, symbol);
  });
};

module.exports = getSymbols;


/***/ }),

/***/ "./node_modules/lodash/_getSymbolsIn.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_getSymbolsIn.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayPush = __webpack_require__(/*! ./_arrayPush */ "./node_modules/lodash/_arrayPush.js"),
    getPrototype = __webpack_require__(/*! ./_getPrototype */ "./node_modules/lodash/_getPrototype.js"),
    getSymbols = __webpack_require__(/*! ./_getSymbols */ "./node_modules/lodash/_getSymbols.js"),
    stubArray = __webpack_require__(/*! ./stubArray */ "./node_modules/lodash/stubArray.js");

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own and inherited enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
  var result = [];
  while (object) {
    arrayPush(result, getSymbols(object));
    object = getPrototype(object);
  }
  return result;
};

module.exports = getSymbolsIn;


/***/ }),

/***/ "./node_modules/lodash/_getTag.js":
/*!****************************************!*\
  !*** ./node_modules/lodash/_getTag.js ***!
  \****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var DataView = __webpack_require__(/*! ./_DataView */ "./node_modules/lodash/_DataView.js"),
    Map = __webpack_require__(/*! ./_Map */ "./node_modules/lodash/_Map.js"),
    Promise = __webpack_require__(/*! ./_Promise */ "./node_modules/lodash/_Promise.js"),
    Set = __webpack_require__(/*! ./_Set */ "./node_modules/lodash/_Set.js"),
    WeakMap = __webpack_require__(/*! ./_WeakMap */ "./node_modules/lodash/_WeakMap.js"),
    baseGetTag = __webpack_require__(/*! ./_baseGetTag */ "./node_modules/lodash/_baseGetTag.js"),
    toSource = __webpack_require__(/*! ./_toSource */ "./node_modules/lodash/_toSource.js");

/** `Object#toString` result references. */
var mapTag = '[object Map]',
    objectTag = '[object Object]',
    promiseTag = '[object Promise]',
    setTag = '[object Set]',
    weakMapTag = '[object WeakMap]';

var dataViewTag = '[object DataView]';

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = toSource(DataView),
    mapCtorString = toSource(Map),
    promiseCtorString = toSource(Promise),
    setCtorString = toSource(Set),
    weakMapCtorString = toSource(WeakMap);

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = baseGetTag;

// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
    (Map && getTag(new Map) != mapTag) ||
    (Promise && getTag(Promise.resolve()) != promiseTag) ||
    (Set && getTag(new Set) != setTag) ||
    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
  getTag = function(value) {
    var result = baseGetTag(value),
        Ctor = result == objectTag ? value.constructor : undefined,
        ctorString = Ctor ? toSource(Ctor) : '';

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString: return dataViewTag;
        case mapCtorString: return mapTag;
        case promiseCtorString: return promiseTag;
        case setCtorString: return setTag;
        case weakMapCtorString: return weakMapTag;
      }
    }
    return result;
  };
}

module.exports = getTag;


/***/ }),

/***/ "./node_modules/lodash/_getValue.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_getValue.js ***!
  \******************************************/
/***/ ((module) => {

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

module.exports = getValue;


/***/ }),

/***/ "./node_modules/lodash/_hasPath.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_hasPath.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var castPath = __webpack_require__(/*! ./_castPath */ "./node_modules/lodash/_castPath.js"),
    isArguments = __webpack_require__(/*! ./isArguments */ "./node_modules/lodash/isArguments.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js"),
    isIndex = __webpack_require__(/*! ./_isIndex */ "./node_modules/lodash/_isIndex.js"),
    isLength = __webpack_require__(/*! ./isLength */ "./node_modules/lodash/isLength.js"),
    toKey = __webpack_require__(/*! ./_toKey */ "./node_modules/lodash/_toKey.js");

/**
 * Checks if `path` exists on `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @param {Function} hasFunc The function to check properties.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 */
function hasPath(object, path, hasFunc) {
  path = castPath(path, object);

  var index = -1,
      length = path.length,
      result = false;

  while (++index < length) {
    var key = toKey(path[index]);
    if (!(result = object != null && hasFunc(object, key))) {
      break;
    }
    object = object[key];
  }
  if (result || ++index != length) {
    return result;
  }
  length = object == null ? 0 : object.length;
  return !!length && isLength(length) && isIndex(key, length) &&
    (isArray(object) || isArguments(object));
}

module.exports = hasPath;


/***/ }),

/***/ "./node_modules/lodash/_hashClear.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_hashClear.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var nativeCreate = __webpack_require__(/*! ./_nativeCreate */ "./node_modules/lodash/_nativeCreate.js");

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
  this.size = 0;
}

module.exports = hashClear;


/***/ }),

/***/ "./node_modules/lodash/_hashDelete.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_hashDelete.js ***!
  \********************************************/
/***/ ((module) => {

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}

module.exports = hashDelete;


/***/ }),

/***/ "./node_modules/lodash/_hashGet.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_hashGet.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var nativeCreate = __webpack_require__(/*! ./_nativeCreate */ "./node_modules/lodash/_nativeCreate.js");

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED ? undefined : result;
  }
  return hasOwnProperty.call(data, key) ? data[key] : undefined;
}

module.exports = hashGet;


/***/ }),

/***/ "./node_modules/lodash/_hashHas.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_hashHas.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var nativeCreate = __webpack_require__(/*! ./_nativeCreate */ "./node_modules/lodash/_nativeCreate.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
}

module.exports = hashHas;


/***/ }),

/***/ "./node_modules/lodash/_hashSet.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_hashSet.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var nativeCreate = __webpack_require__(/*! ./_nativeCreate */ "./node_modules/lodash/_nativeCreate.js");

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

module.exports = hashSet;


/***/ }),

/***/ "./node_modules/lodash/_initCloneArray.js":
/*!************************************************!*\
  !*** ./node_modules/lodash/_initCloneArray.js ***!
  \************************************************/
/***/ ((module) => {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Initializes an array clone.
 *
 * @private
 * @param {Array} array The array to clone.
 * @returns {Array} Returns the initialized clone.
 */
function initCloneArray(array) {
  var length = array.length,
      result = new array.constructor(length);

  // Add properties assigned by `RegExp#exec`.
  if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
    result.index = array.index;
    result.input = array.input;
  }
  return result;
}

module.exports = initCloneArray;


/***/ }),

/***/ "./node_modules/lodash/_initCloneByTag.js":
/*!************************************************!*\
  !*** ./node_modules/lodash/_initCloneByTag.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var cloneArrayBuffer = __webpack_require__(/*! ./_cloneArrayBuffer */ "./node_modules/lodash/_cloneArrayBuffer.js"),
    cloneDataView = __webpack_require__(/*! ./_cloneDataView */ "./node_modules/lodash/_cloneDataView.js"),
    cloneRegExp = __webpack_require__(/*! ./_cloneRegExp */ "./node_modules/lodash/_cloneRegExp.js"),
    cloneSymbol = __webpack_require__(/*! ./_cloneSymbol */ "./node_modules/lodash/_cloneSymbol.js"),
    cloneTypedArray = __webpack_require__(/*! ./_cloneTypedArray */ "./node_modules/lodash/_cloneTypedArray.js");

/** `Object#toString` result references. */
var boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/**
 * Initializes an object clone based on its `toStringTag`.
 *
 * **Note:** This function only supports cloning values with tags of
 * `Boolean`, `Date`, `Error`, `Map`, `Number`, `RegExp`, `Set`, or `String`.
 *
 * @private
 * @param {Object} object The object to clone.
 * @param {string} tag The `toStringTag` of the object to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneByTag(object, tag, isDeep) {
  var Ctor = object.constructor;
  switch (tag) {
    case arrayBufferTag:
      return cloneArrayBuffer(object);

    case boolTag:
    case dateTag:
      return new Ctor(+object);

    case dataViewTag:
      return cloneDataView(object, isDeep);

    case float32Tag: case float64Tag:
    case int8Tag: case int16Tag: case int32Tag:
    case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:
      return cloneTypedArray(object, isDeep);

    case mapTag:
      return new Ctor;

    case numberTag:
    case stringTag:
      return new Ctor(object);

    case regexpTag:
      return cloneRegExp(object);

    case setTag:
      return new Ctor;

    case symbolTag:
      return cloneSymbol(object);
  }
}

module.exports = initCloneByTag;


/***/ }),

/***/ "./node_modules/lodash/_initCloneObject.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash/_initCloneObject.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseCreate = __webpack_require__(/*! ./_baseCreate */ "./node_modules/lodash/_baseCreate.js"),
    getPrototype = __webpack_require__(/*! ./_getPrototype */ "./node_modules/lodash/_getPrototype.js"),
    isPrototype = __webpack_require__(/*! ./_isPrototype */ "./node_modules/lodash/_isPrototype.js");

/**
 * Initializes an object clone.
 *
 * @private
 * @param {Object} object The object to clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneObject(object) {
  return (typeof object.constructor == 'function' && !isPrototype(object))
    ? baseCreate(getPrototype(object))
    : {};
}

module.exports = initCloneObject;


/***/ }),

/***/ "./node_modules/lodash/_isIndex.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_isIndex.js ***!
  \*****************************************/
/***/ ((module) => {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  var type = typeof value;
  length = length == null ? MAX_SAFE_INTEGER : length;

  return !!length &&
    (type == 'number' ||
      (type != 'symbol' && reIsUint.test(value))) &&
        (value > -1 && value % 1 == 0 && value < length);
}

module.exports = isIndex;


/***/ }),

/***/ "./node_modules/lodash/_isKey.js":
/*!***************************************!*\
  !*** ./node_modules/lodash/_isKey.js ***!
  \***************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js"),
    isSymbol = __webpack_require__(/*! ./isSymbol */ "./node_modules/lodash/isSymbol.js");

/** Used to match property names within property paths. */
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
    reIsPlainProp = /^\w*$/;

/**
 * Checks if `value` is a property name and not a property path.
 *
 * @private
 * @param {*} value The value to check.
 * @param {Object} [object] The object to query keys on.
 * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
 */
function isKey(value, object) {
  if (isArray(value)) {
    return false;
  }
  var type = typeof value;
  if (type == 'number' || type == 'symbol' || type == 'boolean' ||
      value == null || isSymbol(value)) {
    return true;
  }
  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
    (object != null && value in Object(object));
}

module.exports = isKey;


/***/ }),

/***/ "./node_modules/lodash/_isKeyable.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_isKeyable.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

module.exports = isKeyable;


/***/ }),

/***/ "./node_modules/lodash/_isMasked.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_isMasked.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var coreJsData = __webpack_require__(/*! ./_coreJsData */ "./node_modules/lodash/_coreJsData.js");

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

module.exports = isMasked;


/***/ }),

/***/ "./node_modules/lodash/_isPrototype.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_isPrototype.js ***!
  \*********************************************/
/***/ ((module) => {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

  return value === proto;
}

module.exports = isPrototype;


/***/ }),

/***/ "./node_modules/lodash/_isStrictComparable.js":
/*!****************************************************!*\
  !*** ./node_modules/lodash/_isStrictComparable.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(/*! ./isObject */ "./node_modules/lodash/isObject.js");

/**
 * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` if suitable for strict
 *  equality comparisons, else `false`.
 */
function isStrictComparable(value) {
  return value === value && !isObject(value);
}

module.exports = isStrictComparable;


/***/ }),

/***/ "./node_modules/lodash/_listCacheClear.js":
/*!************************************************!*\
  !*** ./node_modules/lodash/_listCacheClear.js ***!
  \************************************************/
/***/ ((module) => {

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}

module.exports = listCacheClear;


/***/ }),

/***/ "./node_modules/lodash/_listCacheDelete.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash/_listCacheDelete.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assocIndexOf = __webpack_require__(/*! ./_assocIndexOf */ "./node_modules/lodash/_assocIndexOf.js");

/** Used for built-in method references. */
var arrayProto = Array.prototype;

/** Built-in value references. */
var splice = arrayProto.splice;

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}

module.exports = listCacheDelete;


/***/ }),

/***/ "./node_modules/lodash/_listCacheGet.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_listCacheGet.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assocIndexOf = __webpack_require__(/*! ./_assocIndexOf */ "./node_modules/lodash/_assocIndexOf.js");

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

module.exports = listCacheGet;


/***/ }),

/***/ "./node_modules/lodash/_listCacheHas.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_listCacheHas.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assocIndexOf = __webpack_require__(/*! ./_assocIndexOf */ "./node_modules/lodash/_assocIndexOf.js");

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}

module.exports = listCacheHas;


/***/ }),

/***/ "./node_modules/lodash/_listCacheSet.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_listCacheSet.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assocIndexOf = __webpack_require__(/*! ./_assocIndexOf */ "./node_modules/lodash/_assocIndexOf.js");

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

module.exports = listCacheSet;


/***/ }),

/***/ "./node_modules/lodash/_mapCacheClear.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash/_mapCacheClear.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Hash = __webpack_require__(/*! ./_Hash */ "./node_modules/lodash/_Hash.js"),
    ListCache = __webpack_require__(/*! ./_ListCache */ "./node_modules/lodash/_ListCache.js"),
    Map = __webpack_require__(/*! ./_Map */ "./node_modules/lodash/_Map.js");

/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    'hash': new Hash,
    'map': new (Map || ListCache),
    'string': new Hash
  };
}

module.exports = mapCacheClear;


/***/ }),

/***/ "./node_modules/lodash/_mapCacheDelete.js":
/*!************************************************!*\
  !*** ./node_modules/lodash/_mapCacheDelete.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getMapData = __webpack_require__(/*! ./_getMapData */ "./node_modules/lodash/_getMapData.js");

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}

module.exports = mapCacheDelete;


/***/ }),

/***/ "./node_modules/lodash/_mapCacheGet.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_mapCacheGet.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getMapData = __webpack_require__(/*! ./_getMapData */ "./node_modules/lodash/_getMapData.js");

/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}

module.exports = mapCacheGet;


/***/ }),

/***/ "./node_modules/lodash/_mapCacheHas.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_mapCacheHas.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getMapData = __webpack_require__(/*! ./_getMapData */ "./node_modules/lodash/_getMapData.js");

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}

module.exports = mapCacheHas;


/***/ }),

/***/ "./node_modules/lodash/_mapCacheSet.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_mapCacheSet.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getMapData = __webpack_require__(/*! ./_getMapData */ "./node_modules/lodash/_getMapData.js");

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  var data = getMapData(this, key),
      size = data.size;

  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}

module.exports = mapCacheSet;


/***/ }),

/***/ "./node_modules/lodash/_mapToArray.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_mapToArray.js ***!
  \********************************************/
/***/ ((module) => {

/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */
function mapToArray(map) {
  var index = -1,
      result = Array(map.size);

  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}

module.exports = mapToArray;


/***/ }),

/***/ "./node_modules/lodash/_matchesStrictComparable.js":
/*!*********************************************************!*\
  !*** ./node_modules/lodash/_matchesStrictComparable.js ***!
  \*********************************************************/
/***/ ((module) => {

/**
 * A specialized version of `matchesProperty` for source values suitable
 * for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function matchesStrictComparable(key, srcValue) {
  return function(object) {
    if (object == null) {
      return false;
    }
    return object[key] === srcValue &&
      (srcValue !== undefined || (key in Object(object)));
  };
}

module.exports = matchesStrictComparable;


/***/ }),

/***/ "./node_modules/lodash/_memoizeCapped.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash/_memoizeCapped.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var memoize = __webpack_require__(/*! ./memoize */ "./node_modules/lodash/memoize.js");

/** Used as the maximum memoize cache size. */
var MAX_MEMOIZE_SIZE = 500;

/**
 * A specialized version of `_.memoize` which clears the memoized function's
 * cache when it exceeds `MAX_MEMOIZE_SIZE`.
 *
 * @private
 * @param {Function} func The function to have its output memoized.
 * @returns {Function} Returns the new memoized function.
 */
function memoizeCapped(func) {
  var result = memoize(func, function(key) {
    if (cache.size === MAX_MEMOIZE_SIZE) {
      cache.clear();
    }
    return key;
  });

  var cache = result.cache;
  return result;
}

module.exports = memoizeCapped;


/***/ }),

/***/ "./node_modules/lodash/_nativeCreate.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_nativeCreate.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(/*! ./_getNative */ "./node_modules/lodash/_getNative.js");

/* Built-in method references that are verified to be native. */
var nativeCreate = getNative(Object, 'create');

module.exports = nativeCreate;


/***/ }),

/***/ "./node_modules/lodash/_nativeKeys.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_nativeKeys.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var overArg = __webpack_require__(/*! ./_overArg */ "./node_modules/lodash/_overArg.js");

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeKeys = overArg(Object.keys, Object);

module.exports = nativeKeys;


/***/ }),

/***/ "./node_modules/lodash/_nativeKeysIn.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_nativeKeysIn.js ***!
  \**********************************************/
/***/ ((module) => {

/**
 * This function is like
 * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * except that it includes inherited enumerable properties.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function nativeKeysIn(object) {
  var result = [];
  if (object != null) {
    for (var key in Object(object)) {
      result.push(key);
    }
  }
  return result;
}

module.exports = nativeKeysIn;


/***/ }),

/***/ "./node_modules/lodash/_nodeUtil.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_nodeUtil.js ***!
  \******************************************/
/***/ ((module, exports, __webpack_require__) => {

/* module decorator */ module = __webpack_require__.nmd(module);
var freeGlobal = __webpack_require__(/*! ./_freeGlobal */ "./node_modules/lodash/_freeGlobal.js");

/** Detect free variable `exports`. */
var freeExports =  true && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && "object" == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Detect free variable `process` from Node.js. */
var freeProcess = moduleExports && freeGlobal.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = (function() {
  try {
    // Use `util.types` for Node.js 10+.
    var types = freeModule && freeModule.require && freeModule.require('util').types;

    if (types) {
      return types;
    }

    // Legacy `process.binding('util')` for Node.js < 10.
    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  } catch (e) {}
}());

module.exports = nodeUtil;


/***/ }),

/***/ "./node_modules/lodash/_objectToString.js":
/*!************************************************!*\
  !*** ./node_modules/lodash/_objectToString.js ***!
  \************************************************/
/***/ ((module) => {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

module.exports = objectToString;


/***/ }),

/***/ "./node_modules/lodash/_overArg.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_overArg.js ***!
  \*****************************************/
/***/ ((module) => {

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

module.exports = overArg;


/***/ }),

/***/ "./node_modules/lodash/_root.js":
/*!**************************************!*\
  !*** ./node_modules/lodash/_root.js ***!
  \**************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var freeGlobal = __webpack_require__(/*! ./_freeGlobal */ "./node_modules/lodash/_freeGlobal.js");

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

module.exports = root;


/***/ }),

/***/ "./node_modules/lodash/_setCacheAdd.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_setCacheAdd.js ***!
  \*********************************************/
/***/ ((module) => {

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Adds `value` to the array cache.
 *
 * @private
 * @name add
 * @memberOf SetCache
 * @alias push
 * @param {*} value The value to cache.
 * @returns {Object} Returns the cache instance.
 */
function setCacheAdd(value) {
  this.__data__.set(value, HASH_UNDEFINED);
  return this;
}

module.exports = setCacheAdd;


/***/ }),

/***/ "./node_modules/lodash/_setCacheHas.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_setCacheHas.js ***!
  \*********************************************/
/***/ ((module) => {

/**
 * Checks if `value` is in the array cache.
 *
 * @private
 * @name has
 * @memberOf SetCache
 * @param {*} value The value to search for.
 * @returns {number} Returns `true` if `value` is found, else `false`.
 */
function setCacheHas(value) {
  return this.__data__.has(value);
}

module.exports = setCacheHas;


/***/ }),

/***/ "./node_modules/lodash/_setToArray.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_setToArray.js ***!
  \********************************************/
/***/ ((module) => {

/**
 * Converts `set` to an array of its values.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the values.
 */
function setToArray(set) {
  var index = -1,
      result = Array(set.size);

  set.forEach(function(value) {
    result[++index] = value;
  });
  return result;
}

module.exports = setToArray;


/***/ }),

/***/ "./node_modules/lodash/_stackClear.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_stackClear.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var ListCache = __webpack_require__(/*! ./_ListCache */ "./node_modules/lodash/_ListCache.js");

/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new ListCache;
  this.size = 0;
}

module.exports = stackClear;


/***/ }),

/***/ "./node_modules/lodash/_stackDelete.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_stackDelete.js ***!
  \*********************************************/
/***/ ((module) => {

/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  var data = this.__data__,
      result = data['delete'](key);

  this.size = data.size;
  return result;
}

module.exports = stackDelete;


/***/ }),

/***/ "./node_modules/lodash/_stackGet.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_stackGet.js ***!
  \******************************************/
/***/ ((module) => {

/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}

module.exports = stackGet;


/***/ }),

/***/ "./node_modules/lodash/_stackHas.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_stackHas.js ***!
  \******************************************/
/***/ ((module) => {

/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

module.exports = stackHas;


/***/ }),

/***/ "./node_modules/lodash/_stackSet.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_stackSet.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var ListCache = __webpack_require__(/*! ./_ListCache */ "./node_modules/lodash/_ListCache.js"),
    Map = __webpack_require__(/*! ./_Map */ "./node_modules/lodash/_Map.js"),
    MapCache = __webpack_require__(/*! ./_MapCache */ "./node_modules/lodash/_MapCache.js");

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var data = this.__data__;
  if (data instanceof ListCache) {
    var pairs = data.__data__;
    if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
      pairs.push([key, value]);
      this.size = ++data.size;
      return this;
    }
    data = this.__data__ = new MapCache(pairs);
  }
  data.set(key, value);
  this.size = data.size;
  return this;
}

module.exports = stackSet;


/***/ }),

/***/ "./node_modules/lodash/_strictIndexOf.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash/_strictIndexOf.js ***!
  \***********************************************/
/***/ ((module) => {

/**
 * A specialized version of `_.indexOf` which performs strict equality
 * comparisons of values, i.e. `===`.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function strictIndexOf(array, value, fromIndex) {
  var index = fromIndex - 1,
      length = array.length;

  while (++index < length) {
    if (array[index] === value) {
      return index;
    }
  }
  return -1;
}

module.exports = strictIndexOf;


/***/ }),

/***/ "./node_modules/lodash/_stringToPath.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_stringToPath.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var memoizeCapped = __webpack_require__(/*! ./_memoizeCapped */ "./node_modules/lodash/_memoizeCapped.js");

/** Used to match property names within property paths. */
var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;

/** Used to match backslashes in property paths. */
var reEscapeChar = /\\(\\)?/g;

/**
 * Converts `string` to a property path array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the property path array.
 */
var stringToPath = memoizeCapped(function(string) {
  var result = [];
  if (string.charCodeAt(0) === 46 /* . */) {
    result.push('');
  }
  string.replace(rePropName, function(match, number, quote, subString) {
    result.push(quote ? subString.replace(reEscapeChar, '$1') : (number || match));
  });
  return result;
});

module.exports = stringToPath;


/***/ }),

/***/ "./node_modules/lodash/_toKey.js":
/*!***************************************!*\
  !*** ./node_modules/lodash/_toKey.js ***!
  \***************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isSymbol = __webpack_require__(/*! ./isSymbol */ "./node_modules/lodash/isSymbol.js");

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/**
 * Converts `value` to a string key if it's not a string or symbol.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {string|symbol} Returns the key.
 */
function toKey(value) {
  if (typeof value == 'string' || isSymbol(value)) {
    return value;
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

module.exports = toKey;


/***/ }),

/***/ "./node_modules/lodash/_toSource.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_toSource.js ***!
  \******************************************/
/***/ ((module) => {

/** Used for built-in method references. */
var funcProto = Function.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to convert.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

module.exports = toSource;


/***/ }),

/***/ "./node_modules/lodash/_trimmedEndIndex.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash/_trimmedEndIndex.js ***!
  \*************************************************/
/***/ ((module) => {

/** Used to match a single whitespace character. */
var reWhitespace = /\s/;

/**
 * Used by `_.trim` and `_.trimEnd` to get the index of the last non-whitespace
 * character of `string`.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {number} Returns the index of the last non-whitespace character.
 */
function trimmedEndIndex(string) {
  var index = string.length;

  while (index-- && reWhitespace.test(string.charAt(index))) {}
  return index;
}

module.exports = trimmedEndIndex;


/***/ }),

/***/ "./node_modules/lodash/castArray.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/castArray.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js");

/**
 * Casts `value` as an array if it's not one.
 *
 * @static
 * @memberOf _
 * @since 4.4.0
 * @category Lang
 * @param {*} value The value to inspect.
 * @returns {Array} Returns the cast array.
 * @example
 *
 * _.castArray(1);
 * // => [1]
 *
 * _.castArray({ 'a': 1 });
 * // => [{ 'a': 1 }]
 *
 * _.castArray('abc');
 * // => ['abc']
 *
 * _.castArray(null);
 * // => [null]
 *
 * _.castArray(undefined);
 * // => [undefined]
 *
 * _.castArray();
 * // => []
 *
 * var array = [1, 2, 3];
 * console.log(_.castArray(array) === array);
 * // => true
 */
function castArray() {
  if (!arguments.length) {
    return [];
  }
  var value = arguments[0];
  return isArray(value) ? value : [value];
}

module.exports = castArray;


/***/ }),

/***/ "./node_modules/lodash/cloneDeep.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/cloneDeep.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseClone = __webpack_require__(/*! ./_baseClone */ "./node_modules/lodash/_baseClone.js");

/** Used to compose bitmasks for cloning. */
var CLONE_DEEP_FLAG = 1,
    CLONE_SYMBOLS_FLAG = 4;

/**
 * This method is like `_.clone` except that it recursively clones `value`.
 *
 * @static
 * @memberOf _
 * @since 1.0.0
 * @category Lang
 * @param {*} value The value to recursively clone.
 * @returns {*} Returns the deep cloned value.
 * @see _.clone
 * @example
 *
 * var objects = [{ 'a': 1 }, { 'b': 2 }];
 *
 * var deep = _.cloneDeep(objects);
 * console.log(deep[0] === objects[0]);
 * // => false
 */
function cloneDeep(value) {
  return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG);
}

module.exports = cloneDeep;


/***/ }),

/***/ "./node_modules/lodash/debounce.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/debounce.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(/*! ./isObject */ "./node_modules/lodash/isObject.js"),
    now = __webpack_require__(/*! ./now */ "./node_modules/lodash/now.js"),
    toNumber = __webpack_require__(/*! ./toNumber */ "./node_modules/lodash/toNumber.js");

/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max,
    nativeMin = Math.min;

/**
 * Creates a debounced function that delays invoking `func` until after `wait`
 * milliseconds have elapsed since the last time the debounced function was
 * invoked. The debounced function comes with a `cancel` method to cancel
 * delayed `func` invocations and a `flush` method to immediately invoke them.
 * Provide `options` to indicate whether `func` should be invoked on the
 * leading and/or trailing edge of the `wait` timeout. The `func` is invoked
 * with the last arguments provided to the debounced function. Subsequent
 * calls to the debounced function return the result of the last `func`
 * invocation.
 *
 * **Note:** If `leading` and `trailing` options are `true`, `func` is
 * invoked on the trailing edge of the timeout only if the debounced function
 * is invoked more than once during the `wait` timeout.
 *
 * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
 * until to the next tick, similar to `setTimeout` with a timeout of `0`.
 *
 * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
 * for details over the differences between `_.debounce` and `_.throttle`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to debounce.
 * @param {number} [wait=0] The number of milliseconds to delay.
 * @param {Object} [options={}] The options object.
 * @param {boolean} [options.leading=false]
 *  Specify invoking on the leading edge of the timeout.
 * @param {number} [options.maxWait]
 *  The maximum time `func` is allowed to be delayed before it's invoked.
 * @param {boolean} [options.trailing=true]
 *  Specify invoking on the trailing edge of the timeout.
 * @returns {Function} Returns the new debounced function.
 * @example
 *
 * // Avoid costly calculations while the window size is in flux.
 * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
 *
 * // Invoke `sendMail` when clicked, debouncing subsequent calls.
 * jQuery(element).on('click', _.debounce(sendMail, 300, {
 *   'leading': true,
 *   'trailing': false
 * }));
 *
 * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
 * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });
 * var source = new EventSource('/stream');
 * jQuery(source).on('message', debounced);
 *
 * // Cancel the trailing debounced invocation.
 * jQuery(window).on('popstate', debounced.cancel);
 */
function debounce(func, wait, options) {
  var lastArgs,
      lastThis,
      maxWait,
      result,
      timerId,
      lastCallTime,
      lastInvokeTime = 0,
      leading = false,
      maxing = false,
      trailing = true;

  if (typeof func != 'function') {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  wait = toNumber(wait) || 0;
  if (isObject(options)) {
    leading = !!options.leading;
    maxing = 'maxWait' in options;
    maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
    trailing = 'trailing' in options ? !!options.trailing : trailing;
  }

  function invokeFunc(time) {
    var args = lastArgs,
        thisArg = lastThis;

    lastArgs = lastThis = undefined;
    lastInvokeTime = time;
    result = func.apply(thisArg, args);
    return result;
  }

  function leadingEdge(time) {
    // Reset any `maxWait` timer.
    lastInvokeTime = time;
    // Start the timer for the trailing edge.
    timerId = setTimeout(timerExpired, wait);
    // Invoke the leading edge.
    return leading ? invokeFunc(time) : result;
  }

  function remainingWait(time) {
    var timeSinceLastCall = time - lastCallTime,
        timeSinceLastInvoke = time - lastInvokeTime,
        timeWaiting = wait - timeSinceLastCall;

    return maxing
      ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke)
      : timeWaiting;
  }

  function shouldInvoke(time) {
    var timeSinceLastCall = time - lastCallTime,
        timeSinceLastInvoke = time - lastInvokeTime;

    // Either this is the first call, activity has stopped and we're at the
    // trailing edge, the system time has gone backwards and we're treating
    // it as the trailing edge, or we've hit the `maxWait` limit.
    return (lastCallTime === undefined || (timeSinceLastCall >= wait) ||
      (timeSinceLastCall < 0) || (maxing && timeSinceLastInvoke >= maxWait));
  }

  function timerExpired() {
    var time = now();
    if (shouldInvoke(time)) {
      return trailingEdge(time);
    }
    // Restart the timer.
    timerId = setTimeout(timerExpired, remainingWait(time));
  }

  function trailingEdge(time) {
    timerId = undefined;

    // Only invoke if we have `lastArgs` which means `func` has been
    // debounced at least once.
    if (trailing && lastArgs) {
      return invokeFunc(time);
    }
    lastArgs = lastThis = undefined;
    return result;
  }

  function cancel() {
    if (timerId !== undefined) {
      clearTimeout(timerId);
    }
    lastInvokeTime = 0;
    lastArgs = lastCallTime = lastThis = timerId = undefined;
  }

  function flush() {
    return timerId === undefined ? result : trailingEdge(now());
  }

  function debounced() {
    var time = now(),
        isInvoking = shouldInvoke(time);

    lastArgs = arguments;
    lastThis = this;
    lastCallTime = time;

    if (isInvoking) {
      if (timerId === undefined) {
        return leadingEdge(lastCallTime);
      }
      if (maxing) {
        // Handle invocations in a tight loop.
        clearTimeout(timerId);
        timerId = setTimeout(timerExpired, wait);
        return invokeFunc(lastCallTime);
      }
    }
    if (timerId === undefined) {
      timerId = setTimeout(timerExpired, wait);
    }
    return result;
  }
  debounced.cancel = cancel;
  debounced.flush = flush;
  return debounced;
}

module.exports = debounce;


/***/ }),

/***/ "./node_modules/lodash/eq.js":
/*!***********************************!*\
  !*** ./node_modules/lodash/eq.js ***!
  \***********************************/
/***/ ((module) => {

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

module.exports = eq;


/***/ }),

/***/ "./node_modules/lodash/get.js":
/*!************************************!*\
  !*** ./node_modules/lodash/get.js ***!
  \************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGet = __webpack_require__(/*! ./_baseGet */ "./node_modules/lodash/_baseGet.js");

/**
 * Gets the value at `path` of `object`. If the resolved value is
 * `undefined`, the `defaultValue` is returned in its place.
 *
 * @static
 * @memberOf _
 * @since 3.7.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @param {*} [defaultValue] The value returned for `undefined` resolved values.
 * @returns {*} Returns the resolved value.
 * @example
 *
 * var object = { 'a': [{ 'b': { 'c': 3 } }] };
 *
 * _.get(object, 'a[0].b.c');
 * // => 3
 *
 * _.get(object, ['a', '0', 'b', 'c']);
 * // => 3
 *
 * _.get(object, 'a.b.c', 'default');
 * // => 'default'
 */
function get(object, path, defaultValue) {
  var result = object == null ? undefined : baseGet(object, path);
  return result === undefined ? defaultValue : result;
}

module.exports = get;


/***/ }),

/***/ "./node_modules/lodash/hasIn.js":
/*!**************************************!*\
  !*** ./node_modules/lodash/hasIn.js ***!
  \**************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseHasIn = __webpack_require__(/*! ./_baseHasIn */ "./node_modules/lodash/_baseHasIn.js"),
    hasPath = __webpack_require__(/*! ./_hasPath */ "./node_modules/lodash/_hasPath.js");

/**
 * Checks if `path` is a direct or inherited property of `object`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 * @example
 *
 * var object = _.create({ 'a': _.create({ 'b': 2 }) });
 *
 * _.hasIn(object, 'a');
 * // => true
 *
 * _.hasIn(object, 'a.b');
 * // => true
 *
 * _.hasIn(object, ['a', 'b']);
 * // => true
 *
 * _.hasIn(object, 'b');
 * // => false
 */
function hasIn(object, path) {
  return object != null && hasPath(object, path, baseHasIn);
}

module.exports = hasIn;


/***/ }),

/***/ "./node_modules/lodash/identity.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/identity.js ***!
  \*****************************************/
/***/ ((module) => {

/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity(value) {
  return value;
}

module.exports = identity;


/***/ }),

/***/ "./node_modules/lodash/isArguments.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/isArguments.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsArguments = __webpack_require__(/*! ./_baseIsArguments */ "./node_modules/lodash/_baseIsArguments.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "./node_modules/lodash/isObjectLike.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
  return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
    !propertyIsEnumerable.call(value, 'callee');
};

module.exports = isArguments;


/***/ }),

/***/ "./node_modules/lodash/isArray.js":
/*!****************************************!*\
  !*** ./node_modules/lodash/isArray.js ***!
  \****************************************/
/***/ ((module) => {

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

module.exports = isArray;


/***/ }),

/***/ "./node_modules/lodash/isArrayLike.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/isArrayLike.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isFunction = __webpack_require__(/*! ./isFunction */ "./node_modules/lodash/isFunction.js"),
    isLength = __webpack_require__(/*! ./isLength */ "./node_modules/lodash/isLength.js");

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

module.exports = isArrayLike;


/***/ }),

/***/ "./node_modules/lodash/isBuffer.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/isBuffer.js ***!
  \*****************************************/
/***/ ((module, exports, __webpack_require__) => {

/* module decorator */ module = __webpack_require__.nmd(module);
var root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js"),
    stubFalse = __webpack_require__(/*! ./stubFalse */ "./node_modules/lodash/stubFalse.js");

/** Detect free variable `exports`. */
var freeExports =  true && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && "object" == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse;

module.exports = isBuffer;


/***/ }),

/***/ "./node_modules/lodash/isEqual.js":
/*!****************************************!*\
  !*** ./node_modules/lodash/isEqual.js ***!
  \****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsEqual = __webpack_require__(/*! ./_baseIsEqual */ "./node_modules/lodash/_baseIsEqual.js");

/**
 * Performs a deep comparison between two values to determine if they are
 * equivalent.
 *
 * **Note:** This method supports comparing arrays, array buffers, booleans,
 * date objects, error objects, maps, numbers, `Object` objects, regexes,
 * sets, strings, symbols, and typed arrays. `Object` objects are compared
 * by their own, not inherited, enumerable properties. Functions and DOM
 * nodes are compared by strict equality, i.e. `===`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.isEqual(object, other);
 * // => true
 *
 * object === other;
 * // => false
 */
function isEqual(value, other) {
  return baseIsEqual(value, other);
}

module.exports = isEqual;


/***/ }),

/***/ "./node_modules/lodash/isFunction.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/isFunction.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(/*! ./_baseGetTag */ "./node_modules/lodash/_baseGetTag.js"),
    isObject = __webpack_require__(/*! ./isObject */ "./node_modules/lodash/isObject.js");

/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}

module.exports = isFunction;


/***/ }),

/***/ "./node_modules/lodash/isLength.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/isLength.js ***!
  \*****************************************/
/***/ ((module) => {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

module.exports = isLength;


/***/ }),

/***/ "./node_modules/lodash/isMap.js":
/*!**************************************!*\
  !*** ./node_modules/lodash/isMap.js ***!
  \**************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsMap = __webpack_require__(/*! ./_baseIsMap */ "./node_modules/lodash/_baseIsMap.js"),
    baseUnary = __webpack_require__(/*! ./_baseUnary */ "./node_modules/lodash/_baseUnary.js"),
    nodeUtil = __webpack_require__(/*! ./_nodeUtil */ "./node_modules/lodash/_nodeUtil.js");

/* Node.js helper references. */
var nodeIsMap = nodeUtil && nodeUtil.isMap;

/**
 * Checks if `value` is classified as a `Map` object.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a map, else `false`.
 * @example
 *
 * _.isMap(new Map);
 * // => true
 *
 * _.isMap(new WeakMap);
 * // => false
 */
var isMap = nodeIsMap ? baseUnary(nodeIsMap) : baseIsMap;

module.exports = isMap;


/***/ }),

/***/ "./node_modules/lodash/isObject.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/isObject.js ***!
  \*****************************************/
/***/ ((module) => {

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

module.exports = isObject;


/***/ }),

/***/ "./node_modules/lodash/isObjectLike.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/isObjectLike.js ***!
  \*********************************************/
/***/ ((module) => {

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

module.exports = isObjectLike;


/***/ }),

/***/ "./node_modules/lodash/isPlainObject.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/isPlainObject.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(/*! ./_baseGetTag */ "./node_modules/lodash/_baseGetTag.js"),
    getPrototype = __webpack_require__(/*! ./_getPrototype */ "./node_modules/lodash/_getPrototype.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "./node_modules/lodash/isObjectLike.js");

/** `Object#toString` result references. */
var objectTag = '[object Object]';

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to infer the `Object` constructor. */
var objectCtorString = funcToString.call(Object);

/**
 * Checks if `value` is a plain object, that is, an object created by the
 * `Object` constructor or one with a `[[Prototype]]` of `null`.
 *
 * @static
 * @memberOf _
 * @since 0.8.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 * }
 *
 * _.isPlainObject(new Foo);
 * // => false
 *
 * _.isPlainObject([1, 2, 3]);
 * // => false
 *
 * _.isPlainObject({ 'x': 0, 'y': 0 });
 * // => true
 *
 * _.isPlainObject(Object.create(null));
 * // => true
 */
function isPlainObject(value) {
  if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
    return false;
  }
  var proto = getPrototype(value);
  if (proto === null) {
    return true;
  }
  var Ctor = hasOwnProperty.call(proto, 'constructor') && proto.constructor;
  return typeof Ctor == 'function' && Ctor instanceof Ctor &&
    funcToString.call(Ctor) == objectCtorString;
}

module.exports = isPlainObject;


/***/ }),

/***/ "./node_modules/lodash/isSet.js":
/*!**************************************!*\
  !*** ./node_modules/lodash/isSet.js ***!
  \**************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsSet = __webpack_require__(/*! ./_baseIsSet */ "./node_modules/lodash/_baseIsSet.js"),
    baseUnary = __webpack_require__(/*! ./_baseUnary */ "./node_modules/lodash/_baseUnary.js"),
    nodeUtil = __webpack_require__(/*! ./_nodeUtil */ "./node_modules/lodash/_nodeUtil.js");

/* Node.js helper references. */
var nodeIsSet = nodeUtil && nodeUtil.isSet;

/**
 * Checks if `value` is classified as a `Set` object.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a set, else `false`.
 * @example
 *
 * _.isSet(new Set);
 * // => true
 *
 * _.isSet(new WeakSet);
 * // => false
 */
var isSet = nodeIsSet ? baseUnary(nodeIsSet) : baseIsSet;

module.exports = isSet;


/***/ }),

/***/ "./node_modules/lodash/isSymbol.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/isSymbol.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(/*! ./_baseGetTag */ "./node_modules/lodash/_baseGetTag.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "./node_modules/lodash/isObjectLike.js");

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && baseGetTag(value) == symbolTag);
}

module.exports = isSymbol;


/***/ }),

/***/ "./node_modules/lodash/isTypedArray.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/isTypedArray.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsTypedArray = __webpack_require__(/*! ./_baseIsTypedArray */ "./node_modules/lodash/_baseIsTypedArray.js"),
    baseUnary = __webpack_require__(/*! ./_baseUnary */ "./node_modules/lodash/_baseUnary.js"),
    nodeUtil = __webpack_require__(/*! ./_nodeUtil */ "./node_modules/lodash/_nodeUtil.js");

/* Node.js helper references. */
var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

module.exports = isTypedArray;


/***/ }),

/***/ "./node_modules/lodash/keys.js":
/*!*************************************!*\
  !*** ./node_modules/lodash/keys.js ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayLikeKeys = __webpack_require__(/*! ./_arrayLikeKeys */ "./node_modules/lodash/_arrayLikeKeys.js"),
    baseKeys = __webpack_require__(/*! ./_baseKeys */ "./node_modules/lodash/_baseKeys.js"),
    isArrayLike = __webpack_require__(/*! ./isArrayLike */ "./node_modules/lodash/isArrayLike.js");

/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}

module.exports = keys;


/***/ }),

/***/ "./node_modules/lodash/keysIn.js":
/*!***************************************!*\
  !*** ./node_modules/lodash/keysIn.js ***!
  \***************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayLikeKeys = __webpack_require__(/*! ./_arrayLikeKeys */ "./node_modules/lodash/_arrayLikeKeys.js"),
    baseKeysIn = __webpack_require__(/*! ./_baseKeysIn */ "./node_modules/lodash/_baseKeysIn.js"),
    isArrayLike = __webpack_require__(/*! ./isArrayLike */ "./node_modules/lodash/isArrayLike.js");

/**
 * Creates an array of the own and inherited enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keysIn(new Foo);
 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
 */
function keysIn(object) {
  return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
}

module.exports = keysIn;


/***/ }),

/***/ "./node_modules/lodash/map.js":
/*!************************************!*\
  !*** ./node_modules/lodash/map.js ***!
  \************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayMap = __webpack_require__(/*! ./_arrayMap */ "./node_modules/lodash/_arrayMap.js"),
    baseIteratee = __webpack_require__(/*! ./_baseIteratee */ "./node_modules/lodash/_baseIteratee.js"),
    baseMap = __webpack_require__(/*! ./_baseMap */ "./node_modules/lodash/_baseMap.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js");

/**
 * Creates an array of values by running each element in `collection` thru
 * `iteratee`. The iteratee is invoked with three arguments:
 * (value, index|key, collection).
 *
 * Many lodash methods are guarded to work as iteratees for methods like
 * `_.every`, `_.filter`, `_.map`, `_.mapValues`, `_.reject`, and `_.some`.
 *
 * The guarded methods are:
 * `ary`, `chunk`, `curry`, `curryRight`, `drop`, `dropRight`, `every`,
 * `fill`, `invert`, `parseInt`, `random`, `range`, `rangeRight`, `repeat`,
 * `sampleSize`, `slice`, `some`, `sortBy`, `split`, `take`, `takeRight`,
 * `template`, `trim`, `trimEnd`, `trimStart`, and `words`
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Collection
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} [iteratee=_.identity] The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 * @example
 *
 * function square(n) {
 *   return n * n;
 * }
 *
 * _.map([4, 8], square);
 * // => [16, 64]
 *
 * _.map({ 'a': 4, 'b': 8 }, square);
 * // => [16, 64] (iteration order is not guaranteed)
 *
 * var users = [
 *   { 'user': 'barney' },
 *   { 'user': 'fred' }
 * ];
 *
 * // The `_.property` iteratee shorthand.
 * _.map(users, 'user');
 * // => ['barney', 'fred']
 */
function map(collection, iteratee) {
  var func = isArray(collection) ? arrayMap : baseMap;
  return func(collection, baseIteratee(iteratee, 3));
}

module.exports = map;


/***/ }),

/***/ "./node_modules/lodash/memoize.js":
/*!****************************************!*\
  !*** ./node_modules/lodash/memoize.js ***!
  \****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var MapCache = __webpack_require__(/*! ./_MapCache */ "./node_modules/lodash/_MapCache.js");

/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/**
 * Creates a function that memoizes the result of `func`. If `resolver` is
 * provided, it determines the cache key for storing the result based on the
 * arguments provided to the memoized function. By default, the first argument
 * provided to the memoized function is used as the map cache key. The `func`
 * is invoked with the `this` binding of the memoized function.
 *
 * **Note:** The cache is exposed as the `cache` property on the memoized
 * function. Its creation may be customized by replacing the `_.memoize.Cache`
 * constructor with one whose instances implement the
 * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
 * method interface of `clear`, `delete`, `get`, `has`, and `set`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to have its output memoized.
 * @param {Function} [resolver] The function to resolve the cache key.
 * @returns {Function} Returns the new memoized function.
 * @example
 *
 * var object = { 'a': 1, 'b': 2 };
 * var other = { 'c': 3, 'd': 4 };
 *
 * var values = _.memoize(_.values);
 * values(object);
 * // => [1, 2]
 *
 * values(other);
 * // => [3, 4]
 *
 * object.a = 2;
 * values(object);
 * // => [1, 2]
 *
 * // Modify the result cache.
 * values.cache.set(object, ['a', 'b']);
 * values(object);
 * // => ['a', 'b']
 *
 * // Replace `_.memoize.Cache`.
 * _.memoize.Cache = WeakMap;
 */
function memoize(func, resolver) {
  if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  var memoized = function() {
    var args = arguments,
        key = resolver ? resolver.apply(this, args) : args[0],
        cache = memoized.cache;

    if (cache.has(key)) {
      return cache.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache.set(key, result) || cache;
    return result;
  };
  memoized.cache = new (memoize.Cache || MapCache);
  return memoized;
}

// Expose `MapCache`.
memoize.Cache = MapCache;

module.exports = memoize;


/***/ }),

/***/ "./node_modules/lodash/noop.js":
/*!*************************************!*\
  !*** ./node_modules/lodash/noop.js ***!
  \*************************************/
/***/ ((module) => {

/**
 * This method returns `undefined`.
 *
 * @static
 * @memberOf _
 * @since 2.3.0
 * @category Util
 * @example
 *
 * _.times(2, _.noop);
 * // => [undefined, undefined]
 */
function noop() {
  // No operation performed.
}

module.exports = noop;


/***/ }),

/***/ "./node_modules/lodash/now.js":
/*!************************************!*\
  !*** ./node_modules/lodash/now.js ***!
  \************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/**
 * Gets the timestamp of the number of milliseconds that have elapsed since
 * the Unix epoch (1 January 1970 00:00:00 UTC).
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Date
 * @returns {number} Returns the timestamp.
 * @example
 *
 * _.defer(function(stamp) {
 *   console.log(_.now() - stamp);
 * }, _.now());
 * // => Logs the number of milliseconds it took for the deferred invocation.
 */
var now = function() {
  return root.Date.now();
};

module.exports = now;


/***/ }),

/***/ "./node_modules/lodash/property.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/property.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseProperty = __webpack_require__(/*! ./_baseProperty */ "./node_modules/lodash/_baseProperty.js"),
    basePropertyDeep = __webpack_require__(/*! ./_basePropertyDeep */ "./node_modules/lodash/_basePropertyDeep.js"),
    isKey = __webpack_require__(/*! ./_isKey */ "./node_modules/lodash/_isKey.js"),
    toKey = __webpack_require__(/*! ./_toKey */ "./node_modules/lodash/_toKey.js");

/**
 * Creates a function that returns the value at `path` of a given object.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new accessor function.
 * @example
 *
 * var objects = [
 *   { 'a': { 'b': 2 } },
 *   { 'a': { 'b': 1 } }
 * ];
 *
 * _.map(objects, _.property('a.b'));
 * // => [2, 1]
 *
 * _.map(_.sortBy(objects, _.property(['a', 'b'])), 'a.b');
 * // => [1, 2]
 */
function property(path) {
  return isKey(path) ? baseProperty(toKey(path)) : basePropertyDeep(path);
}

module.exports = property;


/***/ }),

/***/ "./node_modules/lodash/stubArray.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/stubArray.js ***!
  \******************************************/
/***/ ((module) => {

/**
 * This method returns a new empty array.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {Array} Returns the new empty array.
 * @example
 *
 * var arrays = _.times(2, _.stubArray);
 *
 * console.log(arrays);
 * // => [[], []]
 *
 * console.log(arrays[0] === arrays[1]);
 * // => false
 */
function stubArray() {
  return [];
}

module.exports = stubArray;


/***/ }),

/***/ "./node_modules/lodash/stubFalse.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/stubFalse.js ***!
  \******************************************/
/***/ ((module) => {

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

module.exports = stubFalse;


/***/ }),

/***/ "./node_modules/lodash/throttle.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/throttle.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var debounce = __webpack_require__(/*! ./debounce */ "./node_modules/lodash/debounce.js"),
    isObject = __webpack_require__(/*! ./isObject */ "./node_modules/lodash/isObject.js");

/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/**
 * Creates a throttled function that only invokes `func` at most once per
 * every `wait` milliseconds. The throttled function comes with a `cancel`
 * method to cancel delayed `func` invocations and a `flush` method to
 * immediately invoke them. Provide `options` to indicate whether `func`
 * should be invoked on the leading and/or trailing edge of the `wait`
 * timeout. The `func` is invoked with the last arguments provided to the
 * throttled function. Subsequent calls to the throttled function return the
 * result of the last `func` invocation.
 *
 * **Note:** If `leading` and `trailing` options are `true`, `func` is
 * invoked on the trailing edge of the timeout only if the throttled function
 * is invoked more than once during the `wait` timeout.
 *
 * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
 * until to the next tick, similar to `setTimeout` with a timeout of `0`.
 *
 * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
 * for details over the differences between `_.throttle` and `_.debounce`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to throttle.
 * @param {number} [wait=0] The number of milliseconds to throttle invocations to.
 * @param {Object} [options={}] The options object.
 * @param {boolean} [options.leading=true]
 *  Specify invoking on the leading edge of the timeout.
 * @param {boolean} [options.trailing=true]
 *  Specify invoking on the trailing edge of the timeout.
 * @returns {Function} Returns the new throttled function.
 * @example
 *
 * // Avoid excessively updating the position while scrolling.
 * jQuery(window).on('scroll', _.throttle(updatePosition, 100));
 *
 * // Invoke `renewToken` when the click event is fired, but not more than once every 5 minutes.
 * var throttled = _.throttle(renewToken, 300000, { 'trailing': false });
 * jQuery(element).on('click', throttled);
 *
 * // Cancel the trailing throttled invocation.
 * jQuery(window).on('popstate', throttled.cancel);
 */
function throttle(func, wait, options) {
  var leading = true,
      trailing = true;

  if (typeof func != 'function') {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  if (isObject(options)) {
    leading = 'leading' in options ? !!options.leading : leading;
    trailing = 'trailing' in options ? !!options.trailing : trailing;
  }
  return debounce(func, wait, {
    'leading': leading,
    'maxWait': wait,
    'trailing': trailing
  });
}

module.exports = throttle;


/***/ }),

/***/ "./node_modules/lodash/toNumber.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/toNumber.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseTrim = __webpack_require__(/*! ./_baseTrim */ "./node_modules/lodash/_baseTrim.js"),
    isObject = __webpack_require__(/*! ./isObject */ "./node_modules/lodash/isObject.js"),
    isSymbol = __webpack_require__(/*! ./isSymbol */ "./node_modules/lodash/isSymbol.js");

/** Used as references for various `Number` constants. */
var NAN = 0 / 0;

/** Used to detect bad signed hexadecimal string values. */
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

/** Used to detect binary string values. */
var reIsBinary = /^0b[01]+$/i;

/** Used to detect octal string values. */
var reIsOctal = /^0o[0-7]+$/i;

/** Built-in method references without a dependency on `root`. */
var freeParseInt = parseInt;

/**
 * Converts `value` to a number.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {number} Returns the number.
 * @example
 *
 * _.toNumber(3.2);
 * // => 3.2
 *
 * _.toNumber(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toNumber(Infinity);
 * // => Infinity
 *
 * _.toNumber('3.2');
 * // => 3.2
 */
function toNumber(value) {
  if (typeof value == 'number') {
    return value;
  }
  if (isSymbol(value)) {
    return NAN;
  }
  if (isObject(value)) {
    var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
    value = isObject(other) ? (other + '') : other;
  }
  if (typeof value != 'string') {
    return value === 0 ? value : +value;
  }
  value = baseTrim(value);
  var isBinary = reIsBinary.test(value);
  return (isBinary || reIsOctal.test(value))
    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
    : (reIsBadHex.test(value) ? NAN : +value);
}

module.exports = toNumber;


/***/ }),

/***/ "./node_modules/lodash/toString.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/toString.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseToString = __webpack_require__(/*! ./_baseToString */ "./node_modules/lodash/_baseToString.js");

/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : baseToString(value);
}

module.exports = toString;


/***/ }),

/***/ "./node_modules/lodash/uniqWith.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/uniqWith.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseUniq = __webpack_require__(/*! ./_baseUniq */ "./node_modules/lodash/_baseUniq.js");

/**
 * This method is like `_.uniq` except that it accepts `comparator` which
 * is invoked to compare elements of `array`. The order of result values is
 * determined by the order they occur in the array.The comparator is invoked
 * with two arguments: (arrVal, othVal).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Array
 * @param {Array} array The array to inspect.
 * @param {Function} [comparator] The comparator invoked per element.
 * @returns {Array} Returns the new duplicate free array.
 * @example
 *
 * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }, { 'x': 1, 'y': 2 }];
 *
 * _.uniqWith(objects, _.isEqual);
 * // => [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }]
 */
function uniqWith(array, comparator) {
  comparator = typeof comparator == 'function' ? comparator : undefined;
  return (array && array.length) ? baseUniq(array, undefined, comparator) : [];
}

module.exports = uniqWith;


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/Icon.js":
/*!****************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/Icon.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Icon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _defaultAttributes_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./defaultAttributes.js */ "./node_modules/lucide-react/dist/esm/defaultAttributes.js");
/* harmony import */ var _shared_src_utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/src/utils.js */ "./node_modules/lucide-react/dist/esm/shared/src/utils.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */





const Icon = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(
  ({
    color = "currentColor",
    size = 24,
    strokeWidth = 2,
    absoluteStrokeWidth,
    className = "",
    children,
    iconNode,
    ...rest
  }, ref) => {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(
      "svg",
      {
        ref,
        ..._defaultAttributes_js__WEBPACK_IMPORTED_MODULE_1__["default"],
        width: size,
        height: size,
        stroke: color,
        strokeWidth: absoluteStrokeWidth ? Number(strokeWidth) * 24 / Number(size) : strokeWidth,
        className: (0,_shared_src_utils_js__WEBPACK_IMPORTED_MODULE_2__.mergeClasses)("lucide", className),
        ...rest
      },
      [
        ...iconNode.map(([tag, attrs]) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(tag, attrs)),
        ...Array.isArray(children) ? children : [children]
      ]
    );
  }
);


//# sourceMappingURL=Icon.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/createLucideIcon.js":
/*!****************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/createLucideIcon.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createLucideIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _shared_src_utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/src/utils.js */ "./node_modules/lucide-react/dist/esm/shared/src/utils.js");
/* harmony import */ var _Icon_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Icon.js */ "./node_modules/lucide-react/dist/esm/Icon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */





const createLucideIcon = (iconName, iconNode) => {
  const Component = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(
    ({ className, ...props }, ref) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Icon_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
      ref,
      iconNode,
      className: (0,_shared_src_utils_js__WEBPACK_IMPORTED_MODULE_2__.mergeClasses)(`lucide-${(0,_shared_src_utils_js__WEBPACK_IMPORTED_MODULE_2__.toKebabCase)(iconName)}`, className),
      ...props
    })
  );
  Component.displayName = `${iconName}`;
  return Component;
};


//# sourceMappingURL=createLucideIcon.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/defaultAttributes.js":
/*!*****************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/defaultAttributes.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ defaultAttributes)
/* harmony export */ });
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */

var defaultAttributes = {
  xmlns: "http://www.w3.org/2000/svg",
  width: 24,
  height: 24,
  viewBox: "0 0 24 24",
  fill: "none",
  stroke: "currentColor",
  strokeWidth: 2,
  strokeLinecap: "round",
  strokeLinejoin: "round"
};


//# sourceMappingURL=defaultAttributes.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/align-center.js":
/*!******************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/align-center.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ AlignCenter)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M17 12H7", key: "16if0g" }],
  ["path", { d: "M19 18H5", key: "18s9l3" }],
  ["path", { d: "M21 6H3", key: "1jwq7v" }]
];
const AlignCenter = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("AlignCenter", __iconNode);


//# sourceMappingURL=align-center.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/align-justify.js":
/*!*******************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/align-justify.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ AlignJustify)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M3 12h18", key: "1i2n21" }],
  ["path", { d: "M3 18h18", key: "1h113x" }],
  ["path", { d: "M3 6h18", key: "d0wm0j" }]
];
const AlignJustify = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("AlignJustify", __iconNode);


//# sourceMappingURL=align-justify.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/align-left.js":
/*!****************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/align-left.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ AlignLeft)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M15 12H3", key: "6jk70r" }],
  ["path", { d: "M17 18H3", key: "1amg6g" }],
  ["path", { d: "M21 6H3", key: "1jwq7v" }]
];
const AlignLeft = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("AlignLeft", __iconNode);


//# sourceMappingURL=align-left.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/align-right.js":
/*!*****************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/align-right.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ AlignRight)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M21 12H9", key: "dn1m92" }],
  ["path", { d: "M21 18H7", key: "1ygte8" }],
  ["path", { d: "M21 6H3", key: "1jwq7v" }]
];
const AlignRight = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("AlignRight", __iconNode);


//# sourceMappingURL=align-right.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/apple.js":
/*!***********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/apple.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Apple)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  [
    "path",
    {
      d: "M12 20.94c1.5 0 2.75 1.06 4 1.06 3 0 6-8 6-12.22A4.91 4.91 0 0 0 17 5c-2.22 0-4 1.44-5 2-1-.56-2.78-2-5-2a4.9 4.9 0 0 0-5 4.78C2 14 5 22 8 22c1.25 0 2.5-1.06 4-1.06Z",
      key: "3s7exb"
    }
  ],
  ["path", { d: "M10 2c1 .5 2 2 2 5", key: "fcco2y" }]
];
const Apple = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Apple", __iconNode);


//# sourceMappingURL=apple.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/arrow-down.js":
/*!****************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/arrow-down.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ ArrowDown)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M12 5v14", key: "s699le" }],
  ["path", { d: "m19 12-7 7-7-7", key: "1idqje" }]
];
const ArrowDown = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("ArrowDown", __iconNode);


//# sourceMappingURL=arrow-down.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/arrow-left.js":
/*!****************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/arrow-left.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ ArrowLeft)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "m12 19-7-7 7-7", key: "1l729n" }],
  ["path", { d: "M19 12H5", key: "x3x0zl" }]
];
const ArrowLeft = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("ArrowLeft", __iconNode);


//# sourceMappingURL=arrow-left.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/arrow-right.js":
/*!*****************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/arrow-right.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ ArrowRight)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M5 12h14", key: "1ays0h" }],
  ["path", { d: "m12 5 7 7-7 7", key: "xquz4c" }]
];
const ArrowRight = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("ArrowRight", __iconNode);


//# sourceMappingURL=arrow-right.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/arrow-up.js":
/*!**************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/arrow-up.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ ArrowUp)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "m5 12 7-7 7 7", key: "hav0vg" }],
  ["path", { d: "M12 19V5", key: "x0mq9r" }]
];
const ArrowUp = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("ArrowUp", __iconNode);


//# sourceMappingURL=arrow-up.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/audio-lines.js":
/*!*****************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/audio-lines.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ AudioLines)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M2 10v3", key: "1fnikh" }],
  ["path", { d: "M6 6v11", key: "11sgs0" }],
  ["path", { d: "M10 3v18", key: "yhl04a" }],
  ["path", { d: "M14 8v7", key: "3a1oy3" }],
  ["path", { d: "M18 5v13", key: "123xd1" }],
  ["path", { d: "M22 10v3", key: "154ddg" }]
];
const AudioLines = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("AudioLines", __iconNode);


//# sourceMappingURL=audio-lines.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/baseline.js":
/*!**************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/baseline.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Baseline)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M4 20h16", key: "14thso" }],
  ["path", { d: "m6 16 6-12 6 12", key: "1b4byz" }],
  ["path", { d: "M8 12h8", key: "1wcyev" }]
];
const Baseline = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Baseline", __iconNode);


//# sourceMappingURL=baseline.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/bold.js":
/*!**********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/bold.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Bold)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  [
    "path",
    { d: "M6 12h9a4 4 0 0 1 0 8H7a1 1 0 0 1-1-1V5a1 1 0 0 1 1-1h7a4 4 0 0 1 0 8", key: "mg9rjx" }
  ]
];
const Bold = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Bold", __iconNode);


//# sourceMappingURL=bold.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/check.js":
/*!***********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/check.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Check)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [["path", { d: "M20 6 9 17l-5-5", key: "1gmf2c" }]];
const Check = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Check", __iconNode);


//# sourceMappingURL=check.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/chevron-down.js":
/*!******************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/chevron-down.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ ChevronDown)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [["path", { d: "m6 9 6 6 6-6", key: "qrunsl" }]];
const ChevronDown = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("ChevronDown", __iconNode);


//# sourceMappingURL=chevron-down.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/chevron-right.js":
/*!*******************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/chevron-right.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ ChevronRight)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [["path", { d: "m9 18 6-6-6-6", key: "mthhwq" }]];
const ChevronRight = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("ChevronRight", __iconNode);


//# sourceMappingURL=chevron-right.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/clock.js":
/*!***********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/clock.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Clock)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["circle", { cx: "12", cy: "12", r: "10", key: "1mglay" }],
  ["polyline", { points: "12 6 12 12 16 14", key: "68esgv" }]
];
const Clock = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Clock", __iconNode);


//# sourceMappingURL=clock.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/code-xml.js":
/*!**************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/code-xml.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ CodeXml)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "m18 16 4-4-4-4", key: "1inbqp" }],
  ["path", { d: "m6 8-4 4 4 4", key: "15zrgr" }],
  ["path", { d: "m14.5 4-5 16", key: "e7oirm" }]
];
const CodeXml = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("CodeXml", __iconNode);


//# sourceMappingURL=code-xml.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/combine.js":
/*!*************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/combine.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Combine)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M10 18H5a3 3 0 0 1-3-3v-1", key: "ru65g8" }],
  ["path", { d: "M14 2a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2", key: "e30een" }],
  ["path", { d: "M20 2a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2", key: "2ahx8o" }],
  ["path", { d: "m7 21 3-3-3-3", key: "127cv2" }],
  ["rect", { x: "14", y: "14", width: "8", height: "8", rx: "2", key: "1b0bso" }],
  ["rect", { x: "2", y: "2", width: "8", height: "8", rx: "2", key: "1x09vl" }]
];
const Combine = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Combine", __iconNode);


//# sourceMappingURL=combine.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/compass.js":
/*!*************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/compass.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Compass)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  [
    "path",
    {
      d: "m16.24 7.76-1.804 5.411a2 2 0 0 1-1.265 1.265L7.76 16.24l1.804-5.411a2 2 0 0 1 1.265-1.265z",
      key: "9ktpf1"
    }
  ],
  ["circle", { cx: "12", cy: "12", r: "10", key: "1mglay" }]
];
const Compass = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Compass", __iconNode);


//# sourceMappingURL=compass.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/eraser.js":
/*!************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/eraser.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Eraser)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  [
    "path",
    {
      d: "m7 21-4.3-4.3c-1-1-1-2.5 0-3.4l9.6-9.6c1-1 2.5-1 3.4 0l5.6 5.6c1 1 1 2.5 0 3.4L13 21",
      key: "182aya"
    }
  ],
  ["path", { d: "M22 21H7", key: "t4ddhn" }],
  ["path", { d: "m5 11 9 9", key: "1mo9qw" }]
];
const Eraser = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Eraser", __iconNode);


//# sourceMappingURL=eraser.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/external-link.js":
/*!*******************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/external-link.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ ExternalLink)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M15 3h6v6", key: "1q9fwt" }],
  ["path", { d: "M10 14 21 3", key: "gplh6r" }],
  ["path", { d: "M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6", key: "a6xqqp" }]
];
const ExternalLink = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("ExternalLink", __iconNode);


//# sourceMappingURL=external-link.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/file-up.js":
/*!*************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/file-up.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ FileUp)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z", key: "1rqfz7" }],
  ["path", { d: "M14 2v4a2 2 0 0 0 2 2h4", key: "tnqrlb" }],
  ["path", { d: "M12 12v6", key: "3ahymv" }],
  ["path", { d: "m15 15-3-3-3 3", key: "15xj92" }]
];
const FileUp = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("FileUp", __iconNode);


//# sourceMappingURL=file-up.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/film.js":
/*!**********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/film.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Film)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["rect", { width: "18", height: "18", x: "3", y: "3", rx: "2", key: "afitv7" }],
  ["path", { d: "M7 3v18", key: "bbkbws" }],
  ["path", { d: "M3 7.5h4", key: "zfgn84" }],
  ["path", { d: "M3 12h18", key: "1i2n21" }],
  ["path", { d: "M3 16.5h4", key: "1230mu" }],
  ["path", { d: "M17 3v18", key: "in4fa5" }],
  ["path", { d: "M17 7.5h4", key: "myr1c1" }],
  ["path", { d: "M17 16.5h4", key: "go4c1d" }]
];
const Film = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Film", __iconNode);


//# sourceMappingURL=film.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/flag.js":
/*!**********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/flag.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Flag)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M4 15s1-1 4-1 5 2 8 2 4-1 4-1V3s-1 1-4 1-5-2-8-2-4 1-4 1z", key: "i9b6wo" }],
  ["line", { x1: "4", x2: "4", y1: "22", y2: "15", key: "1cm3nv" }]
];
const Flag = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Flag", __iconNode);


//# sourceMappingURL=flag.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/grid-2x2.js":
/*!**************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/grid-2x2.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Grid2x2)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M12 3v18", key: "108xh3" }],
  ["path", { d: "M3 12h18", key: "1i2n21" }],
  ["rect", { x: "3", y: "3", width: "18", height: "18", rx: "2", key: "h1oib" }]
];
const Grid2x2 = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Grid2x2", __iconNode);


//# sourceMappingURL=grid-2x2.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/grid-3x3.js":
/*!**************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/grid-3x3.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Grid3x3)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["rect", { width: "18", height: "18", x: "3", y: "3", rx: "2", key: "afitv7" }],
  ["path", { d: "M3 9h18", key: "1pudct" }],
  ["path", { d: "M3 15h18", key: "5xshup" }],
  ["path", { d: "M9 3v18", key: "fh3hqa" }],
  ["path", { d: "M15 3v18", key: "14nvp0" }]
];
const Grid3x3 = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Grid3x3", __iconNode);


//# sourceMappingURL=grid-3x3.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/grip-vertical.js":
/*!*******************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/grip-vertical.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ GripVertical)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["circle", { cx: "9", cy: "12", r: "1", key: "1vctgf" }],
  ["circle", { cx: "9", cy: "5", r: "1", key: "hp0tcf" }],
  ["circle", { cx: "9", cy: "19", r: "1", key: "fkjjf6" }],
  ["circle", { cx: "15", cy: "12", r: "1", key: "1tmaij" }],
  ["circle", { cx: "15", cy: "5", r: "1", key: "19l28e" }],
  ["circle", { cx: "15", cy: "19", r: "1", key: "f4zoj3" }]
];
const GripVertical = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("GripVertical", __iconNode);


//# sourceMappingURL=grip-vertical.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/heading-1.js":
/*!***************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/heading-1.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Heading1)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M4 12h8", key: "17cfdx" }],
  ["path", { d: "M4 18V6", key: "1rz3zl" }],
  ["path", { d: "M12 18V6", key: "zqpxq5" }],
  ["path", { d: "m17 12 3-2v8", key: "1hhhft" }]
];
const Heading1 = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Heading1", __iconNode);


//# sourceMappingURL=heading-1.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/heading-2.js":
/*!***************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/heading-2.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Heading2)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M4 12h8", key: "17cfdx" }],
  ["path", { d: "M4 18V6", key: "1rz3zl" }],
  ["path", { d: "M12 18V6", key: "zqpxq5" }],
  ["path", { d: "M21 18h-4c0-4 4-3 4-6 0-1.5-2-2.5-4-1", key: "9jr5yi" }]
];
const Heading2 = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Heading2", __iconNode);


//# sourceMappingURL=heading-2.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/heading-3.js":
/*!***************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/heading-3.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Heading3)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M4 12h8", key: "17cfdx" }],
  ["path", { d: "M4 18V6", key: "1rz3zl" }],
  ["path", { d: "M12 18V6", key: "zqpxq5" }],
  ["path", { d: "M17.5 10.5c1.7-1 3.5 0 3.5 1.5a2 2 0 0 1-2 2", key: "68ncm8" }],
  ["path", { d: "M17 17.5c2 1.5 4 .3 4-1.5a2 2 0 0 0-2-2", key: "1ejuhz" }]
];
const Heading3 = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Heading3", __iconNode);


//# sourceMappingURL=heading-3.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/heading-4.js":
/*!***************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/heading-4.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Heading4)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M12 18V6", key: "zqpxq5" }],
  ["path", { d: "M17 10v3a1 1 0 0 0 1 1h3", key: "tj5zdr" }],
  ["path", { d: "M21 10v8", key: "1kdml4" }],
  ["path", { d: "M4 12h8", key: "17cfdx" }],
  ["path", { d: "M4 18V6", key: "1rz3zl" }]
];
const Heading4 = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Heading4", __iconNode);


//# sourceMappingURL=heading-4.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/heading-5.js":
/*!***************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/heading-5.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Heading5)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M4 12h8", key: "17cfdx" }],
  ["path", { d: "M4 18V6", key: "1rz3zl" }],
  ["path", { d: "M12 18V6", key: "zqpxq5" }],
  ["path", { d: "M17 13v-3h4", key: "1nvgqp" }],
  [
    "path",
    { d: "M17 17.7c.4.2.8.3 1.3.3 1.5 0 2.7-1.1 2.7-2.5S19.8 13 18.3 13H17", key: "2nebdn" }
  ]
];
const Heading5 = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Heading5", __iconNode);


//# sourceMappingURL=heading-5.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/heading-6.js":
/*!***************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/heading-6.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Heading6)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M4 12h8", key: "17cfdx" }],
  ["path", { d: "M4 18V6", key: "1rz3zl" }],
  ["path", { d: "M12 18V6", key: "zqpxq5" }],
  ["circle", { cx: "19", cy: "16", r: "2", key: "15mx69" }],
  ["path", { d: "M20 10c-2 2-3 3.5-3 6", key: "f35dl0" }]
];
const Heading6 = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Heading6", __iconNode);


//# sourceMappingURL=heading-6.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/image.js":
/*!***********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/image.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Image)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["rect", { width: "18", height: "18", x: "3", y: "3", rx: "2", ry: "2", key: "1m3agn" }],
  ["circle", { cx: "9", cy: "9", r: "2", key: "af1f0g" }],
  ["path", { d: "m21 15-3.086-3.086a2 2 0 0 0-2.828 0L6 21", key: "1xmnt7" }]
];
const Image = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Image", __iconNode);


//# sourceMappingURL=image.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/indent-decrease.js":
/*!*********************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/indent-decrease.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ IndentDecrease)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M21 12H11", key: "wd7e0v" }],
  ["path", { d: "M21 18H11", key: "4wu86t" }],
  ["path", { d: "M21 6H11", key: "6dy1d6" }],
  ["path", { d: "m7 8-4 4 4 4", key: "o5hrat" }]
];
const IndentDecrease = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("IndentDecrease", __iconNode);


//# sourceMappingURL=indent-decrease.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/indent-increase.js":
/*!*********************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/indent-increase.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ IndentIncrease)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M21 12H11", key: "wd7e0v" }],
  ["path", { d: "M21 18H11", key: "4wu86t" }],
  ["path", { d: "M21 6H11", key: "6dy1d6" }],
  ["path", { d: "m3 8 4 4-4 4", key: "1a3j6y" }]
];
const IndentIncrease = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("IndentIncrease", __iconNode);


//# sourceMappingURL=indent-increase.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/italic.js":
/*!************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/italic.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Italic)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["line", { x1: "19", x2: "10", y1: "4", y2: "4", key: "15jd3p" }],
  ["line", { x1: "14", x2: "5", y1: "20", y2: "20", key: "bu0au3" }],
  ["line", { x1: "15", x2: "9", y1: "4", y2: "20", key: "uljnxc" }]
];
const Italic = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Italic", __iconNode);


//# sourceMappingURL=italic.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/leaf.js":
/*!**********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/leaf.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Leaf)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  [
    "path",
    {
      d: "M11 20A7 7 0 0 1 9.8 6.1C15.5 5 17 4.48 19 2c1 2 2 4.18 2 8 0 5.5-4.78 10-10 10Z",
      key: "nnexq3"
    }
  ],
  ["path", { d: "M2 21c0-3 1.85-5.36 5.08-6C9.5 14.52 12 13 13 12", key: "mt58a7" }]
];
const Leaf = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Leaf", __iconNode);


//# sourceMappingURL=leaf.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/lightbulb.js":
/*!***************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/lightbulb.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Lightbulb)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  [
    "path",
    {
      d: "M15 14c.2-1 .7-1.7 1.5-2.5 1-.9 1.5-2.2 1.5-3.5A6 6 0 0 0 6 8c0 1 .2 2.2 1.5 3.5.7.7 1.3 1.5 1.5 2.5",
      key: "1gvzjb"
    }
  ],
  ["path", { d: "M9 18h6", key: "x1upvd" }],
  ["path", { d: "M10 22h4", key: "ceow96" }]
];
const Lightbulb = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Lightbulb", __iconNode);


//# sourceMappingURL=lightbulb.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/link.js":
/*!**********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/link.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Link)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71", key: "1cjeqo" }],
  ["path", { d: "M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71", key: "19qd67" }]
];
const Link = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Link", __iconNode);


//# sourceMappingURL=link.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/list-ordered.js":
/*!******************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/list-ordered.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ ListOrdered)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M10 12h11", key: "6m4ad9" }],
  ["path", { d: "M10 18h11", key: "11hvi2" }],
  ["path", { d: "M10 6h11", key: "c7qv1k" }],
  ["path", { d: "M4 10h2", key: "16xx2s" }],
  ["path", { d: "M4 6h1v4", key: "cnovpq" }],
  ["path", { d: "M6 18H4c0-1 2-2 2-3s-1-1.5-2-1", key: "m9a95d" }]
];
const ListOrdered = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("ListOrdered", __iconNode);


//# sourceMappingURL=list-ordered.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/list.js":
/*!**********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/list.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ List)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M3 12h.01", key: "nlz23k" }],
  ["path", { d: "M3 18h.01", key: "1tta3j" }],
  ["path", { d: "M3 6h.01", key: "1rqtza" }],
  ["path", { d: "M8 12h13", key: "1za7za" }],
  ["path", { d: "M8 18h13", key: "1lx6n3" }],
  ["path", { d: "M8 6h13", key: "ik3vkj" }]
];
const List = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("List", __iconNode);


//# sourceMappingURL=list.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/minus.js":
/*!***********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/minus.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Minus)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [["path", { d: "M5 12h14", key: "1ays0h" }]];
const Minus = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Minus", __iconNode);


//# sourceMappingURL=minus.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/music.js":
/*!***********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/music.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Music)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M9 18V5l12-2v13", key: "1jmyc2" }],
  ["circle", { cx: "6", cy: "18", r: "3", key: "fqmcym" }],
  ["circle", { cx: "18", cy: "16", r: "3", key: "1hluhg" }]
];
const Music = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Music", __iconNode);


//# sourceMappingURL=music.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/paint-bucket.js":
/*!******************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/paint-bucket.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ PaintBucket)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  [
    "path",
    { d: "m19 11-8-8-8.6 8.6a2 2 0 0 0 0 2.8l5.2 5.2c.8.8 2 .8 2.8 0L19 11Z", key: "irua1i" }
  ],
  ["path", { d: "m5 2 5 5", key: "1lls2c" }],
  ["path", { d: "M2 13h15", key: "1hkzvu" }],
  ["path", { d: "M22 20a2 2 0 1 1-4 0c0-1.6 1.7-2.4 2-4 .3 1.6 2 2.4 2 4Z", key: "xk76lq" }]
];
const PaintBucket = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("PaintBucket", __iconNode);


//# sourceMappingURL=paint-bucket.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/pilcrow.js":
/*!*************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/pilcrow.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Pilcrow)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M13 4v16", key: "8vvj80" }],
  ["path", { d: "M17 4v16", key: "7dpous" }],
  ["path", { d: "M19 4H9.5a4.5 4.5 0 0 0 0 9H13", key: "sh4n9v" }]
];
const Pilcrow = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Pilcrow", __iconNode);


//# sourceMappingURL=pilcrow.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/plus.js":
/*!**********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/plus.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Plus)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M5 12h14", key: "1ays0h" }],
  ["path", { d: "M12 5v14", key: "s699le" }]
];
const Plus = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Plus", __iconNode);


//# sourceMappingURL=plus.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/quote.js":
/*!***********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/quote.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Quote)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  [
    "path",
    {
      d: "M16 3a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2 1 1 0 0 1 1 1v1a2 2 0 0 1-2 2 1 1 0 0 0-1 1v2a1 1 0 0 0 1 1 6 6 0 0 0 6-6V5a2 2 0 0 0-2-2z",
      key: "rib7q0"
    }
  ],
  [
    "path",
    {
      d: "M5 3a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2 1 1 0 0 1 1 1v1a2 2 0 0 1-2 2 1 1 0 0 0-1 1v2a1 1 0 0 0 1 1 6 6 0 0 0 6-6V5a2 2 0 0 0-2-2z",
      key: "1ymkrd"
    }
  ]
];
const Quote = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Quote", __iconNode);


//# sourceMappingURL=quote.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/redo-2.js":
/*!************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/redo-2.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Redo2)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "m15 14 5-5-5-5", key: "12vg1m" }],
  ["path", { d: "M20 9H9.5A5.5 5.5 0 0 0 4 14.5A5.5 5.5 0 0 0 9.5 20H13", key: "6uklza" }]
];
const Redo2 = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Redo2", __iconNode);


//# sourceMappingURL=redo-2.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/search.js":
/*!************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/search.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Search)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["circle", { cx: "11", cy: "11", r: "8", key: "4ej97u" }],
  ["path", { d: "m21 21-4.3-4.3", key: "1qie3q" }]
];
const Search = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Search", __iconNode);


//# sourceMappingURL=search.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/smile.js":
/*!***********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/smile.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Smile)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["circle", { cx: "12", cy: "12", r: "10", key: "1mglay" }],
  ["path", { d: "M8 14s1.5 2 4 2 4-2 4-2", key: "1y1vjs" }],
  ["line", { x1: "9", x2: "9.01", y1: "9", y2: "9", key: "yxxnd0" }],
  ["line", { x1: "15", x2: "15.01", y1: "9", y2: "9", key: "1p4y9e" }]
];
const Smile = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Smile", __iconNode);


//# sourceMappingURL=smile.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/square-split-horizontal.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/square-split-horizontal.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ SquareSplitHorizontal)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M8 19H5c-1 0-2-1-2-2V7c0-1 1-2 2-2h3", key: "lubmu8" }],
  ["path", { d: "M16 5h3c1 0 2 1 2 2v10c0 1-1 2-2 2h-3", key: "1ag34g" }],
  ["line", { x1: "12", x2: "12", y1: "4", y2: "20", key: "1tx1rr" }]
];
const SquareSplitHorizontal = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("SquareSplitHorizontal", __iconNode);


//# sourceMappingURL=square-split-horizontal.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/star.js":
/*!**********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/star.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Star)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  [
    "path",
    {
      d: "M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.123 2.123 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.123 2.123 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.122 2.122 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.122 2.122 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.122 2.122 0 0 0 1.597-1.16z",
      key: "r04s7s"
    }
  ]
];
const Star = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Star", __iconNode);


//# sourceMappingURL=star.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/strikethrough.js":
/*!*******************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/strikethrough.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Strikethrough)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M16 4H9a3 3 0 0 0-2.83 4", key: "43sutm" }],
  ["path", { d: "M14 12a4 4 0 0 1 0 8H6", key: "nlfj13" }],
  ["line", { x1: "4", x2: "20", y1: "12", y2: "12", key: "1e0a9i" }]
];
const Strikethrough = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Strikethrough", __iconNode);


//# sourceMappingURL=strikethrough.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/subscript.js":
/*!***************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/subscript.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Subscript)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "m4 5 8 8", key: "1eunvl" }],
  ["path", { d: "m12 5-8 8", key: "1ah0jp" }],
  [
    "path",
    {
      d: "M20 19h-4c0-1.5.44-2 1.5-2.5S20 15.33 20 14c0-.47-.17-.93-.48-1.29a2.11 2.11 0 0 0-2.62-.44c-.42.24-.74.62-.9 1.07",
      key: "e8ta8j"
    }
  ]
];
const Subscript = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Subscript", __iconNode);


//# sourceMappingURL=subscript.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/superscript.js":
/*!*****************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/superscript.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Superscript)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "m4 19 8-8", key: "hr47gm" }],
  ["path", { d: "m12 19-8-8", key: "1dhhmo" }],
  [
    "path",
    {
      d: "M20 12h-4c0-1.5.442-2 1.5-2.5S20 8.334 20 7.002c0-.472-.17-.93-.484-1.29a2.105 2.105 0 0 0-2.617-.436c-.42.239-.738.614-.899 1.06",
      key: "1dfcux"
    }
  ]
];
const Superscript = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Superscript", __iconNode);


//# sourceMappingURL=superscript.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/table.js":
/*!***********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/table.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Table)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M12 3v18", key: "108xh3" }],
  ["rect", { width: "18", height: "18", x: "3", y: "3", rx: "2", key: "afitv7" }],
  ["path", { d: "M3 9h18", key: "1pudct" }],
  ["path", { d: "M3 15h18", key: "5xshup" }]
];
const Table = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Table", __iconNode);


//# sourceMappingURL=table.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/text.js":
/*!**********************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/text.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Text)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M17 6.1H3", key: "wptmhv" }],
  ["path", { d: "M21 12.1H3", key: "1j38uz" }],
  ["path", { d: "M15.1 18H3", key: "1nb16a" }]
];
const Text = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Text", __iconNode);


//# sourceMappingURL=text.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/trash-2.js":
/*!*************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/trash-2.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Trash2)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M3 6h18", key: "d0wm0j" }],
  ["path", { d: "M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6", key: "4alrt4" }],
  ["path", { d: "M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2", key: "v07s0e" }],
  ["line", { x1: "10", x2: "10", y1: "11", y2: "17", key: "1uufr5" }],
  ["line", { x1: "14", x2: "14", y1: "11", y2: "17", key: "xtxkd" }]
];
const Trash2 = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Trash2", __iconNode);


//# sourceMappingURL=trash-2.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/underline.js":
/*!***************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/underline.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Underline)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M6 4v6a6 6 0 0 0 12 0V4", key: "9kb039" }],
  ["line", { x1: "4", x2: "20", y1: "20", y2: "20", key: "nun2al" }]
];
const Underline = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Underline", __iconNode);


//# sourceMappingURL=underline.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/undo-2.js":
/*!************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/undo-2.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Undo2)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M9 14 4 9l5-5", key: "102s5s" }],
  ["path", { d: "M4 9h10.5a5.5 5.5 0 0 1 5.5 5.5a5.5 5.5 0 0 1-5.5 5.5H11", key: "f3b9sd" }]
];
const Undo2 = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Undo2", __iconNode);


//# sourceMappingURL=undo-2.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/ungroup.js":
/*!*************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/ungroup.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Ungroup)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["rect", { width: "8", height: "6", x: "5", y: "4", rx: "1", key: "nzclkv" }],
  ["rect", { width: "8", height: "6", x: "11", y: "14", rx: "1", key: "4tytwb" }]
];
const Ungroup = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Ungroup", __iconNode);


//# sourceMappingURL=ungroup.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/unlink.js":
/*!************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/unlink.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ Unlink)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  [
    "path",
    {
      d: "m18.84 12.25 1.72-1.71h-.02a5.004 5.004 0 0 0-.12-7.07 5.006 5.006 0 0 0-6.95 0l-1.72 1.71",
      key: "yqzxt4"
    }
  ],
  [
    "path",
    {
      d: "m5.17 11.75-1.71 1.71a5.004 5.004 0 0 0 .12 7.07 5.006 5.006 0 0 0 6.95 0l1.71-1.71",
      key: "4qinb0"
    }
  ],
  ["line", { x1: "8", x2: "8", y1: "2", y2: "5", key: "1041cp" }],
  ["line", { x1: "2", x2: "5", y1: "8", y2: "8", key: "14m1p5" }],
  ["line", { x1: "16", x2: "16", y1: "19", y2: "22", key: "rzdirn" }],
  ["line", { x1: "19", x2: "22", y1: "16", y2: "16", key: "ox905f" }]
];
const Unlink = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("Unlink", __iconNode);


//# sourceMappingURL=unlink.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/wrap-text.js":
/*!***************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/wrap-text.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ WrapText)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["line", { x1: "3", x2: "21", y1: "6", y2: "6", key: "4m8b97" }],
  ["path", { d: "M3 12h15a3 3 0 1 1 0 6h-4", key: "1cl7v7" }],
  ["polyline", { points: "16 16 14 18 16 20", key: "1jznyi" }],
  ["line", { x1: "3", x2: "10", y1: "18", y2: "18", key: "1h33wv" }]
];
const WrapText = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("WrapText", __iconNode);


//# sourceMappingURL=wrap-text.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/icons/x.js":
/*!*******************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/icons/x.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __iconNode: () => (/* binding */ __iconNode),
/* harmony export */   "default": () => (/* binding */ X)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../createLucideIcon.js */ "./node_modules/lucide-react/dist/esm/createLucideIcon.js");
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const __iconNode = [
  ["path", { d: "M18 6 6 18", key: "1bl5f8" }],
  ["path", { d: "m6 6 12 12", key: "d8bk6v" }]
];
const X = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__["default"])("X", __iconNode);


//# sourceMappingURL=x.js.map


/***/ }),

/***/ "./node_modules/lucide-react/dist/esm/shared/src/utils.js":
/*!****************************************************************!*\
  !*** ./node_modules/lucide-react/dist/esm/shared/src/utils.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   mergeClasses: () => (/* binding */ mergeClasses),
/* harmony export */   toKebabCase: () => (/* binding */ toKebabCase)
/* harmony export */ });
/**
 * @license lucide-react v0.476.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */

const toKebabCase = (string) => string.replace(/([a-z0-9])([A-Z])/g, "$1-$2").toLowerCase();
const mergeClasses = (...classes) => classes.filter((className, index, array) => {
  return Boolean(className) && className.trim() !== "" && array.indexOf(className) === index;
}).join(" ").trim();


//# sourceMappingURL=utils.js.map


/***/ }),

/***/ "./node_modules/performance-now/lib/performance-now.js":
/*!*************************************************************!*\
  !*** ./node_modules/performance-now/lib/performance-now.js ***!
  \*************************************************************/
/***/ (function(module) {

// Generated by CoffeeScript 1.12.2
(function() {
  var getNanoSeconds, hrtime, loadTime, moduleLoadTime, nodeLoadTime, upTime;

  if ((typeof performance !== "undefined" && performance !== null) && performance.now) {
    module.exports = function() {
      return performance.now();
    };
  } else if ((typeof process !== "undefined" && process !== null) && process.hrtime) {
    module.exports = function() {
      return (getNanoSeconds() - nodeLoadTime) / 1e6;
    };
    hrtime = process.hrtime;
    getNanoSeconds = function() {
      var hr;
      hr = hrtime();
      return hr[0] * 1e9 + hr[1];
    };
    moduleLoadTime = getNanoSeconds();
    upTime = process.uptime() * 1e9;
    nodeLoadTime = moduleLoadTime - upTime;
  } else if (Date.now) {
    module.exports = function() {
      return Date.now() - loadTime;
    };
    loadTime = Date.now();
  } else {
    module.exports = function() {
      return new Date().getTime() - loadTime;
    };
    loadTime = new Date().getTime();
  }

}).call(this);

//# sourceMappingURL=performance-now.js.map


/***/ }),

/***/ "./node_modules/raf/index.js":
/*!***********************************!*\
  !*** ./node_modules/raf/index.js ***!
  \***********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var now = __webpack_require__(/*! performance-now */ "./node_modules/performance-now/lib/performance-now.js")
  , root = typeof window === 'undefined' ? __webpack_require__.g : window
  , vendors = ['moz', 'webkit']
  , suffix = 'AnimationFrame'
  , raf = root['request' + suffix]
  , caf = root['cancel' + suffix] || root['cancelRequest' + suffix]

for(var i = 0; !raf && i < vendors.length; i++) {
  raf = root[vendors[i] + 'Request' + suffix]
  caf = root[vendors[i] + 'Cancel' + suffix]
      || root[vendors[i] + 'CancelRequest' + suffix]
}

// Some versions of FF have rAF but not cAF
if(!raf || !caf) {
  var last = 0
    , id = 0
    , queue = []
    , frameDuration = 1000 / 60

  raf = function(callback) {
    if(queue.length === 0) {
      var _now = now()
        , next = Math.max(0, frameDuration - (_now - last))
      last = next + _now
      setTimeout(function() {
        var cp = queue.slice(0)
        // Clear queue here to prevent
        // callbacks from appending listeners
        // to the current frame's queue
        queue.length = 0
        for(var i = 0; i < cp.length; i++) {
          if(!cp[i].cancelled) {
            try{
              cp[i].callback(last)
            } catch(e) {
              setTimeout(function() { throw e }, 0)
            }
          }
        }
      }, Math.round(next))
    }
    queue.push({
      handle: ++id,
      callback: callback,
      cancelled: false
    })
    return id
  }

  caf = function(handle) {
    for(var i = 0; i < queue.length; i++) {
      if(queue[i].handle === handle) {
        queue[i].cancelled = true
      }
    }
  }
}

module.exports = function(fn) {
  // Wrap in a new function to prevent
  // `cancel` potentially being assigned
  // to the native rAF function
  return raf.call(root, fn)
}
module.exports.cancel = function() {
  caf.apply(root, arguments)
}
module.exports.polyfill = function(object) {
  if (!object) {
    object = root;
  }
  object.requestAnimationFrame = raf
  object.cancelAnimationFrame = caf
}


/***/ }),

/***/ "./node_modules/react-dom/cjs/react-dom-client.development.js":
/*!********************************************************************!*\
  !*** ./node_modules/react-dom/cjs/react-dom-client.development.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/**
 * @license React
 * react-dom-client.development.js
 *
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

/*
 Modernizr 3.0.0pre (Custom Build) | MIT
*/

 true &&
  (function () {
    function findHook(fiber, id) {
      for (fiber = fiber.memoizedState; null !== fiber && 0 < id; )
        (fiber = fiber.next), id--;
      return fiber;
    }
    function copyWithSetImpl(obj, path, index, value) {
      if (index >= path.length) return value;
      var key = path[index],
        updated = isArrayImpl(obj) ? obj.slice() : assign({}, obj);
      updated[key] = copyWithSetImpl(obj[key], path, index + 1, value);
      return updated;
    }
    function copyWithRename(obj, oldPath, newPath) {
      if (oldPath.length !== newPath.length)
        console.warn("copyWithRename() expects paths of the same length");
      else {
        for (var i = 0; i < newPath.length - 1; i++)
          if (oldPath[i] !== newPath[i]) {
            console.warn(
              "copyWithRename() expects paths to be the same except for the deepest key"
            );
            return;
          }
        return copyWithRenameImpl(obj, oldPath, newPath, 0);
      }
    }
    function copyWithRenameImpl(obj, oldPath, newPath, index) {
      var oldKey = oldPath[index],
        updated = isArrayImpl(obj) ? obj.slice() : assign({}, obj);
      index + 1 === oldPath.length
        ? ((updated[newPath[index]] = updated[oldKey]),
          isArrayImpl(updated)
            ? updated.splice(oldKey, 1)
            : delete updated[oldKey])
        : (updated[oldKey] = copyWithRenameImpl(
            obj[oldKey],
            oldPath,
            newPath,
            index + 1
          ));
      return updated;
    }
    function copyWithDeleteImpl(obj, path, index) {
      var key = path[index],
        updated = isArrayImpl(obj) ? obj.slice() : assign({}, obj);
      if (index + 1 === path.length)
        return (
          isArrayImpl(updated) ? updated.splice(key, 1) : delete updated[key],
          updated
        );
      updated[key] = copyWithDeleteImpl(obj[key], path, index + 1);
      return updated;
    }
    function shouldSuspendImpl() {
      return !1;
    }
    function shouldErrorImpl() {
      return null;
    }
    function createFiber(tag, pendingProps, key, mode) {
      return new FiberNode(tag, pendingProps, key, mode);
    }
    function warnInvalidHookAccess() {
      console.error(
        "Do not call Hooks inside useEffect(...), useMemo(...), or other built-in Hooks. You can only call Hooks at the top level of your React function. For more information, see https://react.dev/link/rules-of-hooks"
      );
    }
    function warnInvalidContextAccess() {
      console.error(
        "Context can only be read while React is rendering. In classes, you can read it in the render method or getDerivedStateFromProps. In function components, you can read it directly in the function body, but not inside Hooks like useReducer() or useMemo()."
      );
    }
    function noop$2() {}
    function warnForMissingKey() {}
    function setToSortedString(set) {
      var array = [];
      set.forEach(function (value) {
        array.push(value);
      });
      return array.sort().join(", ");
    }
    function scheduleRoot(root, element) {
      root.context === emptyContextObject &&
        (updateContainerSync(element, root, null, null), flushSyncWork$1());
    }
    function scheduleRefresh(root, update) {
      if (null !== resolveFamily) {
        var staleFamilies = update.staleFamilies;
        update = update.updatedFamilies;
        flushPassiveEffects();
        scheduleFibersWithFamiliesRecursively(
          root.current,
          update,
          staleFamilies
        );
        flushSyncWork$1();
      }
    }
    function setRefreshHandler(handler) {
      resolveFamily = handler;
    }
    function isValidContainer(node) {
      return !(
        !node ||
        (1 !== node.nodeType && 9 !== node.nodeType && 11 !== node.nodeType)
      );
    }
    function getIteratorFn(maybeIterable) {
      if (null === maybeIterable || "object" !== typeof maybeIterable)
        return null;
      maybeIterable =
        (MAYBE_ITERATOR_SYMBOL && maybeIterable[MAYBE_ITERATOR_SYMBOL]) ||
        maybeIterable["@@iterator"];
      return "function" === typeof maybeIterable ? maybeIterable : null;
    }
    function getComponentNameFromType(type) {
      if (null == type) return null;
      if ("function" === typeof type)
        return type.$$typeof === REACT_CLIENT_REFERENCE
          ? null
          : type.displayName || type.name || null;
      if ("string" === typeof type) return type;
      switch (type) {
        case REACT_FRAGMENT_TYPE:
          return "Fragment";
        case REACT_PORTAL_TYPE:
          return "Portal";
        case REACT_PROFILER_TYPE:
          return "Profiler";
        case REACT_STRICT_MODE_TYPE:
          return "StrictMode";
        case REACT_SUSPENSE_TYPE:
          return "Suspense";
        case REACT_SUSPENSE_LIST_TYPE:
          return "SuspenseList";
      }
      if ("object" === typeof type)
        switch (
          ("number" === typeof type.tag &&
            console.error(
              "Received an unexpected object in getComponentNameFromType(). This is likely a bug in React. Please file an issue."
            ),
          type.$$typeof)
        ) {
          case REACT_CONTEXT_TYPE:
            return (type.displayName || "Context") + ".Provider";
          case REACT_CONSUMER_TYPE:
            return (type._context.displayName || "Context") + ".Consumer";
          case REACT_FORWARD_REF_TYPE:
            var innerType = type.render;
            type = type.displayName;
            type ||
              ((type = innerType.displayName || innerType.name || ""),
              (type = "" !== type ? "ForwardRef(" + type + ")" : "ForwardRef"));
            return type;
          case REACT_MEMO_TYPE:
            return (
              (innerType = type.displayName || null),
              null !== innerType
                ? innerType
                : getComponentNameFromType(type.type) || "Memo"
            );
          case REACT_LAZY_TYPE:
            innerType = type._payload;
            type = type._init;
            try {
              return getComponentNameFromType(type(innerType));
            } catch (x) {}
        }
      return null;
    }
    function getComponentNameFromOwner(owner) {
      return "number" === typeof owner.tag
        ? getComponentNameFromFiber(owner)
        : "string" === typeof owner.name
          ? owner.name
          : null;
    }
    function getComponentNameFromFiber(fiber) {
      var type = fiber.type;
      switch (fiber.tag) {
        case 24:
          return "Cache";
        case 9:
          return (type._context.displayName || "Context") + ".Consumer";
        case 10:
          return (type.displayName || "Context") + ".Provider";
        case 18:
          return "DehydratedFragment";
        case 11:
          return (
            (fiber = type.render),
            (fiber = fiber.displayName || fiber.name || ""),
            type.displayName ||
              ("" !== fiber ? "ForwardRef(" + fiber + ")" : "ForwardRef")
          );
        case 7:
          return "Fragment";
        case 26:
        case 27:
        case 5:
          return type;
        case 4:
          return "Portal";
        case 3:
          return "Root";
        case 6:
          return "Text";
        case 16:
          return getComponentNameFromType(type);
        case 8:
          return type === REACT_STRICT_MODE_TYPE ? "StrictMode" : "Mode";
        case 22:
          return "Offscreen";
        case 12:
          return "Profiler";
        case 21:
          return "Scope";
        case 13:
          return "Suspense";
        case 19:
          return "SuspenseList";
        case 25:
          return "TracingMarker";
        case 1:
        case 0:
        case 14:
        case 15:
          if ("function" === typeof type)
            return type.displayName || type.name || null;
          if ("string" === typeof type) return type;
          break;
        case 29:
          type = fiber._debugInfo;
          if (null != type)
            for (var i = type.length - 1; 0 <= i; i--)
              if ("string" === typeof type[i].name) return type[i].name;
          if (null !== fiber.return)
            return getComponentNameFromFiber(fiber.return);
      }
      return null;
    }
    function disabledLog() {}
    function disableLogs() {
      if (0 === disabledDepth) {
        prevLog = console.log;
        prevInfo = console.info;
        prevWarn = console.warn;
        prevError = console.error;
        prevGroup = console.group;
        prevGroupCollapsed = console.groupCollapsed;
        prevGroupEnd = console.groupEnd;
        var props = {
          configurable: !0,
          enumerable: !0,
          value: disabledLog,
          writable: !0
        };
        Object.defineProperties(console, {
          info: props,
          log: props,
          warn: props,
          error: props,
          group: props,
          groupCollapsed: props,
          groupEnd: props
        });
      }
      disabledDepth++;
    }
    function reenableLogs() {
      disabledDepth--;
      if (0 === disabledDepth) {
        var props = { configurable: !0, enumerable: !0, writable: !0 };
        Object.defineProperties(console, {
          log: assign({}, props, { value: prevLog }),
          info: assign({}, props, { value: prevInfo }),
          warn: assign({}, props, { value: prevWarn }),
          error: assign({}, props, { value: prevError }),
          group: assign({}, props, { value: prevGroup }),
          groupCollapsed: assign({}, props, { value: prevGroupCollapsed }),
          groupEnd: assign({}, props, { value: prevGroupEnd })
        });
      }
      0 > disabledDepth &&
        console.error(
          "disabledDepth fell below zero. This is a bug in React. Please file an issue."
        );
    }
    function describeBuiltInComponentFrame(name) {
      if (void 0 === prefix)
        try {
          throw Error();
        } catch (x) {
          var match = x.stack.trim().match(/\n( *(at )?)/);
          prefix = (match && match[1]) || "";
          suffix =
            -1 < x.stack.indexOf("\n    at")
              ? " (<anonymous>)"
              : -1 < x.stack.indexOf("@")
                ? "@unknown:0:0"
                : "";
        }
      return "\n" + prefix + name + suffix;
    }
    function describeNativeComponentFrame(fn, construct) {
      if (!fn || reentry) return "";
      var frame = componentFrameCache.get(fn);
      if (void 0 !== frame) return frame;
      reentry = !0;
      frame = Error.prepareStackTrace;
      Error.prepareStackTrace = void 0;
      var previousDispatcher = null;
      previousDispatcher = ReactSharedInternals.H;
      ReactSharedInternals.H = null;
      disableLogs();
      try {
        var RunInRootFrame = {
          DetermineComponentFrameRoot: function () {
            try {
              if (construct) {
                var Fake = function () {
                  throw Error();
                };
                Object.defineProperty(Fake.prototype, "props", {
                  set: function () {
                    throw Error();
                  }
                });
                if ("object" === typeof Reflect && Reflect.construct) {
                  try {
                    Reflect.construct(Fake, []);
                  } catch (x) {
                    var control = x;
                  }
                  Reflect.construct(fn, [], Fake);
                } else {
                  try {
                    Fake.call();
                  } catch (x$0) {
                    control = x$0;
                  }
                  fn.call(Fake.prototype);
                }
              } else {
                try {
                  throw Error();
                } catch (x$1) {
                  control = x$1;
                }
                (Fake = fn()) &&
                  "function" === typeof Fake.catch &&
                  Fake.catch(function () {});
              }
            } catch (sample) {
              if (sample && control && "string" === typeof sample.stack)
                return [sample.stack, control.stack];
            }
            return [null, null];
          }
        };
        RunInRootFrame.DetermineComponentFrameRoot.displayName =
          "DetermineComponentFrameRoot";
        var namePropDescriptor = Object.getOwnPropertyDescriptor(
          RunInRootFrame.DetermineComponentFrameRoot,
          "name"
        );
        namePropDescriptor &&
          namePropDescriptor.configurable &&
          Object.defineProperty(
            RunInRootFrame.DetermineComponentFrameRoot,
            "name",
            { value: "DetermineComponentFrameRoot" }
          );
        var _RunInRootFrame$Deter =
            RunInRootFrame.DetermineComponentFrameRoot(),
          sampleStack = _RunInRootFrame$Deter[0],
          controlStack = _RunInRootFrame$Deter[1];
        if (sampleStack && controlStack) {
          var sampleLines = sampleStack.split("\n"),
            controlLines = controlStack.split("\n");
          for (
            _RunInRootFrame$Deter = namePropDescriptor = 0;
            namePropDescriptor < sampleLines.length &&
            !sampleLines[namePropDescriptor].includes(
              "DetermineComponentFrameRoot"
            );

          )
            namePropDescriptor++;
          for (
            ;
            _RunInRootFrame$Deter < controlLines.length &&
            !controlLines[_RunInRootFrame$Deter].includes(
              "DetermineComponentFrameRoot"
            );

          )
            _RunInRootFrame$Deter++;
          if (
            namePropDescriptor === sampleLines.length ||
            _RunInRootFrame$Deter === controlLines.length
          )
            for (
              namePropDescriptor = sampleLines.length - 1,
                _RunInRootFrame$Deter = controlLines.length - 1;
              1 <= namePropDescriptor &&
              0 <= _RunInRootFrame$Deter &&
              sampleLines[namePropDescriptor] !==
                controlLines[_RunInRootFrame$Deter];

            )
              _RunInRootFrame$Deter--;
          for (
            ;
            1 <= namePropDescriptor && 0 <= _RunInRootFrame$Deter;
            namePropDescriptor--, _RunInRootFrame$Deter--
          )
            if (
              sampleLines[namePropDescriptor] !==
              controlLines[_RunInRootFrame$Deter]
            ) {
              if (1 !== namePropDescriptor || 1 !== _RunInRootFrame$Deter) {
                do
                  if (
                    (namePropDescriptor--,
                    _RunInRootFrame$Deter--,
                    0 > _RunInRootFrame$Deter ||
                      sampleLines[namePropDescriptor] !==
                        controlLines[_RunInRootFrame$Deter])
                  ) {
                    var _frame =
                      "\n" +
                      sampleLines[namePropDescriptor].replace(
                        " at new ",
                        " at "
                      );
                    fn.displayName &&
                      _frame.includes("<anonymous>") &&
                      (_frame = _frame.replace("<anonymous>", fn.displayName));
                    "function" === typeof fn &&
                      componentFrameCache.set(fn, _frame);
                    return _frame;
                  }
                while (1 <= namePropDescriptor && 0 <= _RunInRootFrame$Deter);
              }
              break;
            }
        }
      } finally {
        (reentry = !1),
          (ReactSharedInternals.H = previousDispatcher),
          reenableLogs(),
          (Error.prepareStackTrace = frame);
      }
      sampleLines = (sampleLines = fn ? fn.displayName || fn.name : "")
        ? describeBuiltInComponentFrame(sampleLines)
        : "";
      "function" === typeof fn && componentFrameCache.set(fn, sampleLines);
      return sampleLines;
    }
    function describeFiber(fiber) {
      switch (fiber.tag) {
        case 26:
        case 27:
        case 5:
          return describeBuiltInComponentFrame(fiber.type);
        case 16:
          return describeBuiltInComponentFrame("Lazy");
        case 13:
          return describeBuiltInComponentFrame("Suspense");
        case 19:
          return describeBuiltInComponentFrame("SuspenseList");
        case 0:
        case 15:
          return (fiber = describeNativeComponentFrame(fiber.type, !1)), fiber;
        case 11:
          return (
            (fiber = describeNativeComponentFrame(fiber.type.render, !1)), fiber
          );
        case 1:
          return (fiber = describeNativeComponentFrame(fiber.type, !0)), fiber;
        default:
          return "";
      }
    }
    function getStackByFiberInDevAndProd(workInProgress) {
      try {
        var info = "";
        do {
          info += describeFiber(workInProgress);
          var debugInfo = workInProgress._debugInfo;
          if (debugInfo)
            for (var i = debugInfo.length - 1; 0 <= i; i--) {
              var entry = debugInfo[i];
              if ("string" === typeof entry.name) {
                var JSCompiler_temp_const = info,
                  env = entry.env;
                var JSCompiler_inline_result = describeBuiltInComponentFrame(
                  entry.name + (env ? " [" + env + "]" : "")
                );
                info = JSCompiler_temp_const + JSCompiler_inline_result;
              }
            }
          workInProgress = workInProgress.return;
        } while (workInProgress);
        return info;
      } catch (x) {
        return "\nError generating stack: " + x.message + "\n" + x.stack;
      }
    }
    function getCurrentFiberOwnerNameInDevOrNull() {
      if (null === current) return null;
      var owner = current._debugOwner;
      return null != owner ? getComponentNameFromOwner(owner) : null;
    }
    function getCurrentFiberStackInDev() {
      return null === current ? "" : getStackByFiberInDevAndProd(current);
    }
    function runWithFiberInDEV(fiber, callback, arg0, arg1, arg2, arg3, arg4) {
      var previousFiber = current;
      ReactSharedInternals.getCurrentStack =
        null === fiber ? null : getCurrentFiberStackInDev;
      isRendering = !1;
      current = fiber;
      try {
        return callback(arg0, arg1, arg2, arg3, arg4);
      } finally {
        current = previousFiber;
      }
      throw Error(
        "runWithFiberInDEV should never be called in production. This is a bug in React."
      );
    }
    function getNearestMountedFiber(fiber) {
      var node = fiber,
        nearestMounted = fiber;
      if (fiber.alternate) for (; node.return; ) node = node.return;
      else {
        fiber = node;
        do
          (node = fiber),
            0 !== (node.flags & 4098) && (nearestMounted = node.return),
            (fiber = node.return);
        while (fiber);
      }
      return 3 === node.tag ? nearestMounted : null;
    }
    function getSuspenseInstanceFromFiber(fiber) {
      if (13 === fiber.tag) {
        var suspenseState = fiber.memoizedState;
        null === suspenseState &&
          ((fiber = fiber.alternate),
          null !== fiber && (suspenseState = fiber.memoizedState));
        if (null !== suspenseState) return suspenseState.dehydrated;
      }
      return null;
    }
    function assertIsMounted(fiber) {
      if (getNearestMountedFiber(fiber) !== fiber)
        throw Error("Unable to find node on an unmounted component.");
    }
    function findCurrentFiberUsingSlowPath(fiber) {
      var alternate = fiber.alternate;
      if (!alternate) {
        alternate = getNearestMountedFiber(fiber);
        if (null === alternate)
          throw Error("Unable to find node on an unmounted component.");
        return alternate !== fiber ? null : fiber;
      }
      for (var a = fiber, b = alternate; ; ) {
        var parentA = a.return;
        if (null === parentA) break;
        var parentB = parentA.alternate;
        if (null === parentB) {
          b = parentA.return;
          if (null !== b) {
            a = b;
            continue;
          }
          break;
        }
        if (parentA.child === parentB.child) {
          for (parentB = parentA.child; parentB; ) {
            if (parentB === a) return assertIsMounted(parentA), fiber;
            if (parentB === b) return assertIsMounted(parentA), alternate;
            parentB = parentB.sibling;
          }
          throw Error("Unable to find node on an unmounted component.");
        }
        if (a.return !== b.return) (a = parentA), (b = parentB);
        else {
          for (var didFindChild = !1, _child = parentA.child; _child; ) {
            if (_child === a) {
              didFindChild = !0;
              a = parentA;
              b = parentB;
              break;
            }
            if (_child === b) {
              didFindChild = !0;
              b = parentA;
              a = parentB;
              break;
            }
            _child = _child.sibling;
          }
          if (!didFindChild) {
            for (_child = parentB.child; _child; ) {
              if (_child === a) {
                didFindChild = !0;
                a = parentB;
                b = parentA;
                break;
              }
              if (_child === b) {
                didFindChild = !0;
                b = parentB;
                a = parentA;
                break;
              }
              _child = _child.sibling;
            }
            if (!didFindChild)
              throw Error(
                "Child was not found in either parent set. This indicates a bug in React related to the return pointer. Please file an issue."
              );
          }
        }
        if (a.alternate !== b)
          throw Error(
            "Return fibers should always be each others' alternates. This error is likely caused by a bug in React. Please file an issue."
          );
      }
      if (3 !== a.tag)
        throw Error("Unable to find node on an unmounted component.");
      return a.stateNode.current === a ? fiber : alternate;
    }
    function findCurrentHostFiberImpl(node) {
      var tag = node.tag;
      if (5 === tag || 26 === tag || 27 === tag || 6 === tag) return node;
      for (node = node.child; null !== node; ) {
        tag = findCurrentHostFiberImpl(node);
        if (null !== tag) return tag;
        node = node.sibling;
      }
      return null;
    }
    function createCursor(defaultValue) {
      return { current: defaultValue };
    }
    function pop(cursor, fiber) {
      0 > index$jscomp$0
        ? console.error("Unexpected pop.")
        : (fiber !== fiberStack[index$jscomp$0] &&
            console.error("Unexpected Fiber popped."),
          (cursor.current = valueStack[index$jscomp$0]),
          (valueStack[index$jscomp$0] = null),
          (fiberStack[index$jscomp$0] = null),
          index$jscomp$0--);
    }
    function push(cursor, value, fiber) {
      index$jscomp$0++;
      valueStack[index$jscomp$0] = cursor.current;
      fiberStack[index$jscomp$0] = fiber;
      cursor.current = value;
    }
    function requiredContext(c) {
      null === c &&
        console.error(
          "Expected host context to exist. This error is likely caused by a bug in React. Please file an issue."
        );
      return c;
    }
    function pushHostContainer(fiber, nextRootInstance) {
      push(rootInstanceStackCursor, nextRootInstance, fiber);
      push(contextFiberStackCursor, fiber, fiber);
      push(contextStackCursor, null, fiber);
      var nextRootContext = nextRootInstance.nodeType;
      switch (nextRootContext) {
        case 9:
        case 11:
          nextRootContext = 9 === nextRootContext ? "#document" : "#fragment";
          nextRootInstance = (nextRootInstance =
            nextRootInstance.documentElement)
            ? (nextRootInstance = nextRootInstance.namespaceURI)
              ? getOwnHostContext(nextRootInstance)
              : HostContextNamespaceNone
            : HostContextNamespaceNone;
          break;
        default:
          if (
            ((nextRootInstance =
              8 === nextRootContext
                ? nextRootInstance.parentNode
                : nextRootInstance),
            (nextRootContext = nextRootInstance.tagName),
            (nextRootInstance = nextRootInstance.namespaceURI))
          )
            (nextRootInstance = getOwnHostContext(nextRootInstance)),
              (nextRootInstance = getChildHostContextProd(
                nextRootInstance,
                nextRootContext
              ));
          else
            switch (nextRootContext) {
              case "svg":
                nextRootInstance = HostContextNamespaceSvg;
                break;
              case "math":
                nextRootInstance = HostContextNamespaceMath;
                break;
              default:
                nextRootInstance = HostContextNamespaceNone;
            }
      }
      nextRootContext = nextRootContext.toLowerCase();
      nextRootContext = updatedAncestorInfoDev(null, nextRootContext);
      nextRootContext = {
        context: nextRootInstance,
        ancestorInfo: nextRootContext
      };
      pop(contextStackCursor, fiber);
      push(contextStackCursor, nextRootContext, fiber);
    }
    function popHostContainer(fiber) {
      pop(contextStackCursor, fiber);
      pop(contextFiberStackCursor, fiber);
      pop(rootInstanceStackCursor, fiber);
    }
    function getHostContext() {
      return requiredContext(contextStackCursor.current);
    }
    function pushHostContext(fiber) {
      null !== fiber.memoizedState &&
        push(hostTransitionProviderCursor, fiber, fiber);
      var context = requiredContext(contextStackCursor.current);
      var type = fiber.type;
      var nextContext = getChildHostContextProd(context.context, type);
      type = updatedAncestorInfoDev(context.ancestorInfo, type);
      nextContext = { context: nextContext, ancestorInfo: type };
      context !== nextContext &&
        (push(contextFiberStackCursor, fiber, fiber),
        push(contextStackCursor, nextContext, fiber));
    }
    function popHostContext(fiber) {
      contextFiberStackCursor.current === fiber &&
        (pop(contextStackCursor, fiber), pop(contextFiberStackCursor, fiber));
      hostTransitionProviderCursor.current === fiber &&
        (pop(hostTransitionProviderCursor, fiber),
        (HostTransitionContext._currentValue = NotPendingTransition));
    }
    function typeName(value) {
      return (
        ("function" === typeof Symbol &&
          Symbol.toStringTag &&
          value[Symbol.toStringTag]) ||
        value.constructor.name ||
        "Object"
      );
    }
    function willCoercionThrow(value) {
      try {
        return testStringCoercion(value), !1;
      } catch (e) {
        return !0;
      }
    }
    function testStringCoercion(value) {
      return "" + value;
    }
    function checkAttributeStringCoercion(value, attributeName) {
      if (willCoercionThrow(value))
        return (
          console.error(
            "The provided `%s` attribute is an unsupported type %s. This value must be coerced to a string before using it here.",
            attributeName,
            typeName(value)
          ),
          testStringCoercion(value)
        );
    }
    function checkCSSPropertyStringCoercion(value, propName) {
      if (willCoercionThrow(value))
        return (
          console.error(
            "The provided `%s` CSS property is an unsupported type %s. This value must be coerced to a string before using it here.",
            propName,
            typeName(value)
          ),
          testStringCoercion(value)
        );
    }
    function checkFormFieldValueStringCoercion(value) {
      if (willCoercionThrow(value))
        return (
          console.error(
            "Form field values (value, checked, defaultValue, or defaultChecked props) must be strings, not %s. This value must be coerced to a string before using it here.",
            typeName(value)
          ),
          testStringCoercion(value)
        );
    }
    function injectInternals(internals) {
      if ("undefined" === typeof __REACT_DEVTOOLS_GLOBAL_HOOK__) return !1;
      var hook = __REACT_DEVTOOLS_GLOBAL_HOOK__;
      if (hook.isDisabled) return !0;
      if (!hook.supportsFiber)
        return (
          console.error(
            "The installed version of React DevTools is too old and will not work with the current version of React. Please update React DevTools. https://react.dev/link/react-devtools"
          ),
          !0
        );
      try {
        (rendererID = hook.inject(internals)), (injectedHook = hook);
      } catch (err) {
        console.error("React instrumentation encountered an error: %s.", err);
      }
      return hook.checkDCE ? !0 : !1;
    }
    function onCommitRoot$1(root, eventPriority) {
      if (injectedHook && "function" === typeof injectedHook.onCommitFiberRoot)
        try {
          var didError = 128 === (root.current.flags & 128);
          switch (eventPriority) {
            case DiscreteEventPriority:
              var schedulerPriority = ImmediatePriority;
              break;
            case ContinuousEventPriority:
              schedulerPriority = UserBlockingPriority;
              break;
            case DefaultEventPriority:
              schedulerPriority = NormalPriority$1;
              break;
            case IdleEventPriority:
              schedulerPriority = IdlePriority;
              break;
            default:
              schedulerPriority = NormalPriority$1;
          }
          injectedHook.onCommitFiberRoot(
            rendererID,
            root,
            schedulerPriority,
            didError
          );
        } catch (err) {
          hasLoggedError ||
            ((hasLoggedError = !0),
            console.error(
              "React instrumentation encountered an error: %s",
              err
            ));
        }
    }
    function setIsStrictModeForDevtools(newIsStrictMode) {
      "function" === typeof log$1 &&
        unstable_setDisableYieldValue(newIsStrictMode);
      if (injectedHook && "function" === typeof injectedHook.setStrictMode)
        try {
          injectedHook.setStrictMode(rendererID, newIsStrictMode);
        } catch (err) {
          hasLoggedError ||
            ((hasLoggedError = !0),
            console.error(
              "React instrumentation encountered an error: %s",
              err
            ));
        }
    }
    function injectProfilingHooks(profilingHooks) {
      injectedProfilingHooks = profilingHooks;
    }
    function markCommitStopped() {
      null !== injectedProfilingHooks &&
        "function" === typeof injectedProfilingHooks.markCommitStopped &&
        injectedProfilingHooks.markCommitStopped();
    }
    function markComponentRenderStarted(fiber) {
      null !== injectedProfilingHooks &&
        "function" ===
          typeof injectedProfilingHooks.markComponentRenderStarted &&
        injectedProfilingHooks.markComponentRenderStarted(fiber);
    }
    function markComponentRenderStopped() {
      null !== injectedProfilingHooks &&
        "function" ===
          typeof injectedProfilingHooks.markComponentRenderStopped &&
        injectedProfilingHooks.markComponentRenderStopped();
    }
    function markRenderStarted(lanes) {
      null !== injectedProfilingHooks &&
        "function" === typeof injectedProfilingHooks.markRenderStarted &&
        injectedProfilingHooks.markRenderStarted(lanes);
    }
    function markRenderStopped() {
      null !== injectedProfilingHooks &&
        "function" === typeof injectedProfilingHooks.markRenderStopped &&
        injectedProfilingHooks.markRenderStopped();
    }
    function markStateUpdateScheduled(fiber, lane) {
      null !== injectedProfilingHooks &&
        "function" === typeof injectedProfilingHooks.markStateUpdateScheduled &&
        injectedProfilingHooks.markStateUpdateScheduled(fiber, lane);
    }
    function clz32Fallback(x) {
      x >>>= 0;
      return 0 === x ? 32 : (31 - ((log(x) / LN2) | 0)) | 0;
    }
    function getLabelForLane(lane) {
      if (lane & 1) return "SyncHydrationLane";
      if (lane & 2) return "Sync";
      if (lane & 4) return "InputContinuousHydration";
      if (lane & 8) return "InputContinuous";
      if (lane & 16) return "DefaultHydration";
      if (lane & 32) return "Default";
      if (lane & 64) return "TransitionHydration";
      if (lane & 4194176) return "Transition";
      if (lane & 62914560) return "Retry";
      if (lane & 67108864) return "SelectiveHydration";
      if (lane & 134217728) return "IdleHydration";
      if (lane & 268435456) return "Idle";
      if (lane & 536870912) return "Offscreen";
      if (lane & 1073741824) return "Deferred";
    }
    function getHighestPriorityLanes(lanes) {
      var pendingSyncLanes = lanes & 42;
      if (0 !== pendingSyncLanes) return pendingSyncLanes;
      switch (lanes & -lanes) {
        case 1:
          return 1;
        case 2:
          return 2;
        case 4:
          return 4;
        case 8:
          return 8;
        case 16:
          return 16;
        case 32:
          return 32;
        case 64:
          return 64;
        case 128:
        case 256:
        case 512:
        case 1024:
        case 2048:
        case 4096:
        case 8192:
        case 16384:
        case 32768:
        case 65536:
        case 131072:
        case 262144:
        case 524288:
        case 1048576:
        case 2097152:
          return lanes & 4194176;
        case 4194304:
        case 8388608:
        case 16777216:
        case 33554432:
          return lanes & 62914560;
        case 67108864:
          return 67108864;
        case 134217728:
          return 134217728;
        case 268435456:
          return 268435456;
        case 536870912:
          return 536870912;
        case 1073741824:
          return 0;
        default:
          return (
            console.error(
              "Should have found matching lanes. This is a bug in React."
            ),
            lanes
          );
      }
    }
    function getNextLanes(root, wipLanes) {
      var pendingLanes = root.pendingLanes;
      if (0 === pendingLanes) return 0;
      var nextLanes = 0,
        suspendedLanes = root.suspendedLanes,
        pingedLanes = root.pingedLanes,
        warmLanes = root.warmLanes;
      root = 0 !== root.finishedLanes;
      var nonIdlePendingLanes = pendingLanes & 134217727;
      0 !== nonIdlePendingLanes
        ? ((pendingLanes = nonIdlePendingLanes & ~suspendedLanes),
          0 !== pendingLanes
            ? (nextLanes = getHighestPriorityLanes(pendingLanes))
            : ((pingedLanes &= nonIdlePendingLanes),
              0 !== pingedLanes
                ? (nextLanes = getHighestPriorityLanes(pingedLanes))
                : root ||
                  ((warmLanes = nonIdlePendingLanes & ~warmLanes),
                  0 !== warmLanes &&
                    (nextLanes = getHighestPriorityLanes(warmLanes)))))
        : ((nonIdlePendingLanes = pendingLanes & ~suspendedLanes),
          0 !== nonIdlePendingLanes
            ? (nextLanes = getHighestPriorityLanes(nonIdlePendingLanes))
            : 0 !== pingedLanes
              ? (nextLanes = getHighestPriorityLanes(pingedLanes))
              : root ||
                ((warmLanes = pendingLanes & ~warmLanes),
                0 !== warmLanes &&
                  (nextLanes = getHighestPriorityLanes(warmLanes))));
      return 0 === nextLanes
        ? 0
        : 0 !== wipLanes &&
            wipLanes !== nextLanes &&
            0 === (wipLanes & suspendedLanes) &&
            ((suspendedLanes = nextLanes & -nextLanes),
            (warmLanes = wipLanes & -wipLanes),
            suspendedLanes >= warmLanes ||
              (32 === suspendedLanes && 0 !== (warmLanes & 4194176)))
          ? wipLanes
          : nextLanes;
    }
    function checkIfRootIsPrerendering(root, renderLanes) {
      return (
        0 ===
        (root.pendingLanes &
          ~(root.suspendedLanes & ~root.pingedLanes) &
          renderLanes)
      );
    }
    function computeExpirationTime(lane, currentTime) {
      switch (lane) {
        case 1:
        case 2:
        case 4:
        case 8:
          return currentTime + 250;
        case 16:
        case 32:
        case 64:
        case 128:
        case 256:
        case 512:
        case 1024:
        case 2048:
        case 4096:
        case 8192:
        case 16384:
        case 32768:
        case 65536:
        case 131072:
        case 262144:
        case 524288:
        case 1048576:
        case 2097152:
          return currentTime + 5e3;
        case 4194304:
        case 8388608:
        case 16777216:
        case 33554432:
          return -1;
        case 67108864:
        case 134217728:
        case 268435456:
        case 536870912:
        case 1073741824:
          return -1;
        default:
          return (
            console.error(
              "Should have found matching lanes. This is a bug in React."
            ),
            -1
          );
      }
    }
    function claimNextTransitionLane() {
      var lane = nextTransitionLane;
      nextTransitionLane <<= 1;
      0 === (nextTransitionLane & 4194176) && (nextTransitionLane = 128);
      return lane;
    }
    function claimNextRetryLane() {
      var lane = nextRetryLane;
      nextRetryLane <<= 1;
      0 === (nextRetryLane & 62914560) && (nextRetryLane = 4194304);
      return lane;
    }
    function createLaneMap(initial) {
      for (var laneMap = [], i = 0; 31 > i; i++) laneMap.push(initial);
      return laneMap;
    }
    function markRootUpdated$1(root, updateLane) {
      root.pendingLanes |= updateLane;
      268435456 !== updateLane &&
        ((root.suspendedLanes = 0),
        (root.pingedLanes = 0),
        (root.warmLanes = 0));
    }
    function markRootFinished(
      root,
      finishedLanes,
      remainingLanes,
      spawnedLane,
      updatedLanes,
      suspendedRetryLanes
    ) {
      var previouslyPendingLanes = root.pendingLanes;
      root.pendingLanes = remainingLanes;
      root.suspendedLanes = 0;
      root.pingedLanes = 0;
      root.warmLanes = 0;
      root.expiredLanes &= remainingLanes;
      root.entangledLanes &= remainingLanes;
      root.errorRecoveryDisabledLanes &= remainingLanes;
      root.shellSuspendCounter = 0;
      var entanglements = root.entanglements,
        expirationTimes = root.expirationTimes,
        hiddenUpdates = root.hiddenUpdates;
      for (
        remainingLanes = previouslyPendingLanes & ~remainingLanes;
        0 < remainingLanes;

      ) {
        var index = 31 - clz32(remainingLanes),
          lane = 1 << index;
        entanglements[index] = 0;
        expirationTimes[index] = -1;
        var hiddenUpdatesForLane = hiddenUpdates[index];
        if (null !== hiddenUpdatesForLane)
          for (
            hiddenUpdates[index] = null, index = 0;
            index < hiddenUpdatesForLane.length;
            index++
          ) {
            var update = hiddenUpdatesForLane[index];
            null !== update && (update.lane &= -536870913);
          }
        remainingLanes &= ~lane;
      }
      0 !== spawnedLane && markSpawnedDeferredLane(root, spawnedLane, 0);
      0 !== suspendedRetryLanes &&
        0 === updatedLanes &&
        0 !== root.tag &&
        (root.suspendedLanes |=
          suspendedRetryLanes & ~(previouslyPendingLanes & ~finishedLanes));
    }
    function markSpawnedDeferredLane(root, spawnedLane, entangledLanes) {
      root.pendingLanes |= spawnedLane;
      root.suspendedLanes &= ~spawnedLane;
      var spawnedLaneIndex = 31 - clz32(spawnedLane);
      root.entangledLanes |= spawnedLane;
      root.entanglements[spawnedLaneIndex] =
        root.entanglements[spawnedLaneIndex] |
        1073741824 |
        (entangledLanes & 4194218);
    }
    function markRootEntangled(root, entangledLanes) {
      var rootEntangledLanes = (root.entangledLanes |= entangledLanes);
      for (root = root.entanglements; rootEntangledLanes; ) {
        var index = 31 - clz32(rootEntangledLanes),
          lane = 1 << index;
        (lane & entangledLanes) | (root[index] & entangledLanes) &&
          (root[index] |= entangledLanes);
        rootEntangledLanes &= ~lane;
      }
    }
    function addFiberToLanesMap(root, fiber, lanes) {
      if (isDevToolsPresent)
        for (root = root.pendingUpdatersLaneMap; 0 < lanes; ) {
          var index = 31 - clz32(lanes),
            lane = 1 << index;
          root[index].add(fiber);
          lanes &= ~lane;
        }
    }
    function movePendingFibersToMemoized(root, lanes) {
      if (isDevToolsPresent)
        for (
          var pendingUpdatersLaneMap = root.pendingUpdatersLaneMap,
            memoizedUpdaters = root.memoizedUpdaters;
          0 < lanes;

        ) {
          var index = 31 - clz32(lanes);
          root = 1 << index;
          index = pendingUpdatersLaneMap[index];
          0 < index.size &&
            (index.forEach(function (fiber) {
              var alternate = fiber.alternate;
              (null !== alternate && memoizedUpdaters.has(alternate)) ||
                memoizedUpdaters.add(fiber);
            }),
            index.clear());
          lanes &= ~root;
        }
    }
    function lanesToEventPriority(lanes) {
      lanes &= -lanes;
      return 0 !== DiscreteEventPriority && DiscreteEventPriority < lanes
        ? 0 !== ContinuousEventPriority && ContinuousEventPriority < lanes
          ? 0 !== (lanes & 134217727)
            ? DefaultEventPriority
            : IdleEventPriority
          : ContinuousEventPriority
        : DiscreteEventPriority;
    }
    function resolveUpdatePriority() {
      var updatePriority = ReactDOMSharedInternals.p;
      if (0 !== updatePriority) return updatePriority;
      updatePriority = window.event;
      return void 0 === updatePriority
        ? DefaultEventPriority
        : getEventPriority(updatePriority.type);
    }
    function runWithPriority(priority, fn) {
      var previousPriority = ReactDOMSharedInternals.p;
      try {
        return (ReactDOMSharedInternals.p = priority), fn();
      } finally {
        ReactDOMSharedInternals.p = previousPriority;
      }
    }
    function detachDeletedInstance(node) {
      delete node[internalInstanceKey];
      delete node[internalPropsKey];
      delete node[internalEventHandlersKey];
      delete node[internalEventHandlerListenersKey];
      delete node[internalEventHandlesSetKey];
    }
    function getClosestInstanceFromNode(targetNode) {
      var targetInst = targetNode[internalInstanceKey];
      if (targetInst) return targetInst;
      for (var parentNode = targetNode.parentNode; parentNode; ) {
        if (
          (targetInst =
            parentNode[internalContainerInstanceKey] ||
            parentNode[internalInstanceKey])
        ) {
          parentNode = targetInst.alternate;
          if (
            null !== targetInst.child ||
            (null !== parentNode && null !== parentNode.child)
          )
            for (
              targetNode = getParentSuspenseInstance(targetNode);
              null !== targetNode;

            ) {
              if ((parentNode = targetNode[internalInstanceKey]))
                return parentNode;
              targetNode = getParentSuspenseInstance(targetNode);
            }
          return targetInst;
        }
        targetNode = parentNode;
        parentNode = targetNode.parentNode;
      }
      return null;
    }
    function getInstanceFromNode(node) {
      if (
        (node = node[internalInstanceKey] || node[internalContainerInstanceKey])
      ) {
        var tag = node.tag;
        if (
          5 === tag ||
          6 === tag ||
          13 === tag ||
          26 === tag ||
          27 === tag ||
          3 === tag
        )
          return node;
      }
      return null;
    }
    function getNodeFromInstance(inst) {
      var tag = inst.tag;
      if (5 === tag || 26 === tag || 27 === tag || 6 === tag)
        return inst.stateNode;
      throw Error("getNodeFromInstance: Invalid argument.");
    }
    function getResourcesFromRoot(root) {
      var resources = root[internalRootNodeResourcesKey];
      resources ||
        (resources = root[internalRootNodeResourcesKey] =
          { hoistableStyles: new Map(), hoistableScripts: new Map() });
      return resources;
    }
    function markNodeAsHoistable(node) {
      node[internalHoistableMarker] = !0;
    }
    function registerTwoPhaseEvent(registrationName, dependencies) {
      registerDirectEvent(registrationName, dependencies);
      registerDirectEvent(registrationName + "Capture", dependencies);
    }
    function registerDirectEvent(registrationName, dependencies) {
      registrationNameDependencies[registrationName] &&
        console.error(
          "EventRegistry: More than one plugin attempted to publish the same registration name, `%s`.",
          registrationName
        );
      registrationNameDependencies[registrationName] = dependencies;
      var lowerCasedName = registrationName.toLowerCase();
      possibleRegistrationNames[lowerCasedName] = registrationName;
      "onDoubleClick" === registrationName &&
        (possibleRegistrationNames.ondblclick = registrationName);
      for (
        registrationName = 0;
        registrationName < dependencies.length;
        registrationName++
      )
        allNativeEvents.add(dependencies[registrationName]);
    }
    function checkControlledValueProps(tagName, props) {
      hasReadOnlyValue[props.type] ||
        props.onChange ||
        props.onInput ||
        props.readOnly ||
        props.disabled ||
        null == props.value ||
        ("select" === tagName
          ? console.error(
              "You provided a `value` prop to a form field without an `onChange` handler. This will render a read-only field. If the field should be mutable use `defaultValue`. Otherwise, set `onChange`."
            )
          : console.error(
              "You provided a `value` prop to a form field without an `onChange` handler. This will render a read-only field. If the field should be mutable use `defaultValue`. Otherwise, set either `onChange` or `readOnly`."
            ));
      props.onChange ||
        props.readOnly ||
        props.disabled ||
        null == props.checked ||
        console.error(
          "You provided a `checked` prop to a form field without an `onChange` handler. This will render a read-only field. If the field should be mutable use `defaultChecked`. Otherwise, set either `onChange` or `readOnly`."
        );
    }
    function isAttributeNameSafe(attributeName) {
      if (hasOwnProperty.call(validatedAttributeNameCache, attributeName))
        return !0;
      if (hasOwnProperty.call(illegalAttributeNameCache, attributeName))
        return !1;
      if (VALID_ATTRIBUTE_NAME_REGEX.test(attributeName))
        return (validatedAttributeNameCache[attributeName] = !0);
      illegalAttributeNameCache[attributeName] = !0;
      console.error("Invalid attribute name: `%s`", attributeName);
      return !1;
    }
    function getValueForAttributeOnCustomComponent(node, name, expected) {
      if (isAttributeNameSafe(name)) {
        if (!node.hasAttribute(name)) {
          switch (typeof expected) {
            case "symbol":
            case "object":
              return expected;
            case "function":
              return expected;
            case "boolean":
              if (!1 === expected) return expected;
          }
          return void 0 === expected ? void 0 : null;
        }
        node = node.getAttribute(name);
        if ("" === node && !0 === expected) return !0;
        checkAttributeStringCoercion(expected, name);
        return node === "" + expected ? expected : node;
      }
    }
    function setValueForAttribute(node, name, value) {
      if (isAttributeNameSafe(name))
        if (null === value) node.removeAttribute(name);
        else {
          switch (typeof value) {
            case "undefined":
            case "function":
            case "symbol":
              node.removeAttribute(name);
              return;
            case "boolean":
              var prefix = name.toLowerCase().slice(0, 5);
              if ("data-" !== prefix && "aria-" !== prefix) {
                node.removeAttribute(name);
                return;
              }
          }
          checkAttributeStringCoercion(value, name);
          node.setAttribute(name, "" + value);
        }
    }
    function setValueForKnownAttribute(node, name, value) {
      if (null === value) node.removeAttribute(name);
      else {
        switch (typeof value) {
          case "undefined":
          case "function":
          case "symbol":
          case "boolean":
            node.removeAttribute(name);
            return;
        }
        checkAttributeStringCoercion(value, name);
        node.setAttribute(name, "" + value);
      }
    }
    function setValueForNamespacedAttribute(node, namespace, name, value) {
      if (null === value) node.removeAttribute(name);
      else {
        switch (typeof value) {
          case "undefined":
          case "function":
          case "symbol":
          case "boolean":
            node.removeAttribute(name);
            return;
        }
        checkAttributeStringCoercion(value, name);
        node.setAttributeNS(namespace, name, "" + value);
      }
    }
    function getToStringValue(value) {
      switch (typeof value) {
        case "bigint":
        case "boolean":
        case "number":
        case "string":
        case "undefined":
          return value;
        case "object":
          return checkFormFieldValueStringCoercion(value), value;
        default:
          return "";
      }
    }
    function isCheckable(elem) {
      var type = elem.type;
      return (
        (elem = elem.nodeName) &&
        "input" === elem.toLowerCase() &&
        ("checkbox" === type || "radio" === type)
      );
    }
    function trackValueOnNode(node) {
      var valueField = isCheckable(node) ? "checked" : "value",
        descriptor = Object.getOwnPropertyDescriptor(
          node.constructor.prototype,
          valueField
        );
      checkFormFieldValueStringCoercion(node[valueField]);
      var currentValue = "" + node[valueField];
      if (
        !node.hasOwnProperty(valueField) &&
        "undefined" !== typeof descriptor &&
        "function" === typeof descriptor.get &&
        "function" === typeof descriptor.set
      ) {
        var get = descriptor.get,
          set = descriptor.set;
        Object.defineProperty(node, valueField, {
          configurable: !0,
          get: function () {
            return get.call(this);
          },
          set: function (value) {
            checkFormFieldValueStringCoercion(value);
            currentValue = "" + value;
            set.call(this, value);
          }
        });
        Object.defineProperty(node, valueField, {
          enumerable: descriptor.enumerable
        });
        return {
          getValue: function () {
            return currentValue;
          },
          setValue: function (value) {
            checkFormFieldValueStringCoercion(value);
            currentValue = "" + value;
          },
          stopTracking: function () {
            node._valueTracker = null;
            delete node[valueField];
          }
        };
      }
    }
    function track(node) {
      node._valueTracker || (node._valueTracker = trackValueOnNode(node));
    }
    function updateValueIfChanged(node) {
      if (!node) return !1;
      var tracker = node._valueTracker;
      if (!tracker) return !0;
      var lastValue = tracker.getValue();
      var value = "";
      node &&
        (value = isCheckable(node)
          ? node.checked
            ? "true"
            : "false"
          : node.value);
      node = value;
      return node !== lastValue ? (tracker.setValue(node), !0) : !1;
    }
    function getActiveElement(doc) {
      doc = doc || ("undefined" !== typeof document ? document : void 0);
      if ("undefined" === typeof doc) return null;
      try {
        return doc.activeElement || doc.body;
      } catch (e) {
        return doc.body;
      }
    }
    function escapeSelectorAttributeValueInsideDoubleQuotes(value) {
      return value.replace(
        escapeSelectorAttributeValueInsideDoubleQuotesRegex,
        function (ch) {
          return "\\" + ch.charCodeAt(0).toString(16) + " ";
        }
      );
    }
    function validateInputProps(element, props) {
      void 0 === props.checked ||
        void 0 === props.defaultChecked ||
        didWarnCheckedDefaultChecked ||
        (console.error(
          "%s contains an input of type %s with both checked and defaultChecked props. Input elements must be either controlled or uncontrolled (specify either the checked prop, or the defaultChecked prop, but not both). Decide between using a controlled or uncontrolled input element and remove one of these props. More info: https://react.dev/link/controlled-components",
          getCurrentFiberOwnerNameInDevOrNull() || "A component",
          props.type
        ),
        (didWarnCheckedDefaultChecked = !0));
      void 0 === props.value ||
        void 0 === props.defaultValue ||
        didWarnValueDefaultValue$1 ||
        (console.error(
          "%s contains an input of type %s with both value and defaultValue props. Input elements must be either controlled or uncontrolled (specify either the value prop, or the defaultValue prop, but not both). Decide between using a controlled or uncontrolled input element and remove one of these props. More info: https://react.dev/link/controlled-components",
          getCurrentFiberOwnerNameInDevOrNull() || "A component",
          props.type
        ),
        (didWarnValueDefaultValue$1 = !0));
    }
    function updateInput(
      element,
      value,
      defaultValue,
      lastDefaultValue,
      checked,
      defaultChecked,
      type,
      name
    ) {
      element.name = "";
      null != type &&
      "function" !== typeof type &&
      "symbol" !== typeof type &&
      "boolean" !== typeof type
        ? (checkAttributeStringCoercion(type, "type"), (element.type = type))
        : element.removeAttribute("type");
      if (null != value)
        if ("number" === type) {
          if ((0 === value && "" === element.value) || element.value != value)
            element.value = "" + getToStringValue(value);
        } else
          element.value !== "" + getToStringValue(value) &&
            (element.value = "" + getToStringValue(value));
      else
        ("submit" !== type && "reset" !== type) ||
          element.removeAttribute("value");
      null != value
        ? setDefaultValue(element, type, getToStringValue(value))
        : null != defaultValue
          ? setDefaultValue(element, type, getToStringValue(defaultValue))
          : null != lastDefaultValue && element.removeAttribute("value");
      null == checked &&
        null != defaultChecked &&
        (element.defaultChecked = !!defaultChecked);
      null != checked &&
        (element.checked =
          checked &&
          "function" !== typeof checked &&
          "symbol" !== typeof checked);
      null != name &&
      "function" !== typeof name &&
      "symbol" !== typeof name &&
      "boolean" !== typeof name
        ? (checkAttributeStringCoercion(name, "name"),
          (element.name = "" + getToStringValue(name)))
        : element.removeAttribute("name");
    }
    function initInput(
      element,
      value,
      defaultValue,
      checked,
      defaultChecked,
      type,
      name,
      isHydrating
    ) {
      null != type &&
        "function" !== typeof type &&
        "symbol" !== typeof type &&
        "boolean" !== typeof type &&
        (checkAttributeStringCoercion(type, "type"), (element.type = type));
      if (null != value || null != defaultValue) {
        if (
          !(
            ("submit" !== type && "reset" !== type) ||
            (void 0 !== value && null !== value)
          )
        )
          return;
        defaultValue =
          null != defaultValue ? "" + getToStringValue(defaultValue) : "";
        value = null != value ? "" + getToStringValue(value) : defaultValue;
        isHydrating || value === element.value || (element.value = value);
        element.defaultValue = value;
      }
      checked = null != checked ? checked : defaultChecked;
      checked =
        "function" !== typeof checked &&
        "symbol" !== typeof checked &&
        !!checked;
      element.checked = isHydrating ? element.checked : !!checked;
      element.defaultChecked = !!checked;
      null != name &&
        "function" !== typeof name &&
        "symbol" !== typeof name &&
        "boolean" !== typeof name &&
        (checkAttributeStringCoercion(name, "name"), (element.name = name));
    }
    function setDefaultValue(node, type, value) {
      ("number" === type && getActiveElement(node.ownerDocument) === node) ||
        node.defaultValue === "" + value ||
        (node.defaultValue = "" + value);
    }
    function validateOptionProps(element, props) {
      null == props.value &&
        ("object" === typeof props.children && null !== props.children
          ? React.Children.forEach(props.children, function (child) {
              null == child ||
                "string" === typeof child ||
                "number" === typeof child ||
                "bigint" === typeof child ||
                didWarnInvalidChild ||
                ((didWarnInvalidChild = !0),
                console.error(
                  "Cannot infer the option value of complex children. Pass a `value` prop or use a plain string as children to <option>."
                ));
            })
          : null == props.dangerouslySetInnerHTML ||
            didWarnInvalidInnerHTML ||
            ((didWarnInvalidInnerHTML = !0),
            console.error(
              "Pass a `value` prop if you set dangerouslyInnerHTML so React knows which value should be selected."
            )));
      null == props.selected ||
        didWarnSelectedSetOnOption ||
        (console.error(
          "Use the `defaultValue` or `value` props on <select> instead of setting `selected` on <option>."
        ),
        (didWarnSelectedSetOnOption = !0));
    }
    function getDeclarationErrorAddendum() {
      var ownerName = getCurrentFiberOwnerNameInDevOrNull();
      return ownerName
        ? "\n\nCheck the render method of `" + ownerName + "`."
        : "";
    }
    function updateOptions(node, multiple, propValue, setDefaultSelected) {
      node = node.options;
      if (multiple) {
        multiple = {};
        for (var i = 0; i < propValue.length; i++)
          multiple["$" + propValue[i]] = !0;
        for (propValue = 0; propValue < node.length; propValue++)
          (i = multiple.hasOwnProperty("$" + node[propValue].value)),
            node[propValue].selected !== i && (node[propValue].selected = i),
            i && setDefaultSelected && (node[propValue].defaultSelected = !0);
      } else {
        propValue = "" + getToStringValue(propValue);
        multiple = null;
        for (i = 0; i < node.length; i++) {
          if (node[i].value === propValue) {
            node[i].selected = !0;
            setDefaultSelected && (node[i].defaultSelected = !0);
            return;
          }
          null !== multiple || node[i].disabled || (multiple = node[i]);
        }
        null !== multiple && (multiple.selected = !0);
      }
    }
    function validateSelectProps(element, props) {
      for (element = 0; element < valuePropNames.length; element++) {
        var propName = valuePropNames[element];
        if (null != props[propName]) {
          var propNameIsArray = isArrayImpl(props[propName]);
          props.multiple && !propNameIsArray
            ? console.error(
                "The `%s` prop supplied to <select> must be an array if `multiple` is true.%s",
                propName,
                getDeclarationErrorAddendum()
              )
            : !props.multiple &&
              propNameIsArray &&
              console.error(
                "The `%s` prop supplied to <select> must be a scalar value if `multiple` is false.%s",
                propName,
                getDeclarationErrorAddendum()
              );
        }
      }
      void 0 === props.value ||
        void 0 === props.defaultValue ||
        didWarnValueDefaultValue ||
        (console.error(
          "Select elements must be either controlled or uncontrolled (specify either the value prop, or the defaultValue prop, but not both). Decide between using a controlled or uncontrolled select element and remove one of these props. More info: https://react.dev/link/controlled-components"
        ),
        (didWarnValueDefaultValue = !0));
    }
    function validateTextareaProps(element, props) {
      void 0 === props.value ||
        void 0 === props.defaultValue ||
        didWarnValDefaultVal ||
        (console.error(
          "%s contains a textarea with both value and defaultValue props. Textarea elements must be either controlled or uncontrolled (specify either the value prop, or the defaultValue prop, but not both). Decide between using a controlled or uncontrolled textarea and remove one of these props. More info: https://react.dev/link/controlled-components",
          getCurrentFiberOwnerNameInDevOrNull() || "A component"
        ),
        (didWarnValDefaultVal = !0));
      null != props.children &&
        null == props.value &&
        console.error(
          "Use the `defaultValue` or `value` props instead of setting children on <textarea>."
        );
    }
    function updateTextarea(element, value, defaultValue) {
      if (
        null != value &&
        ((value = "" + getToStringValue(value)),
        value !== element.value && (element.value = value),
        null == defaultValue)
      ) {
        element.defaultValue !== value && (element.defaultValue = value);
        return;
      }
      element.defaultValue =
        null != defaultValue ? "" + getToStringValue(defaultValue) : "";
    }
    function initTextarea(element, value, defaultValue, children) {
      if (null == value) {
        if (null != children) {
          if (null != defaultValue)
            throw Error(
              "If you supply `defaultValue` on a <textarea>, do not pass children."
            );
          if (isArrayImpl(children)) {
            if (1 < children.length)
              throw Error("<textarea> can only have at most one child.");
            children = children[0];
          }
          defaultValue = children;
        }
        null == defaultValue && (defaultValue = "");
        value = defaultValue;
      }
      defaultValue = getToStringValue(value);
      element.defaultValue = defaultValue;
      children = element.textContent;
      children === defaultValue &&
        "" !== children &&
        null !== children &&
        (element.value = children);
    }
    function findNotableNode(node, indent) {
      return void 0 === node.serverProps &&
        0 === node.serverTail.length &&
        1 === node.children.length &&
        3 < node.distanceFromLeaf &&
        node.distanceFromLeaf > 15 - indent
        ? findNotableNode(node.children[0], indent)
        : node;
    }
    function indentation(indent) {
      return "  " + "  ".repeat(indent);
    }
    function added(indent) {
      return "+ " + "  ".repeat(indent);
    }
    function removed(indent) {
      return "- " + "  ".repeat(indent);
    }
    function describeFiberType(fiber) {
      switch (fiber.tag) {
        case 26:
        case 27:
        case 5:
          return fiber.type;
        case 16:
          return "Lazy";
        case 13:
          return "Suspense";
        case 19:
          return "SuspenseList";
        case 0:
        case 15:
          return (fiber = fiber.type), fiber.displayName || fiber.name || null;
        case 11:
          return (
            (fiber = fiber.type.render), fiber.displayName || fiber.name || null
          );
        case 1:
          return (fiber = fiber.type), fiber.displayName || fiber.name || null;
        default:
          return null;
      }
    }
    function describeTextNode(content, maxLength) {
      return needsEscaping.test(content)
        ? ((content = JSON.stringify(content)),
          content.length > maxLength - 2
            ? 8 > maxLength
              ? '{"..."}'
              : "{" + content.slice(0, maxLength - 7) + '..."}'
            : "{" + content + "}")
        : content.length > maxLength
          ? 5 > maxLength
            ? '{"..."}'
            : content.slice(0, maxLength - 3) + "..."
          : content;
    }
    function describeTextDiff(clientText, serverProps, indent) {
      var maxLength = 120 - 2 * indent;
      if (null === serverProps)
        return added(indent) + describeTextNode(clientText, maxLength) + "\n";
      if ("string" === typeof serverProps) {
        for (
          var firstDiff = 0;
          firstDiff < serverProps.length &&
          firstDiff < clientText.length &&
          serverProps.charCodeAt(firstDiff) ===
            clientText.charCodeAt(firstDiff);
          firstDiff++
        );
        firstDiff > maxLength - 8 &&
          10 < firstDiff &&
          ((clientText = "..." + clientText.slice(firstDiff - 8)),
          (serverProps = "..." + serverProps.slice(firstDiff - 8)));
        return (
          added(indent) +
          describeTextNode(clientText, maxLength) +
          "\n" +
          removed(indent) +
          describeTextNode(serverProps, maxLength) +
          "\n"
        );
      }
      return (
        indentation(indent) + describeTextNode(clientText, maxLength) + "\n"
      );
    }
    function objectName(object) {
      return Object.prototype.toString
        .call(object)
        .replace(/^\[object (.*)\]$/, function (m, p0) {
          return p0;
        });
    }
    function describeValue(value, maxLength) {
      switch (typeof value) {
        case "string":
          return (
            (value = JSON.stringify(value)),
            value.length > maxLength
              ? 5 > maxLength
                ? '"..."'
                : value.slice(0, maxLength - 4) + '..."'
              : value
          );
        case "object":
          if (null === value) return "null";
          if (isArrayImpl(value)) return "[...]";
          if (value.$$typeof === REACT_ELEMENT_TYPE)
            return (maxLength = getComponentNameFromType(value.type))
              ? "<" + maxLength + ">"
              : "<...>";
          var name = objectName(value);
          if ("Object" === name) {
            name = "";
            maxLength -= 2;
            for (var propName in value)
              if (value.hasOwnProperty(propName)) {
                var jsonPropName = JSON.stringify(propName);
                jsonPropName !== '"' + propName + '"' &&
                  (propName = jsonPropName);
                maxLength -= propName.length - 2;
                jsonPropName = describeValue(
                  value[propName],
                  15 > maxLength ? maxLength : 15
                );
                maxLength -= jsonPropName.length;
                if (0 > maxLength) {
                  name += "" === name ? "..." : ", ...";
                  break;
                }
                name +=
                  ("" === name ? "" : ",") + propName + ":" + jsonPropName;
              }
            return "{" + name + "}";
          }
          return name;
        case "function":
          return (maxLength = value.displayName || value.name)
            ? "function " + maxLength
            : "function";
        default:
          return String(value);
      }
    }
    function describePropValue(value, maxLength) {
      return "string" !== typeof value || needsEscaping.test(value)
        ? "{" + describeValue(value, maxLength - 2) + "}"
        : value.length > maxLength - 2
          ? 5 > maxLength
            ? '"..."'
            : '"' + value.slice(0, maxLength - 5) + '..."'
          : '"' + value + '"';
    }
    function describeExpandedElement(type, props, rowPrefix) {
      var remainingRowLength = 120 - rowPrefix.length - type.length,
        properties = [],
        propName;
      for (propName in props)
        if (props.hasOwnProperty(propName) && "children" !== propName) {
          var propValue = describePropValue(
            props[propName],
            120 - rowPrefix.length - propName.length - 1
          );
          remainingRowLength -= propName.length + propValue.length + 2;
          properties.push(propName + "=" + propValue);
        }
      return 0 === properties.length
        ? rowPrefix + "<" + type + ">\n"
        : 0 < remainingRowLength
          ? rowPrefix + "<" + type + " " + properties.join(" ") + ">\n"
          : rowPrefix +
            "<" +
            type +
            "\n" +
            rowPrefix +
            "  " +
            properties.join("\n" + rowPrefix + "  ") +
            "\n" +
            rowPrefix +
            ">\n";
    }
    function describePropertiesDiff(clientObject, serverObject, indent) {
      var properties = "",
        remainingServerProperties = assign({}, serverObject),
        propName;
      for (propName in clientObject)
        if (clientObject.hasOwnProperty(propName)) {
          delete remainingServerProperties[propName];
          var maxLength = 120 - 2 * indent - propName.length - 2,
            clientPropValue = describeValue(clientObject[propName], maxLength);
          serverObject.hasOwnProperty(propName)
            ? ((maxLength = describeValue(serverObject[propName], maxLength)),
              (properties +=
                added(indent) + propName + ": " + clientPropValue + "\n"),
              (properties +=
                removed(indent) + propName + ": " + maxLength + "\n"))
            : (properties +=
                added(indent) + propName + ": " + clientPropValue + "\n");
        }
      for (var _propName in remainingServerProperties)
        remainingServerProperties.hasOwnProperty(_propName) &&
          ((clientObject = describeValue(
            remainingServerProperties[_propName],
            120 - 2 * indent - _propName.length - 2
          )),
          (properties +=
            removed(indent) + _propName + ": " + clientObject + "\n"));
      return properties;
    }
    function describeElementDiff(type, clientProps, serverProps, indent) {
      var content = "",
        serverPropNames = new Map();
      for (propName$jscomp$0 in serverProps)
        serverProps.hasOwnProperty(propName$jscomp$0) &&
          serverPropNames.set(
            propName$jscomp$0.toLowerCase(),
            propName$jscomp$0
          );
      if (1 === serverPropNames.size && serverPropNames.has("children"))
        content += describeExpandedElement(
          type,
          clientProps,
          indentation(indent)
        );
      else {
        for (var _propName2 in clientProps)
          if (
            clientProps.hasOwnProperty(_propName2) &&
            "children" !== _propName2
          ) {
            var maxLength$jscomp$0 =
                120 - 2 * (indent + 1) - _propName2.length - 1,
              serverPropName = serverPropNames.get(_propName2.toLowerCase());
            if (void 0 !== serverPropName) {
              serverPropNames.delete(_propName2.toLowerCase());
              var propName$jscomp$0 = clientProps[_propName2];
              serverPropName = serverProps[serverPropName];
              var clientPropValue = describePropValue(
                propName$jscomp$0,
                maxLength$jscomp$0
              );
              maxLength$jscomp$0 = describePropValue(
                serverPropName,
                maxLength$jscomp$0
              );
              "object" === typeof propName$jscomp$0 &&
              null !== propName$jscomp$0 &&
              "object" === typeof serverPropName &&
              null !== serverPropName &&
              "Object" === objectName(propName$jscomp$0) &&
              "Object" === objectName(serverPropName) &&
              (2 < Object.keys(propName$jscomp$0).length ||
                2 < Object.keys(serverPropName).length ||
                -1 < clientPropValue.indexOf("...") ||
                -1 < maxLength$jscomp$0.indexOf("..."))
                ? (content +=
                    indentation(indent + 1) +
                    _propName2 +
                    "={{\n" +
                    describePropertiesDiff(
                      propName$jscomp$0,
                      serverPropName,
                      indent + 2
                    ) +
                    indentation(indent + 1) +
                    "}}\n")
                : ((content +=
                    added(indent + 1) +
                    _propName2 +
                    "=" +
                    clientPropValue +
                    "\n"),
                  (content +=
                    removed(indent + 1) +
                    _propName2 +
                    "=" +
                    maxLength$jscomp$0 +
                    "\n"));
            } else
              content +=
                indentation(indent + 1) +
                _propName2 +
                "=" +
                describePropValue(clientProps[_propName2], maxLength$jscomp$0) +
                "\n";
          }
        serverPropNames.forEach(function (propName) {
          if ("children" !== propName) {
            var maxLength = 120 - 2 * (indent + 1) - propName.length - 1;
            content +=
              removed(indent + 1) +
              propName +
              "=" +
              describePropValue(serverProps[propName], maxLength) +
              "\n";
          }
        });
        content =
          "" === content
            ? indentation(indent) + "<" + type + ">\n"
            : indentation(indent) +
              "<" +
              type +
              "\n" +
              content +
              indentation(indent) +
              ">\n";
      }
      type = serverProps.children;
      clientProps = clientProps.children;
      if (
        "string" === typeof type ||
        "number" === typeof type ||
        "bigint" === typeof type
      ) {
        serverPropNames = "";
        if (
          "string" === typeof clientProps ||
          "number" === typeof clientProps ||
          "bigint" === typeof clientProps
        )
          serverPropNames = "" + clientProps;
        content += describeTextDiff(serverPropNames, "" + type, indent + 1);
      } else if (
        "string" === typeof clientProps ||
        "number" === typeof clientProps ||
        "bigint" === typeof clientProps
      )
        content =
          null == type
            ? content + describeTextDiff("" + clientProps, null, indent + 1)
            : content + describeTextDiff("" + clientProps, void 0, indent + 1);
      return content;
    }
    function describeSiblingFiber(fiber, indent) {
      var type = describeFiberType(fiber);
      if (null === type) {
        type = "";
        for (fiber = fiber.child; fiber; )
          (type += describeSiblingFiber(fiber, indent)),
            (fiber = fiber.sibling);
        return type;
      }
      return indentation(indent) + "<" + type + ">\n";
    }
    function describeNode(node, indent) {
      var skipToNode = findNotableNode(node, indent);
      if (
        skipToNode !== node &&
        (1 !== node.children.length || node.children[0] !== skipToNode)
      )
        return (
          indentation(indent) + "...\n" + describeNode(skipToNode, indent + 1)
        );
      skipToNode = "";
      var debugInfo = node.fiber._debugInfo;
      if (debugInfo)
        for (var i = 0; i < debugInfo.length; i++) {
          var serverComponentName = debugInfo[i].name;
          "string" === typeof serverComponentName &&
            ((skipToNode +=
              indentation(indent) + "<" + serverComponentName + ">\n"),
            indent++);
        }
      debugInfo = "";
      i = node.fiber.pendingProps;
      if (6 === node.fiber.tag)
        (debugInfo = describeTextDiff(i, node.serverProps, indent)), indent++;
      else if (
        ((serverComponentName = describeFiberType(node.fiber)),
        null !== serverComponentName)
      )
        if (void 0 === node.serverProps) {
          debugInfo = indent;
          var maxLength = 120 - 2 * debugInfo - serverComponentName.length - 2,
            content = "";
          for (propName in i)
            if (i.hasOwnProperty(propName) && "children" !== propName) {
              var propValue = describePropValue(i[propName], 15);
              maxLength -= propName.length + propValue.length + 2;
              if (0 > maxLength) {
                content += " ...";
                break;
              }
              content += " " + propName + "=" + propValue;
            }
          debugInfo =
            indentation(debugInfo) +
            "<" +
            serverComponentName +
            content +
            ">\n";
          indent++;
        } else
          null === node.serverProps
            ? ((debugInfo = describeExpandedElement(
                serverComponentName,
                i,
                added(indent)
              )),
              indent++)
            : "string" === typeof node.serverProps
              ? console.error(
                  "Should not have matched a non HostText fiber to a Text node. This is a bug in React."
                )
              : ((debugInfo = describeElementDiff(
                  serverComponentName,
                  i,
                  node.serverProps,
                  indent
                )),
                indent++);
      var propName = "";
      i = node.fiber.child;
      for (
        serverComponentName = 0;
        i && serverComponentName < node.children.length;

      )
        (maxLength = node.children[serverComponentName]),
          maxLength.fiber === i
            ? ((propName += describeNode(maxLength, indent)),
              serverComponentName++)
            : (propName += describeSiblingFiber(i, indent)),
          (i = i.sibling);
      i &&
        0 < node.children.length &&
        (propName += indentation(indent) + "...\n");
      i = node.serverTail;
      null === node.serverProps && indent--;
      for (node = 0; node < i.length; node++)
        (serverComponentName = i[node]),
          (propName =
            "string" === typeof serverComponentName
              ? propName +
                (removed(indent) +
                  describeTextNode(serverComponentName, 120 - 2 * indent) +
                  "\n")
              : propName +
                describeExpandedElement(
                  serverComponentName.type,
                  serverComponentName.props,
                  removed(indent)
                ));
      return skipToNode + debugInfo + propName;
    }
    function describeDiff(rootNode) {
      try {
        return "\n\n" + describeNode(rootNode, 0);
      } catch (x) {
        return "";
      }
    }
    function describeAncestors(ancestor, child, props) {
      for (var fiber = child, node = null, distanceFromLeaf = 0; fiber; )
        fiber === ancestor && (distanceFromLeaf = 0),
          (node = {
            fiber: fiber,
            children: null !== node ? [node] : [],
            serverProps:
              fiber === child ? props : fiber === ancestor ? null : void 0,
            serverTail: [],
            distanceFromLeaf: distanceFromLeaf
          }),
          distanceFromLeaf++,
          (fiber = fiber.return);
      return null !== node ? describeDiff(node).replaceAll(/^[+-]/gm, ">") : "";
    }
    function updatedAncestorInfoDev(oldInfo, tag) {
      oldInfo = assign({}, oldInfo || emptyAncestorInfoDev);
      var info = { tag: tag };
      -1 !== inScopeTags.indexOf(tag) &&
        ((oldInfo.aTagInScope = null),
        (oldInfo.buttonTagInScope = null),
        (oldInfo.nobrTagInScope = null));
      -1 !== buttonScopeTags.indexOf(tag) && (oldInfo.pTagInButtonScope = null);
      -1 !== specialTags.indexOf(tag) &&
        "address" !== tag &&
        "div" !== tag &&
        "p" !== tag &&
        ((oldInfo.listItemTagAutoclosing = null),
        (oldInfo.dlItemTagAutoclosing = null));
      oldInfo.current = info;
      "form" === tag && (oldInfo.formTag = info);
      "a" === tag && (oldInfo.aTagInScope = info);
      "button" === tag && (oldInfo.buttonTagInScope = info);
      "nobr" === tag && (oldInfo.nobrTagInScope = info);
      "p" === tag && (oldInfo.pTagInButtonScope = info);
      "li" === tag && (oldInfo.listItemTagAutoclosing = info);
      if ("dd" === tag || "dt" === tag) oldInfo.dlItemTagAutoclosing = info;
      "#document" === tag || "html" === tag
        ? (oldInfo.containerTagInScope = null)
        : oldInfo.containerTagInScope || (oldInfo.containerTagInScope = info);
      return oldInfo;
    }
    function isTagValidWithParent(tag, parentTag) {
      switch (parentTag) {
        case "select":
          return (
            "hr" === tag ||
            "option" === tag ||
            "optgroup" === tag ||
            "#text" === tag
          );
        case "optgroup":
          return "option" === tag || "#text" === tag;
        case "option":
          return "#text" === tag;
        case "tr":
          return (
            "th" === tag ||
            "td" === tag ||
            "style" === tag ||
            "script" === tag ||
            "template" === tag
          );
        case "tbody":
        case "thead":
        case "tfoot":
          return (
            "tr" === tag ||
            "style" === tag ||
            "script" === tag ||
            "template" === tag
          );
        case "colgroup":
          return "col" === tag || "template" === tag;
        case "table":
          return (
            "caption" === tag ||
            "colgroup" === tag ||
            "tbody" === tag ||
            "tfoot" === tag ||
            "thead" === tag ||
            "style" === tag ||
            "script" === tag ||
            "template" === tag
          );
        case "head":
          return (
            "base" === tag ||
            "basefont" === tag ||
            "bgsound" === tag ||
            "link" === tag ||
            "meta" === tag ||
            "title" === tag ||
            "noscript" === tag ||
            "noframes" === tag ||
            "style" === tag ||
            "script" === tag ||
            "template" === tag
          );
        case "html":
          return "head" === tag || "body" === tag || "frameset" === tag;
        case "frameset":
          return "frame" === tag;
        case "#document":
          return "html" === tag;
      }
      switch (tag) {
        case "h1":
        case "h2":
        case "h3":
        case "h4":
        case "h5":
        case "h6":
          return (
            "h1" !== parentTag &&
            "h2" !== parentTag &&
            "h3" !== parentTag &&
            "h4" !== parentTag &&
            "h5" !== parentTag &&
            "h6" !== parentTag
          );
        case "rp":
        case "rt":
          return -1 === impliedEndTags.indexOf(parentTag);
        case "body":
        case "caption":
        case "col":
        case "colgroup":
        case "frameset":
        case "frame":
        case "head":
        case "html":
        case "tbody":
        case "td":
        case "tfoot":
        case "th":
        case "thead":
        case "tr":
          return null == parentTag;
      }
      return !0;
    }
    function findInvalidAncestorForTag(tag, ancestorInfo) {
      switch (tag) {
        case "address":
        case "article":
        case "aside":
        case "blockquote":
        case "center":
        case "details":
        case "dialog":
        case "dir":
        case "div":
        case "dl":
        case "fieldset":
        case "figcaption":
        case "figure":
        case "footer":
        case "header":
        case "hgroup":
        case "main":
        case "menu":
        case "nav":
        case "ol":
        case "p":
        case "section":
        case "summary":
        case "ul":
        case "pre":
        case "listing":
        case "table":
        case "hr":
        case "xmp":
        case "h1":
        case "h2":
        case "h3":
        case "h4":
        case "h5":
        case "h6":
          return ancestorInfo.pTagInButtonScope;
        case "form":
          return ancestorInfo.formTag || ancestorInfo.pTagInButtonScope;
        case "li":
          return ancestorInfo.listItemTagAutoclosing;
        case "dd":
        case "dt":
          return ancestorInfo.dlItemTagAutoclosing;
        case "button":
          return ancestorInfo.buttonTagInScope;
        case "a":
          return ancestorInfo.aTagInScope;
        case "nobr":
          return ancestorInfo.nobrTagInScope;
      }
      return null;
    }
    function findAncestor(parent, tagName) {
      for (; parent; ) {
        switch (parent.tag) {
          case 5:
          case 26:
          case 27:
            if (parent.type === tagName) return parent;
        }
        parent = parent.return;
      }
      return null;
    }
    function validateDOMNesting(childTag, ancestorInfo) {
      ancestorInfo = ancestorInfo || emptyAncestorInfoDev;
      var parentInfo = ancestorInfo.current;
      ancestorInfo = (parentInfo = isTagValidWithParent(
        childTag,
        parentInfo && parentInfo.tag
      )
        ? null
        : parentInfo)
        ? null
        : findInvalidAncestorForTag(childTag, ancestorInfo);
      ancestorInfo = parentInfo || ancestorInfo;
      if (!ancestorInfo) return !0;
      ancestorInfo = ancestorInfo.tag;
      var warnKey = String(!!parentInfo) + "|" + childTag + "|" + ancestorInfo;
      if (didWarn[warnKey]) return !1;
      didWarn[warnKey] = !0;
      var ancestor = (warnKey = current)
        ? findAncestor(warnKey.return, ancestorInfo)
        : null;
      warnKey =
        null !== warnKey && null !== ancestor
          ? describeAncestors(ancestor, warnKey, null)
          : "";
      ancestor = "<" + childTag + ">";
      parentInfo
        ? ((parentInfo = ""),
          "table" === ancestorInfo &&
            "tr" === childTag &&
            (parentInfo +=
              " Add a <tbody>, <thead> or <tfoot> to your code to match the DOM tree generated by the browser."),
          console.error(
            "In HTML, %s cannot be a child of <%s>.%s\nThis will cause a hydration error.%s",
            ancestor,
            ancestorInfo,
            parentInfo,
            warnKey
          ))
        : console.error(
            "In HTML, %s cannot be a descendant of <%s>.\nThis will cause a hydration error.%s",
            ancestor,
            ancestorInfo,
            warnKey
          );
      return !1;
    }
    function validateTextNesting(childText, parentTag) {
      if (isTagValidWithParent("#text", parentTag)) return !0;
      var warnKey = "#text|" + parentTag;
      if (didWarn[warnKey]) return !1;
      didWarn[warnKey] = !0;
      var ancestor = (warnKey = current)
        ? findAncestor(warnKey, parentTag)
        : null;
      warnKey =
        null !== warnKey && null !== ancestor
          ? describeAncestors(
              ancestor,
              warnKey,
              6 !== warnKey.tag ? { children: null } : null
            )
          : "";
      /\S/.test(childText)
        ? console.error(
            "In HTML, text nodes cannot be a child of <%s>.\nThis will cause a hydration error.%s",
            parentTag,
            warnKey
          )
        : console.error(
            "In HTML, whitespace text nodes cannot be a child of <%s>. Make sure you don't have any extra whitespace between tags on each line of your source code.\nThis will cause a hydration error.%s",
            parentTag,
            warnKey
          );
      return !1;
    }
    function setTextContent(node, text) {
      if (text) {
        var firstChild = node.firstChild;
        if (
          firstChild &&
          firstChild === node.lastChild &&
          3 === firstChild.nodeType
        ) {
          firstChild.nodeValue = text;
          return;
        }
      }
      node.textContent = text;
    }
    function camelize(string) {
      return string.replace(hyphenPattern, function (_, character) {
        return character.toUpperCase();
      });
    }
    function setValueForStyle(style, styleName, value) {
      var isCustomProperty = 0 === styleName.indexOf("--");
      isCustomProperty ||
        (-1 < styleName.indexOf("-")
          ? (warnedStyleNames.hasOwnProperty(styleName) &&
              warnedStyleNames[styleName]) ||
            ((warnedStyleNames[styleName] = !0),
            console.error(
              "Unsupported style property %s. Did you mean %s?",
              styleName,
              camelize(styleName.replace(msPattern, "ms-"))
            ))
          : badVendoredStyleNamePattern.test(styleName)
            ? (warnedStyleNames.hasOwnProperty(styleName) &&
                warnedStyleNames[styleName]) ||
              ((warnedStyleNames[styleName] = !0),
              console.error(
                "Unsupported vendor-prefixed style property %s. Did you mean %s?",
                styleName,
                styleName.charAt(0).toUpperCase() + styleName.slice(1)
              ))
            : !badStyleValueWithSemicolonPattern.test(value) ||
              (warnedStyleValues.hasOwnProperty(value) &&
                warnedStyleValues[value]) ||
              ((warnedStyleValues[value] = !0),
              console.error(
                'Style property values shouldn\'t contain a semicolon. Try "%s: %s" instead.',
                styleName,
                value.replace(badStyleValueWithSemicolonPattern, "")
              )),
        "number" === typeof value &&
          (isNaN(value)
            ? warnedForNaNValue ||
              ((warnedForNaNValue = !0),
              console.error(
                "`NaN` is an invalid value for the `%s` css style property.",
                styleName
              ))
            : isFinite(value) ||
              warnedForInfinityValue ||
              ((warnedForInfinityValue = !0),
              console.error(
                "`Infinity` is an invalid value for the `%s` css style property.",
                styleName
              ))));
      null == value || "boolean" === typeof value || "" === value
        ? isCustomProperty
          ? style.setProperty(styleName, "")
          : "float" === styleName
            ? (style.cssFloat = "")
            : (style[styleName] = "")
        : isCustomProperty
          ? style.setProperty(styleName, value)
          : "number" !== typeof value ||
              0 === value ||
              unitlessNumbers.has(styleName)
            ? "float" === styleName
              ? (style.cssFloat = value)
              : (checkCSSPropertyStringCoercion(value, styleName),
                (style[styleName] = ("" + value).trim()))
            : (style[styleName] = value + "px");
    }
    function setValueForStyles(node, styles, prevStyles) {
      if (null != styles && "object" !== typeof styles)
        throw Error(
          "The `style` prop expects a mapping from style properties to values, not a string. For example, style={{marginRight: spacing + 'em'}} when using JSX."
        );
      styles && Object.freeze(styles);
      node = node.style;
      if (null != prevStyles) {
        if (styles) {
          var expandedUpdates = {};
          if (prevStyles)
            for (var key in prevStyles)
              if (prevStyles.hasOwnProperty(key) && !styles.hasOwnProperty(key))
                for (
                  var longhands = shorthandToLonghand[key] || [key], i = 0;
                  i < longhands.length;
                  i++
                )
                  expandedUpdates[longhands[i]] = key;
          for (var _key in styles)
            if (
              styles.hasOwnProperty(_key) &&
              (!prevStyles || prevStyles[_key] !== styles[_key])
            )
              for (
                key = shorthandToLonghand[_key] || [_key], longhands = 0;
                longhands < key.length;
                longhands++
              )
                expandedUpdates[key[longhands]] = _key;
          _key = {};
          for (var key$jscomp$0 in styles)
            for (
              key = shorthandToLonghand[key$jscomp$0] || [key$jscomp$0],
                longhands = 0;
              longhands < key.length;
              longhands++
            )
              _key[key[longhands]] = key$jscomp$0;
          key$jscomp$0 = {};
          for (var _key2 in expandedUpdates)
            if (
              ((key = expandedUpdates[_key2]),
              (longhands = _key[_key2]) &&
                key !== longhands &&
                ((i = key + "," + longhands), !key$jscomp$0[i]))
            ) {
              key$jscomp$0[i] = !0;
              i = console;
              var value = styles[key];
              i.error.call(
                i,
                "%s a style property during rerender (%s) when a conflicting property is set (%s) can lead to styling bugs. To avoid this, don't mix shorthand and non-shorthand properties for the same value; instead, replace the shorthand with separate values.",
                null == value || "boolean" === typeof value || "" === value
                  ? "Removing"
                  : "Updating",
                key,
                longhands
              );
            }
        }
        for (var styleName in prevStyles)
          !prevStyles.hasOwnProperty(styleName) ||
            (null != styles && styles.hasOwnProperty(styleName)) ||
            (0 === styleName.indexOf("--")
              ? node.setProperty(styleName, "")
              : "float" === styleName
                ? (node.cssFloat = "")
                : (node[styleName] = ""));
        for (var _styleName in styles)
          (_key2 = styles[_styleName]),
            styles.hasOwnProperty(_styleName) &&
              prevStyles[_styleName] !== _key2 &&
              setValueForStyle(node, _styleName, _key2);
      } else
        for (expandedUpdates in styles)
          styles.hasOwnProperty(expandedUpdates) &&
            setValueForStyle(node, expandedUpdates, styles[expandedUpdates]);
    }
    function isCustomElement(tagName) {
      if (-1 === tagName.indexOf("-")) return !1;
      switch (tagName) {
        case "annotation-xml":
        case "color-profile":
        case "font-face":
        case "font-face-src":
        case "font-face-uri":
        case "font-face-format":
        case "font-face-name":
        case "missing-glyph":
          return !1;
        default:
          return !0;
      }
    }
    function getAttributeAlias(name) {
      return aliases.get(name) || name;
    }
    function validateProperty$1(tagName, name) {
      if (
        hasOwnProperty.call(warnedProperties$1, name) &&
        warnedProperties$1[name]
      )
        return !0;
      if (rARIACamel$1.test(name)) {
        tagName = "aria-" + name.slice(4).toLowerCase();
        tagName = ariaProperties.hasOwnProperty(tagName) ? tagName : null;
        if (null == tagName)
          return (
            console.error(
              "Invalid ARIA attribute `%s`. ARIA attributes follow the pattern aria-* and must be lowercase.",
              name
            ),
            (warnedProperties$1[name] = !0)
          );
        if (name !== tagName)
          return (
            console.error(
              "Invalid ARIA attribute `%s`. Did you mean `%s`?",
              name,
              tagName
            ),
            (warnedProperties$1[name] = !0)
          );
      }
      if (rARIA$1.test(name)) {
        tagName = name.toLowerCase();
        tagName = ariaProperties.hasOwnProperty(tagName) ? tagName : null;
        if (null == tagName) return (warnedProperties$1[name] = !0), !1;
        name !== tagName &&
          (console.error(
            "Unknown ARIA attribute `%s`. Did you mean `%s`?",
            name,
            tagName
          ),
          (warnedProperties$1[name] = !0));
      }
      return !0;
    }
    function validateProperties$2(type, props) {
      var invalidProps = [],
        key;
      for (key in props)
        validateProperty$1(type, key) || invalidProps.push(key);
      props = invalidProps
        .map(function (prop) {
          return "`" + prop + "`";
        })
        .join(", ");
      1 === invalidProps.length
        ? console.error(
            "Invalid aria prop %s on <%s> tag. For details, see https://react.dev/link/invalid-aria-props",
            props,
            type
          )
        : 1 < invalidProps.length &&
          console.error(
            "Invalid aria props %s on <%s> tag. For details, see https://react.dev/link/invalid-aria-props",
            props,
            type
          );
    }
    function validateProperty(tagName, name, value, eventRegistry) {
      if (hasOwnProperty.call(warnedProperties, name) && warnedProperties[name])
        return !0;
      var lowerCasedName = name.toLowerCase();
      if ("onfocusin" === lowerCasedName || "onfocusout" === lowerCasedName)
        return (
          console.error(
            "React uses onFocus and onBlur instead of onFocusIn and onFocusOut. All React events are normalized to bubble, so onFocusIn and onFocusOut are not needed/supported by React."
          ),
          (warnedProperties[name] = !0)
        );
      if (
        "function" === typeof value &&
        (("form" === tagName && "action" === name) ||
          ("input" === tagName && "formAction" === name) ||
          ("button" === tagName && "formAction" === name))
      )
        return !0;
      if (null != eventRegistry) {
        tagName = eventRegistry.possibleRegistrationNames;
        if (eventRegistry.registrationNameDependencies.hasOwnProperty(name))
          return !0;
        eventRegistry = tagName.hasOwnProperty(lowerCasedName)
          ? tagName[lowerCasedName]
          : null;
        if (null != eventRegistry)
          return (
            console.error(
              "Invalid event handler property `%s`. Did you mean `%s`?",
              name,
              eventRegistry
            ),
            (warnedProperties[name] = !0)
          );
        if (EVENT_NAME_REGEX.test(name))
          return (
            console.error(
              "Unknown event handler property `%s`. It will be ignored.",
              name
            ),
            (warnedProperties[name] = !0)
          );
      } else if (EVENT_NAME_REGEX.test(name))
        return (
          INVALID_EVENT_NAME_REGEX.test(name) &&
            console.error(
              "Invalid event handler property `%s`. React events use the camelCase naming convention, for example `onClick`.",
              name
            ),
          (warnedProperties[name] = !0)
        );
      if (rARIA.test(name) || rARIACamel.test(name)) return !0;
      if ("innerhtml" === lowerCasedName)
        return (
          console.error(
            "Directly setting property `innerHTML` is not permitted. For more information, lookup documentation on `dangerouslySetInnerHTML`."
          ),
          (warnedProperties[name] = !0)
        );
      if ("aria" === lowerCasedName)
        return (
          console.error(
            "The `aria` attribute is reserved for future use in React. Pass individual `aria-` attributes instead."
          ),
          (warnedProperties[name] = !0)
        );
      if (
        "is" === lowerCasedName &&
        null !== value &&
        void 0 !== value &&
        "string" !== typeof value
      )
        return (
          console.error(
            "Received a `%s` for a string attribute `is`. If this is expected, cast the value to a string.",
            typeof value
          ),
          (warnedProperties[name] = !0)
        );
      if ("number" === typeof value && isNaN(value))
        return (
          console.error(
            "Received NaN for the `%s` attribute. If this is expected, cast the value to a string.",
            name
          ),
          (warnedProperties[name] = !0)
        );
      if (possibleStandardNames.hasOwnProperty(lowerCasedName)) {
        if (
          ((lowerCasedName = possibleStandardNames[lowerCasedName]),
          lowerCasedName !== name)
        )
          return (
            console.error(
              "Invalid DOM property `%s`. Did you mean `%s`?",
              name,
              lowerCasedName
            ),
            (warnedProperties[name] = !0)
          );
      } else if (name !== lowerCasedName)
        return (
          console.error(
            "React does not recognize the `%s` prop on a DOM element. If you intentionally want it to appear in the DOM as a custom attribute, spell it as lowercase `%s` instead. If you accidentally passed it from a parent component, remove it from the DOM element.",
            name,
            lowerCasedName
          ),
          (warnedProperties[name] = !0)
        );
      switch (name) {
        case "dangerouslySetInnerHTML":
        case "children":
        case "style":
        case "suppressContentEditableWarning":
        case "suppressHydrationWarning":
        case "defaultValue":
        case "defaultChecked":
        case "innerHTML":
        case "ref":
          return !0;
        case "innerText":
        case "textContent":
          return !0;
      }
      switch (typeof value) {
        case "boolean":
          switch (name) {
            case "autoFocus":
            case "checked":
            case "multiple":
            case "muted":
            case "selected":
            case "contentEditable":
            case "spellCheck":
            case "draggable":
            case "value":
            case "autoReverse":
            case "externalResourcesRequired":
            case "focusable":
            case "preserveAlpha":
            case "allowFullScreen":
            case "async":
            case "autoPlay":
            case "controls":
            case "default":
            case "defer":
            case "disabled":
            case "disablePictureInPicture":
            case "disableRemotePlayback":
            case "formNoValidate":
            case "hidden":
            case "loop":
            case "noModule":
            case "noValidate":
            case "open":
            case "playsInline":
            case "readOnly":
            case "required":
            case "reversed":
            case "scoped":
            case "seamless":
            case "itemScope":
            case "capture":
            case "download":
            case "inert":
              return !0;
            default:
              lowerCasedName = name.toLowerCase().slice(0, 5);
              if ("data-" === lowerCasedName || "aria-" === lowerCasedName)
                return !0;
              value
                ? console.error(
                    'Received `%s` for a non-boolean attribute `%s`.\n\nIf you want to write it to the DOM, pass a string instead: %s="%s" or %s={value.toString()}.',
                    value,
                    name,
                    name,
                    value,
                    name
                  )
                : console.error(
                    'Received `%s` for a non-boolean attribute `%s`.\n\nIf you want to write it to the DOM, pass a string instead: %s="%s" or %s={value.toString()}.\n\nIf you used to conditionally omit it with %s={condition && value}, pass %s={condition ? value : undefined} instead.',
                    value,
                    name,
                    name,
                    value,
                    name,
                    name,
                    name
                  );
              return (warnedProperties[name] = !0);
          }
        case "function":
        case "symbol":
          return (warnedProperties[name] = !0), !1;
        case "string":
          if ("false" === value || "true" === value) {
            switch (name) {
              case "checked":
              case "selected":
              case "multiple":
              case "muted":
              case "allowFullScreen":
              case "async":
              case "autoPlay":
              case "controls":
              case "default":
              case "defer":
              case "disabled":
              case "disablePictureInPicture":
              case "disableRemotePlayback":
              case "formNoValidate":
              case "hidden":
              case "loop":
              case "noModule":
              case "noValidate":
              case "open":
              case "playsInline":
              case "readOnly":
              case "required":
              case "reversed":
              case "scoped":
              case "seamless":
              case "itemScope":
              case "inert":
                break;
              default:
                return !0;
            }
            console.error(
              "Received the string `%s` for the boolean attribute `%s`. %s Did you mean %s={%s}?",
              value,
              name,
              "false" === value
                ? "The browser will interpret it as a truthy value."
                : 'Although this works, it will not work as expected if you pass the string "false".',
              name,
              value
            );
            warnedProperties[name] = !0;
          }
      }
      return !0;
    }
    function warnUnknownProperties(type, props, eventRegistry) {
      var unknownProps = [],
        key;
      for (key in props)
        validateProperty(type, key, props[key], eventRegistry) ||
          unknownProps.push(key);
      props = unknownProps
        .map(function (prop) {
          return "`" + prop + "`";
        })
        .join(", ");
      1 === unknownProps.length
        ? console.error(
            "Invalid value for prop %s on <%s> tag. Either remove it from the element, or pass a string or number value to keep it in the DOM. For details, see https://react.dev/link/attribute-behavior ",
            props,
            type
          )
        : 1 < unknownProps.length &&
          console.error(
            "Invalid values for props %s on <%s> tag. Either remove them from the element, or pass a string or number value to keep them in the DOM. For details, see https://react.dev/link/attribute-behavior ",
            props,
            type
          );
    }
    function sanitizeURL(url) {
      return isJavaScriptProtocol.test("" + url)
        ? "javascript:throw new Error('React has blocked a javascript: URL as a security precaution.')"
        : url;
    }
    function getEventTarget(nativeEvent) {
      nativeEvent = nativeEvent.target || nativeEvent.srcElement || window;
      nativeEvent.correspondingUseElement &&
        (nativeEvent = nativeEvent.correspondingUseElement);
      return 3 === nativeEvent.nodeType ? nativeEvent.parentNode : nativeEvent;
    }
    function restoreStateOfTarget(target) {
      var internalInstance = getInstanceFromNode(target);
      if (internalInstance && (target = internalInstance.stateNode)) {
        var props = target[internalPropsKey] || null;
        a: switch (
          ((target = internalInstance.stateNode), internalInstance.type)
        ) {
          case "input":
            updateInput(
              target,
              props.value,
              props.defaultValue,
              props.defaultValue,
              props.checked,
              props.defaultChecked,
              props.type,
              props.name
            );
            internalInstance = props.name;
            if ("radio" === props.type && null != internalInstance) {
              for (props = target; props.parentNode; ) props = props.parentNode;
              checkAttributeStringCoercion(internalInstance, "name");
              props = props.querySelectorAll(
                'input[name="' +
                  escapeSelectorAttributeValueInsideDoubleQuotes(
                    "" + internalInstance
                  ) +
                  '"][type="radio"]'
              );
              for (
                internalInstance = 0;
                internalInstance < props.length;
                internalInstance++
              ) {
                var otherNode = props[internalInstance];
                if (otherNode !== target && otherNode.form === target.form) {
                  var otherProps = otherNode[internalPropsKey] || null;
                  if (!otherProps)
                    throw Error(
                      "ReactDOMInput: Mixing React and non-React radio inputs with the same `name` is not supported."
                    );
                  updateInput(
                    otherNode,
                    otherProps.value,
                    otherProps.defaultValue,
                    otherProps.defaultValue,
                    otherProps.checked,
                    otherProps.defaultChecked,
                    otherProps.type,
                    otherProps.name
                  );
                }
              }
              for (
                internalInstance = 0;
                internalInstance < props.length;
                internalInstance++
              )
                (otherNode = props[internalInstance]),
                  otherNode.form === target.form &&
                    updateValueIfChanged(otherNode);
            }
            break a;
          case "textarea":
            updateTextarea(target, props.value, props.defaultValue);
            break a;
          case "select":
            (internalInstance = props.value),
              null != internalInstance &&
                updateOptions(target, !!props.multiple, internalInstance, !1);
        }
      }
    }
    function batchedUpdates$1(fn, a, b) {
      if (isInsideEventHandler) return fn(a, b);
      isInsideEventHandler = !0;
      try {
        var JSCompiler_inline_result = fn(a);
        return JSCompiler_inline_result;
      } finally {
        if (
          ((isInsideEventHandler = !1),
          null !== restoreTarget || null !== restoreQueue)
        )
          if (
            (flushSyncWork$1(),
            restoreTarget &&
              ((a = restoreTarget),
              (fn = restoreQueue),
              (restoreQueue = restoreTarget = null),
              restoreStateOfTarget(a),
              fn))
          )
            for (a = 0; a < fn.length; a++) restoreStateOfTarget(fn[a]);
      }
    }
    function getListener(inst, registrationName) {
      var stateNode = inst.stateNode;
      if (null === stateNode) return null;
      var props = stateNode[internalPropsKey] || null;
      if (null === props) return null;
      stateNode = props[registrationName];
      a: switch (registrationName) {
        case "onClick":
        case "onClickCapture":
        case "onDoubleClick":
        case "onDoubleClickCapture":
        case "onMouseDown":
        case "onMouseDownCapture":
        case "onMouseMove":
        case "onMouseMoveCapture":
        case "onMouseUp":
        case "onMouseUpCapture":
        case "onMouseEnter":
          (props = !props.disabled) ||
            ((inst = inst.type),
            (props = !(
              "button" === inst ||
              "input" === inst ||
              "select" === inst ||
              "textarea" === inst
            )));
          inst = !props;
          break a;
        default:
          inst = !1;
      }
      if (inst) return null;
      if (stateNode && "function" !== typeof stateNode)
        throw Error(
          "Expected `" +
            registrationName +
            "` listener to be a function, instead got a value of `" +
            typeof stateNode +
            "` type."
        );
      return stateNode;
    }
    function getData() {
      if (fallbackText) return fallbackText;
      var start,
        startValue = startText,
        startLength = startValue.length,
        end,
        endValue = "value" in root ? root.value : root.textContent,
        endLength = endValue.length;
      for (
        start = 0;
        start < startLength && startValue[start] === endValue[start];
        start++
      );
      var minEnd = startLength - start;
      for (
        end = 1;
        end <= minEnd &&
        startValue[startLength - end] === endValue[endLength - end];
        end++
      );
      return (fallbackText = endValue.slice(start, 1 < end ? 1 - end : void 0));
    }
    function getEventCharCode(nativeEvent) {
      var keyCode = nativeEvent.keyCode;
      "charCode" in nativeEvent
        ? ((nativeEvent = nativeEvent.charCode),
          0 === nativeEvent && 13 === keyCode && (nativeEvent = 13))
        : (nativeEvent = keyCode);
      10 === nativeEvent && (nativeEvent = 13);
      return 32 <= nativeEvent || 13 === nativeEvent ? nativeEvent : 0;
    }
    function functionThatReturnsTrue() {
      return !0;
    }
    function functionThatReturnsFalse() {
      return !1;
    }
    function createSyntheticEvent(Interface) {
      function SyntheticBaseEvent(
        reactName,
        reactEventType,
        targetInst,
        nativeEvent,
        nativeEventTarget
      ) {
        this._reactName = reactName;
        this._targetInst = targetInst;
        this.type = reactEventType;
        this.nativeEvent = nativeEvent;
        this.target = nativeEventTarget;
        this.currentTarget = null;
        for (var propName in Interface)
          Interface.hasOwnProperty(propName) &&
            ((reactName = Interface[propName]),
            (this[propName] = reactName
              ? reactName(nativeEvent)
              : nativeEvent[propName]));
        this.isDefaultPrevented = (
          null != nativeEvent.defaultPrevented
            ? nativeEvent.defaultPrevented
            : !1 === nativeEvent.returnValue
        )
          ? functionThatReturnsTrue
          : functionThatReturnsFalse;
        this.isPropagationStopped = functionThatReturnsFalse;
        return this;
      }
      assign(SyntheticBaseEvent.prototype, {
        preventDefault: function () {
          this.defaultPrevented = !0;
          var event = this.nativeEvent;
          event &&
            (event.preventDefault
              ? event.preventDefault()
              : "unknown" !== typeof event.returnValue &&
                (event.returnValue = !1),
            (this.isDefaultPrevented = functionThatReturnsTrue));
        },
        stopPropagation: function () {
          var event = this.nativeEvent;
          event &&
            (event.stopPropagation
              ? event.stopPropagation()
              : "unknown" !== typeof event.cancelBubble &&
                (event.cancelBubble = !0),
            (this.isPropagationStopped = functionThatReturnsTrue));
        },
        persist: function () {},
        isPersistent: functionThatReturnsTrue
      });
      return SyntheticBaseEvent;
    }
    function modifierStateGetter(keyArg) {
      var nativeEvent = this.nativeEvent;
      return nativeEvent.getModifierState
        ? nativeEvent.getModifierState(keyArg)
        : (keyArg = modifierKeyToProp[keyArg])
          ? !!nativeEvent[keyArg]
          : !1;
    }
    function getEventModifierState() {
      return modifierStateGetter;
    }
    function isFallbackCompositionEnd(domEventName, nativeEvent) {
      switch (domEventName) {
        case "keyup":
          return -1 !== END_KEYCODES.indexOf(nativeEvent.keyCode);
        case "keydown":
          return nativeEvent.keyCode !== START_KEYCODE;
        case "keypress":
        case "mousedown":
        case "focusout":
          return !0;
        default:
          return !1;
      }
    }
    function getDataFromCustomEvent(nativeEvent) {
      nativeEvent = nativeEvent.detail;
      return "object" === typeof nativeEvent && "data" in nativeEvent
        ? nativeEvent.data
        : null;
    }
    function getNativeBeforeInputChars(domEventName, nativeEvent) {
      switch (domEventName) {
        case "compositionend":
          return getDataFromCustomEvent(nativeEvent);
        case "keypress":
          if (nativeEvent.which !== SPACEBAR_CODE) return null;
          hasSpaceKeypress = !0;
          return SPACEBAR_CHAR;
        case "textInput":
          return (
            (domEventName = nativeEvent.data),
            domEventName === SPACEBAR_CHAR && hasSpaceKeypress
              ? null
              : domEventName
          );
        default:
          return null;
      }
    }
    function getFallbackBeforeInputChars(domEventName, nativeEvent) {
      if (isComposing)
        return "compositionend" === domEventName ||
          (!canUseCompositionEvent &&
            isFallbackCompositionEnd(domEventName, nativeEvent))
          ? ((domEventName = getData()),
            (fallbackText = startText = root = null),
            (isComposing = !1),
            domEventName)
          : null;
      switch (domEventName) {
        case "paste":
          return null;
        case "keypress":
          if (
            !(
              nativeEvent.ctrlKey ||
              nativeEvent.altKey ||
              nativeEvent.metaKey
            ) ||
            (nativeEvent.ctrlKey && nativeEvent.altKey)
          ) {
            if (nativeEvent.char && 1 < nativeEvent.char.length)
              return nativeEvent.char;
            if (nativeEvent.which)
              return String.fromCharCode(nativeEvent.which);
          }
          return null;
        case "compositionend":
          return useFallbackCompositionData && "ko" !== nativeEvent.locale
            ? null
            : nativeEvent.data;
        default:
          return null;
      }
    }
    function isTextInputElement(elem) {
      var nodeName = elem && elem.nodeName && elem.nodeName.toLowerCase();
      return "input" === nodeName
        ? !!supportedInputTypes[elem.type]
        : "textarea" === nodeName
          ? !0
          : !1;
    }
    function isEventSupported(eventNameSuffix) {
      if (!canUseDOM) return !1;
      eventNameSuffix = "on" + eventNameSuffix;
      var isSupported = eventNameSuffix in document;
      isSupported ||
        ((isSupported = document.createElement("div")),
        isSupported.setAttribute(eventNameSuffix, "return;"),
        (isSupported = "function" === typeof isSupported[eventNameSuffix]));
      return isSupported;
    }
    function createAndAccumulateChangeEvent(
      dispatchQueue,
      inst,
      nativeEvent,
      target
    ) {
      restoreTarget
        ? restoreQueue
          ? restoreQueue.push(target)
          : (restoreQueue = [target])
        : (restoreTarget = target);
      inst = accumulateTwoPhaseListeners(inst, "onChange");
      0 < inst.length &&
        ((nativeEvent = new SyntheticEvent(
          "onChange",
          "change",
          null,
          nativeEvent,
          target
        )),
        dispatchQueue.push({ event: nativeEvent, listeners: inst }));
    }
    function runEventInBatch(dispatchQueue) {
      processDispatchQueue(dispatchQueue, 0);
    }
    function getInstIfValueChanged(targetInst) {
      var targetNode = getNodeFromInstance(targetInst);
      if (updateValueIfChanged(targetNode)) return targetInst;
    }
    function getTargetInstForChangeEvent(domEventName, targetInst) {
      if ("change" === domEventName) return targetInst;
    }
    function stopWatchingForValueChange() {
      activeElement$1 &&
        (activeElement$1.detachEvent("onpropertychange", handlePropertyChange),
        (activeElementInst$1 = activeElement$1 = null));
    }
    function handlePropertyChange(nativeEvent) {
      if (
        "value" === nativeEvent.propertyName &&
        getInstIfValueChanged(activeElementInst$1)
      ) {
        var dispatchQueue = [];
        createAndAccumulateChangeEvent(
          dispatchQueue,
          activeElementInst$1,
          nativeEvent,
          getEventTarget(nativeEvent)
        );
        batchedUpdates$1(runEventInBatch, dispatchQueue);
      }
    }
    function handleEventsForInputEventPolyfill(
      domEventName,
      target,
      targetInst
    ) {
      "focusin" === domEventName
        ? (stopWatchingForValueChange(),
          (activeElement$1 = target),
          (activeElementInst$1 = targetInst),
          activeElement$1.attachEvent("onpropertychange", handlePropertyChange))
        : "focusout" === domEventName && stopWatchingForValueChange();
    }
    function getTargetInstForInputEventPolyfill(domEventName) {
      if (
        "selectionchange" === domEventName ||
        "keyup" === domEventName ||
        "keydown" === domEventName
      )
        return getInstIfValueChanged(activeElementInst$1);
    }
    function getTargetInstForClickEvent(domEventName, targetInst) {
      if ("click" === domEventName) return getInstIfValueChanged(targetInst);
    }
    function getTargetInstForInputOrChangeEvent(domEventName, targetInst) {
      if ("input" === domEventName || "change" === domEventName)
        return getInstIfValueChanged(targetInst);
    }
    function is(x, y) {
      return (x === y && (0 !== x || 1 / x === 1 / y)) || (x !== x && y !== y);
    }
    function shallowEqual(objA, objB) {
      if (objectIs(objA, objB)) return !0;
      if (
        "object" !== typeof objA ||
        null === objA ||
        "object" !== typeof objB ||
        null === objB
      )
        return !1;
      var keysA = Object.keys(objA),
        keysB = Object.keys(objB);
      if (keysA.length !== keysB.length) return !1;
      for (keysB = 0; keysB < keysA.length; keysB++) {
        var currentKey = keysA[keysB];
        if (
          !hasOwnProperty.call(objB, currentKey) ||
          !objectIs(objA[currentKey], objB[currentKey])
        )
          return !1;
      }
      return !0;
    }
    function getLeafNode(node) {
      for (; node && node.firstChild; ) node = node.firstChild;
      return node;
    }
    function getNodeForCharacterOffset(root, offset) {
      var node = getLeafNode(root);
      root = 0;
      for (var nodeEnd; node; ) {
        if (3 === node.nodeType) {
          nodeEnd = root + node.textContent.length;
          if (root <= offset && nodeEnd >= offset)
            return { node: node, offset: offset - root };
          root = nodeEnd;
        }
        a: {
          for (; node; ) {
            if (node.nextSibling) {
              node = node.nextSibling;
              break a;
            }
            node = node.parentNode;
          }
          node = void 0;
        }
        node = getLeafNode(node);
      }
    }
    function containsNode(outerNode, innerNode) {
      return outerNode && innerNode
        ? outerNode === innerNode
          ? !0
          : outerNode && 3 === outerNode.nodeType
            ? !1
            : innerNode && 3 === innerNode.nodeType
              ? containsNode(outerNode, innerNode.parentNode)
              : "contains" in outerNode
                ? outerNode.contains(innerNode)
                : outerNode.compareDocumentPosition
                  ? !!(outerNode.compareDocumentPosition(innerNode) & 16)
                  : !1
        : !1;
    }
    function getActiveElementDeep(containerInfo) {
      containerInfo =
        null != containerInfo &&
        null != containerInfo.ownerDocument &&
        null != containerInfo.ownerDocument.defaultView
          ? containerInfo.ownerDocument.defaultView
          : window;
      for (
        var element = getActiveElement(containerInfo.document);
        element instanceof containerInfo.HTMLIFrameElement;

      ) {
        try {
          var JSCompiler_inline_result =
            "string" === typeof element.contentWindow.location.href;
        } catch (err) {
          JSCompiler_inline_result = !1;
        }
        if (JSCompiler_inline_result) containerInfo = element.contentWindow;
        else break;
        element = getActiveElement(containerInfo.document);
      }
      return element;
    }
    function hasSelectionCapabilities(elem) {
      var nodeName = elem && elem.nodeName && elem.nodeName.toLowerCase();
      return (
        nodeName &&
        (("input" === nodeName &&
          ("text" === elem.type ||
            "search" === elem.type ||
            "tel" === elem.type ||
            "url" === elem.type ||
            "password" === elem.type)) ||
          "textarea" === nodeName ||
          "true" === elem.contentEditable)
      );
    }
    function restoreSelection(priorSelectionInformation, containerInfo) {
      var curFocusedElem = getActiveElementDeep(containerInfo);
      containerInfo = priorSelectionInformation.focusedElem;
      var priorSelectionRange = priorSelectionInformation.selectionRange;
      if (
        curFocusedElem !== containerInfo &&
        containerInfo &&
        containerInfo.ownerDocument &&
        containsNode(containerInfo.ownerDocument.documentElement, containerInfo)
      ) {
        if (
          null !== priorSelectionRange &&
          hasSelectionCapabilities(containerInfo)
        )
          if (
            ((priorSelectionInformation = priorSelectionRange.start),
            (curFocusedElem = priorSelectionRange.end),
            void 0 === curFocusedElem &&
              (curFocusedElem = priorSelectionInformation),
            "selectionStart" in containerInfo)
          )
            (containerInfo.selectionStart = priorSelectionInformation),
              (containerInfo.selectionEnd = Math.min(
                curFocusedElem,
                containerInfo.value.length
              ));
          else if (
            ((curFocusedElem =
              ((priorSelectionInformation =
                containerInfo.ownerDocument || document) &&
                priorSelectionInformation.defaultView) ||
              window),
            curFocusedElem.getSelection)
          ) {
            curFocusedElem = curFocusedElem.getSelection();
            var length = containerInfo.textContent.length,
              start = Math.min(priorSelectionRange.start, length);
            priorSelectionRange =
              void 0 === priorSelectionRange.end
                ? start
                : Math.min(priorSelectionRange.end, length);
            !curFocusedElem.extend &&
              start > priorSelectionRange &&
              ((length = priorSelectionRange),
              (priorSelectionRange = start),
              (start = length));
            length = getNodeForCharacterOffset(containerInfo, start);
            var endMarker = getNodeForCharacterOffset(
              containerInfo,
              priorSelectionRange
            );
            length &&
              endMarker &&
              (1 !== curFocusedElem.rangeCount ||
                curFocusedElem.anchorNode !== length.node ||
                curFocusedElem.anchorOffset !== length.offset ||
                curFocusedElem.focusNode !== endMarker.node ||
                curFocusedElem.focusOffset !== endMarker.offset) &&
              ((priorSelectionInformation =
                priorSelectionInformation.createRange()),
              priorSelectionInformation.setStart(length.node, length.offset),
              curFocusedElem.removeAllRanges(),
              start > priorSelectionRange
                ? (curFocusedElem.addRange(priorSelectionInformation),
                  curFocusedElem.extend(endMarker.node, endMarker.offset))
                : (priorSelectionInformation.setEnd(
                    endMarker.node,
                    endMarker.offset
                  ),
                  curFocusedElem.addRange(priorSelectionInformation)));
          }
        priorSelectionInformation = [];
        for (
          curFocusedElem = containerInfo;
          (curFocusedElem = curFocusedElem.parentNode);

        )
          1 === curFocusedElem.nodeType &&
            priorSelectionInformation.push({
              element: curFocusedElem,
              left: curFocusedElem.scrollLeft,
              top: curFocusedElem.scrollTop
            });
        "function" === typeof containerInfo.focus && containerInfo.focus();
        for (
          containerInfo = 0;
          containerInfo < priorSelectionInformation.length;
          containerInfo++
        )
          (curFocusedElem = priorSelectionInformation[containerInfo]),
            (curFocusedElem.element.scrollLeft = curFocusedElem.left),
            (curFocusedElem.element.scrollTop = curFocusedElem.top);
      }
    }
    function constructSelectEvent(
      dispatchQueue,
      nativeEvent,
      nativeEventTarget
    ) {
      var doc =
        nativeEventTarget.window === nativeEventTarget
          ? nativeEventTarget.document
          : 9 === nativeEventTarget.nodeType
            ? nativeEventTarget
            : nativeEventTarget.ownerDocument;
      mouseDown ||
        null == activeElement ||
        activeElement !== getActiveElement(doc) ||
        ((doc = activeElement),
        "selectionStart" in doc && hasSelectionCapabilities(doc)
          ? (doc = { start: doc.selectionStart, end: doc.selectionEnd })
          : ((doc = (
              (doc.ownerDocument && doc.ownerDocument.defaultView) ||
              window
            ).getSelection()),
            (doc = {
              anchorNode: doc.anchorNode,
              anchorOffset: doc.anchorOffset,
              focusNode: doc.focusNode,
              focusOffset: doc.focusOffset
            })),
        (lastSelection && shallowEqual(lastSelection, doc)) ||
          ((lastSelection = doc),
          (doc = accumulateTwoPhaseListeners(activeElementInst, "onSelect")),
          0 < doc.length &&
            ((nativeEvent = new SyntheticEvent(
              "onSelect",
              "select",
              null,
              nativeEvent,
              nativeEventTarget
            )),
            dispatchQueue.push({ event: nativeEvent, listeners: doc }),
            (nativeEvent.target = activeElement))));
    }
    function makePrefixMap(styleProp, eventName) {
      var prefixes = {};
      prefixes[styleProp.toLowerCase()] = eventName.toLowerCase();
      prefixes["Webkit" + styleProp] = "webkit" + eventName;
      prefixes["Moz" + styleProp] = "moz" + eventName;
      return prefixes;
    }
    function getVendorPrefixedEventName(eventName) {
      if (prefixedEventNames[eventName]) return prefixedEventNames[eventName];
      if (!vendorPrefixes[eventName]) return eventName;
      var prefixMap = vendorPrefixes[eventName],
        styleProp;
      for (styleProp in prefixMap)
        if (prefixMap.hasOwnProperty(styleProp) && styleProp in style)
          return (prefixedEventNames[eventName] = prefixMap[styleProp]);
      return eventName;
    }
    function registerSimpleEvent(domEventName, reactName) {
      topLevelEventsToReactNames.set(domEventName, reactName);
      registerTwoPhaseEvent(reactName, [domEventName]);
    }
    function finishQueueingConcurrentUpdates() {
      for (
        var endIndex = concurrentQueuesIndex,
          i = (concurrentlyUpdatedLanes = concurrentQueuesIndex = 0);
        i < endIndex;

      ) {
        var fiber = concurrentQueues[i];
        concurrentQueues[i++] = null;
        var queue = concurrentQueues[i];
        concurrentQueues[i++] = null;
        var update = concurrentQueues[i];
        concurrentQueues[i++] = null;
        var lane = concurrentQueues[i];
        concurrentQueues[i++] = null;
        if (null !== queue && null !== update) {
          var pending = queue.pending;
          null === pending
            ? (update.next = update)
            : ((update.next = pending.next), (pending.next = update));
          queue.pending = update;
        }
        0 !== lane && markUpdateLaneFromFiberToRoot(fiber, update, lane);
      }
    }
    function enqueueUpdate$1(fiber, queue, update, lane) {
      concurrentQueues[concurrentQueuesIndex++] = fiber;
      concurrentQueues[concurrentQueuesIndex++] = queue;
      concurrentQueues[concurrentQueuesIndex++] = update;
      concurrentQueues[concurrentQueuesIndex++] = lane;
      concurrentlyUpdatedLanes |= lane;
      fiber.lanes |= lane;
      fiber = fiber.alternate;
      null !== fiber && (fiber.lanes |= lane);
    }
    function enqueueConcurrentHookUpdate(fiber, queue, update, lane) {
      enqueueUpdate$1(fiber, queue, update, lane);
      return getRootForUpdatedFiber(fiber);
    }
    function enqueueConcurrentRenderForLane(fiber, lane) {
      enqueueUpdate$1(fiber, null, null, lane);
      return getRootForUpdatedFiber(fiber);
    }
    function markUpdateLaneFromFiberToRoot(sourceFiber, update, lane) {
      sourceFiber.lanes |= lane;
      var alternate = sourceFiber.alternate;
      null !== alternate && (alternate.lanes |= lane);
      for (var isHidden = !1, parent = sourceFiber.return; null !== parent; )
        (parent.childLanes |= lane),
          (alternate = parent.alternate),
          null !== alternate && (alternate.childLanes |= lane),
          22 === parent.tag &&
            ((sourceFiber = parent.stateNode),
            null === sourceFiber ||
              sourceFiber._visibility & OffscreenVisible ||
              (isHidden = !0)),
          (sourceFiber = parent),
          (parent = parent.return);
      isHidden &&
        null !== update &&
        3 === sourceFiber.tag &&
        ((parent = sourceFiber.stateNode),
        (isHidden = 31 - clz32(lane)),
        (parent = parent.hiddenUpdates),
        (sourceFiber = parent[isHidden]),
        null === sourceFiber
          ? (parent[isHidden] = [update])
          : sourceFiber.push(update),
        (update.lane = lane | 536870912));
    }
    function getRootForUpdatedFiber(sourceFiber) {
      if (nestedUpdateCount > NESTED_UPDATE_LIMIT)
        throw (
          ((nestedPassiveUpdateCount = nestedUpdateCount = 0),
          (rootWithPassiveNestedUpdates = rootWithNestedUpdates = null),
          Error(
            "Maximum update depth exceeded. This can happen when a component repeatedly calls setState inside componentWillUpdate or componentDidUpdate. React limits the number of nested updates to prevent infinite loops."
          ))
        );
      nestedPassiveUpdateCount > NESTED_PASSIVE_UPDATE_LIMIT &&
        ((nestedPassiveUpdateCount = 0),
        (rootWithPassiveNestedUpdates = null),
        console.error(
          "Maximum update depth exceeded. This can happen when a component calls setState inside useEffect, but useEffect either doesn't have a dependency array, or one of the dependencies changes on every render."
        ));
      null === sourceFiber.alternate &&
        0 !== (sourceFiber.flags & 4098) &&
        warnAboutUpdateOnNotYetMountedFiberInDEV(sourceFiber);
      for (var node = sourceFiber, parent = node.return; null !== parent; )
        null === node.alternate &&
          0 !== (node.flags & 4098) &&
          warnAboutUpdateOnNotYetMountedFiberInDEV(sourceFiber),
          (node = parent),
          (parent = node.return);
      return 3 === node.tag ? node.stateNode : null;
    }
    function resolveFunctionForHotReloading(type) {
      if (null === resolveFamily) return type;
      var family = resolveFamily(type);
      return void 0 === family ? type : family.current;
    }
    function resolveForwardRefForHotReloading(type) {
      if (null === resolveFamily) return type;
      var family = resolveFamily(type);
      return void 0 === family
        ? null !== type &&
          void 0 !== type &&
          "function" === typeof type.render &&
          ((family = resolveFunctionForHotReloading(type.render)),
          type.render !== family)
          ? ((family = { $$typeof: REACT_FORWARD_REF_TYPE, render: family }),
            void 0 !== type.displayName &&
              (family.displayName = type.displayName),
            family)
          : type
        : family.current;
    }
    function isCompatibleFamilyForHotReloading(fiber, element) {
      if (null === resolveFamily) return !1;
      var prevType = fiber.elementType;
      element = element.type;
      var needsCompareFamilies = !1,
        $$typeofNextType =
          "object" === typeof element && null !== element
            ? element.$$typeof
            : null;
      switch (fiber.tag) {
        case 1:
          "function" === typeof element && (needsCompareFamilies = !0);
          break;
        case 0:
          "function" === typeof element
            ? (needsCompareFamilies = !0)
            : $$typeofNextType === REACT_LAZY_TYPE &&
              (needsCompareFamilies = !0);
          break;
        case 11:
          $$typeofNextType === REACT_FORWARD_REF_TYPE
            ? (needsCompareFamilies = !0)
            : $$typeofNextType === REACT_LAZY_TYPE &&
              (needsCompareFamilies = !0);
          break;
        case 14:
        case 15:
          $$typeofNextType === REACT_MEMO_TYPE
            ? (needsCompareFamilies = !0)
            : $$typeofNextType === REACT_LAZY_TYPE &&
              (needsCompareFamilies = !0);
          break;
        default:
          return !1;
      }
      return needsCompareFamilies &&
        ((fiber = resolveFamily(prevType)),
        void 0 !== fiber && fiber === resolveFamily(element))
        ? !0
        : !1;
    }
    function markFailedErrorBoundaryForHotReloading(fiber) {
      null !== resolveFamily &&
        "function" === typeof WeakSet &&
        (null === failedBoundaries && (failedBoundaries = new WeakSet()),
        failedBoundaries.add(fiber));
    }
    function scheduleFibersWithFamiliesRecursively(
      fiber,
      updatedFamilies,
      staleFamilies
    ) {
      var alternate = fiber.alternate,
        child = fiber.child,
        sibling = fiber.sibling,
        tag = fiber.tag,
        type = fiber.type,
        candidateType = null;
      switch (tag) {
        case 0:
        case 15:
        case 1:
          candidateType = type;
          break;
        case 11:
          candidateType = type.render;
      }
      if (null === resolveFamily)
        throw Error("Expected resolveFamily to be set during hot reload.");
      var needsRender = !1;
      type = !1;
      null !== candidateType &&
        ((candidateType = resolveFamily(candidateType)),
        void 0 !== candidateType &&
          (staleFamilies.has(candidateType)
            ? (type = !0)
            : updatedFamilies.has(candidateType) &&
              (1 === tag ? (type = !0) : (needsRender = !0))));
      null !== failedBoundaries &&
        (failedBoundaries.has(fiber) ||
          (null !== alternate && failedBoundaries.has(alternate))) &&
        (type = !0);
      type && (fiber._debugNeedsRemount = !0);
      if (type || needsRender)
        (alternate = enqueueConcurrentRenderForLane(fiber, 2)),
          null !== alternate && scheduleUpdateOnFiber(alternate, fiber, 2);
      null === child ||
        type ||
        scheduleFibersWithFamiliesRecursively(
          child,
          updatedFamilies,
          staleFamilies
        );
      null !== sibling &&
        scheduleFibersWithFamiliesRecursively(
          sibling,
          updatedFamilies,
          staleFamilies
        );
    }
    function pushNestedEffectDurations() {
      var prevEffectDuration = profilerEffectDuration;
      profilerEffectDuration = 0;
      return prevEffectDuration;
    }
    function popNestedEffectDurations(prevEffectDuration) {
      var elapsedTime = profilerEffectDuration;
      profilerEffectDuration = prevEffectDuration;
      return elapsedTime;
    }
    function bubbleNestedEffectDurations(prevEffectDuration) {
      var elapsedTime = profilerEffectDuration;
      profilerEffectDuration += prevEffectDuration;
      return elapsedTime;
    }
    function startProfilerTimer(fiber) {
      profilerStartTime = now();
      0 > fiber.actualStartTime && (fiber.actualStartTime = profilerStartTime);
    }
    function stopProfilerTimerIfRunningAndRecordDuration(fiber) {
      if (0 <= profilerStartTime) {
        var elapsedTime = now() - profilerStartTime;
        fiber.actualDuration += elapsedTime;
        fiber.selfBaseDuration = elapsedTime;
        profilerStartTime = -1;
      }
    }
    function stopProfilerTimerIfRunningAndRecordIncompleteDuration(fiber) {
      if (0 <= profilerStartTime) {
        var elapsedTime = now() - profilerStartTime;
        fiber.actualDuration += elapsedTime;
        profilerStartTime = -1;
      }
    }
    function recordEffectDuration() {
      if (0 <= profilerStartTime) {
        var elapsedTime = now() - profilerStartTime;
        profilerStartTime = -1;
        profilerEffectDuration += elapsedTime;
      }
    }
    function startEffectTimer() {
      profilerStartTime = now();
    }
    function transferActualDuration(fiber) {
      for (var child = fiber.child; child; )
        (fiber.actualDuration += child.actualDuration), (child = child.sibling);
    }
    function createCapturedValueAtFiber(value, source) {
      if ("object" === typeof value && null !== value) {
        var existing = CapturedStacks.get(value);
        if (void 0 !== existing) return existing;
        source = {
          value: value,
          source: source,
          stack: getStackByFiberInDevAndProd(source)
        };
        CapturedStacks.set(value, source);
        return source;
      }
      return {
        value: value,
        source: source,
        stack: getStackByFiberInDevAndProd(source)
      };
    }
    function pushTreeFork(workInProgress, totalChildren) {
      warnIfNotHydrating();
      forkStack[forkStackIndex++] = treeForkCount;
      forkStack[forkStackIndex++] = treeForkProvider;
      treeForkProvider = workInProgress;
      treeForkCount = totalChildren;
    }
    function pushTreeId(workInProgress, totalChildren, index) {
      warnIfNotHydrating();
      idStack[idStackIndex++] = treeContextId;
      idStack[idStackIndex++] = treeContextOverflow;
      idStack[idStackIndex++] = treeContextProvider;
      treeContextProvider = workInProgress;
      var baseIdWithLeadingBit = treeContextId;
      workInProgress = treeContextOverflow;
      var baseLength = 32 - clz32(baseIdWithLeadingBit) - 1;
      baseIdWithLeadingBit &= ~(1 << baseLength);
      index += 1;
      var length = 32 - clz32(totalChildren) + baseLength;
      if (30 < length) {
        var numberOfOverflowBits = baseLength - (baseLength % 5);
        length = (
          baseIdWithLeadingBit &
          ((1 << numberOfOverflowBits) - 1)
        ).toString(32);
        baseIdWithLeadingBit >>= numberOfOverflowBits;
        baseLength -= numberOfOverflowBits;
        treeContextId =
          (1 << (32 - clz32(totalChildren) + baseLength)) |
          (index << baseLength) |
          baseIdWithLeadingBit;
        treeContextOverflow = length + workInProgress;
      } else
        (treeContextId =
          (1 << length) | (index << baseLength) | baseIdWithLeadingBit),
          (treeContextOverflow = workInProgress);
    }
    function pushMaterializedTreeId(workInProgress) {
      warnIfNotHydrating();
      null !== workInProgress.return &&
        (pushTreeFork(workInProgress, 1), pushTreeId(workInProgress, 1, 0));
    }
    function popTreeContext(workInProgress) {
      for (; workInProgress === treeForkProvider; )
        (treeForkProvider = forkStack[--forkStackIndex]),
          (forkStack[forkStackIndex] = null),
          (treeForkCount = forkStack[--forkStackIndex]),
          (forkStack[forkStackIndex] = null);
      for (; workInProgress === treeContextProvider; )
        (treeContextProvider = idStack[--idStackIndex]),
          (idStack[idStackIndex] = null),
          (treeContextOverflow = idStack[--idStackIndex]),
          (idStack[idStackIndex] = null),
          (treeContextId = idStack[--idStackIndex]),
          (idStack[idStackIndex] = null);
    }
    function warnIfNotHydrating() {
      isHydrating ||
        console.error(
          "Expected to be hydrating. This is a bug in React. Please file an issue."
        );
    }
    function buildHydrationDiffNode(fiber, distanceFromLeaf) {
      if (null === fiber.return) {
        if (null === hydrationDiffRootDEV)
          hydrationDiffRootDEV = {
            fiber: fiber,
            children: [],
            serverProps: void 0,
            serverTail: [],
            distanceFromLeaf: distanceFromLeaf
          };
        else {
          if (hydrationDiffRootDEV.fiber !== fiber)
            throw Error(
              "Saw multiple hydration diff roots in a pass. This is a bug in React."
            );
          hydrationDiffRootDEV.distanceFromLeaf > distanceFromLeaf &&
            (hydrationDiffRootDEV.distanceFromLeaf = distanceFromLeaf);
        }
        return hydrationDiffRootDEV;
      }
      var siblings = buildHydrationDiffNode(
        fiber.return,
        distanceFromLeaf + 1
      ).children;
      if (0 < siblings.length && siblings[siblings.length - 1].fiber === fiber)
        return (
          (siblings = siblings[siblings.length - 1]),
          siblings.distanceFromLeaf > distanceFromLeaf &&
            (siblings.distanceFromLeaf = distanceFromLeaf),
          siblings
        );
      distanceFromLeaf = {
        fiber: fiber,
        children: [],
        serverProps: void 0,
        serverTail: [],
        distanceFromLeaf: distanceFromLeaf
      };
      siblings.push(distanceFromLeaf);
      return distanceFromLeaf;
    }
    function warnNonHydratedInstance(fiber, rejectedCandidate) {
      didSuspendOrErrorDEV ||
        ((fiber = buildHydrationDiffNode(fiber, 0)),
        (fiber.serverProps = null),
        null !== rejectedCandidate &&
          ((rejectedCandidate =
            describeHydratableInstanceForDevWarnings(rejectedCandidate)),
          fiber.serverTail.push(rejectedCandidate)));
    }
    function throwOnHydrationMismatch(fiber) {
      var diff = "",
        diffRoot = hydrationDiffRootDEV;
      null !== diffRoot &&
        ((hydrationDiffRootDEV = null), (diff = describeDiff(diffRoot)));
      queueHydrationError(
        createCapturedValueAtFiber(
          Error(
            "Hydration failed because the server rendered HTML didn't match the client. As a result this tree will be regenerated on the client. This can happen if a SSR-ed Client Component used:\n\n- A server/client branch `if (typeof window !== 'undefined')`.\n- Variable input such as `Date.now()` or `Math.random()` which changes each time it's called.\n- Date formatting in a user's locale which doesn't match the server.\n- External changing data without sending a snapshot of it along with the HTML.\n- Invalid HTML tag nesting.\n\nIt can also happen if the client has a browser extension installed which messes with the HTML before React loaded.\n\nhttps://react.dev/link/hydration-mismatch" +
              diff
          ),
          fiber
        )
      );
      throw HydrationMismatchException;
    }
    function prepareToHydrateHostInstance(fiber) {
      var didHydrate = fiber.stateNode;
      var type = fiber.type,
        props = fiber.memoizedProps;
      didHydrate[internalInstanceKey] = fiber;
      didHydrate[internalPropsKey] = props;
      validatePropertiesInDevelopment(type, props);
      switch (type) {
        case "dialog":
          listenToNonDelegatedEvent("cancel", didHydrate);
          listenToNonDelegatedEvent("close", didHydrate);
          break;
        case "iframe":
        case "object":
        case "embed":
          listenToNonDelegatedEvent("load", didHydrate);
          break;
        case "video":
        case "audio":
          for (type = 0; type < mediaEventTypes.length; type++)
            listenToNonDelegatedEvent(mediaEventTypes[type], didHydrate);
          break;
        case "source":
          listenToNonDelegatedEvent("error", didHydrate);
          break;
        case "img":
        case "image":
        case "link":
          listenToNonDelegatedEvent("error", didHydrate);
          listenToNonDelegatedEvent("load", didHydrate);
          break;
        case "details":
          listenToNonDelegatedEvent("toggle", didHydrate);
          break;
        case "input":
          checkControlledValueProps("input", props);
          listenToNonDelegatedEvent("invalid", didHydrate);
          validateInputProps(didHydrate, props);
          initInput(
            didHydrate,
            props.value,
            props.defaultValue,
            props.checked,
            props.defaultChecked,
            props.type,
            props.name,
            !0
          );
          track(didHydrate);
          break;
        case "option":
          validateOptionProps(didHydrate, props);
          break;
        case "select":
          checkControlledValueProps("select", props);
          listenToNonDelegatedEvent("invalid", didHydrate);
          validateSelectProps(didHydrate, props);
          break;
        case "textarea":
          checkControlledValueProps("textarea", props),
            listenToNonDelegatedEvent("invalid", didHydrate),
            validateTextareaProps(didHydrate, props),
            initTextarea(
              didHydrate,
              props.value,
              props.defaultValue,
              props.children
            ),
            track(didHydrate);
      }
      type = props.children;
      ("string" !== typeof type &&
        "number" !== typeof type &&
        "bigint" !== typeof type) ||
      didHydrate.textContent === "" + type ||
      !0 === props.suppressHydrationWarning ||
      checkForUnmatchedText(didHydrate.textContent, type)
        ? (null != props.popover &&
            (listenToNonDelegatedEvent("beforetoggle", didHydrate),
            listenToNonDelegatedEvent("toggle", didHydrate)),
          null != props.onScroll &&
            listenToNonDelegatedEvent("scroll", didHydrate),
          null != props.onScrollEnd &&
            listenToNonDelegatedEvent("scrollend", didHydrate),
          null != props.onClick && (didHydrate.onclick = noop$1),
          (didHydrate = !0))
        : (didHydrate = !1);
      didHydrate || throwOnHydrationMismatch(fiber);
    }
    function popToNextHostParent(fiber) {
      for (hydrationParentFiber = fiber.return; hydrationParentFiber; )
        switch (hydrationParentFiber.tag) {
          case 3:
          case 27:
            rootOrSingletonContext = !0;
            return;
          case 5:
          case 13:
            rootOrSingletonContext = !1;
            return;
          default:
            hydrationParentFiber = hydrationParentFiber.return;
        }
    }
    function popHydrationState(fiber) {
      if (fiber !== hydrationParentFiber) return !1;
      if (!isHydrating)
        return popToNextHostParent(fiber), (isHydrating = !0), !1;
      var shouldClear = !1,
        JSCompiler_temp;
      if ((JSCompiler_temp = 3 !== fiber.tag && 27 !== fiber.tag)) {
        if ((JSCompiler_temp = 5 === fiber.tag))
          (JSCompiler_temp = fiber.type),
            (JSCompiler_temp =
              !("form" !== JSCompiler_temp && "button" !== JSCompiler_temp) ||
              shouldSetTextContent(fiber.type, fiber.memoizedProps));
        JSCompiler_temp = !JSCompiler_temp;
      }
      JSCompiler_temp && (shouldClear = !0);
      if (shouldClear && nextHydratableInstance) {
        for (shouldClear = nextHydratableInstance; shouldClear; ) {
          JSCompiler_temp = buildHydrationDiffNode(fiber, 0);
          var description =
            describeHydratableInstanceForDevWarnings(shouldClear);
          JSCompiler_temp.serverTail.push(description);
          shouldClear =
            "Suspense" === description.type
              ? getNextHydratableInstanceAfterSuspenseInstance(shouldClear)
              : getNextHydratable(shouldClear.nextSibling);
        }
        throwOnHydrationMismatch(fiber);
      }
      popToNextHostParent(fiber);
      if (13 === fiber.tag) {
        fiber = fiber.memoizedState;
        fiber = null !== fiber ? fiber.dehydrated : null;
        if (!fiber)
          throw Error(
            "Expected to have a hydrated suspense instance. This error is likely caused by a bug in React. Please file an issue."
          );
        nextHydratableInstance =
          getNextHydratableInstanceAfterSuspenseInstance(fiber);
      } else
        nextHydratableInstance = hydrationParentFiber
          ? getNextHydratable(fiber.stateNode.nextSibling)
          : null;
      return !0;
    }
    function resetHydrationState() {
      nextHydratableInstance = hydrationParentFiber = null;
      didSuspendOrErrorDEV = isHydrating = !1;
    }
    function queueHydrationError(error) {
      null === hydrationErrors
        ? (hydrationErrors = [error])
        : hydrationErrors.push(error);
    }
    function emitPendingHydrationWarnings() {
      var diffRoot = hydrationDiffRootDEV;
      null !== diffRoot &&
        ((hydrationDiffRootDEV = null),
        (diffRoot = describeDiff(diffRoot)),
        console.error(
          "A tree hydrated but some attributes of the server rendered HTML didn't match the client properties. This won't be patched up. This can happen if a SSR-ed Client Component used:\n\n- A server/client branch `if (typeof window !== 'undefined')`.\n- Variable input such as `Date.now()` or `Math.random()` which changes each time it's called.\n- Date formatting in a user's locale which doesn't match the server.\n- External changing data without sending a snapshot of it along with the HTML.\n- Invalid HTML tag nesting.\n\nIt can also happen if the client has a browser extension installed which messes with the HTML before React loaded.\n\n%s%s",
          "https://react.dev/link/hydration-mismatch",
          diffRoot
        ));
    }
    function createThenableState() {
      return { didWarnAboutUncachedPromise: !1, thenables: [] };
    }
    function isThenableResolved(thenable) {
      thenable = thenable.status;
      return "fulfilled" === thenable || "rejected" === thenable;
    }
    function noop$3() {}
    function trackUsedThenable(thenableState, thenable, index) {
      null !== ReactSharedInternals.actQueue &&
        (ReactSharedInternals.didUsePromise = !0);
      var trackedThenables = thenableState.thenables;
      index = trackedThenables[index];
      void 0 === index
        ? trackedThenables.push(thenable)
        : index !== thenable &&
          (thenableState.didWarnAboutUncachedPromise ||
            ((thenableState.didWarnAboutUncachedPromise = !0),
            console.error(
              "A component was suspended by an uncached promise. Creating promises inside a Client Component or hook is not yet supported, except via a Suspense-compatible library or framework."
            )),
          thenable.then(noop$3, noop$3),
          (thenable = index));
      switch (thenable.status) {
        case "fulfilled":
          return thenable.value;
        case "rejected":
          throw (
            ((thenableState = thenable.reason),
            checkIfUseWrappedInAsyncCatch(thenableState),
            thenableState)
          );
        default:
          if ("string" === typeof thenable.status)
            thenable.then(noop$3, noop$3);
          else {
            thenableState = workInProgressRoot;
            if (
              null !== thenableState &&
              100 < thenableState.shellSuspendCounter
            )
              throw Error(
                "async/await is not yet supported in Client Components, only Server Components. This error is often caused by accidentally adding `'use client'` to a module that was originally written for the server."
              );
            thenableState = thenable;
            thenableState.status = "pending";
            thenableState.then(
              function (fulfilledValue) {
                if ("pending" === thenable.status) {
                  var fulfilledThenable = thenable;
                  fulfilledThenable.status = "fulfilled";
                  fulfilledThenable.value = fulfilledValue;
                }
              },
              function (error) {
                if ("pending" === thenable.status) {
                  var rejectedThenable = thenable;
                  rejectedThenable.status = "rejected";
                  rejectedThenable.reason = error;
                }
              }
            );
          }
          switch (thenable.status) {
            case "fulfilled":
              return thenable.value;
            case "rejected":
              throw (
                ((thenableState = thenable.reason),
                checkIfUseWrappedInAsyncCatch(thenableState),
                thenableState)
              );
          }
          suspendedThenable = thenable;
          needsToResetSuspendedThenableDEV = !0;
          throw SuspenseException;
      }
    }
    function getSuspendedThenable() {
      if (null === suspendedThenable)
        throw Error(
          "Expected a suspended thenable. This is a bug in React. Please file an issue."
        );
      var thenable = suspendedThenable;
      suspendedThenable = null;
      needsToResetSuspendedThenableDEV = !1;
      return thenable;
    }
    function checkIfUseWrappedInAsyncCatch(rejectedReason) {
      if (rejectedReason === SuspenseException)
        throw Error(
          "Hooks are not supported inside an async component. This error is often caused by accidentally adding `'use client'` to a module that was originally written for the server."
        );
    }
    function pushDebugInfo(debugInfo) {
      var previousDebugInfo = currentDebugInfo;
      null != debugInfo &&
        (currentDebugInfo =
          null === previousDebugInfo
            ? debugInfo
            : previousDebugInfo.concat(debugInfo));
      return previousDebugInfo;
    }
    function validateFragmentProps(element, fiber, returnFiber) {
      for (var keys = Object.keys(element.props), i = 0; i < keys.length; i++) {
        var key = keys[i];
        if ("children" !== key && "key" !== key) {
          null === fiber &&
            ((fiber = createFiberFromElement(element, returnFiber.mode, 0)),
            (fiber._debugInfo = currentDebugInfo),
            (fiber.return = returnFiber));
          runWithFiberInDEV(
            fiber,
            function (erroredKey) {
              console.error(
                "Invalid prop `%s` supplied to `React.Fragment`. React.Fragment can only have `key` and `children` props.",
                erroredKey
              );
            },
            key
          );
          break;
        }
      }
    }
    function unwrapThenable(thenable) {
      var index = thenableIndexCounter$1;
      thenableIndexCounter$1 += 1;
      null === thenableState$1 && (thenableState$1 = createThenableState());
      return trackUsedThenable(thenableState$1, thenable, index);
    }
    function coerceRef(workInProgress, element) {
      element = element.props.ref;
      workInProgress.ref = void 0 !== element ? element : null;
    }
    function throwOnInvalidObjectType(returnFiber, newChild) {
      if (newChild.$$typeof === REACT_LEGACY_ELEMENT_TYPE)
        throw Error(
          'A React Element from an older version of React was rendered. This is not supported. It can happen if:\n- Multiple copies of the "react" package is used.\n- A library pre-bundled an old copy of "react" or "react/jsx-runtime".\n- A compiler tries to "inline" JSX instead of using the runtime.'
        );
      returnFiber = Object.prototype.toString.call(newChild);
      throw Error(
        "Objects are not valid as a React child (found: " +
          ("[object Object]" === returnFiber
            ? "object with keys {" + Object.keys(newChild).join(", ") + "}"
            : returnFiber) +
          "). If you meant to render a collection of children, use an array instead."
      );
    }
    function warnOnFunctionType(returnFiber, invalidChild) {
      var parentName = getComponentNameFromFiber(returnFiber) || "Component";
      ownerHasFunctionTypeWarning[parentName] ||
        ((ownerHasFunctionTypeWarning[parentName] = !0),
        (invalidChild =
          invalidChild.displayName || invalidChild.name || "Component"),
        3 === returnFiber.tag
          ? console.error(
              "Functions are not valid as a React child. This may happen if you return %s instead of <%s /> from render. Or maybe you meant to call this function rather than return it.\n  root.render(%s)",
              invalidChild,
              invalidChild,
              invalidChild
            )
          : console.error(
              "Functions are not valid as a React child. This may happen if you return %s instead of <%s /> from render. Or maybe you meant to call this function rather than return it.\n  <%s>{%s}</%s>",
              invalidChild,
              invalidChild,
              parentName,
              invalidChild,
              parentName
            ));
    }
    function warnOnSymbolType(returnFiber, invalidChild) {
      var parentName = getComponentNameFromFiber(returnFiber) || "Component";
      ownerHasSymbolTypeWarning[parentName] ||
        ((ownerHasSymbolTypeWarning[parentName] = !0),
        (invalidChild = String(invalidChild)),
        3 === returnFiber.tag
          ? console.error(
              "Symbols are not valid as a React child.\n  root.render(%s)",
              invalidChild
            )
          : console.error(
              "Symbols are not valid as a React child.\n  <%s>%s</%s>",
              parentName,
              invalidChild,
              parentName
            ));
    }
    function createChildReconciler(shouldTrackSideEffects) {
      function deleteChild(returnFiber, childToDelete) {
        if (shouldTrackSideEffects) {
          var deletions = returnFiber.deletions;
          null === deletions
            ? ((returnFiber.deletions = [childToDelete]),
              (returnFiber.flags |= 16))
            : deletions.push(childToDelete);
        }
      }
      function deleteRemainingChildren(returnFiber, currentFirstChild) {
        if (!shouldTrackSideEffects) return null;
        for (; null !== currentFirstChild; )
          deleteChild(returnFiber, currentFirstChild),
            (currentFirstChild = currentFirstChild.sibling);
        return null;
      }
      function mapRemainingChildren(currentFirstChild) {
        for (var existingChildren = new Map(); null !== currentFirstChild; )
          null !== currentFirstChild.key
            ? existingChildren.set(currentFirstChild.key, currentFirstChild)
            : existingChildren.set(currentFirstChild.index, currentFirstChild),
            (currentFirstChild = currentFirstChild.sibling);
        return existingChildren;
      }
      function useFiber(fiber, pendingProps) {
        fiber = createWorkInProgress(fiber, pendingProps);
        fiber.index = 0;
        fiber.sibling = null;
        return fiber;
      }
      function placeChild(newFiber, lastPlacedIndex, newIndex) {
        newFiber.index = newIndex;
        if (!shouldTrackSideEffects)
          return (newFiber.flags |= 1048576), lastPlacedIndex;
        newIndex = newFiber.alternate;
        if (null !== newIndex)
          return (
            (newIndex = newIndex.index),
            newIndex < lastPlacedIndex
              ? ((newFiber.flags |= 33554434), lastPlacedIndex)
              : newIndex
          );
        newFiber.flags |= 33554434;
        return lastPlacedIndex;
      }
      function placeSingleChild(newFiber) {
        shouldTrackSideEffects &&
          null === newFiber.alternate &&
          (newFiber.flags |= 33554434);
        return newFiber;
      }
      function updateTextNode(returnFiber, current, textContent, lanes) {
        if (null === current || 6 !== current.tag)
          return (
            (current = createFiberFromText(
              textContent,
              returnFiber.mode,
              lanes
            )),
            (current.return = returnFiber),
            (current._debugOwner = returnFiber),
            (current._debugInfo = currentDebugInfo),
            current
          );
        current = useFiber(current, textContent);
        current.return = returnFiber;
        current._debugInfo = currentDebugInfo;
        return current;
      }
      function updateElement(returnFiber, current, element, lanes) {
        var elementType = element.type;
        if (elementType === REACT_FRAGMENT_TYPE)
          return (
            (current = updateFragment(
              returnFiber,
              current,
              element.props.children,
              lanes,
              element.key
            )),
            validateFragmentProps(element, current, returnFiber),
            current
          );
        if (
          null !== current &&
          (current.elementType === elementType ||
            isCompatibleFamilyForHotReloading(current, element) ||
            ("object" === typeof elementType &&
              null !== elementType &&
              elementType.$$typeof === REACT_LAZY_TYPE &&
              callLazyInitInDEV(elementType) === current.type))
        )
          return (
            (current = useFiber(current, element.props)),
            coerceRef(current, element),
            (current.return = returnFiber),
            (current._debugOwner = element._owner),
            (current._debugInfo = currentDebugInfo),
            current
          );
        current = createFiberFromElement(element, returnFiber.mode, lanes);
        coerceRef(current, element);
        current.return = returnFiber;
        current._debugInfo = currentDebugInfo;
        return current;
      }
      function updatePortal(returnFiber, current, portal, lanes) {
        if (
          null === current ||
          4 !== current.tag ||
          current.stateNode.containerInfo !== portal.containerInfo ||
          current.stateNode.implementation !== portal.implementation
        )
          return (
            (current = createFiberFromPortal(portal, returnFiber.mode, lanes)),
            (current.return = returnFiber),
            (current._debugInfo = currentDebugInfo),
            current
          );
        current = useFiber(current, portal.children || []);
        current.return = returnFiber;
        current._debugInfo = currentDebugInfo;
        return current;
      }
      function updateFragment(returnFiber, current, fragment, lanes, key) {
        if (null === current || 7 !== current.tag)
          return (
            (current = createFiberFromFragment(
              fragment,
              returnFiber.mode,
              lanes,
              key
            )),
            (current.return = returnFiber),
            (current._debugOwner = returnFiber),
            (current._debugInfo = currentDebugInfo),
            current
          );
        current = useFiber(current, fragment);
        current.return = returnFiber;
        current._debugInfo = currentDebugInfo;
        return current;
      }
      function createChild(returnFiber, newChild, lanes) {
        if (
          ("string" === typeof newChild && "" !== newChild) ||
          "number" === typeof newChild ||
          "bigint" === typeof newChild
        )
          return (
            (newChild = createFiberFromText(
              "" + newChild,
              returnFiber.mode,
              lanes
            )),
            (newChild.return = returnFiber),
            (newChild._debugOwner = returnFiber),
            (newChild._debugInfo = currentDebugInfo),
            newChild
          );
        if ("object" === typeof newChild && null !== newChild) {
          switch (newChild.$$typeof) {
            case REACT_ELEMENT_TYPE:
              return (
                (lanes = createFiberFromElement(
                  newChild,
                  returnFiber.mode,
                  lanes
                )),
                coerceRef(lanes, newChild),
                (lanes.return = returnFiber),
                (returnFiber = pushDebugInfo(newChild._debugInfo)),
                (lanes._debugInfo = currentDebugInfo),
                (currentDebugInfo = returnFiber),
                lanes
              );
            case REACT_PORTAL_TYPE:
              return (
                (newChild = createFiberFromPortal(
                  newChild,
                  returnFiber.mode,
                  lanes
                )),
                (newChild.return = returnFiber),
                (newChild._debugInfo = currentDebugInfo),
                newChild
              );
            case REACT_LAZY_TYPE:
              var _prevDebugInfo = pushDebugInfo(newChild._debugInfo);
              newChild = callLazyInitInDEV(newChild);
              returnFiber = createChild(returnFiber, newChild, lanes);
              currentDebugInfo = _prevDebugInfo;
              return returnFiber;
          }
          if (isArrayImpl(newChild) || getIteratorFn(newChild))
            return (
              (lanes = createFiberFromFragment(
                newChild,
                returnFiber.mode,
                lanes,
                null
              )),
              (lanes.return = returnFiber),
              (lanes._debugOwner = returnFiber),
              (returnFiber = pushDebugInfo(newChild._debugInfo)),
              (lanes._debugInfo = currentDebugInfo),
              (currentDebugInfo = returnFiber),
              lanes
            );
          if ("function" === typeof newChild.then)
            return (
              (_prevDebugInfo = pushDebugInfo(newChild._debugInfo)),
              (returnFiber = createChild(
                returnFiber,
                unwrapThenable(newChild),
                lanes
              )),
              (currentDebugInfo = _prevDebugInfo),
              returnFiber
            );
          if (newChild.$$typeof === REACT_CONTEXT_TYPE)
            return createChild(
              returnFiber,
              readContextDuringReconciliation(returnFiber, newChild),
              lanes
            );
          throwOnInvalidObjectType(returnFiber, newChild);
        }
        "function" === typeof newChild &&
          warnOnFunctionType(returnFiber, newChild);
        "symbol" === typeof newChild && warnOnSymbolType(returnFiber, newChild);
        return null;
      }
      function updateSlot(returnFiber, oldFiber, newChild, lanes) {
        var key = null !== oldFiber ? oldFiber.key : null;
        if (
          ("string" === typeof newChild && "" !== newChild) ||
          "number" === typeof newChild ||
          "bigint" === typeof newChild
        )
          return null !== key
            ? null
            : updateTextNode(returnFiber, oldFiber, "" + newChild, lanes);
        if ("object" === typeof newChild && null !== newChild) {
          switch (newChild.$$typeof) {
            case REACT_ELEMENT_TYPE:
              return newChild.key === key
                ? ((key = pushDebugInfo(newChild._debugInfo)),
                  (returnFiber = updateElement(
                    returnFiber,
                    oldFiber,
                    newChild,
                    lanes
                  )),
                  (currentDebugInfo = key),
                  returnFiber)
                : null;
            case REACT_PORTAL_TYPE:
              return newChild.key === key
                ? updatePortal(returnFiber, oldFiber, newChild, lanes)
                : null;
            case REACT_LAZY_TYPE:
              return (
                (key = pushDebugInfo(newChild._debugInfo)),
                (newChild = callLazyInitInDEV(newChild)),
                (returnFiber = updateSlot(
                  returnFiber,
                  oldFiber,
                  newChild,
                  lanes
                )),
                (currentDebugInfo = key),
                returnFiber
              );
          }
          if (isArrayImpl(newChild) || getIteratorFn(newChild)) {
            if (null !== key) return null;
            key = pushDebugInfo(newChild._debugInfo);
            returnFiber = updateFragment(
              returnFiber,
              oldFiber,
              newChild,
              lanes,
              null
            );
            currentDebugInfo = key;
            return returnFiber;
          }
          if ("function" === typeof newChild.then)
            return (
              (key = pushDebugInfo(newChild._debugInfo)),
              (returnFiber = updateSlot(
                returnFiber,
                oldFiber,
                unwrapThenable(newChild),
                lanes
              )),
              (currentDebugInfo = key),
              returnFiber
            );
          if (newChild.$$typeof === REACT_CONTEXT_TYPE)
            return updateSlot(
              returnFiber,
              oldFiber,
              readContextDuringReconciliation(returnFiber, newChild),
              lanes
            );
          throwOnInvalidObjectType(returnFiber, newChild);
        }
        "function" === typeof newChild &&
          warnOnFunctionType(returnFiber, newChild);
        "symbol" === typeof newChild && warnOnSymbolType(returnFiber, newChild);
        return null;
      }
      function updateFromMap(
        existingChildren,
        returnFiber,
        newIdx,
        newChild,
        lanes
      ) {
        if (
          ("string" === typeof newChild && "" !== newChild) ||
          "number" === typeof newChild ||
          "bigint" === typeof newChild
        )
          return (
            (existingChildren = existingChildren.get(newIdx) || null),
            updateTextNode(returnFiber, existingChildren, "" + newChild, lanes)
          );
        if ("object" === typeof newChild && null !== newChild) {
          switch (newChild.$$typeof) {
            case REACT_ELEMENT_TYPE:
              return (
                (newIdx =
                  existingChildren.get(
                    null === newChild.key ? newIdx : newChild.key
                  ) || null),
                (existingChildren = pushDebugInfo(newChild._debugInfo)),
                (returnFiber = updateElement(
                  returnFiber,
                  newIdx,
                  newChild,
                  lanes
                )),
                (currentDebugInfo = existingChildren),
                returnFiber
              );
            case REACT_PORTAL_TYPE:
              return (
                (existingChildren =
                  existingChildren.get(
                    null === newChild.key ? newIdx : newChild.key
                  ) || null),
                updatePortal(returnFiber, existingChildren, newChild, lanes)
              );
            case REACT_LAZY_TYPE:
              var _prevDebugInfo7 = pushDebugInfo(newChild._debugInfo);
              newChild = callLazyInitInDEV(newChild);
              returnFiber = updateFromMap(
                existingChildren,
                returnFiber,
                newIdx,
                newChild,
                lanes
              );
              currentDebugInfo = _prevDebugInfo7;
              return returnFiber;
          }
          if (isArrayImpl(newChild) || getIteratorFn(newChild))
            return (
              (newIdx = existingChildren.get(newIdx) || null),
              (existingChildren = pushDebugInfo(newChild._debugInfo)),
              (returnFiber = updateFragment(
                returnFiber,
                newIdx,
                newChild,
                lanes,
                null
              )),
              (currentDebugInfo = existingChildren),
              returnFiber
            );
          if ("function" === typeof newChild.then)
            return (
              (_prevDebugInfo7 = pushDebugInfo(newChild._debugInfo)),
              (returnFiber = updateFromMap(
                existingChildren,
                returnFiber,
                newIdx,
                unwrapThenable(newChild),
                lanes
              )),
              (currentDebugInfo = _prevDebugInfo7),
              returnFiber
            );
          if (newChild.$$typeof === REACT_CONTEXT_TYPE)
            return updateFromMap(
              existingChildren,
              returnFiber,
              newIdx,
              readContextDuringReconciliation(returnFiber, newChild),
              lanes
            );
          throwOnInvalidObjectType(returnFiber, newChild);
        }
        "function" === typeof newChild &&
          warnOnFunctionType(returnFiber, newChild);
        "symbol" === typeof newChild && warnOnSymbolType(returnFiber, newChild);
        return null;
      }
      function warnOnInvalidKey(returnFiber, workInProgress, child, knownKeys) {
        if ("object" !== typeof child || null === child) return knownKeys;
        switch (child.$$typeof) {
          case REACT_ELEMENT_TYPE:
          case REACT_PORTAL_TYPE:
            warnForMissingKey(returnFiber, workInProgress, child);
            var key = child.key;
            if ("string" !== typeof key) break;
            if (null === knownKeys) {
              knownKeys = new Set();
              knownKeys.add(key);
              break;
            }
            if (!knownKeys.has(key)) {
              knownKeys.add(key);
              break;
            }
            runWithFiberInDEV(workInProgress, function () {
              console.error(
                "Encountered two children with the same key, `%s`. Keys should be unique so that components maintain their identity across updates. Non-unique keys may cause children to be duplicated and/or omitted \u2014 the behavior is unsupported and could change in a future version.",
                key
              );
            });
            break;
          case REACT_LAZY_TYPE:
            (child = callLazyInitInDEV(child)),
              warnOnInvalidKey(returnFiber, workInProgress, child, knownKeys);
        }
        return knownKeys;
      }
      function reconcileChildrenArray(
        returnFiber,
        currentFirstChild,
        newChildren,
        lanes
      ) {
        for (
          var knownKeys = null,
            resultingFirstChild = null,
            previousNewFiber = null,
            oldFiber = currentFirstChild,
            newIdx = (currentFirstChild = 0),
            nextOldFiber = null;
          null !== oldFiber && newIdx < newChildren.length;
          newIdx++
        ) {
          oldFiber.index > newIdx
            ? ((nextOldFiber = oldFiber), (oldFiber = null))
            : (nextOldFiber = oldFiber.sibling);
          var newFiber = updateSlot(
            returnFiber,
            oldFiber,
            newChildren[newIdx],
            lanes
          );
          if (null === newFiber) {
            null === oldFiber && (oldFiber = nextOldFiber);
            break;
          }
          knownKeys = warnOnInvalidKey(
            returnFiber,
            newFiber,
            newChildren[newIdx],
            knownKeys
          );
          shouldTrackSideEffects &&
            oldFiber &&
            null === newFiber.alternate &&
            deleteChild(returnFiber, oldFiber);
          currentFirstChild = placeChild(newFiber, currentFirstChild, newIdx);
          null === previousNewFiber
            ? (resultingFirstChild = newFiber)
            : (previousNewFiber.sibling = newFiber);
          previousNewFiber = newFiber;
          oldFiber = nextOldFiber;
        }
        if (newIdx === newChildren.length)
          return (
            deleteRemainingChildren(returnFiber, oldFiber),
            isHydrating && pushTreeFork(returnFiber, newIdx),
            resultingFirstChild
          );
        if (null === oldFiber) {
          for (; newIdx < newChildren.length; newIdx++)
            (oldFiber = createChild(returnFiber, newChildren[newIdx], lanes)),
              null !== oldFiber &&
                ((knownKeys = warnOnInvalidKey(
                  returnFiber,
                  oldFiber,
                  newChildren[newIdx],
                  knownKeys
                )),
                (currentFirstChild = placeChild(
                  oldFiber,
                  currentFirstChild,
                  newIdx
                )),
                null === previousNewFiber
                  ? (resultingFirstChild = oldFiber)
                  : (previousNewFiber.sibling = oldFiber),
                (previousNewFiber = oldFiber));
          isHydrating && pushTreeFork(returnFiber, newIdx);
          return resultingFirstChild;
        }
        for (
          oldFiber = mapRemainingChildren(oldFiber);
          newIdx < newChildren.length;
          newIdx++
        )
          (nextOldFiber = updateFromMap(
            oldFiber,
            returnFiber,
            newIdx,
            newChildren[newIdx],
            lanes
          )),
            null !== nextOldFiber &&
              ((knownKeys = warnOnInvalidKey(
                returnFiber,
                nextOldFiber,
                newChildren[newIdx],
                knownKeys
              )),
              shouldTrackSideEffects &&
                null !== nextOldFiber.alternate &&
                oldFiber.delete(
                  null === nextOldFiber.key ? newIdx : nextOldFiber.key
                ),
              (currentFirstChild = placeChild(
                nextOldFiber,
                currentFirstChild,
                newIdx
              )),
              null === previousNewFiber
                ? (resultingFirstChild = nextOldFiber)
                : (previousNewFiber.sibling = nextOldFiber),
              (previousNewFiber = nextOldFiber));
        shouldTrackSideEffects &&
          oldFiber.forEach(function (child) {
            return deleteChild(returnFiber, child);
          });
        isHydrating && pushTreeFork(returnFiber, newIdx);
        return resultingFirstChild;
      }
      function reconcileChildrenIterator(
        returnFiber,
        currentFirstChild,
        newChildren,
        lanes
      ) {
        if (null == newChildren)
          throw Error("An iterable object provided no iterator.");
        for (
          var resultingFirstChild = null,
            previousNewFiber = null,
            oldFiber = currentFirstChild,
            newIdx = (currentFirstChild = 0),
            nextOldFiber = null,
            knownKeys = null,
            step = newChildren.next();
          null !== oldFiber && !step.done;
          newIdx++, step = newChildren.next()
        ) {
          oldFiber.index > newIdx
            ? ((nextOldFiber = oldFiber), (oldFiber = null))
            : (nextOldFiber = oldFiber.sibling);
          var newFiber = updateSlot(returnFiber, oldFiber, step.value, lanes);
          if (null === newFiber) {
            null === oldFiber && (oldFiber = nextOldFiber);
            break;
          }
          knownKeys = warnOnInvalidKey(
            returnFiber,
            newFiber,
            step.value,
            knownKeys
          );
          shouldTrackSideEffects &&
            oldFiber &&
            null === newFiber.alternate &&
            deleteChild(returnFiber, oldFiber);
          currentFirstChild = placeChild(newFiber, currentFirstChild, newIdx);
          null === previousNewFiber
            ? (resultingFirstChild = newFiber)
            : (previousNewFiber.sibling = newFiber);
          previousNewFiber = newFiber;
          oldFiber = nextOldFiber;
        }
        if (step.done)
          return (
            deleteRemainingChildren(returnFiber, oldFiber),
            isHydrating && pushTreeFork(returnFiber, newIdx),
            resultingFirstChild
          );
        if (null === oldFiber) {
          for (; !step.done; newIdx++, step = newChildren.next())
            (oldFiber = createChild(returnFiber, step.value, lanes)),
              null !== oldFiber &&
                ((knownKeys = warnOnInvalidKey(
                  returnFiber,
                  oldFiber,
                  step.value,
                  knownKeys
                )),
                (currentFirstChild = placeChild(
                  oldFiber,
                  currentFirstChild,
                  newIdx
                )),
                null === previousNewFiber
                  ? (resultingFirstChild = oldFiber)
                  : (previousNewFiber.sibling = oldFiber),
                (previousNewFiber = oldFiber));
          isHydrating && pushTreeFork(returnFiber, newIdx);
          return resultingFirstChild;
        }
        for (
          oldFiber = mapRemainingChildren(oldFiber);
          !step.done;
          newIdx++, step = newChildren.next()
        )
          (nextOldFiber = updateFromMap(
            oldFiber,
            returnFiber,
            newIdx,
            step.value,
            lanes
          )),
            null !== nextOldFiber &&
              ((knownKeys = warnOnInvalidKey(
                returnFiber,
                nextOldFiber,
                step.value,
                knownKeys
              )),
              shouldTrackSideEffects &&
                null !== nextOldFiber.alternate &&
                oldFiber.delete(
                  null === nextOldFiber.key ? newIdx : nextOldFiber.key
                ),
              (currentFirstChild = placeChild(
                nextOldFiber,
                currentFirstChild,
                newIdx
              )),
              null === previousNewFiber
                ? (resultingFirstChild = nextOldFiber)
                : (previousNewFiber.sibling = nextOldFiber),
              (previousNewFiber = nextOldFiber));
        shouldTrackSideEffects &&
          oldFiber.forEach(function (child) {
            return deleteChild(returnFiber, child);
          });
        isHydrating && pushTreeFork(returnFiber, newIdx);
        return resultingFirstChild;
      }
      function reconcileChildFibersImpl(
        returnFiber,
        currentFirstChild,
        newChild,
        lanes
      ) {
        "object" === typeof newChild &&
          null !== newChild &&
          newChild.type === REACT_FRAGMENT_TYPE &&
          null === newChild.key &&
          (validateFragmentProps(newChild, null, returnFiber),
          (newChild = newChild.props.children));
        if ("object" === typeof newChild && null !== newChild) {
          switch (newChild.$$typeof) {
            case REACT_ELEMENT_TYPE:
              var prevDebugInfo = pushDebugInfo(newChild._debugInfo);
              a: {
                for (var key = newChild.key; null !== currentFirstChild; ) {
                  if (currentFirstChild.key === key) {
                    key = newChild.type;
                    if (key === REACT_FRAGMENT_TYPE) {
                      if (7 === currentFirstChild.tag) {
                        deleteRemainingChildren(
                          returnFiber,
                          currentFirstChild.sibling
                        );
                        lanes = useFiber(
                          currentFirstChild,
                          newChild.props.children
                        );
                        lanes.return = returnFiber;
                        lanes._debugOwner = newChild._owner;
                        lanes._debugInfo = currentDebugInfo;
                        validateFragmentProps(newChild, lanes, returnFiber);
                        returnFiber = lanes;
                        break a;
                      }
                    } else if (
                      currentFirstChild.elementType === key ||
                      isCompatibleFamilyForHotReloading(
                        currentFirstChild,
                        newChild
                      ) ||
                      ("object" === typeof key &&
                        null !== key &&
                        key.$$typeof === REACT_LAZY_TYPE &&
                        callLazyInitInDEV(key) === currentFirstChild.type)
                    ) {
                      deleteRemainingChildren(
                        returnFiber,
                        currentFirstChild.sibling
                      );
                      lanes = useFiber(currentFirstChild, newChild.props);
                      coerceRef(lanes, newChild);
                      lanes.return = returnFiber;
                      lanes._debugOwner = newChild._owner;
                      lanes._debugInfo = currentDebugInfo;
                      returnFiber = lanes;
                      break a;
                    }
                    deleteRemainingChildren(returnFiber, currentFirstChild);
                    break;
                  } else deleteChild(returnFiber, currentFirstChild);
                  currentFirstChild = currentFirstChild.sibling;
                }
                newChild.type === REACT_FRAGMENT_TYPE
                  ? ((lanes = createFiberFromFragment(
                      newChild.props.children,
                      returnFiber.mode,
                      lanes,
                      newChild.key
                    )),
                    (lanes.return = returnFiber),
                    (lanes._debugOwner = returnFiber),
                    (lanes._debugInfo = currentDebugInfo),
                    validateFragmentProps(newChild, lanes, returnFiber),
                    (returnFiber = lanes))
                  : ((lanes = createFiberFromElement(
                      newChild,
                      returnFiber.mode,
                      lanes
                    )),
                    coerceRef(lanes, newChild),
                    (lanes.return = returnFiber),
                    (lanes._debugInfo = currentDebugInfo),
                    (returnFiber = lanes));
              }
              returnFiber = placeSingleChild(returnFiber);
              currentDebugInfo = prevDebugInfo;
              return returnFiber;
            case REACT_PORTAL_TYPE:
              a: {
                prevDebugInfo = newChild;
                for (
                  newChild = prevDebugInfo.key;
                  null !== currentFirstChild;

                ) {
                  if (currentFirstChild.key === newChild)
                    if (
                      4 === currentFirstChild.tag &&
                      currentFirstChild.stateNode.containerInfo ===
                        prevDebugInfo.containerInfo &&
                      currentFirstChild.stateNode.implementation ===
                        prevDebugInfo.implementation
                    ) {
                      deleteRemainingChildren(
                        returnFiber,
                        currentFirstChild.sibling
                      );
                      lanes = useFiber(
                        currentFirstChild,
                        prevDebugInfo.children || []
                      );
                      lanes.return = returnFiber;
                      returnFiber = lanes;
                      break a;
                    } else {
                      deleteRemainingChildren(returnFiber, currentFirstChild);
                      break;
                    }
                  else deleteChild(returnFiber, currentFirstChild);
                  currentFirstChild = currentFirstChild.sibling;
                }
                lanes = createFiberFromPortal(
                  prevDebugInfo,
                  returnFiber.mode,
                  lanes
                );
                lanes.return = returnFiber;
                returnFiber = lanes;
              }
              return placeSingleChild(returnFiber);
            case REACT_LAZY_TYPE:
              return (
                (prevDebugInfo = pushDebugInfo(newChild._debugInfo)),
                (newChild = callLazyInitInDEV(newChild)),
                (returnFiber = reconcileChildFibersImpl(
                  returnFiber,
                  currentFirstChild,
                  newChild,
                  lanes
                )),
                (currentDebugInfo = prevDebugInfo),
                returnFiber
              );
          }
          if (isArrayImpl(newChild))
            return (
              (prevDebugInfo = pushDebugInfo(newChild._debugInfo)),
              (returnFiber = reconcileChildrenArray(
                returnFiber,
                currentFirstChild,
                newChild,
                lanes
              )),
              (currentDebugInfo = prevDebugInfo),
              returnFiber
            );
          if (getIteratorFn(newChild)) {
            prevDebugInfo = pushDebugInfo(newChild._debugInfo);
            key = getIteratorFn(newChild);
            if ("function" !== typeof key)
              throw Error(
                "An object is not an iterable. This error is likely caused by a bug in React. Please file an issue."
              );
            var newChildren = key.call(newChild);
            if (newChildren === newChild) {
              if (
                0 !== returnFiber.tag ||
                "[object GeneratorFunction]" !==
                  Object.prototype.toString.call(returnFiber.type) ||
                "[object Generator]" !==
                  Object.prototype.toString.call(newChildren)
              )
                didWarnAboutGenerators ||
                  console.error(
                    "Using Iterators as children is unsupported and will likely yield unexpected results because enumerating a generator mutates it. You may convert it to an array with `Array.from()` or the `[...spread]` operator before rendering. You can also use an Iterable that can iterate multiple times over the same items."
                  ),
                  (didWarnAboutGenerators = !0);
            } else
              newChild.entries !== key ||
                didWarnAboutMaps ||
                (console.error(
                  "Using Maps as children is not supported. Use an array of keyed ReactElements instead."
                ),
                (didWarnAboutMaps = !0));
            returnFiber = reconcileChildrenIterator(
              returnFiber,
              currentFirstChild,
              newChildren,
              lanes
            );
            currentDebugInfo = prevDebugInfo;
            return returnFiber;
          }
          if ("function" === typeof newChild.then)
            return (
              (prevDebugInfo = pushDebugInfo(newChild._debugInfo)),
              (returnFiber = reconcileChildFibersImpl(
                returnFiber,
                currentFirstChild,
                unwrapThenable(newChild),
                lanes
              )),
              (currentDebugInfo = prevDebugInfo),
              returnFiber
            );
          if (newChild.$$typeof === REACT_CONTEXT_TYPE)
            return reconcileChildFibersImpl(
              returnFiber,
              currentFirstChild,
              readContextDuringReconciliation(returnFiber, newChild),
              lanes
            );
          throwOnInvalidObjectType(returnFiber, newChild);
        }
        if (
          ("string" === typeof newChild && "" !== newChild) ||
          "number" === typeof newChild ||
          "bigint" === typeof newChild
        )
          return (
     