'use client';

import React from 'react';

import { withRef } from '@udecode/cn';
import {indent} from '@udecode/plate-indent';
import { useIndentButton } from '@udecode/plate-indent/react';
import {moveListItems} from '@udecode/plate-list';
import {TablePlugin} from '@udecode/plate-table/react';
import {useEditorRef, usePluginOption} from '@udecode/plate/react';
import { Indent } from 'lucide-react';

import { ToolbarButton } from './toolbar';

export const IndentToolbarButton = withRef<typeof ToolbarButton>(
    (rest, ref) => {
        const { props } = useIndentButton(),
            editor = useEditorRef(),
            selectedCells = usePluginOption(TablePlugin, 'selectedCells');

        return (
            <ToolbarButton ref={ref} tooltip="Indent" {...props} {...rest}
                /* Potix: add list-indent-toolbar-button functionality */
                onClick={() => {
                    /* Potix: Fix toolbar action after grid cell selection */
                    if (selectedCells && selectedCells.length > 0) {
                        selectedCells.forEach((cell) => {
                            const cellPath = editor.api.findPath(cell);
                            if (cellPath) {
                                // equivalent to indentListItems(editor) with return value
                                moveListItems(editor, {at: cellPath, increase: true})
                                || indent(editor, {getNodesOptions: {at: cellPath}});
                            }
                        });
                    } else moveListItems(editor, {increase: true}) || indent(editor);
                }}
            >
                <Indent />
            </ToolbarButton>
        );
    }
);
