'use client';

import React, { type ReactNode } from 'react';

import * as Popover from '@radix-ui/react-popover';
import {useEditorRef} from '@udecode/plate/react';

type EmojiToolbarDropdownProps = {
    children: ReactNode;
    control: ReactNode;
    isOpen: boolean;
    setIsOpen: (open: boolean) => void;
};

export function EmojiToolbarDropdown({
                                         children,
                                         control,
                                         isOpen,
                                         setIsOpen,
                                     }: EmojiToolbarDropdownProps) {
    const editor = useEditorRef(),
        zclass = editor.zclass as string;
    return (
        <Popover.Root open={isOpen} onOpenChange={setIsOpen}>
            <Popover.Trigger asChild>{control}</Popover.Trigger>

            <Popover.Portal>
                <Popover.Content
                    className={`${zclass}-toolbar-pp`}
                    onCloseAutoFocus={e => {
                        e.preventDefault();
                        editor.tf.focus();
                    }}
                >{children}</Popover.Content>
            </Popover.Portal>
        </Popover.Root>
    );
}
