import {withProps} from '@udecode/cn';
import {NodeComponent, SlateElement, SlateLeaf} from '@udecode/plate';
import {
    BoldPlugin,
    CodePlugin,
    ItalicPlugin,
    StrikethroughPlugin,
    SubscriptPlugin,
    SuperscriptPlugin,
    UnderlinePlugin
} from '@udecode/plate-basic-marks/react';
import {HEADING_KEYS} from '@udecode/plate-heading';
import {HighlightPlugin} from '@udecode/plate-highlight/react';
import {TableCellHeaderPlugin, TableCellPlugin, TablePlugin, TableRowPlugin} from '@udecode/plate-table/react';
import {ParagraphPlugin} from '@udecode/plate/react';
import {HeadingElementStatic} from './components/heading-element-static';
import {HighlightLeafStatic} from './components/highlight-leaf-static';
import {ParagraphElementStatic} from './components/paragraph-element-static';
import {TableCellElementStatic, TableCellHeaderStaticElement} from './components/table-cell-element-static';
import {TableElementStatic} from './components/table-element-static';
import {TableRowElementStatic} from './components/table-row-element-static';
import {ImagePlugin} from '@udecode/plate-media/react';
import {BulletedListPlugin, ListItemPlugin, NumberedListPlugin} from '@udecode/plate-list/react';
import {ListElement} from './components/list-element';
import {LinkPlugin} from '@udecode/plate-link/react';
import {BlockquotePlugin} from '@udecode/plate-block-quote/react';
import {ImageElementStatic} from './components/image-element-static';
import {CodeLeafStatic} from './components/code-leaf-static';
import {LinkElementStatic} from './components/link-element-static';
import {BlockquoteElementStatic} from './components/blockquote-element-static';

export const createStaticComponents = (zclass: string): Record<string, NodeComponent> => {
    return {
        /* Potix: Add {as: 'p'} to preserve paragraph styles in Document#setValue(getValue()) */
        [ParagraphPlugin.key]: withProps(ParagraphElementStatic, {as: 'p', className: `${zclass}-${ParagraphPlugin.key}`}),
        [HEADING_KEYS.h1]: withProps(HeadingElementStatic, {variant: 'h1', className: `${zclass}-${HEADING_KEYS.h1}`}),
        [HEADING_KEYS.h2]: withProps(HeadingElementStatic, {variant: 'h2', className: `${zclass}-${HEADING_KEYS.h2}`}),
        [HEADING_KEYS.h3]: withProps(HeadingElementStatic, {variant: 'h3', className: `${zclass}-${HEADING_KEYS.h3}`}),
        [HEADING_KEYS.h4]: withProps(HeadingElementStatic, {variant: 'h4', className: `${zclass}-${HEADING_KEYS.h4}`}),
        [HEADING_KEYS.h5]: withProps(HeadingElementStatic, {variant: 'h5', className: `${zclass}-${HEADING_KEYS.h5}`}),
        [HEADING_KEYS.h6]: withProps(HeadingElementStatic, {variant: 'h6', className: `${zclass}-${HEADING_KEYS.h6}`}),
        [BlockquotePlugin.key]: withProps(BlockquoteElementStatic, {className: `${zclass}-${BlockquotePlugin.key}`}),
        [TablePlugin.key]: withProps(TableElementStatic, {className: `${zclass}-${TablePlugin.key}`}),
        [TableRowPlugin.key]: withProps(TableRowElementStatic, {className: `${zclass}-${TableRowPlugin.key}`}),
        [TableCellHeaderPlugin.key]: withProps(TableCellHeaderStaticElement, {className: `${zclass}-${TableCellHeaderPlugin.key}`}),
        [TableCellPlugin.key]: withProps(TableCellElementStatic, {className: `${zclass}-${TableCellPlugin.key}`}),

        [BoldPlugin.key]: withProps(SlateLeaf, {as: 'strong', className: `${zclass}-${BoldPlugin.key}`}),
        [ItalicPlugin.key]: withProps(SlateLeaf, {as: 'em', className: `${zclass}-${ItalicPlugin.key}`}),
        [StrikethroughPlugin.key]: withProps(SlateLeaf, {as: 's', className: `${zclass}-${StrikethroughPlugin.key}`}),
        [SubscriptPlugin.key]: withProps(SlateLeaf, {as: 'sub', className: `${zclass}-${SubscriptPlugin.key}`}),
        [SuperscriptPlugin.key]: withProps(SlateLeaf, {as: 'sup', className: `${zclass}-${SuperscriptPlugin.key}`}),
        [UnderlinePlugin.key]: withProps(SlateLeaf, {as: 'u', className: `${zclass}-${UnderlinePlugin.key}`}),
        [CodePlugin.key]: withProps(CodeLeafStatic, {className: `${zclass}-${CodePlugin.key}`}),
        [HighlightPlugin.key]: withProps(HighlightLeafStatic, {className: `${zclass}-${HighlightPlugin.key}`}),

        // media
        [ImagePlugin.key]: withProps(ImageElementStatic, {className: `${zclass}-${ImagePlugin.key}`}),

        // list
        [BulletedListPlugin.key]: withProps(ListElement, { variant: 'ul', className: `${zclass}-${BulletedListPlugin.key}`}),
        [NumberedListPlugin.key]: withProps(ListElement, { variant: 'ol', className: `${zclass}-${NumberedListPlugin.key}`}),
        [ListItemPlugin.key]: withProps(SlateElement, {as: 'li', className: `${zclass}-${ListItemPlugin.key}`}),

        // link
        [LinkPlugin.key]: withProps(LinkElementStatic, {className: `${zclass}-${LinkPlugin.key}`}),
    };
};
