import {cn, useComposedRef, withRef} from '@udecode/cn';
import {At, PathApi} from '@udecode/plate';
import {useDraggable} from '@udecode/plate-dnd';
import {PlateElement, useEditorRef, useSelected,} from '@udecode/plate/react';
import * as React from 'react';

export const TableRowElement = withRef<typeof PlateElement>(
    ({children, className, ...props}, ref) => {
        // usePluginOption(
        //     BlockSelectionPlugin,
        //     'isSelectionAreaVisible'
        // );
        const {element} = props,
            selected = useSelected(),
            editor = useEditorRef(),
            {previewRef} = useDraggable({
                element,
                type: element.type,
                canDropNode: ({dragEntry, dropEntry}) =>
                    PathApi.equals(
                        PathApi.parent(dragEntry[1]),
                        PathApi.parent(dropEntry[1])
                    ),
                onDropHandler: (_, {dragItem}) => {
                    const dragElement = dragItem['element'] as At;

                    if (dragElement) {
                        editor.tf.select(dragElement);
                    }
                },
            }),
            ghost = React.useMemo(() => <th className='ghost' contentEditable={false}/>, []);

        return (
            <PlateElement
                ref={useComposedRef(ref, previewRef)}
                as="tr"
                className={cn(className, 'group/row')}
                data-selected={selected ? 'true' : undefined}
                {...props}
            >
                {/* Potix: remove RowDragHandle due to bug in Plate's row reordering with merged cells */}
                {ghost}
                {children}
            </PlateElement>
        );
    }
);
