import React from 'react';

import { withRef, withVariants } from '@udecode/cn';
import { PlateElement } from '@udecode/plate/react';
import { cva } from 'class-variance-authority';

const headingVariants = cva('relative mb-1', {
    variants: {
        variant: {
            h1: 'mt-[1.6em] pb-1 font-heading text-4xl font-bold',
            h2: 'mt-[1.4em] pb-px font-heading text-2xl font-semibold tracking-tight',
            h3: 'mt-[1em] pb-px font-heading text-xl font-semibold tracking-tight',
            h4: 'mt-[0.75em] font-heading text-lg font-semibold tracking-tight',
            h5: 'mt-[0.75em] text-lg font-semibold tracking-tight',
            h6: 'mt-[0.75em] text-base font-semibold tracking-tight',
        },
    },
}),
    HeadingElementVariants = withVariants(PlateElement, headingVariants, [
    'variant',
]);

export const HeadingElement = withRef<typeof HeadingElementVariants>(
    ({ children, variant = 'h1', ...props }, ref) => {
        const ghost = React.useMemo(() => <span className='ghost' contentEditable={false}/>, []);
        return (
            <HeadingElementVariants
                ref={ref}
                as={variant!}
                variant={variant}
                {...props}
            >
                {ghost}
                {children}
            </HeadingElementVariants>
        );
    }
);
