import {ListToolbarButton} from '@plate/toolbar/list-toolbar-button';
import {BulletedListPlugin, NumberedListPlugin} from '@udecode/plate-list/react';
import React, {ReactElement} from 'react';
import {RedoToolbarButton, UndoToolbarButton} from '@plate/toolbar/history-toolbar-button';
import {TurnIntoDropdownMenu} from '@plate/toolbar/turn-into-dropdown-menu';
import {MarkToolbarButton} from '@plate/toolbar/mark-toolbar-button';
import {
	BoldPlugin,
	CodePlugin,
	ItalicPlugin,
	StrikethroughPlugin,
	SubscriptPlugin,
	SuperscriptPlugin,
	UnderlinePlugin
} from '@udecode/plate-basic-marks/react';
import {
	BaselineIcon,
	BoldIcon,
	Code2Icon,
	ItalicIcon, PaintBucketIcon,
	StrikethroughIcon,
	SubscriptIcon,
	SuperscriptIcon,
	UnderlineIcon
} from 'lucide-react';
import {FontSizeToolbarButton} from '@plate/toolbar/font-size-toolbar-button';
import {ColorDropdownMenu} from '@plate/toolbar/color-dropdown-menu';
import {FontBackgroundColorPlugin, FontColorPlugin} from '@udecode/plate-font/react';
import {AlignDropdownMenu} from '@plate/toolbar/align-dropdown-menu';
import {LineHeightDropdownMenu} from '@plate/toolbar/line-height-dropdown-menu';
import {OutdentToolbarButton} from '@plate/toolbar/outdent-toolbar-button';
import {IndentToolbarButton} from '@plate/toolbar/indent-toolbar-button';
import {LinkToolbarButton} from '@plate/toolbar/link-toolbar-button';
import {EmojiDropdownMenu} from '@plate/toolbar/emoji-dropdown-menu';
import {TableDropdownMenu} from '@plate/toolbar/table-dropdown-menu';
import {MediaToolbarButton} from '@plate/toolbar/media-toolbar-button';
import {ImagePlugin} from '@udecode/plate-media/react';
import {useEditorReadOnly} from '@udecode/plate/react';
import {FixedToolbar} from '@plate/toolbar/fixed-toolbar';
import {Separator} from '@plate/toolbar/separator';

const toolsMap: {
		[toolName: string]: (key: string) => ReactElement;
	} = {
		'-': (key) => (
			<div className="mx-1.5 py-0.5 group-last/toolbar-group:hidden!" key={key}>
				<Separator orientation="vertical" />
			</div>
		),
		'Undo': (key) => <UndoToolbarButton key={key}/>,
		'Redo': (key) => <RedoToolbarButton key={key}/>,
		'TurnInto': (key) => <TurnIntoDropdownMenu key={key}/>,
		'Bold': (key) => (
			<MarkToolbarButton nodeType={BoldPlugin.key} tooltip="Bold (⌘+B)" key={key}>
				<BoldIcon/>
			</MarkToolbarButton>
		),
		'Italic': (key) => (
			<MarkToolbarButton nodeType={ItalicPlugin.key} tooltip="Italic (⌘+I)" key={key}>
				<ItalicIcon/>
			</MarkToolbarButton>
		),
		'Underline': (key) => (
			<MarkToolbarButton nodeType={UnderlinePlugin.key} tooltip="Underline (⌘+U)" key={key}>
				<UnderlineIcon/>
			</MarkToolbarButton>
		),
		'Strike': (key) => (
			<MarkToolbarButton nodeType={StrikethroughPlugin.key} tooltip="Strikethrough (⌘+⇧+M)" key={key}>
				<StrikethroughIcon/>
			</MarkToolbarButton>
		),
		'Superscript': (key) => (
			<MarkToolbarButton nodeType={SuperscriptPlugin.key} tooltip="Superscript" key={key}>
				<SuperscriptIcon/>
			</MarkToolbarButton>
		),
		'Subscript': (key) => (
			<MarkToolbarButton nodeType={SubscriptPlugin.key} tooltip="Subscript" key={key}>
				<SubscriptIcon/>
			</MarkToolbarButton>
		),
		'Code': (key) => (
			<MarkToolbarButton nodeType={CodePlugin.key} tooltip="Code (⌘+E)" key={key}>
				<Code2Icon/>
			</MarkToolbarButton>
		),
		'FontSize': (key) => <FontSizeToolbarButton key={key}/>,
		'FontColor': (key) => (
			<ColorDropdownMenu nodeType={FontColorPlugin.key} tooltip="Text color" key={key}>
				<BaselineIcon/>
			</ColorDropdownMenu>
		),
		'FontBackgroundColor': (key) => (
			<ColorDropdownMenu nodeType={FontBackgroundColorPlugin.key} tooltip="Background color" key={key}>
				<PaintBucketIcon/>
			</ColorDropdownMenu>
		),
		'NumberedList': (key) => <ListToolbarButton nodeType={NumberedListPlugin.key} key={key}/>,
		'BulletedList': (key) => <ListToolbarButton nodeType={BulletedListPlugin.key} key={key}/>,
		'HorizontalRule': (key) => <AlignDropdownMenu key={key}/>,
		'LineHeight': (key) => <LineHeightDropdownMenu key={key}/>,
		'Outdent': (key) => <OutdentToolbarButton key={key}/>,
		'Indent': (key) => <IndentToolbarButton key={key}/>,
		'Link': (key) => <LinkToolbarButton key={key}/>,
		'Emoji': (key) => <EmojiDropdownMenu key={key}/>,
		'Table': (key) => <TableDropdownMenu key={key}/>,
		'Image': (key) => <MediaToolbarButton nodeType={ImagePlugin.key} key={key}/>,
	},
	defaultToolbar = [
		[
			'Undo', 'Redo', '-',
			'TurnInto', 'FontSize', '-',
			'Bold', 'Italic', 'Underline', 'Strike', 'Superscript', 'Subscript', 'Code', 'FontColor', 'FontBackgroundColor', '-',
			'HorizontalRule', 'NumberedList', 'BulletedList', '-',
			'Link', 'Table', 'Emoji', 'Image', '-',
			'LineHeight', 'Outdent', 'Indent'
		]
	];

export function KKDocToolbar({ id, documentConfig }: {
	id: string;
	documentConfig: kkdoc.DocumentConfig;
}): ReactElement {
	const readOnly = useEditorReadOnly(),
		toolbarConfig = documentConfig?.toolbar ?? defaultToolbar;

	return (
		<div id={id}>
			{!readOnly && toolbarConfig.map((row, rowIndex) => (
				<FixedToolbar
					key={rowIndex}
					onMouseDown={e => {
						if (e.target === e.currentTarget) e.preventDefault();
					}}
				>
					<div
						className="flex w-full flex-wrap"
						onMouseDown={e => {
							if (e.target === e.currentTarget) e.preventDefault();
						}}
					>
						{row.map((toolName, toolIndex) => {
							const toolCallback = toolsMap[toolName];
							if (toolCallback) {
								return toolCallback(toolIndex.toString());
							} else {
								zk.error(`Unknown tool name: ${toolName}`);
							}
						})}
					</div>
				</FixedToolbar>
			))}
		</div>
	);
}