
import React from 'react';

import type { TMentionElement } from '@udecode/plate-mention';

import { cn, withRef } from '@udecode/cn';
import { getHandler, IS_APPLE } from '@udecode/plate';
import {
    PlateElement,
    useFocused,
    useReadOnly,
    useSelected,
} from '@udecode/plate/react';

import { useMounted } from '@plate/use-mounted';

export const MentionElement = withRef<
    typeof PlateElement,
    {
        prefix?: string;
        onClick?: (mentionNode: unknown) => void;
    }
>(({ children, className, prefix, onClick, ...props }, ref) => {
    const element = props.element as TMentionElement,
     selected = useSelected(),
     focused = useFocused(),
     mounted = useMounted(),
     readOnly = useReadOnly();

    return (
        <PlateElement
            ref={ref}
            className={cn(
                className,
                'inline-block rounded-md bg-muted px-1.5 py-0.5 align-baseline text-sm font-medium',
                !readOnly && 'cursor-pointer',
                selected && focused && 'ring-2 ring-ring',
                element.children[0].bold === true && 'font-bold',
                element.children[0].italic === true && 'italic',
                element.children[0].underline === true && 'underline'
            )}
            onClick={getHandler(onClick, element)}
            data-slate-value={element.value}
            contentEditable={false}
            draggable
            {...props}
        >
            {mounted && IS_APPLE ? (
                // Mac OS IME https://github.com/ianstormtaylor/slate/issues/3490
                <React.Fragment>
                    {children}
                    {prefix}
                    {element.value}
                </React.Fragment>
            ) : (
                // Others like Android https://github.com/ianstormtaylor/slate/pull/5360
                <React.Fragment>
                    {prefix}
                    {element.value}
                    {children}
                </React.Fragment>
            )}
        </PlateElement>
    );
});