import { cn } from '@udecode/cn';
import { RangeApi } from '@udecode/plate';
import {type CursorData, type CursorOverlayState, useCursorOverlay,} from '@udecode/plate-selection/react';
import {useEditorRef} from '@udecode/plate/react';
import React from 'react';

export function Cursor({
                           id,
                           caretPosition,
                           data,
                           selection,
                           selectionRects,
                       }: CursorOverlayState<CursorData>): React.ReactElement {
    const {style, selectionStyle = style} = data ?? ({} satisfies CursorData),
        zclass = useEditorRef().zclass as string,
        isCursor = RangeApi.isCollapsed(selection);

    return (
        <>
            {selectionRects.map((position, i) => {
                return (
                    <div
                        key={i}
                        className={cn(
                            `plate-selection ${zclass}-selection`,
                            'pointer-events-none absolute z-10',
                            id === 'selection' && 'bg-brand/25',
                            id === 'selection' && isCursor && 'bg-primary'
                        )}
                        style={{
                            ...selectionStyle,
                            ...position,
                        }}
                    />
                );
            })}
            {caretPosition && (
                <div
                    className={cn(
                        `plate-caret ${zclass}-caret`,
                        'pointer-events-none absolute z-10 w-0.5',
                        id === 'drag' && 'w-px bg-brand'
                    )}
                    style={{ ...caretPosition, ...style }}
                />
            )}
        </>
    );
}

export function CursorOverlay(): React.ReactElement {
    const {cursors} = useCursorOverlay();

    return (
        <>
            {cursors.map((cursor) => (
                <Cursor key={cursor.id as string} {...cursor} />
            ))}
        </>
    );
}
