/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.pdf;

import java.awt.Color;
import org.zkoss.poi.hssf.util.HSSFColor;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.impl.pdf.BorderStyle;

class StyleConversionUtil {
    public static float DEFAULT_ROW_HEADER_COLUMN_WIDTH = 25.0f;

    StyleConversionUtil() {
    }

    public static int getCorrespondingPdfPCellAlignment(short poiAlignment) {
        switch (poiAlignment) {
            case 2: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 5: {
                return 3;
            }
        }
        return -1;
    }

    public static int getCorrespondingPdfPCellAlignment(SCellStyle.Alignment zssAlignment) {
        switch (zssAlignment) {
            case CENTER_SELECTION: 
            case CENTER: {
                return 1;
            }
            case LEFT: {
                return 0;
            }
            case RIGHT: {
                return 2;
            }
            case JUSTIFY: {
                return 3;
            }
            case FILL: {
                return 8;
            }
        }
        return -1;
    }

    public static int getCorrespondingPdfPCellVerticalAlignment(SCellStyle.VerticalAlignment zssAlignment) {
        switch (zssAlignment) {
            case CENTER: {
                return 5;
            }
            case TOP: {
                return 4;
            }
            case BOTTOM: {
                return 6;
            }
            case JUSTIFY: {
                return 7;
            }
        }
        return -1;
    }

    public static int getCorrespondingPdfPCellVerticalAlignment(short poiAlignment) {
        switch (poiAlignment) {
            case 1: {
                return 5;
            }
            case 0: {
                return 4;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 7;
            }
        }
        return -1;
    }

    public static Color getBaseColor(HSSFColor hssfColor) {
        if (hssfColor == null) {
            return null;
        }
        short[] rgb = hssfColor.getTriplet();
        if (rgb[0] == 0 && rgb[1] == 0 && rgb[2] == 0) {
            return Color.white;
        }
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public static BorderStyle getBorderStyle(short borderStyle) {
        SCellStyle.BorderType borderType = null;
        switch (borderStyle) {
            case 4: {
                borderType = SCellStyle.BorderType.DOTTED;
                break;
            }
            case 7: {
                borderType = SCellStyle.BorderType.HAIR;
                break;
            }
            case 11: {
                borderType = SCellStyle.BorderType.DASH_DOT_DOT;
                break;
            }
            case 12: {
                borderType = SCellStyle.BorderType.MEDIUM_DASH_DOT_DOT;
                break;
            }
            case 9: {
                borderType = SCellStyle.BorderType.DASH_DOT;
                break;
            }
            case 3: {
                borderType = SCellStyle.BorderType.DASHED;
                break;
            }
            case 1: {
                borderType = SCellStyle.BorderType.THIN;
                break;
            }
            case 13: {
                borderType = SCellStyle.BorderType.SLANTED_DASH_DOT;
                break;
            }
            case 10: {
                borderType = SCellStyle.BorderType.MEDIUM_DASH_DOT;
                break;
            }
            case 8: {
                borderType = SCellStyle.BorderType.MEDIUM_DASHED;
                break;
            }
            case 2: {
                borderType = SCellStyle.BorderType.MEDIUM;
                break;
            }
            case 5: {
                borderType = SCellStyle.BorderType.THICK;
                break;
            }
            case 6: {
                borderType = SCellStyle.BorderType.DOUBLE;
                break;
            }
            default: {
                borderType = null;
            }
        }
        return StyleConversionUtil.getBorderStyle(borderType);
    }

    public static BorderStyle getBorderStyle(SCellStyle.BorderType borderStyle) {
        switch (borderStyle) {
            case DOTTED: {
                return new BorderStyle(1.0f, 0, new float[]{1.0f, 1.0f}, 0.0f);
            }
            case HAIR: {
                return new BorderStyle(1.5f, 0, new float[]{1.5f, 1.5f}, 0.0f);
            }
            case DASH_DOT_DOT: {
                return new BorderStyle(1.5f, 0, new float[]{10.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f}, 0.0f);
            }
            case MEDIUM_DASH_DOT_DOT: {
                return new BorderStyle(1.7f, 0, new float[]{10.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f}, 0.0f);
            }
            case DASH_DOT: {
                return new BorderStyle(1.5f, 0, new float[]{10.0f, 3.0f, 3.0f, 3.0f}, 0.0f);
            }
            case DASHED: {
                return new BorderStyle(1.0f, 0, new float[]{5.0f}, 0.0f);
            }
            case THIN: {
                return new BorderStyle(1.0f, 0, new float[0], 0.0f);
            }
            case SLANTED_DASH_DOT: {
                return new BorderStyle(2.0f, 0, new float[]{10.0f, 3.0f, 3.0f, 3.0f}, 0.0f);
            }
            case MEDIUM_DASH_DOT: {
                return new BorderStyle(1.7f, 0, new float[]{10.0f, 3.0f, 3.0f, 3.0f}, 0.0f);
            }
            case MEDIUM_DASHED: {
                return new BorderStyle(2.0f, 0, new float[]{5.0f}, 0.0f);
            }
            case MEDIUM: {
                return new BorderStyle(1.7f, 0, new float[0], 0.0f);
            }
            case THICK: {
                return new BorderStyle(2.2f, 0, new float[0], 0.0f);
            }
            case DOUBLE: {
                return new BorderStyle(0.6f, 0, new float[0], 0.0f);
            }
        }
        return null;
    }
}

