/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Utilities;
import com.lowagie.text.html.WebColors;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;
import org.zkoss.lang.Library;
import org.zkoss.poi.ss.usermodel.ZssContext;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SChart;
import org.zkoss.zss.model.SColor;
import org.zkoss.zss.model.SFont;
import org.zkoss.zss.model.SFooter;
import org.zkoss.zss.model.SHeader;
import org.zkoss.zss.model.SPicture;
import org.zkoss.zss.model.SPrintSetup;
import org.zkoss.zss.model.SRichText;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.ViewAnchor;
import org.zkoss.zss.model.impl.AbstractRowAdv;
import org.zkoss.zss.model.impl.PrintSetupImpl;
import org.zkoss.zss.model.impl.pdf.CellRenderEvent;
import org.zkoss.zss.model.impl.pdf.FontLoader;
import org.zkoss.zss.model.impl.pdf.LayoutUnitConversionHelper;
import org.zkoss.zss.model.impl.pdf.PageSizeConversionUtil;
import org.zkoss.zss.model.impl.pdf.RenderInfo;
import org.zkoss.zss.model.impl.pdf.StyleConversionUtil;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.format.FormatContext;
import org.zkoss.zss.model.sys.format.FormatEngine;
import org.zkoss.zss.model.sys.format.FormatResult;
import org.zkoss.zss.range.SExporter;
import org.zkoss.zss.range.impl.imexp.PoiEnumConversion;
import org.zkoss.zssex.util.ChartHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfExporter
implements SExporter,
Serializable {
    private static final long serialVersionUID = 671162544116213200L;
    static final float PAD_TOP = 0.0f;
    static final float PAD_BOTTOM = 1.4f;
    static final float PAD_LEFT = 1.5f;
    static final float PAD_RIGHT = 1.5f;
    static final float OUTLINE_WIDTH = 0.8f;
    static final float GRIDLINE_WIDTH = 0.4f;
    static final float DOUBLE_LINE_SPACE = 1.4f;
    static final float DOUBLE_LINE_WIDTH = 0.6f;
    static final float UNDERLINE_WIDTH = 0.6f;
    static final float UNDERLINE_OFFSET = 0.6f;
    static final float ACCOUNT_UNDERLINE_OFFSET = 1.0f;
    private SBook _wb;
    private PdfWriter _writer;
    private int[] _colBreaks;
    private int[] _rowBreaks;
    private int _firstCol;
    private int _endCol;
    private int _firstRow;
    private int _endRow;
    private int _printCol1;
    private int _printCol2;
    private int _printRow1;
    private int _printRow2;
    private int _pageCount;
    private int _pageNumber;
    private String _sheetName;
    private String _bookName;
    private Font _docStandardFont;
    private SPrintSetup _printSetup;
    private Rectangle _paperSize;
    private double _totalHeaderFooterWidth;
    private double _leftMargin;
    private double _rightMargin;
    private double _topMargin;
    private double _bottomMargin;
    private double _headerMargin;
    private double _footerMargin;
    private double _totalPrintWidth;
    private double _totalPrintHeight;
    private double[] _repeatColLeft;
    private double[] _repeatRowTop;
    private double[] _colLeft;
    private double[] _rowTop;
    private int _currentSheetIndex = 0;
    List<SPicture> _pictures;
    private boolean _firstPage;
    private SSheet _currentSheet;
    private int _titleCol1 = -1;
    private int _titleCol2 = -1;
    private int _titleRow1 = -1;
    private int _titleRow2 = -1;
    private boolean _printGridlines;
    private boolean _printHeadings;
    private boolean _hcenter;
    private boolean _vcenter;
    private TreeSet<CellRegion> _extendRegions = new TreeSet<CellRegion>(new Comparator<CellRegion>(){

        @Override
        public int compare(CellRegion arg0, CellRegion arg1) {
            return arg0.getLastColumn() - arg1.getLastColumn();
        }
    });
    private Rectangle _customPaperSize;
    private int _scale;
    private int _pageRow1;
    private int _pageRow2;
    private int _pageCol1;
    private int _pageCol2;
    static final String IGNORE_COLUMN_BREAK_PROPERTY_KEY = "org.zkoss.zss.pdf.ignoreColumnBreak";
    static final String IGNORE_ROW_BREAK_PROPERTY_KEY = "org.zkoss.zss.pdf.ignoreRowBreak";

    public PdfExporter() {
        FontLoader.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(SBook book, File file) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            this.export(book, (OutputStream)os);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
    }

    public void export(SBook workbook, OutputStream outputStream) throws IOException {
        Document doc = new Document();
        try {
            this._wb = workbook;
            this._bookName = workbook.getBookName();
            SSheet sheet0 = this._wb.getSheet(0);
            this.setupExporter(sheet0, outputStream, doc);
            doc.open();
            this._currentSheetIndex = 0;
            this.exportSheet(sheet0, 0, doc);
            int numSheets = workbook.getNumOfSheet();
            for (int i = 1; i < numSheets; ++i) {
                SSheet sheet = workbook.getSheet(i);
                this.initDocumentForSheet(sheet, doc);
                this._currentSheetIndex = i;
                this.exportSheet(sheet, i, doc);
            }
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
        finally {
            doc.close();
        }
    }

    public void export(SSheet worksheet, OutputStream outputStream) throws IOException {
        Document doc = new Document();
        try {
            this._wb = worksheet.getBook();
            this._bookName = worksheet.getBook().getBookName();
            this.setupExporter(worksheet, outputStream, doc);
            doc.open();
            this._currentSheetIndex = this._wb.getSheetIndex(worksheet);
            this.exportSheet(worksheet, this._currentSheetIndex, doc);
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
        finally {
            doc.close();
        }
    }

    public void export(SheetRegion sheetRegion, OutputStream outputStream) throws IOException {
        Document doc = new Document();
        try {
            SSheet worksheet = sheetRegion.getSheet();
            CellRegion area = sheetRegion.getRegion();
            this._wb = worksheet.getBook();
            this._bookName = worksheet.getBook().getBookName();
            this.setupExporter(worksheet, outputStream, doc);
            doc.open();
            this._currentSheetIndex = this._wb.getSheetIndex(worksheet);
            this.exportSheetSelection(worksheet, this._currentSheetIndex, area, doc);
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
        finally {
            doc.close();
        }
    }

    private Document setupExporter(SSheet sheet, OutputStream outputStream, Document document) throws DocumentException {
        this._writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        this.initDocument(sheet, document);
        PdfHeaderFooter phf = new PdfHeaderFooter();
        this._writer.setPageEvent((PdfPageEvent)phf);
        return document;
    }

    private void printScalePages(float scale, Document doc, byte[] pdfIn) throws IOException {
        PdfReader reader = new PdfReader(pdfIn);
        PdfContentByte cb = this._writer.getDirectContent();
        float x = (float)this._leftMargin;
        float y = (float)this._bottomMargin;
        this._pageCount = reader.getNumberOfPages();
        try {
            for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                PdfImportedPage page = this._writer.getImportedPage(reader, i);
                cb.addTemplate((PdfTemplate)page, scale, 0.0f, 0.0f, scale, x, y);
                doc.newPage();
            }
        }
        catch (ExceptionConverter ex) {
            throw (IOException)ex.getException();
        }
    }

    private void printScaleSheet(SSheet sheet, Document doc, SPrintSetup ps) throws IOException {
        float newWidth = (float)(this._totalPrintWidth * 100.0 / (double)this._scale);
        float newHeight = (float)(this._totalPrintHeight * 100.0 / (double)this._scale);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PdfExporter scaleExporter = new PdfExporter();
        scaleExporter.setCustomPaperSize(newWidth, newHeight);
        SPrintSetup scalePs = scaleExporter.getPrintSetup();
        ((PrintSetupImpl)scalePs).copyFrom((PrintSetupImpl)ps);
        scalePs.setLeftMargin(0.0);
        scalePs.setTopMargin(0.0);
        scalePs.setRightMargin(0.0);
        scalePs.setBottomMargin(0.0);
        scalePs.setHeaderMargin(0.0);
        scalePs.setFooterMargin(0.0);
        scalePs.setDifferentFirstPage(false);
        scalePs.setDifferentOddEvenPage(false);
        scalePs.setHeader(null);
        scalePs.setFooter(null);
        scalePs.setLandscape(false);
        scalePs.setScale(100);
        scalePs.setFitHeight(0);
        scalePs.setFitWidth(0);
        scaleExporter.export(sheet, (OutputStream)os);
        this.printScalePages((float)((double)this._scale / 100.0), doc, os.toByteArray());
    }

    private int prepareFitPageScale(SSheet sheet, int fitWidth, int fitHeight) {
        int scaleX = 100;
        int scaleY = 100;
        if (fitHeight > 0) {
            scaleY = this.prepareScaleY(sheet, fitHeight);
        }
        if (fitWidth > 0) {
            scaleX = this.prepareScaleX(sheet, fitWidth);
        }
        return Math.min(scaleX, scaleY);
    }

    private int prepareScaleY(SSheet sheet, int fitHeight) {
        double total = 0.0;
        double defaultRowHeight = LayoutUnitConversionHelper.pxToPdfHeightPoints(sheet.getDefaultRowHeight());
        if (this._printHeadings) {
            total = defaultRowHeight * (double)fitHeight;
        }
        if (this.isUseRowTitles()) {
            if (this._titleRow2 < this._firstRow) {
                total += this._repeatRowTop[this._titleRow2 + 1 - this._titleRow1] * (double)fitHeight;
            } else if (this._titleRow1 < this._firstRow) {
                total += this._repeatRowTop[this._firstRow - this._titleRow1] + this._repeatRowTop[this._titleRow2 + 1 - this._titleRow1] * (double)(fitHeight - 1);
            }
        }
        double avgHeight = (total += this._rowTop[this._endRow - this._firstRow]) / (double)fitHeight;
        double pageHeight = Math.max(this._totalPrintHeight, avgHeight);
        double headHeight = 0.0;
        if (this._printHeadings) {
            headHeight = defaultRowHeight;
        }
        double currentPageHeight = headHeight;
        double titleHeight = this.getTitleHeight();
        boolean firstRowInPage = true;
        int pageCount = 0;
        if (this.isUseRowTitles()) {
            if (this._titleRow2 < this._firstRow) {
                currentPageHeight += titleHeight;
            } else if (this._titleRow1 < this._firstRow) {
                currentPageHeight += this._repeatRowTop[this._firstRow - this._titleRow1];
            }
        }
        for (int i = this._firstRow; i <= this._endRow; ++i) {
            boolean exceedEdge;
            double rowHeight = this._rowTop[i + 1 - this._firstRow] - this._rowTop[i - this._firstRow];
            boolean bl = exceedEdge = (currentPageHeight += rowHeight) > pageHeight;
            if (exceedEdge) {
                double partNextPage = currentPageHeight - pageHeight;
                double partThisPage = rowHeight - partNextPage;
                double rest = total - currentPageHeight + rowHeight;
                if (pageCount < fitHeight - 1 && !firstRowInPage && (pageCount == fitHeight - 2 && rest <= pageHeight || partNextPage > partThisPage)) {
                    --i;
                    total = rest;
                    avgHeight = total / (double)(fitHeight - pageCount - 1);
                    if (pageHeight < avgHeight) {
                        pageHeight = avgHeight;
                    }
                } else {
                    pageHeight = currentPageHeight;
                    total -= currentPageHeight;
                }
                ++pageCount;
                currentPageHeight = headHeight;
                if (this.isUseRowTitles()) {
                    if (this._titleRow2 < i) {
                        currentPageHeight += titleHeight;
                    } else if (this._titleRow1 < i) {
                        currentPageHeight += this._repeatRowTop[i - this._titleRow1];
                    }
                }
                firstRowInPage = true;
                continue;
            }
            firstRowInPage = false;
        }
        if (!firstRowInPage) {
            ++pageCount;
        }
        return pageHeight > this._totalPrintHeight ? (int)(this._totalPrintHeight * 100.0 / pageHeight) : 100;
    }

    private int prepareScaleX(SSheet sheet, int fitWidth) {
        double total = 0.0;
        double defaultColWidth = StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH;
        if (this._printHeadings) {
            total = defaultColWidth * (double)fitWidth;
        }
        if (this.isUseColTitles()) {
            if (this._titleCol2 < this._printCol1) {
                total += this._repeatColLeft[this._titleCol2 + 1 - this._titleCol1] * (double)fitWidth;
            } else if (this._titleCol1 < this._printCol1) {
                total += this._repeatColLeft[this._printCol1 - this._titleCol1] + this._repeatColLeft[this._titleCol2 + 1 - this._titleCol1] * (double)(fitWidth - 1);
            }
        }
        double avgWidth = (total += this._colLeft[this._printCol2 - this._firstCol]) / (double)fitWidth;
        double pageWidth = Math.max(this._totalPrintWidth, avgWidth);
        double headWidth = 0.0;
        if (this._printHeadings) {
            headWidth = defaultColWidth;
        }
        double currentPageWidth = headWidth;
        double titleWidth = this.getTitleWidth();
        boolean firstColInPage = true;
        int pageCount = 0;
        if (this.isUseColTitles()) {
            if (this._titleCol2 < this._printCol1) {
                currentPageWidth += titleWidth;
            } else if (this._titleCol1 < this._printCol1) {
                currentPageWidth += this._repeatColLeft[this._printCol1 - this._titleCol1];
            }
        }
        for (int i = this._printCol1; i <= this._printCol2; ++i) {
            boolean exceedEdge;
            double colWidth = this._colLeft[i + 1 - this._firstCol] - this._colLeft[i - this._firstCol];
            boolean bl = exceedEdge = (currentPageWidth += colWidth) > pageWidth;
            if (exceedEdge) {
                double partNextPage = currentPageWidth - pageWidth;
                double partThisPage = colWidth - partNextPage;
                double rest = total - currentPageWidth + colWidth;
                if (pageCount < fitWidth - 1 && !firstColInPage && (pageCount == fitWidth - 2 && rest <= pageWidth || partNextPage > partThisPage)) {
                    --i;
                    total = rest;
                    avgWidth = total / (double)(fitWidth - pageCount - 1);
                    if (pageWidth < avgWidth) {
                        pageWidth = avgWidth;
                    }
                } else {
                    pageWidth = currentPageWidth;
                    total -= currentPageWidth;
                }
                ++pageCount;
                currentPageWidth = headWidth;
                if (this.isUseColTitles()) {
                    if (this._titleCol2 < i) {
                        currentPageWidth += titleWidth;
                    } else if (this._titleCol1 < i) {
                        currentPageWidth += this._repeatColLeft[i - this._titleCol1];
                    }
                }
                firstColInPage = true;
                continue;
            }
            firstColInPage = false;
        }
        if (!firstColInPage) {
            ++pageCount;
        }
        return pageWidth > this._totalPrintWidth ? (int)(this._totalPrintWidth * 100.0 / pageWidth) : 100;
    }

    private void exportSheetSelection(SSheet sheet, int sheetIndex, CellRegion area, Document doc) throws DocumentException, IOException {
        boolean useFitPages;
        SPrintSetup ps = this.getCurrentPrintSetup(sheet);
        this._scale = ps.getScale();
        int fitHeight = ps.getFitHeight();
        int fitWidth = ps.getFitWidth();
        boolean bl = useFitPages = fitHeight > 0 || fitWidth > 0;
        if (this._scale != 100) {
            this.printScaleSheet(sheet, doc, ps);
            return;
        }
        CellRegion crgn = ps.getRepeatingColumnsTitle();
        if (crgn != null) {
            this._titleCol1 = crgn.getColumn();
            this._titleCol2 = crgn.getLastColumn();
        } else {
            this._titleCol1 = -1;
            this._titleCol2 = -1;
        }
        CellRegion rrgn = ps.getRepeatingRowsTitle();
        if (rrgn != null) {
            this._titleRow1 = rrgn.getRow();
            this._titleRow2 = rrgn.getLastRow();
        } else {
            this._titleRow1 = -1;
            this._titleRow2 = -1;
        }
        this._printGridlines = ps.isPrintGridlines();
        this._printHeadings = ps.isPrintHeadings();
        this._hcenter = ps.isHCenter();
        this._vcenter = ps.isVCenter();
        this._currentSheet = sheet;
        this.initPrintArea(sheet, area);
        if (this._endCol >= 0 && this._endRow >= 0) {
            this.initRowColumnPositions(sheet);
            if (useFitPages) {
                this._scale = this.prepareFitPageScale(sheet, fitWidth, fitHeight);
                if (this._scale != 100) {
                    this.printScaleSheet(sheet, doc, ps);
                    return;
                }
            }
            boolean ignoreRowManualBreaks = "true".equalsIgnoreCase(Library.getProperty((String)IGNORE_ROW_BREAK_PROPERTY_KEY));
            boolean ignoreColManualBreaks = "true".equalsIgnoreCase(Library.getProperty((String)IGNORE_COLUMN_BREAK_PROPERTY_KEY));
            this.prepareRowBreaks(sheet, ignoreRowManualBreaks);
            this.prepareColBreaks(sheet, ignoreColManualBreaks);
            this.getPictureData(sheet);
            this.printSheet(sheet, doc);
        }
    }

    private void initRowColumnPositions(SSheet sheet) {
        int j;
        double defaultRowHeight = LayoutUnitConversionHelper.pxToPdfHeightPoints(sheet.getDefaultRowHeight());
        if (this.isUseColTitles()) {
            int extendedTitleCol2 = this._titleCol2;
            Iterator rowIterX = sheet.getRowIterator();
            while (rowIterX.hasNext()) {
                SRow row = (SRow)rowIterX.next();
                int rowIdx = row.getIndex();
                CellRegion mergedRegion = this.getMergedRegionIfAny(sheet, rowIdx, this._titleCol2);
                if (mergedRegion != null) {
                    int col = mergedRegion.getLastColumn();
                    if (col <= extendedTitleCol2) continue;
                    extendedTitleCol2 = col;
                    continue;
                }
                SCell zssCell = sheet.getCell(rowIdx, this._titleCol2);
                int col = this.getExtendedEndColumn(sheet, zssCell, this._titleCol2);
                if (col <= extendedTitleCol2) continue;
                extendedTitleCol2 = col;
            }
            double titleWidth = 0.0;
            this._repeatColLeft = new double[extendedTitleCol2 - this._titleCol1 + 2];
            for (j = this._titleCol1; j <= extendedTitleCol2; ++j) {
                this._repeatColLeft[j - this._titleCol1] = titleWidth;
                titleWidth += LayoutUnitConversionHelper.pxToPdfWidthPoints(sheet.getColumn(j).getWidth());
            }
            this._repeatColLeft[extendedTitleCol2 + 1 - this._titleCol1] = titleWidth;
        }
        if (this.isUseRowTitles()) {
            double titleHeight = 0.0;
            this._repeatRowTop = new double[this._titleRow2 - this._titleRow1 + 2];
            for (int j2 = this._titleRow1; j2 <= this._titleRow2; ++j2) {
                this._repeatRowTop[j2 - this._titleRow1] = titleHeight;
                SRow currentRow = sheet.getRow(j2);
                if (currentRow != null) {
                    titleHeight += LayoutUnitConversionHelper.pxToPdfHeightPoints(currentRow.getHeight());
                    continue;
                }
                titleHeight += defaultRowHeight;
            }
            this._repeatRowTop[this._titleRow2 + 1 - this._titleRow1] = titleHeight;
        }
        double titleWidth = 0.0;
        this._colLeft = new double[this._endCol - this._firstCol + 2];
        for (int j3 = this._firstCol; j3 <= this._endCol; ++j3) {
            this._colLeft[j3 - this._firstCol] = titleWidth;
            titleWidth += LayoutUnitConversionHelper.pxToPdfWidthPoints(sheet.getColumn(j3).getWidth());
        }
        this._colLeft[this._endCol + 1 - this._firstCol] = titleWidth;
        double titleHeight = 0.0;
        this._rowTop = new double[this._endRow - this._firstRow + 2];
        for (j = this._firstRow; j <= this._endRow; ++j) {
            this._rowTop[j - this._firstRow] = titleHeight;
            SRow currentRow = sheet.getRow(j);
            if (currentRow != null) {
                titleHeight += LayoutUnitConversionHelper.pxToPdfHeightPoints(currentRow.getHeight());
                continue;
            }
            titleHeight += defaultRowHeight;
        }
        this._rowTop[this._endRow + 1 - this._firstRow] = titleHeight;
    }

    private void exportSheet(SSheet sheet, int sheetIndex, Document doc) throws DocumentException, IOException {
        this._currentSheet = sheet;
        this._sheetName = sheet.getSheetName();
        PrintSetupImpl ps = (PrintSetupImpl)this.getCurrentPrintSetup(sheet);
        CellRegion[] regions = ps.getPrintAreas(sheet);
        if (regions == null) {
            this.exportSheetSelection(sheet, sheetIndex, null, doc);
        } else {
            for (CellRegion rgn : regions) {
                this.exportSheetSelection(sheet, sheetIndex, rgn, doc);
            }
        }
    }

    private void getPictureData(SSheet sheet) {
        this._pictures = sheet.getPictures();
    }

    private void prepareRowBreaks(SSheet sheet, boolean ignoreManualBreaks) {
        this._rowBreaks = ignoreManualBreaks ? new int[0] : sheet.getViewInfo().getRowBreaks();
        if (this._rowBreaks == null) {
            this._rowBreaks = new int[0];
        }
        this.setupRowBreaks(sheet);
    }

    private void prepareColBreaks(SSheet sheet, boolean ignoreManualBreaks) {
        this._colBreaks = ignoreManualBreaks ? new int[0] : sheet.getViewInfo().getColumnBreaks();
        if (this._colBreaks == null) {
            this._colBreaks = new int[0];
        }
        this.setupColumnBreaks(sheet);
    }

    private void setupRowBreaks(SSheet sheet) {
        double headHeight = 0.0;
        double defaultRowHeight = LayoutUnitConversionHelper.pxToPdfHeightPoints(sheet.getDefaultRowHeight());
        if (this._printHeadings) {
            headHeight = defaultRowHeight;
        }
        double currentPageHeight = headHeight;
        double titleHeight = this.getTitleHeight();
        boolean firstRowInPage = true;
        ArrayList<Integer> autoRowBreaks = new ArrayList<Integer>();
        if (this.isUseRowTitles()) {
            if (this._titleRow2 < this._printRow1) {
                currentPageHeight += titleHeight;
            } else if (this._titleRow1 < this._printRow1) {
                currentPageHeight += this._repeatRowTop[this._printRow1 - this._titleRow1];
            }
        }
        for (int i = this._printRow1; i <= this._printRow2; ++i) {
            boolean exceedEdge;
            double rowHeight = this._rowTop[i + 1 - this._firstRow] - this._rowTop[i - this._firstRow];
            boolean manualBreak = this.isRowPageBreak(i);
            boolean bl = exceedEdge = (currentPageHeight += rowHeight) > this._totalPrintHeight;
            if (exceedEdge || manualBreak) {
                if (exceedEdge && !firstRowInPage) {
                    --i;
                }
                autoRowBreaks.add(i + 1);
                currentPageHeight = headHeight;
                if (this.isUseRowTitles()) {
                    if (this._titleRow2 < i) {
                        currentPageHeight += titleHeight;
                    } else if (this._titleRow1 < i) {
                        currentPageHeight += this._repeatRowTop[i - this._titleRow1];
                    }
                }
                firstRowInPage = true;
                continue;
            }
            firstRowInPage = false;
        }
        if (!firstRowInPage) {
            autoRowBreaks.add(this._printRow2 + 1);
        }
        if (autoRowBreaks.size() > 0) {
            this._rowBreaks = PdfExporter.convertIntegers(autoRowBreaks);
        }
    }

    private void setupColumnBreaks(SSheet sheet) {
        SPrintSetup ps = this.getCurrentPrintSetup(sheet);
        boolean printHeadings = ps.isPrintHeadings();
        double headWidth = 0.0;
        if (printHeadings) {
            headWidth = StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH;
        }
        double currentPageWidth = headWidth;
        double titleWidth = this.getTitleWidth();
        boolean firstColInPage = true;
        ArrayList<Integer> autoColumnBreaks = new ArrayList<Integer>();
        if (this.isUseColTitles()) {
            if (this._titleCol2 < this._printCol1) {
                currentPageWidth += titleWidth;
            } else if (this._titleCol1 < this._printCol1) {
                currentPageWidth += this._repeatColLeft[this._printCol1 - this._titleCol1];
            }
        }
        for (int i = this._printCol1; i <= this._printCol2; ++i) {
            boolean exceedEdge;
            double colWidth = this._colLeft[i + 1 - this._firstCol] - this._colLeft[i - this._firstCol];
            boolean manualBreak = this.isColPageBreak(i);
            boolean bl = exceedEdge = (currentPageWidth += colWidth) > this._totalPrintWidth;
            if (exceedEdge || manualBreak) {
                if (!firstColInPage && exceedEdge) {
                    --i;
                }
                autoColumnBreaks.add(i + 1);
                currentPageWidth = headWidth;
                if (this.isUseColTitles()) {
                    if (this._titleCol2 < i) {
                        currentPageWidth += titleWidth;
                    } else if (this._titleCol1 < i) {
                        currentPageWidth += this._repeatColLeft[i - this._titleCol1];
                    }
                }
                firstColInPage = true;
                continue;
            }
            firstColInPage = false;
        }
        if (!firstColInPage) {
            autoColumnBreaks.add(this._printCol2 + 1);
        }
        if (autoColumnBreaks.size() > 0) {
            this._colBreaks = PdfExporter.convertIntegers(autoColumnBreaks);
        }
    }

    private boolean isColPageBreak(int col) {
        return Arrays.binarySearch(this._colBreaks, col) >= 0;
    }

    private boolean isRowPageBreak(int row) {
        return Arrays.binarySearch(this._rowBreaks, row) >= 0;
    }

    private static int[] convertIntegers(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = integers.get(i);
        }
        return ret;
    }

    private void setCustomPaperSize(float width, float height) {
        this._customPaperSize = new Rectangle(0.0f, 0.0f, width, height);
    }

    private void initDocument(SSheet sheet, Document doc) {
        SFont defFont = sheet.getBook().getDefaultFont();
        this._docStandardFont = FontFactory.getFont((String)defFont.getName(), (String)"Identity-H");
        this._docStandardFont.setSize(11.0f);
        this._docStandardFont.setStyle(0);
        this.initDocumentForSheet(sheet, doc);
    }

    private void initDocumentForSheet(SSheet sheet, Document doc) {
        SPrintSetup ps = this.getCurrentPrintSetup(sheet);
        this._pageNumber = ps.getPageStart() > 0 ? ps.getPageStart() - 1 : 0;
        this._firstPage = true;
        this._leftMargin = Utilities.inchesToPoints((float)((float)ps.getLeftMargin()));
        this._rightMargin = Utilities.inchesToPoints((float)((float)ps.getRightMargin()));
        this._topMargin = Utilities.inchesToPoints((float)((float)ps.getTopMargin()));
        this._bottomMargin = Utilities.inchesToPoints((float)((float)ps.getBottomMargin()));
        this._headerMargin = Utilities.inchesToPoints((float)((float)ps.getHeaderMargin()));
        this._footerMargin = Utilities.inchesToPoints((float)((float)ps.getFooterMargin()));
        Rectangle rectangle = this._paperSize = this._customPaperSize != null ? this._customPaperSize : PageSizeConversionUtil.getPageSize(PoiEnumConversion.toPoiPaperSize((SPrintSetup.PaperSize)ps.getPaperSize()));
        if (ps.isLandscape()) {
            Rectangle r;
            this._paperSize = r = this._paperSize.rotate();
            doc.setPageSize(r);
            this._totalHeaderFooterWidth = (double)r.getWidth() - (this._topMargin + this._bottomMargin);
        } else {
            doc.setPageSize(this._paperSize);
            this._totalHeaderFooterWidth = (double)this._paperSize.getWidth() - (this._leftMargin + this._rightMargin);
        }
        this._totalPrintWidth = (double)this._paperSize.getRight() - this._rightMargin - ((double)this._paperSize.getLeft() + this._leftMargin);
        this._totalPrintHeight = (double)this._paperSize.getTop() - this._topMargin - ((double)this._paperSize.getBottom() + this._bottomMargin);
        doc.setMargins((float)this._leftMargin, (float)this._rightMargin, (float)this._topMargin, (float)this._bottomMargin);
    }

    private void printSheet(SSheet sheet, Document doc) throws DocumentException, IOException {
        this._extendRegions.clear();
        this._pageCount = this._rowBreaks.length * this._colBreaks.length;
        SPrintSetup ps = this.getCurrentPrintSetup(sheet);
        try {
            if (ps.isLeftToRight()) {
                int bRow = this._printRow1;
                for (int j = 0; j < this._rowBreaks.length; ++j) {
                    int eRow = this._rowBreaks[j];
                    int bCol = this._printCol1;
                    for (int k = 0; k < this._colBreaks.length; ++k) {
                        int eCol = this._colBreaks[k];
                        this.printPage(bRow, eRow, bCol, eCol, sheet, doc);
                        doc.newPage();
                        bCol = eCol;
                    }
                    bRow = eRow;
                }
            } else {
                int bCol = this._printCol1;
                for (int j = 0; j < this._colBreaks.length; ++j) {
                    int eCol = this._colBreaks[j];
                    int bRow = this._printRow1;
                    for (int k = 0; k < this._rowBreaks.length; ++k) {
                        int eRow = this._rowBreaks[k];
                        this.printPage(bRow, eRow, bCol, eCol, sheet, doc);
                        doc.newPage();
                        bRow = eRow;
                    }
                    bCol = eCol;
                }
            }
        }
        catch (ExceptionConverter ex) {
            throw (IOException)ex.getException();
        }
    }

    private void printPage(int bRow, int eRow, int bCol, int eCol, SSheet sheet, Document doc) throws DocumentException {
        double shift;
        float rowHeight;
        int j;
        PdfPTable pdfTable = this.createPdfTable(bCol, eCol, sheet);
        this._pageRow1 = bRow;
        this._pageRow2 = eRow;
        this._pageCol1 = bCol;
        this._pageCol2 = eCol;
        int outlineRow1 = bRow;
        int outlineCol1 = bCol;
        int outlineRow2 = eRow - 1;
        int outlineCol2 = eCol - 1;
        if (this.isUseRowTitles() && bRow > this._titleRow1) {
            outlineRow1 = this._titleRow1;
        }
        if (this.isUseColTitles() && bCol > this._titleCol1) {
            outlineCol1 = this._titleCol1;
        }
        CellRegion outlineRegion = new CellRegion(outlineRow1, outlineCol1, outlineRow2, outlineCol2);
        if (this.isUseRowTitles()) {
            if (bRow > this._titleRow2) {
                for (j = this._titleRow1; j <= this._titleRow2; ++j) {
                    rowHeight = (float)(this._repeatRowTop[j + 1 - this._titleRow1] - this._repeatRowTop[j - this._titleRow1]);
                    this.printRow(pdfTable, j, this._titleRow1, this._titleRow2 + 1, bCol, eCol, sheet, rowHeight, outlineRegion);
                }
            } else if (bRow > this._titleRow1) {
                for (j = this._titleRow1; j < bRow; ++j) {
                    rowHeight = (float)(this._repeatRowTop[j + 1 - this._titleRow1] - this._repeatRowTop[j - this._titleRow1]);
                    this.printRow(pdfTable, j, this._titleRow1, eRow, bCol, eCol, sheet, rowHeight, outlineRegion);
                }
            }
        }
        for (j = bRow; j < eRow; ++j) {
            rowHeight = (float)(this._rowTop[j + 1 - this._firstRow] - this._rowTop[j - this._firstRow]);
            this.printRow(pdfTable, j, bRow, eRow, bCol, eCol, sheet, rowHeight, outlineRegion);
        }
        double offsetX = this._leftMargin;
        double offsetY = this._bottomMargin + this._totalPrintHeight;
        if (this._vcenter) {
            double tableHeight = pdfTable.getTotalHeight();
            shift = (this._totalPrintHeight - tableHeight) / 2.0;
            offsetY -= shift;
        }
        if (this._hcenter) {
            double tableWidth = pdfTable.getTotalWidth();
            shift = (this._totalPrintWidth - tableWidth) / 2.0;
            offsetX += shift;
        }
        pdfTable.writeSelectedRows(0, -1, (float)offsetX, (float)offsetY, this._writer.getDirectContent());
    }

    private void printRow(PdfPTable pdfTable, int rowIdx, int bRow, int eRow, int bCol, int eCol, SSheet sheet, float rowHeight, CellRegion outlineRegion) {
        int k;
        if (this._printHeadings) {
            this.printRowHeadingCell(pdfTable, rowIdx, rowHeight);
        }
        if (this.isUseColTitles()) {
            if (bCol > this._titleCol2) {
                for (k = this._titleCol1; k <= this._titleCol2; ++k) {
                    k = this.printCell(pdfTable, rowIdx, k, sheet, rowHeight, bRow, eRow, this._titleCol1, this._titleCol2 + 1, outlineRegion);
                }
            } else if (bCol > this._titleCol1) {
                for (k = this._titleCol1; k < bCol; ++k) {
                    k = this.printCell(pdfTable, rowIdx, k, sheet, rowHeight, bRow, eRow, this._titleCol1, eCol, outlineRegion);
                }
            }
        }
        for (k = bCol; k < eCol; ++k) {
            k = this.printCell(pdfTable, rowIdx, k, sheet, rowHeight, bRow, eRow, bCol, eCol, outlineRegion);
        }
    }

    private int printCell(PdfPTable pdfTable, int rowIdx, int colIdx, SSheet sheet, double rowHeight, int bRow, int eRow, int bCol, int eCol, CellRegion outlineRegion) {
        CellRegion renderRegion = null;
        CellRegion clipRegion = null;
        SCell sCell = null;
        boolean extended = false;
        CellRegion extendRegion = this.getExtendRegion(rowIdx, colIdx);
        CellRegion mergedRegion = null;
        if (extendRegion != null) {
            int rowIdx0 = extendRegion.getRow();
            int colIdx0 = extendRegion.getColumn();
            sCell = sheet.getCell(rowIdx0, colIdx0);
            renderRegion = extendRegion;
            clipRegion = this.splitRegionsInBoundaries(renderRegion, bRow, eRow, bCol, eCol);
        } else {
            sCell = sheet.getCell(rowIdx, colIdx);
            mergedRegion = this.getMergedRegionIfAny(sheet, rowIdx, colIdx);
            if (mergedRegion != null) {
                renderRegion = mergedRegion;
                clipRegion = this.splitRegionsInBoundaries(mergedRegion, bRow, eRow, bCol, eCol);
                if (clipRegion.getColumn() == colIdx && clipRegion.getRow() == rowIdx) {
                    sCell = sheet.getCell(mergedRegion.getRow(), mergedRegion.getColumn());
                } else {
                    clipRegion = new CellRegion(rowIdx, colIdx);
                }
            } else {
                int colIdx2 = this.getExtendedEndColumn(sheet, sCell, colIdx);
                for (int j = colIdx + 1; j <= colIdx2; ++j) {
                    SCell sibling = sheet.getCell(rowIdx, j);
                    if (sibling == null || sibling.isNull() || sibling.getType() == SCell.CellType.BLANK) continue;
                    colIdx2 = j - 1;
                    break;
                }
                if (colIdx2 > colIdx) {
                    renderRegion = new CellRegion(rowIdx, colIdx, rowIdx, colIdx2);
                    clipRegion = this.splitRegionsInBoundaries(renderRegion, bRow, eRow, bCol, eCol);
                    this.addExtendRegion(renderRegion);
                    SCellStyle style = sCell.getCellStyle();
                    extended = style.getAlignment() != SCellStyle.Alignment.CENTER_SELECTION;
                } else {
                    renderRegion = clipRegion = new CellRegion(rowIdx, colIdx);
                }
            }
        }
        boolean printOutline = this._printGridlines || this._printHeadings;
        PdfPCell cell = this.createPdfCell(clipRegion, renderRegion, sCell, outlineRegion, sheet, this._printGridlines, printOutline, extended);
        cell.setFixedHeight((float)rowHeight);
        pdfTable.addCell(cell);
        int colSpan = clipRegion.getColumnCount();
        if (colSpan > 1) {
            for (int j = 1; j < colSpan; ++j) {
                int colIdx0 = j + colIdx;
                PdfPCell cell0 = this.createEmptyRowSpanCell(sheet, outlineRegion, rowHeight, renderRegion, rowIdx, colIdx0, printOutline, this._printGridlines);
                pdfTable.addCell(cell0);
            }
        }
        return clipRegion.getLastColumn();
    }

    private PdfPCell createEmptyRowSpanCell(SSheet sheet, CellRegion outlineRegion, double rowHeight, CellRegion renderRegion, int rowIdx, int colIdx, boolean printOutline, boolean printGridline) {
        SCell zssCell = sheet.getCell(rowIdx, colIdx);
        CellRegion clipRegion = new CellRegion(rowIdx, colIdx);
        PdfPCell cell = this.createPdfCell(clipRegion, renderRegion, zssCell, outlineRegion, sheet, printGridline, printOutline, false);
        cell.setFixedHeight((float)rowHeight);
        return cell;
    }

    private CellRegion splitRegionsInBoundaries(CellRegion region, int bRow, int eRow, int bCol, int eCol) {
        int r1 = region.getRow();
        int r2 = region.getLastRow();
        int c1 = region.getColumn();
        int c2 = region.getLastColumn();
        if (bRow <= r1) {
            if (bCol <= c1) {
                return new CellRegion(r1, c1, Math.min(r2, eRow - 1), Math.min(c2, eCol - 1));
            }
            return new CellRegion(r1, bCol, Math.min(r2, eRow - 1), Math.min(c2, eCol - 1));
        }
        if (bCol <= c1) {
            return new CellRegion(bRow, c1, Math.min(r2, eRow - 1), Math.min(c2, eCol - 1));
        }
        return new CellRegion(bRow, bCol, Math.min(r2, eRow - 1), Math.min(c2, eCol - 1));
    }

    private CellRegion getExtendRegion(int rowIdx, int colIdx) {
        HashSet<CellRegion> toRemoved = new HashSet<CellRegion>();
        for (CellRegion range : this._extendRegions) {
            if (rowIdx == range.getRow() && colIdx >= range.getColumn() && colIdx <= range.getLastColumn()) {
                return range;
            }
            if (rowIdx != range.getRow() || colIdx <= range.getLastColumn()) continue;
            toRemoved.add(range);
        }
        if (!toRemoved.isEmpty()) {
            this._extendRegions.removeAll(toRemoved);
        }
        return null;
    }

    private void addExtendRegion(CellRegion region) {
        this._extendRegions.add(region);
    }

    private PdfPTable createPdfTable(int bCol, int eCol, SSheet sheet) throws DocumentException {
        double width;
        int j;
        int len;
        int numOfColumns;
        int n = numOfColumns = this._printHeadings ? 1 : 0;
        numOfColumns = this.isUseColTitles() ? (bCol > this._titleCol2 ? (numOfColumns += eCol - bCol + this.getCountOfColTitles()) : (bCol > this._titleCol1 ? (numOfColumns += eCol - this._titleCol1) : (numOfColumns += eCol - bCol))) : (numOfColumns += eCol - bCol);
        float[] columnWidths = new float[numOfColumns];
        int columnWidthsIndex = 0;
        if (this._printHeadings) {
            columnWidths[columnWidthsIndex++] = StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH;
        }
        if (this.isUseColTitles()) {
            if (bCol > this._titleCol2) {
                len = this._titleCol2 - this._titleCol1 + 1;
                for (j = 0; j < len; ++j) {
                    width = this._repeatColLeft[j + 1] - this._repeatColLeft[j];
                    columnWidths[columnWidthsIndex++] = (float)width;
                }
            } else if (bCol > this._titleCol1) {
                len = bCol - this._titleCol1;
                for (j = 0; j < len; ++j) {
                    width = this._repeatColLeft[j + 1] - this._repeatColLeft[j];
                    columnWidths[columnWidthsIndex++] = (float)width;
                }
            }
        }
        len = eCol - this._firstCol;
        for (j = bCol - this._firstCol; j < len; ++j) {
            width = this._colLeft[j + 1] - this._colLeft[j];
            columnWidths[columnWidthsIndex++] = (float)width;
        }
        PdfPTable pdfTable = new PdfPTable(numOfColumns);
        pdfTable.setWidths(columnWidths);
        pdfTable.setLockedWidth(true);
        pdfTable.setTotalWidth(columnWidths);
        pdfTable.setSpacingBefore(0.0f);
        if (this._printHeadings) {
            float rowHeight = (float)LayoutUnitConversionHelper.pxToPdfHeightPoints(sheet.getDefaultRowHeight());
            this.printColHeadings(pdfTable, bCol, eCol, rowHeight);
        }
        return pdfTable;
    }

    private void printColHeadings(PdfPTable pdfTable, int bCol, int eCol, float rowHeight) {
        int j;
        PdfPCell cell = new PdfPCell(new Phrase(" ", this._docStandardFont));
        cell.setFixedHeight(rowHeight);
        cell.setBorderWidth(0.8f);
        pdfTable.addCell(cell);
        if (this.isUseColTitles()) {
            if (bCol > this._titleCol2) {
                for (j = this._titleCol1; j <= this._titleCol2; ++j) {
                    this.printColHeadingCell(pdfTable, j, rowHeight);
                }
            } else if (bCol > this._titleCol1) {
                for (j = this._titleCol1; j < bCol; ++j) {
                    this.printColHeadingCell(pdfTable, j, rowHeight);
                }
            }
        }
        for (j = bCol; j < eCol; ++j) {
            this.printColHeadingCell(pdfTable, j, rowHeight);
        }
    }

    private void printColHeadingCell(PdfPTable pdfTable, int colIdx, float rowHeight) {
        PdfPCell cell = new PdfPCell(new Phrase(CellRegion.convertIndexToColumnString((int)colIdx), this._docStandardFont));
        cell.setFixedHeight(rowHeight);
        cell.setPaddingTop(0.0f);
        cell.setPaddingLeft(1.5f);
        cell.setPaddingRight(1.5f);
        cell.setPaddingBottom(1.4f);
        cell.setBorderWidth(0.8f);
        cell.setHorizontalAlignment(1);
        pdfTable.addCell(cell);
    }

    private void printRowHeadingCell(PdfPTable pdfTable, int rowIdx, float rowHeight) {
        Phrase p = new Phrase("" + (rowIdx + 1), this._docStandardFont);
        PdfPCell cell = new PdfPCell();
        cell.setFixedHeight(rowHeight);
        cell.setPaddingTop(0.0f);
        cell.setPaddingLeft(1.5f);
        cell.setPaddingRight(1.5f);
        cell.setPaddingBottom(4.15f);
        cell.setBorderWidth(0.8f);
        cell.setVerticalAlignment(6);
        cell.setHorizontalAlignment(1);
        cell.setCellEvent((PdfPCellEvent)CellRenderEvent.getCellRenderEvent(null, null, null, null, null, null, false, false, null, p, null));
        pdfTable.addCell(cell);
    }

    private double[] preparePageXYInfo(SSheet sheet, int bRow, int eRow, int bCol, int eCol) {
        double pageColumnX = this._colLeft[bCol - this._firstCol];
        double pageRowY = this._rowTop[bRow - this._firstRow];
        double clipOffsetX = this._leftMargin;
        double clipOffsetY = this._topMargin;
        if (this._printHeadings) {
            double defaultRowHeight = LayoutUnitConversionHelper.pxToPdfHeightPoints(sheet.getDefaultRowHeight());
            clipOffsetY += defaultRowHeight;
            clipOffsetX += (double)StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH;
        }
        if (this.isUseColTitles()) {
            if (bCol > this._titleCol2) {
                clipOffsetX += this._repeatColLeft[this._titleCol2 + 1 - this._titleCol1] - this._repeatColLeft[0];
            } else if (bCol > this._titleCol1) {
                clipOffsetX += this._repeatColLeft[bCol - this._titleCol1] - this._repeatColLeft[0];
            }
        }
        if (this.isUseRowTitles()) {
            if (bRow > this._titleRow2) {
                clipOffsetY += this._repeatRowTop[this._titleRow2 + 1 - this._titleRow1] - this._repeatRowTop[0];
            } else if (bCol > this._titleCol1) {
                clipOffsetY += this._repeatRowTop[bRow - this._titleRow1] - this._repeatRowTop[0];
            }
        }
        return new double[]{pageColumnX, pageRowY, clipOffsetX, clipOffsetY};
    }

    private void printImage(PdfContentByte canvas, byte[] rawData, ViewAnchor anchor1, ViewAnchor anchor2, CellRegion clipRegion, CellRegion renderRegion, double pageColumnX, double pageRowY, double clipOffsetX, double clipOffsetY, boolean outline) throws IOException {
        double clipLeft = this._colLeft[clipRegion.getColumn() - this._firstCol] - pageColumnX;
        double clipTop = this._rowTop[clipRegion.getRow() - this._firstRow] - pageRowY;
        double clipRight = this._colLeft[clipRegion.getLastColumn() + 1 - this._firstCol] - pageColumnX;
        double clipBottom = this._rowTop[clipRegion.getLastRow() + 1 - this._firstRow] - pageRowY;
        RenderInfo renderInfo = this.prepareRenderInfo(clipRegion, renderRegion, false, false);
        double renderLeft = clipLeft + renderInfo.getOffsetX();
        double renderTop = clipTop + renderInfo.getOffsetY();
        try {
            Image image = Image.getInstance((byte[])rawData);
            double width = LayoutUnitConversionHelper.pxToPdfWidthPoints(anchor1.getWidth());
            double height = LayoutUnitConversionHelper.pxToPdfHeightPoints(anchor1.getHeight());
            double xOffset = LayoutUnitConversionHelper.pxToPdfWidthPoints(anchor1.getXOffset());
            double yOffset = LayoutUnitConversionHelper.pxToPdfHeightPoints(anchor1.getYOffset());
            double imageLeft = renderLeft + xOffset;
            double imageTop = renderTop + yOffset;
            double imageRight = imageLeft + width;
            double imageBottom = imageTop + height;
            double cropLeft = Math.max(clipLeft, imageLeft);
            double cropTop = Math.max(clipTop, imageTop);
            double cropRight = Math.min(clipRight, imageRight);
            double cropBottom = Math.min(clipBottom, imageBottom);
            double cropOffsetX = cropLeft - imageLeft;
            double cropOffsetY = cropTop - imageTop;
            double cropWidth = cropRight - cropLeft;
            double cropHeight = cropBottom - cropTop;
            if (cropWidth != width || cropHeight != height) {
                image = this.cropImage(image, (float)width, (float)height, this._writer, (float)cropOffsetX, (float)cropOffsetY, (float)cropWidth, (float)cropHeight);
            }
            image.scaleAbsolute((float)cropWidth, (float)cropHeight);
            double x = clipOffsetX + cropLeft;
            double y = (double)this._paperSize.getTop() - clipOffsetY - cropTop - cropHeight;
            image.setAbsolutePosition((float)x, (float)y);
            canvas.addImage(image);
            if (outline) {
                double y2;
                double x2;
                if (renderRegion.getColumn() == clipRegion.getColumn()) {
                    double y22 = y + cropHeight;
                    this.drawLine(canvas, (float)x, (float)y, (float)x, (float)y22);
                }
                if (renderRegion.getLastColumn() == clipRegion.getLastColumn()) {
                    x2 = x + cropWidth;
                    y2 = y + cropHeight;
                    this.drawLine(canvas, (float)x2, (float)y, (float)x2, (float)y2);
                }
                if (renderRegion.getRow() == clipRegion.getRow()) {
                    x2 = x + cropWidth;
                    y2 = y + cropHeight;
                    this.drawLine(canvas, (float)x, (float)y2, (float)x2, (float)y2);
                }
                if (renderRegion.getLastRow() == clipRegion.getLastRow()) {
                    x2 = x + cropWidth;
                    this.drawLine(canvas, (float)x, (float)y, (float)x2, (float)y);
                }
            }
        }
        catch (BadElementException e) {
            throw new IOException(e);
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
    }

    private void drawLine(PdfContentByte lineCanvas, float x1, float y1, float x2, float y2) {
        lineCanvas.saveState();
        lineCanvas.setLineWidth(0.4f);
        lineCanvas.setLineCap(0);
        lineCanvas.setLineDash(new float[0], 0.0f);
        lineCanvas.setColorStroke(Color.DARK_GRAY);
        lineCanvas.moveTo(x1, y1);
        lineCanvas.lineTo(x2, y2);
        lineCanvas.stroke();
        lineCanvas.restoreState();
    }

    private void layoverPictureIfAny(SSheet sheet, int bRow, int eRow, int bCol, int eCol, PdfWriter writer) throws IOException {
        PdfContentByte canvas = writer.getDirectContent();
        double[] pageInfo = this.preparePageXYInfo(sheet, bRow, eRow, bCol, eCol);
        double pageColumnX = pageInfo[0];
        double pageRowY = pageInfo[1];
        double clipOffsetX = pageInfo[2];
        double clipOffsetY = pageInfo[3];
        for (SPicture picture : sheet.getPictures()) {
            if (picture == null) continue;
            ViewAnchor anchor1 = picture.getAnchor();
            ViewAnchor anchor2 = anchor1.getRightBottomAnchor(sheet);
            int anchorLeft = anchor1.getColumnIndex();
            int anchorTop = anchor1.getRowIndex();
            int anchorRight = anchor2.getColumnIndex();
            int anchorBottom = anchor2.getRowIndex();
            if (anchorLeft > eCol || anchorRight < bCol || anchorTop > eRow || anchorBottom < bRow) continue;
            CellRegion renderRegion = new CellRegion(anchorTop, anchorLeft, anchorBottom, anchorRight);
            CellRegion clipRegion = this.splitRegionsInBoundaries(renderRegion, bRow, eRow, bCol, eCol);
            this.printImage(canvas, picture.getData(), anchor1, anchor2, clipRegion, renderRegion, pageColumnX, pageRowY, clipOffsetX, clipOffsetY, false);
        }
    }

    private Image cropImage(Image image, float origWidth, float origHeight, PdfWriter writer, float x, float y, float width, float height) throws DocumentException {
        PdfContentByte cb = writer.getDirectContent();
        PdfTemplate t = cb.createTemplate(width, height);
        t.addImage(image, origWidth, 0.0f, 0.0f, origHeight, -x, -y);
        return Image.getInstance((PdfTemplate)t);
    }

    private void layoutCharts(SSheet sheet, int bRow, int eRow, int bCol, int eCol, PdfWriter writer) throws IOException {
        PdfContentByte canvas = writer.getDirectContent();
        List charts = sheet.getCharts();
        if (charts == null || charts.size() == 0) {
            return;
        }
        double[] pageInfo = this.preparePageXYInfo(sheet, bRow, eRow, bCol, eCol);
        double pageColumnX = pageInfo[0];
        double pageRowY = pageInfo[1];
        double clipOffsetX = pageInfo[2];
        double clipOffsetY = pageInfo[3];
        for (SChart chart : charts) {
            JFreeChart jfchart;
            ViewAnchor anchor1 = chart.getAnchor();
            ViewAnchor anchor2 = anchor1.getRightBottomAnchor(sheet);
            int anchorLeft = anchor1.getColumnIndex();
            int anchorTop = anchor1.getRowIndex();
            int anchorRight = anchor2.getColumnIndex();
            int anchorBottom = anchor2.getRowIndex();
            if (anchorLeft > eCol || anchorRight < bCol || anchorTop > eRow || anchorBottom < bRow || (jfchart = ChartHelper.drawJFreeChart((SChart)chart)) == null) continue;
            ChartRenderingInfo jfinfo = new ChartRenderingInfo();
            BufferedImage bi = jfchart.createBufferedImage(chart.getAnchor().getWidth(), chart.getAnchor().getHeight(), 3, jfinfo);
            byte[] rawData = null;
            rawData = EncoderUtil.encode((BufferedImage)bi, (String)"png", (boolean)true);
            CellRegion renderRegion = new CellRegion(anchorTop, anchorLeft, anchorBottom, anchorRight);
            CellRegion clipRegion = this.splitRegionsInBoundaries(renderRegion, bRow, eRow, bCol, eCol);
            this.printImage(canvas, rawData, anchor1, anchor2, clipRegion, renderRegion, pageColumnX, pageRowY, clipOffsetX, clipOffsetY, true);
        }
    }

    private CellRegion getMergedRegionIfAny(SSheet sheet, int rowIdx, int colIdx) {
        CellRegion partOfRange = null;
        for (CellRegion range : sheet.getMergedRegions()) {
            if (colIdx < range.getColumn() || colIdx > range.getLastColumn() || rowIdx < range.getRow() || rowIdx > range.getLastRow()) continue;
            partOfRange = range;
            break;
        }
        return partOfRange;
    }

    private boolean isPartOfMergedRegion(SSheet sheet, SCell cell) {
        boolean partOfMergedRegion = false;
        for (CellRegion range : sheet.getMergedRegions()) {
            if (cell.getColumnIndex() < range.getColumn() || cell.getColumnIndex() > range.getLastColumn() || cell.getRowIndex() < range.getRow() || cell.getRowIndex() > range.getLastRow()) continue;
            partOfMergedRegion = true;
            break;
        }
        return partOfMergedRegion;
    }

    private PdfPCell createPdfCell(CellRegion clipRegion, CellRegion renderRegion, SCell zssCell, CellRegion outlineRegion, SSheet sheet, boolean printGridLines, boolean printOutline, boolean extended) {
        PdfPCell cell = null;
        if (zssCell != null && !zssCell.isNull()) {
            SCellStyle style = zssCell.getCellStyle();
            Object[] results = this.createPhrase(zssCell);
            Phrase p = (Phrase)results[0];
            Boolean isNumber = (Boolean)results[1];
            cell = new PdfPCell();
            cell.setBorder(0);
            cell.setNoWrap(!style.isWrapText());
            SColor color = style.getFillColor();
            Color baseColor = Color.white;
            if (color != null) {
                String sColor = color.getHtmlColor();
                baseColor = WebColors.getRGBColor((String)(sColor == null || "AUTO_COLOR".equals(sColor) ? "WHITE" : sColor));
                cell.setBackgroundColor(baseColor);
            }
            RenderInfo renderInfo = this.prepareRenderInfo(clipRegion, renderRegion, extended, isNumber);
            RenderInfo clipInfo = clipRegion.getColumnCount() > 1 || clipRegion.getRowCount() > 1 ? this.prepareClipInfo(clipRegion) : null;
            cell.setCellEvent((PdfPCellEvent)CellRenderEvent.getCellRenderEvent(clipRegion, clipInfo, renderRegion, renderInfo, zssCell, style, printOutline, printGridLines, outlineRegion, p, sheet));
        } else {
            cell = this.createEmptyCell(CellRenderEvent.getCellRenderEvent(clipRegion, null, renderRegion, null, null, null, printOutline, printGridLines, outlineRegion, null, sheet));
        }
        return cell;
    }

    PdfPCell createEmptyCell(CellRenderEvent event) {
        PdfPCell cell = new PdfPCell();
        cell.setBorder(0);
        cell.setPadding(0.0f);
        cell.setPaddingLeft(1.5f);
        cell.setHorizontalAlignment(-1);
        cell.setVerticalAlignment(7);
        cell.setCellEvent((PdfPCellEvent)event);
        return cell;
    }

    private RenderInfo prepareClipInfo(CellRegion clipRegion) {
        double width = this.getRegionWidth(clipRegion);
        double height = this.getRegionHeight(clipRegion);
        return new RenderInfo(0.0, 0.0, width, height, false, false);
    }

    private RenderInfo prepareRenderInfo(CellRegion clipRegion, CellRegion renderRegion, boolean extended, boolean number) {
        double xOffset = 0.0;
        double yOffset = 0.0;
        double width = this.getRegionWidth(renderRegion);
        double height = this.getRegionHeight(renderRegion);
        if (!clipRegion.equals((Object)renderRegion)) {
            int clipCol1 = clipRegion.getColumn();
            int clipRow1 = clipRegion.getRow();
            int renderCol1 = renderRegion.getColumn();
            int renderRow1 = renderRegion.getRow();
            xOffset = this.isUseColTitles() && this._titleCol1 <= renderCol1 && renderCol1 <= this._titleCol2 ? this._repeatColLeft[renderCol1 - this._titleCol1] - this._repeatColLeft[clipCol1 - this._titleCol1] : this._colLeft[renderCol1 - this._firstCol] - this._colLeft[clipCol1 - this._firstCol];
            yOffset = this.isUseRowTitles() && this._titleRow1 <= renderRow1 && renderRow1 <= this._titleRow2 ? this._repeatRowTop[renderRow1 - this._titleRow1] - this._repeatRowTop[clipRow1 - this._titleRow1] : this._rowTop[renderRow1 - this._firstRow] - this._rowTop[clipRow1 - this._firstRow];
        }
        return new RenderInfo(xOffset, yOffset, width, height, extended, number);
    }

    private double getRegionWidth(CellRegion region) {
        int col1 = region.getColumn();
        int col2 = region.getLastColumn();
        if (this.isUseColTitles() && this._titleCol1 <= col1 && col1 <= this._titleCol2 && this._titleCol1 <= col2 && col2 <= this._titleCol2) {
            return this._repeatColLeft[col2 + 1 - this._titleCol1] - this._repeatColLeft[col1 - this._titleCol1];
        }
        return this._colLeft[col2 + 1 - this._firstCol] - this._colLeft[col1 - this._firstCol];
    }

    private double getRegionHeight(CellRegion region) {
        int row1 = region.getRow();
        int row2 = region.getLastRow();
        if (this.isUseRowTitles() && this._titleRow1 <= row1 && row1 <= this._titleRow2 && this._titleRow1 <= row2 && row2 <= this._titleRow2) {
            return this._repeatRowTop[row2 + 1 - this._titleRow1] - this._repeatRowTop[row1 - this._titleRow1];
        }
        return this._rowTop[row2 + 1 - this._firstRow] - this._rowTop[row1 - this._firstRow];
    }

    private Object[] createPhrase(SCell zssCell) {
        Phrase p = null;
        boolean number = false;
        if (zssCell != null && !zssCell.isNull() && zssCell.getType() != SCell.CellType.BLANK) {
            SCellStyle style = zssCell.getCellStyle();
            SFont styleFont = style.getFont();
            FormatEngine fe = EngineFactory.getInstance().createFormatEngine();
            FormatResult result = fe.format(zssCell, new FormatContext(ZssContext.getCurrent().getLocale()));
            boolean bl = number = !result.isDateFormatted() && (zssCell.getType() == SCell.CellType.NUMBER || zssCell.getType() == SCell.CellType.FORMULA && zssCell.getFormulaResultType() == SCell.CellType.NUMBER);
            if (result.isRichText()) {
                boolean accountingUnder = styleFont.getUnderline() == SFont.Underline.SINGLE_ACCOUNTING || styleFont.getUnderline() == SFont.Underline.DOUBLE_ACCOUNTING;
                p = new Phrase();
                for (SRichText.Segment sg : result.getRichText().getSegments()) {
                    SFont zssFont = sg.getFont();
                    Font cellFont = FontFactory.getFont((String)zssFont.getName(), (String)"Identity-H");
                    cellFont.setColor(WebColors.getRGBColor((String)zssFont.getColor().getHtmlColor()));
                    int fontsize = zssFont.getHeightPoints();
                    if (zssFont.getTypeOffset() != SFont.TypeOffset.NONE) {
                        fontsize = (int)(0.7 * (double)fontsize + 0.5);
                    }
                    cellFont.setSize((float)fontsize);
                    if (zssFont.getBoldweight() == SFont.Boldweight.BOLD) {
                        if (zssFont.isItalic()) {
                            cellFont.setStyle(3);
                        } else {
                            cellFont.setStyle(1);
                        }
                    } else if (zssFont.isItalic()) {
                        cellFont.setStyle(2);
                    }
                    if (zssFont.isStrikeout()) {
                        cellFont.setStyle(8);
                    }
                    Chunk chunk = new Chunk(sg.getText(), cellFont);
                    if (zssFont.getTypeOffset() == SFont.TypeOffset.SUB) {
                        chunk.setTextRise(-5.0f);
                    } else if (zssFont.getTypeOffset() == SFont.TypeOffset.SUPER) {
                        chunk.setTextRise(5.0f);
                    }
                    if (!accountingUnder) {
                        switch (zssFont.getUnderline()) {
                            case SINGLE: {
                                chunk.setUnderline(0.6f, -0.6f);
                                break;
                            }
                            case DOUBLE: {
                                chunk.setUnderline(0.6f, -0.6f);
                                chunk.setUnderline(0.6f, -2.0f);
                                break;
                            }
                        }
                    }
                    p.add((Object)chunk);
                }
            } else {
                Font cellFont = this.getPdfCellFont(style);
                Chunk chunk = new Chunk(result.getText(), cellFont);
                if (styleFont.getTypeOffset() == SFont.TypeOffset.SUB) {
                    chunk.setTextRise(-5.0f);
                } else if (styleFont.getTypeOffset() == SFont.TypeOffset.SUPER) {
                    chunk.setTextRise(5.0f);
                }
                switch (styleFont.getUnderline()) {
                    case SINGLE: {
                        chunk.setUnderline(0.6f, -0.6f);
                        break;
                    }
                    case DOUBLE: {
                        chunk.setUnderline(0.6f, -0.6f);
                        chunk.setUnderline(0.6f, -2.0f);
                        break;
                    }
                }
                p = new Phrase(0.0f, chunk);
            }
        }
        return new Object[]{p, number};
    }

    private Font getPdfCellFont(SCellStyle style) {
        SFont zssFont = style.getFont();
        SColor fontColor = zssFont.getColor();
        Font cellFont = FontFactory.getFont((String)zssFont.getName(), (String)"Identity-H");
        Color fontBaseColor = null;
        if (fontColor != null) {
            String sColor = fontColor.getHtmlColor();
            fontBaseColor = WebColors.getRGBColor((String)(sColor == null || "AUTO_COLOR".equals(sColor) ? "BLACK" : sColor));
            cellFont.setColor(fontBaseColor);
        }
        int fontsize = zssFont.getHeightPoints();
        if (zssFont.getTypeOffset() != SFont.TypeOffset.NONE) {
            fontsize = (int)(0.7 * (double)fontsize + 0.5);
        }
        cellFont.setSize((float)fontsize);
        if (zssFont.isItalic()) {
            cellFont.setStyle(2);
        }
        if (zssFont.isStrikeout()) {
            cellFont.setStyle(8);
        }
        return cellFont;
    }

    private int searchNonBlankEndColumn(SSheet sheet, int rowIdx, int lastColIdx) {
        int last = -1;
        for (int i = lastColIdx; i >= 0; --i) {
            SCell cell = sheet.getCell(rowIdx, i);
            if (cell.isNull() || cell.getType() == SCell.CellType.BLANK) continue;
            last = i;
            break;
        }
        return last;
    }

    private void initSelectedPrintArea(SSheet sheet) {
        List charts;
        int colIdx;
        int rowIdx;
        int minRowIdx;
        int minC = this._firstCol;
        int maxC = this._endCol;
        int minR = this._firstRow;
        int maxR = this._endRow;
        if (this._firstRow > 0 && this._firstRow > (minRowIdx = sheet.getStartRowIndex())) {
            CellRegion mergedRegion;
            int colIdx2;
            rowIdx = this._firstRow;
            for (colIdx2 = this._firstCol; colIdx2 <= this._endCol; ++colIdx2) {
                mergedRegion = this.getMergedRegionIfAny(sheet, rowIdx, colIdx2);
                if (mergedRegion == null) continue;
                minC = Math.min(minC, mergedRegion.getColumn());
                maxC = Math.max(maxC, mergedRegion.getLastColumn());
                minR = Math.min(minR, mergedRegion.getRow());
            }
            rowIdx = this._endRow;
            for (colIdx2 = this._firstCol; colIdx2 <= this._endCol; ++colIdx2) {
                mergedRegion = this.getMergedRegionIfAny(sheet, rowIdx, colIdx2);
                if (mergedRegion == null) continue;
                minC = Math.min(minC, mergedRegion.getColumn());
                maxC = Math.max(maxC, mergedRegion.getLastColumn());
                maxR = Math.min(maxR, mergedRegion.getLastRow());
            }
        }
        if (this._firstCol > 0 && minC > 0) {
            colIdx = this._firstCol;
            for (rowIdx = this._firstRow; rowIdx <= this._endRow; ++rowIdx) {
                int col0;
                int col;
                SCell sCell;
                Iterator iter;
                CellRegion mergedRegion = this.getMergedRegionIfAny(sheet, rowIdx, colIdx);
                if (mergedRegion != null) {
                    minC = Math.min(minC, mergedRegion.getColumn());
                    maxC = Math.max(maxC, mergedRegion.getLastColumn());
                    if (minC != 0) continue;
                    break;
                }
                SRow row = sheet.getRow(rowIdx);
                if (row != null && !row.isNull() && (iter = ((AbstractRowAdv)row).getCellIterator(true, 0, colIdx - 1)).hasNext() && (sCell = (SCell)iter.next()).getType() != SCell.CellType.BLANK && (col = this.getExtendedEndColumn(sheet, sCell, col0 = sCell.getColumnIndex())) >= this._firstCol && col0 < minC && (minC = col0) == 0) break;
            }
        }
        colIdx = this._endCol;
        for (rowIdx = this._firstRow; rowIdx <= this._endRow; ++rowIdx) {
            int col;
            CellRegion mergedRegion = this.getMergedRegionIfAny(sheet, rowIdx, colIdx);
            if (mergedRegion != null) {
                maxC = Math.max(maxC, mergedRegion.getLastColumn());
                continue;
            }
            SCell sCell = sheet.getCell(rowIdx, colIdx);
            if (sCell == null || sCell.isNull() || sCell.getType() == SCell.CellType.BLANK || (col = this.getExtendedEndColumn(sheet, sCell, colIdx)) <= maxC) continue;
            maxC = col;
        }
        List pics = sheet.getPictures();
        if (pics != null && pics.size() != 0) {
            for (SPicture pic : pics) {
                ViewAnchor anchor1 = pic.getAnchor();
                ViewAnchor anchor2 = anchor1.getRightBottomAnchor(sheet);
                if (anchor2.getColumnIndex() < this._firstCol || anchor1.getColumnIndex() > this._endCol || anchor2.getRowIndex() < this._firstRow || anchor1.getRowIndex() > this._endRow) continue;
                minC = Math.min(minC, anchor1.getColumnIndex());
                minR = Math.min(minR, anchor1.getRowIndex());
                maxC = Math.max(maxC, anchor2.getColumnIndex());
                maxR = Math.max(maxR, anchor2.getRowIndex());
            }
        }
        if ((charts = sheet.getCharts()) != null && charts.size() != 0) {
            for (SChart chart : charts) {
                ViewAnchor anchor1 = chart.getAnchor();
                ViewAnchor anchor2 = anchor1.getRightBottomAnchor(sheet);
                if (anchor2.getColumnIndex() < this._firstCol || anchor1.getColumnIndex() > this._endCol || anchor2.getRowIndex() < this._firstRow || anchor1.getRowIndex() > this._endRow) continue;
                minC = Math.min(minC, anchor1.getColumnIndex());
                minR = Math.min(minR, anchor1.getRowIndex());
                maxC = Math.max(maxC, anchor2.getColumnIndex());
                maxR = Math.max(maxR, anchor2.getRowIndex());
            }
        }
        this._firstCol = minC;
        this._firstRow = minR;
        this._endCol = maxC;
        this._endRow = maxR;
    }

    private void initPrintArea(SSheet sheet, CellRegion region) {
        List charts;
        if (region != null) {
            this._printRow1 = this._firstRow = region.getRow();
            this._printRow2 = this._endRow = region.getLastRow();
            this._printCol1 = this._firstCol = region.getColumn();
            this._printCol2 = this._endCol = region.getLastColumn();
            this.initSelectedPrintArea(sheet);
            return;
        }
        this._firstCol = 0;
        this._endCol = -1;
        this._firstRow = 0;
        this._endRow = -1;
        Iterator rowIter = sheet.getRowIterator();
        while (rowIter.hasNext()) {
            SRow row = (SRow)rowIter.next();
            int rowIdx = row.getIndex();
            int lastCol = sheet.getEndCellIndex(rowIdx);
            if (lastCol < 0) continue;
            int lastNonBlankCol = this.searchNonBlankEndColumn(sheet, rowIdx, lastCol);
            CellRegion mergedRegion = this.getMergedRegionIfAny(sheet, rowIdx, lastNonBlankCol);
            if (mergedRegion != null) {
                int col = mergedRegion.getLastColumn();
                if (col > lastCol) {
                    lastCol = col;
                }
            } else {
                SCell zssCell = sheet.getCell(rowIdx, lastNonBlankCol);
                int col = this.getExtendedEndColumn(sheet, zssCell, lastNonBlankCol);
                if (col > lastCol) {
                    lastCol = col;
                }
            }
            this._endCol = Math.max(this._endCol, lastCol);
            this._endRow = Math.max(this._endRow, row.getIndex());
        }
        List pics = sheet.getPictures();
        if (pics != null && pics.size() != 0) {
            for (SPicture pic : pics) {
                ViewAnchor anchor1 = pic.getAnchor();
                ViewAnchor anchor2 = anchor1.getRightBottomAnchor(sheet);
                if (anchor2.getColumnIndex() > this._endCol) {
                    this._endCol = anchor2.getColumnIndex();
                }
                if (anchor2.getRowIndex() <= this._endRow) continue;
                this._endRow = anchor2.getRowIndex();
            }
        }
        if ((charts = sheet.getCharts()) != null && charts.size() != 0) {
            for (SChart chart : charts) {
                ViewAnchor anchor1 = chart.getAnchor();
                ViewAnchor anchor2 = anchor1.getRightBottomAnchor(sheet);
                if (anchor2.getColumnIndex() > this._endCol) {
                    this._endCol = anchor2.getColumnIndex();
                }
                if (anchor2.getRowIndex() <= this._endRow) continue;
                this._endRow = anchor2.getRowIndex();
            }
        }
        this._printRow1 = this._firstRow;
        this._printRow2 = this._endRow;
        this._printCol1 = this._firstCol;
        this._printCol2 = this._endCol;
    }

    private int getExtendedEndColumn(SSheet sheet, SCell zssCell, int colIdx) {
        SCellStyle style;
        SCell.CellType type = zssCell.getType();
        if ((type == SCell.CellType.STRING || type == SCell.CellType.FORMULA && zssCell.getFormulaResultType() == SCell.CellType.STRING) && !(style = zssCell.getCellStyle()).isWrapText()) {
            if (style.getAlignment() == SCellStyle.Alignment.LEFT || style.getAlignment() == SCellStyle.Alignment.GENERAL) {
                return this.getExtendedEndColumn0(sheet, zssCell, colIdx);
            }
            if (style.getAlignment() == SCellStyle.Alignment.CENTER_SELECTION) {
                return this.getAcrossSelectionColumn0(sheet, zssCell.getRowIndex(), colIdx);
            }
        }
        return colIdx;
    }

    private int getAcrossSelectionColumn0(SSheet sheet, int rowIdx, int colIdx) {
        int maxCol = this._wb.getMaxColumnIndex();
        for (int c = colIdx + 1; c <= maxCol; ++c) {
            SCellStyle style;
            SCell sCell = sheet.getCell(rowIdx, c);
            if (sCell != null && sCell.getType() == SCell.CellType.BLANK && (style = sCell.getCellStyle()) != null && style.getAlignment() == SCellStyle.Alignment.CENTER_SELECTION) continue;
            return c - 1;
        }
        return colIdx;
    }

    private int getExtendedEndColumn0(SSheet sheet, SCell zssCell, int colIdx) {
        Object[] results = this.createPhrase(zssCell);
        Phrase p = (Phrase)results[0];
        double stringWidth = PdfExporter.getStringWidth(p) + 1.5;
        double width = 0.0;
        int maxCol = this._wb.getMaxColumnIndex();
        for (int c = colIdx; c <= maxCol; ++c) {
            if (!((width += LayoutUnitConversionHelper.pxToPdfWidthPoints(sheet.getColumn(c).getWidth())) >= stringWidth)) continue;
            return c;
        }
        return colIdx;
    }

    static double getStringWidth(Phrase phrase) {
        double width = 0.0;
        for (Chunk chunk : phrase.getChunks()) {
            width += (double)chunk.getWidthPoint();
        }
        return width;
    }

    public SPrintSetup getPrintSetup() {
        if (this._printSetup == null) {
            this._printSetup = new PrintSetupImpl();
        }
        return this._printSetup;
    }

    private SPrintSetup getCurrentPrintSetup(SSheet sheet) {
        return this._printSetup == null ? sheet.getPrintSetup() : this._printSetup;
    }

    private SHeader getCurrentHeader(SSheet sheet) {
        SPrintSetup ps = this.getCurrentPrintSetup(sheet);
        if (this._firstPage && ps.isDifferentFirstPage()) {
            return ps.getFirstHeader();
        }
        if (this.isEvenPage(this._pageNumber) && ps.isDifferentOddEvenPage()) {
            return ps.getEvenHeader();
        }
        return ps.getHeader();
    }

    private SFooter getCurrentFooter(SSheet sheet) {
        SPrintSetup ps = this.getCurrentPrintSetup(sheet);
        if (this._firstPage && ps.isDifferentFirstPage()) {
            return ps.getFirstFooter();
        }
        if (this.isEvenPage(this._pageNumber) && ps.isDifferentOddEvenPage()) {
            return ps.getEvenFooter();
        }
        return ps.getFooter();
    }

    private boolean isEvenPage(int no) {
        return (no & 1) == 0;
    }

    private boolean isUseColTitles() {
        return this._titleCol1 >= 0 && this._titleCol2 >= this._titleCol1;
    }

    private boolean isUseRowTitles() {
        return this._titleRow1 >= 0 && this._titleRow2 >= this._titleRow1;
    }

    private int getCountOfColTitles() {
        return this.isUseColTitles() ? this._titleCol2 - this._titleCol1 + 1 : 0;
    }

    private double getTitleWidth() {
        return this.isUseColTitles() ? this._repeatColLeft[this._titleCol2 + 1 - this._titleCol1] - this._repeatColLeft[0] : 0.0;
    }

    private double getTitleHeight() {
        return this.isUseRowTitles() ? this._repeatRowTop[this._titleRow2 + 1 - this._titleRow1] - this._repeatRowTop[0] : 0.0;
    }

    static SCellStyle.Alignment getRealAlignment(SCell cell) {
        if (cell == null) {
            return SCellStyle.Alignment.CENTER;
        }
        SCellStyle style = cell.getCellStyle();
        SCell.CellType type = cell.getType();
        SCellStyle.Alignment align = style.getAlignment();
        if (align == SCellStyle.Alignment.GENERAL) {
            String format = style.getDataFormat();
            if (format != null && format.startsWith("@")) {
                type = SCell.CellType.STRING;
            } else if (type == SCell.CellType.FORMULA) {
                type = cell.getFormulaResultType();
            }
            switch (type) {
                case BLANK: {
                    return align;
                }
                case BOOLEAN: {
                    return SCellStyle.Alignment.CENTER;
                }
                case ERROR: {
                    return SCellStyle.Alignment.CENTER;
                }
                case NUMBER: {
                    return SCellStyle.Alignment.RIGHT;
                }
            }
            return SCellStyle.Alignment.LEFT;
        }
        return align;
    }

    static SCellStyle.VerticalAlignment getRealVerticalAlignment(SCell cell) {
        if (cell == null) {
            return SCellStyle.VerticalAlignment.BOTTOM;
        }
        SCellStyle style = cell.getCellStyle();
        SCellStyle.VerticalAlignment align = style.getVerticalAlignment();
        if (align == SCellStyle.VerticalAlignment.JUSTIFY) {
            return SCellStyle.VerticalAlignment.TOP;
        }
        return align;
    }

    class PdfHeaderFooter
    extends PdfPageEventHelper {
        PdfHeaderFooter() {
        }

        public void onOpenDocument(PdfWriter pdfWriter, Document doc) {
        }

        public void onStartPage(PdfWriter pdfWriter, Document doc) {
            PdfExporter.this._pageNumber++;
        }

        private PdfPCell createHeaderFooterCell(String rawText, int alignment, int valign) {
            Phrase phrase = this.createHeaderFooterPhrase(rawText);
            PdfPCell cell = new PdfPCell(phrase);
            cell.setPaddingLeft(1.5f);
            cell.setHorizontalAlignment(alignment);
            cell.setVerticalAlignment(valign);
            cell.setBorder(0);
            return cell;
        }

        private String[] getFontInfo(String rawText, int start, int[] index) {
            StringBuilder sb = new StringBuilder();
            String fontName = "-";
            String fontStyle = "Regular";
            int len = rawText.length();
            for (int j = start + 1; j < len; ++j) {
                char ch = rawText.charAt(j);
                if (ch == ',') {
                    fontName = sb.toString();
                    sb = new StringBuilder();
                } else if (ch == '\"') {
                    fontStyle = sb.toString();
                    index[0] = j;
                }
                sb.append(ch);
            }
            return new String[]{fontName, fontStyle};
        }

        private Color getFontColor(String rawText, int start, int[] index) {
            boolean isTheme;
            char ch3th = rawText.charAt(start + 3);
            boolean bl = isTheme = ch3th == '-' || ch3th == '+';
            if (isTheme) {
                index[0] = start + 5;
                return null;
            }
            StringBuilder rgbsb = new StringBuilder();
            rgbsb.append('#');
            int len = start + 7;
            for (int j = start + 1; j < len; ++j) {
                char ch = rawText.charAt(j);
                rgbsb.append(ch);
            }
            index[0] = start + 6;
            return WebColors.getRGBColor((String)rgbsb.toString());
        }

        private int getFontSize(String rawText, int start, int[] index) {
            StringBuilder numsb = new StringBuilder();
            int len = rawText.length();
            for (int j = start; j < len; ++j) {
                char ch = rawText.charAt(j);
                if ('0' <= ch && ch <= '9') {
                    numsb.append(ch);
                }
                index[0] = j - 1;
            }
            return Integer.parseInt(numsb.toString());
        }

        private Phrase createHeaderFooterPhrase(String rawText) {
            if (rawText == null) {
                return new Phrase(rawText, PdfExporter.this._docStandardFont);
            }
            Phrase p = new Phrase();
            boolean strikeout = false;
            boolean underline = false;
            boolean doubleline = false;
            boolean superscript = false;
            boolean subscript = false;
            boolean outline = false;
            boolean shadow = false;
            boolean bold = false;
            boolean italic = false;
            String defaultFontName = PdfExporter.this._docStandardFont.getFamilyname();
            float defaultFontSize = PdfExporter.this._docStandardFont.getSize();
            Color defaultFontColor = PdfExporter.this._docStandardFont.getColor();
            String fontName = defaultFontName;
            float fontSize = defaultFontSize;
            Color fontColor = defaultFontColor;
            Date now = new Date();
            Locale locale = ZssContext.getCurrent().getLocale();
            DateFormat df = DateFormat.getDateInstance(3, locale);
            String date = df.format(now);
            DateFormat tf = DateFormat.getTimeInstance(1, locale);
            String time = tf.format(now);
            boolean endOfChunk = false;
            StringBuilder sb = new StringBuilder();
            int[] index = new int[1];
            int len = rawText.length();
            for (int j = 0; j < len; ++j) {
                char ch = rawText.charAt(j);
                if (ch == '&') {
                    ch = rawText.charAt(++j);
                    switch (ch) {
                        case 'U': {
                            if (sb.length() > 0) {
                                j -= 2;
                                endOfChunk = true;
                                break;
                            }
                            underline = !underline;
                            break;
                        }
                        case 'S': {
                            if (sb.length() > 0) {
                                j -= 2;
                                endOfChunk = true;
                                break;
                            }
                            strikeout = !strikeout;
                            break;
                        }
                        case 'X': {
                            if (sb.length() > 0) {
                                j -= 2;
                                endOfChunk = true;
                                break;
                            }
                            superscript = !superscript;
                            break;
                        }
                        case 'E': {
                            if (sb.length() > 0) {
                                j -= 2;
                                endOfChunk = true;
                                break;
                            }
                            doubleline = !doubleline;
                            break;
                        }
                        case 'Y': {
                            if (sb.length() > 0) {
                                j -= 2;
                                endOfChunk = true;
                                break;
                            }
                            subscript = !subscript;
                            break;
                        }
                        case 'B': {
                            if (sb.length() > 0) {
                                j -= 2;
                                endOfChunk = true;
                                break;
                            }
                            bold = !bold;
                            break;
                        }
                        case 'I': {
                            if (sb.length() > 0) {
                                j -= 2;
                                endOfChunk = true;
                                break;
                            }
                            italic = !italic;
                            break;
                        }
                        case 'O': {
                            if (sb.length() > 0) {
                                j -= 2;
                                endOfChunk = true;
                                break;
                            }
                            outline = !outline;
                            break;
                        }
                        case 'H': {
                            if (sb.length() > 0) {
                                j -= 2;
                                endOfChunk = true;
                                break;
                            }
                            shadow = !shadow;
                            break;
                        }
                        case '\"': {
                            if (sb.length() > 0) {
                                j -= 2;
                                endOfChunk = true;
                                break;
                            }
                            String[] fontInfo = this.getFontInfo(rawText, j, index);
                            String nm = fontInfo[0];
                            String style = fontInfo[1];
                            String string = fontName = nm == "-" ? defaultFontName : nm;
                            if ("Bold".equalsIgnoreCase(style)) {
                                bold = true;
                                break;
                            }
                            if ("Italic".equalsIgnoreCase(style)) {
                                italic = true;
                                break;
                            }
                            if ("Bold Italic".equalsIgnoreCase(style)) {
                                italic = true;
                                bold = true;
                                break;
                            }
                            if ("Italic Bold".equalsIgnoreCase(style)) {
                                italic = true;
                                bold = true;
                                break;
                            }
                            italic = false;
                            bold = false;
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (sb.length() > 0) {
                                j -= 2;
                                endOfChunk = true;
                                break;
                            }
                            fontSize = this.getFontSize(rawText, j, index);
                            j = index[0];
                            break;
                        }
                        case 'K': {
                            if (sb.length() > 0) {
                                j -= 2;
                                endOfChunk = true;
                                break;
                            }
                            fontColor = this.getFontColor(rawText, j, index);
                            if (fontColor == null) {
                                fontColor = defaultFontColor;
                            }
                            j = index[0];
                            break;
                        }
                        case 'P': {
                            sb.append(PdfExporter.this._pageNumber);
                            break;
                        }
                        case 'N': {
                            sb.append(PdfExporter.this._pageCount);
                            break;
                        }
                        case 'D': {
                            sb.append(date);
                            break;
                        }
                        case 'T': {
                            sb.append(time);
                            break;
                        }
                        case 'Z': {
                            sb.append(PdfExporter.this._bookName);
                            break;
                        }
                        case 'F': {
                            sb.append(PdfExporter.this._bookName);
                            break;
                        }
                        case 'A': {
                            sb.append(PdfExporter.this._sheetName);
                            break;
                        }
                        case 'G': {
                            break;
                        }
                        case '&': {
                            sb.append(ch);
                            break;
                        }
                    }
                } else {
                    sb.append(ch);
                }
                if (!endOfChunk) continue;
                Font cellFont = FontFactory.getFont((String)fontName, (String)"Identity-H");
                cellFont.setColor(fontColor);
                int fontsize = (int)fontSize;
                if (superscript || subscript) {
                    fontsize = (int)(0.7 * (double)fontsize + 0.5);
                }
                cellFont.setSize((float)fontsize);
                if (bold) {
                    if (italic) {
                        cellFont.setStyle(3);
                    } else {
                        cellFont.setStyle(1);
                    }
                } else if (italic) {
                    cellFont.setStyle(2);
                }
                if (strikeout) {
                    cellFont.setStyle(8);
                }
                Chunk chunk = new Chunk(sb.toString(), cellFont);
                if (subscript) {
                    chunk.setTextRise(-5.0f);
                } else if (superscript) {
                    chunk.setTextRise(5.0f);
                }
                if (doubleline) {
                    chunk.setUnderline(0.6f, -0.6f);
                    chunk.setUnderline(0.6f, -2.0f);
                } else if (underline) {
                    chunk.setUnderline(0.6f, -0.6f);
                }
                p.add((Object)chunk);
                sb = new StringBuilder();
                endOfChunk = false;
            }
            if (sb.length() > 0) {
                Font cellFont = FontFactory.getFont((String)fontName, (String)"Identity-H");
                cellFont.setColor(fontColor);
                int fontsize = (int)fontSize;
                if (superscript || subscript) {
                    fontsize = (int)(0.7 * (double)fontsize + 0.5);
                }
                cellFont.setSize((float)fontsize);
                if (bold) {
                    if (italic) {
                        cellFont.setStyle(3);
                    } else {
                        cellFont.setStyle(1);
                    }
                } else if (italic) {
                    cellFont.setStyle(2);
                }
                if (strikeout) {
                    cellFont.setStyle(8);
                }
                Chunk chunk = new Chunk(sb.toString(), cellFont);
                if (subscript) {
                    chunk.setTextRise(-5.0f);
                } else if (superscript) {
                    chunk.setTextRise(5.0f);
                }
                if (doubleline) {
                    chunk.setUnderline(0.6f, -0.6f);
                    chunk.setUnderline(0.6f, -2.0f);
                } else if (underline) {
                    chunk.setUnderline(0.6f, -0.6f);
                }
                p.add((Object)chunk);
            }
            return p;
        }

        private PdfPTable createHeaderFooter(int alignment) throws IOException {
            PdfPTable table = new PdfPTable(3);
            float width = (float)(PdfExporter.this._totalHeaderFooterWidth / 3.0);
            float[] widths = new float[]{width, width, width};
            try {
                table.setWidths(widths);
                table.setLockedWidth(true);
                table.setTotalWidth(widths);
                table.setHorizontalAlignment(alignment);
            }
            catch (DocumentException e) {
                throw new IOException(e);
            }
            return table;
        }

        public void onEndPage(PdfWriter writer, Document doc) {
            try {
                this.doEndPage(writer, doc);
            }
            catch (IOException e) {
                throw new ExceptionConverter((Exception)e);
            }
        }

        private void doEndPage(PdfWriter writer, Document doc) throws IOException {
            SFooter footer;
            PdfContentByte canvas = writer.getDirectContent();
            SHeader header = PdfExporter.this.getCurrentHeader(PdfExporter.this._currentSheet);
            if (header != null) {
                PdfPTable pheader = this.createHeaderFooter(1);
                pheader.addCell(this.createHeaderFooterCell(header.getLeftText(), 0, 4));
                pheader.addCell(this.createHeaderFooterCell(header.getCenterText(), 1, 4));
                pheader.addCell(this.createHeaderFooterCell(header.getRightText(), 2, 4));
                float topPosition = (float)(PdfExporter.this._bottomMargin + PdfExporter.this._totalPrintHeight + (PdfExporter.this._topMargin - PdfExporter.this._headerMargin));
                pheader.writeSelectedRows(0, -1, (float)PdfExporter.this._leftMargin, topPosition, canvas);
            }
            if ((footer = PdfExporter.this.getCurrentFooter(PdfExporter.this._currentSheet)) != null) {
                PdfPTable pfooter = this.createHeaderFooter(1);
                pfooter.addCell(this.createHeaderFooterCell(footer.getLeftText(), 0, 6));
                pfooter.addCell(this.createHeaderFooterCell(footer.getCenterText(), 1, 6));
                pfooter.addCell(this.createHeaderFooterCell(footer.getRightText(), 2, 6));
                float bottomPosition = (float)(PdfExporter.this._footerMargin + (double)pfooter.getTotalHeight());
                pfooter.writeSelectedRows(0, -1, (float)PdfExporter.this._leftMargin, bottomPosition, canvas);
            }
            if (PdfExporter.this._firstPage) {
                PdfExporter.this._firstPage = false;
            }
            if (PdfExporter.this._scale == 100) {
                PdfExporter.this.layoverPictureIfAny(PdfExporter.this._wb.getSheet(PdfExporter.this._currentSheetIndex), PdfExporter.this._pageRow1, PdfExporter.this._pageRow2, PdfExporter.this._pageCol1, PdfExporter.this._pageCol2, writer);
                PdfExporter.this.layoutCharts(PdfExporter.this._wb.getSheet(PdfExporter.this._currentSheetIndex), PdfExporter.this._pageRow1, PdfExporter.this._pageRow2, PdfExporter.this._pageCol1, PdfExporter.this._pageCol2, writer);
            }
        }
    }
}

