/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.pdf;

class LayoutUnitConversionHelper {
    LayoutUnitConversionHelper() {
    }

    public static int pxToTwip(int px) {
        return px * 72 * 20 / 96;
    }

    public static int twipToPx(int twip) {
        return twip * 96 / 72 / 20;
    }

    public static int fileChar256ToPx(int char256, int charWidth) {
        double w = char256;
        return (int)Math.floor(w * (double)charWidth / 256.0 + 0.5);
    }

    public static int pxToFileChar256(int px, int charWidth) {
        double w = px;
        return (int)Math.floor(w * 256.0 / (double)charWidth + 0.5);
    }

    public static double pxToPdfHeightPoints(int px) {
        double w = px;
        return w * 0.725;
    }

    public static double pxToPdfWidthPoints(int px) {
        double w = px;
        return w * 0.805;
    }

    public static double twippxToPdfPoints(int px, int pdfCharWidth) {
        double w = px;
        return w * (double)pdfCharWidth / 72.0;
    }

    public static double fileChar256ToPdfPoints(int char256, int charWidth, int pdfCharWidth) {
        return LayoutUnitConversionHelper.pxToPdfWidthPoints(LayoutUnitConversionHelper.fileChar256ToPx(char256, charWidth));
    }

    public static double twipsToPdfPoints(int twip, int pdfCharWidth) {
        return LayoutUnitConversionHelper.twippxToPdfPoints(LayoutUnitConversionHelper.twipToPx(twip), pdfCharWidth);
    }
}

