/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Utilities;
import com.lowagie.text.html.WebColors;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;
import org.zkoss.lang.Library;
import org.zkoss.poi.ss.usermodel.ZssContext;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SChart;
import org.zkoss.zss.model.SColor;
import org.zkoss.zss.model.SFont;
import org.zkoss.zss.model.SFooter;
import org.zkoss.zss.model.SHeader;
import org.zkoss.zss.model.SPicture;
import org.zkoss.zss.model.SPrintSetup;
import org.zkoss.zss.model.SRichText;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.ViewAnchor;
import org.zkoss.zss.model.impl.pdf.BorderDrawEvent;
import org.zkoss.zss.model.impl.pdf.FontLoader;
import org.zkoss.zss.model.impl.pdf.LayoutUnitConversionHelper;
import org.zkoss.zss.model.impl.pdf.PageSizeConversionUtil;
import org.zkoss.zss.model.impl.pdf.StyleConversionUtil;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.format.FormatContext;
import org.zkoss.zss.model.sys.format.FormatEngine;
import org.zkoss.zss.model.sys.format.FormatResult;
import org.zkoss.zss.range.SExporter;
import org.zkoss.zss.range.impl.imexp.PoiEnumConversion;
import org.zkoss.zss.range.impl.imexp.UnitUtil;
import org.zkoss.zssex.util.ChartHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfExporter
implements SExporter,
Serializable {
    private static int DEFAULT_EXCEL_CHARWIDTH = 7;
    private static int DEFAULT_PDF_CHARWIDTH = 58;
    private SBook wb;
    private Document document;
    private PdfWriter writer;
    private int[] colBreaks;
    private int[] rowBreaks;
    private int firstColumn;
    private int endColumn;
    private int endRow;
    private int pageCount = 1;
    private int pageNumber;
    private Font documentStandardFont;
    private boolean printGridLines = false;
    private boolean printHeadings;
    private Rectangle pgSize;
    private float headerFooterTotalWidth;
    private float leftMargin;
    private float rightMargin;
    private float topMargin;
    private float bottomMargin;
    private float headerMargin;
    private float footerMargin;
    private SHeader header;
    private SFooter footer;
    private Map<Integer, Map<String, int[]>> sheetsWithRepeatingRowsAndColumns = new HashMap<Integer, Map<String, int[]>>();
    private float totalAvailablePageWidth;
    private float totalAvailablePageHeight;
    private float[] columnLeft;
    private float[] rowTop;
    private Map<String, Integer> lastPageRowColumnBounds;
    private int currentStartColumn = 0;
    private int currentEndColumn = 0;
    private int currentStartRow = 0;
    private int currentEndRow = 0;
    private int currentSheetIndex = 0;
    List<SPicture> pictures;
    private FontLoader fontLoader = FontLoader.getInstance();
    private String _refSheetName;
    static final String IGNORE_COLUMN_BREAK_PROPERTY_KEY = "org.zkoss.zss.pdf.ignoreColumnBreak";
    static final String IGNORE_ROW_BREAK_PROPERTY_KEY = "org.zkoss.zss.pdf.ignoreRowBreak";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(SBook book, File file) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            this.export(book, (OutputStream)os);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
    }

    public void export(SBook workbook, OutputStream outputStream) throws IOException {
        try {
            this.wb = workbook;
            this.setupExporter(this.wb.getSheet(0), outputStream);
            this.document.open();
            int numSheets = workbook.getNumOfSheet();
            for (int i = 0; i < numSheets; ++i) {
                this.currentSheetIndex = i;
                this.exportSheet(workbook.getSheet(i), i);
            }
            this.document.close();
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void export(SSheet worksheet, OutputStream outputStream) throws IOException {
        try {
            this.wb = worksheet.getBook();
            this.setupExporter(worksheet, outputStream);
            this.document.open();
            this.currentSheetIndex = this.wb.getSheetIndex(worksheet);
            this.exportSheet(worksheet, this.currentSheetIndex);
            this.document.close();
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void export(SheetRegion sheetRegion, OutputStream outputStream) throws IOException {
        try {
            SSheet worksheet = sheetRegion.getSheet();
            CellRegion area = sheetRegion.getRegion();
            this.wb = worksheet.getBook();
            this.setupExporter(worksheet, outputStream);
            this.document.open();
            this.currentSheetIndex = this.wb.getSheetIndex(worksheet);
            this.exportSheetSelection(worksheet, this.currentSheetIndex, area);
            this.document.close();
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void setupExporter(SSheet sheet, OutputStream outputStream) throws DocumentException {
        this.document = new Document();
        this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)outputStream);
        this.setDocumentPageProperties(sheet);
        PdfHeaderFooter phf = new PdfHeaderFooter();
        this.writer.setBoxSize("art", this.pgSize);
        this.writer.setPageEvent((PdfPageEvent)phf);
    }

    private void exportSheetSelection(SSheet sheet, int sheetIndex, CellRegion area) throws DocumentException {
        this.header = sheet.getViewInfo().getHeader();
        this.footer = sheet.getViewInfo().getFooter();
        this.initSheetRowColumnBounds(sheet);
        this.setRowColumnBreaks(sheet);
        this.getPictureData(sheet);
        this.printSelectedColumns(sheet, sheetIndex, area.getColumn(), area.getLastColumn(), area);
        this.document.newPage();
    }

    private void exportSheet(SSheet sheet, int sheetIndex) throws DocumentException {
        this.header = sheet.getViewInfo().getHeader();
        this.footer = sheet.getViewInfo().getFooter();
        this.initSheetRowColumnBounds(sheet);
        this.setRowColumnBreaks(sheet);
        this.getPictureData(sheet);
        int leftColumnBound = this.firstColumn;
        for (int i = 0; i < this.colBreaks.length; ++i) {
            this.printColumns(sheet, sheetIndex, leftColumnBound, this.colBreaks[i]);
            leftColumnBound = this.colBreaks[i] + 1;
        }
        if (leftColumnBound <= this.endColumn) {
            this.printColumns(sheet, sheetIndex, leftColumnBound, this.endColumn);
        }
        this.document.newPage();
    }

    private void getPictureData(SSheet sheet) {
        this.pictures = sheet.getPictures();
    }

    private void setRowColumnBreaks(SSheet sheet) {
        this.rowBreaks = "true".equalsIgnoreCase(Library.getProperty((String)IGNORE_ROW_BREAK_PROPERTY_KEY)) ? new int[0] : sheet.getViewInfo().getRowBreaks();
        this.colBreaks = "true".equalsIgnoreCase(Library.getProperty((String)IGNORE_COLUMN_BREAK_PROPERTY_KEY)) ? new int[0] : sheet.getViewInfo().getColumnBreaks();
        if (this.colBreaks != null && this.colBreaks.length == 0) {
            this.setAutoColumnBreaks(sheet);
        }
        if (this.rowBreaks != null && this.rowBreaks.length == 0) {
            this.setAutoRowBreaks(sheet);
        }
    }

    private void setAutoRowBreaks(SSheet sheet) {
        float currentPageHeight = 0.0f;
        float defaultRowHeight = LayoutUnitConversionHelper.pxToPdfPoints(sheet.getDefaultRowHeight(), DEFAULT_PDF_CHARWIDTH);
        if (this.printHeadings) {
            currentPageHeight = defaultRowHeight;
        }
        ArrayList<Integer> autoRowBreaks = new ArrayList<Integer>();
        this.rowTop = new float[this.endRow + 1];
        for (int i = 0; i <= this.endRow; ++i) {
            SRow currentRow = sheet.getRow(i);
            this.rowTop[i] = currentPageHeight;
            currentPageHeight = currentRow != null ? (currentPageHeight += (float)LayoutUnitConversionHelper.pxToPdfPoints(currentRow.getHeight(), DEFAULT_PDF_CHARWIDTH)) : (currentPageHeight += defaultRowHeight);
            if (!(currentPageHeight >= this.totalAvailablePageHeight)) continue;
            autoRowBreaks.add(i - 1);
            float f = currentPageHeight = currentRow != null ? (float)LayoutUnitConversionHelper.pxToPdfPoints(currentRow.getHeight(), DEFAULT_PDF_CHARWIDTH) : defaultRowHeight;
            if (!this.printHeadings) continue;
            currentPageHeight += defaultRowHeight;
        }
        if (autoRowBreaks.size() > 0) {
            this.rowBreaks = PdfExporter.convertIntegers(autoRowBreaks);
        }
    }

    private void setAutoColumnBreaks(SSheet sheet) {
        float currentPageWidth = 0.0f;
        if (this.printHeadings) {
            currentPageWidth = StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH;
        }
        ArrayList<Integer> autoColumnBreaks = new ArrayList<Integer>();
        this.columnLeft = new float[this.endColumn + 1];
        for (int i = this.firstColumn; i <= this.endColumn; ++i) {
            this.columnLeft[i] = currentPageWidth;
            if (!((currentPageWidth += (float)LayoutUnitConversionHelper.pxToPdfPoints(sheet.getColumn(i).getWidth(), DEFAULT_PDF_CHARWIDTH)) >= this.totalAvailablePageWidth)) continue;
            autoColumnBreaks.add(i - 1);
            currentPageWidth = this.printHeadings ? StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH + (float)LayoutUnitConversionHelper.pxToPdfPoints(sheet.getColumn(i).getWidth(), DEFAULT_PDF_CHARWIDTH) : 0.0f;
        }
        if (autoColumnBreaks.size() > 0) {
            this.colBreaks = PdfExporter.convertIntegers(autoColumnBreaks);
        }
    }

    private static int[] convertIntegers(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = integers.get(i);
        }
        return ret;
    }

    private void setDocumentPageProperties(SSheet sheet) {
        SFont defFont = sheet.getBook().getDefaultFont();
        this.documentStandardFont = FontFactory.getFont((String)defFont.getName(), (String)"Identity-H");
        this.documentStandardFont.setSize(11.0f);
        this.documentStandardFont.setStyle(0);
        this.leftMargin = Utilities.inchesToPoints((float)((float)UnitUtil.pxToInche((int)sheet.getPrintSetup().getLeftMargin())));
        this.rightMargin = Utilities.inchesToPoints((float)((float)UnitUtil.pxToInche((int)sheet.getPrintSetup().getRightMargin())));
        this.topMargin = Utilities.inchesToPoints((float)((float)UnitUtil.pxToInche((int)sheet.getPrintSetup().getTopMargin())));
        this.bottomMargin = Utilities.inchesToPoints((float)((float)UnitUtil.pxToInche((int)sheet.getPrintSetup().getBottomMargin())));
        this.pgSize = PageSizeConversionUtil.getPageSize(PoiEnumConversion.toPoiPaperSize((SPrintSetup.PaperSize)sheet.getPrintSetup().getPaperSize()));
        if (sheet.getPrintSetup().isLandscape()) {
            Rectangle r;
            this.pgSize = r = this.pgSize.rotate();
            this.document.setPageSize(r);
            this.headerFooterTotalWidth = r.getWidth() - (this.topMargin + this.bottomMargin);
        } else {
            this.document.setPageSize(this.pgSize);
            this.headerFooterTotalWidth = this.pgSize.getWidth() - (this.leftMargin + this.rightMargin);
        }
        this.totalAvailablePageWidth = this.pgSize.getRight() - this.rightMargin - (this.pgSize.getLeft() + this.leftMargin);
        this.totalAvailablePageHeight = this.pgSize.getTop() - this.topMargin - (this.pgSize.getBottom() + this.bottomMargin);
        this.headerMargin = UnitUtil.pxToPoint((int)sheet.getPrintSetup().getHeaderMargin());
        this.footerMargin = UnitUtil.pxToPoint((int)sheet.getPrintSetup().getFooterMargin());
        this.document.setMargins(this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    private void printSelectedColumns(SSheet sheet, int sheetIndex, int leftColumnBound, int rightColumnBound, CellRegion area) throws DocumentException {
        Map<String, int[]> currentSheetRepeatingRowsAndColumns = this.sheetsWithRepeatingRowsAndColumns.get(sheetIndex);
        int[] repeatingColumns = new int[]{-1, -1};
        boolean columnsOverlapRepeatingColumns = false;
        if (currentSheetRepeatingRowsAndColumns != null) {
            repeatingColumns = currentSheetRepeatingRowsAndColumns.get("Columns");
            if (leftColumnBound > repeatingColumns[0] && leftColumnBound <= repeatingColumns[1] + 1) {
                leftColumnBound = repeatingColumns[0];
                columnsOverlapRepeatingColumns = true;
            }
            if (rightColumnBound < repeatingColumns[1] && rightColumnBound >= repeatingColumns[0]) {
                rightColumnBound = repeatingColumns[1];
                columnsOverlapRepeatingColumns = true;
            } else if (rightColumnBound >= repeatingColumns[1] && leftColumnBound <= repeatingColumns[1]) {
                columnsOverlapRepeatingColumns = true;
            }
        }
        this.document.newPage();
        this.lastPageRowColumnBounds = new HashMap<String, Integer>(4);
        this.lastPageRowColumnBounds.put("rowTop", area.getRow());
        this.lastPageRowColumnBounds.put("rowBottom", area.getLastRow());
        this.lastPageRowColumnBounds.put("columnLeft", leftColumnBound);
        this.lastPageRowColumnBounds.put("columnRight", rightColumnBound);
        ++this.pageCount;
        if (columnsOverlapRepeatingColumns) {
            this.printRowsWithOverlappingRepeatingColumns(sheet, sheetIndex, area.getRow(), area.getLastRow(), leftColumnBound, rightColumnBound);
        } else {
            this.printRowsWithNonOverlappingRepeatingColumns(sheet, sheetIndex, area.getRow(), area.getLastRow(), leftColumnBound, rightColumnBound, repeatingColumns[0], repeatingColumns[1]);
        }
    }

    private void printColumns(SSheet sheet, int sheetIndex, int leftColumnBound, int rightColumnBound) throws DocumentException {
        this.currentStartColumn = leftColumnBound;
        this.currentEndColumn = rightColumnBound;
        int topRowBound = 0;
        Map<String, int[]> currentSheetRepeatingRowsAndColumns = this.sheetsWithRepeatingRowsAndColumns.get(sheetIndex);
        int[] repeatingColumns = new int[]{-1, -1};
        boolean columnsOverlapRepeatingColumns = false;
        if (currentSheetRepeatingRowsAndColumns != null) {
            repeatingColumns = currentSheetRepeatingRowsAndColumns.get("Columns");
            if (leftColumnBound > repeatingColumns[0] && leftColumnBound <= repeatingColumns[1] + 1) {
                leftColumnBound = repeatingColumns[0];
                columnsOverlapRepeatingColumns = true;
            }
            if (rightColumnBound < repeatingColumns[1] && rightColumnBound >= repeatingColumns[0]) {
                rightColumnBound = repeatingColumns[1];
                columnsOverlapRepeatingColumns = true;
            } else if (rightColumnBound >= repeatingColumns[1] && leftColumnBound <= repeatingColumns[1]) {
                columnsOverlapRepeatingColumns = true;
            }
        }
        for (int i = 0; i < this.rowBreaks.length; ++i) {
            this.document.newPage();
            this.currentStartRow = topRowBound;
            this.currentEndRow = this.rowBreaks[i];
            this.lastPageRowColumnBounds = new HashMap<String, Integer>(4);
            this.lastPageRowColumnBounds.put("rowTop", topRowBound);
            this.lastPageRowColumnBounds.put("rowBottom", this.rowBreaks[i]);
            this.lastPageRowColumnBounds.put("columnLeft", leftColumnBound);
            this.lastPageRowColumnBounds.put("columnRight", rightColumnBound);
            ++this.pageCount;
            if (columnsOverlapRepeatingColumns) {
                this.printRowsWithOverlappingRepeatingColumns(sheet, sheetIndex, topRowBound, this.rowBreaks[i], leftColumnBound, rightColumnBound);
            } else {
                this.printRowsWithNonOverlappingRepeatingColumns(sheet, sheetIndex, topRowBound, this.rowBreaks[i], leftColumnBound, rightColumnBound, repeatingColumns[0], repeatingColumns[1]);
            }
            topRowBound = this.rowBreaks[i] + 1;
        }
        if (topRowBound <= this.endRow) {
            ++this.pageCount;
            this.document.newPage();
            this.currentStartRow = topRowBound;
            this.currentEndRow = sheet.getEndRowIndex();
            this.lastPageRowColumnBounds = new HashMap<String, Integer>(4);
            this.lastPageRowColumnBounds.put("rowTop", topRowBound);
            this.lastPageRowColumnBounds.put("rowBottom", sheet.getEndRowIndex());
            this.lastPageRowColumnBounds.put("columnLeft", leftColumnBound);
            this.lastPageRowColumnBounds.put("columnRight", rightColumnBound);
            if (columnsOverlapRepeatingColumns) {
                this.printRowsWithOverlappingRepeatingColumns(sheet, sheetIndex, topRowBound, this.endRow, leftColumnBound, rightColumnBound);
            } else {
                this.printRowsWithNonOverlappingRepeatingColumns(sheet, sheetIndex, topRowBound, this.endRow, leftColumnBound, rightColumnBound, repeatingColumns[0], repeatingColumns[1]);
            }
        }
    }

    private void printRowsWithNonOverlappingRepeatingColumns(SSheet sheet, int sheetIndex, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound, int repeatingColumnStart, int repeatingColumnEnd) throws DocumentException {
        Map<String, int[]> currentSheetRepeatingRowsAndColumns = this.sheetsWithRepeatingRowsAndColumns.get(sheetIndex);
        int[] repeatingRows = new int[]{-1, -1};
        boolean rowsOverlapRepeatingRows = false;
        if (currentSheetRepeatingRowsAndColumns != null) {
            repeatingRows = currentSheetRepeatingRowsAndColumns.get("Rows");
            if (topRowBound > repeatingRows[0] && topRowBound <= repeatingRows[1] + 1) {
                topRowBound = repeatingRows[0];
                rowsOverlapRepeatingRows = true;
            }
            if (bottomRowBound < repeatingRows[1] && bottomRowBound >= repeatingRows[0]) {
                bottomRowBound = repeatingRows[1];
                rowsOverlapRepeatingRows = true;
            } else if (bottomRowBound >= repeatingRows[1] && topRowBound <= repeatingRows[1]) {
                rowsOverlapRepeatingRows = true;
            }
        }
        int numOfColumns = rightColumnBound - leftColumnBound == 0 ? 1 : rightColumnBound - leftColumnBound + 1;
        int numOfRepeatingColumns = 0;
        if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
            numOfRepeatingColumns = repeatingColumnEnd - repeatingColumnStart == 0 ? 1 : repeatingColumnEnd - repeatingColumnStart + 1;
        }
        PdfPTable table = this.createPdfTableWithNonOverlappingColumns(numOfColumns + numOfRepeatingColumns, sheet, leftColumnBound, rightColumnBound, repeatingColumnStart, repeatingColumnEnd);
        if (rowsOverlapRepeatingRows) {
            this.printOverlappingRowsWithNonOverlappingRepeatingColumns(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, repeatingColumnStart, repeatingColumnEnd, table);
        } else {
            this.printNonOverlappingRowsWithNonOverlappingRepeatingColumns(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, repeatingColumnStart, repeatingColumnEnd, table, repeatingRows[0], repeatingRows[1]);
        }
        table.setHorizontalAlignment(0);
        this.document.add((Element)table);
    }

    private void printNonOverlappingRowsWithNonOverlappingRepeatingColumns(SSheet sheet, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound, int repeatingColumnStart, int repeatingColumnEnd, PdfPTable table, int repeatingRowsStart, int repeatingRowsEnd) {
        float rowHeight;
        SRow currentRow;
        int rowIndex;
        if (repeatingRowsStart != -1 && repeatingRowsEnd != -1) {
            for (rowIndex = repeatingRowsStart; rowIndex <= repeatingRowsEnd; ++rowIndex) {
                currentRow = sheet.getRow(rowIndex);
                if (this.printHeadings) {
                    PdfPCell cell = new PdfPCell(new Phrase("" + (rowIndex + 1), this.documentStandardFont));
                    cell.setBorderWidth(0.7f);
                    cell.setVerticalAlignment(6);
                    cell.setHorizontalAlignment(1);
                    table.addCell(cell);
                }
                if (currentRow != null) {
                    rowHeight = LayoutUnitConversionHelper.pxToPdfPoints(currentRow.getHeight(), DEFAULT_PDF_CHARWIDTH);
                    if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
                        this.printCells(sheet, repeatingRowsStart, repeatingRowsEnd, repeatingColumnStart, repeatingColumnEnd, table, rowIndex, currentRow, rowHeight);
                    }
                    this.printCells(sheet, repeatingRowsStart, repeatingRowsEnd, leftColumnBound, rightColumnBound, table, rowIndex, currentRow, rowHeight);
                    continue;
                }
                rowHeight = LayoutUnitConversionHelper.pxToPdfPoints(sheet.getDefaultRowHeight(), DEFAULT_PDF_CHARWIDTH);
                if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
                    this.printEmptyCells(repeatingRowsStart, repeatingRowsEnd, repeatingColumnStart, repeatingColumnEnd, table, rowIndex, rowHeight, sheet);
                }
                this.printEmptyCells(repeatingRowsStart, repeatingRowsEnd, leftColumnBound, rightColumnBound, table, rowIndex, rowHeight, sheet);
            }
        }
        for (rowIndex = topRowBound; rowIndex <= bottomRowBound; ++rowIndex) {
            currentRow = sheet.getRow(rowIndex);
            if (this.printHeadings) {
                PdfPCell cell = new PdfPCell(new Phrase("" + (rowIndex + 1), this.documentStandardFont));
                cell.setBorderWidth(0.7f);
                cell.setVerticalAlignment(6);
                cell.setHorizontalAlignment(1);
                table.addCell(cell);
            }
            if (currentRow != null) {
                rowHeight = LayoutUnitConversionHelper.pxToPdfPoints(currentRow.getHeight(), DEFAULT_PDF_CHARWIDTH);
                if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
                    this.printCells(sheet, topRowBound, bottomRowBound, repeatingColumnStart, repeatingColumnEnd, table, rowIndex, currentRow, rowHeight);
                }
                this.printCells(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, currentRow, rowHeight);
                continue;
            }
            rowHeight = LayoutUnitConversionHelper.pxToPdfPoints(sheet.getDefaultRowHeight(), DEFAULT_PDF_CHARWIDTH);
            if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
                this.printEmptyCells(topRowBound, bottomRowBound, repeatingColumnStart, repeatingColumnEnd, table, rowIndex, rowHeight, sheet);
            }
            this.printEmptyCells(topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, rowHeight, sheet);
        }
    }

    private void printOverlappingRowsWithNonOverlappingRepeatingColumns(SSheet sheet, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound, int repeatingColumnStart, int repeatingColumnEnd, PdfPTable table) {
        for (int rowIndex = topRowBound; rowIndex <= bottomRowBound; ++rowIndex) {
            float rowHeight;
            SRow currentRow = sheet.getRow(rowIndex);
            if (this.printHeadings) {
                PdfPCell cell = new PdfPCell(new Phrase("" + (rowIndex + 1), this.documentStandardFont));
                cell.setBorderWidth(0.7f);
                cell.setVerticalAlignment(6);
                cell.setHorizontalAlignment(1);
                table.addCell(cell);
            }
            if (currentRow != null) {
                rowHeight = LayoutUnitConversionHelper.pxToPdfPoints(currentRow.getHeight(), DEFAULT_PDF_CHARWIDTH);
                if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
                    this.printCells(sheet, topRowBound, bottomRowBound, repeatingColumnStart, repeatingColumnEnd, table, rowIndex, currentRow, rowHeight);
                }
                this.printCells(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, currentRow, rowHeight);
                continue;
            }
            rowHeight = LayoutUnitConversionHelper.pxToPdfPoints(sheet.getDefaultRowHeight(), DEFAULT_PDF_CHARWIDTH);
            if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
                this.printEmptyCells(topRowBound, bottomRowBound, repeatingColumnStart, repeatingColumnEnd, table, rowIndex, rowHeight, sheet);
            }
            this.printEmptyCells(topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, rowHeight, sheet);
        }
    }

    private void printEmptyCells(int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound, PdfPTable table, int rowIndex, float rowHeight, SSheet sheet) {
        boolean isTopBound = topRowBound == rowIndex;
        for (int columnIndex = leftColumnBound; columnIndex <= rightColumnBound; ++columnIndex) {
            boolean isLeftBound = leftColumnBound == columnIndex;
            PdfPCell cell = this.createPdfCell(rowIndex, columnIndex, null, isTopBound, isLeftBound, sheet);
            cell.setBorder(0);
            cell.setFixedHeight(rowHeight);
            table.addCell(cell);
        }
    }

    private void printCells(SSheet sheet, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound, PdfPTable table, int rowIndex, SRow currentRow, float rowHeight) {
        boolean isTopBound = topRowBound == rowIndex;
        for (int columnIndex = leftColumnBound; columnIndex <= rightColumnBound; ++columnIndex) {
            boolean isLeftBound;
            SCell currentCell = currentRow.getSheet().getCell(rowIndex, columnIndex);
            PdfPCell cell = null;
            boolean bl = isLeftBound = leftColumnBound == columnIndex;
            if (currentCell != null) {
                cell = this.createPdfCell(rowIndex, columnIndex, currentCell, isTopBound, isLeftBound, sheet);
                cell.setBorder(0);
                cell.setFixedHeight(rowHeight);
                CellRegion mergedRegionRange = this.getMergedRegionIfAny(sheet, currentCell);
                if (mergedRegionRange != null) {
                    int colSpan = mergedRegionRange.getLastColumn() - columnIndex + 1;
                    cell.setColspan(colSpan);
                    table.addCell(cell);
                    columnIndex = mergedRegionRange.getLastColumn();
                    continue;
                }
                table.addCell(cell);
                continue;
            }
            cell = this.createPdfCell(rowIndex, columnIndex, null, isTopBound, isLeftBound, sheet);
            cell.setBorder(0);
            cell.setFixedHeight(rowHeight);
            table.addCell(cell);
        }
    }

    private void printRowsWithOverlappingRepeatingColumns(SSheet sheet, int sheetIndex, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound) throws DocumentException {
        Map<String, int[]> currentSheetRepeatingRowsAndColumns = this.sheetsWithRepeatingRowsAndColumns.get(sheetIndex);
        int[] repeatingRows = null;
        boolean rowsOverlapRepeatingRows = false;
        if (currentSheetRepeatingRowsAndColumns != null) {
            repeatingRows = currentSheetRepeatingRowsAndColumns.get("Rows");
            if (topRowBound > repeatingRows[0] && topRowBound <= repeatingRows[1] + 1) {
                topRowBound = repeatingRows[0];
                rowsOverlapRepeatingRows = true;
            }
            if (bottomRowBound < repeatingRows[1] && bottomRowBound >= repeatingRows[0]) {
                bottomRowBound = repeatingRows[1];
                rowsOverlapRepeatingRows = true;
            } else if (bottomRowBound >= repeatingRows[1] && topRowBound <= repeatingRows[1]) {
                rowsOverlapRepeatingRows = true;
            }
        }
        int numOfColumns = rightColumnBound - leftColumnBound == 0 ? 1 : rightColumnBound - leftColumnBound + 1;
        PdfPTable table = this.createPdfTable(numOfColumns, sheet, leftColumnBound, rightColumnBound);
        if (rowsOverlapRepeatingRows) {
            this.printOverlappingRowsWithOverlappingRepeatingColumns(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table);
        } else {
            this.printNonOverlappingRowsWithOverlappingRepeatingColumns(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, repeatingRows[0], repeatingRows[1]);
        }
        table.setHorizontalAlignment(0);
        this.document.add((Element)table);
    }

    private void layoverImagesIfAny(SSheet sheet, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound) {
        PdfContentByte canvas = this.writer.getDirectContent();
        for (SPicture picture : sheet.getPictures()) {
            if (picture == null) continue;
            ViewAnchor anchor1 = picture.getAnchor();
            ViewAnchor anchor2 = anchor1.getRightBottomAnchor(sheet);
            try {
                Image image = Image.getInstance((byte[])picture.getData());
                int width = LayoutUnitConversionHelper.pxToPdfPoints(anchor1.getWidth(), DEFAULT_PDF_CHARWIDTH);
                int height = LayoutUnitConversionHelper.pxToPdfPoints(anchor1.getHeight(), DEFAULT_PDF_CHARWIDTH);
                int xOffset = LayoutUnitConversionHelper.pxToPdfPoints(anchor1.getXOffset(), DEFAULT_PDF_CHARWIDTH);
                int yOffset = LayoutUnitConversionHelper.pxToPdfPoints(anchor1.getYOffset(), DEFAULT_PDF_CHARWIDTH);
                float x = this.leftMargin + this.columnLeft[anchor1.getColumnIndex()] + (float)xOffset;
                float y = this.pgSize.getTop() - this.topMargin - this.rowTop[anchor2.getRowIndex()] - (float)yOffset;
                image.scaleAbsolute((float)width, (float)height);
                image.setAbsolutePosition(x, y);
                canvas.addImage(image);
            }
            catch (BadElementException e) {
            }
            catch (IOException e) {
            }
            catch (DocumentException e) {}
        }
    }

    private void layoutCharts(SSheet sheet, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound) {
        PdfContentByte canvas = this.writer.getDirectContent();
        List charts = sheet.getCharts();
        if (charts == null || charts.size() == 0) {
            return;
        }
        for (SChart chart : charts) {
            ViewAnchor anchor1 = chart.getAnchor();
            ViewAnchor anchor2 = anchor1.getRightBottomAnchor(sheet);
            JFreeChart jfchart = ChartHelper.drawJFreeChart((SChart)chart);
            if (jfchart == null) continue;
            ChartRenderingInfo jfinfo = new ChartRenderingInfo();
            BufferedImage bi = jfchart.createBufferedImage(chart.getAnchor().getWidth(), chart.getAnchor().getHeight(), 3, jfinfo);
            byte[] rawData = null;
            try {
                rawData = EncoderUtil.encode((BufferedImage)bi, (String)"png", (boolean)true);
            }
            catch (IOException ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
            try {
                Image image = Image.getInstance((byte[])rawData);
                int width = LayoutUnitConversionHelper.pxToPdfPoints(anchor1.getWidth(), DEFAULT_PDF_CHARWIDTH);
                int height = LayoutUnitConversionHelper.pxToPdfPoints(anchor1.getHeight(), DEFAULT_PDF_CHARWIDTH);
                int xOffset = LayoutUnitConversionHelper.pxToPdfPoints(anchor1.getXOffset(), DEFAULT_PDF_CHARWIDTH);
                int yOffset = LayoutUnitConversionHelper.pxToPdfPoints(anchor1.getYOffset(), DEFAULT_PDF_CHARWIDTH);
                float x = this.leftMargin + this.columnLeft[anchor1.getColumnIndex()] + (float)xOffset;
                float y = this.pgSize.getTop() - this.topMargin - this.rowTop[anchor2.getRowIndex()] - (float)yOffset;
                image.scaleAbsolute((float)width, (float)height);
                image.setAbsolutePosition(x, y);
                canvas.addImage(image);
            }
            catch (BadElementException e1) {
            }
            catch (IOException e1) {
            }
            catch (DocumentException e) {}
        }
    }

    private void printNonOverlappingRowsWithOverlappingRepeatingColumns(SSheet sheet, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound, PdfPTable table, int repeatingRowsStart, int repeatingRowsEnd) {
        float rowHeight;
        SRow currentRow;
        int rowIndex;
        for (rowIndex = repeatingRowsStart; rowIndex <= repeatingRowsEnd; ++rowIndex) {
            currentRow = sheet.getRow(rowIndex);
            if (this.printHeadings) {
                PdfPCell cell = new PdfPCell(new Phrase("" + (rowIndex + 1), this.documentStandardFont));
                cell.setBorderWidth(0.7f);
                cell.setVerticalAlignment(6);
                cell.setHorizontalAlignment(1);
                table.addCell(cell);
            }
            if (currentRow != null) {
                rowHeight = LayoutUnitConversionHelper.pxToPdfPoints(currentRow.getHeight(), DEFAULT_PDF_CHARWIDTH);
                this.printCells(sheet, repeatingRowsStart, repeatingRowsEnd, leftColumnBound, rightColumnBound, table, rowIndex, currentRow, rowHeight);
                continue;
            }
            rowHeight = LayoutUnitConversionHelper.pxToPdfPoints(sheet.getDefaultRowHeight(), DEFAULT_PDF_CHARWIDTH);
            this.printEmptyCells(repeatingRowsStart, repeatingRowsEnd, leftColumnBound, rightColumnBound, table, rowIndex, rowHeight, sheet);
        }
        for (rowIndex = topRowBound; rowIndex <= bottomRowBound; ++rowIndex) {
            currentRow = sheet.getRow(rowIndex);
            if (this.printHeadings) {
                PdfPCell cell = new PdfPCell(new Phrase("" + (rowIndex + 1), this.documentStandardFont));
                cell.setBorderWidth(0.7f);
                cell.setVerticalAlignment(6);
                cell.setHorizontalAlignment(1);
                table.addCell(cell);
            }
            if (currentRow != null) {
                rowHeight = LayoutUnitConversionHelper.pxToPdfPoints(currentRow.getHeight(), DEFAULT_PDF_CHARWIDTH);
                this.printCells(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, currentRow, rowHeight);
                continue;
            }
            rowHeight = LayoutUnitConversionHelper.pxToPdfPoints(sheet.getDefaultRowHeight(), DEFAULT_PDF_CHARWIDTH);
            this.printEmptyCells(topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, rowHeight, sheet);
        }
    }

    private void printOverlappingRowsWithOverlappingRepeatingColumns(SSheet sheet, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound, PdfPTable table) {
        for (int rowIndex = topRowBound; rowIndex <= bottomRowBound; ++rowIndex) {
            float rowHeight;
            SRow currentRow = sheet.getRow(rowIndex);
            if (this.printHeadings) {
                PdfPCell cell = new PdfPCell(new Phrase("" + (rowIndex + 1), this.documentStandardFont));
                cell.setBorderWidth(0.7f);
                cell.setVerticalAlignment(6);
                cell.setHorizontalAlignment(1);
                table.addCell(cell);
            }
            if (currentRow != null) {
                rowHeight = LayoutUnitConversionHelper.pxToPdfPoints(currentRow.getHeight(), DEFAULT_PDF_CHARWIDTH);
                this.printCells(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, currentRow, rowHeight);
                continue;
            }
            rowHeight = LayoutUnitConversionHelper.pxToPdfPoints(sheet.getDefaultRowHeight(), DEFAULT_PDF_CHARWIDTH);
            this.printEmptyCells(topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, rowHeight, sheet);
        }
    }

    private CellRegion getMergedRegionIfAny(SSheet sheet, SCell cell) {
        CellRegion partOfRange = null;
        for (CellRegion range : sheet.getMergedRegions()) {
            if (cell.getColumnIndex() < range.getColumn() || cell.getColumnIndex() > range.getLastColumn() || cell.getRowIndex() < range.getRow() || cell.getRowIndex() > range.getLastRow()) continue;
            partOfRange = range;
            break;
        }
        return partOfRange;
    }

    private boolean isPartOfMergedRegion(SSheet sheet, SCell cell) {
        boolean partOfMergedRegion = false;
        for (CellRegion range : sheet.getMergedRegions()) {
            if (cell.getColumnIndex() < range.getColumn() || cell.getColumnIndex() > range.getLastColumn() || cell.getRowIndex() < range.getRow() || cell.getRowIndex() > range.getLastRow()) continue;
            partOfMergedRegion = true;
            break;
        }
        return partOfMergedRegion;
    }

    private PdfPTable createPdfTable(int numOfColumns, SSheet sheet, int leftColumnBound, int rightColumnBound) throws DocumentException {
        PdfPTable pdfTable = null;
        int totalWidth = 0;
        float[] columnWidths = null;
        int columnWidthsIndex = 0;
        if (this.printHeadings) {
            pdfTable = new PdfPTable(numOfColumns + 1);
            totalWidth = (int)((float)totalWidth + StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH);
            columnWidths = new float[numOfColumns + 1];
            columnWidths[columnWidthsIndex++] = StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH;
        } else {
            pdfTable = new PdfPTable(numOfColumns);
            columnWidths = new float[numOfColumns];
        }
        int columnIndex = leftColumnBound;
        while (columnIndex <= rightColumnBound) {
            int columnWidth = sheet.getColumn(columnIndex).getWidth();
            int columnWidthInPoints = LayoutUnitConversionHelper.pxToPdfPoints(columnWidth, DEFAULT_PDF_CHARWIDTH);
            totalWidth += columnWidthInPoints;
            columnWidths[columnWidthsIndex] = columnWidthInPoints;
            ++columnIndex;
            ++columnWidthsIndex;
        }
        pdfTable.setWidths(columnWidths);
        pdfTable.setLockedWidth(true);
        pdfTable.setTotalWidth(columnWidths);
        pdfTable.setSpacingBefore(0.0f);
        pdfTable.setHorizontalAlignment(0);
        if (this.printHeadings) {
            PdfPCell cell = new PdfPCell(new Phrase(" ", this.documentStandardFont));
            cell.setBorderWidth(0.7f);
            pdfTable.addCell(cell);
            for (int columnIndex2 = leftColumnBound; columnIndex2 <= rightColumnBound; ++columnIndex2) {
                cell = new PdfPCell(new Phrase(CellRegion.convertIndexToColumnString((int)columnIndex2), this.documentStandardFont));
                cell.setBorderWidth(0.7f);
                cell.setHorizontalAlignment(1);
                pdfTable.addCell(cell);
            }
        }
        return pdfTable;
    }

    private PdfPTable createPdfTableWithNonOverlappingColumns(int numOfColumns, SSheet sheet, int leftColumnBound, int rightColumnBound, int repeatingColumnStart, int repeatingColumnEnd) throws DocumentException {
        int columnWidthInPoints;
        int columnWidth;
        int columnIndex;
        PdfPTable pdfTable = null;
        int totalWidth = 0;
        float[] columnWidths = null;
        int columnWidthsIndex = 0;
        if (this.printHeadings) {
            pdfTable = new PdfPTable(numOfColumns + 1);
            totalWidth = (int)((float)totalWidth + StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH);
            columnWidths = new float[numOfColumns + 1];
            columnWidths[columnWidthsIndex++] = StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH;
        } else {
            pdfTable = new PdfPTable(numOfColumns);
            columnWidths = new float[numOfColumns];
        }
        if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
            columnIndex = repeatingColumnStart;
            while (columnIndex <= repeatingColumnEnd) {
                columnWidth = sheet.getColumn(columnIndex).getWidth();
                columnWidthInPoints = LayoutUnitConversionHelper.pxToPdfPoints(columnWidth, 58);
                totalWidth += columnWidthInPoints;
                columnWidths[columnWidthsIndex] = columnWidthInPoints;
                ++columnIndex;
                ++columnWidthsIndex;
            }
        }
        columnIndex = leftColumnBound;
        while (columnIndex <= rightColumnBound) {
            columnWidth = sheet.getColumn(columnIndex).getWidth();
            columnWidthInPoints = LayoutUnitConversionHelper.pxToPdfPoints(columnWidth, 58);
            totalWidth += columnWidthInPoints;
            columnWidths[columnWidthsIndex] = columnWidthInPoints;
            ++columnIndex;
            ++columnWidthsIndex;
        }
        pdfTable.setWidths(columnWidths);
        pdfTable.setLockedWidth(true);
        pdfTable.setTotalWidth(columnWidths);
        pdfTable.setSpacingBefore(0.0f);
        pdfTable.setHorizontalAlignment(0);
        if (this.printHeadings) {
            int columnIndex2;
            PdfPCell cell = new PdfPCell(new Phrase(" ", this.documentStandardFont));
            cell.setBorderWidth(0.7f);
            pdfTable.addCell(cell);
            if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
                for (columnIndex2 = repeatingColumnStart; columnIndex2 <= repeatingColumnEnd; ++columnIndex2) {
                    cell = new PdfPCell(new Phrase(CellRegion.convertIndexToColumnString((int)columnIndex2), this.documentStandardFont));
                    cell.setBorderWidth(0.7f);
                    cell.setHorizontalAlignment(1);
                    pdfTable.addCell(cell);
                }
            }
            for (columnIndex2 = leftColumnBound; columnIndex2 <= rightColumnBound; ++columnIndex2) {
                cell = new PdfPCell(new Phrase(CellRegion.convertIndexToColumnString((int)columnIndex2), this.documentStandardFont));
                cell.setBorderWidth(0.7f);
                cell.setHorizontalAlignment(1);
                pdfTable.addCell(cell);
            }
        }
        return pdfTable;
    }

    private PdfPCell createPdfCell(int rowIndex, int colIndex, SCell zssCell, boolean isTopBound, boolean isLeftBound, SSheet sheet) {
        PdfPCell cell = null;
        if (zssCell != null) {
            SCellStyle style = zssCell.getCellStyle();
            Phrase p = this.createPhrase(zssCell);
            cell = new PdfPCell(p);
            cell.setPadding(0.0f);
            cell.setPaddingLeft(2.5f);
            cell.setPaddingRight(2.5f);
            cell.setPaddingBottom(2.5f);
            cell.setHorizontalAlignment(StyleConversionUtil.getCorrespondingPdfPCellAlignment(style.getAlignment()));
            cell.setVerticalAlignment(StyleConversionUtil.getCorrespondingPdfPCellVerticalAlignment(style.getVerticalAlignment()));
            SColor color = style.getFillColor();
            Color baseColor = Color.white;
            if (color != null) {
                String sColor = color.getHtmlColor();
                baseColor = WebColors.getRGBColor((String)(sColor == null || "AUTO_COLOR".equals(sColor) ? "WHITE" : sColor));
                cell.setBackgroundColor(baseColor);
            }
            cell.setCellEvent((PdfPCellEvent)BorderDrawEvent.getCellEvent(rowIndex, colIndex, zssCell, style, this.printGridLines, isTopBound, isLeftBound, sheet, this.wb));
        } else {
            cell = new PdfPCell(new Phrase(" ", this.documentStandardFont));
            cell.setPadding(0.0f);
            cell.setPaddingLeft(2.5f);
            cell.setHorizontalAlignment(-1);
            cell.setVerticalAlignment(7);
            cell.setCellEvent((PdfPCellEvent)BorderDrawEvent.getCellEvent(rowIndex, colIndex, null, null, this.printGridLines, isTopBound, isLeftBound, sheet, this.wb));
        }
        return cell;
    }

    private Phrase createPhrase(SCell zssCell) {
        Phrase p = null;
        if (!zssCell.isNull()) {
            FormatEngine fe = EngineFactory.getInstance().createFormatEngine();
            FormatResult result = fe.format(zssCell, new FormatContext(ZssContext.getCurrent().getLocale()));
            if (result.isRichText()) {
                p = new Phrase();
                for (SRichText.Segment sg : result.getRichText().getSegments()) {
                    SFont zssFont = sg.getFont();
                    Font cellFont = FontFactory.getFont((String)zssFont.getName(), (String)"Identity-H");
                    cellFont.setColor(WebColors.getRGBColor((String)zssFont.getColor().getHtmlColor()));
                    cellFont.setSize((float)zssFont.getHeightPoints());
                    if (zssFont.isItalic()) {
                        cellFont.setStyle(2);
                    }
                    if (zssFont.getUnderline() != SFont.Underline.NONE) {
                        cellFont.setStyle(4);
                    }
                    if (zssFont.isStrikeout()) {
                        cellFont.setStyle(8);
                    }
                    p.add((Object)new Chunk(sg.getText(), cellFont));
                }
            } else {
                SCellStyle style = zssCell.getCellStyle();
                Font cellFont = this.getPdfCellFont(style);
                p = new Phrase(0.0f, result.getText(), cellFont);
            }
        }
        return p;
    }

    private Font getPdfCellFont(SCellStyle style) {
        SFont zssFont = style.getFont();
        SColor fontColor = zssFont.getColor();
        Font cellFont = FontFactory.getFont((String)zssFont.getName(), (String)"Identity-H");
        Color fontBaseColor = null;
        if (fontColor != null) {
            String sColor = fontColor.getHtmlColor();
            fontBaseColor = WebColors.getRGBColor((String)(sColor == null || "AUTO_COLOR".equals(sColor) ? "BLACK" : sColor));
            cellFont.setColor(fontBaseColor);
        }
        cellFont.setSize((float)zssFont.getHeightPoints());
        if (zssFont.isItalic()) {
            cellFont.setStyle(2);
        }
        if (zssFont.getUnderline() != SFont.Underline.NONE) {
            cellFont.setStyle(4);
        }
        if (zssFont.isStrikeout()) {
            cellFont.setStyle(8);
        }
        return cellFont;
    }

    private int searchEndColumn(SSheet sheet, SRow row) {
        int last = -1;
        for (int i = sheet.getEndCellIndex(row.getIndex()); i > 0; --i) {
            SCell cell = sheet.getCell(row.getIndex(), i);
            if (cell.isNull() || cell.getType() == SCell.CellType.BLANK) continue;
            last = i;
            break;
        }
        return last;
    }

    private void initSheetRowColumnBounds(SSheet sheet) {
        List charts;
        this.firstColumn = 0;
        this.endColumn = 0;
        this.endRow = 0;
        Iterator rowIter = sheet.getRowIterator();
        while (rowIter.hasNext()) {
            SRow row = (SRow)rowIter.next();
            int lastCol = this.searchEndColumn(sheet, row);
            this.endColumn = Math.max(this.endColumn, lastCol);
            this.endRow = Math.max(this.endRow, row.getIndex());
        }
        List pics = sheet.getPictures();
        if (pics != null && pics.size() != 0) {
            for (SPicture pic : pics) {
                ViewAnchor anchor1 = pic.getAnchor();
                ViewAnchor anchor2 = anchor1.getRightBottomAnchor(sheet);
                if (anchor2.getColumnIndex() > this.endColumn) {
                    this.endColumn = anchor2.getColumnIndex();
                }
                if (anchor2.getRowIndex() <= this.endRow) continue;
                this.endRow = anchor2.getRowIndex();
            }
        }
        if ((charts = sheet.getCharts()) != null && charts.size() != 0) {
            for (SChart chart : charts) {
                ViewAnchor anchor1 = chart.getAnchor();
                ViewAnchor anchor2 = anchor1.getRightBottomAnchor(sheet);
                if (anchor2.getColumnIndex() > this.endColumn) {
                    this.endColumn = anchor2.getColumnIndex();
                }
                if (anchor2.getRowIndex() <= this.endRow) continue;
                this.endRow = anchor2.getRowIndex();
            }
        }
    }

    public void enableGridLines(boolean enable) {
        this.printGridLines = enable;
    }

    public void enableHeadings(boolean enable) {
        this.printHeadings = enable;
    }

    class PdfHeaderFooter
    extends PdfPageEventHelper {
        PdfHeaderFooter() {
        }

        public void onOpenDocument(PdfWriter pdfWriter, Document doc) {
        }

        public void onStartPage(PdfWriter pdfWriter, Document doc) {
            PdfExporter.this.pageNumber++;
        }

        private PdfPCell createHeaderFooterCell(String text, int alignment) {
            PdfPCell cell = new PdfPCell(new Phrase(text, PdfExporter.this.documentStandardFont));
            cell.setPaddingLeft(2.5f);
            cell.setHorizontalAlignment(alignment);
            cell.setBorder(0);
            return cell;
        }

        private PdfPTable createHeaderFooter(int alignment) {
            PdfPTable table = new PdfPTable(1);
            table.setTotalWidth(PdfExporter.this.headerFooterTotalWidth / 3.0f);
            table.setHorizontalAlignment(alignment);
            return table;
        }

        public void onEndPage(PdfWriter pdfWriter, Document doc) {
            Rectangle rect = PdfExporter.this.writer.getBoxSize("art");
            PdfPTable leftHeader = this.createHeaderFooter(0);
            PdfPTable centerHeader = this.createHeaderFooter(1);
            PdfPTable rightHeader = this.createHeaderFooter(2);
            leftHeader.addCell(this.createHeaderFooterCell(PdfExporter.this.header.getLeftText(), 0));
            centerHeader.addCell(this.createHeaderFooterCell(PdfExporter.this.header.getCenterText(), 1));
            rightHeader.addCell(this.createHeaderFooterCell(PdfExporter.this.header.getRightText(), 2));
            float topPosition = rect.getTop() - PdfExporter.this.topMargin + leftHeader.getTotalHeight() + PdfExporter.this.headerMargin;
            leftHeader.writeSelectedRows(0, 1, PdfExporter.this.leftMargin, topPosition, PdfExporter.this.writer.getDirectContent());
            centerHeader.writeSelectedRows(0, 1, PdfExporter.this.leftMargin + leftHeader.getTotalWidth(), topPosition, PdfExporter.this.writer.getDirectContent());
            rightHeader.writeSelectedRows(0, 1, PdfExporter.this.leftMargin + leftHeader.getTotalWidth() + centerHeader.getTotalWidth(), topPosition, PdfExporter.this.writer.getDirectContent());
            PdfPTable leftFooter = this.createHeaderFooter(0);
            PdfPTable centerFooter = this.createHeaderFooter(1);
            PdfPTable rightFooter = this.createHeaderFooter(2);
            leftFooter.addCell(this.createHeaderFooterCell(PdfExporter.this.footer.getLeftText(), 0));
            centerFooter.addCell(this.createHeaderFooterCell(PdfExporter.this.footer.getCenterText(), 1));
            rightFooter.addCell(this.createHeaderFooterCell(PdfExporter.this.footer.getRightText(), 2));
            float bottomPosition = rect.getBottom() + PdfExporter.this.bottomMargin - PdfExporter.this.footerMargin;
            leftFooter.writeSelectedRows(0, 1, PdfExporter.this.leftMargin, bottomPosition, PdfExporter.this.writer.getDirectContent());
            centerFooter.writeSelectedRows(0, 1, PdfExporter.this.leftMargin + leftFooter.getTotalWidth(), bottomPosition, PdfExporter.this.writer.getDirectContent());
            rightFooter.writeSelectedRows(0, 1, PdfExporter.this.leftMargin + leftFooter.getTotalWidth() + centerFooter.getTotalWidth(), bottomPosition, PdfExporter.this.writer.getDirectContent());
            PdfExporter.this.layoverImagesIfAny(PdfExporter.this.wb.getSheet(PdfExporter.this.currentSheetIndex), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("rowTop"), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("rowBottom"), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("columnLeft"), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("columnRight"));
            PdfExporter.this.layoutCharts(PdfExporter.this.wb.getSheet(PdfExporter.this.currentSheetIndex), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("rowTop"), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("rowBottom"), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("columnLeft"), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("columnRight"));
        }
    }
}

