/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.html.WebColors;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import java.awt.Color;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SColor;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.impl.pdf.BorderStyle;
import org.zkoss.zss.model.impl.pdf.StyleConversionUtil;

class BorderDrawEvent
implements PdfPCellEvent {
    private SCellStyle style;
    private SCell zssCell;
    private int rowIndex;
    private int columnIndex;
    private SSheet sheet;
    private boolean isTopBound;
    private boolean isLeftBound;
    private boolean printGridLines;
    private final SBook wb;

    public SCell getZSSCell() {
        return this.zssCell;
    }

    public void setZSSCell(SCell zssCell) {
        this.zssCell = zssCell;
    }

    private BorderDrawEvent(SBook wb, SSheet sheet, int rowIndex, int columnIndex, boolean isTopBound, boolean isLeftBound) {
        this.wb = wb;
        this.sheet = sheet;
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.isTopBound = isTopBound;
        this.isLeftBound = isLeftBound;
    }

    public static BorderDrawEvent getCellEvent(int rowIndex, int colIndex, SCell zssCell, SCellStyle style, boolean printGridLines, boolean isTopBound, boolean isLeftBound, SSheet sheet, SBook wb) {
        BorderDrawEvent event = new BorderDrawEvent(wb, sheet, rowIndex, colIndex, isTopBound, isLeftBound);
        event.setZSSCell(zssCell);
        event.setStyle(style);
        event.setPrintGridLines(printGridLines);
        return event;
    }

    public void cellLayout(PdfPCell cell, Rectangle rect, PdfContentByte[] canvases) {
        PdfContentByte lineCanvas = canvases[2];
        lineCanvas.setLineJoin(0);
        this.processBottomBorder(rect, lineCanvas);
        this.processRightBorder(rect, lineCanvas);
        this.processTopBorder(rect, lineCanvas);
        this.processLeftBorder(rect, lineCanvas);
    }

    private BorderInfo getBorderInfo(BORDER border, SCell cell) {
        SCellStyle cellStyle;
        if (!cell.isNull() && (cellStyle = cell.getCellStyle()) != null) {
            Object type = border.getType(cellStyle);
            if (border == BORDER.BACKGROUND && SCellStyle.FillPattern.NO_FILL != type) {
                return new BorderInfo(type, border.getColor(cellStyle));
            }
            if (SCellStyle.BorderType.NONE != type && SCellStyle.FillPattern.NO_FILL != type) {
                return new BorderInfo(type, border.getColor(cellStyle));
            }
        }
        return null;
    }

    private void processBottomBorder(Rectangle rect, PdfContentByte lineCanvas) {
        BorderInfo info = this.getBorderInfo(BORDER.BOTTOM, this.zssCell);
        if (info != null) {
            this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.BOTTOM);
            return;
        }
        SCell nextCell = this.sheet.getCell(this.rowIndex + 1, this.columnIndex);
        info = this.getBorderInfo(BORDER.TOP, nextCell);
        if (info != null) {
            this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.BOTTOM);
            return;
        }
        info = this.getBorderInfo(BORDER.BACKGROUND, nextCell);
        if (info != null) {
            this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.BOTTOM);
            return;
        }
        this.drawBorder(rect, lineCanvas, null, null, BORDER.BOTTOM);
    }

    private void processRightBorder(Rectangle rect, PdfContentByte lineCanvas) {
        BorderInfo info = this.getBorderInfo(BORDER.RIGHT, this.zssCell);
        if (info != null) {
            this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.RIGHT);
            return;
        }
        SCell rightCell = this.sheet.getCell(this.rowIndex, this.columnIndex + 1);
        info = this.getBorderInfo(BORDER.LEFT, rightCell);
        if (info != null) {
            this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.RIGHT);
            return;
        }
        info = this.getBorderInfo(BORDER.BACKGROUND, rightCell);
        if (info != null) {
            this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.RIGHT);
            return;
        }
        this.drawBorder(rect, lineCanvas, null, null, BORDER.RIGHT);
    }

    private void processTopBorder(Rectangle rect, PdfContentByte lineCanvas) {
        if (this.isTopBound) {
            BorderInfo info;
            if (this.rowIndex - 1 >= 0 && (info = this.getBorderInfo(BORDER.BOTTOM, this.sheet.getCell(this.rowIndex - 1, this.columnIndex))) != null) {
                this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.TOP);
                return;
            }
            info = this.getBorderInfo(BORDER.TOP, this.zssCell);
            if (info != null) {
                this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.TOP);
                return;
            }
            info = this.getBorderInfo(BORDER.BACKGROUND, this.zssCell);
            if (info != null) {
                this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.TOP);
                return;
            }
            this.drawBorder(rect, lineCanvas, null, null, BORDER.TOP);
        }
    }

    private void processLeftBorder(Rectangle rect, PdfContentByte lineCanvas) {
        if (this.isLeftBound) {
            BorderInfo info;
            if (this.columnIndex - 1 >= 0 && (info = this.getBorderInfo(BORDER.RIGHT, this.sheet.getCell(this.rowIndex, this.columnIndex - 1))) != null) {
                this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.LEFT);
                return;
            }
            info = this.getBorderInfo(BORDER.LEFT, this.zssCell);
            if (info != null) {
                this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.LEFT);
                return;
            }
            info = this.getBorderInfo(BORDER.BACKGROUND, this.zssCell);
            if (info != null) {
                this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.LEFT);
                return;
            }
            this.drawBorder(rect, lineCanvas, null, null, BORDER.LEFT);
        }
    }

    private void drawBorder(Rectangle rect, PdfContentByte lineCanvas, BorderStyle borderStyle, String sBorderColor, BORDER border) {
        if (borderStyle == null) {
            if (this.isPrintGridLines()) {
                lineCanvas.saveState();
                lineCanvas.setLineWidth(0.4f);
                lineCanvas.setLineCap(0);
                lineCanvas.setLineDash(new float[0], 0.0f);
                lineCanvas.setColorStroke(Color.LIGHT_GRAY);
                this.setBorderEndPoints(rect, lineCanvas, border);
                lineCanvas.stroke();
                lineCanvas.restoreState();
            }
        } else {
            lineCanvas.saveState();
            BorderStyle blankBorder = StyleConversionUtil.getBorderStyle((short)5);
            blankBorder.setLineWidth(borderStyle.getLineWidth());
            lineCanvas.setLineWidth(blankBorder.getLineWidth());
            lineCanvas.setLineCap(blankBorder.getLineCapStyle());
            lineCanvas.setLineDash(blankBorder.getUnits(), blankBorder.getPhase());
            lineCanvas.setColorStroke(Color.white);
            this.setBorderEndPoints(rect, lineCanvas, border);
            lineCanvas.stroke();
            lineCanvas.restoreState();
            lineCanvas.saveState();
            lineCanvas.setLineWidth(borderStyle.getLineWidth());
            lineCanvas.setLineCap(borderStyle.getLineCapStyle());
            lineCanvas.setLineDash(borderStyle.getUnits(), borderStyle.getPhase());
            Color borderColor = WebColors.getRGBColor((String)(sBorderColor == null || "AUTO_COLOR".equals(sBorderColor) ? "BLACK" : sBorderColor));
            lineCanvas.setColorStroke(Color.black);
            if (borderColor != null && borderColor != Color.white) {
                lineCanvas.setColorStroke(borderColor);
            }
            this.setBorderEndPoints(rect, lineCanvas, border);
            lineCanvas.stroke();
            lineCanvas.restoreState();
        }
    }

    private void setBorderEndPoints(Rectangle rect, PdfContentByte lineCanvas, BORDER border) {
        switch (border) {
            case BOTTOM: {
                lineCanvas.moveTo(rect.getLeft(), rect.getBottom());
                lineCanvas.lineTo(rect.getRight(), rect.getBottom());
                break;
            }
            case RIGHT: {
                lineCanvas.moveTo(rect.getRight(), rect.getBottom());
                lineCanvas.lineTo(rect.getRight(), rect.getTop());
                break;
            }
            case TOP: {
                lineCanvas.moveTo(rect.getLeft(), rect.getTop());
                lineCanvas.lineTo(rect.getRight(), rect.getTop());
                break;
            }
            case LEFT: {
                lineCanvas.moveTo(rect.getLeft(), rect.getBottom());
                lineCanvas.lineTo(rect.getLeft(), rect.getTop());
            }
        }
    }

    private void setStyle(SCellStyle style) {
        this.style = style;
    }

    private SCellStyle getStyle() {
        return this.style;
    }

    private void setPrintGridLines(boolean printGridLines) {
        this.printGridLines = printGridLines;
    }

    private boolean isPrintGridLines() {
        return this.printGridLines;
    }

    private class BorderInfo {
        final BorderStyle style;
        final String htmlColor;

        BorderInfo(Object borderType, SColor borderColor) {
            this.style = borderType instanceof SCellStyle.BorderType ? StyleConversionUtil.getBorderStyle((SCellStyle.BorderType)borderType) : null;
            this.htmlColor = borderColor.getHtmlColor();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BORDER {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT,
        BACKGROUND;


        Object getType(SCellStyle cellStyle) {
            switch (this) {
                case TOP: {
                    return cellStyle.getBorderTop();
                }
                case RIGHT: {
                    return cellStyle.getBorderRight();
                }
                case BOTTOM: {
                    return cellStyle.getBorderBottom();
                }
                case LEFT: {
                    return cellStyle.getBorderLeft();
                }
                case BACKGROUND: {
                    return cellStyle.getFillPattern();
                }
            }
            throw new RuntimeException();
        }

        SColor getColor(SCellStyle cellStyle) {
            switch (this) {
                case TOP: {
                    return cellStyle.getBorderTopColor();
                }
                case RIGHT: {
                    return cellStyle.getBorderRightColor();
                }
                case BOTTOM: {
                    return cellStyle.getBorderBottomColor();
                }
                case LEFT: {
                    return cellStyle.getBorderLeftColor();
                }
                case BACKGROUND: {
                    return cellStyle.getFillColor();
                }
            }
            throw new RuntimeException();
        }
    }
}

