/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.pdf;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.html.WebColors;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPCellEvent;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zkoss.poi.hssf.usermodel.HSSFRichTextString;
import org.zkoss.poi.hssf.usermodel.HSSFSheet;
import org.zkoss.poi.ss.usermodel.Cell;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.ChartDrawer;
import org.zkoss.poi.ss.usermodel.ChartInfo;
import org.zkoss.poi.ss.usermodel.ClientAnchor;
import org.zkoss.poi.ss.usermodel.Color;
import org.zkoss.poi.ss.usermodel.Font;
import org.zkoss.poi.ss.usermodel.Footer;
import org.zkoss.poi.ss.usermodel.Header;
import org.zkoss.poi.ss.usermodel.Picture;
import org.zkoss.poi.ss.usermodel.PictureData;
import org.zkoss.poi.ss.usermodel.RichTextString;
import org.zkoss.poi.ss.usermodel.Row;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.Workbook;
import org.zkoss.poi.ss.usermodel.ZssChartX;
import org.zkoss.poi.ss.util.AreaReference;
import org.zkoss.poi.ss.util.CellRangeAddress;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.poi.xssf.usermodel.XSSFRichTextString;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zss.model.Book;
import org.zkoss.zss.model.Exporter;
import org.zkoss.zss.model.FormatText;
import org.zkoss.zss.model.Worksheet;
import org.zkoss.zss.model.impl.BookHelper;
import org.zkoss.zss.model.impl.DrawingManager;
import org.zkoss.zss.model.impl.Headings;
import org.zkoss.zss.model.impl.SheetCtrl;
import org.zkoss.zss.model.impl.pdf.BorderDrawEvent;
import org.zkoss.zss.model.impl.pdf.FontLoader;
import org.zkoss.zss.model.impl.pdf.LayoutUnitConversionHelper;
import org.zkoss.zss.model.impl.pdf.PageSizeConversionUtil;
import org.zkoss.zss.model.impl.pdf.StyleConversionUtil;
import org.zkoss.zss.ui.impl.Utils;
import org.zkoss.zssex.util.ChartHelper;
import org.zkoss.zul.Chart;
import org.zkoss.zul.ChartModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfExporter
implements Exporter,
Headings,
ChartDrawer,
Serializable {
    private Book wb;
    private Document document;
    private PdfWriter writer;
    private int[] colBreaks;
    private int[] rowBreaks;
    private int firstColumn;
    private int endColumn;
    private int endRow;
    private int pageCount = 1;
    private int pageNumber;
    private com.itextpdf.text.Font documentStandardFont;
    private boolean printGridLines;
    private boolean printHeadings;
    private Rectangle pgSize;
    private float headerFooterTotalWidth;
    private float leftMargin;
    private float rightMargin;
    private float topMargin;
    private float bottomMargin;
    private float headerMargin;
    private float footerMargin;
    private Header header;
    private Footer footer;
    private Map<Integer, Map<String, int[]>> sheetsWithRepeatingRowsAndColumns = new HashMap<Integer, Map<String, int[]>>();
    private float totalAvailablePageWidth;
    private float totalAvailablePageHeight;
    private float[] columnLeft;
    private float[] rowTop;
    private Map<String, Integer> lastPageRowColumnBounds;
    private int currentSheetIndex = 0;
    List<Picture> pictures;
    private FontLoader fontLoader = FontLoader.getInstance();
    private DrawingManager _dm;
    private int _outcol1;
    private int _outcol2;
    private int _outrow1;
    private int _outrow2;
    private Chart _chart;
    private String _refSheetName;

    public void export(Book workbook, OutputStream outputStream) {
        try {
            this.wb = workbook;
            this.setupExporter(this.wb.getWorksheetAt(0), outputStream);
            this.document.open();
            int numSheets = workbook.getNumberOfSheets();
            for (int i = 0; i < numSheets; ++i) {
                this.currentSheetIndex = i;
                this.exportSheet(workbook.getWorksheetAt(i), i);
            }
            this.document.close();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public void export(Worksheet worksheet, OutputStream outputStream) {
        try {
            this.wb = (Book)worksheet.getWorkbook();
            this.setupExporter(worksheet, outputStream);
            this.document.open();
            this.currentSheetIndex = this.wb.getSheetIndex((Sheet)worksheet);
            this.exportSheet(worksheet, this.currentSheetIndex);
            this.document.close();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public void exportSelection(Worksheet worksheet, AreaReference area, OutputStream outputStream) {
        try {
            this.wb = (Book)worksheet.getWorkbook();
            this.setupExporter(worksheet, outputStream);
            this.document.open();
            this.currentSheetIndex = this.wb.getSheetIndex((Sheet)worksheet);
            this.exportSheetSelection(worksheet, this.currentSheetIndex, area);
            this.document.close();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private void setupExporter(Worksheet sheet, OutputStream outputStream) throws DocumentException {
        this.document = new Document();
        this._dm = ((SheetCtrl)sheet).getDrawingManager();
        this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)outputStream);
        this.setDocumentPageProperties(sheet);
        PdfHeaderFooter phf = new PdfHeaderFooter();
        Rectangle artBox = new Rectangle(this.pgSize.getLeft(), this.pgSize.getBottom(), this.pgSize.getRight(), this.pgSize.getBottom());
        artBox.setBorderWidth(1.0f);
        artBox.setBorder(1);
        artBox.enableBorderSide(1);
        this.writer.setBoxSize("art", this.pgSize);
        this.writer.setPageEvent((PdfPageEvent)phf);
    }

    private void exportSheetSelection(Worksheet sheet, int sheetIndex, AreaReference area) throws DocumentException {
        this.header = sheet.getHeader();
        this.footer = sheet.getFooter();
        this.initSheetRowColumnBounds(sheet);
        this.setRowColumnBreaks(sheet);
        this.getPictureData(sheet);
        this.printSelectedColumns(sheet, sheetIndex, area.getFirstCell().getCol(), area.getLastCell().getCol(), area);
        this.document.newPage();
    }

    private void exportSheet(Worksheet sheet, int sheetIndex) throws DocumentException {
        this.header = sheet.getHeader();
        this.footer = sheet.getFooter();
        this.initSheetRowColumnBounds(sheet);
        this.setRowColumnBreaks(sheet);
        this.getPictureData(sheet);
        int leftColumnBound = this.firstColumn;
        for (int i = 0; i < this.colBreaks.length; ++i) {
            this.printColumns(sheet, sheetIndex, leftColumnBound, this.colBreaks[i]);
            leftColumnBound = this.colBreaks[i] + 1;
        }
        if (leftColumnBound <= this.endColumn) {
            this.printColumns(sheet, sheetIndex, leftColumnBound, this.endColumn);
        }
        this.document.newPage();
    }

    private void getPictureData(Worksheet sheet) {
        this.pictures = this._dm.getPictures();
    }

    private void setRowColumnBreaks(Worksheet sheet) {
        this.colBreaks = sheet.getColumnBreaks();
        this.rowBreaks = sheet.getRowBreaks();
        if (this.colBreaks != null && this.colBreaks.length == 0) {
            this.setAutoColumnBreaks(sheet);
        }
        if (this.rowBreaks != null && this.rowBreaks.length == 0) {
            this.setAutoRowBreaks(sheet);
        }
    }

    private void setAutoRowBreaks(Worksheet sheet) {
        float currentPageHeight = 0.0f;
        float defaultRowHeight = LayoutUnitConversionHelper.twipsToPdfPoints(sheet.getDefaultRowHeight(), 53);
        if (this.printHeadings) {
            currentPageHeight = defaultRowHeight;
        }
        ArrayList<Integer> autoRowBreaks = new ArrayList<Integer>();
        this.rowTop = new float[this.endRow + 1];
        for (int i = 0; i <= this.endRow; ++i) {
            Row currentRow = sheet.getRow(i);
            this.rowTop[i] = currentPageHeight;
            currentPageHeight = currentRow != null ? (currentPageHeight += LayoutUnitConversionHelper.twipsToPdfPoints(currentRow.getHeight(), 53)) : (currentPageHeight += defaultRowHeight);
            if (!(currentPageHeight >= this.totalAvailablePageHeight)) continue;
            autoRowBreaks.add(i - 1);
            currentPageHeight = this.printHeadings ? defaultRowHeight + (currentRow != null ? LayoutUnitConversionHelper.twipsToPdfPoints(currentRow.getHeight(), 53) : defaultRowHeight) : LayoutUnitConversionHelper.twipsToPdfPoints(currentRow.getHeight(), 53);
        }
        if (autoRowBreaks.size() > 0) {
            this.rowBreaks = PdfExporter.convertIntegers(autoRowBreaks);
        }
    }

    private void setAutoColumnBreaks(Worksheet sheet) {
        float currentPageWidth = 0.0f;
        if (this.printHeadings) {
            currentPageWidth = StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH;
        }
        ArrayList<Integer> autoColumnBreaks = new ArrayList<Integer>();
        this.columnLeft = new float[this.endColumn + 1];
        for (int i = this.firstColumn; i <= this.endColumn; ++i) {
            this.columnLeft[i] = currentPageWidth;
            if (!((currentPageWidth += (float)LayoutUnitConversionHelper.fileChar256ToPdfPoints(sheet.getColumnWidth(i), 7, 58)) >= this.totalAvailablePageWidth)) continue;
            autoColumnBreaks.add(--i);
            currentPageWidth = this.printHeadings ? StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH + (float)LayoutUnitConversionHelper.fileChar256ToPdfPoints(sheet.getColumnWidth(i), 7, 58) : 0.0f;
        }
        if (autoColumnBreaks.size() > 0) {
            this.colBreaks = PdfExporter.convertIntegers(autoColumnBreaks);
        }
    }

    private static int[] convertIntegers(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = integers.get(i);
        }
        return ret;
    }

    private void setDocumentPageProperties(Worksheet sheet) {
        this.printGridLines = sheet.isPrintGridlines();
        Font defFont = sheet.getWorkbook().getFontAt((short)0);
        this.documentStandardFont = FontFactory.getFont((String)defFont.getFontName());
        this.documentStandardFont.setSize(11.0f);
        this.documentStandardFont.setStyle(0);
        this.leftMargin = Utilities.inchesToPoints((float)((float)sheet.getMargin((short)0)));
        this.rightMargin = Utilities.inchesToPoints((float)((float)sheet.getMargin((short)1)));
        this.topMargin = Utilities.inchesToPoints((float)((float)sheet.getMargin((short)2)));
        this.bottomMargin = Utilities.inchesToPoints((float)((float)sheet.getMargin((short)3)));
        this.pgSize = PageSizeConversionUtil.getPageSize(sheet.getPrintSetup().getPaperSize());
        if (sheet.getPrintSetup().getLandscape()) {
            Rectangle r;
            this.pgSize = r = this.pgSize.rotate();
            this.document.setPageSize(r);
            this.headerFooterTotalWidth = r.getWidth() - (this.topMargin + this.bottomMargin);
        } else {
            this.document.setPageSize(this.pgSize);
            this.headerFooterTotalWidth = this.pgSize.getWidth() - (this.leftMargin + this.rightMargin);
        }
        this.totalAvailablePageWidth = this.pgSize.getRight() - this.rightMargin - (this.pgSize.getLeft() + this.leftMargin);
        this.totalAvailablePageHeight = this.pgSize.getTop() - this.topMargin - (this.pgSize.getBottom() + this.bottomMargin);
        this.setHeaderMargin((float)sheet.getPrintSetup().getHeaderMargin());
        this.setFooterMargin((float)sheet.getPrintSetup().getFooterMargin());
        this.document.setMargins(this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    private void printSelectedColumns(Worksheet sheet, int sheetIndex, int leftColumnBound, int rightColumnBound, AreaReference area) throws DocumentException {
        Map<String, int[]> currentSheetRepeatingRowsAndColumns = this.sheetsWithRepeatingRowsAndColumns.get(sheetIndex);
        int[] repeatingColumns = new int[]{-1, -1};
        boolean columnsOverlapRepeatingColumns = false;
        if (currentSheetRepeatingRowsAndColumns != null) {
            repeatingColumns = currentSheetRepeatingRowsAndColumns.get("Columns");
            if (leftColumnBound > repeatingColumns[0] && leftColumnBound <= repeatingColumns[1] + 1) {
                leftColumnBound = repeatingColumns[0];
                columnsOverlapRepeatingColumns = true;
            }
            if (rightColumnBound < repeatingColumns[1] && rightColumnBound >= repeatingColumns[0]) {
                rightColumnBound = repeatingColumns[1];
                columnsOverlapRepeatingColumns = true;
            } else if (rightColumnBound >= repeatingColumns[1] && leftColumnBound <= repeatingColumns[1]) {
                columnsOverlapRepeatingColumns = true;
            }
        }
        this.document.newPage();
        this.lastPageRowColumnBounds = new HashMap<String, Integer>(4);
        this.lastPageRowColumnBounds.put("rowTop", area.getFirstCell().getRow());
        this.lastPageRowColumnBounds.put("rowBottom", area.getLastCell().getRow());
        this.lastPageRowColumnBounds.put("columnLeft", leftColumnBound);
        this.lastPageRowColumnBounds.put("columnRight", rightColumnBound);
        ++this.pageCount;
        if (columnsOverlapRepeatingColumns) {
            this.printRowsWithOverlappingRepeatingColumns(sheet, sheetIndex, area.getFirstCell().getRow(), area.getLastCell().getRow(), leftColumnBound, rightColumnBound);
        } else {
            this.printRowsWithNonOverlappingRepeatingColumns(sheet, sheetIndex, area.getFirstCell().getRow(), area.getLastCell().getRow(), leftColumnBound, rightColumnBound, repeatingColumns[0], repeatingColumns[1]);
        }
    }

    private void printColumns(Worksheet sheet, int sheetIndex, int leftColumnBound, int rightColumnBound) throws DocumentException {
        int topRowBound = 0;
        Map<String, int[]> currentSheetRepeatingRowsAndColumns = this.sheetsWithRepeatingRowsAndColumns.get(sheetIndex);
        int[] repeatingColumns = new int[]{-1, -1};
        boolean columnsOverlapRepeatingColumns = false;
        if (currentSheetRepeatingRowsAndColumns != null) {
            repeatingColumns = currentSheetRepeatingRowsAndColumns.get("Columns");
            if (leftColumnBound > repeatingColumns[0] && leftColumnBound <= repeatingColumns[1] + 1) {
                leftColumnBound = repeatingColumns[0];
                columnsOverlapRepeatingColumns = true;
            }
            if (rightColumnBound < repeatingColumns[1] && rightColumnBound >= repeatingColumns[0]) {
                rightColumnBound = repeatingColumns[1];
                columnsOverlapRepeatingColumns = true;
            } else if (rightColumnBound >= repeatingColumns[1] && leftColumnBound <= repeatingColumns[1]) {
                columnsOverlapRepeatingColumns = true;
            }
        }
        for (int i = 0; i < this.rowBreaks.length; ++i) {
            this.document.newPage();
            this.lastPageRowColumnBounds = new HashMap<String, Integer>(4);
            this.lastPageRowColumnBounds.put("rowTop", topRowBound);
            this.lastPageRowColumnBounds.put("rowBottom", this.rowBreaks[i]);
            this.lastPageRowColumnBounds.put("columnLeft", leftColumnBound);
            this.lastPageRowColumnBounds.put("columnRight", rightColumnBound);
            ++this.pageCount;
            if (columnsOverlapRepeatingColumns) {
                this.printRowsWithOverlappingRepeatingColumns(sheet, sheetIndex, topRowBound, this.rowBreaks[i], leftColumnBound, rightColumnBound);
            } else {
                this.printRowsWithNonOverlappingRepeatingColumns(sheet, sheetIndex, topRowBound, this.rowBreaks[i], leftColumnBound, rightColumnBound, repeatingColumns[0], repeatingColumns[1]);
            }
            topRowBound = this.rowBreaks[i] + 1;
        }
        if (topRowBound <= this.endRow) {
            ++this.pageCount;
            this.document.newPage();
            this.lastPageRowColumnBounds = new HashMap<String, Integer>(4);
            this.lastPageRowColumnBounds.put("rowTop", topRowBound);
            this.lastPageRowColumnBounds.put("rowBottom", sheet.getLastRowNum());
            this.lastPageRowColumnBounds.put("columnLeft", leftColumnBound);
            this.lastPageRowColumnBounds.put("columnRight", rightColumnBound);
            if (columnsOverlapRepeatingColumns) {
                this.printRowsWithOverlappingRepeatingColumns(sheet, sheetIndex, topRowBound, this.endRow, leftColumnBound, rightColumnBound);
            } else {
                this.printRowsWithNonOverlappingRepeatingColumns(sheet, sheetIndex, topRowBound, this.endRow, leftColumnBound, rightColumnBound, repeatingColumns[0], repeatingColumns[1]);
            }
        }
    }

    private void printRowsWithNonOverlappingRepeatingColumns(Worksheet sheet, int sheetIndex, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound, int repeatingColumnStart, int repeatingColumnEnd) throws DocumentException {
        Map<String, int[]> currentSheetRepeatingRowsAndColumns = this.sheetsWithRepeatingRowsAndColumns.get(sheetIndex);
        int[] repeatingRows = new int[]{-1, -1};
        boolean rowsOverlapRepeatingRows = false;
        if (currentSheetRepeatingRowsAndColumns != null) {
            repeatingRows = currentSheetRepeatingRowsAndColumns.get("Rows");
            if (topRowBound > repeatingRows[0] && topRowBound <= repeatingRows[1] + 1) {
                topRowBound = repeatingRows[0];
                rowsOverlapRepeatingRows = true;
            }
            if (bottomRowBound < repeatingRows[1] && bottomRowBound >= repeatingRows[0]) {
                bottomRowBound = repeatingRows[1];
                rowsOverlapRepeatingRows = true;
            } else if (bottomRowBound >= repeatingRows[1] && topRowBound <= repeatingRows[1]) {
                rowsOverlapRepeatingRows = true;
            }
        }
        int numOfColumns = rightColumnBound - leftColumnBound == 0 ? 1 : rightColumnBound - leftColumnBound + 1;
        int numOfRepeatingColumns = 0;
        if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
            numOfRepeatingColumns = repeatingColumnEnd - repeatingColumnStart == 0 ? 1 : repeatingColumnEnd - repeatingColumnStart + 1;
        }
        PdfPTable table = this.createPdfTableWithNonOverlappingColumns(numOfColumns + numOfRepeatingColumns, sheet, leftColumnBound, rightColumnBound, repeatingColumnStart, repeatingColumnEnd);
        if (rowsOverlapRepeatingRows) {
            this.printOverlappingRowsWithNonOverlappingRepeatingColumns(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, repeatingColumnStart, repeatingColumnEnd, table);
        } else {
            this.printNonOverlappingRowsWithNonOverlappingRepeatingColumns(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, repeatingColumnStart, repeatingColumnEnd, table, repeatingRows[0], repeatingRows[1]);
        }
        table.setHorizontalAlignment(0);
        this.document.add((Element)table);
    }

    private void printNonOverlappingRowsWithNonOverlappingRepeatingColumns(Worksheet sheet, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound, int repeatingColumnStart, int repeatingColumnEnd, PdfPTable table, int repeatingRowsStart, int repeatingRowsEnd) {
        float rowHeight;
        Row currentRow;
        int rowIndex;
        if (repeatingRowsStart != -1 && repeatingRowsEnd != -1) {
            for (rowIndex = repeatingRowsStart; rowIndex <= repeatingRowsEnd; ++rowIndex) {
                currentRow = sheet.getRow(rowIndex);
                if (this.printHeadings) {
                    PdfPCell cell = new PdfPCell(new Phrase("" + (rowIndex + 1), this.documentStandardFont));
                    cell.setBorderWidth(0.7f);
                    cell.setVerticalAlignment(6);
                    cell.setHorizontalAlignment(1);
                    table.addCell(cell);
                }
                if (currentRow != null) {
                    rowHeight = LayoutUnitConversionHelper.twipsToPdfPoints(currentRow.getHeight(), 53);
                    if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
                        this.printCells(sheet, repeatingRowsStart, repeatingRowsEnd, repeatingColumnStart, repeatingColumnEnd, table, rowIndex, currentRow, rowHeight);
                    }
                    this.printCells(sheet, repeatingRowsStart, repeatingRowsEnd, leftColumnBound, rightColumnBound, table, rowIndex, currentRow, rowHeight);
                    continue;
                }
                rowHeight = LayoutUnitConversionHelper.twipsToPdfPoints(sheet.getDefaultRowHeight(), 53);
                if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
                    this.printEmptyCells(repeatingRowsStart, repeatingRowsEnd, repeatingColumnStart, repeatingColumnEnd, table, rowIndex, rowHeight, sheet);
                }
                this.printEmptyCells(repeatingRowsStart, repeatingRowsEnd, leftColumnBound, rightColumnBound, table, rowIndex, rowHeight, sheet);
            }
        }
        for (rowIndex = topRowBound; rowIndex <= bottomRowBound; ++rowIndex) {
            currentRow = sheet.getRow(rowIndex);
            if (this.printHeadings) {
                PdfPCell cell = new PdfPCell(new Phrase("" + (rowIndex + 1), this.documentStandardFont));
                cell.setBorderWidth(0.7f);
                cell.setVerticalAlignment(6);
                cell.setHorizontalAlignment(1);
                table.addCell(cell);
            }
            if (currentRow != null) {
                rowHeight = LayoutUnitConversionHelper.twipsToPdfPoints(currentRow.getHeight(), 53);
                if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
                    this.printCells(sheet, topRowBound, bottomRowBound, repeatingColumnStart, repeatingColumnEnd, table, rowIndex, currentRow, rowHeight);
                }
                this.printCells(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, currentRow, rowHeight);
                continue;
            }
            rowHeight = LayoutUnitConversionHelper.twipsToPdfPoints(sheet.getDefaultRowHeight(), 53);
            if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
                this.printEmptyCells(topRowBound, bottomRowBound, repeatingColumnStart, repeatingColumnEnd, table, rowIndex, rowHeight, sheet);
            }
            this.printEmptyCells(topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, rowHeight, sheet);
        }
    }

    private void printOverlappingRowsWithNonOverlappingRepeatingColumns(Worksheet sheet, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound, int repeatingColumnStart, int repeatingColumnEnd, PdfPTable table) {
        for (int rowIndex = topRowBound; rowIndex <= bottomRowBound; ++rowIndex) {
            float rowHeight;
            Row currentRow = sheet.getRow(rowIndex);
            if (this.printHeadings) {
                PdfPCell cell = new PdfPCell(new Phrase("" + (rowIndex + 1), this.documentStandardFont));
                cell.setBorderWidth(0.7f);
                cell.setVerticalAlignment(6);
                cell.setHorizontalAlignment(1);
                table.addCell(cell);
            }
            if (currentRow != null) {
                rowHeight = LayoutUnitConversionHelper.twipsToPdfPoints(currentRow.getHeight(), 53);
                if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
                    this.printCells(sheet, topRowBound, bottomRowBound, repeatingColumnStart, repeatingColumnEnd, table, rowIndex, currentRow, rowHeight);
                }
                this.printCells(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, currentRow, rowHeight);
                continue;
            }
            rowHeight = LayoutUnitConversionHelper.twipsToPdfPoints(sheet.getDefaultRowHeight(), 53);
            if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
                this.printEmptyCells(topRowBound, bottomRowBound, repeatingColumnStart, repeatingColumnEnd, table, rowIndex, rowHeight, sheet);
            }
            this.printEmptyCells(topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, rowHeight, sheet);
        }
    }

    private void printEmptyCells(int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound, PdfPTable table, int rowIndex, float rowHeight, Worksheet sheet) {
        boolean isTopBound = topRowBound == rowIndex;
        for (int columnIndex = leftColumnBound; columnIndex <= rightColumnBound; ++columnIndex) {
            boolean isLeftBound = leftColumnBound == columnIndex;
            PdfPCell cell = this.createPdfCell(rowIndex, columnIndex, null, isTopBound, isLeftBound, sheet);
            cell.setBorder(0);
            cell.setFixedHeight(rowHeight);
            table.addCell(cell);
        }
    }

    private void printCells(Worksheet sheet, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound, PdfPTable table, int rowIndex, Row currentRow, float rowHeight) {
        boolean isTopBound = topRowBound == rowIndex;
        for (int columnIndex = leftColumnBound; columnIndex <= rightColumnBound; ++columnIndex) {
            boolean isLeftBound;
            Cell currentCell = currentRow.getCell(columnIndex);
            PdfPCell cell = null;
            boolean bl = isLeftBound = leftColumnBound == columnIndex;
            if (currentCell != null) {
                cell = this.createPdfCell(rowIndex, columnIndex, currentCell, isTopBound, isLeftBound, sheet);
                cell.setBorder(0);
                cell.setFixedHeight(rowHeight);
                CellRangeAddress mergedRegionRange = this.getMergedRegionIfAny(sheet, currentCell);
                if (mergedRegionRange != null) {
                    int colSpan = mergedRegionRange.getLastColumn() - columnIndex + 1;
                    cell.setColspan(colSpan);
                    table.addCell(cell);
                    columnIndex = mergedRegionRange.getLastColumn();
                    continue;
                }
                table.addCell(cell);
                continue;
            }
            cell = this.createPdfCell(rowIndex, columnIndex, null, isTopBound, isLeftBound, sheet);
            cell.setBorder(0);
            cell.setFixedHeight(rowHeight);
            table.addCell(cell);
        }
    }

    private void printRowsWithOverlappingRepeatingColumns(Worksheet sheet, int sheetIndex, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound) throws DocumentException {
        Map<String, int[]> currentSheetRepeatingRowsAndColumns = this.sheetsWithRepeatingRowsAndColumns.get(sheetIndex);
        int[] repeatingRows = null;
        boolean rowsOverlapRepeatingRows = false;
        if (currentSheetRepeatingRowsAndColumns != null) {
            repeatingRows = currentSheetRepeatingRowsAndColumns.get("Rows");
            if (topRowBound > repeatingRows[0] && topRowBound <= repeatingRows[1] + 1) {
                topRowBound = repeatingRows[0];
                rowsOverlapRepeatingRows = true;
            }
            if (bottomRowBound < repeatingRows[1] && bottomRowBound >= repeatingRows[0]) {
                bottomRowBound = repeatingRows[1];
                rowsOverlapRepeatingRows = true;
            } else if (bottomRowBound >= repeatingRows[1] && topRowBound <= repeatingRows[1]) {
                rowsOverlapRepeatingRows = true;
            }
        }
        int numOfColumns = rightColumnBound - leftColumnBound == 0 ? 1 : rightColumnBound - leftColumnBound + 1;
        PdfPTable table = this.createPdfTable(numOfColumns, sheet, leftColumnBound, rightColumnBound);
        if (rowsOverlapRepeatingRows) {
            this.printOverlappingRowsWithOverlappingRepeatingColumns(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table);
        } else {
            this.printNonOverlappingRowsWithOverlappingRepeatingColumns(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, repeatingRows[0], repeatingRows[1]);
        }
        table.setHorizontalAlignment(0);
        this.document.add((Element)table);
    }

    private void layoverImagesIfAny(Worksheet sheet, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound) {
        PdfContentByte canvas = this.writer.getDirectContent();
        for (Picture picture : this.pictures) {
            ClientAnchor anchor;
            if (picture == null || (anchor = picture.getClientAnchor()).getCol1() < leftColumnBound || anchor.getCol2() > rightColumnBound + 1 || picture == null) continue;
            PictureData picdata = picture.getPictureData();
            try {
                Image image = Image.getInstance((byte[])picdata.getData());
                int charWidth = this.wb.getDefaultCharWidth();
                int left = Utils.getLeftFraction((Worksheet)sheet, (ClientAnchor)anchor, (int)charWidth);
                int top = Utils.getTopFraction((Worksheet)sheet, (ClientAnchor)anchor);
                int rightOffset = this.getRightFraction(sheet, anchor, charWidth);
                int bottomOffset = this.getBottomFraction(sheet, anchor, charWidth);
                float imageX1 = this.leftMargin + this.columnLeft[anchor.getCol1()] + (float)LayoutUnitConversionHelper.pxToPdfPoints(left, 58);
                float imageX2 = this.leftMargin + this.columnLeft[anchor.getCol2()] + (float)LayoutUnitConversionHelper.pxToPdfPoints(rightOffset, 58);
                float imageY1 = this.pgSize.getTop() - (this.topMargin + this.rowTop[anchor.getRow1()] + (float)top);
                float imageY2 = this.pgSize.getTop() - (this.topMargin + this.rowTop[anchor.getRow2() - 1]) + (float)bottomOffset;
                float width = imageX2 - imageX1;
                float height = imageY1 - imageY2;
                image.scaleAbsolute(width, height);
                image.setAbsolutePosition(imageX1, imageY2);
                canvas.addImage(image);
            }
            catch (BadElementException e) {
            }
            catch (MalformedURLException e) {
            }
            catch (IOException e) {
            }
            catch (DocumentException e) {}
        }
    }

    private int getRightFraction(Worksheet zkSheet, ClientAnchor anchor, int charWidth) {
        short l = anchor.getCol2();
        int lfrc = anchor.getDx2();
        int lw = Utils.getWidthAny((Worksheet)zkSheet, (int)l, (int)charWidth);
        return lfrc >= 1024 ? lw : lw * lfrc / 1024;
    }

    private int getBottomFraction(Worksheet zkSheet, ClientAnchor anchor, int charWidth) {
        int t = anchor.getRow1();
        int tfrc = anchor.getDy1();
        int th = Utils.getHeightAny((Worksheet)zkSheet, (int)t);
        return tfrc >= 256 ? th : th * tfrc / 256;
    }

    private void layoutCharts(Worksheet sheet, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound) {
        List charts = this._dm.getChartXs();
        if (charts == null || charts.size() == 0) {
            return;
        }
        for (ZssChartX chart : charts) {
            ClientAnchor anchor = chart.getPreferredSize();
            if (anchor.getCol1() < leftColumnBound || anchor.getCol2() > rightColumnBound + 1 || anchor.getRow1() < topRowBound || anchor.getRow2() > bottomRowBound) continue;
            Chart zchart = sheet instanceof HSSFSheet ? ChartHelper.createChart((ChartInfo)chart.getChartInfo()) : ChartHelper.createChart((org.zkoss.poi.ss.usermodel.Chart)chart.getChart());
            this.initChart(zchart, sheet, chart);
            try {
                Image image = Image.getInstance((byte[])zchart.getEngine().drawChart((Object)zchart));
                int charWidth = this.wb.getDefaultCharWidth();
                int left = Utils.getLeftFraction((Worksheet)sheet, (ClientAnchor)anchor, (int)charWidth);
                int top = Utils.getTopFraction((Worksheet)sheet, (ClientAnchor)anchor);
                int rightOffset = this.getRightFraction(sheet, anchor, charWidth);
                int bottomOffset = this.getBottomFraction(sheet, anchor, charWidth);
                float imageX1 = this.leftMargin + this.columnLeft[anchor.getCol1()] + (float)LayoutUnitConversionHelper.pxToPdfPoints(left, 58);
                float imageX2 = this.leftMargin + this.columnLeft[anchor.getCol2()] + (float)LayoutUnitConversionHelper.pxToPdfPoints(rightOffset, 58);
                float imageY1 = this.pgSize.getTop() - (this.topMargin + this.rowTop[anchor.getRow1()] + (float)top);
                float imageY2 = this.pgSize.getTop() - (this.topMargin + this.rowTop[anchor.getRow2() - 1]) + (float)bottomOffset;
                float width = imageX2 - imageX1;
                float height = imageY1 - imageY2;
                image.scaleAbsolute(width, height);
                image.setAbsolutePosition(imageX1, imageY2);
                PdfContentByte canvas = this.writer.getDirectContent();
                canvas.addImage(image);
            }
            catch (UiException e1) {
            }
            catch (BadElementException e1) {
            }
            catch (MalformedURLException e1) {
            }
            catch (IOException e1) {
            }
            catch (DocumentException e) {}
        }
    }

    private void initChart(Chart zchart, Worksheet sheet, ZssChartX poiChart) {
        ChartHelper.drawChart((ChartDrawer)this, (Chart)zchart, (Worksheet)sheet, (ZssChartX)poiChart);
    }

    private void initUpdateAreaReference() {
        this._outcol1 = Integer.MAX_VALUE;
        this._outrow1 = Integer.MAX_VALUE;
        this._outcol2 = Integer.MIN_VALUE;
        this._outrow2 = Integer.MIN_VALUE;
    }

    public void prepareUpdateAreaReference(int col1, int row1, int col2, int row2) {
        if (this._outcol1 > col1) {
            this._outcol1 = col1;
        }
        if (this._outcol2 < col2) {
            this._outcol2 = col2;
        }
        if (this._outrow1 > row1) {
            this._outrow1 = row1;
        }
        if (this._outrow2 < row2) {
            this._outrow2 = row2;
        }
    }

    private void printNonOverlappingRowsWithOverlappingRepeatingColumns(Worksheet sheet, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound, PdfPTable table, int repeatingRowsStart, int repeatingRowsEnd) {
        float rowHeight;
        Row currentRow;
        int rowIndex;
        for (rowIndex = repeatingRowsStart; rowIndex <= repeatingRowsEnd; ++rowIndex) {
            currentRow = sheet.getRow(rowIndex);
            if (this.printHeadings) {
                PdfPCell cell = new PdfPCell(new Phrase("" + (rowIndex + 1), this.documentStandardFont));
                cell.setBorderWidth(0.7f);
                cell.setVerticalAlignment(6);
                cell.setHorizontalAlignment(1);
                table.addCell(cell);
            }
            if (currentRow != null) {
                rowHeight = LayoutUnitConversionHelper.twipsToPdfPoints(currentRow.getHeight(), 53);
                this.printCells(sheet, repeatingRowsStart, repeatingRowsEnd, leftColumnBound, rightColumnBound, table, rowIndex, currentRow, rowHeight);
                continue;
            }
            rowHeight = LayoutUnitConversionHelper.twipsToPdfPoints(sheet.getDefaultRowHeight(), 53);
            this.printEmptyCells(repeatingRowsStart, repeatingRowsEnd, leftColumnBound, rightColumnBound, table, rowIndex, rowHeight, sheet);
        }
        for (rowIndex = topRowBound; rowIndex <= bottomRowBound; ++rowIndex) {
            currentRow = sheet.getRow(rowIndex);
            if (this.printHeadings) {
                PdfPCell cell = new PdfPCell(new Phrase("" + (rowIndex + 1), this.documentStandardFont));
                cell.setBorderWidth(0.7f);
                cell.setVerticalAlignment(6);
                cell.setHorizontalAlignment(1);
                table.addCell(cell);
            }
            if (currentRow != null) {
                rowHeight = LayoutUnitConversionHelper.twipsToPdfPoints(currentRow.getHeight(), 53);
                this.printCells(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, currentRow, rowHeight);
                continue;
            }
            rowHeight = LayoutUnitConversionHelper.twipsToPdfPoints(sheet.getDefaultRowHeight(), 53);
            this.printEmptyCells(topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, rowHeight, sheet);
        }
    }

    private void printOverlappingRowsWithOverlappingRepeatingColumns(Worksheet sheet, int topRowBound, int bottomRowBound, int leftColumnBound, int rightColumnBound, PdfPTable table) {
        for (int rowIndex = topRowBound; rowIndex <= bottomRowBound; ++rowIndex) {
            float rowHeight;
            Row currentRow = sheet.getRow(rowIndex);
            if (this.printHeadings) {
                PdfPCell cell = new PdfPCell(new Phrase("" + (rowIndex + 1), this.documentStandardFont));
                cell.setBorderWidth(0.7f);
                cell.setVerticalAlignment(6);
                cell.setHorizontalAlignment(1);
                table.addCell(cell);
            }
            if (currentRow != null) {
                rowHeight = LayoutUnitConversionHelper.twipsToPdfPoints(currentRow.getHeight(), 53);
                this.printCells(sheet, topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, currentRow, rowHeight);
                continue;
            }
            rowHeight = LayoutUnitConversionHelper.twipsToPdfPoints(sheet.getDefaultRowHeight(), 53);
            this.printEmptyCells(topRowBound, bottomRowBound, leftColumnBound, rightColumnBound, table, rowIndex, rowHeight, sheet);
        }
    }

    private CellRangeAddress getMergedRegionIfAny(Worksheet sheet, Cell cell) {
        CellRangeAddress partOfRange = null;
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            if (cell.getColumnIndex() < range.getFirstColumn() || cell.getColumnIndex() > range.getLastColumn() || cell.getRowIndex() < range.getFirstRow() || cell.getRowIndex() > range.getLastRow()) continue;
            partOfRange = range;
            break;
        }
        return partOfRange;
    }

    private boolean isPartOfMergedRegion(Worksheet sheet, Cell cell) {
        boolean partOfMergedRegion = false;
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            if (cell.getColumnIndex() < range.getFirstColumn() || cell.getColumnIndex() > range.getLastColumn() || cell.getRowIndex() < range.getFirstRow() || cell.getRowIndex() > range.getLastRow()) continue;
            partOfMergedRegion = true;
            break;
        }
        return partOfMergedRegion;
    }

    private PdfPTable createPdfTable(int numOfColumns, Worksheet sheet, int leftColumnBound, int rightColumnBound) throws DocumentException {
        PdfPTable pdfTable = null;
        int totalWidth = 0;
        float[] columnWidths = null;
        int columnWidthsIndex = 0;
        if (this.printHeadings) {
            pdfTable = new PdfPTable(numOfColumns + 1);
            totalWidth = (int)((float)totalWidth + StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH);
            columnWidths = new float[numOfColumns + 1];
            columnWidths[columnWidthsIndex++] = StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH;
        } else {
            pdfTable = new PdfPTable(numOfColumns);
            columnWidths = new float[numOfColumns];
        }
        int columnIndex = leftColumnBound;
        while (columnIndex <= rightColumnBound) {
            int columnWidth = sheet.getColumnWidth(columnIndex);
            int columnWidthInPoints = LayoutUnitConversionHelper.fileChar256ToPdfPoints(columnWidth, 7, 58);
            totalWidth += columnWidthInPoints;
            columnWidths[columnWidthsIndex] = columnWidthInPoints;
            ++columnIndex;
            ++columnWidthsIndex;
        }
        pdfTable.setWidths(columnWidths);
        pdfTable.setLockedWidth(true);
        pdfTable.setTotalWidth(columnWidths);
        pdfTable.setSpacingBefore(0.0f);
        pdfTable.setHorizontalAlignment(0);
        if (this.printHeadings) {
            PdfPCell cell = new PdfPCell(new Phrase(" ", this.documentStandardFont));
            cell.setBorderWidth(0.7f);
            pdfTable.addCell(cell);
            for (int columnIndex2 = leftColumnBound; columnIndex2 <= rightColumnBound; ++columnIndex2) {
                cell = new PdfPCell(new Phrase(CellReference.convertNumToColString((int)columnIndex2), this.documentStandardFont));
                cell.setBorderWidth(0.7f);
                cell.setHorizontalAlignment(1);
                pdfTable.addCell(cell);
            }
        }
        return pdfTable;
    }

    private PdfPTable createPdfTableWithNonOverlappingColumns(int numOfColumns, Worksheet sheet, int leftColumnBound, int rightColumnBound, int repeatingColumnStart, int repeatingColumnEnd) throws DocumentException {
        int columnWidthInPoints;
        int columnWidth;
        int columnIndex;
        PdfPTable pdfTable = null;
        int totalWidth = 0;
        float[] columnWidths = null;
        int columnWidthsIndex = 0;
        if (this.printHeadings) {
            pdfTable = new PdfPTable(numOfColumns + 1);
            totalWidth = (int)((float)totalWidth + StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH);
            columnWidths = new float[numOfColumns + 1];
            columnWidths[columnWidthsIndex++] = StyleConversionUtil.DEFAULT_ROW_HEADER_COLUMN_WIDTH;
        } else {
            pdfTable = new PdfPTable(numOfColumns);
            columnWidths = new float[numOfColumns];
        }
        if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
            columnIndex = repeatingColumnStart;
            while (columnIndex <= repeatingColumnEnd) {
                columnWidth = sheet.getColumnWidth(columnIndex);
                columnWidthInPoints = LayoutUnitConversionHelper.fileChar256ToPdfPoints(columnWidth, 7, 58);
                totalWidth += columnWidthInPoints;
                columnWidths[columnWidthsIndex] = columnWidthInPoints;
                ++columnIndex;
                ++columnWidthsIndex;
            }
        }
        columnIndex = leftColumnBound;
        while (columnIndex <= rightColumnBound) {
            columnWidth = sheet.getColumnWidth(columnIndex);
            columnWidthInPoints = LayoutUnitConversionHelper.fileChar256ToPdfPoints(columnWidth, 7, 58);
            totalWidth += columnWidthInPoints;
            columnWidths[columnWidthsIndex] = columnWidthInPoints;
            ++columnIndex;
            ++columnWidthsIndex;
        }
        pdfTable.setWidths(columnWidths);
        pdfTable.setLockedWidth(true);
        pdfTable.setTotalWidth(columnWidths);
        pdfTable.setSpacingBefore(0.0f);
        pdfTable.setHorizontalAlignment(0);
        if (this.printHeadings) {
            int columnIndex2;
            PdfPCell cell = new PdfPCell(new Phrase(" ", this.documentStandardFont));
            cell.setBorderWidth(0.7f);
            pdfTable.addCell(cell);
            if (repeatingColumnStart != -1 && repeatingColumnEnd != -1) {
                for (columnIndex2 = repeatingColumnStart; columnIndex2 <= repeatingColumnEnd; ++columnIndex2) {
                    cell = new PdfPCell(new Phrase(CellReference.convertNumToColString((int)columnIndex2), this.documentStandardFont));
                    cell.setBorderWidth(0.7f);
                    cell.setHorizontalAlignment(1);
                    pdfTable.addCell(cell);
                }
            }
            for (columnIndex2 = leftColumnBound; columnIndex2 <= rightColumnBound; ++columnIndex2) {
                cell = new PdfPCell(new Phrase(CellReference.convertNumToColString((int)columnIndex2), this.documentStandardFont));
                cell.setBorderWidth(0.7f);
                cell.setHorizontalAlignment(1);
                pdfTable.addCell(cell);
            }
        }
        return pdfTable;
    }

    private PdfPCell createPdfCell(int rowIndex, int colIndex, Cell poiCell, boolean isTopBound, boolean isLeftBound, Worksheet sheet) {
        PdfPCell cell = null;
        if (poiCell != null) {
            CellStyle style = poiCell.getCellStyle();
            Phrase p = this.createPhrase(poiCell);
            cell = new PdfPCell(p);
            cell.setPadding(0.0f);
            cell.setPaddingLeft(2.5f);
            cell.setPaddingRight(2.5f);
            cell.setPaddingBottom(2.5f);
            cell.setHorizontalAlignment(StyleConversionUtil.getCorrespondingPdfPCellAlignment((short)BookHelper.getRealAlignment((Cell)poiCell)));
            cell.setVerticalAlignment(StyleConversionUtil.getCorrespondingPdfPCellVerticalAlignment(style.getVerticalAlignment()));
            Color color = style.getFillPattern() != 0 ? style.getFillForegroundColorColor() : null;
            BaseColor baseColor = BaseColor.WHITE;
            if (color != null) {
                String sColor = BookHelper.colorToHTML((Workbook)this.wb, (Color)color);
                baseColor = WebColors.getRGBColor((String)(sColor == null || "AUTO_COLOR".equals(sColor) ? "WHITE" : sColor));
                cell.setBackgroundColor(baseColor);
            }
            cell.setCellEvent((PdfPCellEvent)BorderDrawEvent.getCellEvent(rowIndex, colIndex, poiCell, style, this.printGridLines, isTopBound, isLeftBound, sheet, (Workbook)this.wb));
        } else {
            cell = new PdfPCell(new Phrase(" ", this.documentStandardFont));
            cell.setPadding(0.0f);
            cell.setPaddingLeft(2.5f);
            cell.setHorizontalAlignment(-1);
            cell.setVerticalAlignment(7);
            cell.setCellEvent((PdfPCellEvent)BorderDrawEvent.getCellEvent(rowIndex, colIndex, null, null, this.printGridLines, isTopBound, isLeftBound, sheet, (Workbook)this.wb));
        }
        return cell;
    }

    private Phrase createPhrase(Cell poiCell) {
        FormatText ft;
        String text = "";
        Phrase p = null;
        CellStyle style = poiCell.getCellStyle();
        if (poiCell != null && (ft = Utils.getFormatText((Cell)poiCell)) != null) {
            p = new Phrase();
            if (ft.isRichTextString()) {
                RichTextString rstr = ft.getRichTextString();
                p = new Phrase();
                String cellValue = poiCell.getStringCellValue();
                if (rstr.numFormattingRuns() > 0) {
                    for (int i = 0; i < rstr.numFormattingRuns(); ++i) {
                        Font poiCellFont = this.getFont(this.wb, rstr, i);
                        Color fontColor = BookHelper.getFontColor((Workbook)this.wb, (Font)poiCellFont);
                        BaseColor fontBaseColor = BaseColor.BLACK;
                        com.itextpdf.text.Font cellFont = FontFactory.getFont((String)poiCellFont.getFontName());
                        if (fontColor != null) {
                            fontBaseColor = WebColors.getRGBColor((String)BookHelper.colorToHTML((Workbook)this.wb, (Color)fontColor));
                            cellFont.setColor(fontBaseColor);
                        }
                        cellFont.setSize((float)poiCellFont.getFontHeightInPoints());
                        if (poiCellFont.getItalic()) {
                            cellFont.setStyle(2);
                        }
                        if (poiCellFont.getUnderline() != 0) {
                            cellFont.setStyle(4);
                        }
                        if (poiCellFont.getStrikeout()) {
                            cellFont.setStyle(8);
                        }
                        int nextFormattingRunIndex = i + 1 >= rstr.numFormattingRuns() ? cellValue.length() : rstr.getIndexOfFormattingRun(i + 1);
                        Chunk c = new Chunk(cellValue.substring(rstr.getIndexOfFormattingRun(i), nextFormattingRunIndex), cellFont);
                        p.add((Element)c);
                    }
                } else {
                    com.itextpdf.text.Font cellFont = this.getPdfCellFont(style);
                    p = new Phrase(0.0f, cellValue, cellFont);
                }
            } else if (ft.isCellFormatResult()) {
                text = ft.getCellFormatResult().text;
                java.awt.Color color = ft.getCellFormatResult().textColor;
                com.itextpdf.text.Font cellFont = this.getPdfCellFont(style);
                if (color != null) {
                    String sColor = BookHelper.awtColorToHTMLColor((java.awt.Color)color);
                    BaseColor fontBaseColor = WebColors.getRGBColor((String)(sColor == null || "AUTO_COLOR".equals(sColor) ? "BLACK" : sColor));
                    cellFont.setColor(fontBaseColor);
                }
                p = new Phrase(0.0f, text, cellFont);
            }
        }
        return p;
    }

    private Font getFont(Book book, RichTextString rstr, int run) {
        return rstr instanceof HSSFRichTextString ? book.getFontAt(((HSSFRichTextString)rstr).getFontOfFormattingRun(run)) : ((XSSFRichTextString)rstr).getFontOfFormattingRun(run);
    }

    private com.itextpdf.text.Font getPdfCellFont(CellStyle style) {
        Font poiCellFont = this.wb.getFontAt(style.getFontIndex());
        Color fontColor = BookHelper.getFontColor((Workbook)this.wb, (Font)poiCellFont);
        com.itextpdf.text.Font cellFont = FontFactory.getFont((String)poiCellFont.getFontName());
        BaseColor fontBaseColor = null;
        if (fontColor != null) {
            String sColor = BookHelper.colorToHTML((Workbook)this.wb, (Color)fontColor);
            fontBaseColor = WebColors.getRGBColor((String)(sColor == null || "AUTO_COLOR".equals(sColor) ? "BLACK" : sColor));
            cellFont.setColor(fontBaseColor);
        }
        cellFont.setSize((float)poiCellFont.getFontHeightInPoints());
        return cellFont;
    }

    private int searchEndColumn(Row row) {
        int last = -1;
        for (int i = row.getLastCellNum(); i > 0; --i) {
            Cell cell = row.getCell(i);
            if (cell == null || cell.getCellType() == 3) continue;
            last = i;
            break;
        }
        return last;
    }

    private void initSheetRowColumnBounds(Worksheet sheet) {
        List charts;
        Iterator iter = sheet.rowIterator();
        this.firstColumn = 0;
        this.endColumn = 0;
        this.endRow = 0;
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            short firstCell = row.getFirstCellNum();
            if (firstCell < 0) continue;
            this.firstColumn = Math.min(this.firstColumn, firstCell);
            int lastCol = this.searchEndColumn(row);
            this.endColumn = Math.max(this.endColumn, lastCol);
            if (lastCol < 0) continue;
            this.endRow = Math.max(this.endRow, row.getRowNum());
        }
        --this.endColumn;
        List pics = this._dm.getPictures();
        if (pics != null && pics.size() != 0) {
            for (Picture pic : pics) {
                ClientAnchor anchor = pic.getClientAnchor();
                if (anchor.getCol2() > this.endColumn) {
                    this.endColumn = anchor.getCol2();
                }
                if (anchor.getRow2() <= this.endRow) continue;
                this.endRow = anchor.getRow2() - 1;
            }
        }
        if ((charts = this._dm.getChartXs()) != null && charts.size() != 0) {
            for (ZssChartX chart : charts) {
                ClientAnchor anchor = chart.getPreferredSize();
                if (anchor.getCol2() > this.endColumn) {
                    this.endColumn = anchor.getCol2();
                }
                if (anchor.getRow2() <= this.endRow) continue;
                this.endRow = anchor.getRow2() - 1;
            }
        }
    }

    public void enableGridLines(boolean enable) {
        this.printGridLines = enable;
    }

    public void enableHeadings(boolean enable) {
        this.printHeadings = enable;
    }

    private void setHeaderMargin(float inches) {
        this.headerMargin = Utilities.inchesToPoints((float)inches);
    }

    private void setFooterMargin(float inches) {
        this.footerMargin = Utilities.inchesToPoints((float)inches);
    }

    private void setRepeatingRowsAndColumns(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        int[] repeatingColumns = new int[]{startColumn, endColumn};
        int[] repeatingRows = new int[]{startRow, endRow};
        HashMap<String, int[]> hm = new HashMap<String, int[]>(2);
        hm.put("Columns", repeatingColumns);
        hm.put("Rows", repeatingRows);
        this.sheetsWithRepeatingRowsAndColumns.put(sheetIndex, hm);
    }

    public boolean prepareChart(Chart chart, ChartModel model, ChartInfo chartInfo) {
        return false;
    }

    public boolean prepareChart(Chart chart, ChartModel model, org.zkoss.poi.ss.usermodel.Chart poiChart) {
        return false;
    }

    class PdfHeaderFooter
    extends PdfPageEventHelper {
        PdfHeaderFooter() {
        }

        public void onOpenDocument(PdfWriter pdfWriter, Document doc) {
        }

        public void onStartPage(PdfWriter pdfWriter, Document doc) {
            PdfExporter.this.pageNumber++;
        }

        public void onEndPage(PdfWriter pdfWriter, Document doc) {
            Rectangle rect = PdfExporter.this.writer.getBoxSize("art");
            PdfPTable leftHeader = new PdfPTable(1);
            PdfPTable centerHeader = new PdfPTable(1);
            PdfPTable rightHeader = new PdfPTable(1);
            leftHeader.setTotalWidth(PdfExporter.this.headerFooterTotalWidth / 3.0f);
            centerHeader.setTotalWidth(PdfExporter.this.headerFooterTotalWidth / 3.0f);
            rightHeader.setTotalWidth(PdfExporter.this.headerFooterTotalWidth / 3.0f);
            PdfPCell left = new PdfPCell(new Phrase(PdfExporter.this.header.getLeft(), PdfExporter.this.documentStandardFont));
            left.setPaddingLeft(2.5f);
            left.setHorizontalAlignment(0);
            left.setBorder(0);
            leftHeader.setHorizontalAlignment(0);
            leftHeader.addCell(left);
            PdfPCell center = new PdfPCell(new Phrase(PdfExporter.this.header.getCenter(), PdfExporter.this.documentStandardFont));
            center.setPaddingLeft(2.5f);
            center.setHorizontalAlignment(1);
            center.setBorder(0);
            centerHeader.setHorizontalAlignment(5);
            centerHeader.addCell(center);
            PdfPCell right = new PdfPCell(new Phrase(PdfExporter.this.header.getRight(), PdfExporter.this.documentStandardFont));
            right.setPaddingLeft(2.5f);
            right.setHorizontalAlignment(2);
            right.setBorder(0);
            rightHeader.setHorizontalAlignment(2);
            rightHeader.addCell(right);
            leftHeader.writeSelectedRows(0, 1, PdfExporter.this.leftMargin, rect.getTop() - PdfExporter.this.topMargin + leftHeader.getTotalHeight() + PdfExporter.this.headerMargin, PdfExporter.this.writer.getDirectContent());
            centerHeader.writeSelectedRows(0, 1, PdfExporter.this.leftMargin + leftHeader.getTotalWidth(), rect.getTop() - PdfExporter.this.topMargin + centerHeader.getTotalHeight() + PdfExporter.this.headerMargin, PdfExporter.this.writer.getDirectContent());
            rightHeader.writeSelectedRows(0, 1, PdfExporter.this.leftMargin + leftHeader.getTotalWidth() + centerHeader.getTotalWidth(), rect.getTop() - PdfExporter.this.topMargin + rightHeader.getTotalHeight() + PdfExporter.this.headerMargin, PdfExporter.this.writer.getDirectContent());
            PdfPTable leftFooter = new PdfPTable(1);
            PdfPTable centerFooter = new PdfPTable(1);
            PdfPTable rightFooter = new PdfPTable(1);
            leftFooter.setTotalWidth(PdfExporter.this.headerFooterTotalWidth / 3.0f);
            centerFooter.setTotalWidth(PdfExporter.this.headerFooterTotalWidth / 3.0f);
            rightFooter.setTotalWidth(PdfExporter.this.headerFooterTotalWidth / 3.0f);
            PdfPCell fLeft = new PdfPCell(new Phrase(PdfExporter.this.footer.getLeft(), PdfExporter.this.documentStandardFont));
            fLeft.setPaddingLeft(2.5f);
            fLeft.setHorizontalAlignment(0);
            fLeft.setBorder(0);
            leftFooter.setHorizontalAlignment(0);
            leftFooter.addCell(fLeft);
            PdfPCell fCenter = new PdfPCell(new Phrase(PdfExporter.this.footer.getCenter(), PdfExporter.this.documentStandardFont));
            fCenter.setPaddingLeft(2.5f);
            fCenter.setHorizontalAlignment(1);
            fCenter.setBorder(0);
            centerFooter.setHorizontalAlignment(5);
            centerFooter.addCell(fCenter);
            PdfPCell fRight = new PdfPCell(new Phrase(PdfExporter.this.footer.getRight(), PdfExporter.this.documentStandardFont));
            fRight.setPaddingLeft(2.5f);
            fRight.setHorizontalAlignment(2);
            fRight.setBorder(0);
            rightFooter.setHorizontalAlignment(2);
            rightFooter.addCell(fRight);
            leftFooter.writeSelectedRows(0, 1, PdfExporter.this.leftMargin, rect.getBottom() + PdfExporter.this.bottomMargin - PdfExporter.this.footerMargin, PdfExporter.this.writer.getDirectContent());
            centerFooter.writeSelectedRows(0, 1, PdfExporter.this.leftMargin + leftFooter.getTotalWidth(), rect.getBottom() + PdfExporter.this.bottomMargin - PdfExporter.this.footerMargin, PdfExporter.this.writer.getDirectContent());
            rightFooter.writeSelectedRows(0, 1, PdfExporter.this.leftMargin + leftFooter.getTotalWidth() + centerFooter.getTotalWidth(), rect.getBottom() + PdfExporter.this.bottomMargin - PdfExporter.this.footerMargin, PdfExporter.this.writer.getDirectContent());
            PdfExporter.this.layoverImagesIfAny(PdfExporter.this.wb.getWorksheetAt(PdfExporter.this.currentSheetIndex), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("rowTop"), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("rowBottom"), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("columnLeft"), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("columnRight"));
            PdfExporter.this.layoutCharts(PdfExporter.this.wb.getWorksheetAt(PdfExporter.this.currentSheetIndex), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("rowTop"), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("rowBottom"), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("columnLeft"), (Integer)PdfExporter.this.lastPageRowColumnBounds.get("columnRight"));
        }
    }
}

