/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.html.WebColors;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPCellEvent;
import org.zkoss.poi.ss.usermodel.Cell;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.Color;
import org.zkoss.poi.ss.usermodel.Workbook;
import org.zkoss.zss.model.Worksheet;
import org.zkoss.zss.model.impl.BookHelper;
import org.zkoss.zss.model.impl.pdf.BorderStyle;
import org.zkoss.zss.model.impl.pdf.StyleConversionUtil;
import org.zkoss.zss.ui.impl.Utils;

class BorderDrawEvent
implements PdfPCellEvent {
    private CellStyle style;
    private Cell poiCell;
    private int rowIndex;
    private int columnIndex;
    private Worksheet sheet;
    private boolean isTopBound;
    private boolean isLeftBound;
    private boolean printGridLines;
    private final Workbook wb;

    public Cell getPoiCell() {
        return this.poiCell;
    }

    public void setPoiCell(Cell poiCell) {
        this.poiCell = poiCell;
    }

    private BorderDrawEvent(Workbook wb, Worksheet sheet, int rowIndex, int columnIndex, boolean isTopBound, boolean isLeftBound) {
        this.wb = wb;
        this.sheet = sheet;
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.isTopBound = isTopBound;
        this.isLeftBound = isLeftBound;
    }

    public static BorderDrawEvent getCellEvent(int rowIndex, int colIndex, Cell poiCell, CellStyle style, boolean printGridLines, boolean isTopBound, boolean isLeftBound, Worksheet sheet, Workbook wb) {
        BorderDrawEvent event = new BorderDrawEvent(wb, sheet, rowIndex, colIndex, isTopBound, isLeftBound);
        event.setPoiCell(poiCell);
        event.setStyle(style);
        event.setPrintGridLines(printGridLines);
        return event;
    }

    public void cellLayout(PdfPCell cell, Rectangle rect, PdfContentByte[] canvases) {
        PdfContentByte lineCanvas = canvases[2];
        lineCanvas.setLineJoin(0);
        this.processBottomBorder(rect, lineCanvas);
        this.processRightBorder(rect, lineCanvas);
        this.processTopBorder(rect, lineCanvas);
        this.processLeftBorder(rect, lineCanvas);
    }

    private BorderInfo getBorderInfo(BORDER border, Cell cell) {
        CellStyle cellStyle;
        if (cell != null && (cellStyle = cell.getCellStyle()) != null) {
            short type = border.getType(cellStyle);
            if (border == BORDER.BACKGROUND && 0 != type) {
                return new BorderInfo(type, border.getColor(cellStyle));
            }
            if (0 != type) {
                return new BorderInfo(type, border.getColor(cellStyle));
            }
        }
        return null;
    }

    private void processBottomBorder(Rectangle rect, PdfContentByte lineCanvas) {
        BorderInfo info = this.getBorderInfo(BORDER.BOTTOM, this.poiCell);
        if (info != null) {
            this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.BOTTOM);
            return;
        }
        Cell nextCell = Utils.getCell((Worksheet)this.sheet, (int)(this.rowIndex + 1), (int)this.columnIndex);
        info = this.getBorderInfo(BORDER.TOP, nextCell);
        if (info != null) {
            this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.BOTTOM);
            return;
        }
        info = this.getBorderInfo(BORDER.BACKGROUND, nextCell);
        if (info != null) {
            this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.BOTTOM);
            return;
        }
    }

    private void processRightBorder(Rectangle rect, PdfContentByte lineCanvas) {
        BorderInfo info = this.getBorderInfo(BORDER.RIGHT, this.poiCell);
        if (info != null) {
            this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.RIGHT);
            return;
        }
        Cell rightCell = Utils.getCell((Worksheet)this.sheet, (int)this.rowIndex, (int)(this.columnIndex + 1));
        info = this.getBorderInfo(BORDER.LEFT, rightCell);
        if (info != null) {
            this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.RIGHT);
            return;
        }
        info = this.getBorderInfo(BORDER.BACKGROUND, rightCell);
        if (info != null) {
            this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.RIGHT);
            return;
        }
    }

    private void processTopBorder(Rectangle rect, PdfContentByte lineCanvas) {
        if (this.isTopBound) {
            BorderInfo info;
            if (this.rowIndex - 1 >= 0 && (info = this.getBorderInfo(BORDER.BOTTOM, Utils.getCell((Worksheet)this.sheet, (int)(this.rowIndex - 1), (int)this.columnIndex))) != null) {
                this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.TOP);
                return;
            }
            info = this.getBorderInfo(BORDER.TOP, this.poiCell);
            if (info != null) {
                this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.TOP);
                return;
            }
            info = this.getBorderInfo(BORDER.BACKGROUND, this.poiCell);
            if (info != null) {
                this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.TOP);
                return;
            }
        }
    }

    private void processLeftBorder(Rectangle rect, PdfContentByte lineCanvas) {
        if (this.isLeftBound) {
            BorderInfo info;
            if (this.columnIndex - 1 >= 0 && (info = this.getBorderInfo(BORDER.RIGHT, Utils.getCell((Worksheet)this.sheet, (int)this.rowIndex, (int)(this.columnIndex - 1)))) != null) {
                this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.LEFT);
                return;
            }
            info = this.getBorderInfo(BORDER.LEFT, this.poiCell);
            if (info != null) {
                this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.LEFT);
                return;
            }
            info = this.getBorderInfo(BORDER.BACKGROUND, this.poiCell);
            if (info != null) {
                this.drawBorder(rect, lineCanvas, info.style, info.htmlColor, BORDER.LEFT);
                return;
            }
        }
    }

    private void drawBorder(Rectangle rect, PdfContentByte lineCanvas, BorderStyle borderStyle, String sBorderColor, BORDER border) {
        if (borderStyle == null) {
            if (this.isPrintGridLines() && border != BORDER.TOP && border != BORDER.LEFT) {
                lineCanvas.saveState();
                lineCanvas.setLineWidth(0.4f);
                lineCanvas.setLineCap(0);
                lineCanvas.setLineDash(new float[0], 0.0f);
                lineCanvas.setColorStroke(BaseColor.BLACK);
                this.setBorderEndPoints(rect, lineCanvas, border);
                lineCanvas.stroke();
                lineCanvas.restoreState();
            }
        } else {
            lineCanvas.saveState();
            BorderStyle blankBorder = StyleConversionUtil.getBorderStyle((short)5);
            blankBorder.setLineWidth(borderStyle.getLineWidth());
            lineCanvas.setLineWidth(blankBorder.getLineWidth());
            lineCanvas.setLineCap(blankBorder.getLineCapStyle());
            lineCanvas.setLineDash(blankBorder.getUnits(), blankBorder.getPhase());
            lineCanvas.setColorStroke(BaseColor.WHITE);
            this.setBorderEndPoints(rect, lineCanvas, border);
            lineCanvas.stroke();
            lineCanvas.restoreState();
            lineCanvas.saveState();
            lineCanvas.setLineWidth(borderStyle.getLineWidth());
            lineCanvas.setLineCap(borderStyle.getLineCapStyle());
            lineCanvas.setLineDash(borderStyle.getUnits(), borderStyle.getPhase());
            BaseColor borderColor = WebColors.getRGBColor((String)(sBorderColor == null || "AUTO_COLOR".equals(sBorderColor) ? "WHITE" : sBorderColor));
            lineCanvas.setColorStroke(BaseColor.BLACK);
            if (borderColor != null && borderColor != BaseColor.WHITE) {
                lineCanvas.setColorStroke(borderColor);
            }
            this.setBorderEndPoints(rect, lineCanvas, border);
            lineCanvas.stroke();
            lineCanvas.restoreState();
        }
    }

    private void setBorderEndPoints(Rectangle rect, PdfContentByte lineCanvas, BORDER border) {
        switch (border) {
            case BOTTOM: {
                lineCanvas.moveTo(rect.getLeft(), rect.getBottom());
                lineCanvas.lineTo(rect.getRight(), rect.getBottom());
                break;
            }
            case RIGHT: {
                lineCanvas.moveTo(rect.getRight(), rect.getBottom());
                lineCanvas.lineTo(rect.getRight(), rect.getTop());
                break;
            }
            case TOP: {
                lineCanvas.moveTo(rect.getLeft(), rect.getTop());
                lineCanvas.lineTo(rect.getRight(), rect.getTop());
                break;
            }
            case LEFT: {
                lineCanvas.moveTo(rect.getLeft(), rect.getBottom());
                lineCanvas.lineTo(rect.getLeft(), rect.getTop());
            }
        }
    }

    private void setStyle(CellStyle style) {
        this.style = style;
    }

    private CellStyle getStyle() {
        return this.style;
    }

    private void setPrintGridLines(boolean printGridLines) {
        this.printGridLines = printGridLines;
    }

    private boolean isPrintGridLines() {
        return this.printGridLines;
    }

    private class BorderInfo {
        final BorderStyle style;
        final String htmlColor;

        BorderInfo(short borderType, Color borderColor) {
            this.style = StyleConversionUtil.getBorderStyle(borderType);
            this.htmlColor = BookHelper.colorToHTML((Workbook)BorderDrawEvent.this.wb, (Color)borderColor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BORDER {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT,
        BACKGROUND;


        short getType(CellStyle cellStyle) {
            switch (this) {
                case TOP: {
                    return cellStyle.getBorderTop();
                }
                case RIGHT: {
                    return cellStyle.getBorderRight();
                }
                case BOTTOM: {
                    return cellStyle.getBorderBottom();
                }
                case LEFT: {
                    return cellStyle.getBorderLeft();
                }
                case BACKGROUND: {
                    return cellStyle.getFillPattern();
                }
            }
            throw new RuntimeException();
        }

        Color getColor(CellStyle cellStyle) {
            switch (this) {
                case TOP: {
                    return cellStyle.getTopBorderColorColor();
                }
                case RIGHT: {
                    return cellStyle.getRightBorderColorColor();
                }
                case BOTTOM: {
                    return cellStyle.getBottomBorderColorColor();
                }
                case LEFT: {
                    return cellStyle.getLeftBorderColorColor();
                }
                case BACKGROUND: {
                    return cellStyle.getFillForegroundColorColor();
                }
            }
            throw new RuntimeException();
        }
    }
}

