/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.jsf.ui.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesUtil {
    public static FacesContext getContext() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            throw new RuntimeException("faces context not found");
        }
        return context;
    }

    public static boolean isAjaxRequest() {
        FacesContext context = FacesUtil.getContext();
        return context.getPartialViewContext().isAjaxRequest();
    }

    public static UIComponent searchComponent(String id) {
        return FacesUtil.searchComponent(null, id);
    }

    public static UIComponent searchComponent(UIComponent base, final String id) {
        FacesContext context = FacesContext.getCurrentInstance();
        char sepChar = UINamingContainer.getSeparatorChar((FacesContext)context);
        String SEPARATOR_STRING = String.valueOf(sepChar);
        if (id.startsWith(SEPARATOR_STRING)) {
            if (base == null) {
                base = (UIComponent)context.getViewRoot().getChildren().get(0);
            }
            return base.findComponent(id);
        }
        UIComponent nc = base;
        UIComponent targetComp = null;
        while (nc != null) {
            targetComp = nc.findComponent(id);
            if (targetComp != null) {
                return targetComp;
            }
            if ((nc = nc.getParent()) instanceof NamingContainer) continue;
            nc = nc.getNamingContainer();
        }
        UIViewRoot root = context.getViewRoot();
        targetComp = root.findComponent(id);
        if (targetComp != null) {
            return targetComp;
        }
        final UIComponent[] found = new UIComponent[1];
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context);
        root.visitTree(visitContext, new VisitCallback(){

            public VisitResult visit(VisitContext context, UIComponent component) {
                if (component.getId().equals(id)) {
                    found[0] = component;
                    return VisitResult.COMPLETE;
                }
                return VisitResult.ACCEPT;
            }
        });
        return found[0];
    }

    public static String toScriptString(String script) {
        StringBuilder sb = new StringBuilder();
        sb.append("<script type=\"text/javascript\">");
        sb.append(script);
        sb.append("</script>");
        return sb.toString();
    }

    private static String getUpdateKey() {
        return "$zssjsf.update";
    }

    public static void addUpdateScript(String clientId, String script) {
        String key;
        FacesContext context = FacesContext.getCurrentInstance();
        Map reqm = context.getExternalContext().getRequestMap();
        ArrayList<UpdateScript> us = (ArrayList<UpdateScript>)reqm.get(key = FacesUtil.getUpdateKey());
        if (us == null) {
            us = new ArrayList<UpdateScript>(3);
            reqm.put(key, us);
        }
        us.add(new UpdateScript(clientId, script));
    }

    public static void clearUpdateScript(String clientId) {
        String key;
        FacesContext context = FacesContext.getCurrentInstance();
        Map reqm = context.getExternalContext().getRequestMap();
        List us = (List)reqm.get(key = FacesUtil.getUpdateKey());
        if (us == null) {
            return;
        }
        for (int i = us.size() - 1; i >= 0; --i) {
            if (!((UpdateScript)us.get((int)i)).clientId.equals(clientId)) continue;
            us.remove(i);
        }
    }

    public static void clearUpdateScript() {
        FacesContext context = FacesContext.getCurrentInstance();
        Map reqm = context.getExternalContext().getRequestMap();
        String key = FacesUtil.getUpdateKey();
        reqm.remove(key);
    }

    public static List<String> getUpdateScript() {
        FacesContext context = FacesContext.getCurrentInstance();
        Map reqm = context.getExternalContext().getRequestMap();
        String key = FacesUtil.getUpdateKey();
        List us = (List)reqm.get(key);
        ArrayList<String> scripts = new ArrayList<String>();
        if (us == null) {
            return scripts;
        }
        for (UpdateScript s : us) {
            scripts.add(s.script);
        }
        return scripts;
    }

    static class UpdateScript {
        final String clientId;
        final String script;

        public UpdateScript(String clientId, String script) {
            this.clientId = clientId;
            this.script = script;
        }
    }
}

