/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.jsf.ui.impl;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponentBase;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.io.NullWriter;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Strings;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.GenericRichlet;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.AfterCompose;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zk.ui.metainfo.Property;
import org.zkoss.zk.ui.metainfo.PropertyNotFoundException;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zkplus.embed.Bridge;
import org.zkoss.zkplus.embed.Renders;
import org.zkoss.zss.jsf.ui.impl.ActionBridgeImpl;
import org.zkoss.zss.jsf.ui.impl.FacesUtil;
import org.zkoss.zssex.ui.UpdateBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSFComponentBase
extends UIComponentBase {
    private static final Log log = Log.lookup(JSFComponentBase.class);
    private transient WeakReference<Component> component;
    private String desktopId;
    private String compUuid;
    private LinkedHashMap<String, PROP_TYPE> stateProps = new LinkedHashMap();
    AttrMap attrsMap = new AttrMap();

    public void setValueExpression(String name, ValueExpression binding) {
        super.setValueExpression(name, binding);
        if (name.indexOf(".") == -1) {
            this.stateProps.put(name, PROP_TYPE.VALUE_EXPRESSION);
        }
    }

    public Map<String, Object> getAttributes() {
        return this.attrsMap;
    }

    protected abstract Component newZKComponent();

    public Component getZKComponent() {
        Component comp;
        Component component = comp = this.component != null ? (Component)this.component.get() : null;
        if (comp != null) {
            return comp;
        }
        if (this.desktopId == null || this.compUuid == null) {
            return null;
        }
        Desktop dt = this.getZKDesktop();
        comp = dt.getComponentByUuid(this.compUuid);
        this.component = new WeakReference<Component>(comp);
        return (Component)this.component.get();
    }

    public Desktop getZKDesktop() {
        if (this.desktopId == null) {
            return null;
        }
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx == null) {
            return null;
        }
        ExternalContext extCtx = ctx.getExternalContext();
        Object servletCtx = extCtx.getContext();
        if (!(servletCtx instanceof ServletContext)) {
            return null;
        }
        Object request = extCtx.getRequest();
        Desktop dt = UpdateBridge.findDesktop((ServletContext)((ServletContext)servletCtx), (HttpServletRequest)((HttpServletRequest)request), (String)this.desktopId);
        return dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeBegin(final FacesContext context) throws IOException {
        String renderResult;
        ServletContext svlctx = (ServletContext)context.getExternalContext().getContext();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        String id = this.getClientId(context);
        ResponseWriter responseWriter = context.getResponseWriter();
        NullWriter nullwriter = new NullWriter();
        boolean isAjax = FacesUtil.isAjaxRequest();
        final Component oldcomp = this.getZKComponent();
        String cleanUpResult = null;
        boolean desktopCleanup = false;
        if (oldcomp != null) {
            Desktop desktop = this.getZKDesktop();
            Bridge zbridge = Bridge.start((ServletContext)svlctx, (HttpServletRequest)request, (HttpServletResponse)response, (Desktop)desktop);
            try {
                this.releaseResource(oldcomp);
                oldcomp.detach();
                if (isAjax) {
                    cleanUpResult = zbridge.getResult();
                }
            }
            catch (Exception e) {
                log.warning(e.getMessage(), (Throwable)e);
            }
            finally {
                zbridge.close();
            }
        }
        if (cleanUpResult != null) {
            responseWriter.append((CharSequence)FacesUtil.toScriptString(cleanUpResult));
        }
        if (isAjax) {
            try {
                Renders.render((ServletContext)svlctx, (HttpServletRequest)request, (HttpServletResponse)response, (Richlet)new GenericRichlet(){

                    public void service(Page page) throws Exception {
                        Desktop dt = page.getDesktop();
                        ((DesktopCtrl)dt).removePage(page);
                    }
                }, null, (Writer)nullwriter);
            }
            catch (ServletException e) {
                throw new IOException(e.getMessage());
            }
            desktopCleanup = true;
        }
        try {
            this.desktopId = null;
            this.component = null;
            StringWriter writer = new StringWriter();
            Renders.render((ServletContext)svlctx, (HttpServletRequest)request, (HttpServletResponse)response, (Richlet)new GenericRichlet(){

                public void service(Page page) throws Exception {
                    JSFComponentBase.this.desktopId = page.getDesktop().getId();
                    Component comp = oldcomp == null ? JSFComponentBase.this.newZKComponent() : oldcomp;
                    comp.setPage(page);
                    JSFComponentBase.this.component = new WeakReference<Component>(comp);
                    JSFComponentBase.this.compUuid = comp.getUuid();
                    String id = JSFComponentBase.this.getId();
                    if (id != null) {
                        comp.setId(id);
                    }
                    JSFComponentBase.this.applyProperties(context, comp);
                    JSFComponentBase.this.doAfterCompose(comp);
                }
            }, null, (Writer)writer);
            if (desktopCleanup) {
                writer.write(FacesUtil.toScriptString("zk.Desktop.sync(500);"));
            }
            renderResult = writer.toString();
        }
        catch (ServletException e) {
            throw new IOException(e.getMessage());
        }
        if (renderResult != null) {
            responseWriter.write(renderResult);
        }
        FacesUtil.clearUpdateScript(id);
    }

    protected void releaseResource(Component comp) {
    }

    protected Object getStateProperty(String name) {
        PROP_TYPE pt = this.stateProps.get(name);
        if (pt == PROP_TYPE.ATTR) {
            return this.getAttributes().get(name);
        }
        if (pt == PROP_TYPE.VALUE_EXPRESSION) {
            return this.getStateHelper().eval((Serializable)((Object)name));
        }
        return null;
    }

    protected void applyProperties(FacesContext context, Component component) {
        for (Map.Entry<String, PROP_TYPE> e : this.stateProps.entrySet()) {
            String nm = e.getKey();
            if ("apply".equals(nm)) continue;
            Object value = this.getStateProperty(nm);
            try {
                this.applyProperty(component, nm, value);
            }
            catch (PropertyNotFoundException pnfe) {
                log.debug(pnfe.getMessage());
            }
        }
    }

    protected void applyProperty(Component comp, String nm, Object value) {
        JSFComponentBase.assignProperty(comp, nm, value);
    }

    protected static void assignProperty(Component comp, String name, Object value) {
        Method mtd = Property.resolveMethod(comp.getClass(), (String)name);
        if (mtd != null) {
            try {
                Object val = Classes.coerce(mtd.getParameterTypes()[0], (Object)value);
                mtd.invoke((Object)comp, val);
            }
            catch (Exception ex) {
                log.error("Failed to assign " + value + " to " + comp + "\n" + Exceptions.getMessage((Throwable)ex));
                throw UiException.Aide.wrap((Throwable)ex);
            }
        } else {
            ((DynamicPropertied)comp).setDynamicProperty(name, value);
        }
    }

    protected void doAfterCompose(Component component) throws Exception {
        if (component instanceof AfterCompose) {
            ((AfterCompose)component).afterCompose();
        }
        if (!this.stateProps.containsKey("apply")) {
            return;
        }
        Object o = this.getStateProperty("apply");
        if (o instanceof String) {
            o = Classes.newInstanceByThread((String)o.toString());
        }
        if (!(o instanceof Composer)) {
            throw new IllegalStateException("apply is not a composer is " + o);
        }
        ((Composer)o).doAfterCompose(component);
    }

    public String getFamily() {
        return "zk";
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        try {
            ELContext ctx;
            ValueExpression ve = this.getValueExpression("actionBridge");
            if (ve != null && !ve.isReadOnly(ctx = context.getELContext())) {
                ve.setValue(context.getELContext(), (Object)new ActionBridgeImpl(this.getClientId(context), this.getZKComponent().getUuid()));
            }
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.desktopId = (String)values[1];
        this.compUuid = (String)values[2];
        this.stateProps = (LinkedHashMap)values[3];
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.desktopId, this.compUuid, this.stateProps};
        return state;
    }

    protected static String appendStyle(String style, String attr, String value) {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isEmpty((String)style)) {
            sb.append(style).append(";");
        }
        sb.append(attr).append(":").append(value);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AttrMap
    extends AbstractMap<String, Object> {
        AttrMap() {
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return JSFComponentBase.super.getAttributes().entrySet();
        }

        @Override
        public Object put(String key, Object value) {
            if (key.indexOf(".") == -1) {
                JSFComponentBase.this.stateProps.put(key, PROP_TYPE.ATTR);
            }
            return JSFComponentBase.super.getAttributes().put(key, value);
        }

        @Override
        public void clear() {
            for (String nm : this.keySet()) {
                JSFComponentBase.this.stateProps.remove(nm);
            }
            JSFComponentBase.super.getAttributes().clear();
        }

        @Override
        public Object remove(Object key) {
            JSFComponentBase.this.stateProps.remove(key.toString());
            return JSFComponentBase.super.getAttributes().remove(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PROP_TYPE {
        ATTR,
        VALUE_EXPRESSION;

    }
}

