/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.jsf.ui;

import java.io.IOException;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.FacesComponent;
import javax.faces.component.StateHelper;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.zkoss.lang.Strings;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zss.api.model.Book;
import org.zkoss.zss.jsf.ui.impl.JSFComponentBase;
import org.zkoss.zss.ui.Spreadsheet;

@FacesComponent(value="org.zkoss.zss.Spreadsheet")
public class JSFSpreadsheet
extends JSFComponentBase {
    private static final Log log = Log.lookup(JSFSpreadsheet.class);

    public Spreadsheet getSpreadsheet() {
        return (Spreadsheet)this.getZKComponent();
    }

    protected Component newZKComponent() {
        return new Spreadsheet();
    }

    public void encodeBegin(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = this.getClientId(context);
        writer.startElement("div", (UIComponent)this);
        writer.writeAttribute("id", (Object)id, "id");
        StateHelper sh = this.getStateHelper();
        String sclass = (String)this.getStateProperty("sclass");
        String style = (String)this.getStateProperty("style");
        String width = (String)this.getStateProperty("width");
        String height = (String)this.getStateProperty("height");
        if (!Strings.isEmpty((String)sclass)) {
            writer.writeAttribute("class", (Object)("zssjsf " + sclass), null);
        } else {
            writer.writeAttribute("class", (Object)"zssjsf", null);
        }
        if (!Strings.isEmpty((String)width)) {
            style = JSFSpreadsheet.appendStyle(style, "width", width);
        }
        if (!Strings.isEmpty((String)height)) {
            style = JSFSpreadsheet.appendStyle(style, "height", height);
        }
        if (!Strings.isEmpty((String)style)) {
            writer.writeAttribute("style", (Object)style, null);
        }
        super.encodeBegin(context);
        String zssid = this.getZKComponent().getUuid();
        writer.append((CharSequence)"<script type=\"text/javascript\">zk.afterLoad(function(){");
        writer.append((CharSequence)("zssjsf.fixSize('" + zssid + "');"));
        writer.append((CharSequence)("zssjsf.fixTomcatTrunkIssue('" + zssid + "');"));
        writer.append((CharSequence)"});</script>");
        writer.endElement("div");
    }

    protected void releaseResource(Component compToBeDrop) {
        ((Spreadsheet)compToBeDrop).setBook(null);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        try {
            this.updateBook(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    protected void updateBook(FacesContext context) {
        Spreadsheet ss;
        ELContext ctx;
        if (context == null) {
            throw new NullPointerException();
        }
        ValueExpression ve = this.getValueExpression("book");
        if (ve != null && !ve.isReadOnly(ctx = context.getELContext())) {
            ss = this.getSpreadsheet();
            Book book = ss.getBook();
            ve.setValue(context.getELContext(), (Object)book);
        }
        if ((ve = this.getValueExpression("selectedSheetName")) != null && !ve.isReadOnly(ctx = context.getELContext())) {
            ss = this.getSpreadsheet();
            String nm = ss.getSelectedSheetName();
            ve.setValue(context.getELContext(), (Object)nm);
        }
    }
}

