/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.html;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SPicture;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.impl.html.ToHtml;
import org.zkoss.zss.range.SExporter;
import org.zkoss.zul.Chart;

public class HtmlExporter
implements SExporter,
Serializable {
    private SBook wb;
    private int[] colBreaks;
    private int[] rowBreaks;
    private int firstColumn;
    private int endColumn;
    private int endRow;
    private int pageCount = 1;
    private int pageNumber;
    private boolean printGridLines;
    private boolean printHeadings;
    private float headerFooterTotalWidth;
    private float leftMargin;
    private float rightMargin;
    private float topMargin;
    private float bottomMargin;
    private float headerMargin;
    private float footerMargin;
    private Map<Integer, Map<String, int[]>> sheetsWithRepeatingRowsAndColumns = new HashMap<Integer, Map<String, int[]>>();
    private float totalAvailablePageWidth;
    private float totalAvailablePageHeight;
    private float[] columnLeft;
    private float[] rowTop;
    private Map<String, Integer> lastPageRowColumnBounds;
    private int currentSheetIndex = 0;
    List<SPicture> pictures;
    private int _outcol1;
    private int _outcol2;
    private int _outrow1;
    private int _outrow2;
    private Chart _chart;
    private String _refSheetName;

    public void export(SBook workbook, OutputStream outputStream) throws IOException {
        ToHtml.export(workbook, outputStream, !this.printHeadings);
    }

    public void export(SSheet worksheet, OutputStream outputStream) throws IOException {
        ToHtml.export(worksheet, outputStream, !this.printHeadings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(SBook book, File file) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            this.export(book, (OutputStream)os);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
    }

    public void export(SheetRegion sheetRegion, OutputStream outputStream) throws IOException {
        ToHtml.export(sheetRegion.getSheet(), sheetRegion.getRegion(), outputStream, !this.printHeadings);
    }

    public void enableHeadings(boolean enable) {
        this.printHeadings = enable;
    }
}

