/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.html;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.zkoss.poi.hssf.usermodel.HSSFWorkbook;
import org.zkoss.poi.openxml4j.exceptions.InvalidFormatException;
import org.zkoss.poi.ss.format.CellFormat;
import org.zkoss.poi.ss.format.CellFormatResult;
import org.zkoss.poi.ss.usermodel.Cell;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.ClientAnchor;
import org.zkoss.poi.ss.usermodel.Font;
import org.zkoss.poi.ss.usermodel.Picture;
import org.zkoss.poi.ss.usermodel.Row;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.Workbook;
import org.zkoss.poi.ss.usermodel.WorkbookFactory;
import org.zkoss.poi.ss.usermodel.ZssChartX;
import org.zkoss.poi.ss.usermodel.ZssContext;
import org.zkoss.poi.ss.util.AreaReference;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;
import org.zkoss.zss.model.impl.html.Base64Coder;
import org.zkoss.zss.model.impl.html.ChartPainter;
import org.zkoss.zss.model.impl.html.HSSFHtmlHelper;
import org.zkoss.zss.model.impl.html.HtmlHelper;
import org.zkoss.zss.model.impl.html.LayoutUnitConversionHelper;
import org.zkoss.zss.model.impl.html.XSSFHtmlHelper;
import org.zkoss.zss.model.sys.XBook;
import org.zkoss.zss.model.sys.XSheet;
import org.zkoss.zss.model.sys.impl.DrawingManager;
import org.zkoss.zss.model.sys.impl.SheetCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToHtml {
    private final XBook wb;
    private final OutputStream output;
    private boolean completeHTML;
    private Formatter out;
    private int firstColumn;
    private int endColumn;
    private HtmlHelper helper;
    private boolean exportOneSheet = false;
    private String exportOneSheetName;
    private boolean exportSelectionArea = false;
    private AreaReference area;
    private boolean printHeader = true;
    private static final String DEFAULTS_CLASS = "excelDefaults";
    private static final String COL_HEAD_CLASS = "colHeader";
    private static final String ROW_HEAD_CLASS = "rowHeader";
    private static final Map<Short, String> ALIGN = ToHtml.mapFor((short)1, "left", (short)2, "center", (short)3, "right", (short)4, "left", (short)5, "left", (short)6, "center");
    private static final Map<Short, String> VERTICAL_ALIGN = ToHtml.mapFor((short)2, "bottom", (short)1, "middle", (short)0, "top");
    private static final Map<Short, String> BORDER = ToHtml.mapFor((short)9, "dashed 1pt", (short)11, "dashed 1pt", (short)3, "dashed 1pt", (short)4, "dotted 1pt", (short)6, "double 3pt", (short)7, "solid 1px", (short)2, "solid 2pt", (short)10, "dashed 2pt", (short)12, "dashed 2pt", (short)8, "dashed 2pt", (short)0, "none", (short)13, "dashed 2pt", (short)5, "solid 3pt", (short)1, "dashed 1pt");

    private static <K, V> Map<K, V> mapFor(Object ... mapping) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < mapping.length; i += 2) {
            map.put(mapping[i], mapping[i + 1]);
        }
        return map;
    }

    public static ToHtml create(XBook wb, OutputStream output) {
        ToHtml toHtml = new ToHtml(wb, output);
        return toHtml;
    }

    public static ToHtml create(XSheet ws, OutputStream output) {
        ToHtml toHtml = new ToHtml((XBook)ws.getWorkbook(), output);
        toHtml.exportOneSheet = true;
        toHtml.exportOneSheetName = ws.getSheetName();
        return toHtml;
    }

    private static ToHtml create(XSheet ws, AreaReference area, OutputStream output) {
        ToHtml toHtml = new ToHtml((XBook)ws.getWorkbook(), output);
        toHtml.exportOneSheet = true;
        toHtml.exportOneSheetName = ws.getSheetName();
        toHtml.exportSelectionArea = true;
        toHtml.area = area;
        return toHtml;
    }

    public static ToHtml create(String path, OutputStream output) throws IOException {
        return ToHtml.create(new FileInputStream(path), output);
    }

    public static ToHtml create(InputStream in, OutputStream output) throws IOException {
        try {
            Workbook wb = WorkbookFactory.create((InputStream)in);
            return ToHtml.create((XBook)wb, output);
        }
        catch (InvalidFormatException e) {
            throw new IllegalArgumentException("Cannot create workbook from stream", e);
        }
    }

    private ToHtml(XBook wb, OutputStream output) {
        if (wb == null) {
            throw new NullPointerException("wb");
        }
        if (output == null) {
            throw new NullPointerException("output");
        }
        this.wb = wb;
        this.output = output;
        this.setupColorMap();
    }

    private void setPrintHeader(boolean printHeader) {
        this.printHeader = printHeader;
    }

    private void setupColorMap() {
        if (this.wb instanceof HSSFWorkbook) {
            this.helper = new HSSFHtmlHelper((HSSFWorkbook)this.wb);
        } else if (this.wb instanceof XSSFWorkbook) {
            this.helper = new XSSFHtmlHelper((XSSFWorkbook)this.wb);
        } else {
            throw new IllegalArgumentException("unknown workbook type: " + this.wb.getClass().getSimpleName());
        }
    }

    public static void main(String[] args) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Formatter myOut = new Formatter(baos);
        myOut.format("    <td class=%s %s>%s</td>%n", "\u4e2d\u6587", "\u4e2d\u6587", "\u4e2d\u6587");
        myOut.close();
        System.out.println(">>>>" + baos.toString());
        String enc = System.getProperty("file.encoding");
        System.out.println(enc);
    }

    public static void export(Workbook wb, OutputStream outputStream, boolean noHeader) throws IOException {
        ToHtml toHtml = ToHtml.create((XBook)wb, outputStream);
        toHtml.setCompleteHTML(true);
        toHtml.setPrintHeader(!noHeader);
        toHtml.printPage();
    }

    public static void export(XSheet ws, OutputStream outputStream, boolean noHeader) throws IOException {
        ToHtml toHtml = ToHtml.create(ws, outputStream);
        toHtml.setCompleteHTML(true);
        toHtml.setPrintHeader(!noHeader);
        toHtml.printPage();
    }

    public static void export(XSheet ws, AreaReference area, OutputStream outputStream, boolean noHeader) throws IOException {
        ToHtml toHtml = ToHtml.create(ws, area, outputStream);
        toHtml.setCompleteHTML(true);
        toHtml.setPrintHeader(!noHeader);
        toHtml.printPage();
    }

    public static void export(Workbook wb, OutputStream outputStream) throws IOException {
        ToHtml.export(wb, outputStream, false);
    }

    public static void export(XSheet ws, OutputStream outputStream) throws IOException {
        ToHtml.export(ws, outputStream, false);
    }

    public static void export(XSheet ws, AreaReference area, OutputStream outputStream) throws IOException {
        ToHtml.export(ws, area, outputStream, false);
    }

    public void setCompleteHTML(boolean completeHTML) {
        this.completeHTML = completeHTML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printPage() throws IOException {
        try {
            this.ensureOut();
            if (this.completeHTML) {
                this.out.format("<?xml version=\"1.0\" ?>%n", new Object[0]);
                this.out.format("<html>%n", new Object[0]);
                this.out.format("<head>%n", new Object[0]);
                this.out.format("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />", new Object[0]);
                this.out.format("</head>%n", new Object[0]);
                this.out.format("<body>%n", new Object[0]);
            }
            this.print();
            if (this.completeHTML) {
                this.out.format("</body>%n", new Object[0]);
                this.out.format("</html>%n", new Object[0]);
            }
        }
        finally {
            if (this.out != null) {
                this.out.close();
            }
            if (this.output instanceof Closeable) {
                OutputStream closeable = this.output;
                closeable.close();
            }
        }
    }

    public void print() {
        this.printInlineStyle();
        this.printSheets();
    }

    private void printInlineStyle() {
        this.out.format("<style type=\"text/css\">%n", new Object[0]);
        this.printStyles();
        this.out.format("</style>%n", new Object[0]);
    }

    private void ensureOut() {
        if (this.out == null) {
            this.out = new Formatter(this.output);
        }
    }

    public void printStyles() {
        this.ensureOut();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("excelStyle.css")));
            while ((line = in.readLine()) != null) {
                this.out.format("%s%n", line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Reading standard css", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Reading standard css", e);
                }
            }
        }
        HashSet<Integer> seen = new HashSet<Integer>();
        if (this.exportOneSheet) {
            Sheet sheet = this.wb.getSheet(this.exportOneSheetName);
            Iterator rows = sheet.rowIterator();
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                for (Cell cell : row) {
                    CellStyle style = cell.getCellStyle();
                    Integer index = style.getIndex();
                    if (seen.contains(index)) continue;
                    this.printStyle(style);
                    seen.add(index);
                }
            }
        } else {
            for (int i = 0; i < this.wb.getNumberOfSheets(); ++i) {
                Sheet sheet = this.wb.getSheetAt(i);
                Iterator rows = sheet.rowIterator();
                while (rows.hasNext()) {
                    Row row = (Row)rows.next();
                    for (Cell cell : row) {
                        CellStyle style = cell.getCellStyle();
                        Integer index = style.getIndex();
                        if (seen.contains(index)) continue;
                        this.printStyle(style);
                        seen.add(index);
                    }
                }
            }
        }
    }

    private void printStyle(CellStyle style) {
        this.out.format(".%s .%s {%n", DEFAULTS_CLASS, this.styleName(style));
        this.styleContents(style);
        this.out.format("}%n", new Object[0]);
    }

    private void styleContents(CellStyle style) {
        this.styleOut("text-align", style.getAlignment(), ALIGN);
        this.styleOut("vertical-align", style.getVerticalAlignment(), VERTICAL_ALIGN);
        this.fontStyle(style);
        this.borderStyles(style);
        this.helper.colorStyles(style, this.out);
    }

    private void borderStyles(CellStyle style) {
        this.styleOut("border-left", style.getBorderLeft(), BORDER);
        this.styleOut("border-right", style.getBorderRight(), BORDER);
        this.styleOut("border-top", style.getBorderTop(), BORDER);
        this.styleOut("border-bottom", style.getBorderBottom(), BORDER);
    }

    private void fontStyle(CellStyle style) {
        int fontheight;
        Font font = this.wb.getFontAt(style.getFontIndex());
        if (font.getBoldweight() > 400) {
            this.out.format("  font-weight: bold;%n", new Object[0]);
        }
        if (font.getItalic()) {
            this.out.format("  font-style: italic;%n", new Object[0]);
        }
        if (font.getUnderline() == 1) {
            this.out.format("  text-decoration: underline;%n", new Object[0]);
        }
        if (font.getStrikeout()) {
            this.out.format("  text-decoration: line-through;%n", new Object[0]);
        }
        if (font.getFontName() != null) {
            this.out.format(" font-family:%s;%n", font.getFontName());
        }
        if ((fontheight = font.getFontHeightInPoints()) == 9) {
            fontheight = 10;
        }
        this.out.format("  font-size: %dpt;%n", fontheight);
    }

    private String styleName(CellStyle style) {
        if (style == null) {
            style = this.wb.getCellStyleAt((short)0);
        }
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, ZssContext.getCurrent().getLocale());
        fmt.format("style_%02x", style.getIndex());
        return fmt.toString();
    }

    private <K> void styleOut(String attr, K key, Map<K, String> mapping) {
        String value = mapping.get(key);
        if (value != null) {
            this.out.format("  %s: %s;%n", attr, value);
        }
    }

    private static int ultimateCellType(Cell c) {
        int type = c.getCellType();
        if (type == 2) {
            type = c.getCachedFormulaResultType();
        }
        return type;
    }

    private void printSheets() {
        this.ensureOut();
        if (this.exportOneSheet) {
            Sheet sheet = this.wb.getSheet(this.exportOneSheetName);
            this.printSheet(sheet);
        } else {
            int sheetsNumber = this.wb.getNumberOfSheets();
            for (int i = 0; i < sheetsNumber; ++i) {
                Sheet sheet = this.wb.getSheetAt(i);
                this.printSheet(sheet);
                this.out.format("<br/>", new Object[0]);
            }
        }
    }

    public void printSheet(Sheet sheet) {
        this.ensureOut();
        this.out.format("<div>%s%n<table class=%s>%n", sheet.getSheetName(), DEFAULTS_CLASS);
        this.printCols(sheet);
        this.printSheetContent(sheet);
        this.out.format("</table>%n</div>", new Object[0]);
    }

    private void printCols(Sheet sheet) {
        this.out.format("<col/>%n", new Object[0]);
        this.ensureColumnBounds(sheet);
        for (int i = this.firstColumn; i < this.endColumn; ++i) {
            this.out.format("<col/>%n", new Object[0]);
        }
    }

    private void ensureColumnBounds(Sheet sheet) {
        if (this.exportSelectionArea) {
            this.firstColumn = this.area.getFirstCell().getCol();
            this.endColumn = this.area.getLastCell().getCol() + 1;
        } else {
            Iterator iter = sheet.rowIterator();
            this.firstColumn = iter.hasNext() ? Integer.MAX_VALUE : 0;
            this.endColumn = 0;
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                short firstCell = row.getFirstCellNum();
                if (firstCell < 0) continue;
                this.firstColumn = Math.min(this.firstColumn, firstCell);
                this.endColumn = Math.max(this.endColumn, row.getLastCellNum());
            }
        }
    }

    private void printColumnHeads(Sheet sheet) {
        this.out.format("<thead>%n", new Object[0]);
        this.out.format("  <tr class=%s>%n", COL_HEAD_CLASS);
        this.out.format("    <th class=%s>&#x25CA;</th>%n", COL_HEAD_CLASS);
        StringBuilder colName = new StringBuilder();
        for (int i = this.firstColumn; i < this.endColumn; ++i) {
            colName.setLength(0);
            int cnum = i;
            boolean lastChar = true;
            do {
                if (lastChar) {
                    colName.insert(0, (char)(65 + cnum % 26));
                    lastChar = false;
                    continue;
                }
                colName.insert(0, (char)(65 + cnum % 26 - 1));
            } while ((cnum /= 26) > 0);
            int width = LayoutUnitConversionHelper.convertWidthToPixel(sheet.getColumnWidth(i));
            this.out.format("    <th class=%s width=%s>%s</th>%n", COL_HEAD_CLASS, width, colName);
        }
        this.out.format("  </tr>%n", new Object[0]);
        this.out.format("</thead>%n", new Object[0]);
    }

    private void printSheetContent(Sheet sheet) {
        this.printColumnHeads(sheet);
        List<Picture> pictures = this.getPictureData(sheet);
        List<ZssChartX> charts = this.getChartData(sheet);
        this.out.format("<tbody>%n", new Object[0]);
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            if (this.exportSelectionArea && (row.getRowNum() < this.area.getFirstCell().getRow() || row.getRowNum() > this.area.getLastCell().getRow())) continue;
            int rowHeight = LayoutUnitConversionHelper.convertHeightToPixel(row.getHeight());
            this.out.format("  <tr>%n", new Object[0]);
            this.out.format("    <td class=%s height=%s>%d</td>%n", ROW_HEAD_CLASS, rowHeight, row.getRowNum() + 1);
            Locale locale = ZssContext.getCurrent().getLocale();
            for (int i = this.firstColumn; i < this.endColumn; ++i) {
                Cell cell;
                String content = "&nbsp;";
                String attrs = "";
                CellStyle style = null;
                if (i >= row.getFirstCellNum() && i < row.getLastCellNum() && (cell = row.getCell(i)) != null) {
                    style = cell.getCellStyle();
                    attrs = this.tagStyle(cell, style);
                    CellFormat cf = CellFormat.getInstance((String)style.getDataFormatString(), (Locale)locale);
                    CellFormatResult result = cf.apply(cell);
                    content = result.text;
                    if (this.hasPictureStartInCell(pictures, cell)) {
                        content = this.genContentForPicture(pictures, cell);
                    }
                    if (this.hasChartStartInCell(charts, cell)) {
                        content = this.genContentForChart((XSheet)sheet, charts, cell);
                    }
                    if (content.equals("")) {
                        content = "&nbsp;";
                    }
                    if (cell.getHyperlink() != null) {
                        content = "<a href=\"hyperlinkurl\" style=\"color:blue;\">origin_content</a>".replace("hyperlinkurl", cell.getHyperlink().getAddress()).replace("origin_content", content);
                    }
                }
                this.out.format("    <td class=%s %s>%s</td>%n", this.styleName(style), attrs, content);
            }
            this.out.format("  </tr>%n", new Object[0]);
        }
        this.out.format("</tbody>%n", new Object[0]);
    }

    private String tagStyle(Cell cell, CellStyle style) {
        if (style.getAlignment() == 0) {
            switch (ToHtml.ultimateCellType(cell)) {
                case 1: {
                    return "style=\"text-align: left;\"";
                }
                case 4: 
                case 5: {
                    return "style=\"text-align: center;\"";
                }
            }
        }
        return "";
    }

    private List<ZssChartX> getChartData(Sheet sheet) {
        DrawingManager _dm = ((SheetCtrl)sheet).getDrawingManager();
        List charts = _dm.getChartXs();
        return charts;
    }

    private List<Picture> getPictureData(Sheet sheet) {
        DrawingManager _dm = ((SheetCtrl)sheet).getDrawingManager();
        List pictures = _dm.getPictures();
        return pictures;
    }

    private String genContentForChart(XSheet sheet, List<ZssChartX> charts, Cell cell) {
        String result = "<span style=\"position: absolute; z-index: 1; margin-left: 27px; margin-top: 15px; width: contentWidth; height: contentHeight;\"><img alt=\"Embedded Image\" width=\"contentWidth\" height=\"contentHeight\" src=\"data:image/png;base64,realcontent\"></span>";
        ZssChartX chart = this.getMappingChart(charts, cell);
        ClientAnchor anchor = chart.getPreferredSize();
        int width = LayoutUnitConversionHelper.getChartWidth(sheet, anchor);
        int height = LayoutUnitConversionHelper.getChartHeight(sheet, anchor);
        ChartPainter painter = new ChartPainter();
        byte[] data = painter.paint(sheet, chart);
        String encodedPic = String.valueOf(Base64Coder.encode(data));
        result = result.replaceAll("contentWidth", String.valueOf(width));
        result = result.replaceAll("contentHeight", String.valueOf(height));
        return result.replace("realcontent", encodedPic);
    }

    private String genContentForPicture(List<Picture> pictures, Cell cell) {
        String result = "<span style=\"position: absolute; z-index: 1; margin-left: 27px; margin-top: 15px; width: contentWidthpx; height: contentHeightpx;\"><img alt=\"Embedded Image\" width=\"contentWidth\" height=\"contentHeight\" src=\"data:image/png;base64,realcontent\"></span>";
        Picture picture = this.getMappingPicture(pictures, cell);
        ClientAnchor anchor = picture.getClientAnchor();
        int width = anchor.getDx2() - anchor.getDx2();
        int height = anchor.getDy2() - anchor.getDy1();
        byte[] data = picture.getPictureData().getData();
        String encodedPic = String.valueOf(Base64Coder.encode(data));
        result = result.replaceAll("contentWidth", String.valueOf(width));
        result = result.replaceAll("contentHeight", String.valueOf(height));
        return result.replace("realcontent", encodedPic);
    }

    private boolean hasChartStartInCell(List<ZssChartX> charts, Cell cell) {
        for (ZssChartX chart : charts) {
            ClientAnchor anchor = chart.getPreferredSize();
            if (anchor.getCol1() != cell.getColumnIndex() || anchor.getRow1() != cell.getRowIndex()) continue;
            return true;
        }
        return false;
    }

    private boolean hasPictureStartInCell(List<Picture> pictures, Cell cell) {
        for (Picture picture : pictures) {
            ClientAnchor anchor = picture.getClientAnchor();
            if (anchor.getCol1() != cell.getColumnIndex() || anchor.getRow1() != cell.getRowIndex()) continue;
            return true;
        }
        return false;
    }

    private ZssChartX getMappingChart(List<ZssChartX> charts, Cell cell) {
        for (ZssChartX chart : charts) {
            ClientAnchor anchor = chart.getPreferredSize();
            if (anchor.getCol1() != cell.getColumnIndex() || anchor.getRow1() != cell.getRowIndex()) continue;
            return chart;
        }
        return null;
    }

    private Picture getMappingPicture(List<Picture> pictures, Cell cell) {
        for (Picture picture : pictures) {
            ClientAnchor anchor = picture.getClientAnchor();
            if (anchor.getCol1() != cell.getColumnIndex() || anchor.getRow1() != cell.getRowIndex()) continue;
            return picture;
        }
        return null;
    }
}

