/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.html;

import java.util.Formatter;
import org.zkoss.poi.hssf.usermodel.HSSFCellStyle;
import org.zkoss.poi.hssf.usermodel.HSSFPalette;
import org.zkoss.poi.hssf.usermodel.HSSFWorkbook;
import org.zkoss.poi.hssf.util.HSSFColor;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.Color;
import org.zkoss.poi.ss.usermodel.Workbook;
import org.zkoss.zss.model.impl.html.HtmlHelper;
import org.zkoss.zss.model.sys.impl.BookHelper;

public class HSSFHtmlHelper
implements HtmlHelper {
    private final HSSFWorkbook wb;
    private final HSSFPalette colors;
    private static final HSSFColor HSSF_AUTO = new HSSFColor.AUTOMATIC();

    public HSSFHtmlHelper(HSSFWorkbook wb) {
        this.wb = wb;
        this.colors = wb.getCustomPalette();
    }

    public void colorStyles(CellStyle style, Formatter out) {
        HSSFCellStyle cs = (HSSFCellStyle)style;
        out.format("  /* fill pattern = %d */%n", cs.getFillPattern());
        if (cs.getFillPattern() != 0) {
            out.format("  background-color: %s;%n", BookHelper.colorToHTML((Workbook)this.wb, (Color)cs.getFillForegroundColorColor()));
        }
        this.styleColor(out, "color", cs.getFont((Workbook)this.wb).getColor());
        this.styleColor(out, "border-left-color", cs.getLeftBorderColor());
        this.styleColor(out, "border-right-color", cs.getRightBorderColor());
        this.styleColor(out, "border-top-color", cs.getTopBorderColor());
        this.styleColor(out, "border-bottom-color", cs.getBottomBorderColor());
    }

    private void styleColor(Formatter out, String attr, short index) {
        HSSFColor color = this.colors.getColor(index);
        if (index == HSSF_AUTO.getIndex() || color == null) {
            out.format("  /* %s: index = %d */%n", attr, index);
        } else {
            short[] rgb = color.getTriplet();
            out.format("  %s: #%02x%02x%02x; /* index = %d */%n", attr, rgb[0], rgb[1], rgb[2], index);
        }
    }
}

