/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zuti.zul;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zuti.zul.ForEach;

public class ForEachRenderer
implements Serializable {
    private static final long serialVersionUID = 20150127110000L;

    public void render(ForEach forEachComp, Component host, Template tm, List<?> list, boolean isUsingListModel) {
        int begin = forEachComp.getBegin();
        int end = forEachComp.getEnd();
        int step = forEachComp.getStep();
        this.render(forEachComp, host, tm, begin, end, step, list, isUsingListModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(ForEach forEachComp, Component host, Template tm, int begin, int end, int step, List<?> list, boolean isUsingListModel) {
        Component insertBefore = null;
        Object shadowInfo = ShadowElementsCtrl.getCurrentInfo();
        String forEachRenderedCompAttr = "$ForEachRenderedComponents$" + forEachComp.getUuid();
        try {
            ShadowElementsCtrl.setCurrentInfo((Object)((Object)forEachComp));
            LinkedList<Component[]> feCompList = (LinkedList<Component[]>)host.getAttribute(forEachRenderedCompAttr);
            insertBefore = feCompList != null && feCompList.size() > begin ? ((Component[])feCompList.get(begin))[0] : forEachComp.getNextInsertionComponentIfAny();
            int insertIndex = begin;
            ForEachIterator<Object> it = new ForEachIterator<Object>(begin, end, step, list);
            while (it.hasNext()) {
                VariableResolver variableResolver = this.initVariableResolver(forEachComp, it);
                Execution exec = Executions.getCurrent();
                exec.addVariableResolver(variableResolver);
                Component[] creates = null;
                forEachComp.setAttribute(forEachComp.getVar(), variableResolver.resolveVariable(forEachComp.getVar()));
                forEachComp.setAttribute(forEachComp.getVarStatus(), variableResolver.resolveVariable(forEachComp.getVarStatus()));
                creates = tm.create(host, insertBefore, variableResolver, null);
                forEachComp.removeAttribute(forEachComp.getVar());
                forEachComp.removeAttribute(forEachComp.getVarStatus());
                if (isUsingListModel) {
                    if (feCompList == null) {
                        feCompList = new LinkedList<Component[]>();
                    }
                    if (feCompList.size() > insertIndex) {
                        feCompList.add(insertIndex, creates);
                    } else {
                        feCompList.add(creates);
                    }
                    host.setAttribute(forEachRenderedCompAttr, feCompList);
                }
                for (Component comp : creates) {
                    comp.setAttribute(forEachComp.getVar(), variableResolver.resolveVariable(forEachComp.getVar()));
                    comp.setAttribute(forEachComp.getVarStatus(), variableResolver.resolveVariable(forEachComp.getVarStatus()));
                }
                insertIndex += step;
                exec.removeVariableResolver(variableResolver);
            }
        }
        finally {
            ShadowElementsCtrl.setCurrentInfo((Object)shadowInfo);
        }
    }

    public VariableResolver initVariableResolver(final ForEach forEachComp, final ForEachIterator<Object> it) {
        final Object item = it.next();
        final int index = it.getIndex();
        return new VariableResolver(){
            private ForEachStatus prev = null;
            private ForEachStatus current = null;

            public Object resolveVariable(String name) {
                if (forEachComp.getVar().equals(name)) {
                    return item;
                }
                if (forEachComp.getVarStatus().equals(name)) {
                    if (this.current != null) {
                        this.prev = this.current;
                    }
                    this.current = new ForEachStatus(){

                        public ForEachStatus getPrevious() {
                            return prev;
                        }

                        public Object getEach() {
                            return this.getCurrent();
                        }

                        public int getIndex() {
                            return index;
                        }

                        public Integer getBegin() {
                            return it.getBegin();
                        }

                        public Integer getEnd() {
                            return it.getEnd();
                        }

                        public Object getCurrent() {
                            return item;
                        }

                        public boolean isFirst() {
                            return this.getIndex() == this.getBegin().intValue();
                        }

                        public boolean isLast() {
                            return this.getIndex() == this.getEnd().intValue();
                        }

                        public Integer getStep() {
                            return forEachComp.getStep();
                        }

                        public int getCount() {
                            return this.getIndex() + 1;
                        }
                    };
                    return this.current;
                }
                return null;
            }
        };
    }

    private static class ForEachIterator<E> {
        private final int startIndex;
        private final int endIndex;
        private final int step;
        private int cursor;
        private ListIterator<Object> iter;

        ForEachIterator(int begin, int end, int step, List items) {
            this.startIndex = begin;
            this.endIndex = end;
            this.step = step;
            this.cursor = -1;
            if (items != null) {
                if (items.size() > this.startIndex) {
                    this.iter = items.listIterator(this.startIndex);
                } else {
                    this.cursor = this.endIndex;
                }
            }
        }

        int getBegin() {
            return this.startIndex;
        }

        int getEnd() {
            return this.endIndex;
        }

        boolean hasPrevious() {
            return this.cursor - this.step > this.startIndex;
        }

        Object previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Object item = null;
            if (this.iter != null) {
                int prevStep = this.step;
                while (prevStep-- > 0) {
                    item = this.iter.previous();
                }
                this.cursor -= this.step;
            } else {
                item = this.cursor;
                this.cursor -= this.step;
            }
            return item;
        }

        boolean hasNext() {
            return this.cursor == -1 || this.cursor + this.step <= this.endIndex;
        }

        int getIndex() {
            return this.cursor == -1 ? this.startIndex : this.cursor;
        }

        Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object item = null;
            if (this.iter != null) {
                int nextStep = this.step;
                if (this.cursor == -1) {
                    this.cursor = this.startIndex;
                    item = this.iter.next();
                } else {
                    while (nextStep-- > 0) {
                        item = this.iter.next();
                    }
                    this.cursor += this.step;
                }
            } else {
                this.cursor = this.cursor == -1 ? this.startIndex : (this.cursor += this.step);
                item = this.cursor;
            }
            return item;
        }
    }
}

