/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zuti.zul;

import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zuti.zul.ForEach;
import org.zkoss.zuti.zul.ForEachConverter;
import org.zkoss.zuti.zul.ForEachListModelDataEvent;
import org.zkoss.zuti.zul.ForEachRenderer;

public class ForEachListDataListener
implements ListDataListener,
Serializable {
    private static final long serialVersionUID = 20150116151900L;
    private final ForEach _forEachComp;
    private final Component _host;
    private final ForEachConverter _conv;
    private final Template _tm;

    public ForEachListDataListener(ForEach forEachComp, Component host) {
        Template tm;
        this._forEachComp = forEachComp;
        this._host = host;
        this._conv = this._forEachComp.getDataConverter();
        this._tm = tm = this._forEachComp.getTemplate("");
    }

    public void onChange(ListDataEvent event) {
        this.onListModelDataChange(new ForEachListModelDataEvent(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onListModelDataChange(ListDataEvent event) {
        if (this._host == null || this._host.getDesktop() == null) {
            return;
        }
        ListModel model = event.getModel();
        int type = event.getType();
        int index0 = event.getIndex0();
        int index1 = event.getIndex1();
        List feCompList = (List)this._host.getAttribute("$ForEachRenderedComponents$" + this._forEachComp.getUuid());
        int oldsz = feCompList == null ? 0 : feCompList.size();
        int newsz = model.getSize();
        Object shadowInfo = ShadowElementsCtrl.getCurrentInfo();
        try {
            ShadowElementsCtrl.setCurrentInfo((Object)((Object)this._forEachComp));
            if (type == 1) {
                int addedCount = index1 - index0 + 1;
                if (newsz - oldsz <= 0) {
                    throw new UiException("Adding causes a smaller list?");
                }
                if (oldsz + addedCount != newsz) {
                    index0 = oldsz;
                    index1 = newsz - 1;
                }
                this.renderModelData(this._host, model, index0, index1);
            } else if (type == 0) {
                if (index0 < 0) {
                    this.syncModel(this._host, model);
                } else {
                    for (int i = index0; i <= index1; ++i) {
                        for (Component oldComps : (Component[])feCompList.get(i)) {
                            if (oldComps instanceof ShadowElement) {
                                ((ShadowElement)oldComps).getDistributedChildren().clear();
                            }
                            oldComps.detach();
                        }
                        feCompList.remove(i);
                    }
                    this.renderModelData(this._host, model, index0, index1);
                }
            } else if (type == 2) {
                if (oldsz - newsz <= 0) {
                    throw new UiException("Removal causes a larger list?");
                }
                for (int i = index0; i <= index1; ++i) {
                    for (Component oldComps : (Component[])feCompList.get(index0)) {
                        if (oldComps instanceof ShadowElement) {
                            ((ShadowElement)oldComps).getDistributedChildren().clear();
                        }
                        oldComps.detach();
                    }
                    feCompList.remove(index0);
                }
            }
        }
        finally {
            ShadowElementsCtrl.setCurrentInfo((Object)shadowInfo);
        }
    }

    private void syncModel(Component host, ListModel<?> model) {
        String forEachRenderedCompAttr = "$ForEachRenderedComponents$" + this._forEachComp.getUuid();
        List feCompList = (List)host.getAttribute(forEachRenderedCompAttr);
        if (feCompList != null) {
            host.removeAttribute(forEachRenderedCompAttr);
            ListIterator l = this._forEachComp.getDistributedChildren().listIterator();
            while (l.hasNext()) {
                l.next();
                l.remove();
            }
        }
        this.renderModelData(host, model, 0, model.getSize() - 1);
    }

    private void renderModelData(Component host, ListModel<?> model, int from, int to) {
        List data;
        ForEachRenderer renderer = new ForEachRenderer();
        if (this._conv != null && (data = (List)this._conv.coerceToUi(model)) != null) {
            int size = data.size();
            if (to >= size) {
                to = size - 1;
            }
            renderer.render(this._forEachComp, this._host, this._tm, from, to, this._forEachComp.getStep(), data, true);
        }
    }
}

