/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zuti.zul;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.sys.IntPropertyAccess;
import org.zkoss.zk.ui.sys.ObjectPropertyAccess;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.sys.StringPropertyAccess;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelArray;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zuti.zul.ForEachConverter;
import org.zkoss.zuti.zul.ForEachListDataListener;
import org.zkoss.zuti.zul.ForEachRenderer;
import org.zkoss.zuti.zul.TemplateBasedShadowElement;

public class ForEach
extends TemplateBasedShadowElement {
    private static final long serialVersionUID = 2014102212473126L;
    private AuxInfo _auxinf = null;
    private ForEachConverter _conv = new ForEachConverter();
    protected ForEachListDataListener _dataListener;
    private static HashMap<String, PropertyAccess> _properties = new HashMap(6);

    public void setItems(Object items) {
        this._dirtyBinding = true;
        this.initAuxInfo().items = items;
    }

    public Object getItems() {
        return this._auxinf != null ? this._auxinf.items : null;
    }

    public void setBegin(int begin) {
        if (begin < 0) {
            throw new IllegalArgumentException("'begin' < 0 [" + begin + "]");
        }
        if (!Objects.equals((Object)(this._auxinf != null ? Integer.valueOf(this._auxinf.begin) : null), (Object)begin)) {
            this.initAuxInfo().begin = begin;
            this._dirtyBinding = true;
        }
    }

    public int getBegin() {
        return this._auxinf != null ? this._auxinf.begin : 0;
    }

    public void setEnd(int end) {
        if (end < 0) {
            throw new IllegalArgumentException("'end' < 0 [" + end + "]");
        }
        if (!Objects.equals((Object)(this._auxinf != null ? Integer.valueOf(this._auxinf.end) : null), (Object)end)) {
            this.initAuxInfo().end = end;
            this._dirtyBinding = true;
        }
    }

    public int getEnd() {
        if (this._auxinf != null && this._auxinf.end > -1) {
            return this._auxinf.end;
        }
        int size = this.getItemsSize();
        return size > 0 ? size - 1 : 0;
    }

    private int getItemsSize() {
        Object items = this.getItems();
        if (items instanceof Collection) {
            return ((Collection)items).size();
        }
        if (items instanceof Map) {
            return ((Map)items).size();
        }
        if (items instanceof ListModelArray) {
            return ((ListModelArray)items).getInnerArray().length;
        }
        if (items instanceof Object[]) {
            return ((Object[])items).length;
        }
        if (items instanceof Class && Enum.class.isAssignableFrom((Class)items)) {
            return ((Class)items).getEnumConstants().length;
        }
        return 0;
    }

    public void setStep(int step) {
        if (step <= 0) {
            throw new IllegalArgumentException("'step' <= 0 [" + step + "]");
        }
        if (!Objects.equals((Object)(this._auxinf != null ? Integer.valueOf(this._auxinf.step) : null), (Object)step)) {
            this.initAuxInfo().step = step;
            this._dirtyBinding = true;
        }
    }

    public int getStep() {
        return this._auxinf != null ? this._auxinf.step : 1;
    }

    public void setVar(String var) {
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.var : null), (Object)var)) {
            this.initAuxInfo().var = var;
            this._dirtyBinding = true;
        }
    }

    public String getVar() {
        return this._auxinf != null ? this._auxinf.var : "each";
    }

    public void setVarStatus(String varStatus) {
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.varStatus : null), (Object)varStatus)) {
            this.initAuxInfo().varStatus = varStatus;
            this._dirtyBinding = true;
        }
    }

    public String getVarStatus() {
        return this._auxinf != null ? this._auxinf.varStatus : "forEachStatus";
    }

    public ForEachConverter getDataConverter() {
        return this._conv;
    }

    private final AuxInfo initAuxInfo() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    @Override
    protected boolean isEffective() {
        if (this.getItems() != null) {
            return true;
        }
        if (this._auxinf == null) {
            return false;
        }
        return this._auxinf.begin <= this._auxinf.end;
    }

    private void initDataListener(ListModel model, Component host) {
        if (this._dataListener == null) {
            this._dataListener = new ForEachListDataListener(this, host);
        } else {
            model.removeListDataListener((ListDataListener)this._dataListener);
            this._dataListener = new ForEachListDataListener(this, host);
        }
        model.addListDataListener((ListDataListener)this._dataListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void compose(Component host) {
        if (this.getEnd() < this.getBegin()) {
            throw new IllegalArgumentException("End index must not be less than start index.");
        }
        Object items = this.getItems();
        Template tm = this.getTemplate("");
        Object value = this._conv.coerceToUi(items);
        if (tm != null) {
            boolean isUsingListModel;
            List list = null;
            if (value != null && value instanceof List) {
                list = (List)value;
            }
            if (isUsingListModel = items instanceof ListModel) {
                this.initDataListener((ListModel)items, host);
                String forEachRenderedCompAttr = "$ForEachRenderedComponents$" + this.getUuid();
                if (host.hasAttribute(forEachRenderedCompAttr)) {
                    Object shadowInfo = ShadowElementsCtrl.getCurrentInfo();
                    try {
                        ShadowElementsCtrl.setCurrentInfo((Object)((Object)this));
                        host.removeAttribute(forEachRenderedCompAttr);
                        ListIterator l = this.getDistributedChildren().listIterator();
                        while (l.hasNext()) {
                            l.next();
                            l.remove();
                        }
                    }
                    finally {
                        ShadowElementsCtrl.setCurrentInfo((Object)shadowInfo);
                    }
                }
            }
            ForEachRenderer renderer = new ForEachRenderer();
            renderer.render(this, host, tm, list, isUsingListModel);
        }
    }

    @Override
    public boolean isDynamicValue() {
        return this.getItems() instanceof ListModel || super.isDynamicValue();
    }

    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    public void removeFromParent() {
        Object items = this.getItems();
        if (items instanceof ListModel) {
            ((ListModel)items).removeListDataListener((ListDataListener)this._dataListener);
        }
        super.removeFromParent();
    }

    static {
        _properties.put("items", (PropertyAccess)new ObjectPropertyAccess(){

            public void setValue(Component cmp, Object value) {
                ((ForEach)cmp).setItems(value);
            }

            public Object getValue(Component cmp) {
                return ((ForEach)cmp).getItems();
            }
        });
        _properties.put("begin", (PropertyAccess)new IntPropertyAccess(){

            public void setValue(Component cmp, Integer value) {
                ((ForEach)cmp).setBegin(value);
            }

            public Integer getValue(Component cmp) {
                return ((ForEach)cmp).getBegin();
            }
        });
        _properties.put("end", (PropertyAccess)new IntPropertyAccess(){

            public void setValue(Component cmp, Integer value) {
                ((ForEach)cmp).setEnd(value);
            }

            public Integer getValue(Component cmp) {
                return ((ForEach)cmp).getEnd();
            }
        });
        _properties.put("step", (PropertyAccess)new IntPropertyAccess(){

            public void setValue(Component cmp, Integer value) {
                ((ForEach)cmp).setStep(value);
            }

            public Integer getValue(Component cmp) {
                return ((ForEach)cmp).getStep();
            }
        });
        _properties.put("var", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String value) {
                ((ForEach)cmp).setVar(value);
            }

            public String getValue(Component cmp) {
                return ((ForEach)cmp).getVar();
            }
        });
        _properties.put("varStatus", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String value) {
                ((ForEach)cmp).setVarStatus(value);
            }

            public String getValue(Component cmp) {
                return ((ForEach)cmp).getVarStatus();
            }
        });
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private Object items;
        private int begin = 0;
        private int end = -1;
        private int step = 1;
        private String var = "each";
        private String varStatus = "forEachStatus";

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

