/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zuti.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.zkoss.bind.BindUtils;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Strings;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zuti.zul.NavigationLevel;
import org.zkoss.zuti.zul.NavigationModel;
import org.zkoss.zuti.zul.NavigationNode;
import org.zkoss.zuti.zul.event.NavigationEvent;

class DefaultNavigationLevel<T>
implements NavigationLevel<T>,
Serializable {
    private static boolean HAS_ZKBIND = true;
    private final NavigationModel<T> _model;
    private final int _level;
    private NavigationNode<T> _node;
    private NavigationNode<T> _head;
    private Map<String, Object> _context;
    private volatile DefaultNavigationLevel<T> _childLevel;
    private boolean _hasNavigated = false;

    DefaultNavigationLevel(NavigationModel<T> model, int level) {
        this._model = model;
        this._level = level;
    }

    void setNavigated(boolean navigated) {
        if (this._hasNavigated != navigated) {
            this._hasNavigated = navigated;
            if (navigated) {
                this.notify(NavigationEvent.Type.NAVIGATE, this, "current");
            }
        }
    }

    NavigationNode<T> getNode() {
        return this._node;
    }

    void setNode(NavigationNode<T> node) {
        if (this._node != node) {
            this._node = node;
            if (this._node != null) {
                NavigationNode<T> child = this._node.getChild();
                if (this._childLevel != null && child != null) {
                    this._childLevel.setNode(child);
                    this._childLevel.setHead(child);
                    this._childLevel.setNavigated(false);
                }
            }
            if (this._hasNavigated) {
                this.notify(NavigationEvent.Type.NAVIGATE, this, "current");
            }
        }
    }

    private void notify(NavigationEvent.Type type, Object bean, String ... props) {
        if (Executions.getCurrent() == null) {
            return;
        }
        this._model.fireEvent(this, type, this._node);
        if (HAS_ZKBIND) {
            BindUtils.postNotifyChange(null, null, (Object)bean, (String[])props);
        }
    }

    NavigationNode<T> getHead() {
        if (this._head == null) {
            this._head = this._node;
        }
        if (this._head != null) {
            NavigationNode<T> head = this._head;
            do {
                if (head.getLeft() != null) continue;
                this._head = head;
                break;
            } while ((head = head.getLeft()) != null);
        }
        return this._head;
    }

    void setHead(NavigationNode<T> head) {
        this._head = head;
    }

    @Override
    public int getLevel() {
        return this._level;
    }

    @Override
    public Map<String, Object> getContext() {
        return this._context;
    }

    @Override
    public NavigationLevel<T> setContext(Map<String, Object> context) {
        if (this._context != context) {
            this._context = context;
            this.notify(NavigationEvent.Type.CHANGE_CONTEXT, this, "context");
        }
        return this;
    }

    @Override
    public String getCurrentKey() {
        if (this._hasNavigated) {
            return this._node != null ? this._node.getKey() : null;
        }
        return null;
    }

    @Override
    public T getCurrent() {
        if (this._hasNavigated) {
            return this._node != null ? (T)this._node.getValue() : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigationLevel<T> getChild() {
        if (this._node == null) {
            return null;
        }
        NavigationNode<T> child = this._node.getChild();
        if (child != null) {
            if (this._childLevel == null) {
                DefaultNavigationLevel defaultNavigationLevel = this;
                synchronized (defaultNavigationLevel) {
                    if (this._childLevel == null) {
                        this._childLevel = new DefaultNavigationLevel<T>(this._model, this._level + 1);
                        this._childLevel.setNode(child);
                        this._childLevel.setHead(child);
                    }
                }
            }
            return this._childLevel;
        }
        return null;
    }

    @Override
    public NavigationLevel<T> navigateTo(String key) {
        if (Strings.isEmpty((String)key)) {
            throw new IllegalArgumentException("key cannot be null or empty");
        }
        if (this._node == null) {
            throw new IllegalArgumentException("the level is empty");
        }
        NavigationNode<T> n = this._node;
        do {
            if (!key.equals(n.getKey())) continue;
            this.setNode(n);
            this.setNavigated(true);
            return this;
        } while ((n = n.getRight()) != null);
        n = this._node;
        while ((n = n.getLeft()) != null) {
            if (!key.equals(n.getKey())) continue;
            this.setNode(n);
            this.setNavigated(true);
            return this;
        }
        throw new IllegalArgumentException("Not found in the level: " + key);
    }

    @Override
    public Iterator<Pair<String, T>> getItemIterator() {
        return new Iterator<Pair<String, T>>(){
            private NavigationNode<T> n;
            {
                this.n = DefaultNavigationLevel.this.getHead();
            }

            @Override
            public boolean hasNext() {
                return this.n != null;
            }

            @Override
            public Pair<String, T> next() {
                if (this.hasNext()) {
                    Pair result = new Pair((Object)this.n.getKey(), this.n.getValue());
                    this.n = this.n.getRight();
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("readonly");
            }
        };
    }

    @Override
    public List<Pair<String, T>> getItems() {
        ArrayList<Pair<String, T>> result = new ArrayList<Pair<String, T>>();
        Iterator<Pair<String, T>> iter = this.getItemIterator();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultNavigationLevel{");
        sb.append("_level=").append(this._level);
        sb.append(", _node=").append(this._node);
        sb.append(", _context=").append(this._context);
        sb.append('}');
        return sb.toString();
    }

    static {
        try {
            Classes.forNameByThread((String)"org.zkoss.bind.BindUtils");
        }
        catch (ClassNotFoundException e) {
            HAS_ZKBIND = false;
        }
    }
}

