/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zuti.zul;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.BinderUtil;
import org.zkoss.bind.sys.ReferenceBinding;
import org.zkoss.lang.Objects;
import org.zkoss.util.Maps;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Templates;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zk.ui.metainfo.impl.ShadowDefinitionImpl;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zk.ui.sys.StringPropertyAccess;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zuti.zul.TemplateBasedShadowElement;

public class Apply
extends TemplateBasedShadowElement
implements DynamicPropertied {
    private static final long serialVersionUID = 2014102212493116L;
    private static final String REFERENCE_SET = "$REF_SET$";
    private String _template = "";
    private String _templateURI;
    protected Map<String, Object> _props;
    private static HashMap<String, PropertyAccess> _properties = new HashMap(2);

    public Apply() {
        this.init();
    }

    private void init() {
        this._props = new LinkedHashMap<String, Object>();
    }

    public String getTemplate() {
        return this._template;
    }

    public void setTemplate(String template) {
        if (template != null && template.length() > 0 && this._templateURI != null && this._templateURI.length() > 0) {
            throw new UiException("Can not set template and template uri in the same time. Set template uri as null or empty string first.");
        }
        if (!Objects.equals((Object)this._template, (Object)template)) {
            this._template = template;
            this._dirtyBinding = true;
        }
    }

    public void setTemplateURI(String templateURI) {
        if (templateURI != null && templateURI.length() > 0 && this._template != null && this._template.length() > 0) {
            throw new UiException("Can not set template and template uri in the same time. Set template as null or empty string first.");
        }
        if (!Objects.equals((Object)this._templateURI, (Object)templateURI)) {
            this._templateURI = templateURI;
            this._dirtyBinding = true;
        }
    }

    public String getTemplateURI() {
        return this._templateURI;
    }

    protected Template resolveTemplate() {
        if (this._templateURI != null && this._templateURI.length() > 0) {
            return null;
        }
        return this.lookupTemplate((Component)this, this, this.getTemplate(), null);
    }

    private Template lookupTemplate(Component comp, Apply base, String name, Component compBase) {
        return Templates.lookup((Component)comp, (Component)base, (String)name, (Component)compBase);
    }

    public Object resolveVariable(Component child, String name, boolean recurse) {
        Object result = this._props.get(name);
        if (result == null) {
            return super.resolveVariable(child, name, recurse);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void compose(Component host) {
        Set refs;
        String templateURI;
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("No execution available");
        }
        Template t = this.resolveTemplate();
        if (t != null) {
            exec.pushArg(this._props);
            try {
                t.create(host, this.getNextInsertionComponentIfAny(), null, null);
            }
            finally {
                exec.popArg();
            }
        }
        if ((templateURI = this._templateURI) == null) {
            templateURI = ((ShadowDefinitionImpl)this.getDefinition()).getTemplateURI();
        }
        if (templateURI != null) {
            String uri = templateURI;
            int queryStart = uri.indexOf(63);
            String queryString = null;
            if (queryStart >= 0) {
                queryString = uri.substring(queryStart + 1);
                uri = uri.substring(0, queryStart);
            }
            Map map = Maps.parse(null, (String)queryString, (char)'&', (char)'=', (boolean)false);
            HashMap<String, Object> arg = new HashMap<String, Object>();
            arg.putAll(this._props);
            arg.putAll(map);
            exec.createComponents(uri, host, this.getNextInsertionComponentIfAny(), null, arg);
        }
        if ((refs = (Set)this.getAttribute(REFERENCE_SET)) != null && !refs.isEmpty()) {
            Binder binder = BinderUtil.getBinder((Component)this);
            for (Component comp : this.getDistributedChildren()) {
                if (refs == null) continue;
                this.copyReferenceBinding(comp, refs, binder);
            }
        }
    }

    private void copyReferenceBinding(Component comp, Set<String> refs, Binder binder) {
        for (String key : refs) {
            this.addReferenceBinding(comp, key, (ReferenceBinding)this.getAttribute(key));
        }
    }

    private void addReferenceBinding(Component comp, String attr, ReferenceBinding binding) {
        comp.setAttribute(attr, (Object)binding);
        HashSet<String> refs = (HashSet<String>)comp.getAttribute(REFERENCE_SET, 0);
        if (refs == null) {
            refs = new HashSet<String>();
            comp.setAttribute(REFERENCE_SET, refs);
        }
        refs.add(attr);
    }

    @Override
    protected boolean isEffective() {
        Apply compCtrl = this;
        if (!compCtrl.getAnnotatedProperties().isEmpty() && !this.isBindingReady()) {
            return false;
        }
        boolean hasTemplate = !"".equals(this._template) || this.getTemplate("") != null;
        return hasTemplate || this._templateURI != null || ((ShadowDefinitionImpl)this.getDefinition()).getTemplateURI() != null;
    }

    public boolean hasDynamicProperty(String name) {
        return this._props.containsKey(name);
    }

    public Object getDynamicProperty(String name) {
        return this._props.get(name);
    }

    public Map<String, Object> getDynamicProperties() {
        return this._props;
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        this._dirtyBinding = true;
        this._props.put(name, value);
    }

    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    @Override
    public Object clone() {
        Apply clone = (Apply)((Object)super.clone());
        clone.init();
        clone._props.putAll(this._props);
        return clone;
    }

    static {
        _properties.put("template", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String value) {
                ((Apply)cmp).setTemplate(value);
            }

            public String getValue(Component cmp) {
                return ((Apply)cmp).getTemplate();
            }
        });
        _properties.put("templateURI", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String value) {
                ((Apply)cmp).setTemplateURI(value);
            }

            public String getValue(Component cmp) {
                return ((Apply)cmp).getTemplateURI();
            }
        });
    }
}

