/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.test.webdriver;

import java.time.Duration;
import java.util.Collections;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.Pause;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.zkoss.test.webdriver.DockerWebDriverTestCase;

public abstract class TouchWebDriverTestCase
extends DockerWebDriverTestCase {
    protected PointerInput FINGER = new PointerInput(PointerInput.Kind.MOUSE, "finger");

    @Override
    protected final ChromeOptions getWebDriverOptions() {
        return (ChromeOptions)super.getWebDriverOptions().setExperimentalOption("mobileEmulation", Collections.singletonMap("deviceName", System.getProperty("MobileEmulationDeviceName", "Nexus 7")));
    }

    public void swipe(Point start, Point end) {
        this.swipe(start, end, 0);
    }

    public void swipe(Point start, Point end, int duration) {
        Sequence swipe = new Sequence((InputSource)this.FINGER, 1).addAction(this.FINGER.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), start.getX(), start.getY())).addAction(this.FINGER.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction(this.FINGER.createPointerMove(Duration.ofMillis(duration), PointerInput.Origin.viewport(), end.getX(), end.getY())).addAction(this.FINGER.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        ((RemoteWebDriver)this.driver).perform(Collections.singleton(swipe));
    }

    public void swipe(WebElement start, WebElement end) {
        this.swipe(start, end);
    }

    public void swipe(WebElement start, WebElement end, int duration) {
        this.swipe(start.getLocation(), end.getLocation(), duration);
    }

    public void tap(Point point) {
        this.tap(point, 0);
    }

    public void tap(Point point, int duration) {
        Sequence tap = new Sequence((InputSource)this.FINGER, 1).addAction(this.FINGER.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), point.getX() + 1, point.getY() + 1)).addAction(this.FINGER.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction((Interaction)new Pause((InputSource)this.FINGER, Duration.ofMillis(duration))).addAction(this.FINGER.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        ((RemoteWebDriver)this.driver).perform(Collections.singleton(tap));
    }

    public void tap(WebElement start, int duration) {
        this.tap(start.getLocation(), duration);
    }

    public void tap(WebElement start) {
        this.tap(start.getLocation(), 0);
    }

    public void scrollTo(int startX, int startY, int endX, int endY) {
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger");
        Sequence scrollAction = new Sequence((InputSource)finger, 0);
        scrollAction.addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), startX, startY));
        scrollAction.addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
        scrollAction.addAction(finger.createPointerMove(Duration.ofMillis(500L), PointerInput.Origin.viewport(), endX, endY));
        scrollAction.addAction(finger.createPointerMove(Duration.ofMillis(500L), PointerInput.Origin.viewport(), endX, endY));
        scrollAction.addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        ((RemoteWebDriver)this.driver).perform(Collections.singleton(scrollAction));
    }

    public void scroll(WebElement target, int startY, int endY, int delta) {
        Rectangle rect = target.getRect();
        int length = Math.abs(startY - endY);
        int times = (int)Math.ceil(length / Math.max(1, rect.getHeight()));
        if (startY >= endY) {
            while (times-- > 0) {
                this.scrollTo(rect.getX() + delta, rect.getY() + delta, rect.getX() + delta, rect.getHeight() - delta);
            }
        } else {
            while (times-- > 0) {
                this.scrollTo(rect.getX() + delta, rect.getHeight() - delta, rect.getX() + delta, rect.getY() + delta);
            }
        }
    }

    public void scroll(WebElement target, int startY, int endY) {
        this.scroll(target, startY, endY, 20);
    }
}

